/*
 * Decompiled with CFR 0.152.
 */
package edu.umn.space.swaves.util.xml;

import edu.umn.space.swaves.GSEException.GSEException;
import edu.umn.space.swaves.util.xml.XmlTransform;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.net.URL;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.charset.Charset;
import java.util.StringTokenizer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class ConfigFileAccess {
    private String XMLFileName;
    private Document ConfigDOM = null;
    private Node topPropertyNode;
    public String delimiter = "#*";
    private String PathToGseDir;
    private String ErrPath = "Universe.edu.umn.space.swaves..util.xml.";
    private Charset AsciiCharset = Charset.forName("US-ASCII");
    String ExcepName;
    String ErrComment;

    public ConfigFileAccess(String inputXMLFileName) throws GSEException {
        if (this.ConfigDOM == null) {
            this.loadDomTree(inputXMLFileName);
        }
    }

    private void loadDomTree(String inputXMLFileName) throws GSEException {
        this.XMLFileName = inputXMLFileName;
        this.PathToGseDir = this.findGseTopDir();
        if (this.XMLFileName.equals("TMLibConfig")) {
            this.XMLFileName = this.PathToGseDir + "/config/Info.plist";
        }
        try {
            File xmlConfigFile = new File(this.XMLFileName);
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            factory.setValidating(false);
            DocumentBuilder builder = factory.newDocumentBuilder();
            this.ConfigDOM = builder.parse(xmlConfigFile.toURI().getPath());
            this.findTopPropertyNode(this.ConfigDOM);
        }
        catch (Exception e) {
            System.out.println("Error reading URI: " + e.getMessage());
        }
    }

    public String findGseTopDir() {
        URL url = this.getClass().getResource("ConfigFileAccess.class");
        String PathToThisJar = url.getPath();
        Pattern PathPattern = Pattern.compile("file:(.*)/build/lib/java(.*)");
        Matcher PathMatcher = PathPattern.matcher(PathToThisJar);
        PathMatcher.find();
        return PathMatcher.group(1);
    }

    private void findTopPropertyNode(Document DOMtreeStoresTable) {
        Node testNode = DOMtreeStoresTable;
        NodeList nodes = testNode.getChildNodes();
        int plistCount = 0;
        int secondPlistIndex = -1;
        while (plistCount < 2) {
            if (!(testNode = nodes.item(++secondPlistIndex)).getNodeName().equals("plist")) continue;
            ++plistCount;
        }
        Node secondPlistNode = nodes.item(secondPlistIndex);
        nodes = secondPlistNode.getChildNodes();
        int dictIndex = 0;
        testNode = nodes.item(0);
        while (!testNode.getNodeName().equals("dict")) {
            testNode = nodes.item(++dictIndex);
        }
        this.topPropertyNode = testNode;
    }

    public String getStr(String propertyName) throws GSEException {
        String propertyValue = null;
        Node propertyNode = this.getBottomPropertyNode(propertyName);
        if (propertyNode == null) {
            this.ExcepName = this.ErrPath + "STRING_NOT_IN_CONFIG_FILE";
            this.ErrComment = "The parameter  " + propertyName + " is not in Info.plist";
            throw new GSEException(this.ErrComment, this.ExcepName);
        }
        propertyValue = propertyNode.getFirstChild().getNodeValue();
        propertyValue = propertyValue.replaceAll("\\$GSE_DIR", this.PathToGseDir);
        return propertyValue;
    }

    public double getDbl(String propertyName) throws GSEException {
        String StrPropertyValue = this.getStr(propertyName);
        double DblValue = 1.0;
        try {
            DblValue = Double.parseDouble(StrPropertyValue);
        }
        catch (NumberFormatException e) {
            this.ExcepName = this.ErrPath + "CONFIG_VALUE_NOT_DOUBLE";
            this.ErrComment = "The config parameter " + propertyName + "\n" + "has a value: " + StrPropertyValue + "\n" + "which cannot be converted to a double ";
            throw new GSEException(this.ErrComment, this.ExcepName);
        }
        return DblValue;
    }

    public int getInt(String propertyName) throws GSEException {
        String StrPropertyValue = this.getStr(propertyName);
        int IntValue = 1;
        try {
            IntValue = Integer.parseInt(StrPropertyValue);
        }
        catch (NumberFormatException e) {
            this.ExcepName = this.ErrPath + "CONFIG_VALUE_NOT_INTEGER";
            this.ErrComment = "The config parameter " + propertyName + "\n" + "has a value: " + StrPropertyValue + "\n" + "which cannot be converted to an int ";
            throw new GSEException(this.ErrComment, this.ExcepName);
        }
        return IntValue;
    }

    public long getLong(String propertyName) throws GSEException {
        String StrPropertyValue = this.getStr(propertyName);
        long LongValue = 1L;
        try {
            LongValue = Long.parseLong(StrPropertyValue);
        }
        catch (NumberFormatException e) {
            this.ExcepName = this.ErrPath + "CONFIG_VALUE_NOT_LONG";
            this.ErrComment = "The config parameter " + propertyName + "\n" + "has a value: " + StrPropertyValue + "\n" + "which cannot be converted to a long ";
            throw new GSEException(this.ErrComment, this.ExcepName);
        }
        return LongValue;
    }

    private Node getBottomPropertyNode(String propertyName) {
        String nodePropertyNodeName;
        Node startingNode = this.topPropertyNode;
        Node propValueNode = null;
        StringTokenizer tokenizedPropertyName = new StringTokenizer(propertyName, this.delimiter);
        while (tokenizedPropertyName.hasMoreTokens() && (propValueNode = this.getPropertyNode(nodePropertyNodeName = tokenizedPropertyName.nextToken(), startingNode)) != null) {
            startingNode = propValueNode;
        }
        return propValueNode;
    }

    private Node getPropertyNode(String propertyName, Node startingNode) {
        Node nodeWithPropertyValue = null;
        NodeList nodes = startingNode.getChildNodes();
        if (nodes != null) {
            for (int i = 0; i < nodes.getLength(); ++i) {
                Node keyNode;
                String value;
                Node nodeToCheck = nodes.item(i);
                String name = " ";
                name = nodeToCheck.getNodeName();
                if (!name.equals("key") || !(value = (keyNode = nodeToCheck.getFirstChild()).getNodeValue()).equals(propertyName)) continue;
                name = "#text";
                while (name.equals("#text")) {
                    name = nodes.item(++i).getNodeName();
                }
                nodeWithPropertyValue = nodes.item(i);
                break;
            }
        }
        return nodeWithPropertyValue;
    }

    public void setNodeValue(String propertyName, String NewValue) throws GSEException {
        StringBuffer XmlAsStrBuff = null;
        Node propertyNode = this.getBottomPropertyNode(propertyName);
        if (propertyNode == null) {
            this.ExcepName = this.ErrPath + "STRING_NOT_IN_CONFIG_FILE";
            this.ErrComment = "The parameter  " + propertyName + " is not in Info.plist";
            throw new GSEException(this.ErrComment, this.ExcepName);
        }
        Node ChildNode = propertyNode.getFirstChild();
        ChildNode.setNodeValue(NewValue);
        try {
            XmlTransform TransXML = new XmlTransform();
            TransXML.setTopNode(this.ConfigDOM);
            TransXML.setOutputProperty("doctype-system", "PropertyList-1.0.dtd");
            XmlAsStrBuff = TransXML.XmlToStringBuffer();
        }
        catch (Exception excep) {
            excep.printStackTrace();
        }
        ByteBuffer bbuf = ByteBuffer.allocate(XmlAsStrBuff.length());
        bbuf.position(0);
        bbuf.limit(bbuf.capacity());
        bbuf.put(this.AsciiCharset.encode(XmlAsStrBuff.toString()));
        bbuf.flip();
        File file = new File(this.XMLFileName);
        boolean append = false;
        try {
            FileChannel wChannel = new FileOutputStream(file, append).getChannel();
            wChannel.write(bbuf);
            wChannel.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

