/*
 * Decompiled with CFR 0.152.
 */
package edu.umn.space.swaves.TMlibServerAgent;

import edu.umn.space.swaves.GSEException.GSEException;
import edu.umn.space.swaves.TMlibServerAgent.LaunchTMlibTCP_Session;
import edu.umn.space.swaves.TMlibServerAgent.PortScanner;
import edu.umn.space.swaves.TMlibServerAgent.StreamGobbler;
import edu.umn.space.swaves.stereoLib.tcpServer.tcpPidSess;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.nio.ByteBuffer;
import java.nio.channels.SocketChannel;

public final class handleIncomingClient
extends Thread {
    SocketChannel SocketToClient;
    private PortScanner portCheck;
    private static int ID_NUM;
    private boolean myDebug;

    public handleIncomingClient(SocketChannel inSocketToClient, PortScanner inPortCheck, boolean debugFlag) {
        this.myDebug = debugFlag;
        this.SocketToClient = inSocketToClient;
        this.portCheck = inPortCheck;
    }

    public void run() {
        Process NewProcess = null;
        try {
            ByteBuffer CmdFromTmLibClient = ByteBuffer.allocate(50);
            CmdFromTmLibClient.limit(4);
            for (int i = 0; i < 4; ++i) {
                this.SocketToClient.read(CmdFromTmLibClient);
            }
            int NumBytesFromServer = CmdFromTmLibClient.getInt(0);
            CmdFromTmLibClient.limit(NumBytesFromServer + 4);
            for (int i = 0; i < NumBytesFromServer + 4; ++i) {
                this.SocketToClient.read(CmdFromTmLibClient);
            }
            int TMlibID = this.getID_NUM();
            int NewPort = this.portCheck.findOpenPort();
            InetSocketAddress RemoteAddress = (InetSocketAddress)this.SocketToClient.socket().getRemoteSocketAddress();
            String LaunchParam = RemoteAddress.getAddress().getHostName();
            if (!this.myDebug) {
                NewProcess = LaunchTMlibTCP_Session.launchNewSession(NewPort, TMlibID, LaunchParam);
            } else {
                launchDebugSession debugSession = new launchDebugSession(NewPort, TMlibID);
                debugSession.setName("launchDebugSession[" + TMlibID + "]");
                debugSession.start();
            }
            this.portCheck.waitForNewTCPServer(NewPort);
            this.portCheck.releasePort(NewPort);
            ByteBuffer MessageToTmLibClient = ByteBuffer.allocate(50);
            MessageToTmLibClient.putInt(12);
            MessageToTmLibClient.putInt(0);
            MessageToTmLibClient.putInt(NewPort);
            MessageToTmLibClient.putInt(TMlibID);
            MessageToTmLibClient.flip();
            this.SocketToClient.write(MessageToTmLibClient);
            this.SocketToClient.close();
            if (!this.myDebug) {
                this.manageTheProcessBuffer(NewPort, NewProcess);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (GSEException e) {
            try {
                ByteBuffer MessageToTmLibClient = ByteBuffer.allocate(50);
                MessageToTmLibClient.putInt(4);
                MessageToTmLibClient.putInt(e.getErrorCode());
                MessageToTmLibClient.flip();
                this.SocketToClient.write(MessageToTmLibClient);
                this.SocketToClient.close();
            }
            catch (IOException ioerr) {
                e.printStackTrace();
            }
        }
    }

    private synchronized int getID_NUM() {
        return ++ID_NUM;
    }

    private void manageTheProcessBuffer(int NewPort, Process NewProcess) {
        StreamGobbler STDERR = new StreamGobbler(NewProcess.getErrorStream(), "ERROR");
        StreamGobbler STDOUT = new StreamGobbler(NewProcess.getInputStream(), "OUTPUT");
        STDERR.start();
        STDOUT.start();
        STDERR.setName("errorGobbler " + Integer.toString(NewPort));
        STDOUT.setName("outputGobbler " + Integer.toString(NewPort));
        try {
            NewProcess.getOutputStream().close();
            NewProcess.waitFor();
        }
        catch (Exception excep) {
            excep.printStackTrace();
        }
    }

    private class launchDebugSession
    extends Thread {
        private int myPort;
        private int myID;

        public launchDebugSession(int port, int id) {
            this.myPort = port;
            this.myID = id;
        }

        public void run() {
            try {
                tcpPidSess tmsession = new tcpPidSess(this.myID);
                tmsession.waitForClientsToConnect(this.myPort);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }
}

