/*
 * Decompiled with CFR 0.152.
 */
package edu.umn.space.swaves.TMlibServerAgent;

import edu.umn.space.swaves.GSEException.GSEException;
import edu.umn.space.swaves.TMlibServerAgent.PortScanner;
import edu.umn.space.swaves.TMlibServerAgent.handleIncomingClient;
import edu.umn.space.swaves.util.xml.ConfigFileAccess;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.nio.channels.ServerSocketChannel;
import java.nio.channels.SocketChannel;

public final class ServerAgent {
    private PortScanner portCheck;
    private int myAgentPort;

    public ServerAgent() throws GSEException {
        ConfigFileAccess propData = new ConfigFileAccess("TMLibConfig");
        String ConfigTop = "Java#*TMlibServerAgent#*";
        int MinPort = propData.getInt(ConfigTop + "LowPortToCheckForTMlibProcess");
        int MaxPort = propData.getInt(ConfigTop + "HiPortToCheckForTMlibProcess");
        this.portCheck = new PortScanner(MinPort, MaxPort);
        this.myAgentPort = propData.getInt(ConfigTop + "WellKnownPortOfTMlibAgent");
    }

    private void listenForClients(boolean debug) {
        try {
            ServerSocketChannel AcceptingServer = ServerSocketChannel.open();
            AcceptingServer.socket().bind(new InetSocketAddress(this.myAgentPort));
            AcceptingServer.configureBlocking(true);
            while (true) {
                SocketChannel SocketToClient = AcceptingServer.accept();
                handleIncomingClient newClient = new handleIncomingClient(SocketToClient, this.portCheck, debug);
                newClient.setName("handleIncomingClient");
                newClient.start();
            }
        }
        catch (IOException excep) {
            excep.printStackTrace();
            System.exit(1);
            return;
        }
    }

    public static void main(String[] args) {
        boolean debug = false;
        if (args.length > 0 && args[0].equals("debug")) {
            debug = true;
        }
        try {
            ServerAgent server = new ServerAgent();
            server.listenForClients(debug);
        }
        catch (GSEException LogExcep) {
            System.out.println("Server Agent Could Not be Configured");
            System.out.println("GSEException Exception:");
            System.out.println("Name:        " + LogExcep.getErrorName());
            System.out.println("Code:        " + LogExcep.getErrorCode());
            System.out.println("Description: " + LogExcep.getErrorDescription());
            System.out.println("Message:     " + LogExcep.getMessage());
            System.exit(0);
        }
    }
}

