/*
 * Decompiled with CFR 0.152.
 */
package edu.umn.space.swaves.TMlibServerAgent;

import edu.umn.space.swaves.GSEException.GSEException;
import java.io.IOException;
import java.net.Socket;
import java.util.Hashtable;

public final class PortScanner {
    static String host = "localhost";
    static Hashtable PortsLaunchedButNotComplete = new Hashtable();
    int startingPortNumber;
    int finishingPortNumber;
    private String ErrPath = "Universe.edu.umn.space.swaves..tcpServer.";

    public PortScanner(int inStartingPortNumber, int infinishingPortNumber) {
        this.startingPortNumber = inStartingPortNumber;
        this.finishingPortNumber = infinishingPortNumber;
    }

    public synchronized int findOpenPort() throws GSEException {
        int goodPort = -1;
        boolean KeepLooking = true;
        int LoopStart = this.startingPortNumber;
        while (KeepLooking) {
            for (int port = LoopStart; port < this.finishingPortNumber; ++port) {
                boolean PortTaken = false;
                try {
                    Socket connection = new Socket(host, port);
                    connection.close();
                    PortTaken = true;
                }
                catch (IOException e) {
                    // empty catch block
                }
                if (PortTaken) continue;
                goodPort = port;
                break;
            }
            if (goodPort == -1) {
                String ErrComment = "No open port between " + this.startingPortNumber + "and " + this.finishingPortNumber;
                String ExcepName = this.ErrPath + "NO_OPEN_PORT_FOR_TMLIB";
                throw new GSEException(ErrComment, ExcepName);
            }
            if (PortsLaunchedButNotComplete.containsKey(new Integer(goodPort))) {
                LoopStart = goodPort + 1;
                continue;
            }
            KeepLooking = false;
            PortsLaunchedButNotComplete.put(new Integer(goodPort), new Integer(1));
        }
        return goodPort;
    }

    public void releasePort(int PortThatHasConnected) {
        PortsLaunchedButNotComplete.remove(new Integer(PortThatHasConnected));
    }

    public void waitForNewTCPServer(int portNum) throws GSEException {
        int NumTrys = 1000;
        long sleepTimeWaitingForNewServer = 120L;
        boolean serverMade = false;
        for (int limit = 0; limit < NumTrys; ++limit) {
            try {
                Socket connection = new Socket("localhost", portNum);
                connection.close();
                serverMade = true;
                break;
            }
            catch (IOException e) {
                try {
                    Thread.sleep(sleepTimeWaitingForNewServer);
                }
                catch (InterruptedException Interrupte) {
                    e.printStackTrace();
                }
                continue;
            }
        }
        if (!serverMade) {
            String ErrComment = "Server not bound in " + sleepTimeWaitingForNewServer + "millisec";
            String ExcepName = this.ErrPath + "LAUNCH_OF_TMLIB_PROCESS_FAILED_IN_TIMELIMIT";
            throw new GSEException(ErrComment, ExcepName);
        }
    }
}

