/*
 * Decompiled with CFR 0.152.
 */
package edu.umn.space.swaves.GSEException;

import edu.umn.space.swaves.util.xml.ConfigFileAccess;
import edu.umn.space.swaves.util.xml.XMLtoTree;

public class GSEException
extends Exception {
    public static final String ErrPath = "Universe.edu.umn.space.swaves.";
    private static XMLtoTree XMLtree;
    private static boolean DataBaseMade;
    private static final String leafName = "errorCode";
    private static final String delimiter = "\\.";
    private static final int basisForNumbersInXmlFile = 10;
    private String customizedErrorMessage;

    public GSEException(String incustomizedErrorMessage, String ErrPath) {
        this.customizedErrorMessage = incustomizedErrorMessage;
        if (!DataBaseMade) {
            this.loadErrorDB();
        }
        try {
            XMLtree.findLeafNode(ErrPath);
        }
        catch (Exception excp) {
            XMLtree.findLeafNode("ERROR_NAME_NOT_IN_XML_FILE");
            this.customizedErrorMessage = "The error: " + ErrPath + " is not in the XML error database";
        }
    }

    private void loadErrorDB() {
        XMLtree = new XMLtoTree(leafName);
        XMLtree.setAttributeNodeName("name");
        XMLtree.setDelimiter(delimiter);
        String PathToErrorXml = null;
        try {
            ConfigFileAccess propData = new ConfigFileAccess("TMLibConfig");
            PathToErrorXml = propData.getStr("FileSystem#*EXCEPTION_DB");
        }
        catch (Exception e) {
            System.out.println("Error reading URI: " + e.getMessage());
        }
        XMLtree.ParseXMLfile(PathToErrorXml);
        boolean DataBaseMade = true;
    }

    public String getErrorName() {
        return XMLtree.getCurrentNodeAttibuteValue("name");
    }

    public int getErrorCode() {
        String strCode = XMLtree.getCurrentNodeAttibuteValue("code");
        return Integer.valueOf(strCode, 10);
    }

    public String getMessage() {
        return this.customizedErrorMessage;
    }

    public String getErrorDescription() {
        return XMLtree.getCurrentNodeAttibuteValue("desc");
    }

    static {
        DataBaseMade = false;
    }
}

