/*
 * Decompiled with CFR 0.152.
 */
package edu.umn.space.swaves.util.xml;

import edu.umn.space.swaves.GSEException.GSEException;
import edu.umn.space.swaves.util.xml.ConfigFileAccess;
import edu.umn.space.swaves.util.xml.SearchXMl_TreeBasedOnAttrValues;
import java.io.File;

public class MocListExtract {
    private static final String ErrPath = "Universe.edu.umn.space.swaves..util.xml.";
    private SearchXMl_TreeBasedOnAttrValues XPathSearch;
    private String NodeType = "MocSource";
    private String MocListFileName;
    private String RequestedNodeName;

    public MocListExtract() throws GSEException {
        ConfigFileAccess propData = new ConfigFileAccess("TMLibConfig");
        this.MocListFileName = propData.getStr("FileSystem#*MOC_LIST");
        this.XPathSearch = new SearchXMl_TreeBasedOnAttrValues(new File(this.MocListFileName));
        this.XPathSearch.setAttrTypeUsedToNameNode("NAME");
        this.XPathSearch.setNodeType("MocSource");
    }

    public void selectNode(String inRequestedNodeName) throws GSEException {
        this.RequestedNodeName = inRequestedNodeName;
        this.XPathSearch.setRequestedNodeName(this.RequestedNodeName);
    }

    public String getNAME() throws GSEException {
        return this.getGeneralValue("NAME");
    }

    public String getMISSION() throws GSEException {
        return this.getGeneralValue("MISSION");
    }

    public String getMOC_TELMETRY_HOST() throws GSEException {
        return this.getGeneralValue("MOC_TELMETRY_HOST");
    }

    public String getMOC_CMD_HOST() throws GSEException {
        return this.getGeneralValue("MOC_CMD_HOST");
    }

    public String getDESCRIPTION() throws GSEException {
        return this.getGeneralValue("DESCRIPTION");
    }

    public int getMOC_TELMETRY_PORT() throws GSEException {
        return Integer.parseInt(this.getGeneralValue("MOC_TELMETRY_PORT"));
    }

    public int getMOC_CMD_PORT() throws GSEException {
        return Integer.parseInt(this.getGeneralValue("MOC_CMD_PORT"));
    }

    public String getOUTPUT_FILE_DESCRIP() throws GSEException {
        return this.getGeneralValue("OUTPUT_FILE_DESCRIP");
    }

    public String getWRITE_PATH() throws GSEException {
        return this.getGeneralValue("WRITE_PATH");
    }

    public String getGeneralValue(String AttributeToRetrun) throws GSEException {
        String OutString = null;
        this.XPathSearch.setAttributeToRetrun(AttributeToRetrun);
        OutString = this.XPathSearch.evaluate();
        if (OutString == null) {
            String ExcepName = "Universe.edu.umn.space.swaves..util.xml.ERROR_GETTING_PARAMETER_FROM_CONFIG_FILE";
            String ErrComment = "\nThe parameter:                    " + AttributeToRetrun + "\n" + "was not found in a node of type:  " + this.NodeType + "\n" + "The user requested the node name: " + this.RequestedNodeName + "\n" + "The following file was searched: \n" + this.MocListFileName;
            throw new GSEException(ErrComment, ExcepName);
        }
        return OutString;
    }
}

