/*
 * Decompiled with CFR 0.152.
 */
package edu.umn.space.swaves.logServer.ServerSide;

import edu.umn.space.swaves.GSEException.GSEException;
import edu.umn.space.swaves.logServer.ServerSide.ParmsForLogRecord;
import edu.umn.space.swaves.util.xml.ConfigFileAccess;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.SocketChannel;
import java.nio.charset.CharacterCodingException;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.util.logging.Logger;

public final class CentralLoggerThread
extends Thread {
    private SocketChannel ChannelFromLoggerClient;
    private Charset charset = Charset.forName("US-ASCII");
    private CharsetDecoder decoder = this.charset.newDecoder();
    private Logger MainLogger;
    private int BufferSz;
    private static final int LOGGER_MODE_LOG_MESSAGE = 1;
    private static final int LOGGER_MODE_COMMAND_CODE = 2;

    public CentralLoggerThread(SocketChannel inputChannelFromLoggerClient) throws IOException, GSEException {
        this.ChannelFromLoggerClient = inputChannelFromLoggerClient;
        this.ChannelFromLoggerClient.configureBlocking(false);
        ConfigFileAccess propData = new ConfigFileAccess("TMLibConfig");
        this.BufferSz = propData.getInt("Logs#*LOGGER_BUFFER_SIZE");
    }

    public void setMainLogger(Logger inputMainLogger) {
        this.MainLogger = inputMainLogger;
    }

    public void run() {
        ByteBuffer FromClient = ByteBuffer.allocate(this.BufferSz);
        ParmsForLogRecord LogFormatInfo = new ParmsForLogRecord();
        boolean KeepSendingRecords = true;
        boolean NumFailures = false;
        while (KeepSendingRecords) {
            try {
                FromClient.clear();
                this.readNbytesFromChannel(FromClient, 4);
                int LoggerMode = FromClient.getInt(0);
                if (LoggerMode == 1) {
                    this.fillByteBufferFromClient(FromClient, LogFormatInfo);
                    String Message = LogFormatInfo.getMessage();
                    this.MainLogger.log(LogFormatInfo.getLogLevel(), Message, LogFormatInfo);
                } else if (LoggerMode == 2) {
                    this.readNbytesFromChannel(FromClient, 4);
                    int Commmand = FromClient.getInt(4);
                    if (Commmand == 57005) {
                        KeepSendingRecords = false;
                        this.ChannelFromLoggerClient.close();
                    }
                }
                NumFailures = false;
            }
            catch (Exception e) {}
        }
    }

    private void fillByteBufferFromClient(ByteBuffer FromClient, ParmsForLogRecord LogFormatInfo) throws Exception {
        FromClient.position(4);
        this.readNbytesFromChannel(FromClient, 16);
        int spot = FromClient.limit() - 4;
        int LEN_NAME = FromClient.getInt(spot);
        this.readNbytesFromChannel(FromClient, LEN_NAME + 4);
        spot = FromClient.limit() - 4;
        int LEN_CLASS = FromClient.getInt(spot);
        this.readNbytesFromChannel(FromClient, LEN_CLASS + 4);
        spot = FromClient.limit() - 4;
        int LEN_METHOD = FromClient.getInt(spot);
        this.readNbytesFromChannel(FromClient, LEN_METHOD + 4);
        spot = FromClient.limit() - 4;
        int LEN_MESSAGE = FromClient.getInt(spot);
        this.readNbytesFromChannel(FromClient, LEN_MESSAGE);
        FromClient.flip();
        FromClient.position(4);
        LogFormatInfo.setLogLevelInt(FromClient.getInt());
        LogFormatInfo.setMillsec1970(FromClient.getLong());
        int Start = 20;
        int Last = Start + LEN_NAME;
        LogFormatInfo.setLogName(this.pullStrFromBuff(FromClient, Start, Last));
        Start = Last + 4;
        Last = Start + LEN_CLASS;
        LogFormatInfo.setClassOfMessageOrigin(this.pullStrFromBuff(FromClient, Start, Last));
        Start = Last + 4;
        Last = Start + LEN_METHOD;
        LogFormatInfo.setMethodOfMessageOrigin(this.pullStrFromBuff(FromClient, Start, Last));
        Start = Last + 4;
        Last = Start + LEN_MESSAGE;
        LogFormatInfo.setMessage(this.pullStrFromBuff(FromClient, Start, Last));
    }

    private void readNbytesFromChannel(ByteBuffer FromClient, int NumToRead) throws Exception {
        FromClient.limit(FromClient.position() + NumToRead);
        while (FromClient.hasRemaining()) {
            this.ChannelFromLoggerClient.read(FromClient);
            if (!FromClient.hasRemaining()) continue;
            Thread.sleep(25L);
        }
    }

    private String pullStrFromBuff(ByteBuffer InBuff, int First, int Last) throws CharacterCodingException {
        InBuff.limit(Last).position(First);
        return this.decoder.decode(InBuff).toString();
    }
}

