/*
 * Decompiled with CFR 0.152.
 */
package edu.umn.space.swaves.GSEException;

import edu.umn.space.swaves.GSEException.GSEException;
import edu.umn.space.swaves.util.strings.stringTools;

public class TMlibErrorStack {
    private static GSEException sLibError;
    public int NumberOfElementsInTheStack = 0;
    public boolean ReadingFromErrorStack = false;

    public void enterElementIntoStack(GSEException in_sLibError) {
        sLibError = in_sLibError;
        ++this.NumberOfElementsInTheStack;
    }

    public void clear() {
        this.NumberOfElementsInTheStack = 0;
        this.ReadingFromErrorStack = false;
        sLibError = null;
    }

    public String queryErrorStack(String CmdType) {
        String errorReport;
        if (this.NumberOfElementsInTheStack == 0) {
            errorReport = "Server error stack is empty";
        } else if (CmdType.trim().equalsIgnoreCase("code")) {
            errorReport = Integer.toString(sLibError.getErrorCode());
        } else if (CmdType.equalsIgnoreCase("description")) {
            errorReport = sLibError.getErrorDescription();
        } else if (CmdType.equalsIgnoreCase("name")) {
            errorReport = sLibError.getErrorName();
        } else if (CmdType.equalsIgnoreCase("message")) {
            errorReport = sLibError.getMessage();
        } else if (CmdType.equalsIgnoreCase("stackTrace")) {
            errorReport = this.errorStackDump(sLibError);
        } else if (CmdType.equalsIgnoreCase("verbose")) {
            int ErrorCode = sLibError.getErrorCode();
            errorReport = "Error Code: " + Integer.toString(ErrorCode) + "\n" + "Name: " + sLibError.getErrorName() + "\n" + "Description: " + sLibError.getErrorDescription() + "\n" + "Message: " + sLibError.getMessage() + "\n";
        } else {
            errorReport = CmdType + " is not a valid GSEException option";
        }
        this.ReadingFromErrorStack = true;
        return errorReport;
    }

    public boolean errorPresent() {
        return sLibError != null;
    }

    public int getNewErrorStackCode() {
        int ErrorCode = 0;
        if (this.NumberOfElementsInTheStack != 0 && !this.ReadingFromErrorStack) {
            ErrorCode = sLibError.getErrorCode();
        }
        return ErrorCode;
    }

    private String errorStackDump(Throwable InputException) {
        StackTraceElement[] stackElements = InputException.getStackTrace();
        String StackString = "";
        String LineNumber = stringTools.pad("Line#", 7);
        String MethodName = stringTools.pad("Method", 35);
        String ClassName = stringTools.pad("Class", 75) + "\n";
        StackString = StackString + LineNumber + MethodName + ClassName;
        for (int stackIndex = 0; stackIndex < stackElements.length; ++stackIndex) {
            LineNumber = stringTools.pad("" + stackElements[stackIndex].getLineNumber(), 7);
            MethodName = stringTools.pad(stackElements[stackIndex].getMethodName(), 35);
            ClassName = stringTools.pad(stackElements[stackIndex].getClassName(), 75).trim() + ".java\n";
            StackString = StackString + LineNumber + MethodName + ClassName;
        }
        StackString = StackString.replaceAll("\\.", "/");
        StackString = StackString.replaceAll("/java\n", ".java\n");
        StackString = StackString.replaceAll("edu/", "src/edu/");
        return StackString;
    }
}

