/*
 * Decompiled with CFR 0.152.
 */
package edu.umn.space.swaves.GSEControl;

import edu.umn.space.swaves.GSEException.GSEException;
import edu.umn.space.swaves.logServer.ClientSide.LogClient;
import edu.umn.space.swaves.logServer.ClientSide.TMlibLogLevel;
import edu.umn.space.swaves.util.xml.ConfigFileAccess;
import java.util.logging.Level;

public final class ConfigureLogger {
    public static void main(String[] args) {
        try {
            if (args.length == 0) {
                ConfigFileAccess propData = new ConfigFileAccess("TMLibConfig");
                String CurrentLevel = propData.getStr("Logs#*TM_log_level");
                System.out.println("\nCurrent Logging Level: " + CurrentLevel + "\n");
            } else {
                ConfigureLogger.ChangeLogLevel(args[0]);
            }
        }
        catch (GSEException Excep) {
            System.out.println("GSEException Exception while Configuring Logger:");
            System.out.println("Name:        " + Excep.getErrorName());
            System.out.println("Code:        " + Excep.getErrorCode());
            System.out.println("Description: " + Excep.getErrorDescription());
            System.out.println("Message:     " + Excep.getMessage());
            System.exit(0);
        }
    }

    private static void ChangeLogLevel(String Direction) throws GSEException {
        String NewLevel = null;
        ConfigFileAccess propData = new ConfigFileAccess("TMLibConfig");
        String CurrentLevel = propData.getStr("Logs#*TM_log_level");
        if (Direction.equalsIgnoreCase("less")) {
            NewLevel = TMlibLogLevel.OneLower(CurrentLevel);
        } else if (Direction.equalsIgnoreCase("more")) {
            NewLevel = TMlibLogLevel.OneHigher(CurrentLevel);
        } else {
            System.out.println("\nThe command: gsecontrol -log " + Direction);
            System.out.println("Is not allowed.  Valid options are:");
            System.out.println("gsecontrol -log more");
            System.out.println("gsecontrol -log less");
            System.exit(1);
        }
        propData.setNodeValue("Logs#*TM_log_level", NewLevel);
        LogClient.getLogger(4);
        LogClient.log(Level.CONFIG, "Logging Level for new TMlib sessions: " + NewLevel);
    }
}

