function TM_UR8_to_YDOY, UR8, yyyy, doy, msec_d
    if size(UR8, /type) eq 0 then UR8 = double(0.0)
    if size(UR8, /type) ne 5 then UR8 = double(UR8)
    if size(yyyy, /type) eq 0 then yyyy = long(0)
    if size(yyyy, /type) ne 3 and size(yyyy, /type) ne 13 $
       then yyyy = long(yyyy)
    if size(doy, /type) eq 0 then doy = long(0)
    if size(doy, /type) ne 3 and size(doy, /type) ne 13 $
       then doy = long(doy)
    if size(msec_d, /type) eq 0 then msec_d = long(0)
    if size(msec_d, /type) ne 3 and size(msec_d, /type) ne 13 $
       then msec_d = long(msec_d)

    err = call_external(TM_GetLibPath(), 'TM_UR8_to_YDOY_idl', UR8, $
       yyyy, doy, msec_d, RETURN_TYPE=3)

    return, err
end

function TM_UR8_to_YDOYH, UR8, yyyy, doy, hour
    if size(UR8, /type) eq 0 then UR8 = double(0.0)
    if size(UR8, /type) ne 5 then UR8 = double(UR8)
    if size(yyyy, /type) eq 0 then yyyy = long(0)
    if size(yyyy, /type) ne 3 and size(yyyy, /type) ne 13 $
       then yyyy = long(yyyy)
    if size(doy, /type) eq 0 then doy = long(0)
    if size(doy, /type) ne 3 and size(doy, /type) ne 13 $
       then doy = long(doy)
    if size(hour, /type) eq 0 then hour = double(0)
    if size(hour, /type) ne 5 then hour = double(hour)

    err = call_external(TM_GetLibPath(), 'TM_UR8_to_YDOYH_idl', UR8, $
       yyyy, doy, hour, RETURN_TYPE=3)

    return, err
end

function TM_UR8_to_YMD, UR8, yyyy, mon, dd, hh, mm, ss, ms
    if size(UR8, /type) eq 0 then UR8 = double(0.0)
    if size(UR8, /type) ne 5 then UR8 = double(UR8)
    if size(yyyy, /type) eq 0 then yyyy = long(0)
    if size(yyyy, /type) ne 3 and size(yyyy, /type) ne 13 $
       then yyyy = long(yyyy)
    if size(mon, /type) eq 0 then mon = long(0)
    if size(mon, /type) ne 3 and size(mon, /type) ne 13 $
       then mon = long(mon)
    if size(dd, /type) eq 0 then dd = long(0)
    if size(dd, /type) ne 3 and size(dd, /type) ne 13 $
       then dd = long(dd)
    if size(hh, /type) eq 0 then hh = long(0)
    if size(hh, /type) ne 3 and size(hh, /type) ne 13 $
       then hh = long(hh)
    if size(mm, /type) eq 0 then mm = long(0)
    if size(mm, /type) ne 3 and size(mm, /type) ne 13 $
       then mm = long(mm)
    if size(ss, /type) eq 0 then ss = long(0)
    if size(ss, /type) ne 3 and size(ss, /type) ne 13 $
       then ss = long(ss)
    if size(ms, /type) eq 0 then ms = long(0)
    if size(ms, /type) ne 3 and size(ms, /type) ne 13 $
       then ms = long(ms)

    err = call_external(TM_GetLibPath(), 'TM_UR8_to_YMD_idl', UR8, $
       yyyy, mon, dd, hh, mm, ss, ms, RETURN_TYPE=3)

    return, err
end

function TM_UR8_to_String, UR8, Date_String
    if size(UR8, /type) eq 0 then UR8 = double(0.0)
    if size(UR8, /type) ne 5 then UR8 = double(UR8)

    buf = bytarr(50)

    err = call_external(TM_GetLibPath(),'TM_UR8_to_String_idl', $
       UR8, buf, n_elements(buf), RETURN_TYPE=3)

    Date_String = string(buf)
    
    return, err
end

function TM_UR8_to_String_Absolute, UR8, Absolute_dt_string
    if size(UR8, /type) eq 0 then UR8 = double(0.0)
    if size(UR8, /type) ne 5 then UR8 = double(UR8)

    buf = bytarr(50)

    err = call_external(TM_GetLibPath(), 'TM_UR8_to_String_Absolute_idl', $
       UR8, buf, n_elements(buf), RETURN_TYPE=3)

    Absolute_dt_string = string(buf)

    return, err
end

function TM_UR8_to_String_Comparison, UR8, ComparisonString
    if size(UR8, /type) eq 0 then UR8 = double(0.0)
    if size(UR8, /type) ne 5 then UR8 = double(UR8)

    buf = bytarr(50)

    err = call_external(TM_GetLibPath(),'TM_UR8_to_String_Comparison_idl', $
       UR8, buf, n_elements(buf), RETURN_TYPE=3)

    ComparisonString = string(buf)

    return, err
end

function TM_UR8_from_YDOY, UR8, yyyy, doy, msec_d
    if size(UR8, /type) eq 0 then UR8 = double(0.0)
    if size(UR8, /type) ne 5 then UR8 = double(UR8)
    yyyy = long(yyyy)
    doy = long(doy)
    msec_d = long(msec_d)

    err = call_external(TM_GetLibPath(),'TM_UR8_from_YDOY_idl', UR8, $
       yyyy, doy, msec_d, RETURN_TYPE=3)

    return, err
end

function TM_UR8_from_YMD,UR8, yyyy, mon, dd, hh, mm, ss, ms
    if size(UR8, /type) eq 0 then UR8 = double(0.0)
    if size(UR8, /type) ne 5 then UR8 = double(UR8)
    yyyy = long(yyyy)
    mon = long(mon)
    dd = long(dd)
    hh = long(hh)
    mm = long(mm)
    ss = long(ss)
    ms = long(ms)

    err = call_external(TM_GetLibPath(),'TM_UR8_from_YMD_idl', UR8, $
       yyyy, mon, dd, hh, mm, ss, ms, RETURN_TYPE=3)

    return, err
end

function TM_UR8_from_String_Absolute, UR8, Comparison_dt_String
    if size(UR8, /type) eq 0 then UR8 = double(0.0)
    if size(UR8, /type) ne 5 then UR8 = double(UR8)

    err = call_external(TM_GetLibPath(),'TM_UR8_from_String_Absolute_idl', $
       UR8, Comparison_dt_String, RETURN_TYPE=3)

    return, err
end

function TM_UR8_from_String_Comparison, UR8, Comparison_dt_String
    if size(UR8, /type) eq 0 then UR8 = double(0.0)
    if size(UR8, /type) ne 5 then UR8 = double(UR8)

    err = call_external(TM_GetLibPath(),'TM_UR8_from_String_Comparison_idl', $
       UR8, Comparison_dt_String, RETURN_TYPE=3)

    return, err
end

function TM_UR8_from_Local_Time, UR8
    if size(UR8, /type) eq 0 then UR8 = double(0.0)
    if size(UR8, /type) ne 5 then UR8 = double(UR8)

    err = call_external(TM_GetLibPath(), 'TM_UR8_from_Local_Time_idl', UR8, $
       RETURN_TYPE=3)

    return, err
end