function TM_GetLibPath
    if (!version.os eq 'Win32') then begin
       IDL_lib_Abs_Path = getenv('STEREO_TMlib_Client_Home') + "\lib\c\TM.dll"
    endif else if (!version.os eq 'darwin' or !version.os eq 'linux') then begin
       IDL_lib_Abs_Path = getenv('STEREO_TMlib_Client_Home') + "/lib/idl/libIdlBridge.so"
    endif

    return, IDL_lib_Abs_Path
end

;function TM_Select_Site, sitename
;    err = call_external(TM_GetLibPath(), 'TM_Select_Site_idl', $
;       sitename, RETURN_TYPE=3)
;
;    return, err
;end

function TM_Select_Server, ServerName
    err = call_external(TM_GetLibPath(), 'TM_Select_Server_idl', $
       ServerName, RETURN_TYPE=3)

    return, err
end

function TM_Select_Port, PortNum
    if size(PortNum, /type) eq 0 then PortNum = long(0)
    if size(PortNum, /type) ne 3 and size(PortNum, /type) ne 13 $
       then PortNum = long(0)

    err = call_external(TM_GetLibPath(), 'TM_Select_Port_idl', PortNum, $
       RETURN_TYPE=3)
    return, err
end

function TM_Select_Domain, Stream_ID, Mission, Spacecraft, Instrument, Event
    if size(Stream_ID, /type) ne 13 then Stream_ID = ulong(0)

    err = call_external(TM_GetLibPath(), 'TM_Select_Domain_idl', Stream_id, $
       Mission, Spacecraft, Instrument, Event, RETURN_TYPE=3)

    return, err
end

function TM_Select_Stream, Stream_ID, StreamName
    if size(Stream_ID, /type) eq 0 then Stream_ID = ulong(0)
    if size(Stream_ID, /type) ne 13 then Stream_ID = ulong(Stream_ID)

    err = call_external(TM_GetLibPath(), 'TM_Select_Stream_File_idl', Stream_ID, $
       StreamName, RETURN_TYPE=3)

    return, err
end

function TM_Select_Stream_File, Stream_ID, StreamName
    if size(Stream_ID, /type) eq 0 then Stream_ID = ulong(0)
    if size(Stream_ID, /type) ne 13 then Stream_ID = ulong(Stream_ID)

    err = call_external(TM_GetLibPath(), 'TM_Select_Stream_File_idl', Stream_ID, $
       StreamName, RETURN_TYPE=3)

    return, err
end

function TM_Select_Stream_TimeRange, Stream_ID, StartUR8, EndUR8
    if size(Stream_ID, /type) eq 0 then Stream_ID = ulong(0)
    if size(Stream_ID, /type) ne 13 then Stream_ID = ulong(Stream_ID)

    if size(StartUR8, /type) eq 0 then StartUR8 = double(0.0)
    if size(StartUR8, /type) ne 5 then StartUR8 = double(StartUR8)
    if size(  EndUR8, /type) eq 0 then   EndUR8 = double(0.0)
    if size(  EndUR8, /type) ne 5 then   EndUR8 = double(  EndUR8)

    err = call_external(TM_GetLibPath(), 'TM_Select_Stream_TimeRange_idl', $
        Stream_ID, StartUR8, EndUR8, RETURN_TYPE=3)

    return, err
end

function TM_Find_Event, Stream_ID
    if size(Stream_ID, /type) eq 0 then Stream_ID = ulong(0)
    if size(Stream_ID, /type) ne 13 then Stream_ID = ulong(Stream_ID)

    err = call_external(TM_GetLibPath(), 'TM_Find_Event_idl', Stream_ID, $
       RETURN_TYPE=3)

    ; WIN32 ONLY
    ; Due to a bug/limitation of the Windows IDLDE, when blocking on
    ; potentially long events, we must spawn a thread in the shim and
    ; poll for its completion else we cause the IDLDE to hang and possibly
    ; crash.
    
    ; 0x00000103 is the value of the Win32 macro STILL_PENDING. This is what
    ; TM_GetFindEventStatus returns should the thread still be running.
    if (!version.os eq 'Win32' and err eq 0) then begin
       repeat begin
         err = call_external(TM_GetLibPath(), 'TM_GetFindEventStatus_idl', $
          RETURN_TYPE=3)
         wait, 0.005
       endrep until (err ne '00000103'XU)
    endif

    return, err
end

function TM_Get_Item_I4, Stream_ID, itemname, dataToClient, bufsize, dataLen
    if size(Stream_ID, /type) eq 0 then Stream_ID = ulong(0)
    if size(Stream_ID, /type) ne 13 then Stream_ID = ulong(Stream_ID)
    if size(bufsize, /type) eq 0 then bufsize = long(1)
    if size(bufsize, /type) ne 3 and size(bufsize, /type) ne 13 $
       then bufsize = long(bufsize)
    if size(dataToClient, /type) eq 0 then dataToClient = long(0)
    if size(dataToClient, /type) ne 3 and size(dataToClient, /type) ne 13 $
       then dataToClient = long(0)
    if size(dataToClient, /N_elements) lt bufsize $
       then dataToClient = lonarr(bufsize)
    dataLen = 0L

    err = call_external(TM_GetLibPath(), 'TM_Get_Item_I4_idl', Stream_ID, $
       itemname, dataToClient, bufsize, dataLen, RETURN_TYPE=3)

    return, err
end

function TM_Get_Item_R4, Stream_ID, itemname, dataToClient, bufsize, dataLen
    if size(Stream_ID, /type) eq 0 then Stream_ID = ulong(0)
    if size(Stream_ID, /type) ne 13 then Stream_ID = ulong(Stream_ID)
    if size(bufsize, /type) eq 0 then bufsize = long(1)
    if size(bufsize, /type) ne 3 and size(bufsize, /type) ne 13 $
       then bufsize = long(bufsize)
    if size(dataToClient, /type) eq 0 then dataToClient = float(0.0)
    if size(dataToClient, /type) ne 4 then dataToClient = float(0.0)
    if size(dataToClient, /N_elements) lt bufsize $
       then dataToClient = fltarr(bufsize)
    dataLen = 0L

    err = call_external(TM_GetLibPath(), 'TM_Get_Item_R4_idl', Stream_ID, $
       itemname, dataToClient, bufsize, dataLen, RETURN_TYPE=3)

    return, err
end

function TM_Get_Item_R8, Stream_ID, itemname, dataToClient, bufsize, dataLen
    if size(Stream_ID, /type) eq 0 then Stream_ID = ulong(0)
    if size(Stream_ID, /type) ne 13 then Stream_ID = ulong(Stream_ID)
    if size(bufsize, /type) eq 0 then bufsize = long(1)
    if size(bufsize, /type) ne 3 and size(bufsize, /type) ne 13 $
       then bufsize = long(bufsize)
    if size(dataToClient, /type) eq 0 then dataToClient = double(0.0)
    if size(dataToClient, /type) ne 5 then dataToClient = double(0.0)
    if size(dataToClient, /N_elements) lt bufsize $
       then dataToClient = dblarr(bufsize)
    dataLen = 0L

    err = call_external(TM_GetLibPath(), 'TM_Get_Item_R8_idl', Stream_ID, $
       itemname, dataToClient, bufsize, dataLen, RETURN_TYPE=3)

    return, err
end

function TM_Get_Item_Char, Stream_ID, itemname, dataToClient, bufsize, dataLen
    if size(Stream_ID, /type) eq 0 then Stream_ID = ulong(0)
    if size(Stream_ID, /type) ne 13 then Stream_ID = ulong(Stream_ID)
    if size(bufsize, /type) eq 0 then bufsize = long(1)
    if size(bufsize, /type) ne 3 and size(bufsize, /type) ne 13 $
       then bufsize = long(bufsize)
    dataLen = 0L
    inputDataToClient = bytarr(bufsize)

    err = call_external(TM_GetLibPath(), 'TM_Get_Item_Char_idl', Stream_ID,$
       itemname, inputDataToClient, bufsize, dataLen, RETURN_TYPE=3)

    dataToClient = string(inputDataToClient)

    return, err
end

function TM_Get_Position, Stream_ID, UR8
    if size(Stream_ID, /type) eq 0 then Stream_ID = ulong(0)
    if size(Stream_ID, /type) ne 13 then Stream_ID = ulong(Stream_ID)
    if size(UR8, /type) eq 0 then UR8 = double(0.0)
    if size(UR8, /type) ne 5 then UR8 = double(UR8)

    err = call_external(TM_GetLibPath(), 'TM_Get_Position_idl', Stream_ID, UR8, $
       RETURN_TYPE=3)

    return, err
end

function TM_Set_Position, Stream_ID, UR8
    if size(Stream_ID, /type) eq 0 then Stream_ID = ulong(0)
    if size(Stream_ID, /type) ne 13 then Stream_ID = ulong(Stream_ID)
    UR8 = double(UR8)

    err = call_external(TM_GetLibPath(), 'TM_Set_Position_idl', Stream_ID, UR8, $
       RETURN_TYPE=3)

    return, err
end

function TM_Close, Stream_ID
    if size(Stream_ID, /type) eq 0 then Stream_ID = ulong(0)
    if size(Stream_ID, /type) ne 13 then Stream_ID = ulong(Stream_ID)

    err = call_external(TM_GetLibPath(), 'TM_Close_idl', Stream_ID, $
       RETURN_TYPE=3)
    return, err
end

function TM_Error_Stack, Stream_ID, errorRequest, errorBuff, bufsize, dataLen
    if size(Stream_ID, /type) eq 0 then Stream_ID = ulong(0)
    if size(Stream_ID, /type) ne 13 then Stream_ID = ulong(Stream_ID)
    if size(bufsize, /type) eq 0 then bufsize = long(1)
    if size(bufsize, /type) ne 3 and size(bufsize, /type) ne 13 $
       then bufsize = long(bufsize)
    dataLen = 0L
    inputErrorBuff = bytarr(bufsize)

    err = call_external(TM_GetLibPath(), 'TM_Error_Stack_idl', Stream_ID, $
       errorRequest, inputErrorBuff, bufsize, dataLen, RETURN_TYPE=3)

    errorBuff = string(inputErrorBuff)

    return, err
end

function TM_Help, Stream_ID, HelpCommand, HelpBuff, bufsize, dataLen
    if size(Stream_ID, /type) eq 0 then Stream_ID = ulong(0)
    if size(Stream_ID, /type) ne 13 then Stream_ID = ulong(Stream_ID)
    if size(bufsize, /type) eq 0 then bufsize = long(1)
    if size(bufsize, /type) ne 3 and size(bufsize, /type) ne 13 $
       then bufsize = long(bufsize)
    dataLen = 0L
    inputHelpBuff = bytarr(bufsize)

    err = call_external(TM_GetLibPath(), 'TM_Help_idl', Stream_ID, $
       HelpCommand, inputHelpBuff, bufsize, dataLen, RETURN_TYPE=3)

    HelpBuff = string(inputHelpBuff)

    return, err
end

function TM_Client_Info
    buf = bytarr(200)
    
    err = call_external(TM_GetLibPath(), 'TM_Client_Info_idl', buf, $
        n_elements(buf), RETURN_TYPE=3)
    
    print, string(buf)
end