#ifndef LIBTM_H
#define LIBTM_H

#ifdef WIN32
typedef char    int8_t;
typedef unsigned char uint8_t;
typedef int     int32_t;
typedef unsigned int uint32_t;
typedef long long int64_t;
typedef unsigned long long uint64_t;
typedef int     ssize_t;

#define _CRT_SECURE_NO_DEPRECATE

#if defined(_cplusplus)
#define EXPORT extern "C" __declspec(dllimport)
#else
#define EXPORT __declspec(dllimport)
#endif
#else                /* not windows */
#include <inttypes.h>
#define EXPORT
#endif                /* WIN32 */


EXPORT int32_t TM_Help (
uint32_t,        /* StreamID Number */
char *,            /* help command */
char *,            /* caller-allocated buffer for returned help text */
int32_t,        /* size of caller-allocated buffer in chars */
int32_t *        /* strlen(caller_allocated_buffer) */
);

EXPORT int32_t TM_Error_Stack (
uint32_t,        /* StreamID Number */
char *,            /* error request */
char *,            /* caller-allocated buffer for returned excp'n text */
int32_t,        /* size of caller-allocated buffer in chars */
int32_t *        /* strlen(caller_allocated_buffer) */
);

EXPORT int32_t TM_Select_Site (
char *            /* The string name of the site */
);

EXPORT int32_t TM_Select_Server (
char *            /* The ip of name of the TM server */
);

EXPORT int32_t TM_Select_Port (
int                /* The port where the STEREO server agent is located */
);

EXPORT int32_t TM_Select_Domain (
uint32_t *,        /* StreamID Number Buffer */
char *,            /* mission */
char *,            /* spacecraft */
char *,            /* instrument */
char *            /* event */
);

EXPORT int32_t TM_Select_Stream_TimeRange (
uint32_t,        /* StreamID Number */
double,            /* start time in UR8 format */
double            /* end time in UR8 format */
);

EXPORT int32_t TM_Select_Stream (
 uint32_t,        /* StreamID Number */
 char *            /* Stream Name or Chooser */
);

EXPORT int32_t TM_Select_Stream_File (
uint32_t,        /* StreamID Number */
char *            /* Stream Name or Chooser */
);

EXPORT int32_t TM_Find_Event (
uint32_t        /* StreamID Number */
);

EXPORT int32_t TM_Get_Position (
uint32_t,        /* StreamID Number */
double *        /* gettime position in the selected stream */
);

EXPORT int32_t TM_Set_Position (
uint32_t,        /* StreamID Number */
double            /* set time poistion in the selected stream */
);

EXPORT int32_t TM_Get_Item_I4 (
uint32_t,        /* StreamID Number */
char *,            /* item name */
int32_t *,        /* caller-allocated buffer for returned item */
int32_t,        /* size of caller-allocated buffer in 32-bit ints */
int32_t *        /* number of 32-bit ints in the returned item */
);

EXPORT int32_t TM_Get_Item_R8 (
uint32_t,        /* StreamID Number */
char *,            /* item name */
double *,        /* caller-allocated buffer for returned item */
int32_t,        /* size of caller-allocated buffer in 32-bit ints */
int32_t *        /* number of 32-bit ints in the returned item */
);

EXPORT int32_t TM_Get_Item_R4 (
uint32_t,        /* StreamID Number */
char *,            /* item name */
float *,        /* caller-allocated buffer for returned item */
int32_t,        /* size of caller-allocated buffer in 32-bit ints */
int32_t *        /* number of 32-bit ints in the returned item */
);

EXPORT int32_t TM_Get_Item_Char (
uint32_t,        /* StreamID Number */
char *,            /* item name */
char *,            /* caller-allocated buffer for returned text */
int32_t,        /* size of caller-allocated buffer in chars */
int32_t *        /* strlen(caller_allocated_buf fer) */
);

EXPORT int32_t TM_Close (
uint32_t        /* StreamID Number */
);

EXPORT int32_t TM_Noop (
uint32_t        /* StreamID Number */
);

/*
 * Time Conversion
 */

EXPORT int TM_UR8_from_String_Absolute (
double *,        /* A UR8  */
char *            /* Absolute_dt_string formated date  */
);

EXPORT int TM_UR8_to_String_Absolute (
double,            /* A UR8  */
char *            /* Absolute_dt_string formated date  */
);

EXPORT int TM_UR8_to_YDOY (
double,            /* A UR8  */
int *,            /* yyyy  */
int *,            /* doy  */
int *            /* msec_d  */
);

EXPORT int TM_UR8_to_YDOYH (
double,            /* A UR8  */
int *,            /* yyyy  */
int *,            /* doy  */
double *        /* hour  */
);

EXPORT int TM_UR8_from_YDOY (
double *,        /* A UR8  */
int,            /* yyyy  */
int,            /* doy  */
int                /* msec_d  */
);

EXPORT int TM_UR8_to_YMD(double,int *,int *,int *,int *,int *,int *,int *);
EXPORT int TM_UR8_from_YMD(double *,int,int,int,int,int,int,int);
EXPORT int TM_UR8_from_String_Comparison(double *,char *);
EXPORT int TM_UR8_to_String_Comparison(double,char *);
EXPORT int TM_UR8_to_String(double,char *);
EXPORT int TM_UR8_from_localtime(double *);

#endif /* LIBTM_H */
