
import java.nio.*;
import edu.umn.space.swaves.*;

/**
* This class will call the TM Lib methods and connect to the server and pull 
* packet events.  It will then produce an output of the form<br>
* <br>
* <xmp>
* 000001 2004.03.05 21:47:30.3 0d 01 c0 00 01 09 56 db 53 f2 56 00 00 00 ... 00 00
* 000002 2004.03.05 21:47:33.5 0d 04 c0 00 01 09 56 db 53 f5 8b 00 0b 00 ... 00 00
* 000003 2004.03.05 21:47:35.3 0d 01 c0 00 01 09 56 db 53 f7 56 00 00 00 ... 00 00
* 000004 2004.03.05 21:47:37.5 0d 04 c0 00 01 09 56 db 53 f9 8b 00 0b 00 ... 00 00
* 000005 2004.03.05 21:47:40.3 0d 01 c0 00 01 09 56 db 53 fc 56 00 00 00 ... 00 00
* 000006 2004.03.05 21:47:41.5 0d 04 c0 00 01 09 56 db 53 fd 8b 00 0b 00 ... 00 00
* 000007 2004.03.05 21:47:45.3 0d 01 c0 00 01 09 56 db 54 01 56 00 00 00 ... 00 00
* 000008 2004.03.05 21:47:45.5 0d 04 c0 00 01 09 56 db 54 01 8b 00 0b 00 ... 00 00
* 000009 2004.03.05 21:47:49.5 0d 04 c0 00 01 09 56 db 54 05 8b 00 0b 00 ... 00 00
* 000010 2004.03.05 21:47:50.3 0d 01 c0 00 01 09 56 db 54 06 56 00 00 00 ... 00 00
* </xmp>
* <br>
* <br>
* @author <a href="mailto:java@waves.space.umn.edu">Jeff Silvis</a> University of Minnesota
* @version .5  
*/



public class packets  {

private  TM TmLib = new TM();
private  int              ok;
private  int              BufferSize   = 2000;
private  IntBuffer        ItemI4Buffer = IntBuffer.allocate(BufferSize);
private  DoubleBuffer     ItemR8Buffer = DoubleBuffer.allocate(BufferSize);
private  CharBuffer       ErrorDump    = CharBuffer.allocate(BufferSize);
private  IntBuffer        numvals      = IntBuffer.allocate(1);
private  int              count        = 1;
private  IntBuffer        idbuf         = IntBuffer.allocate(1);
private  int        StreamID;
private  CharBuffer dateBuf = CharBuffer.allocate(BufferSize);
                                                                            
public packets () {
    ok = TmLib.TM_Select_Domain(idbuf,"stereo", "stereo_a", "swaves", "packet");
   errorHandle(ok);
   StreamID = idbuf.get();
 
}

/**
* This method will display the SCET date, the CCSDS header and a portion 
* of the CCSDS data.  Events will be taken and displayed in an infinite loop.
*/
public void showPackets() {
  // The contents of this string will be printed to stdout
  String outString; 
  // select a  file
  ok = TmLib.TM_Select_Stream(StreamID,"realtime");         
  errorHandle(ok);

while (true)  {
 ok = TmLib.TM_Find_Event(StreamID);                  
 errorHandle(ok);
  // running count of packets pulled since program started
 outString = this.getCountString();
 outString += " ";
 
 
 
 
 //      double sec1970 = (double) System.currentTimeMillis();
  //      sec1970 /= 1000.;
  //      sec1970 = Math.round(sec1970);
  //      int IntSec1970 = (int) sec1970;
  //  outString += " " + Integer.toString(IntSec1970) + " ";  
  
  
    
  // get the timestamp as a UR8 (UTC days since January 1, 1982)
  ok = TmLib.TM_Get_Item_R8(StreamID,"CCSDS_SCET_UR8",ItemR8Buffer,BufferSize,numvals);
  errorHandle(ok);
  dateBuf.clear();
  TmLib.TM_UR8_to_String(ItemR8Buffer.get(0), dateBuf);
  // Convert the UR8 timestamp to a user friendly string output
  outString +=  dateBuf.toString();

  // Pull the ccsds header and byte by byte append it to the output
  ok =TmLib.TM_Get_Item_I4(StreamID,"CCSDS_HEADER_BYTES",ItemI4Buffer,BufferSize,numvals);
  errorHandle(ok);
  for (int i = 0 ; i < numvals.get(0); i++) {
    outString += " " + getTwoDigitHexStr(ItemI4Buffer.get(i));
   }
   
   // Grab the data portion of the CCSDS packet (i.e. the meat) and 
   // append to the output the first 2 bytes of the data region
   ok =TmLib.TM_Get_Item_I4(StreamID,"CCSDS_MEAT",ItemI4Buffer,BufferSize,numvals);
   errorHandle(ok);
   for (int i = 0; i < 1  ; i++) {
    outString += " " + getTwoDigitHexStr(ItemI4Buffer.get(i));
   }
    
    // spacer to indicate that some of the ccsds data has been skipped
    outString +=  " ...";
    
   // grab the last two bytes of the data region of the ccsds packet and 
   // append it to the output.
   for (int i = ItemI4Buffer.limit() - 2; i < ItemI4Buffer.limit()  ; i++) {
    outString += " " + getTwoDigitHexStr(ItemI4Buffer.get(i));
   }
  ok =TmLib.TM_Get_Item_I4(StreamID,"CCSDS_ENTIRE_PACKET",ItemI4Buffer,BufferSize,numvals);
     outString += 
      " (" + this.getTwoDigitHexStr(this.checkSum(ItemI4Buffer)) + ")";


  System.out.println(outString);
 }
}


private int checkSum(IntBuffer BuffToCheck){
  int chksum = 0;
   for (int i = 0 ; i < BuffToCheck.limit()  ; i++) {
    chksum +=  BuffToCheck.get(i);
   }
  return chksum  & 0XFF ;
}





/**
* This method produes a counter for the output.  It will rollever at 
* 1000000 and will pad the the number with 0's to ensure that it is 
* six digits long
*/
private String getCountString(){
  String StrCount;
  if (count == 1000000) count = 1;
  StrCount = Integer.toString(count);
  while (StrCount.length() < 6 ) StrCount = "0" + StrCount; 
  count++;
 return StrCount;
}

/**
* This method will take an in and convert it to hex.  If the 
* result is a single hex digit, it will be prepended by a zero.
*/
private String getTwoDigitHexStr(int IntHex){
    String stHex = Integer.toHexString(IntHex) ;
    if (stHex.length() != 2 ) stHex = "0"+ stHex;
    return stHex;
}

/**
* If the output from any of the TM Library methods (the "ok" int) is nonzero 
* this method will produce a more detailed error message for the user.  If the 
* error message indicates that the error was fatal.  This method will exit the
* process.
* @param ok The error value from one of the TM Lib methods.
*/

public void errorHandle(int ok){
  if (ok != 0 ) 
  {  
       int ErrorValue = ok;
       ok = TmLib.TM_Error_Stack(StreamID,"verbose", ErrorDump,BufferSize, numvals);
       System.out.println( ErrorDump.toString());
       //
       // find out if the error was fatal
        if (ErrorValue < 0 ) {
           System.out.println("The error was fatal");
           System.out.println("Exiting this process");
           System.out.println("Bye");
           System.exit(0);
       } 
       else
         { 
          System.out.println("The error was not fatal");
          System.out.println("This process will continue");
          try {
              Thread.sleep(5000); 
              } catch (java.lang.InterruptedException e) 
              { e.printStackTrace(); }
       }
  }
}

/**
*/
public  static void main(String[] args) {
 packets packetDisplay = new packets();
 packetDisplay.showPackets();
}  // end main function

    
}
