
import java.io.*;
import java.nio.*;
import edu.umn.space.swaves.*;


/**
* 
* The user will select a value of CCSDS_DATAFRMT_ID.  If a given 
* packet matches has a  CCSDS_DATAFRMT_ID that matches the value desired 
* by the user then the CCSDS packet will be dumped to stdout in the format 
* shown below:
*
* <xmp>
* 2003.11.03 18:30:03  DataFormatId: 3
* 00000   0d 03 c0 00 01 09 56 39 51 8b    3c 1d 01 c0 00 00 09 00 00 00
* 00020   00 00 00 00 01 02 03 00 00 00    00 00 00 00 00 00 00 00 00 00
* 00040   00 00 00 00 00 00 00 00 00 00    00 00 00 00 00 00 00 00 00 00
* 00060   00 00 00 00 00 00 00 00 00 00    00 00 00 00 00 00 00 00 00 00
* 00080   00 00 00 00 00 00 00 00 00 00    00 00 00 00 00 00 00 00 00 00
* 00100   00 00 00 00 00 00 00 00 00 00    00 00 00 00 00 00 00 00 00 00
* 00120   00 00 00 00 00 00 00 00 00 00    00 00 00 00 00 00 00 00 00 00
* 00140   00 00 00 00 00 00 00 00 00 00    00 00 00 00 00 00 00 00 00 00
* 00160   00 00 00 00 00 00 00 00 00 00    00 00 00 00 00 00 00 00 00 00
* 00180   00 00 00 00 00 00 00 00 00 00    00 00 00 00 00 00 00 00 00 00
* 00200   00 00 00 00 00 00 00 00 00 00    00 00 00 00 00 00 00 00 00 00
* 00220   00 00 00 00 00 00 00 00 00 00    00 00 00 00 00 00 00 00 00 00
* 00240   00 00 00 00 00 00 00 00 00 00    00 00 02 00 00 00 00 00 00 00
* 00260   00 00 00 00 00 00 00 00 00 00    00 00
*-----------------------------------------------------------------------
* </xmp>
* <br>
* <br>
* @author <a href="mailto:java@waves.space.umn.edu">Jeff Silvis</a> University of Minnesota
* @version .5  
*/      
public class dump_packet  {
private  TM  TmLib = new TM();

private  int              ok;   // stores error value from TmLib methods
//
// Buffers to hold data from the TmLib server
private  int              BufferSize   = 2000;
private  IntBuffer        ItemI4Buffer = IntBuffer.allocate(BufferSize);
private  DoubleBuffer     ItemR8Buffer = DoubleBuffer.allocate(BufferSize);
private  CharBuffer       ErrorDump    = CharBuffer.allocate(BufferSize);
private  CharBuffer       dateBuf      = CharBuffer.allocate(BufferSize);
private  IntBuffer        numvals      = IntBuffer.allocate(1);
private  IntBuffer      idbuf        = IntBuffer.allocate(1);
private int StreamID;
                                                                            

private int DataFormatId ;       // CCSDS_DATAFRMT_ID for a given packet
private int DesiredDataFormatId; // the DataFormatId desired by the user
private String outString ;

public dump_packet () {
  ok = TmLib.TM_Select_Domain(idbuf, "stereo", "stereo_a", "swaves", "packet");
  errorHandle(ok);
  StreamID = idbuf.get();
 
}
/**
* Sets the desired value of the CCSDS_DATAFRMT_ID item.
*@param inputDataFormatId If a CCSDS packet has a CCSDS_DATAFRMT_ID that
* matches this value, then all the bytes in the CCSDS packet will be sent
* to stdout.
*/
public void setDesiredDataFormatId(int inputDataFormatId) {
DesiredDataFormatId = inputDataFormatId;
}

/**
* This method will loop forever and print out the all the bytes int 
* a CCSDS packet whose CCSDS_DATAFRMT_ID item matches the user's input.
*/
public void showPackets() {
// 
// open a stream
ok = TmLib.TM_Select_Stream(StreamID,"realtime");         
errorHandle(ok);
//
// Take packets forever
while (true)  {
  ok = TmLib.TM_Find_Event(StreamID);                  
  errorHandle(ok);
  // get the timestamp as a UR8 (UTC days since January 1, 1982)
  ok = TmLib.TM_Get_Item_R8(StreamID,"CCSDS_SCET_UR8",ItemR8Buffer,BufferSize,numvals);
  errorHandle(ok);
  // Convert the UR8 timestamp to a user friendly string output
  dateBuf.clear();
 TmLib.TM_UR8_to_String(ItemR8Buffer.get(0), dateBuf);
 outString = dateBuf.toString();
  
 ok = TmLib.TM_Get_Item_I4(StreamID,"CCSDS_DATAFRMT_ID",ItemI4Buffer,BufferSize,numvals);
 errorHandle(ok);
 DataFormatId = ItemI4Buffer.get(0);
 outString += "  DATAFRMT_ID: " + DataFormatId;
 //
 // print the Date Stamp and the DATAFRMT_ID
 System.out.println(outString);
 if (DataFormatId == DesiredDataFormatId ) {
     this.sendAllCcsdsBytesPacketToStdout();
  } // end of if that checks DataFormatId 
 } // end of infinite while
}


/**
* This method formats the CCSDS packet and sends it to stdout.  An example of the 
* format can be seen at the top of this document.
*/

private void sendAllCcsdsBytesPacketToStdout(){
  ok = TmLib.TM_Get_Item_I4(StreamID,"CCSDS_ENTIRE_PACKET",ItemI4Buffer,BufferSize,numvals);
  errorHandle(ok);
  outString = " "; 
  int count = 0;
  String StrCount;
  int bufferLength = numvals.get(0);
  //
  // Dump to a string all the rows that contain exactly 20 bytes
  for (int i = 0; i < bufferLength / 20 ; i++){
     // The counter at the head of the row
     StrCount = Integer.toString(count*20);
     while (StrCount.length() < 5 ) StrCount = "0" + StrCount; 
     outString +=  StrCount + "  ";
     outString +=  this.next10BytesAsHexString(ItemI4Buffer) +  "   "; 
     outString +=  this.next10BytesAsHexString(ItemI4Buffer)  + "\n "; 
     count++;
  } // end of the for that covers an even multiples of 20 
 //
 // Now take care of extra bytes on the end if we don't have a multiple of 20.
  int NumBytesInLastRow = bufferLength % 20;
  if (NumBytesInLastRow != 0 ) {
     // 
    // The counter at the head of the row     
    StrCount = Integer.toString(count*20);
    while (StrCount.length() < 5 ) StrCount = "0" + StrCount; 
    outString +=  StrCount + "  ";
    
    if (NumBytesInLastRow < 10 ) {
      for (int i = 0; i < NumBytesInLastRow ; i++){
          outString += this.getTwoDigitHexStr(ItemI4Buffer.get());
        }
    } else {
       outString += next10BytesAsHexString(ItemI4Buffer); 
       outString +=  "   ";
      for (int i = 0; i < (NumBytesInLastRow - 10)  ; i++){
         outString +=   this.getTwoDigitHexStr(ItemI4Buffer.get());
        } 
    }
    }
   
   ok =TmLib.TM_Get_Item_I4(StreamID,"CCSDS_ENTIRE_PACKET",ItemI4Buffer,BufferSize,numvals);
   outString += 
      " (" + this.getTwoDigitHexStr(this.checkSum(ItemI4Buffer)) + ")";

  System.out.println(outString);  
   
     
   System.out.println
    ("-----------------------------------------------------------------------");
}



private int checkSum(IntBuffer BuffToCheck){
  int chksum = 0;
   for (int i = 0 ; i < BuffToCheck.limit()  ; i++) {
    chksum +=  BuffToCheck.get(i);
   }
  return chksum  & 0XFF ;
}



/**
* This helper method will take a block of 10 bytes and convert them 
* to a formated string. 
*/
private String next10BytesAsHexString(IntBuffer BufferToDump) {
String TempString = "";
for (int j = 0; j < 10 ; j ++) {
    TempString += this.getTwoDigitHexStr(BufferToDump.get());
 }
 return TempString;
}



/**
* This method will take an in and convert it to hex.  If the 
* result is a single hex digit, it will be prepended by a zero.
*/
private String getTwoDigitHexStr(int IntHex){
  String stHex = Integer.toHexString(IntHex) ;
  if (stHex.length() != 2 ) stHex = "0"+ stHex ;
  stHex = " " + stHex;
  return  stHex;
}



public void errorHandle(int ok){
  if (ok != 0 ) 
  {  
       int ErrorValue = ok;
       ok = TmLib.TM_Error_Stack(StreamID,"verbose", ErrorDump,BufferSize, numvals);
       System.out.println( ErrorDump.toString());
       //
       // find out if the error was fatal
        if (ErrorValue < 0 ) {
           System.out.println("Error Number: " + ErrorValue);
           System.out.println("The error was fatal");
           System.out.println("Exiting this process");
           System.out.println("Bye");
           System.exit(0);
       } 
       else
         { 
          System.out.println("Error Number: " + ErrorValue);
          System.out.println("The error was not fatal");
          System.out.println("This process will continue");
          try {
              Thread.sleep(5000); 
              } catch (java.lang.InterruptedException e) 
              { e.printStackTrace(); }
       }
     ok = TmLib.TM_Error_Stack(StreamID,"stacktrace", ErrorDump,BufferSize, numvals);
       System.out.println( ErrorDump.toString()); 
  }
}
/**
* Interactively allows the user to select a value for the CCSDS_DATAFRMT_ID 
* item.
*/
public static void main(String[] args) {
 dump_packet packetDisplay = new dump_packet();
 BufferedReader userIn
          = new BufferedReader( new InputStreamReader(System.in)); 
 String CmdString ;
     try {
        System.out.print("Select DATAFRMT_ID > ");
        CmdString =  userIn.readLine();
        packetDisplay.setDesiredDataFormatId(Integer.parseInt(CmdString)) ; 
       } catch (IOException err) {
        err.printStackTrace();
       }
  packetDisplay.showPackets();
  }  // end main function
}



