; language: IDL
; filename: errorstack_demo_idl.pro

pro errorstack_demo_idl
    ErrorBuffSize = 2500

    err = TM_Select_Domain(stream_id, 'stereo', 'stereo_a', 'swaves', 'packet')
    err = TM_Select_Stream(stream_id, 'realtime')

    err = TM_Find_Event(stream_id)

    ; There isn't an item named aaaaTTTTxxxQ
    err = TM_Get_Item_I4(stream_id, "aaaaTTTTxxxQ", itemBuffer, 1, size)
    if (err ne 0) then begin
        print, "Error = ", err

        err = TM_Error_Stack(stream_id, "name", ErrorDump, ErrorBuffSize, size)
        print, "Error Name = ", ErrorDump

        err = TM_Error_Stack(stream_id, "description", ErrorDump, ErrorBuffSize, size)
        print, "Error Description = ", ErrorDump

        err = TM_Error_Stack(stream_id, "message", ErrorDump, ErrorBuffSize, size)
        print, "Error Message = ", ErrorDump

        err = TM_Error_Stack(stream_id, "code", ErrorDump, ErrorBuffSize, size)
        print, "Error Code = ", ErrorDump
    endif
end
