/*
 * language: C
 * filename: errorstack_demo_c.c
 */

#include <stdio.h>

#include "libTM.h"

int 
main(void)
{
    int             err, size, itemBuffer[1], ErrorBuffSize = 2500;
    uint32_t        stream_id;
    char            ErrorDump[2500];

    TM_Select_Domain(&stream_id, "stereo", "stereo_a", "swaves", "packet");
    TM_Select_Stream(stream_id, "realtime");

    TM_Find_Event(stream_id);

    /* There isn't an item named aaaaTTTTxxxQ */
    err = TM_Get_Item_I4(stream_id, "aaaaTTTTxxxQ", itemBuffer, 1, &size);
    if (err != 0) {
        printf("Error = %d\n", err);

        TM_Error_Stack(stream_id, "name", ErrorDump, ErrorBuffSize, &size);
        printf("Error Name = %s\n", ErrorDump);

        TM_Error_Stack(stream_id, "description", ErrorDump, ErrorBuffSize, &size);
        printf("Error Description = %s\n", ErrorDump);

        TM_Error_Stack(stream_id, "message", ErrorDump, ErrorBuffSize, &size);
        printf("Error Message = %s\n", ErrorDump);

        TM_Error_Stack(stream_id, "code", ErrorDump, ErrorBuffSize, &size);
        printf("Error Code = %s\n", ErrorDump);

    }
    return 0;
}
