/**
*
* The user will select a value of CCSDS_DATAFRMT_ID.  If a given
* packet matches has a  CCSDS_DATAFRMT_ID that matches the value desired
* by the user then the CCSDS packet will be dumped to stdout in the format
* shown below:
*
* 2003.11.03 18:30:03  DataFormatId: 3
* 00000   0d 03 c0 00 01 09 56 39 51 8b    3c 1d 01 c0 00 00 09 00 00 00
* 00020   00 00 00 00 01 02 03 00 00 00    00 00 00 00 00 00 00 00 00 00
* 00040   00 00 00 00 00 00 00 00 00 00    00 00 00 00 00 00 00 00 00 00
* 00060   00 00 00 00 00 00 00 00 00 00    00 00 00 00 00 00 00 00 00 00
* 00080   00 00 00 00 00 00 00 00 00 00    00 00 00 00 00 00 00 00 00 00
* 00100   00 00 00 00 00 00 00 00 00 00    00 00 00 00 00 00 00 00 00 00
* 00120   00 00 00 00 00 00 00 00 00 00    00 00 00 00 00 00 00 00 00 00
* 00140   00 00 00 00 00 00 00 00 00 00    00 00 00 00 00 00 00 00 00 00
* 00160   00 00 00 00 00 00 00 00 00 00    00 00 00 00 00 00 00 00 00 00
* 00180   00 00 00 00 00 00 00 00 00 00    00 00 00 00 00 00 00 00 00 00
* 00200   00 00 00 00 00 00 00 00 00 00    00 00 00 00 00 00 00 00 00 00
* 00220   00 00 00 00 00 00 00 00 00 00    00 00 00 00 00 00 00 00 00 00
* 00240   00 00 00 00 00 00 00 00 00 00    00 00 02 00 00 00 00 00 00 00
* 00260   00 00 00 00 00 00 00 00 00 00    00 (00)
*-----------------------------------------------------------------------
*/

#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#include <libTM.h>

#define MAXBUFSIZE 2000

void            do_error(uint32_t, int32_t);
void            doit(int);
void            usage(const char *);

char            stream[MAXBUFSIZE];

int
main(int argc, char *argv[])
{
    int             id, err;
    char           *s, progname[MAXBUFSIZE];

    strcpy(stream, "realtime");
    strcpy(progname, *argv);

    while (--argc > 0 && (*++argv)[0] == '-') {
        for (s = argv[0] + 1; *s != '\0'; s++) {
            switch (*s) {
                case 'h':
                    usage(progname);
                    exit(0);
                    break;
                case 'c':
                    strcpy(stream, "chooser");
                    break;
                default:
                    usage(progname);
                    exit(0);
                    break;
            }
        }
    }

    (void) printf("Select DATAFRMT_ID> ");
    (void) fflush(stdout);
    if ((err = fscanf(stdin, "%i", &id)) == 0) {
        (void) fprintf(stderr, "Error reading input.\n");
        (void) fflush(stderr);
        exit(-1);
    }
    doit(id);
    return (0);
}

void
doit(int id)
{
    char            mesg[MAXBUFSIZE];
    int             j;
    int32_t         chksum, intbuf[MAXBUFSIZE];
    int32_t         err, numvals;
    uint32_t        sid, count = 0;
    double          doublebuf[MAXBUFSIZE];

    if ((err = TM_Select_Domain(&sid, "stereo", "stereo_a", "swaves", "packet")) != 0)
        do_error(sid, err);

    if ((err = TM_Select_Stream(sid, stream)) != 0)
        do_error(sid, err);

    for (;;) {
        if ((err = TM_Find_Event(sid)) != 0)
            do_error(sid, err);

        if ((err = TM_Get_Item_R8(sid, "CCSDS_SCET_UR8", doublebuf, MAXBUFSIZE, &numvals)) != 0)
            do_error(sid, err);
        if ((err = TM_UR8_to_String(doublebuf[0], mesg)) != 0)
            do_error(sid, err);

        if ((err = TM_Get_Item_I4(sid, "CCSDS_DATAFRMT_ID", intbuf, MAXBUFSIZE, &numvals)) != 0)
            do_error(sid, err);

        (void) printf("%s DATAFRMT_ID: %d\n", mesg, *intbuf);

        /* print out the entire packet if the ids match */
        if (id == *intbuf) {

            if ((err = TM_Get_Item_I4(sid, "CCSDS_ENTIRE_PACKET", intbuf, MAXBUFSIZE, &numvals)) != 0)
                do_error(sid, err);

            printf("%05d", count);
            for (j = 0; j < numvals; j++) {
                if ((j != 0) && (j % 20 == 0)) {
                    count += 20;
                    printf("\n%05d   ", count);
                } else if (j % 10 == 0)
                    printf("   ");
                printf("%02x ", intbuf[j]);
            }

            chksum = 0;
            for (j = 0; j < numvals; j++)
                chksum += intbuf[j];

            (void) printf("(%02x)", chksum & 0xFF);

            count = 0;
            printf("\n");
        }
        fflush(stdout);
    }
    return;
}

void
do_error(uint32_t sid, int32_t err)
{
    char            mesg[MAXBUFSIZE];
    int32_t         numvals;
    int             isc;

    if (err == 0)
        return;

    if ((isc = TM_Error_Stack(sid, "name", mesg, MAXBUFSIZE, &numvals)) == 0)
        (void) fprintf(stderr, "Error Name: %s\n", mesg);
    else
        (void) fprintf(stderr, "Fatal error. Cound not get Error Stack.\n");
    if ((isc = TM_Error_Stack(sid, "message", mesg, MAXBUFSIZE, &numvals)) == 0)
        (void) fprintf(stderr, "Error Message: %s\n", mesg);
    else
        (void) fprintf(stderr, "Fatal error. Cound not get Error Stack.\n");
    if ((isc = TM_Error_Stack(sid, "description", mesg, MAXBUFSIZE, &numvals)) == 0)
        (void) fprintf(stderr, "Error Description: %s\n", mesg);
    else
        (void) fprintf(stderr, "Fatal error. Cound not get Error Stack.\n");
    if ((isc = TM_Error_Stack(sid, "code", mesg, MAXBUFSIZE, &numvals)) == 0)
        (void) fprintf(stderr, "Error Code: %s\n", mesg);
    else
        (void) fprintf(stderr, "Fatal error. Cound not get Error Stack.\n");
    (void) fflush(stderr);
    exit(-1);
}

void
usage(const char *progname)
{
    fprintf(stderr, "usage: %s [-c] [-h]\n", progname);
    fprintf(stderr, "-h\t\tThis message.\n");
    fprintf(stderr, "-c\t\tUse chooser to select stream.\n");
}
