/*
 * language: C
 * filename: chooser_demo.c
 */
#include <stdio.h>

#include "libTM.h"

int
main(void)
{
    int             err = 0, size, ccsds_apid;
    uint32_t        stream_id;

    err = TM_Select_Domain(&stream_id, "stereo", "stereo_a", "swaves", "packet");
    err = TM_Select_Stream(stream_id, "chooser");

    /* loop until no more events */
    while (err == 0) {
        err = TM_Find_Event(stream_id);

        TM_Get_Item_I4(stream_id, "CCSDS_APID", &ccsds_apid, 1, &size);

        printf("APID: %d\n", ccsds_apid);
    }
    printf("file read\n");
    return 0;
}
