/**
* This class will call the TM Lib methods and connect to the server and pull
* packet events.  It will then produce an output of the form:
*
* 000001 2004.03.05 21:47:30.3 0d 01 c0 00 01 09 56 db 53 f2 56 00 00 00 ... 00 00
* 000002 2004.03.05 21:47:33.5 0d 04 c0 00 01 09 56 db 53 f5 8b 00 0b 00 ... 00 00
* 000003 2004.03.05 21:47:35.3 0d 01 c0 00 01 09 56 db 53 f7 56 00 00 00 ... 00 00
* 000004 2004.03.05 21:47:37.5 0d 04 c0 00 01 09 56 db 53 f9 8b 00 0b 00 ... 00 00
* 000005 2004.03.05 21:47:40.3 0d 01 c0 00 01 09 56 db 53 fc 56 00 00 00 ... 00 00
* 000006 2004.03.05 21:47:41.5 0d 04 c0 00 01 09 56 db 53 fd 8b 00 0b 00 ... 00 00
* 000007 2004.03.05 21:47:45.3 0d 01 c0 00 01 09 56 db 54 01 56 00 00 00 ... 00 00
* 000008 2004.03.05 21:47:45.5 0d 04 c0 00 01 09 56 db 54 01 8b 00 0b 00 ... 00 00
* 000009 2004.03.05 21:47:49.5 0d 04 c0 00 01 09 56 db 54 05 8b 00 0b 00 ... 00 00
* 000010 2004.03.05 21:47:50.3 0d 01 c0 00 01 09 56 db 54 06 56 00 00 00 ... 00 00
*
*/

#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#include <libTM.h>

#define MAXBUFSIZE 2000

void            do_error(uint32_t, int32_t);
void            usage(const char *);

int
main(int argc, char *argv[])
{
    char             stream[MAXBUFSIZE], progname[MAXBUFSIZE],
                   *s;
    int32_t         err, numvals;
    uint32_t        sid;
    double          doublebuf[MAXBUFSIZE];

    strcpy(stream, "+level_zero/STEREO/Behind/SWAVES/swaves_behind_2006_350_1_02.ptp");
    strcpy(progname, *argv);

    while (--argc > 0 && (*++argv)[0] == '-') {
        for (s = argv[0] + 1; *s != '\0'; s++) {
            switch (*s) {
                case 'h':
                    usage(progname);
                    exit(0);
                    break;
                case 'c':
                    strcpy(stream, "chooser");
                    break;
                default:
                    usage(progname);
                    exit(0);
                    break;
            }
        }
    }

    if ((err = TM_Select_Domain(&sid, "stereo", "stereo_a", "swaves", "packet")) != 0)
        do_error(sid, err);

    if ((err = TM_Select_Stream(sid, stream)) != 0)
        do_error(sid, err);

    for (;;) {
        if ((err = TM_Find_Event(sid)) != 0)
            do_error(sid, err);

        if ((err = TM_Get_Item_R8(sid, "CCSDS_SCET_UR8", doublebuf, MAXBUFSIZE, &numvals)) != 0)
            do_error(sid, err);
        printf("%16.12f\n", doublebuf[0]);
    }
    TM_Close(sid);
    return (0);
}

void
do_error(uint32_t sid, int32_t err)
{
    char            mesg[MAXBUFSIZE];
    int32_t         numvals;
    int             isc;

    if (err == 0)
        return;

    if ((isc = TM_Error_Stack(sid, "name", mesg, MAXBUFSIZE, &numvals)) == 0)
        (void) fprintf(stderr, "Error Name: %s\n", mesg);
    else
        (void) fprintf(stderr, "Fatal error. Cound not get Error Stack.\n");
    if ((isc = TM_Error_Stack(sid, "message", mesg, MAXBUFSIZE, &numvals)) == 0)
        (void) fprintf(stderr, "Error Message: %s\n", mesg);
    else
        (void) fprintf(stderr, "Fatal error. Cound not get Error Stack.\n");
    if ((isc = TM_Error_Stack(sid, "description", mesg, MAXBUFSIZE, &numvals)) == 0)
        (void) fprintf(stderr, "Error Description: %s\n", mesg);
    else
        (void) fprintf(stderr, "Fatal error. Cound not get Error Stack.\n");
    if ((isc = TM_Error_Stack(sid, "code", mesg, MAXBUFSIZE, &numvals)) == 0)
        (void) fprintf(stderr, "Error Code: %s\n", mesg);
    else
        (void) fprintf(stderr, "Fatal error. Cound not get Error Stack.\n");
    (void) fflush(stderr);

    if (err < 0) {
        TM_Close(sid);
        exit(-1);
    }
}

void
usage(const char *progname)
{
    fprintf(stderr, "usage: %s [-c] [-h]\n", progname);
    fprintf(stderr, "-h\t\tThis message.\n");
    fprintf(stderr, "-c\t\tUse chooser to select stream.\n");
}
