;-------------------------------------------------------------------------------
PRO extract_html_links,	$
;-------------------------------------------------------------------------------
	s,			$	; LINT_PROTOTYPE input
	nlinks,			$	; LINT_PROTOTYPE input
	links,			$	; LINT_PROTOTYPE input
	datelinks,		$	; LINT_PROTOTYPE input
	taillelinks,		$	; LINT_PROTOTYPE input
	relative=relative 		; LINT_PROTOTYPE input
;-------------------------------------------------------------------------------
; Extrait les noms, dates et tailles des liens trouvs dans les balises <a href> d'une chaine de caractres.
;-------------------------------------------------------------------------------

	;compile_opt  idl2,hidden

	p0 = STRPOS(STRLOWCASE(s),'<a href="')
	IF p0 GE 0 THEN BEGIN
		p1 = STRPOS(s,'">',p0)
		IF p1 GE p0+9 THEN BEGIN
			link = STRMID(s,p0+9,p1-p0-9)
			bad = STRLEN(link) EQ 0
			IF KEYWORD_SET(relative) THEN bad = (STRPOS(link,'?') GE 0) OR bad
			IF KEYWORD_SET(relative) THEN bad = (STRPOS(link,'*') GE 0) OR bad
			IF KEYWORD_SET(relative) THEN bad = (STRPOS(link,'/') EQ 0) OR bad   ; remove absolute links (which start with '/')
			IF ~bad THEN BEGIN
				IF nlinks EQ N_ELEMENTS(links) THEN BEGIN
					; on augmente la taille des tableaux links, datelinks et taillelinks
					links1 = REPLICATE ('', nlinks*2)
					links1[0:nlinks-1] = links
					links = links1
					datelinks1 = REPLICATE ('', nlinks*2)
					datelinks1[0:nlinks-1] = datelinks
					datelinks = datelinks1
					taillelinks1 = REPLICATE ('', nlinks*2)
					taillelinks1[0:nlinks-1] = taillelinks
					taillelinks = taillelinks1
				END
				links[nlinks] = link ; lien
				p2 = STRPOS(STRLOWCASE(s),'</a>',p1)
				IF p2 GE 0 THEN BEGIN
					tmp = supprimer_tags(STRMID(s,p2))
					tmp = STRSPLIT(tmp,' ',/extract)
					IF N_ELEMENTS(tmp) GE 3 THEN BEGIN
						datelinks[nlinks] = tmp[0]+' '+tmp[1]	; date
						taillelinks[nlinks] = tmp[2]		; taille
					END
				END
				nlinks++
			END
		END
	END

END


;-------------------------------------------------------------------------------
FUNCTION file_extract_html_links,		$
;-------------------------------------------------------------------------------
	filename,			$	; LINT_PROTOTYPE input
	count,				$	; LINT_PROTOTYPE [output]
	datelinks=datelinks,		$	; LINT_PROTOTYPE output
	taillelinks=taillelinks			; LINT_PROTOTYPE output
;-------------------------------------------------------------------------------
; Retourne les noms, dates et tailles des liens <a href> trouvs dans un fichier html.
;-------------------------------------------------------------------------------

	count = 0                                   ; this should only return the relative links.
	ON_IOERROR, badfile
	OPENR,lun,filename,/get_lun
	s = ''
	links = REPLICATE ('',1000)
	datelinks = REPLICATE ('',1000)
	taillelinks = REPLICATE ('',1000)
	nlinks = 0L
	WHILE ~EOF(lun) DO BEGIN
		READF,lun,s
		extract_html_links,s,nlinks,links,datelinks,taillelinks,/relative
	END
	links		= nlinks EQ 0 ? '' : links[0:nlinks-1]
	datelinks	= nlinks EQ 0 ? '' : datelinks[0:nlinks-1]
	taillelinks	= nlinks EQ 0 ? '' : taillelinks[0:nlinks-1]
	FREE_LUN,lun
	bad = STRLEN(links) EQ 0
	w = WHERE(bad EQ 0,count)

	RETURN,count GT 0 ? links[w] : ''

badfile:
	dprint,dlevel=1,'Bad file: '+filename

	RETURN,''

END


;-------------------------------------------------------------------------------
PRO file_http_header_info, 	$
;-------------------------------------------------------------------------------
	header,			$	; LINT_PROTOTYPE input
	hi,			$	; LINT_PROTOTYPE output
	verbose=verbose			; LINT_PROTOTYPE input
;-------------------------------------------------------------------------------
; MIME type recognition
;-------------------------------------------------------------------------------

	;  hi.url = url
	IF STRMID(hi.url,0,1,/reverse_offset) EQ '/' THEN hi.directory = 1
	hi.ltime = SYSTIME(1)
	IF ~KEYWORD_SET(header) THEN RETURN  ;,hi

	; get server time (date)
	tok = 'DATE:'
	ltok = STRLEN(tok)
	def = STRUPCASE(STRMID(header,0,ltok))
	g = WHERE(def EQ tok, Ng)
	date = Ng GT 0 ? (STRMID(header[g[0]], ltok, STRLEN(header[g[0]])-1)) : ''
	hi.atime = str2time(date, informat='DMYhms')
	hi.clock_offset = hi.atime - hi.ltime
	dprint,dlevel=6,verbose=verbose,'date=',date

	; Look for successful return
	pos = STRPOS(STRUPCASE(header[0]),'200 OK')
	hi.exists = pos GE 0
	IF ~hi.exists THEN BEGIN
		pos = STRPOS(STRUPCASE(header[0]),'302 FOUND')
		IF pos GE 0 THEN dprint,dlevel=0,verbose=verbose,'Redirection: Open a browser and log into network.'
		RETURN  ;,hi
	END

	hi.class = 'text'
	hi.type = 'simple'               ; in case no information found...
	def = STRUPCASE(STRMID(header,0,13))
	g = WHERE(def EQ 'CONTENT-TYPE:', Ng)
	IF Ng GT 0 THEN BEGIN
		ClassAndType = STRMID(header[g[0]], 14, STRLEN(header[g[0]])-1)
		hi.Class = (STRSPLIT(ClassAndType, '/', /extract))[0]
		hi.Type = (STRSPLIT(ClassAndType, '/', /extract))[1]
	END

	; get file modification time
	tok = 'LAST-MODIFIED:'
	ltok = STRLEN(tok)
	def = STRUPCASE(STRMID(header,0,ltok))
	g = WHERE(def EQ tok, Ng)
	last_modified = Ng GT 0 ? (STRMID(header[g[0]], ltok, STRLEN(header[g[0]])-1)) : ''
	hi.mtime = KEYWORD_SET(last_modified) ? str2time(last_modified, informat='DMYhms') : SYSTIME(1)
	dprint,dlevel=6,verbose=verbose,'last_modified=',last_modified

	; Try to determine length
	def = STRUPCASE(STRMID(header,0,15))
	g = WHERE(def EQ 'CONTENT-LENGTH:', Ng)
	hi.size = Ng GT 0 ? LONG64(STRMID(header[g[0]], 15, STRLEN(header[g[0]])-1)) : -1

	RETURN 

END

;-------------------------------------------------------------------------------
PRO file_https_copy,	$
;-------------------------------------------------------------------------------
	pathname,				$	; LINT_PROTOTYPE input
	localdir,				$	; LINT_PROTOTYPE input
	verbose=verbose,			$	; LINT_PROTOTYPE input
	user_agent=user_agent,			$	; LINT_PROTOTYPE input
	authorization=authorization,		$	; LINT_PROTOTYPE input
	general=general,			$	; LINT_PROTOTYPE input
	msg=msg,				$	; LINT_PROTOTYPE input
	readonly=readonly,			$	; LINT_PROTOTYPE input
	silence=silence,			$	; LINT_PROTOTYPE input
	localname=localname,			$	; LINT_PROTOTYPE output
	links=links2,				$	; LINT_PROTOTYPE output
	datelinks=datelinks2,			$	; LINT_PROTOTYPE output
	taillelinks=taillelinks2,		$	; LINT_PROTOTYPE output
	error=error,				$	; LINT_PROTOTYPE output
	header=header,				$	; LINT_PROTOTYPE output
	telecharge=telecharge				; LINT_PROTOTYPE output
;-------------------------------------------------------------------------------
; Tlcharge par https un fichier ou retourne les noms, dates et tailles des liens d'un rpertoire.
;-------------------------------------------------------------------------------

	; voir general/spedas_tools/spd_download/spd_download_file.pro

	net_object = OBJ_NEW('IDLNETURL')
	url_struct = PARSE_URL(pathname)

	user_agent = N_ELEMENTS(user_agent) NE 0 ? user_agent : 'IDL ' + !VERSION.RELEASE + ' on ' + !VERSION.OS + '/' + !VERSION.ARCH
	headers = user_agent

	IF STRMID(url_struct.path,0,1,/reverse_offset) NE '/' THEN BEGIN
		localname = localdir + basename(pathname)
		lcl = my_file_info(localname)
		lcl_date = lcl.mtime*1000d + tu_to_date(1970,1,1,0,0,0)-tu_to_date(1958,1,1,0,0,0)
		dow = LONG (lcl_date / 86400000d) MOD 7 ; Le premier janvier 1958 tait un mercredi
		sdow = ['Wed','Thu','Fri','Sat','Sun','Mon','Tue']
		smois = ['Jan','Feb','Mar','Apr','May','Jun','Jul','Aug','Sep','Oct','Nov','Dec']
		date_to_tu, lcl_date, annee, mois, jour, heure, minute, seconde
		if_modified_since = 'If-Modified-Since: ' + sdow[dow] + ', ' + int_str_0(jour,2) + ' ' + smois[mois-1] + ' ' + int_str_0(annee,4) + ' ' + $
				    int_str_0(heure,2) + ':' + int_str_0(minute,2) + ':' + int_str_0(LONG(seconde),2) + ' GMT'
		headers = [ headers , if_modified_since ]
	END

	IF STRMID(url_struct.path,0,1,/reverse_offset) EQ '/' THEN BEGIN
		localname = localdir + '.remote-index.html'
	END ELSE BEGIN
		localname = localdir + basename(pathname)
		localname += '.tmp'
	END
	;PRINT, pathname + ' -> ' + localname
	
	net_object -> setproperty,			$
		headers=headers,			$
		url_scheme=url_struct.scheme,		$
		url_host=url_struct.host,		$
		url_path=url_struct.path,		$
		url_query=url_struct.query,		$
		url_port=url_struct.port,		$
		url_username=url_struct.username,	$
		url_password=url_struct.password,	$
		timeout=30.0

	telecharge = 0
	CATCH, error
	net_object->getproperty, response_code=response_code, response_header=response_header, url_scheme=url_scheme
	IF response_code NE 0 THEN BEGIN
		IF response_code EQ 304 THEN BEGIN
			; Not Modified: ce n'est pas une erreur
			error = 0
			PRINT, pathname + ' -> ' + localname + ' NOT MODIFIED'
		END ELSE BEGIN
			PRINT, pathname + ' -> ' + localname + ' ' + !error_state.msg
			error = response_code
		END
	END ELSE BEGIN
		filepath = net_object -> get(filename=localname)
		IF error NE 0 THEN BEGIN
			CATCH, /CANCEL
			PRINT, pathname + ' -> ' + localname + ' ' + !error_state.msg
		END ELSE BEGIN
			telecharge = 1
			IF ARG_PRESENT(links2) THEN links2 = file_extract_html_links(localname,nlinks2,datelinks=datelinks2,taillelinks=taillelinks2)
			lines = N_ELEMENTS(links2)
			links2       = nlinks2 EQ 0 ? '' : links2[0:nlinks2-1]   ; get rid of first ''
			datelinks2   = nlinks2 EQ 0 ? '' : datelinks2[0:nlinks2-1]   ; get rid of first ''
			taillelinks2 = nlinks2 EQ 0 ? '' : taillelinks2[0:nlinks2-1]   ; get rid of first ''
		END
	END

	IF OBJ_VALID(net_object) THEN OBJ_DESTROY, net_object

END

;-------------------------------------------------------------------------------
PRO file_http_copy,	$
;-------------------------------------------------------------------------------
	pathname,				$	; LINT_PROTOTYPE input
	localdir,				$	; LINT_PROTOTYPE input
	verbose=verbose,			$	; LINT_PROTOTYPE input
	user_agent=user_agent,			$	; LINT_PROTOTYPE input
	authorization=authorization,		$	; LINT_PROTOTYPE input
	general=general,			$	; LINT_PROTOTYPE input
	msg=msg,				$	; LINT_PROTOTYPE input
	readonly=readonly,			$	; LINT_PROTOTYPE input
	silence=silence,			$	; LINT_PROTOTYPE input
	localname=localname,			$	; LINT_PROTOTYPE output
	links=links2,				$	; LINT_PROTOTYPE output
	datelinks=datelinks2,			$	; LINT_PROTOTYPE output
	taillelinks=taillelinks2,		$	; LINT_PROTOTYPE output
	error=error,				$	; LINT_PROTOTYPE output
	header=header,				$	; LINT_PROTOTYPE output
	telecharge=telecharge				; LINT_PROTOTYPE output
;-------------------------------------------------------------------------------
; Tlcharge par http un fichier ou retourne les noms, dates et tailles des liens d'un rpertoire.
;
; (1) Le fichier rcupr sera localdir+basename(pathname)+'.tmp'
; ex: file_http_copy,'http://interball2.cesr.fr:8001/software/cl/cl_version_latest', '/tmp/', localname=localname
;
; (2) Si pathname se termine par '/', alors le contenu du rpertoire sera mis dans localdir+'.remote-index.html.tmp', mais il sera dtruit  la fin.
; ex: file_http_copy,'http://interball2.cesr.fr:8001/software/cl/','/tmp/',links=links,datelinks=datelinks,taillelinks=taillelinks
;
; (3) Si pathname contient '?', c'est le cas dans les webservice, le fichier rcupr sera localdir+'a.out.tmp'
; ex: file_http_copy, 'http://msslkz.mssl.ucl.ac.uk/helio-ics/HelioQueryService?STARTTIME=2009-10-15T20:30:56&ENDTIME=2009-10-20T20:30:56&FROM=instrument_observatory', '/tmp/', localname=localname
;
; (4) Si pathname commence par 'http://caa.estec.esa.int/' alors traitement spcial pour le CAA
; ex: file_http_copy, 'http://caa.estec.esa.int/C1/CIS-HIA/C1_CP_CIS-HIA_HS_1D_PEF/2003/07/C1_CP_CIS-HIA_HS_1D_PEF_20030713_V01.cef.gz', '/tmp/', localname=localname
;
; (5) Si pathname ne commence pas par 'http://' et que pathname est un fichier
; ex: file_http_copy, '/var/www/html/penou/lint/lint.css', '/tmp/', localname=localname
;
; (6) Si pathname ne commence pas par 'http://' et que pathname est un rpertoire
; ex: file_http_copy, '/var/www/html/penou/lint/', '/tmp/', links=links
;
; Entres:
; --------
;
;	pathname				nom du fichier  tlcharger
;	localdir:				rpertoire destination qui doit se terminer par '/'
;	verbose=verbose:			(integer) Set level of verbose output.  (2 is typical)
;	user_agent=user_agent:			Contenu de 'User-Agent:' a envoyer au serveur, sinon une chaine avec la version d'IDL sera utilis
;	authorization=authorization:		Contenu de 'Authorization:' a envoy au serveur, sinon rien ne sera envoy
;	general=general:			Objet general de cl, utilis pour afficher des messages avec cl_msg() et savoir si l'utilisateur a cliqu sur arret
;	msg=msg:				Message de dbut qui sera utilis dans cl_msg()
;	readonly=readonly:			A positionner pour ne rien tlcharg
;	silence=silence:			Pour ne pas afficher de messages avec cl_msg()
;
; Sorties:
; --------
;	localname=localname:			Downloaded filenames are returned in this variable
;	links=links2:				links are returned in this variable if the file is an html file
;	datelinks=datelinks2,			date of links ar returned in this variable
;	taillelinks=taillelinks2:		size of links ar returned in this variable
;	error=error:				0 si OK, sinon PB
;	header=header:				tableau de string, peut-tre indfini si error est non nul
;							 La premire ligne pourra contenir par exemple:
;								'AAA BBB'
;								'200 OK'
;								'HTTP/1.1 401 Authorization Required'
;	telecharge=telecharge:			1 si le fichier a t tlcharg, 0 sinon
;-------------------------------------------------------------------------------

	DEBUG = 0

	IF N_ELEMENTS(silence)  EQ 0 THEN silence = 0
	IF N_ELEMENTS(readonly) EQ 0 THEN readonly = 0

	tstart = SYSTIME(1)

	telecharge = 0
	header = '200 OK'	; obligatoire car header doit tre dans tous les cas retourn  l'appellant
	error = 0		; pas d'erreur

	IF STRMID(pathname,0,7) NE 'http://' AND STRMID(pathname,0,8) NE 'https://' THEN BEGIN	; pathname ne commence pas par 'http://' ou 'https://'

		IF STRMID(pathname,STRLEN(pathname)-1,1) EQ '/' THEN BEGIN

			; Rpertoire: renvoyer les fichiers qu'il contient dans links2
			links2 = my_findfile (pathname+'*', /C)
			datelinks2 = REPLICATE ('',N_ELEMENTS(links2))

		END ELSE BEGIN

			; Fichier: le copier si ncessaire
			localname = localdir+basename(pathname)
			ldst = my_file_info(localname)
			lsrc = my_file_info(pathname)
			localname += '.tmp'
			IF (lsrc.size EQ ldst.size) AND (ldst.mtime GE lsrc.mtime) THEN BEGIN
			END ELSE BEGIN
				Mb = 2.^20
				percent = 0
				st1 = val_to_str_2decimales (lsrc.size/Mb)
				messstr = '  '+STRING(format='(f5.1," %  (",A," Mbytes)")', percent, st1, /print)
				IF N_ELEMENTS(general) NE 0 THEN BEGIN
					IF ~silence THEN cl_msg, general, str_bas=afficher_http(msg) + messstr
				END
				top1 = nbsec()
				error = copier (pathname, localname)
				IF error NE 0 THEN BEGIN
					; error vaut 1
					ON_IOERROR, copie_done
					OPENW, fd, localname, /GET_LUN ; qui devrait planter et crer un message d'erreur dans !error_state.msg
				END ELSE BEGIN
					percent = 100
					top2 = nbsec()
					rate = lsrc.size/Mb/(top2-top1)
					srate = val_to_str_2decimales (rate)
					messstr = '  '+STRING(format='(f5.1," %  (",A," Mbytes)  @ ",A," Mbytes/sec")', percent, st1, srate, /print)
					IF N_ELEMENTS(general) NE 0 THEN BEGIN
						IF ~silence THEN cl_msg, general, str_bas=afficher_http(msg) + messstr
					END
				END
				telecharge = 1
			END
		END
copie_done:
		RETURN
	END

	localname = ''
	nlinks2 = 0L
	links2 = REPLICATE('',1000)
	datelinks2 = REPLICATE('',1000)
	taillelinks2 = REPLICATE('',1000)

	IF STRMID(pathname,0,8) EQ 'https://' THEN BEGIN	; pathname commence par 'https://'

		file_https_copy, 				$
			pathname,				$
			localdir,				$
			verbose=verbose,			$
			user_agent=user_agent,			$
			authorization=authorization,		$
			general=general,			$
			msg=msg,				$
			readonly=readonly,			$
			silence=silence,			$
			localname=localname,			$
			links=links2,				$
			datelinks=datelinks2,			$
			taillelinks=taillelinks2,		$
			error=error,				$
			header=header,				$
			telecharge=telecharge

		RETURN
	END


	dprint,dlevel=4,verbose=verbose,'Start; $Id: file_http_copy.pro,v 1.56 2019/09/27 12:27:03 penou Exp $'

	url_info = { http_info,		$
		url:		'',	$	; Full url of file
		localname:	'',	$	; local file name
		type:		'',	$	; type of file
		class:		'',	$	; Class
		exists:		0b,	$
		directory:	0b,	$
		ltime:		0ll,	$	; Time when procedure was run
		atime:		0ll,	$	; server time at time of last access
		mtime:		0ll,	$	; last mod time of file
		clock_offset:	0ll,	$	; difference between server time and local time
		size:		0ll	$
	}

	url = pathname

	url_info.url = url
	url_info.ltime = SYSTIME(1)

	is_webservice = STRPOS(url,'?') NE -1

	; nom du fichier en local
	localname = is_webservice ? (localdir+'a.out') : localdir + basename(pathname)

	IF is_webservice THEN lint_unused = detruire(localname)

	read_timeout = 30

	traiter_debut_http_special, url, localdir, localname, links2, datelinks2, taillelinks2, read_timeout, infos
	IF infos.is_termine THEN RETURN

	IF STRMID(url,0,1,/reverse_offset) EQ '/' THEN BEGIN    ; Directories
		url_info.directory = 1
		localname = localdir + '.remote-index.html'
	END
	lcl = my_file_info(localname)
	localname += '.tmp'

	; ----------------------------------------
	; open the connection and request the file
	; ----------------------------------------
	top_debut = nbsec()

	connect_timeout = 2
	t_connect = SYSTIME(1)

	slash1 = STRPOS(STRMID(url, 7, STRLEN(url)), '/')
	Server = STRMID(url, 7, slash1 )
	purl = STRMID(url,slash1+7, STRLEN(url))

	Port = 80
	xxx = STRPOS(Server,':')
	IF xxx NE -1 THEN BEGIN
		Port = LONG(STRMID(Server,xxx+1,STRLEN(Server)-xxx-1))
		Server = STRMID(Server,0,xxx)
	END
	dprint,dlevel=4,verbose=verbose,'Opening server: ',Server
	IF ~KEYWORD_SET(Server) THEN dprint,dlevel=0,verbose=verbose,'Bad server'
	SOCKET, unit, Server,  Port, /get_lun, /swap_if_little_endian, error=error, read_timeout=read_timeout, connect_timeout=connect_timeout
	IF error EQ 0 THEN BEGIN
		EOL = is_windows() ? '' : STRING(13b)
		PRINTF, unit, 'GET '+purl +  ' HTTP/1.1' + EOL
		PRINTF, unit, 'Host: '+Server + EOL
		IF N_ELEMENTS(authorization) NE 0 THEN BEGIN
			IF authorization NE '' THEN BEGIN
				PRINTF, unit, 'Authorization: ' + authorization + EOL
			END
		END
		user_agent = N_ELEMENTS(user_agent) NE 0 ? user_agent : 'IDL ' + !VERSION.RELEASE + ' on ' + !VERSION.OS + '/' + !VERSION.ARCH
		PRINTF, unit, 'User-Agent: ' + user_agent + EOL
		PRINTF, unit, '' + EOL
	END ELSE BEGIN
		; error: non zero value indicate an error
		dprint,dlevel=0,verbose=verbose,!error_state.msg
		GOTO, ERREUR
	END

	; -------------------------------------------------
	; now read the header: dtermine la variable header
	; -------------------------------------------------
	LinesRead = 0
	text = 'xxx'
	ON_IOERROR, DONE
	header = STRARR(256)
	chunked = 0
	content_length = LONG64(0)
	content_type = ''
	IF DEBUG THEN PRINT,'****** '+purl
	WHILE text NE '' DO BEGIN
		READF, unit, text
		IF DEBUG THEN PRINT,'****** '+text
		header[LinesRead] = text
		LinesRead++
		IF LinesRead MOD 256 EQ 0 THEN header = [header, STRARR(256)]
		IF text EQ 'Transfer-Encoding: chunked' THEN chunked = 1
		IF STRMID(text,0,15) EQ 'Content-Length:' THEN READS,STRMID(text,15),content_length
		IF STRMID(text,0,13) EQ 'Content-Type:' THEN READS,STRMID(text,14),content_type
	END
DONE:	

	ON_IOERROR, NULL
	IF LinesRead EQ 0 THEN BEGIN
		FREE_LUN, unit
		error = -1 ; valeur diffrente de 0
		dprint,dlevel=0,verbose=verbose,!error_state.msg
		GOTO, ERREUR
	END
	header = header[0:LinesRead-1]

	file_http_header_info,header,url_info,verbose=verbose
	url_info.localname = localname

	dprint,dlevel=3,verbose=verbose,'Server ',Server,' Connect time= ',SYSTIME(1)-t_connect
	dprint,dlevel=7,verbose=verbose,'header= ',TRANSPOSE(header)
	dprint,dlevel=6,verbose=verbose,phelp=2,url_info
	
	IF ABS(url_info.clock_offset) GT 30 THEN BEGIN
		dprint,dlevel=1,verbose=verbose,'Warning! Remote and local clocks differ by:',url_info.clock_offset,' Seconds'
	END

	IF url_info.exists THEN BEGIN

		; Determine if download is needed

		tdiff = (url_info.mtime - lcl.mtime) / 24./3600.  ; days old
		Mb = 2.^20
		IF lcl.exists THEN BEGIN
			download_file = 0
			IF tdiff GT 0  THEN BEGIN
				download_file = 1
				IF readonly THEN BEGIN
					PRINT,'lcl.mtime = ' , lcl.mtime, ' ',date_to_str(tu_to_date(1970,1,1,0,0,0)+lcl.mtime*1000d)
					PRINT,'url_info.mtime = ',url_info.mtime,' ',date_to_str(tu_to_date(1970,1,1,0,0,0)+url_info.mtime*1000d)
					dprint,format="('Warning!  ',f0.1,' day old local file: ',a  )", tdiff, localname
					download_file = 0
				END
			END
			IF lcl.size NE url_info.size  THEN BEGIN
				download_file = 1
				IF readonly THEN BEGIN
					dprint,url_info.size/Mb,lcl.size/Mb, basename(localname), format='("Warning! Different file sizes: Remote=",f0.3," Mb, Local=",f0.3," Mb file: ",a)'
					download_file = 0
				END
			END
		END ELSE BEGIN     ; endof lcl.exists
			download_file = 1
			dprint,dlevel=3,verbose=verbose,format="('Found remote (',f0.3,' Mb) file: ""',a,'""')",url_info.size/Mb,url
			IF readonly THEN BEGIN
				dprint,format="('Found remote (',f0.3,' Mb) file: ""',a,'""')",url_info.size/Mb,url
				download_file = 0
			END
		END

		is_fichier = infos.is_special OR content_type EQ 'application/octet-stream' OR content_type EQ 'application/gzip'

		IF download_file THEN BEGIN    ;  begin file download

			ON_IOERROR, ERREUR

			OPENW, wunit, localname, /get_lun
			ts = SYSTIME(1)
			t0 = ts

			IF is_fichier AND chunked THEN BEGIN ; a mettre en premier

				; -------------
				; DOWNLOAD FILE
				; -------------

				; Traitement avec "Transfer-Encoding: chunked"

				Mb = 2.^20
				nb = 0l
				t0 = SYSTIME(1)
				b = 0l
				REPEAT BEGIN
					READF, unit, size_chunked, FORMAT='(Z)'
					IF size_chunked NE 0 THEN BEGIN
						tab = REPLICATE(0b,size_chunked)
						READU, unit, tab
						WRITEU, wunit, tab
						crlf = REPLICATE(0b,2)
						READU, unit, crlf
					END
					t1 = SYSTIME(1)
					dt = t1-t0
					nb += size_chunked
					b += size_chunked

					; Boutton arret de cl
					IF N_ELEMENTS(general) NE 0 THEN BEGIN
						IF cl_arret(general) THEN BEGIN
							FREE_LUN, unit
							FREE_LUN, wunit
							lint_unused = detruire (localname)
							error = -1 ; valeur diffrente de 0
							RETURN
						END
					END

					; Message pour cl (en cours de tlchargement)
					IF N_ELEMENTS(general) NE 0 AND dt GE 1 THEN BEGIN
						rate = b/Mb/dt                             ; This will only display if the filesize (url_info.size) is greater than MAXB
						st2 = val_to_str_2decimales (nb/Mb)
						sduree1 = val_to_str_1decimale (t1-tstart)
						srate = val_to_str_2decimales (rate)
						messstr = '  '+STRING(format='("(",A," secs  ",A," Mbytes)  @ ",A," Mbytes/sec")', sduree1, st2,  srate, /print)
						IF ~silence THEN cl_msg, general, str_bas=afficher_http(msg) + messstr
						t0 = t1
						b = 0l
					END
				END UNTIL size_chunked EQ 0

				FREE_LUN, wunit
				telecharge = 1

			END ELSE IF ~is_fichier AND (url_info.size LT 0 OR STRMID(url_info.type,0,4) EQ 'html') THEN BEGIN         ; download text file (typically these are directory listings

				; --------------------------
				; DOWNLOAD DIRECTORY LISTING
				; --------------------------

				dprint,dlevel=3,verbose=verbose,'Downloading "',localname,'" as a text file.'
				lines = 0ul
				last_top = nbsec()
				top0 = last_top
				; Message pour cl (dbut de tlchargement)
				IF N_ELEMENTS(general) NE 0 THEN BEGIN
					messstr = ' starting ...'+(chunked NE 0 ? " chunked":"")
					IF ~silence THEN cl_msg, general, str_bas=msg + messstr
				END
				IF chunked THEN BEGIN
					; Traitement avec "Transfer-Encoding: chunked"
					REPEAT BEGIN
						READF, unit, size_chunked, FORMAT='(Z)'
						IF size_chunked NE 0 THEN BEGIN
							tab = REPLICATE(0b,size_chunked)
							READU, unit, tab
							WRITEU, wunit, tab
							crlf = REPLICATE(0b,2)
							READU, unit, crlf
						END
					END UNTIL size_chunked EQ 0
				END ELSE IF content_length GT 0 THEN BEGIN
					tab = REPLICATE(0b,content_length)
					READU, unit, tab
					WRITEU, wunit, tab
				END
				FREE_LUN, wunit
				IF ARG_PRESENT(links2) THEN links2 = file_extract_html_links(localname,nlinks2,datelinks=datelinks2,taillelinks=taillelinks2)
				lines = N_ELEMENTS(links2)

				; mis en commentaire sinon impossible de rcuprer "http://wdc.kugi.kyoto-u.ac.jp/dst_realtime/201501/index.html"
				;IF ~is_webservice THEN lint_unused = detruire (localname)

				dprint,dlevel=2,verbose=verbose,'Downloaded ',STRTRIM(lines,2),' lines in ',STRING(SYSTIME(1)-ts,format='(f0.2)'),' seconds. File:',localname
				links2       = nlinks2 EQ 0 ? '' : links2[0:nlinks2-1]   ; get rid of first ''
				datelinks2   = nlinks2 EQ 0 ? '' : datelinks2[0:nlinks2-1]   ; get rid of first ''
				taillelinks2 = nlinks2 EQ 0 ? '' : taillelinks2[0:nlinks2-1]   ; get rid of first ''
				; Message pour cl (fin de tlchargement)
				top = nbsec()
				IF N_ELEMENTS(general) NE 0 AND (top - last_top GE 1) THEN BEGIN
					messstr = '  '+ val_to_str(nlinks2) + ' files found in ' + val_to_str_2decimales(top-top0)+' sec'
					IF ~silence THEN cl_msg, general, str_bas=afficher_http(msg) + messstr
				END


			END ELSE BEGIN ; download Non-text (binary) files

				; -----------------------------------
				; DOWNLOAD FILE PAR BUFFER DE 1Mbytes
				; -----------------------------------

				maxb = 2l^20   ; 1 Megabyte default buffer size
				nb = 0l
				b = 0l

				; Message pour cl (dbut de tlchargement)
				IF N_ELEMENTS(general) NE 0 THEN BEGIN
					percent = 0
					st1 = val_to_str_2decimales (url_info.size/Mb)
					messstr = '  '+STRING(format='(f5.1," %  (",A," Mbytes)")', percent, st1, /print)
					IF ~silence THEN cl_msg, general, str_bas=afficher_http(msg) + messstr
				END

				WHILE nb LT url_info.size DO BEGIN
					buffsize = maxb  <  (url_info.size-nb)
					aaa = BYTARR(buffsize,/nozero)
					READU, unit, aaa
					WRITEU, wunit, aaa
					nb += buffsize
					t1 = SYSTIME(1)
					dt = t1-t0
					b += buffsize
					percent = 100.*FLOAT(nb)/url_info.size

					; Boutton arret de cl
					IF N_ELEMENTS(general) NE 0 THEN BEGIN
						IF cl_arret(general) THEN BEGIN
							FREE_LUN, unit
							FREE_LUN, wunit
							lint_unused = detruire (localname)
							error = -1 ; valeur diffrente de 0
							RETURN
						END
					END

					; Message pour cl (en cours de tlchargement)
					IF N_ELEMENTS(general) NE 0 AND dt NE 0 AND b NE 0 THEN BEGIN ; dt NE 0 sinon division par zero
						rate = b/Mb/dt                             ; This will only display if the filesize (url_info.size) is greater than MAXB
						st1 = val_to_str_2decimales (url_info.size/Mb)
						st2 = val_to_str_2decimales (nb/Mb)
						eta = (url_info.size-nb)/Mb/rate +t1 - tstart
						sduree1 = val_to_str_1decimale (t1-tstart)
						sduree2 = val_to_str_1decimale (eta)
						srate = val_to_str_2decimales (rate)
						messstr = '  '+STRING(format='(f5.1," %  (",A,"/",A," secs  ",A,"/",A," Mbytes)  @ ",A," Mbytes/sec)")', percent, sduree1, sduree2, st2, st1, srate, /print)
						t0 = t1
						b = 0l
						IF ~silence THEN cl_msg, general, str_bas=afficher_http(msg) + messstr
					END

					; Message texte
					IF (dt GT 5.) AND (nb LT url_info.size) AND b NE 0 THEN BEGIN   ; Wait 5 seconds between updates.
						rate = b/Mb/dt                             ; This will only display if the filesize (url_info.size) is greater than MAXB
						eta = (url_info.size-nb)/Mb/rate +t1 - tstart
						messstr = STRING(format='("  ",f5.1," %  (",f0.1,"/",f0.1," secs)  @  ",f0.2," Mbytes/s  File: ",a)', percent, t1-tstart,eta, rate,basename(localname) ,/print)
						t0 = t1
						b = 0l
						dprint,dlevel=1,verbose=verbose,messstr    &  WAIT,.01
					END
				END

				t1 = SYSTIME(1)
				dt = t1 - tstart

				; Message pour cl (fin de tlchargement)
				IF N_ELEMENTS(general) NE 0 THEN BEGIN
					messstr = '  '+'100.0 %'
					IF ~silence THEN cl_msg, general, str_bas=afficher_http(msg) + messstr
				END

				; message texte (fin de tlchargement)
				messstr = STRING(/print,format="('Downloaded ',f0.3,' Mbytes in ',f0.1,' secs @ ',f0.2,' Mbytes/s  File: ""', a,'""' )",nb/Mb,dt,nb/Mb/dt,localname )
				dprint,dlevel=2,verbose=verbose,messstr

				FREE_LUN, wunit
				telecharge = 1

			END


		END ELSE BEGIN

			dprint,dlevel=3,verbose=verbose,'Local file: "' + localname + '" (Not downloaded)'

		END

	END ELSE BEGIN

		dprint,dlevel=1,verbose=verbose,'Remote file not found! "'+ url + '"'

	END

	FREE_LUN, unit
	unit = -1 ; pour savoir que le SOCKET a t ferm
	dprint,dlevel=5,verbose=verbose,'Closing server: ',Server

	localname = url_info.localname
	dprint,dlevel=5,verbose=verbose,'Done'

	top_fin = nbsec()

	PRINT, url + ' in ' + val_to_str_2decimales(top_fin-top_debut) + ' sec'

	traiter_fin_http_special, infos, localname, ioerror
	IF ioerror THEN GOTO, ERREUR

	RETURN


ERREUR:
	; ---------------------
	; UTILE EN CAS D'ERREUR
	; ---------------------

	PRINT, 'ERREUR file_http_copy pathname=' + pathname

	dprint,dlevel=0,verbose=verbose,'Error downloading file: "',url,'"'
	error = !error_state.msg
	dprint,dlevel=0,verbose=verbose,error

	error = -1 ; valeur diffrente de 0

	; fermer le fichier fd sinon j'ai des "All available logical units are currelntly in use"
	; ca ne plante pas si le fichier a deja ete ferme
	IF N_ELEMENTS(fd) THEN FREE_LUN, fd ; localname

	; fermer le fichier de sortie
	IF N_ELEMENTS(wunit) THEN FREE_LUN, wunit ; localname

	; fermer le SOCKET
	IF N_ELEMENTS(unit) THEN IF unit NE -1 THEN FREE_LUN, unit 

	; supprimer le fichier localname
	lint_unused = detruire (localname)

END
