/*------------------------------------------------------------------------------
 *
 *	Fichier	: $RCSfile: write_ascii.c,v $, v $Revision: 1.30 $
 *
 *	Date	: $Date: 2021/04/27 09:48:59 $
 *
 *	Auteur	: $Author: penou $
 *
 *	Version : %Z% version %I% de %M% du %G%
 *
 *------------------------------------------------------------------------------
*/

#include <math.h>
#include <limits.h>

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <ctype.h>

#ifdef GDL
#include "libgdl.h"
#else
#include "export.h"
#endif

double	**tab_datax;
float	**tab_datay;
int	nbtotal;
float	fillval;
int	epoch;

#define indice2(i1,i2,nb1,nb2)				((i1)+(nb1)*(i2))
#define indice3(i1,i2,i3,nb1,nb2,nb3)			((i1)+(nb1)*((i2)+(nb2)*(i3)))
#define indice4(i1,i2,i3,i4,nb1,nb2,nb3,nb4)		((i1)+(nb1)*((i2)+(nb2)*((i3)+(nb3)*(i4))))
#define indice5(i1,i2,i3,i4,i5,nb1,nb2,nb3,nb4,nb5)	((i1)+(nb1)*((i2)+(nb2)*((i3)+(nb3)*((i4)+(nb4)*(i5)))))

/*---------------------------------------------------------------------------*/
void caldat (int *mm, int *id, int *iyyy, int julian) {
/*---------------------------------------------------------------------------*/

	#define igreg2 2299161

	int je,jd,jc,jb,jalpha,ja;

	if (julian > igreg2) {
		jalpha = (int)(((julian-1867216)-0.25)/36524.25);
		ja = julian + 1 + jalpha - (int)(0.25*jalpha);
	} else
		ja = julian;

	jb = ja + 1524;
	jc = (int)(6680.0 + ((jb - 2439870)-122.1)/365.25);
	jd = 365*jc + (int)(0.25*jc);
	je = (int)((jb - jd)/30.6001);
	*id = jb - jd - (int)(30.6001*je);
	*mm = je - 1;
	if (*mm > 12)
		*mm = *mm - 12;
	*iyyy = jc - 4715;
	if (*mm > 2)
		*iyyy = *iyyy - 1;
	if (*iyyy <= 0)
		*iyyy = *iyyy - 1;

}


#define	julian1958 2436205

/*---------------------------------------------------------------------------*/
void date_to_tu (double date, int *annee, int *mois, int *jour, int *heure, int *minute, double *seconde) {
/*---------------------------------------------------------------------------*/

	int	julian;

	julian = julian1958 + (int)(date/86400000);
	caldat (mois, jour, annee, julian);

	*seconde = (date - (double)(julian-julian1958)*86400000)/1000;
	*heure = *seconde / 3600;

	*seconde = *seconde - *heure*3600;

	*minute = *seconde / 60;

	*seconde = *seconde - *minute*60;

}


/*---------------------------------------------------------------------------*/
char *Milli_to_str_time (double milli, int format) {
/*---------------------------------------------------------------------------*/

	/* Converti un temps au format ascii QSAS */

	static char buffer [28];	// passage de 25  28 octets sinon message sous CentOS8 (gcc 8.2.1)
	int annee;
	int mois;
	int jour;
	int heure;
	int minute;
	double seconde;

	date_to_tu (milli, &annee, &mois, &jour, &heure, &minute, &seconde);

	if (format==3)
		sprintf (buffer, "%04d-%02d-%02dT%02d:%02d:%06.3fZ", annee, mois, jour, heure, minute, seconde);
	else if (format==9)
		sprintf (buffer, "%04d-%02d-%02dT%02d:%02d:%09.6fZ", annee, mois, jour, heure, minute, seconde);
	else if (format==4)
		sprintf (buffer, "%04d %02d %02d %02d %02d %06.3f", annee, mois, jour, heure, minute, seconde);
	else if (format==1)
		sprintf (buffer, "%02d %02d %04d %02d %02d %06.3f", jour, mois, annee, heure, minute, seconde);

	return buffer;

}

/*---------------------------------------------------------------------------*/
int INIT1_TIMESERIES (int argc, void *argv[]) {
/*---------------------------------------------------------------------------*/

	/* Initialise le module */

	int	nbtotal_idl	= *(int *)	argv[0];
	float	fillval_idl	= *(float *)	argv[1];
	int	epoch_idl	= *(int *)	argv[2];

	nbtotal = nbtotal_idl;
	fillval = fillval_idl;
	epoch   = epoch_idl;

	tab_datax = (double **) malloc (sizeof(double *)*nbtotal);
	tab_datay = (float **) malloc (sizeof(float *)*nbtotal);

	return 1;

}

/*---------------------------------------------------------------------------*/
int INIT1_TIMESERIES_AUTO_GLUE (
/*---------------------------------------------------------------------------*/
	void	*p01,
	void	*p02,
	void	*p03) {

	int	argc=3;
	void	*argv[3];

	argv[0] = p01;
	argv[1] = p02;
	argv[2] = p03;
	return INIT1_TIMESERIES (argc, argv);

}


/*---------------------------------------------------------------------------*/
int INIT2_TIMESERIES (int argc, void *argv[]) {
/*---------------------------------------------------------------------------*/

	int	i_idl		= *(int *)	argv[0];
	double	*datax_idl	= (double *)	argv[1];
	float	*datay_idl	= (float *)	argv[2];

	tab_datax[i_idl] = datax_idl;
	tab_datay[i_idl] = datay_idl;

	return 1;

}

/*---------------------------------------------------------------------------*/
int INIT2_TIMESERIES_AUTO_GLUE (
/*---------------------------------------------------------------------------*/
	void	*p01,
	void	*p02,
	void	*p03) {

	int	argc=3;
	void	*argv[3];

	argv[0] = p01;
	argv[1] = p02;
	argv[2] = p03;
	return INIT2_TIMESERIES (argc, argv);

}


#define DEBUT						\
tabx = (double *) malloc (sizeof(double)*nbtotal);	\
taby = (float *) malloc (sizeof(float)*nbtotal);	\
tabi = (int *) malloc (sizeof(int)*nbtotal);		\
							\
for (i=0;i<nbtotal;i++) {				\
	tabx[i]=1E34;					\
	taby[i]=1E34;					\
	tabi[i]=0;					\
}							\
							\
for (i=0;i<nbtotal;i++)					\
	if (tabnb[i]!=0) {				\
		tabx[i] = tab_datax[i][tabi[i]];	\
		taby[i] = tab_datay[i][tabi[i]];	\
}

#define FIN 	\
free (tabx);	\
free (taby);	\
free (tabi);

#define BOUCLE(inst1,inst2,inst3) 					\
for (noligne=0;;noligne++) {						\
	xmin=1E35;							\
	for (i=0;i<nbtotal;i++)						\
		if (tabx[i]<xmin) xmin=tabx[i];				\
	if (xmin > 1E33) break;						\
									\
	inst1								\
									\
	for (i=0;i<nbtotal;i++) {					\
		if (tabx[i]==xmin) {					\
			val = taby[i];					\
			(tabi[i])++;					\
			if (tabi[i]<tabnb[i]) {				\
				tabx[i] = tab_datax[i][tabi[i]];	\
				taby[i] = tab_datay[i][tabi[i]];	\
			} else {					\
				tabx[i]=1E34;				\
			}						\
		} else {						\
			val=fillval;					\
		}							\
		inst2							\
	}								\
	inst3								\
}


/*---------------------------------------------------------------------------*/
int WRITE_TIMESERIES (int argc, void *argv[]) {
/*---------------------------------------------------------------------------*/

	int		*tabnb			= (int *)		argv[0];
	IDL_STRING	*nom_IDL		= (IDL_STRING *)	argv[1];
	int		format			= *(int *)		argv[2]; /* 3='QSAS' 1='YYYY MM DD HH MM SS.MSC' */
	IDL_STRING	*field_separator_IDL	= (IDL_STRING *)	argv[3]; /* "," ou " " */
	int		votable			= *(int *)		argv[4]; /* 1 s'il faut crer un fichier XML VOTABLE, 0 sinon*/

	char	s[10000];
	float	val;
	int	i;
	double	xmin;
	FILE	*fd;
	double	*tabx;
	float	*taby;
	int	*tabi;
	int	noligne;

	fd = fopen (IDL_STRING_STR(nom_IDL),"a+");

	DEBUT

	if (votable==0) {

		BOUCLE (

			if (epoch==1)
				sprintf (s,"%s", Milli_to_str_time (xmin,format));
			else
				sprintf (s,"%12.5E",xmin);

			,

			sprintf (s+strlen(s),"%s %12.5E",IDL_STRING_STR(field_separator_IDL),val);

			,

			fprintf (fd,"%s\n",s);

		)

	} else {

		BOUCLE (

			if (epoch==1)
				sprintf (s,"<TR><TD>%s</TD>", Milli_to_str_time (xmin,format));
			else
				sprintf (s,"<TR><TD>%12.5E</TD>",xmin);

			,

			sprintf (s+strlen(s),"<TD>%12.5E</TD>",val);

			,

			fprintf (fd,"%s</TR>\n",s);

		)

	}

	FIN

	free (tab_datax);
	free (tab_datay);

	fclose (fd);

	return 1;

}

/*---------------------------------------------------------------------------*/
int WRITE_TIMESERIES_AUTO_GLUE (
/*---------------------------------------------------------------------------*/
	void	*p01,
	void	*p_nom_IDL,
	void	*p03,
	void	*p_field_separator_IDL,
	void	*p05) {

	int		argc=5;
	void		*argv[5];
	int		code;
	IDL_STRING	*nom_IDL;
	IDL_STRING	*field_separator_IDL;

	// p_nom_IDL -> nom_IDL
	nom_IDL = malloc (sizeof(IDL_STRING));
	IDL_StrStore (nom_IDL, p_nom_IDL);

	// p_field_separator_IDL -> field_separator_IDL
	field_separator_IDL = malloc (sizeof(IDL_STRING));
	IDL_StrStore (field_separator_IDL, p_field_separator_IDL);

	argv[0] = p01;
	argv[1] = nom_IDL;
	argv[2] = p03;
	argv[3] = field_separator_IDL;
	argv[4] = p05;
	code = WRITE_TIMESERIES (argc, argv);

	free (nom_IDL);
	free (field_separator_IDL);

	return code;

}

/*---------------------------------------------------------------------------*/
int INFO_TIMESERIES (int argc, void *argv[]) {
/*---------------------------------------------------------------------------*/

	int	*tabnb		= (int *)	argv[0];
	int	*nblignes	= (int *)	argv[1];

	float val;
	int i;
	double xmin;
	double *tabx;
	float *taby;
	int *tabi;
	int noligne;

	DEBUT

	*nblignes=0;

	BOUCLE (

		(*nblignes)++;

		,

		,

	)

	FIN	

	return 1;

}

/*---------------------------------------------------------------------------*/
int INFO_TIMESERIES_AUTO_GLUE (
/*---------------------------------------------------------------------------*/
	void	*p01,
	void    *p02) {

	int	argc=2;
	void	*argv[2];

	argv[0] = p01;
	argv[1] = p02;
	return INFO_TIMESERIES (argc, argv);

}


/*---------------------------------------------------------------------------*/
int WRITE_TAB_TIMESERIES (int argc, void *argv[]) {
/*---------------------------------------------------------------------------*/

	int	*tabnb	= (int *)	argv[0];
	int	taille	= *(int *)	argv[1];
	char*	tabdata	= (char *)	argv[2]; /* tabdata[nblignes] contient une structure Double + nbtotal*float */

	float val;
	int i;
	double xmin;
	double *tabx;
	float *taby;
	int *tabi;
	int noligne;
	double *pdouble;
	float *pfloat;

	DEBUT

	BOUCLE (

		pdouble = (double *)(tabdata+noligne*taille);
		pfloat = (float *)(tabdata + noligne*taille + sizeof(double));
		*pdouble = xmin;

		,

		pfloat[i]=val;

		,

	)

	FIN

	free (tab_datax);
	free (tab_datay);

	return 1;

}

/*---------------------------------------------------------------------------*/
int WRITE_TAB_TIMESERIES_AUTO_GLUE (
/*---------------------------------------------------------------------------*/
	void	*p01,
	void	*p02,
	void	*p03) {

	int	argc=3;
	void	*argv[3];

	argv[0] = p01;
	argv[1] = p02;
	argv[2] = p03;
	return WRITE_TAB_TIMESERIES (argc, argv);

}


/*---------------------------------------------------------------------------*/
int WRITE_SPECTRO (int argc, void *argv[]) {
/*---------------------------------------------------------------------------*/

	IDL_STRING	*nom_IDL		= (IDL_STRING *)	argv[ 0];
	int		nbX			= *(int *)		argv[ 1];
	int		nbY			= *(int *)		argv[ 2];
	int		nbtables		= *(int *)		argv[ 3];
	double		*Xmin_data		= (double *)		argv[ 4]; /* Xmin_data[nbX] */
	double		*Xmoy_data		= (double *)		argv[ 5]; /* Xmoy_data[nbX] */
	double		*Xmax_data		= (double *)		argv[ 6]; /* Xmax_data[nbX] */
	int		*indY			= (int *)		argv[ 7]; /* indY[nbX] */
	float		*Ymin_data		= (float *)		argv[ 8]; /* Ymin_data[nbtables,nbY] */
	float		*Ymoy_data		= (float *)		argv[ 9]; /* Ymoy_data[nbtables,nbY] */
	float		*Ymax_data		= (float *)		argv[10]; /* Ymax_data[nbtables,nbY] */
	float		*Zdata			= (float *)		argv[11]; /* Zdata[nbX,nbY] */
	short		*produit1		= (short *)		argv[12]; /* produit1[nbspins] */
	double		time_t1			= *(double *)		argv[13];
	double		time_t2			= *(double *)		argv[14];
	double		t1_calib		= *(double *)		argv[15]; /* si t1_calib > time_t1, on n'ecrit que les donnees > t1_calib */
	double		t2_calib		= *(double *)		argv[16]; /* si t2_calib < time_t2, on n'ecrit que les donnees <= t2_calib */
	IDL_STRING	*Yformat		= (IDL_STRING *)	argv[17];
	IDL_STRING	*Zformat		= (IDL_STRING *)	argv[18];
	int		phi_theta		= *(int *)		argv[19];
	int		rlong_rlat		= *(int *)		argv[20];
	float		*Emin			= (float *)		argv[21]; /* Emin[nbX] */
	float		*Emax			= (float *)		argv[22]; /* Emax[nbX] */
	int		format			= *(int *)		argv[23]; /* 3='QSAS' 1='YYYY MM DD HH MM SS.MSC' */
	IDL_STRING	*field_separator_IDL	= (IDL_STRING *)	argv[24]; /* "," ou " " */
	float		F_INFINITY		= *(float *)		argv[25]; /* !VALUES.F_INFINITY */

	int i,j;
	FILE *fd;
	char *t2,formatstr[1000];

	if (phi_theta==1) {
		sprintf (formatstr,"%s%s %s%s %s%s %s%s %%8.2f%s %%8.2f%s %s\n",
			IDL_STRING_STR(Yformat), IDL_STRING_STR(field_separator_IDL),
			IDL_STRING_STR(Yformat), IDL_STRING_STR(field_separator_IDL),
			IDL_STRING_STR(Yformat), IDL_STRING_STR(field_separator_IDL),
			IDL_STRING_STR(Yformat), IDL_STRING_STR(field_separator_IDL),
			IDL_STRING_STR(field_separator_IDL),
			IDL_STRING_STR(field_separator_IDL),
			IDL_STRING_STR(Zformat));
	} else if (rlong_rlat==1) {
		sprintf (formatstr,"%s%s %s%s %s\n",
			IDL_STRING_STR(Yformat), IDL_STRING_STR(field_separator_IDL),
			IDL_STRING_STR(Yformat), IDL_STRING_STR(field_separator_IDL),
			IDL_STRING_STR(Zformat));
	} else {
		sprintf (formatstr,"%%s%s %%8.2f%s %s%s %s%s %%2d%s %s\n",
			IDL_STRING_STR(field_separator_IDL),
			IDL_STRING_STR(field_separator_IDL),
			IDL_STRING_STR(Yformat), IDL_STRING_STR(field_separator_IDL),
			IDL_STRING_STR(Yformat), IDL_STRING_STR(field_separator_IDL),
			IDL_STRING_STR(field_separator_IDL),
			IDL_STRING_STR(Zformat));
	}

	fd = fopen (IDL_STRING_STR(nom_IDL),"a+");

	for (i=0;i<nbX;i++) {

		/* Test pour ne pas ecrire 2 fois la meme ligne dans le cas de changement de calibration */
		if (t1_calib<=time_t1 || Xmin_data[i]>t1_calib) {
			if (t2_calib>=time_t2 || Xmin_data[i]<=t2_calib) {

				if (phi_theta==1) {
					for (j=0;j<nbY;j++) {
						fprintf (fd,formatstr, 
							Xmoy_data[i],Xmax_data[i]-Xmin_data[i],
							Ymoy_data[indice2(indY[i],j,nbtables,nbY)],
							Ymax_data[indice2(indY[i],j,nbtables,nbY)]-Ymin_data[indice2(indY[i],j,nbtables,nbY)],
							Emin[i],Emax[i],(Zdata[indice2(i,j,nbX,nbY)]==F_INFINITY) ? 0 : Zdata[indice2(i,j,nbX,nbY)]);
					}
				} else if (rlong_rlat==1) {
					for (j=0;j<nbY;j++) {
						fprintf (fd,formatstr, 
							Xmoy_data[i],
							Ymoy_data[indice2(indY[i],j,nbtables,nbY)],
							(Zdata[indice2(i,j,nbX,nbY)]==F_INFINITY) ? 0 : Zdata[indice2(i,j,nbX,nbY)]);
						}
	
				} else { 
					t2 = Milli_to_str_time (Xmoy_data[i],format);
					for (j=0;j<nbY;j++) {
						fprintf (fd,formatstr, 
							t2,(Xmax_data[i]-Xmin_data[i])/1000.,
							Ymoy_data[indice2(indY[i],j,nbtables,nbY)],
							Ymax_data[indice2(indY[i],j,nbtables,nbY)]-Ymin_data[indice2(indY[i],j,nbtables,nbY)],
							produit1[i],(Zdata[indice2(i,j,nbX,nbY)]==F_INFINITY) ? 0 : Zdata[indice2(i,j,nbX,nbY)]);
					}
				}
			}
		}
	}

	fclose (fd);

	return 1;

}

/*---------------------------------------------------------------------------*/
int WRITE_SPECTRO_AUTO_GLUE (
/*---------------------------------------------------------------------------*/
	void	*p_nom_IDL,
	void	*p02,
	void	*p03,
	void	*p04,
	void	*p05,
	void	*p06,
	void	*p07,
	void	*p08,
	void	*p09,
	void	*p10,
	void	*p11,
	void	*p12,
	void	*p13,
	void	*p14,
	void	*p15,
	void	*p16,
	void	*p17,
	void	*p_Yformat,
	void	*p_Zformat,
	void	*p20,
	void	*p21,
	void	*p22,
	void	*p23,
	void	*p24,
	void	*p_field_separator_IDL,
	void	*p26) {

	int		argc=26;
	void		*argv[26];
	int		code;
	IDL_STRING	*nom_IDL;
	IDL_STRING	*Yformat;
	IDL_STRING	*Zformat;
	IDL_STRING	*field_separator_IDL;

	// p_nom_IDL -> nom_IDL
	nom_IDL = malloc (sizeof(IDL_STRING));
	IDL_StrStore (nom_IDL, p_nom_IDL);

	// p_Yformat -> Yformat
	Yformat = malloc (sizeof(IDL_STRING));
	IDL_StrStore (Yformat, p_Yformat);

	// p_Zformat -> Zformat
	Zformat = malloc (sizeof(IDL_STRING));
	IDL_StrStore (Zformat, p_Zformat);

	// p_field_separator_IDL -> field_separator_IDL
	field_separator_IDL = malloc (sizeof(IDL_STRING));
	IDL_StrStore (field_separator_IDL, p_field_separator_IDL);

	argv[ 0] = nom_IDL;
	argv[ 1] = p02;
	argv[ 2] = p03;
	argv[ 3] = p04;
	argv[ 4] = p05;
	argv[ 5] = p06;
	argv[ 6] = p07;
	argv[ 7] = p08;
	argv[ 8] = p09;
	argv[ 9] = p10;
	argv[10] = p11;
	argv[11] = p12;
	argv[12] = p13;
	argv[13] = p14;
	argv[14] = p15;
	argv[15] = p16;
	argv[16] = p17;
	argv[17] = Yformat;
	argv[18] = Zformat;
	argv[19] = p20;
	argv[20] = p21;
	argv[21] = p22;
	argv[22] = p23;
	argv[23] = p24;
	argv[24] = field_separator_IDL;
	argv[25] = p26;
	code = WRITE_SPECTRO (argc, argv);

	free (nom_IDL);
	free (Yformat);
	free (Zformat);
	free (field_separator_IDL);

	return code;

}

/*---------------------------------------------------------------------------*/
char *sprintf93E (char *separateur, float valfloat) {
/*---------------------------------------------------------------------------*/

	//#define YANN
	//#define ALAIN
	#define MANU

	int		v1,v2,v3,v4,e1,e2;
	int		i,i1,i2;
	char		signe,signe_exposant;
	static char	buffer[12];
	double		tmp;
	double		val;

	static int	initialise=0;
	#define MAX93E	85
	static double	Cmin[MAX93E];
	static double	Cmax[MAX93E];
	static double	Cdiv[MAX93E];
	static int	Cexp[MAX93E];

	#ifdef YANN
	static int	magic[255];
	unsigned char	*p;
	int		exposant;
	#endif

	if (initialise==0) {
		
		// Les float vont de -1E45  3E38. Je vaire faire les tests avec des DOUBLES entre:
		//	1E-46 < x <= 1E-45
		//	1E-45 < x <= 1E-44
		//	...
		// 	1E37 < x <= 1E38
		// 	1E38 < x <= 1E39
		for (i=0 ; i<MAX93E ; i++) {
			Cmin[i] = pow (10.0,-46+i);	
			Cmax[i] = pow (10.0,-46+i+1);
			Cdiv[i] = pow (10.0,-46+i-3);
			Cexp[i] = -46+i;
			#ifdef DEBUG
			if (i<=1 || i>=MAX93E-2) {
				printf ("Cmin=%9.3E max=%9.3E Cdiv=%9.3E\n",Cmin[i],Cmax[i],Cdiv[i]);
			} else if (i==2) {
				printf ("...\n");
			}
			#endif
		}
		initialise = 1;
		#ifdef YANN
		for (i=0 ; i<255 ; i++) {
			magic[i] = log10(pow (2.0, i-127));
			if (magic[i]<0) magic[i]--;
			magic[i] += 46;
		}
		#endif

	}

	if (isnan(valfloat)) {
		buffer[ 0] = separateur[0];
		buffer[ 1] = ' ';
		buffer[ 2] = ' ';
		buffer[ 3] = ' ';
		buffer[ 4] = ' ';
		buffer[ 5] = ' ';
		buffer[ 6] = ' ';
		buffer[ 7] = 'N';
		buffer[ 8] = 'A';
		buffer[ 9] = 'N';
		buffer[10] = 0;
		return buffer;
	}

	i = isinf(valfloat);
	if (i==1) {
		buffer[ 0] = separateur[0];
		buffer[ 1] = ' ';
		buffer[ 2] = ' ';
		buffer[ 3] = ' ';
		buffer[ 4] = ' ';
		buffer[ 5] = ' ';
		buffer[ 6] = ' ';
		buffer[ 7] = 'I';
		buffer[ 8] = 'N';
		buffer[ 9] = 'F';
		buffer[10] = 0;
		return buffer;
	} else if (i==-1) {
		buffer[ 0] = separateur[0];
		buffer[ 1] = ' ';
		buffer[ 2] = ' ';
		buffer[ 3] = ' ';
		buffer[ 4] = ' ';
		buffer[ 5] = ' ';
		buffer[ 6] = '-';
		buffer[ 7] = 'I';
		buffer[ 8] = 'N';
		buffer[ 9] = 'F';
		buffer[10] = 0;
		return buffer;
	}

	if (valfloat < 0) {
		val = -valfloat;
		signe = '-';
	} else {
		val = valfloat;
		signe='+';
	}

	if (val <= Cmin[0]) {
		buffer[ 0] = separateur[0];
		buffer[ 1] = '0';
		buffer[ 2] = '.';
		buffer[ 3] = '0';
		buffer[ 4] = '0';
		buffer[ 5] = '0';
		buffer[ 6] = 'E';
		buffer[ 7] = '+';
		buffer[ 8] = '0';
		buffer[ 9] = '0';
		buffer[10] = 0;
		return buffer;
	}

	#ifdef YANN

		p = (unsigned char *) (&valfloat);
		exposant = ((p[3]&0x7f)<<1)+(p[2]>>7);
		// Ce codage ne marche pas sous Sparc
		i = magic[exposant];
		// Ne marche pas avec les nombres dnormaliss
		

	#endif

	#ifdef ALAIN

	i = log10(val) + 46;

	#endif

	#ifdef MANU

	// Recherche dichotomique pour dterminer la puissance de 10

	i1 = 0;
	i2 = MAX93E-1;

	while (i1<MAX93E && i2>=0) {

		i = (i1+i2)/2;
		//printf ("%.50f<=(Cmin[%d]=%9.3E)?  %.50F>(Cmax[%d]=%9.3E)\n",val,i,Cmin[i],val,i,Cmax[i]);
		//printf ("i1=%d i2=%d i=%d\n",i1,i2,i);

		if (val <= Cmin[i]) {

			i2 = i-1;

		} else if (val > Cmax[i]) {

			i1 = i+1;

		} else {

			break;

		}

	}

	if (i1 >= MAX93E || i2<0) {
		buffer[ 0] = separateur[0];
		buffer[ 1] = ' ';
		buffer[ 2] = ' ';
		buffer[ 3] = ' ';
		buffer[ 4] = 'D';
		buffer[ 5] = 'A';
		buffer[ 6] = 'M';
		buffer[ 7] = 'N';
		buffer[ 8] = 'E';
		buffer[ 9] = 'D';
		buffer[10] = 0;
		strcpy (buffer, "   DAMNED");
		return buffer;
	}

	#endif

	// on a donc (val>Cmin[i]) && (val<=Cmax[i])

	tmp = val / Cdiv[i];
	v4 = tmp;
	if (tmp - v4 > 0.5) v4++;

	if (v4 >= 10000) {
		// arrive avec 9999.784180 / 1.0 => v4=10000
		i++;
		tmp = val / Cdiv[i];
		v4 = tmp;
		if (tmp - v4 > 0.5) v4++;
	}

	v1 = v4 / 1000;
	v4 -= 1000 * v1;

	v2 = v4 / 100;
	v4 -= 100 * v2;

	v3 = v4 / 10;
	v4 -= 10 * v3;

	if (Cexp[i] >= 0) {
		signe_exposant = '+';
		e1 = Cexp[i] / 10;
		e2 = Cexp[i] - 10*e1;
	} else {
		signe_exposant = '-';
		e1 = (-Cexp[i]) / 10;
		e2 = (-Cexp[i]) - 10*e1;
	}
	if (signe=='-') {
		buffer[ 0] = separateur[0];
		buffer[ 1] = signe;
		buffer[ 2] = '0' + v1;
		buffer[ 3] = '.';
		buffer[ 4] = '0' + v2;
		buffer[ 5] = '0' + v3;
		buffer[ 6] = '0' + v4;
		buffer[ 7] = 'E';
		buffer[ 8] = signe_exposant;
		buffer[ 9] = '0' + e1;
		buffer[10] = '0' + e2;
		buffer[11] = 0;
	} else {
		buffer[ 0] = separateur[0];
		buffer[ 1] = '0' + v1;
		buffer[ 2] = '.';
		buffer[ 3] = '0' + v2;
		buffer[ 4] = '0' + v3;
		buffer[ 5] = '0' + v4;
		buffer[ 6] = 'E';
		buffer[ 7] = signe_exposant;
		buffer[ 8] = '0' + e1;
		buffer[ 9] = '0' + e2;
		buffer[10] = 0;
	}

	return buffer;

}


/*---------------------------------------------------------------------------*/
int WRITE_DATE_TAB (int argc, void *argv[]) {
/*---------------------------------------------------------------------------*/

	int		nbarg			= 0;
	IDL_STRING	*nom_IDL		= (IDL_STRING *)	argv[nbarg++];
	IDL_STRING	*separateur		= (IDL_STRING *)	argv[nbarg++];
	IDL_STRING	*fin_de_ligne		= (IDL_STRING *)	argv[nbarg++];
	int		nbspins			= *(int *)		argv[nbarg++];
	int		nbmasses		= *(int *)		argv[nbarg++];
	int		nbcellules		= *(int *)		argv[nbarg++];
	int		nbspectres		= *(int *)		argv[nbarg++];
	int		nbenergies		= *(int *)		argv[nbarg++];
	int		write_masstable		= *(int *)		argv[nbarg++];
	float		*MASS_TABLE		= (float *)		argv[nbarg++]; /* MASS_TABLE[nbspins,nbmasses] */
	float		*MASS_DELTA_PLUS	= (float *)		argv[nbarg++]; /* MASS_DELTA_PLUS[nbspins,nbmasses] */
	float		*MASS_DELTA_MINUS	= (float *)		argv[nbarg++]; /* MASS_DELTA_MINUS[nbspins,nbmasses] */
	int		write_phitable		= *(int *)		argv[nbarg++];
	int		nbphis			= *(int *)		argv[nbarg++];
	float		*PHI_TABLE		= (float *)		argv[nbarg++]; /* PHI_TABLE[nbspins,nbphis] */
	float		*PHI_DELTA_PLUS		= (float *)		argv[nbarg++]; /* PHI_DELTA_PLUS[nbspins,nbphis] */
	float		*PHI_DELTA_MINUS	= (float *)		argv[nbarg++]; /* PHI_DELTA_MINUS[nbspins,nbphis] */
	int		write_energytable	= *(int *)		argv[nbarg++];
	float		*ENERGY_TABLE		= (float *)		argv[nbarg++]; /* ENERGY_TABLE[nbspins,nbenergies] */
	float		*ENERGY_DELTA_PLUS	= (float *)		argv[nbarg++]; /* ENERGY_DELTA_PLUS[nbspins,nbenergies] */
	float		*ENERGY_DELTA_MINUS	= (float *)		argv[nbarg++]; /* ENERGY_DELTA_MINUS[nbspins,nbenergies] */
	int		write_duration		= *(int *)		argv[nbarg++];
	double		*tab_duration		= (double *)		argv[nbarg++]; /* tab_duration[nbspins] */
	int		write_quality0		= *(int *)		argv[nbarg++];
	int		*tab_quality0		= (int *)		argv[nbarg++]; /* tab_quality0[nbspins] */
	int		write_quality1		= *(int *)		argv[nbarg++];
	int		*tab_quality1		= (int *)		argv[nbarg++]; /* tab_quality1[nbspins] */
	double		*tab_date		= (double *)		argv[nbarg++]; /* tab_date[nbspins] */
	float		*tab_data		= (float *)		argv[nbarg++]; /* tab_data[nbspins,nbmasses,nbcellules,nbspectres,nbenergies] */
	double		time_t1			= *(double *)		argv[nbarg++];
	double		time_t2			= *(double *)		argv[nbarg++];
	double		t1_calib		= *(double *)		argv[nbarg++]; /* si t1_calib > time_t1, on n'ecrit que les donnees > t1_calib */
	double		t2_calib		= *(double *)		argv[nbarg++]; /* si t2_calib < time_t2, on n'ecrit que les donnees <= t2_calib */
	IDL_STRING	*Dformat		= (IDL_STRING *)	argv[nbarg++];
	IDL_STRING	*Eformat		= (IDL_STRING *)	argv[nbarg++];
	IDL_STRING	*Zformat		= (IDL_STRING *)	argv[nbarg++];
	int		dateformat		= *(int *)		argv[nbarg++]; /* 3='QSAS' 1='YYYY MM DD HH MM SS.MSC' */
	float		F_INFINITY		= *(float *)		argv[nbarg++]; /* !VALUES.F_INFINITY */
	int		votable			= *(int *)		argv[nbarg++]; /* 0 ou 1 */


	int	ispin;
	int	imasse;
	int	icellule;
	int	ispectre;
	int	ienergie;
	int	iphi;
	FILE	*fd;
	char	*t2;
	char	formatstrZ[1024];
	char	formatstrE[1024];
	char	formatstrD[1024];
	char	formatstrQ[1024];
	char	zero[1024];	// codage optimis du zero

	char	bufferm[1000000];
	char	bufferp[1000000];
	char	buffere[1000000];
	int	ispinm=-1,ispinp=-1,ispine=-1;;
	int	dep;
	int	idem;
	char	*p;

	float	val;
	
	int	is_sprintf93E = strcmp(IDL_STRING_STR(Zformat),"%9.3E") == 0;

	if (is_sprintf93E) {
		printf ("Zformat=[%s] is_sprintf93E=%d\n",IDL_STRING_STR(Zformat),is_sprintf93E);
	}

	// Format pour tab_duration
	if (votable) {
		sprintf (formatstrD,"<TD>%s</TD>", IDL_STRING_STR(Dformat));
	} else {
		sprintf (formatstrD,"%s%s", IDL_STRING_STR(separateur),IDL_STRING_STR(Dformat));
	}

	// Format pour les nergies
	//sprintf (formatstrE,"%s%s", IDL_STRING_STR(separateur),IDL_STRING_STR(Eformat));		// Mthode lente
	if (votable) {
		sprintf (formatstrE," %s%%n", IDL_STRING_STR(Eformat));					// Mthode rapide
	} else {
		sprintf (formatstrE,"%s%s%%n", IDL_STRING_STR(separateur),IDL_STRING_STR(Eformat));	// Mthode rapide
	}

	// Format pour les comptages en printf
	if (votable) {
		sprintf (formatstrZ,"<TD>%s</TD>", IDL_STRING_STR(Zformat));
	} else {
		sprintf (formatstrZ,"%s%s", IDL_STRING_STR(separateur),IDL_STRING_STR(Zformat));
	}

	// Format pour tab_quality0 et tab_quality1
	if (votable) {
		sprintf (formatstrQ,"<TD>%s</TD>", "%d");
	} else {
		sprintf (formatstrQ,"%s%s", IDL_STRING_STR(separateur),"%d");
	}

	// Format pour les comptages nuls
	//sprintf (zero, formatstrZ, 0.0);				// prend beaucoup de place	ex: ",0.000E+00"	
	if (votable) {
		sprintf (zero," 0");					// prend moins de place		ex: ",0"		
	} else {
		sprintf (zero,"%s0", IDL_STRING_STR(separateur));	// prend moins de place		ex: ",0"		
	}

	fd = fopen (IDL_STRING_STR(nom_IDL),"a+");

	for (ispin=0 ; ispin<nbspins ; ispin++) {

		/* Test pour ne pas ecrire 2 fois la meme ligne dans le cas de changement de calibration */
		if (t1_calib<=time_t1 || tab_date[ispin]>t1_calib) {
			if (t2_calib>=time_t2 || tab_date[ispin]<=t2_calib) {

				if (dateformat==-1) {	// format binaire
					fwrite (&tab_date[ispin],sizeof(double),1,fd);
					if (write_duration) {
						val = tab_duration[ispin];
						fwrite (&val,sizeof(float),1,fd);
					}
					if (write_masstable) {
						for (imasse=0 ; imasse<nbmasses ; imasse++) {
							fwrite (&MASS_TABLE[indice2(ispin,imasse,nbspins,nbmasses)],sizeof(float),1,fd);
						}
						if (MASS_DELTA_PLUS[0] > -1e30) {
							for (imasse=0 ; imasse<nbmasses ; imasse++) {
								fwrite (&MASS_DELTA_PLUS[indice2(ispin,imasse,nbspins,nbmasses)],sizeof(float),1,fd);
							}
						}
						if (MASS_DELTA_MINUS[0] > -1e30) {
							for (imasse=0 ; imasse<nbmasses ; imasse++) {
								fwrite (&MASS_DELTA_MINUS[indice2(ispin,imasse,nbspins,nbmasses)],sizeof(float),1,fd);
							}
						}
					}
					if (write_phitable) {
						for (iphi=0 ; iphi<nbphis ; iphi++) {
							fwrite (&PHI_TABLE[indice2(ispin,iphi,nbspins,nbphis)],sizeof(float),1,fd);
						}
						if (PHI_DELTA_PLUS[0] > -1e30) {
							for (iphi=0 ; iphi<nbphis ; iphi++) {
								fwrite (&PHI_DELTA_PLUS[indice2(ispin,iphi,nbspins,nbphis)],sizeof(float),1,fd);
							}
						}
						if (PHI_DELTA_MINUS[0] > -1e30) {
							for (iphi=0 ; iphi<nbphis ; iphi++) {
								fwrite (&PHI_DELTA_MINUS[indice2(ispin,iphi,nbspins,nbphis)],sizeof(float),1,fd);
							}
						}
					}
					if (write_energytable) {
						for (ienergie=0 ; ienergie<nbenergies ; ienergie++) {
							fwrite (&ENERGY_TABLE[indice2(ispin,ienergie,nbspins,nbenergies)],sizeof(float),1,fd);
						}
						if (ENERGY_DELTA_PLUS[0] > -1e30) {
							for (ienergie=0 ; ienergie<nbenergies ; ienergie++) {
								fwrite (&ENERGY_DELTA_PLUS[indice2(ispin,ienergie,nbspins,nbenergies)],sizeof(float),1,fd);
							}
						}
						if (ENERGY_DELTA_MINUS[0] > -1e30) {
							for (ienergie=0 ; ienergie<nbenergies ; ienergie++) {
								fwrite (&ENERGY_DELTA_MINUS[indice2(ispin,ienergie,nbspins,nbenergies)],sizeof(float),1,fd);
							}
						}
					}
					for (imasse=0 ; imasse<nbmasses ; imasse++) {
						for (icellule=0 ; icellule<nbcellules ; icellule++) {
							for (ispectre=0 ; ispectre<nbspectres ; ispectre++) {
								for (ienergie=0 ; ienergie<nbenergies ; ienergie++) {
									val = tab_data[indice5(ispin,imasse,icellule,ispectre,ienergie,nbspins,nbmasses,nbcellules,nbspectres,nbenergies)];
									fwrite (&val,sizeof(float),1,fd);
								}
							}
						}
					}
					continue;
				}

				if (votable) {
					fputs ("<TR>",fd);
				}

				t2 = Milli_to_str_time (tab_date[ispin],dateformat);
				if (votable) {
					fprintf (fd, "<TD>%s</TD>", t2);
				} else {
					fprintf (fd, "%s", t2);
				}

				if (write_quality0) {
					fprintf (fd, formatstrQ, tab_quality0[ispin]);
				}

				if (write_quality1) {
					fprintf (fd, formatstrQ, tab_quality1[ispin]);
				}

				if (write_duration) {
					fprintf (fd, formatstrD, tab_duration[ispin]);
				}


				if (write_masstable) {

					// Mthode rapide: est-ce que les tables de masses sont les mmes que les dernires formates avec printf ?
					idem = 1;
					if (ispinm != -1) {
						for (imasse=0 ; imasse<nbmasses ; imasse++) {
							if (MASS_TABLE[indice2(ispin,imasse,nbspins,nbmasses)] != MASS_TABLE[indice2(ispinm,imasse,nbspins,nbmasses)]) {
								idem = 0;
								break;
							}
						}
						if (MASS_DELTA_PLUS[0] > -1e30) {
							for (imasse=0 ; imasse<nbmasses ; imasse++) {
								if (MASS_DELTA_PLUS[indice2(ispin,imasse,nbspins,nbmasses)] != MASS_DELTA_PLUS[indice2(ispinm,imasse,nbspins,nbmasses)]) {
									idem = 0;
									break;
								}
							}
						}
						if (MASS_DELTA_MINUS[0] > -1e30) {
							for (imasse=0 ; imasse<nbmasses ; imasse++) {
								if (MASS_DELTA_MINUS[indice2(ispin,imasse,nbspins,nbmasses)] != MASS_DELTA_MINUS[indice2(ispinm,imasse,nbspins,nbmasses)]) {
									idem = 0;
									break;
								}
							}
						}
					} else {
						idem = 0;
					}

					if (idem==0) {
						// recalcul de bufferm
						ispinm = ispin;
						p = bufferm;
						if (votable) {
							sprintf (p, "<TD>%n", &dep);
							p += dep;
						}
						for (imasse=0 ; imasse<nbmasses ; imasse++) {
							sprintf (p, formatstrE, MASS_TABLE[indice2(ispin,imasse,nbspins,nbmasses)],&dep);
							p += dep;
						}
						if (votable) {
							sprintf (p, "</TD><TD>%n", &dep);
							p += dep;
						}
						if (MASS_DELTA_PLUS[0] > -1e30) {
							for (imasse=0 ; imasse<nbmasses ; imasse++) {
								sprintf (p, formatstrE, MASS_DELTA_PLUS[indice2(ispin,imasse,nbspins,nbmasses)],&dep);
								p += dep;
							}
						}
						if (votable) {
							sprintf (p, "</TD><TD>%n", &dep);
							p += dep;
						}
						if (MASS_DELTA_MINUS[0] > -1e30) {
							for (imasse=0 ; imasse<nbmasses ; imasse++) {
								sprintf (p, formatstrE, MASS_DELTA_MINUS[indice2(ispin,imasse,nbspins,nbmasses)],&dep);
								p += dep;
							}
						}
						if (votable) {
							sprintf (p, "</TD>%n", &dep);
							p += dep;
						}
					}
					fprintf (fd,"%s",bufferm);

				}

				if (write_phitable) {

					// Mthode rapide: est-ce que les tables de phis sont les mmes que les dernires formates avec printf ?
					idem = 1;
					if (ispinp != -1) {
						for (iphi=0 ; iphi<nbphis ; iphi++) {
							if (PHI_TABLE[indice2(ispin,iphi,nbspins,nbphis)] != PHI_TABLE[indice2(ispinp,iphi,nbspins,nbphis)]) {
								idem = 0;
								break;
							}
						}
						if (PHI_DELTA_PLUS[0] > -1e30) {
							for (iphi=0 ; iphi<nbphis ; iphi++) {
								if (PHI_DELTA_PLUS[indice2(ispin,iphi,nbspins,nbphis)] != PHI_DELTA_PLUS[indice2(ispinp,iphi,nbspins,nbphis)]) {
									idem = 0;
									break;
								}
							}
						}
						if (PHI_DELTA_MINUS[0] > -1e30) {
							for (iphi=0 ; iphi<nbphis ; iphi++) {
								if (PHI_DELTA_MINUS[indice2(ispin,iphi,nbspins,nbphis)] != PHI_DELTA_MINUS[indice2(ispinp,iphi,nbspins,nbphis)]) {
									idem = 0;
									break;
								}
							}
						}
					} else {
						idem = 0;
					}

					if (idem==0) {
						// recalcul de bufferm
						ispinp = ispin;
						p = bufferp;
						if (votable) {
							sprintf (p, "<TD>%n", &dep);
							p += dep;
						}
						for (iphi=0 ; iphi<nbphis ; iphi++) {
							sprintf (p, formatstrE, PHI_TABLE[indice2(ispin,iphi,nbspins,nbphis)],&dep);
							p += dep;
						}
						if (votable) {
							sprintf (p, "</TD><TD>%n", &dep);
							p += dep;
						}
						if (PHI_DELTA_PLUS[0] > -1e30) {
							for (iphi=0 ; iphi<nbphis ; iphi++) {
								sprintf (p, formatstrE, PHI_DELTA_PLUS[indice2(ispin,iphi,nbspins,nbphis)],&dep);
								p += dep;
							}
						}
						if (votable) {
							sprintf (p, "</TD><TD>%n", &dep);
							p += dep;
						}
						if (PHI_DELTA_MINUS[0] > -1e30) {
							for (iphi=0 ; iphi<nbphis ; iphi++) {
								sprintf (p, formatstrE, PHI_DELTA_MINUS[indice2(ispin,iphi,nbspins,nbphis)],&dep);
								p += dep;
							}
						}
						if (votable) {
							sprintf (p, "</TD>%n", &dep);
							p += dep;
						}
					}
					fprintf (fd,"%s",bufferp);

				}
			
				if (write_energytable) {

					// Mthode lente: criture dans tous les cas avec printf
					//for (ienergie=0 ; ienergie<nbenergies ; ienergie++) fprintf (fd, formatstrE, ENERGY_TABLE[indice2(ispin,ienergie,nbspins,nbenergies)]);
					//for (ienergie=0 ; ienergie<nbenergies ; ienergie++) fprintf (fd, formatstrE, ENERGY_DELTA_PLUS[indice2(ispin,ienergie,nbspins,nbenergies)]);
					//for (ienergie=0 ; ienergie<nbenergies ; ienergie++) fprintf (fd, formatstrE, ENERGY_DELTA_MINUS[indice2(ispin,ienergie,nbspins,nbenergies)]);

					// Mthode rapide: est-ce que les tables d'nergies sont les mmes que les dernires formates avec printf ?
					idem = 1;
					if (ispine != -1) {
						for (ienergie=0 ; ienergie<nbenergies ; ienergie++) {
							if (ENERGY_TABLE[indice2(ispin,ienergie,nbspins,nbenergies)] != ENERGY_TABLE[indice2(ispine,ienergie,nbspins,nbenergies)]) {
								idem = 0;
								break;
							}
						}
						if (ENERGY_DELTA_PLUS[0] > -1e30) {
							for (ienergie=0 ; ienergie<nbenergies ; ienergie++) {
								if (ENERGY_DELTA_PLUS[indice2(ispin,ienergie,nbspins,nbenergies)] != ENERGY_DELTA_PLUS[indice2(ispine,ienergie,nbspins,nbenergies)]) {
									idem = 0;
									break;
								}
							}
						}
						if (ENERGY_DELTA_MINUS[0] > -1e30) {
							for (ienergie=0 ; ienergie<nbenergies ; ienergie++) {
								if (ENERGY_DELTA_MINUS[indice2(ispin,ienergie,nbspins,nbenergies)] != ENERGY_DELTA_MINUS[indice2(ispine,ienergie,nbspins,nbenergies)]) {
									idem = 0;
									break;
								}
							}
						}
					} else {
						idem = 0;
					}

					if (idem==0) {
						// recalcul de buffere
						ispine = ispin;
						p = buffere;
						if (votable) {
							sprintf (p, "<TD>%n", &dep);
							p += dep;
						}
						for (ienergie=0 ; ienergie<nbenergies ; ienergie++) {
							sprintf (p, formatstrE, ENERGY_TABLE[indice2(ispin,ienergie,nbspins,nbenergies)],&dep);
							p += dep;
						}
						if (votable) {
							sprintf (p, "</TD><TD>%n", &dep);
							p += dep;
						}
						if (ENERGY_DELTA_PLUS[0] > -1e30) {
							for (ienergie=0 ; ienergie<nbenergies ; ienergie++) {
								sprintf (p, formatstrE, ENERGY_DELTA_PLUS[indice2(ispin,ienergie,nbspins,nbenergies)],&dep);
								p += dep;
							}
						}
						if (votable) {
							sprintf (p, "</TD><TD>%n", &dep);
							p += dep;
						}
						if (ENERGY_DELTA_MINUS[0] > -1e30) {
							for (ienergie=0 ; ienergie<nbenergies ; ienergie++) {
								sprintf (p, formatstrE, ENERGY_DELTA_MINUS[indice2(ispin,ienergie,nbspins,nbenergies)],&dep);
								p += dep;
							}
						}
						if (votable) {
							sprintf (p, "</TD>%n", &dep);
							p += dep;
						}
					}
					fprintf (fd,"%s",buffere);

				}

				if (votable) {
					fputs ("<TD>",fd);
				}
				for (imasse=0 ; imasse<nbmasses ; imasse++) {
					for (icellule=0 ; icellule<nbcellules ; icellule++) {
						for (ispectre=0 ; ispectre<nbspectres ; ispectre++) {
							for (ienergie=0 ; ienergie<nbenergies ; ienergie++) {
								val=tab_data[indice5(ispin,imasse,icellule,ispectre,ienergie,nbspins,nbmasses,nbcellules,nbspectres,nbenergies)];
								if (val==0 || val==F_INFINITY) {
									fputs (zero,fd);
								} else if (is_sprintf93E) {
									if (votable) {
										fputs (sprintf93E (" ", val), fd);
									} else {
										fputs (sprintf93E (IDL_STRING_STR(separateur), val), fd);
									}
								} else {
									fprintf (fd, formatstrZ, val);
								}
							}
						}
					}
				}
				if (votable) {
					fputs ("</TD>",fd);
				}
				if (votable) {
					fputs ("</TR>\n",fd);
				} else {
					fprintf (fd,"%s\n", IDL_STRING_STR(fin_de_ligne));
				}
			}
		}
	}

	if (votable) {
		fputs ("</TABLEDATA>\n",fd);
		fputs ("</DATA>\n",fd);
		fputs ("</TABLE>\n",fd);
		fputs ("</RESOURCE>\n",fd);
		fputs ("</VOTABLE>\n",fd);
	}

	fclose (fd);

	return 1;

}

/*---------------------------------------------------------------------------*/
int WRITE_DATE_TAB_AUTO_GLUE (
/*---------------------------------------------------------------------------*/
	void	*p_nom_IDL,
	void	*p_separateur,
	void	*p_fin_de_ligne,
	void	*p04,
	void	*p05,
	void	*p06,
	void	*p07,
	void	*p08,
	void	*p09,
	void	*p10,
	void	*p11,
	void	*p12,
	void	*p13,
	void	*p14,
	void	*p15,
	void	*p16,
	void	*p17,
	void	*p18,
	void	*p19,
	void	*p20,
	void	*p21,
	void	*p22,
	void	*p23,
	void	*p24,
	void	*p25,
	void	*p26,
	void	*p27,
	void	*p28,
	void	*p29,
	void	*p30,
	void	*p31,
	void	*p32,
	void	*p33,
	void	*p_Dformat,
	void	*p_Eformat,
	void	*p_Zformat,
	void	*p37,
	void	*p38,
	void	*p39) {

	int		argc=39;
	void		*argv[39];
	int		code;
	IDL_STRING	*nom_IDL;
	IDL_STRING	*separateur;
	IDL_STRING	*fin_de_ligne;
	IDL_STRING	*Dformat;
	IDL_STRING	*Eformat;
	IDL_STRING	*Zformat;

	// p_nom_IDL -> nom_IDL
	nom_IDL = malloc (sizeof(IDL_STRING));
	IDL_StrStore (nom_IDL, p_nom_IDL);

	// p_separateur -> separateur
	separateur = malloc (sizeof(IDL_STRING));
	IDL_StrStore (separateur, p_separateur);

	// p_fin_de_ligne -> fin_de_ligne
	fin_de_ligne = malloc (sizeof(IDL_STRING));
	IDL_StrStore (fin_de_ligne, p_fin_de_ligne);

	// p_Dformat -> Dformat
	Dformat = malloc (sizeof(IDL_STRING));
	IDL_StrStore (Dformat, p_Dformat);

	// p_Eformat -> Eformat
	Eformat = malloc (sizeof(IDL_STRING));
	IDL_StrStore (Eformat, p_Eformat);

	// p_Zformat -> Zformat
	Zformat = malloc (sizeof(IDL_STRING));
	IDL_StrStore (Zformat, p_Zformat);

	argv[ 0] = nom_IDL;
	argv[ 1] = separateur;
	argv[ 2] = fin_de_ligne;
	argv[ 3] = p04;
	argv[ 4] = p05;
	argv[ 5] = p06;
	argv[ 6] = p07;
	argv[ 7] = p08;
	argv[ 8] = p09;
	argv[ 9] = p10;
	argv[10] = p11;
	argv[11] = p12;
	argv[12] = p13;
	argv[13] = p14;
	argv[14] = p15;
	argv[15] = p16;
	argv[16] = p17;
	argv[17] = p18;
	argv[18] = p19;
	argv[19] = p20;
	argv[20] = p21;
	argv[21] = p22;
	argv[22] = p23;
	argv[23] = p24;
	argv[24] = p25;
	argv[25] = p26;
	argv[26] = p27;
	argv[27] = p28;
	argv[28] = p29;
	argv[29] = p30;
	argv[30] = p31;
	argv[31] = p32;
	argv[32] = p33;
	argv[33] = Dformat;
	argv[34] = Eformat;
	argv[35] = Zformat;
	argv[36] = p37;
	argv[37] = p38;
	argv[38] = p39;
	code = WRITE_DATE_TAB (argc, argv);

	free (nom_IDL);
	free (separateur);
	free (fin_de_ligne);
	free (Dformat);
	free (Eformat);
	free (Zformat);

	return code;

}


/*---------------------------------------------------------------------------*/
int WRITE_TAB (int argc, void *argv[]) {
/*---------------------------------------------------------------------------*/

	int		nbarg			= 0;
	IDL_STRING	*nom_IDL		= (IDL_STRING *)	argv[nbarg++];
	IDL_STRING	*s			= (IDL_STRING *)	argv[nbarg++];
	int		nbX			= *(int *)		argv[nbarg++];
	float		*tab_data		= (float *)		argv[nbarg++]; /* tab_data[nbX] */
	IDL_STRING	*Zformat		= (IDL_STRING *)	argv[nbarg++];

	int	i;
	FILE	*fd;
	char	formatstr[1000];

	sprintf (formatstr," %s", IDL_STRING_STR(Zformat));

	fd = fopen (IDL_STRING_STR(nom_IDL),"a+");
	fprintf (fd, "%s", IDL_STRING_STR(s));

	for (i=0;i<nbX;i++)
		fprintf (fd, formatstr, tab_data[i]);
	fprintf (fd,"\n");

	fclose (fd);

	return 1;

}

/*---------------------------------------------------------------------------*/
int WRITE_TAB_AUTO_GLUE (
/*---------------------------------------------------------------------------*/
	void	*p_nom_IDL,
	void	*p_s,
	void	*p03,
	void	*p04,
	void	*p_Zformat) {

	int		argc=5;
	void		*argv[5];
	int		code;
	IDL_STRING	*nom_IDL;
	IDL_STRING	*s;
	IDL_STRING	*Zformat;

	// p_nom_IDL -> nom_IDL
	nom_IDL = malloc (sizeof(IDL_STRING));
	IDL_StrStore (nom_IDL, p_nom_IDL);

	// p_s -> s
	s = malloc (sizeof(IDL_STRING));
	IDL_StrStore (s, p_s);

	// p_Zformat -> Zformat
	Zformat = malloc (sizeof(IDL_STRING));
	IDL_StrStore (Zformat, p_Zformat);

	argv[0] = nom_IDL;
	argv[1] = s;
	argv[2] = p03;
	argv[3] = p04;
	argv[4] = Zformat;
	code = WRITE_TAB (argc, argv);

	free (nom_IDL);
	free (s);
	free (Zformat);

	return code;

}


/*---------------------------------------------------------------------------*/
int WRITE_LINE (int argc, void *argv[]) {
/*---------------------------------------------------------------------------*/

	int		nbarg			= 0;
	IDL_STRING	*nom_IDL		= (IDL_STRING *) argv[nbarg++];
	IDL_STRING	*ligne			= (IDL_STRING *) argv[nbarg++];

	FILE *fd;

	fd = fopen (IDL_STRING_STR(nom_IDL),"a+");
	fprintf (fd, "%s\n", IDL_STRING_STR(ligne));
	fclose (fd);

	return 1;

}

/*---------------------------------------------------------------------------*/
int WRITE_LINE_AUTO_GLUE (
/*---------------------------------------------------------------------------*/
	void	*p_nom_IDL,
	void	*p_ligne) {

	int		argc=2;
	void		*argv[2];
	int		code;
	IDL_STRING	*nom_IDL;
	IDL_STRING	*ligne;

	// p_nom_IDL -> nom_IDL
	nom_IDL = malloc (sizeof(IDL_STRING));
	IDL_StrStore (nom_IDL, p_nom_IDL);

	// p_ligne -> ligne
	ligne = malloc (sizeof(IDL_STRING));
	IDL_StrStore (ligne, p_ligne);

	argv[0] = nom_IDL;
	argv[1] = ligne;
	code = WRITE_LINE (argc, argv);

	free (nom_IDL);
	free (ligne);

	return code;

}
