/*------------------------------------------------------------------------------
 *
 *	Fichier	: $RCSfile: util.c,v $, v $Revision: 1.50 $
 *
 *	Date	: $Date: 2021/04/27 09:48:59 $
 *
 *	Auteur	: $Author: penou $
 *
 *	Version : %Z% version %I% de %M% du %G%
 *
 *------------------------------------------------------------------------------
 */


/*#define MESSAGE*/

#if defined (__WIN32__) || defined (__WIN64__)
	#include <windows.h>
#else
	#include <arpa/inet.h>
	#include <netdb.h>
#endif
#include <unistd.h>
#include <sys/stat.h>
#include <libgen.h>
#include <glob.h>

#include <stdio.h>
#include <stdlib.h>
#include <math.h>

#ifdef GDL
#include "libgdl.h"
#else
#include "export.h"
#endif

#include <string.h>

#include <sys/types.h>
/*#include <sys/wait.h>*/

#if defined (__linux__) || defined (__APPLE__)
	#define FINITE(x) finite(x)
#else
	#ifdef __WIN64__
	#include <ieeefp.h>
	#endif
	#define FINITE(x) finite(x)
#endif

#include "infini.h"


#define indice2(i1,i2,nb1,nb2)				((i1)+(nb1)*(i2))
#define indice3(i1,i2,i3,nb1,nb2,nb3)			((i1)+(nb1)*((i2)+(nb2)*(i3)))
#define indice4(i1,i2,i3,i4,nb1,nb2,nb3,nb4)		((i1)+(nb1)*((i2)+(nb2)*((i3)+(nb3)*(i4))))
#define indice5(i1,i2,i3,i4,i5,nb1,nb2,nb3,nb4,nb5)	((i1)+(nb1)*((i2)+(nb2)*((i3)+(nb3)*((i4)+(nb4)*(i5)))))
#define get_pfloat(tabdata,taille,offset,i,j)		(float *) (tabdata+(size_t)taille*(size_t)(i)+offset[j])
#define get_pdouble(tabdata,taille,offset,i,j)		(double *) (tabdata+(size_t)taille*(size_t)(i)+offset[j])
typedef unsigned char	byte1;


char		message[1024];


#define MAX_PATH_LEN 1024

/*---------------------------------------------------------------------------*/
char *basename1 (char *path) {
/*---------------------------------------------------------------------------*/


	/* 	Renvoie la partie se trouvant apres le dernier /. 
		Les / en fin de chaine ne font pas partie du chemin.

		Si le chemin ne contient pas de /, basename renvoie une copie de chemin.

		[OK] Si le chemin == '/', basename renvoie '/'

		Si le chemin == NULL ou vide, basename renvoie "."

	*/

	int	i;
	int	debut;
	int	fin;
	static	char	result[MAX_PATH_LEN];

	/*for (i=0 ; i<strlen(path) ; i++)
		if (path[i] == '\\')
			path[i] = '/';*/


	if (path[0] == 0) {

		sprintf (result,".");
		return result;

	}

	for (i=strlen(path)-1 ; i>=0 && path[i]=='/' ; i--);
	if (i == -1) {
		/* Le chemin revient a '/' */
		sprintf (result,"/");
		return result;
	}

	fin = i; /* dernier caractere ne contenant pas de '/' */
	i--;
	debut=0;
	for ( ; i>=0 ; i--) {
		if (path[i]=='/') {
			debut=i+1;
			break;
		}
	}

	for (i=debut ; i<=fin ; i++) {
		result[i-debut] = path[i];
		
	}

	result[i-debut]=0;
	return result;
		

}

/*---------------------------------------------------------------------------*/
char *my_basename (char *path) {
/*---------------------------------------------------------------------------*/

	if (strlen(path) >=2 && path[1] == ':') {

		return basename1 (path+2);

	} else {

		return basename1 (path);

	}

}


/*---------------------------------------------------------------------------*/
void MY_SPAWN_AUTO_GLUE (char *cmd) {
/*---------------------------------------------------------------------------*/

	system (cmd);

}

/*---------------------------------------------------------------------------*/
int MELANGER_TABX_TABY (int argc, void *argv[]) {
/*---------------------------------------------------------------------------*/

	int	nb1	= *(int *)	argv[0];
	int	nb2	= *(int *)	argv[1];
	double	*tabx1	= (double *)	argv[2]; /* tabx1[nb1] */
	float	*taby1	= (float *)	argv[3]; /* taby1[nb1] */
	double	*tabx2	= (double *)	argv[4]; /* tabx2[nb2] */
	float	*taby2	= (float *)	argv[5]; /* taby2[nb2] */
	double	*tabx3	= (double *)	argv[6]; /* tabx3[nb3] */
	float	*taby3	= (float *)	argv[7]; /* taby3[nb3] */
	int	*nb3	= (int *)	argv[8];

	/* 
	Entrees: 
		nb1, nb2, nb3, tabx1[nb1], taby1[nb1], tabx2[nb2], taby2[nb2]
		Les tableaux tabx1 et tabx2 doivent etre croissants.

	Sorties:
		nb3, tabx3[nb3], taby3[nb3].
		On rajoute la courbe1 a la courbe2 pour creer la courbe3
		Le tableau tabx3 sera aussi croissant. En cas de valeurs identiques
		dans tabx1 et tabx2, on utilisera tabx2.

	La courbe2 est prioritaire par rapport a la courbe1. Chaque point i de la courbe2
	est valable de tabx2[i] a tabx2[i]+dttrou.
	*/

	int i1=0,i2=0,i3=0;

	while (i1<nb1 || i2<nb2) {
		if (i1==nb1) {
			/* Il ne reste plus que la courbe 2 */
			tabx3[i3]=tabx2[i2]; taby3[i3]=taby2[i2]; i2++;i3++;
		} else if (i2==nb2) {
			/* Il ne reste plus que la courbe 1 */
			tabx3[i3]=tabx1[i1]; taby3[i3]=taby1[i1]; i3++;
			i1++;
		} else if (tabx1[i1]<tabx2[i2]) {
			tabx3[i3]=tabx1[i1]; taby3[i3]=taby1[i1]; i3++;
			i1++;
		} else if (tabx1[i1]>tabx2[i2]) {
			tabx3[i3]=tabx2[i2]; taby3[i3]=taby2[i2]; i2++;i3++;
		} else {
			tabx3[i3]=tabx2[i2]; taby3[i3]=taby2[i2]; i1++;i2++;i3++;
		}
	}
	*nb3=i3;

	return 0;

}


/*---------------------------------------------------------------------------*/
int MELANGER_TABX_TABY_AUTO_GLUE (
/*---------------------------------------------------------------------------*/
	void *p01,
	void *p02,
	void *p03,
	void *p04,
	void *p05,
	void *p06,
	void *p07,
	void *p08,
	void *p09) {

	int	argc=9;
	void	*argv[9];

	argv[0] = p01;
	argv[1] = p02;
	argv[2] = p03;
	argv[3] = p04;
	argv[4] = p05;
	argv[5] = p06;
	argv[6] = p07;
	argv[7] = p08;
	argv[8] = p09;
	return MELANGER_TABX_TABY (argc, argv);

}


/*---------------------------------------------------------------------------*/
int MELANGER_TABX_TABY_STRING (int argc, void *argv[]) {
/*---------------------------------------------------------------------------*/

	int		nb1	= *(int *)		argv[0];
	int		nb2	= *(int *)		argv[1];
	double		*tabx1	= (double *)		argv[2]; /* tabx1[nb1] */
	IDL_STRING	*taby1	= (IDL_STRING *)	argv[3]; /* taby1[nb1] */
	double		*tabx2	= (double *)		argv[4]; /* tabx2[nb2] */
	IDL_STRING	*taby2	= (IDL_STRING *)	argv[5]; /* taby2[nb2] */
	double		*tabx3	= (double *)		argv[6]; /* tabx3[nb3] */
	IDL_STRING	*taby3	= (IDL_STRING *)	argv[7]; /* taby3[nb3] */
	int		*nb3	= (int *)		argv[8];

	/* 
	Entrees: 
		nb1, nb2, nb3, tabx1[nb1], taby1[nb1], tabx2[nb2], taby2[nb2]
		Les tableaux tabx1 et tabx2 doivent etre croissants.

	Sorties:
		nb3, tabx3[nb3], taby3[nb3].
		On rajoute la courbe1 a la courbe2 pour creer la courbe3
		Le tableau tabx3 sera aussi croissant. En cas de valeurs identiques
		dans tabx1 et tabx2, on utilisera tabx2.

	La courbe2 est prioritaire par rapport a la courbe1. Chaque point i de la courbe2
	est valable de tabx2[i] a tabx2[i]+dttrou.
	*/

	int i1=0,i2=0,i3=0;

	while (i1<nb1 || i2<nb2) {
		if (i1==nb1) {
			/* Il ne reste plus que la courbe 2 */
			tabx3[i3]=tabx2[i2]; IDL_StrStore(taby3+i3,IDL_STRING_STR(taby2+i2)); i2++;i3++;
		} else if (i2==nb2) {
			/* Il ne reste plus que la courbe 1 */
			tabx3[i3]=tabx1[i1]; IDL_StrStore(taby3+i3,IDL_STRING_STR(taby1+i1)); i3++;
			i1++;
		} else if (tabx1[i1]<tabx2[i2]) {
			tabx3[i3]=tabx1[i1]; IDL_StrStore(taby3+i3,IDL_STRING_STR(taby1+i1)); i3++;
			i1++;
		} else if (tabx1[i1]>tabx2[i2]) {
			tabx3[i3]=tabx2[i2]; IDL_StrStore(taby3+i3,IDL_STRING_STR(taby2+i2)); i2++;i3++;
		} else {
			tabx3[i3]=tabx2[i2]; IDL_StrStore(taby3+i3,IDL_STRING_STR(taby2+i2)); i1++;i2++;i3++;
		}
	}
	*nb3=i3;

	return 0;

}

/*---------------------------------------------------------------------------*/
int MELANGER_TABX_TABY_STRING_AUTO_GLUE (
/*---------------------------------------------------------------------------*/
	void	*p_nb1,
	void	*p_nb2,
	void	*p03,
	void	*p_taby1,
	void	*p05,
	void	*p_taby2,
	void	*p07,
	void	*p_taby3,
	void	*p_nb3) {

	int		argc=9;
	void		*argv[9];
	int		code;
	int		i;
	int		nb1 = * (int *) p_nb1;
	int		nb2 = * (int *) p_nb2;
	int		nb3 = * (int *) p_nb3;
	IDL_STRING	*taby1;
	IDL_STRING	*taby2;
	IDL_STRING	*taby3;

	// p_taby1 -> taby1
	taby1 = malloc (nb1 * sizeof(IDL_STRING));
	for (i=0 ; i<nb1 ; i++) IDL_StrStore (taby1+i, p_taby1 + i*1024);

	// p_taby2 -> taby2
	taby2 = malloc (nb2 * sizeof(IDL_STRING));
	for (i=0 ; i<nb2 ; i++) IDL_StrStore (taby2+i, p_taby2 + i*1024);

	// p_taby3 -> taby3
	taby3 = malloc (nb3 * sizeof(IDL_STRING));
	for (i=0 ; i<nb3 ; i++) IDL_StrStore (taby3+i, p_taby3 + i*1024);

	argv[0] = p_nb1;
	argv[1] = p_nb2;
	argv[2] = p03;
	argv[3] = taby1;
	argv[4] = p05;
	argv[5] = taby2;
	argv[6] = p07;
	argv[7] = taby3;
	argv[8] = p_nb3;
	code = MELANGER_TABX_TABY_STRING (argc, argv);

	// taby3 -> p_taby3
	for (i=0 ; i<nb3 ; i++) strcpy (p_taby3+i*1024, IDL_STRING_STR(taby3+i));

	free (taby1);
	free (taby2);
	free (taby3);

	return code;

}

///*---------------------------------------------------------------------------*/
//int MELANGER_TABX_TABY_DOUBLE (int argc, void *argv[]) {
///*---------------------------------------------------------------------------*/
//
//	int	nb1    = *(int *)    argv[0];
//	int	nb2    = *(int *)    argv[1];
//	double	*tabx1 = (double *)  argv[2]; /* tabx1[nb1] */
//	double	*taby1 = (double *)  argv[3]; /* taby1[nb1] */
//	double	*tabx2 = (double *)  argv[4]; /* tabx2[nb2] */
//	double	*taby2 = (double *)  argv[5]; /* taby2[nb2] */
//	double	*tabx3 = (double *)  argv[6]; /* tabx3[nb3] */
//	double	*taby3 = (double *)  argv[7]; /* taby3[nb3] */
//	int	*nb3   = (int *)     argv[8];
//
//	/* 
//	Entrees: 
//		nb1, nb2, nb3, tabx1[nb1], taby1[nb1], tabx2[nb2], taby2[nb2]
//		Les tableaux tabx1 et tabx2 doivent etre croissants.
//
//	Sorties:
//		nb3, tabx3[nb3], taby3[nb3].
//		On rajoute la courbe1 a la courbe2 pour creer la courbe3
//		Le tableau tabx3 sera aussi croissant. En cas de valeurs identiques
//		dans tabx1 et tabx2, on utilisera tabx2.
//
//	La courbe2 est prioritaire par rapport a la courbe1. Chaque point i de la courbe2
//	est valable de tabx2[i] a tabx2[i]+dttrou.
//	*/
//
//	int i1=0,i2=0,i3=0;
//
//	while (i1<nb1 || i2<nb2) {
//		if (i1==nb1) {
//			/* Il ne reste plus que la courbe 2 */
//			tabx3[i3]=tabx2[i2]; taby3[i3]=taby2[i2]; i2++;i3++;
//		} else if (i2==nb2) {
//			/* Il ne reste plus que la courbe 1 */
//			tabx3[i3]=tabx1[i1]; taby3[i3]=taby1[i1]; i3++;
//			i1++;
//		} else if (tabx1[i1]<tabx2[i2]) {
//			tabx3[i3]=tabx1[i1]; taby3[i3]=taby1[i1]; i3++;
//			i1++;
//		} else if (tabx1[i1]>tabx2[i2]) {
//			tabx3[i3]=tabx2[i2]; taby3[i3]=taby2[i2]; i2++;i3++;
//		} else {
//			tabx3[i3]=tabx2[i2]; taby3[i3]=taby2[i2]; i1++;i2++;i3++;
//		}
//	}
//	*nb3=i3;
//
//	return 0;
//
//}

/*---------------------------------------------------------------------------*/
void GET_ADRESSEIP (int argc, void *argv[]) {
/*---------------------------------------------------------------------------*/

	IDL_STRING *adresse = (IDL_STRING *) argv[0];

	unsigned int i;

	#define BUFF_SIZE 256

	typedef char buffer_t[BUFF_SIZE];
	char nom0[]="127.0.0.1";
	char *nom;
	static buffer_t local_host;
	struct hostent *hp;
	struct in_addr in;

	#if defined (__WIN32__) || defined (__WIN64__)
	
		// je ne sais pas faire

	#else

	for (i=0; i<strlen(nom0); i++)
		(adresse->s)[i] = nom0[i];

	if (gethostname (local_host, BUFF_SIZE) != 0)
		return;

	if ((hp = gethostbyname (local_host)) == NULL)
		return;

	memcpy (&in.s_addr, *(hp->h_addr_list), sizeof(in.s_addr));
	nom = inet_ntoa (in);

	for (i=0; i<strlen(nom); i++)
		(adresse->s)[i] = nom[i];

	#endif

}

/*---------------------------------------------------------------------------*/
void GET_ADRESSEIP_AUTO_GLUE (
/*---------------------------------------------------------------------------*/
	void	*p_adresse) {

	int		argc=1;
	void		*argv[1];
	IDL_STRING	*adresse;

	// p_adresse -> adresse
	adresse = malloc (sizeof(IDL_STRING));
	IDL_StrStore (adresse, p_adresse);

	argv[0] = adresse;
	GET_ADRESSEIP (argc, argv);

	// adresse -> p_adresse
	strcpy (p_adresse, IDL_STRING_STR(adresse));

	free (adresse);

}


/*---------------------------------------------------------------------------*/
void CODER (int argc, void *argv[]) {
/*---------------------------------------------------------------------------*/

	int		nb = *(int *)		argv[0]; /* nombre de caracteres dans s1 */
	unsigned char	*s1 = (unsigned char *)	argv[1]; /* s1: chaine  coder */
	IDL_STRING	*s2 = (IDL_STRING *)	argv[2]; /* s2: chaine codee */

	unsigned char masque[]={
					3,1,4,1,5,6,2,6,1,8,3,9,0,2,7,2,
					3,0,3,8,3,6,2,7,0,3,8,2,7,2,0,2,
					0,2,8,7,3,6,3,6,8,2,9,2,0,2,8,2,
					7,6,2,6,2,7,2,9,2,9,2,8,2,7,6,2,
					6,2,7,6,3,9,8,9,4,8,9,2,7,9,3,4,
					6,7,1,8,4,6,1,2,7,4,6,1,9,3,8,1,
					0,9,4,8,1,0,9,4,8,0,1,9,8,4,0,1,
					9,8,4,0,1,4,1,5,4,7,3,6,1,5,3,8};
	int	i,j,k;
	char	chaine[100];

	k=0;
	for (i=0 ; i<nb ; i++) {
		sprintf (chaine,"%02X",s1[i] ^ masque[i]);
		for (j=0 ; j<strlen(chaine); j++)
			(s2->s)[k+j] = chaine[j];
		k+=2;
	}

}

/*---------------------------------------------------------------------------*/
void CODER_AUTO_GLUE (
/*---------------------------------------------------------------------------*/
	void	*p01,
	void	*p_s1,
	void	*p_s2) {

	int		argc=3;
	void		*argv[3];
	IDL_STRING	*s1;
	IDL_STRING	*s2;

	// p_s1 -> s1
	s1 = malloc (sizeof(IDL_STRING));
	IDL_StrStore (s1, p_s1);

	// p_s2 -> s2
	s2 = malloc (sizeof(IDL_STRING));
	IDL_StrStore (s2, p_s2);

	argv[0] = p01;
	argv[1] = s1;
	argv[2] = s2;
	CODER (argc, argv);

	// s2 -> p_s2
	strcpy (p_s2, IDL_STRING_STR(s2));

	free (s1);
	free (s2);

}

/*---------------------------------------------------------------------------*/
void AJOUTER_TAB (int argc, void *argv[]) {
/*---------------------------------------------------------------------------*/

	/* Entrees */
	IDL_STRING	*tabs1		= (IDL_STRING *)	argv[0]; /* tableau de nb1 string */
	int		nb1		= *(int *)		argv[1]; /* nombre de string dans tabs1 */
	IDL_STRING	*tabs2		= (IDL_STRING *)	argv[2]; /* tableau de nb2 string */
	int		nb2		= *(int *)		argv[3]; /* nombre de string dans tabs2 */

	/* Sorties */
	int		*nouveau	= (int *)		argv[4]; /* tableau de nb2 entiers contenant:
										- 0 si tabs2[i] est contenu dans tabs1
										- 1 si tabs2[i] sinon */
	int i,j;

	for (i=0 ; i<nb2 ; i++) {
		/* Pour chaque chaine de tabs2 */
		nouveau[i]=1;

		for (j=0 ; j<nb1 ; j++) /* tabs2[i] est-elle dans tabs1 ? */
			if (tabs2[i].slen == tabs1[j].slen)
				if (strncmp (tabs2[i].s , tabs1[j].s, tabs2[i].slen) == 0) {
					/* chaine trouve */
					nouveau[i]=0;
					break;
				}
	}

}


/*---------------------------------------------------------------------------*/
void AJOUTER_TAB_AUTO_GLUE (
/*---------------------------------------------------------------------------*/
	void	*p_tabs1,
	void	*p_nb1,
	void	*p_tabs2,
	void	*p_nb2,
	void	*p05) {

	int		argc=5;
	void		*argv[5];
	int		nb1 = * (int *) p_nb1;
	int		nb2 = * (int *) p_nb2;
	int		i;
	IDL_STRING	*tabs1;
	IDL_STRING	*tabs2;

	// p_tabs1 -> tabs1
	tabs1 = malloc (nb1 * sizeof(IDL_STRING));
	for (i=0 ; i<nb1 ; i++) IDL_StrStore (tabs1+i, p_tabs1 + i*1024);

	// p_tabs2 -> tabs2
	tabs2 = malloc (nb2 * sizeof(IDL_STRING));
	for (i=0 ; i<nb2 ; i++) IDL_StrStore (tabs2+i, p_tabs2 + i*1024);

	argv[0] = tabs1;
	argv[1] = p_nb1;
	argv[2] = tabs2;
	argv[3] = p_nb2;
	argv[4] = p05;
	AJOUTER_TAB (argc, argv);

	free (tabs1);
	free (tabs2);

}


/*---------------------------------------------------------------------------*/
double fichier1_plusrecentque_fichier2 (char *nom1, char *nom2) {
/*---------------------------------------------------------------------------*/

	struct stat	info1;
	struct stat	info2;

	if (stat (nom1, &info1) != 0) /* nom1 n'existe pas */
		return -1;

	if (stat (nom2, &info2) != 0) /* nom2 n'existe pas */
		return -1;

	#ifdef UTILISER_CTIME
	if ((info2.st_mtime < info1.st_mtime) || (info2.st_mtime < info1.st_ctime))
	#else
	if (info2.st_mtime < info1.st_mtime)
	#endif
											{

		return 1;

	} else {

		return 0;

	}

}



/*---------------------------------------------------------------------------*/
int DETERMINER_NEW_DATA (int argc, void *argv[]) {
/*---------------------------------------------------------------------------*/

	IDL_STRING	*masque1	= (IDL_STRING *)	argv[0]; /* Entree = masque pour les fichiers */
	IDL_STRING	*chem2		= (IDL_STRING *)	argv[1]; /* Entree = repertoire */
	int		*no_data	= (int *)		argv[2]; /* Sortie = 0 ou 1 */
	int		*new_data	= (int *)		argv[3]; /* Sortie = 0 ou 1 */

	int		i;
	int		j;
	glob_t		buffer1;
	glob_t		buffer2;
	char		masque[1024];
	char		*p1;
	char		*p2;
	int		termine=0;
	char		nom[1024];

	sprintf (masque, "%s", IDL_STRING_STR(masque1));

	buffer1.gl_offs = 0;
	glob (masque, GLOB_DOOFFS, NULL, & buffer1);

	if (buffer1.gl_pathc == 0) {
		/**no_data=1;*/
		termine=1;
	}

	for (i=0 ; i<buffer1.gl_pathc && termine==0; i++) {

		p1 = buffer1.gl_pathv [i];

		sprintf (nom,"%s",p1);
		sprintf (masque, "%s/%s*", IDL_STRING_STR(chem2), my_basename(nom));

		buffer2.gl_offs = 0;
		glob (masque, GLOB_DOOFFS, NULL, & buffer2);

		if (buffer2.gl_pathc == 0) {
			*new_data=1;
			termine=1;
		}

		for (j=0 ; j<buffer2.gl_pathc && termine==0; j++) {

			p2 = buffer2.gl_pathv [j];

			#ifdef MESSAGE
			sprintf (message,"nom1=%s  nom2=%s",p1,p2);
			IDL_Message (IDL_M_NAMED_GENERIC, IDL_MSG_INFO, message);
			#endif

			if (fichier1_plusrecentque_fichier2 (p1, p2) == 1) {

				*new_data=1;
				termine=1;

			}

		}

		globfree (& buffer2);

	}

	globfree (& buffer1);

	return 0;

}

/*---------------------------------------------------------------------------*/
int DETERMINER_NEW_DATA_AUTO_GLUE (
/*---------------------------------------------------------------------------*/
	void	*p_masque1,
	void	*p_chem2,
	void	*p03,
	void	*p04) {

	int		argc=4;
	void		*argv[4];
	int		code;
	IDL_STRING	*masque1;
	IDL_STRING	*chem2;

	// p_masque1 -> masque1
	masque1 = malloc (sizeof(IDL_STRING));
	IDL_StrStore (masque1, p_masque1);

	// p_chem2 -> chem2
	chem2 = malloc (sizeof(IDL_STRING));
	IDL_StrStore (chem2, p_chem2);

	argv[0] = masque1;
	argv[1] = chem2;
	argv[2] = p03;
	argv[3] = p04;
	code = DETERMINER_NEW_DATA (argc, argv);

	free (masque1);
	free (chem2);

	return code;

}

#if defined (__WIN32__) || defined (__WIN64__)
/*---------------------------------------------------------------------------*/
int MY_PUTENV (int argc, void *argv[]) {
/*---------------------------------------------------------------------------*/
	IDL_STRING	*cmd	= (IDL_STRING *) 	argv[0]; /* nom=valeur */

	putenv (IDL_STRING_STR(cmd));

	return 0;

}

/*---------------------------------------------------------------------------*/
int MY_PUTENV_AUTO_GLUE (
/*---------------------------------------------------------------------------*/
	void	*p_cmd) {

	int		argc=1;
	void		*argv[1];
	int		code;
	IDL_STRING	*cmd;

	// p_cmd -> cmd
	cmd = malloc (sizeof(IDL_STRING));
	IDL_StrStore (cmd, p_cmd);

	argv[0] = cmd;
	code = MY_PUTENV (argc, argv);

	free (cmd);

	return code;
}
#endif


/*---------------------------------------------------------------------------*/
int ALOG10_ZDATA (int argc, void *argv[]) {
/*---------------------------------------------------------------------------*/

	int	nb		=	*(int *)	argv[0];
	float	*Zdata		=	(float *)	argv[1]; /* Zdata[nb] */
	int	loguse		=	*(int *)	argv[2];
	float	log10logval	=	*(float *)	argv[3];
	float	infini		=	*(float *)	argv[4];

	int 	i;

	for (i=0 ; i<nb ; i++) {

		if (Zdata[i] <= 0) {

			Zdata[i] = (loguse==0) ? infini : log10logval;

		} else if (Zdata[i] != infini) {

			Zdata[i] = log10f (Zdata[i]);

		}

	}

	return 0;

}


/*---------------------------------------------------------------------------*/
int ALOG10_ZDATA_AUTO_GLUE (
/*---------------------------------------------------------------------------*/

	void *p01,
	void *p02,
	void *p03,
	void *p04,
	void *p05) {

	int	argc=5;
	void	*argv[5];

	argv[0] = p01;
	argv[1] = p02;
	argv[2] = p03;
	argv[3] = p04;
	argv[4] = p05;
	return ALOG10_ZDATA (argc, argv);

}


/*---------------------------------------------------------------------------*/
void MODULE_XYZ (int argc, void *argv[]) {
/*---------------------------------------------------------------------------*/

	int	nbarg		= 0;
	byte1	*Z1		= (byte1 *)	argv[nbarg++]; /* pointeur sur la structure avec x, y, z */
	int	nb1		= *(int *)	argv[nbarg++];
	int	taille1		= *(int *)	argv[nbarg++];
	int	offset_x	= *(int *)	argv[nbarg++];
	int	offset_y	= *(int *)	argv[nbarg++];
	int	offset_z	= *(int *)	argv[nbarg++];
	byte1	*Z2		= (byte1 *)	argv[nbarg++]; /* pointeur sur la structure avec module */
	int	nb2		= *(int *)	argv[nbarg++];
	int	taille2		= *(int *)	argv[nbarg++];
	int	offset_module	= *(int *)	argv[nbarg++];

	int 	i;
	float	x, y, z, module;

	if (nbarg != argc) return;

	for (i=0 ; i<nb1 ; i++) {

		x = * (float *) (Z1 + taille1*i + offset_x);
		y = * (float *) (Z1 + taille1*i + offset_y);
		z = * (float *) (Z1 + taille1*i + offset_z);

		if (x>-1e30 && y>-1e30 && z>=-1e30) {
			module = sqrt (x*x + y*y + z*z);
		} else {
			module = -1e31;
		}
		* (float *) (Z2 + taille2*i + offset_module) = module;

	}

}

/*---------------------------------------------------------------------------*/
void MODULE_XYZ_AUTO_GLUE (
/*---------------------------------------------------------------------------*/
	void *p01,
	void *p02,
	void *p03,
	void *p04,
	void *p05,
	void *p06,
	void *p07,
	void *p08,
	void *p09,
	void *p10) {

	int	argc=10;
	void	*argv[10];

	argv[0] = p01;
	argv[1] = p02;
	argv[2] = p03;
	argv[3] = p04;
	argv[4] = p05;
	argv[5] = p06;
	argv[6] = p07;
	argv[7] = p08;
	argv[8] = p09;
	argv[9] = p10;
	MODULE_XYZ (argc, argv);

}

/*---------------------------------------------------------------------------*/
int GET_ENERGY_TABLE (int argc, void *argv[]) {
/*---------------------------------------------------------------------------*/

	int		nbenergies	= *(int *)		argv[0];
	int		nblignes	= *(int *)		argv[1];
	int		taille		= *(int *)		argv[2]; /* taille en octets d'un enregistrement de la structure data */
	int		*offset		= (int *)		argv[3]; /* position en octets des champs dans la structure data */
	float		*ENERGY_TABLE	= (float *)		argv[4]; /* pointeur sur le tableau ENERGY_TABLE[nbenergies,nblignes] */
	int		*numeros	= (int *)		argv[5]; /* pointeur sur le tableau numeros[nbenergies] */
	unsigned char	*data		= (unsigned char *)	argv[6]; /* pointeur sur la structure data */

	int 	iligne,ienergie;
	float	*pfloat;

	for (iligne=0 ; iligne<nblignes ; iligne++) {

		for (ienergie=0 ; ienergie<nbenergies ; ienergie++) {

			// 17/11/2017: rajout de (size_t) sinon ca fait un core dump sur une vue MMS
			pfloat = (float *) (data + (size_t)taille*(size_t)iligne + (size_t)offset[numeros[ienergie]]);
			ENERGY_TABLE[indice2(ienergie,iligne,nbenergies,nblignes)] = *pfloat;

		}

	}

	return 0;

}

/*---------------------------------------------------------------------------*/
int GET_ENERGY_TABLE_AUTO_GLUE (
/*---------------------------------------------------------------------------*/

	void *p01,
	void *p02,
	void *p03,
	void *p04,
	void *p05,
	void *p06,
	void *p07) {

	int	argc=7;
	void	*argv[7];

	argv[0] = p01;
	argv[1] = p02;
	argv[2] = p03;
	argv[3] = p04;
	argv[4] = p05;
	argv[5] = p06;
	argv[6] = p07;
	return GET_ENERGY_TABLE (argc, argv);

}

/*---------------------------------------------------------------------------*/
int GET_HEURISTIQUE (int argc, void *argv[]) {
/*---------------------------------------------------------------------------*/

	int	nbenergies	= *(int *)	argv[0];
	int	nblignes	= *(int *)	argv[1];
	float	*ENERGY_TABLE	= (float *)	argv[2]; /* pointeur sur le tableau ENERGY_TABLE[nbenergies,nblignes] */
	double	*heuristique	= (double *)	argv[3]; /* pointeur sur le tableau heuristique[nblignes] */

	int 	ienergie,iligne;
	float	tmp;

	for (iligne=0 ; iligne<nblignes ; iligne++) {

		for (ienergie=0 ; ienergie<nbenergies ; ienergie++) {

			tmp = ENERGY_TABLE[indice2(ienergie,iligne,nbenergies,nblignes)];
			if (tmp == -1e31) {
				// arrive sur CDF L2 ESA
				ENERGY_TABLE[indice2(ienergie,iligne,nbenergies,nblignes)] = 0;
				continue;
			} else if (FINITE(tmp)==0) {
				continue;
			}

			// On ajoute une fois la premire nergie, puis 2 fois la seconde, ...
			// car si on se contente d'ajouter toutes les valeurs, on trouve pour le produit P12 SWEA des sommes identiques alors que les valeurs sont diffrentes

			heuristique[iligne] += (1+(double)(ienergie+1)/nbenergies) * tmp;

		}

	}

	return 0;

}

/*---------------------------------------------------------------------------*/
int GET_HEURISTIQUE_AUTO_GLUE (
/*---------------------------------------------------------------------------*/
	void *p01,
	void *p02,
	void *p03,
	void *p04) {

	int	argc=4;
	void	*argv[4];

	argv[0] = p01;
	argv[1] = p02;
	argv[2] = p03;
	argv[3] = p04;
	return GET_HEURISTIQUE (argc, argv);

}

/*---------------------------------------------------------------------------*/
int GET_INDTABLE (int argc, void *argv[]) {
/*---------------------------------------------------------------------------*/

	int	nbtables		= *(int *)	argv[0];
	int	nblignes		= *(int *)	argv[1];
	double	*heuristique		= (double *)	argv[2]; /* pointeur sur heuristique[nblignes] */
	double	*heuristique_uniq	= (double *)	argv[3]; /* pointeur sur heuristique_uniq[nblignes] */
	int	*indtable		= (int *)	argv[4]; /* pointeur sur indtable[nbtables] */

	int 	i,j;

	for (i=0 ; i<nbtables ; i++) {
		for (j=0 ; j<nblignes ; j++) {
			if (heuristique[j] == heuristique_uniq[i]) {
				indtable[i] = j;
				break;
			}
		}
	}

	return 0;

}

/*---------------------------------------------------------------------------*/
int GET_INDTABLE_AUTO_GLUE (
/*---------------------------------------------------------------------------*/
	void *p01,
	void *p02,
	void *p03,
	void *p04,
	void *p05) {

	int	argc=5;
	void	*argv[5];

	argv[0] = p01;
	argv[1] = p02;
	argv[2] = p03;
	argv[3] = p04;
	argv[4] = p05;
	return GET_INDTABLE (argc, argv);

}

/*---------------------------------------------------------------------------*/
int GET_INDY (int argc, void *argv[]) {
/*---------------------------------------------------------------------------*/

	int	nbtables	= *(int *)	argv[0];
	int	nblignes	= *(int *)	argv[1];
	double	*heuristique	= (double *)	argv[2]; /* pointeur sur heuristique[nblignes] */
	int	*indtable	= (int *)	argv[3]; /* pointeur sur indtable[nbtables] */
	int	*indY		= (int *)	argv[4]; /* pointeur sur indY[nblignes] */

	int 	i,j;

	for (i=0 ; i<nbtables ; i++) {
		for (j=0 ; j<nblignes ; j++) {
			if (heuristique[j] == heuristique[indtable[i]]) {
				indY[j] = i;
			}
		}
	}

	return 0;

}

/*---------------------------------------------------------------------------*/
int GET_INDY_AUTO_GLUE (
/*---------------------------------------------------------------------------*/
	void *p01,
	void *p02,
	void *p03,
	void *p04,
	void *p05) {

	int	argc=5;
	void	*argv[5];

	argv[0] = p01;
	argv[1] = p02;
	argv[2] = p03;
	argv[3] = p04;
	argv[4] = p05;
	return GET_INDY (argc, argv);

}

/*---------------------------------------------------------------------------*/
int TRANSLATER_TIME_THETA (int argc, void *argv[]) {
/*---------------------------------------------------------------------------*/

	int	nbspins		=	*(int *)	argv[0];
	int	nbspectres	=	*(int *)	argv[1];
	int	nby 		=	*(int *)	argv[2];
	int	spin_average	=	*(int *)	argv[3];
	float	*Z		=	(float *)	argv[4]; /* si spin_average=	1 alors Z[nbspins,nby]
											0       Z[nbspins*nbspectres,nby]*/
	int	*translation	=	(int *)		argv[5]; /* translation[nby] */
	int    	nbind 		=	*(int *)	argv[6];
	int	*ind		=	(int *)		argv[7];

	int	i;
	int	itrans;
	int	ispectre;
	float	*tmp = (float*)malloc(sizeof(float)*nby);

	if (spin_average == 1) {
		for (i=0 ; i<nbind ; i++) {
			for (itrans=0 ; itrans<nby ; itrans++) {
				tmp[itrans] = Z[indice2(ind[i],itrans,nbspins,nby)];
			}
			for (itrans=0 ; itrans<nby ; itrans++) {
				Z[indice2(ind[i],itrans,nbspins,nby)] = tmp[translation[itrans]];
			}
		}
	} else if (spin_average == 0) {
		for (i=0 ; i<nbind ; i++) {
			for (ispectre=0 ; ispectre<nbspectres ; ispectre++) {
				for (itrans=0 ; itrans<nby ; itrans++) {
					tmp[itrans] = Z[indice2(i*nbspectres+ispectre,itrans,nbspins*nbspectres,nbcellules)];
				}
				for (itrans=0 ; itrans<nby ; itrans++) {
					Z[indice2(i*nbspectres+ispectre,itrans,nbspins*nbspectres,nbcellules)] = tmp[translation[itrans]];
				}
			}
		}
	}

	free (tmp);
	return 0;

}

/*---------------------------------------------------------------------------*/
int TRANSLATER_TIME_THETA_AUTO_GLUE (
/*---------------------------------------------------------------------------*/
	void *p01,
	void *p02,
	void *p03,
	void *p04,
	void *p05,
	void *p06,
	void *p07,
	void *p08) {

	int	argc=8;
	void	*argv[8];

	argv[0] = p01;
	argv[1] = p02;
	argv[2] = p03;
	argv[3] = p04;
	argv[4] = p05;
	argv[5] = p06;
	argv[6] = p07;
	argv[7] = p08;
	return TRANSLATER_TIME_THETA (argc, argv);

}


/*---------------------------------------------------------------------------*/
int TRANSLATER_TIME_PHI (int argc, void *argv[]) {
/*---------------------------------------------------------------------------*/

	int	nbspins		=	*(int *)	argv[0];
	int	nbspectres	=	*(int *)	argv[1];
	int	nby 		=	*(int *)	argv[2];
	int	spin_average	=	*(int *)	argv[3];
	float	*Z		=	(float *)	argv[4]; /* si spin_average=	1 alors Z[nbspins,nby]
											0       Z[nbspins*nbspectres,nby]*/
	int	*translation	=	(int *)		argv[5]; /* translation[nby] */
	int	nbind 		=	*(int *)	argv[6];
	int	*ind		=	(int *)		argv[7];

	int	i;
	int	itrans;
	float	*tmp = (float*)malloc(sizeof(float)*nby);

	if (spin_average == 1) {
		for (i=0 ; i<nbind ; i++) {
			for (itrans=0 ; itrans<nby ; itrans++) {
				tmp[itrans] = Z[indice2(ind[i],itrans,nbspins,nby)];
			}
			for (itrans=0 ; itrans<nby ; itrans++) {
				Z[indice2(ind[i],itrans,nbspins,nby)] = tmp[translation[itrans]];
			}
		}
	} else if (spin_average == 0) {
		for (i=0 ; i<nbind ; i++) {
			for (itrans=0 ; itrans<nby ; itrans++) {
				tmp[itrans] = Z[indice2(ind[i],itrans,nbspins*nbspectres,nby)];
			}
			for (itrans=0 ; itrans<nby ; itrans++) {
				Z[indice2(ind[i],itrans,nbspins*nbspectres,nby)] = tmp[translation[itrans]];
			}
		}
	}

	free (tmp);
	return 0;

}

/*---------------------------------------------------------------------------*/
int TRANSLATER_TIME_PHI_AUTO_GLUE (
/*---------------------------------------------------------------------------*/
	void *p01,
	void *p02,
	void *p03,
	void *p04,
	void *p05,
	void *p06,
	void *p07,
	void *p08) {

	int	argc=8;
	void	*argv[8];

	argv[0] = p01;
	argv[1] = p02;
	argv[2] = p03;
	argv[3] = p04;
	argv[4] = p05;
	argv[5] = p06;
	argv[6] = p07;
	argv[7] = p08;
	return TRANSLATER_TIME_PHI (argc, argv);

}


/*---------------------------------------------------------------------------*/
int MOYENNE_GLISSANTE (int argc, void *argv[]) {
/*---------------------------------------------------------------------------*/

	int	nb_t	=	*(int *)	argv[0];
	double	*tab_t	=	(double *)	argv[1];
	double	*tdeb	=	(double *)	argv[2];
	double	*tfin	=	(double *)	argv[3];
	int	*ideb	=	(int *)		argv[4];
	int	*ifin	=	(int *)		argv[5];
	double	*tab_y	=	(double *)	argv[6];
	double	*tab1_y	=	(double *)	argv[7];


	int	no1 = 0;
	int	no2 = 0;
	int	i;
	int	j;

	for (i=0 ; i<nb_t ; i++) {

		while (no1 < nb_t) {
			if (tab_t[i] >= tdeb[no1]) {
				ideb[no1++] = i;
			} else {
				break;
			}
		}

		while (tab_t[i] > tfin[no2]) {
			ifin[no2++] = i-1;
		}

	}

	for (i=0 ; i<nb_t ; i++) {

		tab1_y[i] = 0;
		for (j=ideb[i] ; j<=ifin[i] ; j++) {
			tab1_y[i] += tab_y[j];
		}
		tab1_y[i] /= ifin[i]-ideb[i]+1;

	}

	return 0;

}

/*---------------------------------------------------------------------------*/
int MOYENNE_GLISSANTE_AUTO_GLUE (
/*---------------------------------------------------------------------------*/
	void *p01,
	void *p02,
	void *p03,
	void *p04,
	void *p05,
	void *p06,
	void *p07,
	void *p08) {

	int	argc=8;
	void	*argv[8];

	argv[0] = p01;
	argv[1] = p02;
	argv[2] = p03;
	argv[3] = p04;
	argv[4] = p05;
	argv[5] = p06;
	argv[6] = p07;
	argv[7] = p08;
	return MOYENNE_GLISSANTE (argc, argv);

}

/*---------------------------------------------------------------------------*/
int IMAGETRUE_TO_IMAGE (int argc, void *argv[]) {
/*---------------------------------------------------------------------------*/

	int		nbx		=	*(int *)		argv[0];
	int		nby		=	*(int *)		argv[1];
	unsigned char	*imagetrue	=	(unsigned char *)	argv[2];
	int		nbcouleurs	=	*(int *)		argv[3];
	short		*r		=	(short *)		argv[4];
	short		*v		=	(short *)		argv[5];
	short		*b		=	(short *)		argv[6];
	unsigned char	*image		=	(unsigned char *)	argv[7];

	int		i;
	int		j;
	int		k;
	unsigned int	dist;
	unsigned int	distmin;
	int		best;
	unsigned char	r0;
	unsigned char 	v0;
	unsigned char	b0;


	for (i=0 ; i<nbx ; i++) {

		for (j=0 ; j<nby ; j++) {

			best = -1;
			distmin = 0 ^ 0xFFFFFFFF; /* 2^32-1 */
			r0 = imagetrue[indice3(0,i,j,3,nbx,nby)];
			v0 = imagetrue[indice3(1,i,j,3,nbx,nby)];
			b0 = imagetrue[indice3(2,i,j,3,nbx,nby)];

			for (k=0 ; k<nbcouleurs; k++) {

				dist = abs (r0 - r[k]) + abs (v0 - v[k]) + abs(b0 - b[k]);

				if (dist < distmin) {
					distmin = dist;
					best = k;
					if (dist == 0)
					break;
				}
			}

			k = best;
			#ifdef MESSAGE
			if (distmin != 0) {
				sprintf (message,"imagetrue[%d,%d] = (%d,%d,%d) substitued by (%d,%d,%d)",
						i,j,
						imagetrue[indice3(0,i,j,3,nbx,nby)],
						imagetrue[indice3(1,i,j,3,nbx,nby)],
						imagetrue[indice3(2,i,j,3,nbx,nby)],
						r[k], v[k], b[k]);
				IDL_Message (IDL_M_NAMED_GENERIC, IDL_MSG_INFO, message);
			}
			#endif

			image[indice2(i,j,nbx,nby)] = k;

		}

	}


	return 0;


}

/*---------------------------------------------------------------------------*/
int IMAGETRUE_TO_IMAGE_AUTO_GLUE (
/*---------------------------------------------------------------------------*/
	void *p01,
	void *p02,
	void *p03,
	void *p04,
	void *p05,
	void *p06,
	void *p07,
	void *p08) {

	int	argc=8;
	void	*argv[8];

	argv[0] = p01;
	argv[1] = p02;
	argv[2] = p03;
	argv[3] = p04;
	argv[4] = p05;
	argv[5] = p06;
	argv[6] = p07;
	argv[7] = p08;
	return IMAGETRUE_TO_IMAGE (argc, argv);

}


/*---------------------------------------------------------------------------*/
int CONTENIR (int argc, void *argv[]) {
/*---------------------------------------------------------------------------*/

	double	*tab1	= (double *)	argv[0];
	double	*tab2	= (double *)	argv[1];
	int	nb1	= *(int *)	argv[2];
	int	nb2	= *(int *)	argv[3];
	int	*ind1	= (int *)	argv[4];
	int	*ind2	= (int *)	argv[5];

	/* 
	Entrees: 
		tab1[nb1] double	classe par ordre croissant
		tab2[nb2] double	classe par ordre croissant
		ind1[nb1] int		positionnes a 0
		ind2[nb2] int 		positionnes a 0
		nb        int		positionne a 0

		ind1 et ind2: positionne a 1 la ou les valeurs apparaissent a la fois dans tab1 et tab2

	Retourne:
		le nombre de valeurs apparaissant a la fois dans tab1 et tab2
	*/


	int	i1;
	int	i2;
	int	lasti=-1;
	int	nb=0;

	for (i1=0 ; i1<nb1 ; i1++) {

		for (i2=lasti+1 ; i2<nb2 ; i2++) {

			if (tab1[i1] == tab2[i2]) {

				ind1[i1] = ind2[i2] = 1;
				lasti = i2;
				nb++;
				break;

			} else if (tab2[i2] > tab1[i1]) {

				break;

			}

		}

	}

	return nb;

}

/*---------------------------------------------------------------------------*/
int CONTENIR_AUTO_GLUE (
/*---------------------------------------------------------------------------*/
	void *p01,
	void *p02,
	void *p03,
	void *p04,
	void *p05,
	void *p06) {

	int	argc=6;
	void	*argv[6];

	argv[0] = p01;
	argv[1] = p02;
	argv[2] = p03;
	argv[3] = p04;
	argv[4] = p05;
	argv[5] = p06;
	return CONTENIR (argc, argv);

}

#define TROU_DE_DONNEES_GENERIQUE(nb,tabdate,dttrou,tabok)							\
	int	i;												\
	for (i=0 ; i<nb-1 ; i++) {										\
		tabok[i] = ( (tabdate[i+1] - tabdate[i]) >= dttrou || (tabdate[i+1] - tabdate[i]) <= -dttrou );	\
	}
	


/*---------------------------------------------------------------------------*/
int TROU_DE_DONNEES_DOUBLE (int argc, void *argv[]) {
/*---------------------------------------------------------------------------*/

	double		*tabdate	= (double *)		argv[0];
	unsigned char	*tabok		= (unsigned char *)	argv[1];
	int		nb		= *(int *)		argv[2];
	double		dttrou		= *(double *)		argv[3];

	/* 
	Entrees: 
		tabdate:	tableau de nb date (nombre de millisecondes)
		nb:		dimension de tabdate
		dttrou:		nombre de millisecondes

	Sorties:
		tabok:		tableau de nb-1 unsigned char
				tabok[i] vaut 1 si tabdate[i+1]-tabdate[i] >= dttrou
				tabok[i] vaut 0 sinon

	*/

	TROU_DE_DONNEES_GENERIQUE(nb,tabdate,dttrou,tabok)

	return 0;

}

/*---------------------------------------------------------------------------*/
int TROU_DE_DONNEES_DOUBLE_AUTO_GLUE (
/*---------------------------------------------------------------------------*/
	void *p01,
	void *p02,
	void *p03,
	void *p04) {

	int	argc=4;
	void	*argv[4];

	argv[0] = p01;
	argv[1] = p02;
	argv[2] = p03;
	argv[3] = p04;
	return TROU_DE_DONNEES_DOUBLE (argc, argv);

}


/*---------------------------------------------------------------------------*/
int TROU_DE_DONNEES_INT (int argc, void *argv[]) {
/*---------------------------------------------------------------------------*/

	int		*tabdate	= (int *)		argv[0];
	unsigned char	*tabok		= (unsigned char *)	argv[1];
	int		nb		= *(int *)		argv[2];
	int		dttrou		= *(int *)		argv[3];

	/* 

	idem troudetm avec tabdate et dttrou de type int.

	*/

	TROU_DE_DONNEES_GENERIQUE(nb,tabdate,dttrou,tabok)

	return 0;

}


/*---------------------------------------------------------------------------*/
int TROU_DE_DONNEES_INT_AUTO_GLUE (
/*---------------------------------------------------------------------------*/
	void *p01,
	void *p02,
	void *p03,
	void *p04) {

	int	argc=4;
	void	*argv[4];

	argv[0] = p01;
	argv[1] = p02;
	argv[2] = p03;
	argv[3] = p04;
	return TROU_DE_DONNEES_INT (argc, argv);

}


/*---------------------------------------------------------------------------*/
int CHERCHER_NONFILLVAL (int argc, void *argv[]) {
/*---------------------------------------------------------------------------*/

	float	*tab	= (float *)	argv[0];
	int	nb	= *(int *)	argv[1];
	int	debut	= *(int *)	argv[2];
	int	*no1	= (int *)	argv[3];
	int	*no2	= (int *)	argv[4];

	/* 
	Entrees: 
		tab[nb]   float		tableau de nb float pouvant contenir des -1e31
		debut			commencer la recherche  l'indice debut

	Sorties:
		no1 et no2 tels que tab[no1:no2] ne contiennent pas de -1e31
	*/


	int	i;

	// rechercher  partir de debut la premire valeur diffrente de -1e31
	*no1 = -1;
	for (i=debut ; i<nb ; i++) {
		if (tab[i] >= -1e30) {
			*no1 = i;
			break;
		}
	}
		
	if (*no1 == -1) return 0;

	// tab[no1:no2] ne contiendra que des valeurs diffrentes de -1e31
	for (i=*no1 ; i<nb ; i++) {
		if (tab[i] < -1e30) break;
		*no2 = i;
	}

	return 0;

}

/*---------------------------------------------------------------------------*/
int CHERCHER_NONFILLVAL_AUTO_GLUE (
/*---------------------------------------------------------------------------*/
	void *p01,
	void *p02,
	void *p03,
	void *p04,
	void *p05) {

	int	argc=5;
	void	*argv[5];

	argv[0] = p01;
	argv[1] = p02;
	argv[2] = p03;
	argv[3] = p04;
	argv[4] = p05;
	return CHERCHER_NONFILLVAL (argc, argv);

}


/*---------------------------------------------------------------------------*/
void remplir (int nb1, double *intervalle1, int nb, double *intervalle, int *resultat, int val) {
/*---------------------------------------------------------------------------*/

	int	i;
	int	j;

	/* Remplir resultat avec intervalle1 */
	for (i=0 ; i<nb1 ; i+=2) {
		/* intervalle allant de intervalle1[i]  intervalle1[i+1] */

		for (j=0 ; j+1<nb ; j++) {
			/* intervalle allant de intervalle[j]  intervalle[j+1] */
	
			if (intervalle[j] >= intervalle1[i] && intervalle[j+1] <= intervalle1[i+1]) {
				resultat[j] += val;
			}

		}
	}

}


/*---------------------------------------------------------------------------*/
int JOINDRE_INTERVALLE (int argc, void *argv[]) {
/*---------------------------------------------------------------------------*/

	int		nbarg		= 0;
	int		nb1		= *(int *)		argv[nbarg++];
	double		*intervalle1	= (double *)		argv[nbarg++];
	int		nb2		= *(int *)		argv[nbarg++];
	double		*intervalle2	= (double *)		argv[nbarg++];
	int		nb		= *(int *)		argv[nbarg++];
	double		*intervalle	= (double *)		argv[nbarg++];
	int		*resultat	= (int *)		argv[nbarg++];

	remplir (nb1, intervalle1, nb, intervalle, resultat, 1);
	remplir (nb2, intervalle2, nb, intervalle, resultat, 2);

	return 1;

}

/*---------------------------------------------------------------------------*/
int JOINDRE_INTERVALLE_AUTO_GLUE (
/*---------------------------------------------------------------------------*/
	void *p01,
	void *p02,
	void *p03,
	void *p04,
	void *p05,
	void *p06,
	void *p07) {

	int	argc=7;
	void	*argv[7];

	argv[0] = p01;
	argv[1] = p02;
	argv[2] = p03;
	argv[3] = p04;
	argv[4] = p05;
	argv[5] = p06;
	argv[6] = p07;
	return JOINDRE_INTERVALLE (argc, argv);

}


/*---------------------------------------------------------------------------*/
int MODIFIER_ORDRE_DATA (int argc, void *argv[]) {
/*---------------------------------------------------------------------------*/

	int		nbarg		= 0;
	unsigned char	*data		= (unsigned char *)	argv[nbarg++]; /* pointeur sur la structure  renseigner */
	int		taille_struct	= *(int *)		argv[nbarg++]; /* nombre d'octets dans la structure */
	int		offset_champ	= *(int *)		argv[nbarg++]; /* position en octets dans la structure */
	int		taille_champ	= *(int *)		argv[nbarg++]; /* nombre d'octets par lments dans la structure */
	int		nbspins		= *(int *)		argv[nbarg++]; /* nombre de lignes data */
	int		nbangles	= *(int *)		argv[nbarg++]; /* nombre d'angles */
	int		nbenergies	= *(int *)		argv[nbarg++]; /* nombre d'nergies */
	int		nbmasses	= *(int *)		argv[nbarg++]; /* nombre de masses */
	int		nocas		= *(int *)		argv[nbarg++]; /* Identifie l'opration  effectuer */

	/*
	1: [angles,energies] -> [energies,angles] cas STEREO-SWEA
	2: [energies,angles] -> [energies,angles] avec inversion des nergies cas GEOTAIL LEP
	*/

	int		ispin;
	int		j;
	unsigned char	*p;
	unsigned char	*tmp;
	int		ienergie;
	int		iangle;
	int		src;
	int		dst;

	tmp = (unsigned char *) malloc (taille_champ*nbenergies*nbangles*nbmasses);

	for (ispin=0 ; ispin<nbspins ; ispin++) {
		p = data + ispin*taille_struct + offset_champ;

		if (nocas == 1) {
			for (iangle=0 ; iangle<nbangles ; iangle++) {
				for (ienergie=0 ; ienergie<nbenergies ; ienergie++) {
					src = indice2(iangle,ienergie,nbangles,nbenergies);
					dst = indice2(ienergie,iangle,nbenergies,nbangles);
					for (j=0 ; j<taille_champ ; j++) {
						tmp [taille_champ*dst+j] = p[taille_champ*src+j];
					}

				}

			}
		} else if (nocas == 2) {
			for (iangle=0 ; iangle<nbangles ; iangle++) {
				for (ienergie=0 ; ienergie<nbenergies ; ienergie++) {
					src = indice2(ienergie,iangle,nbenergies,nbangles);
					dst = indice2(nbenergies-ienergie-1,iangle,nbenergies,nbangles);
					for (j=0 ; j<taille_champ ; j++) {
						tmp [taille_champ*dst+j] = p[taille_champ*src+j];
					}

				}

			}
		}
		memcpy (p, tmp, taille_champ * nbangles * nbenergies * nbmasses);
	}
	free (tmp);

	return 1;

}

/*---------------------------------------------------------------------------*/
int MODIFIER_ORDRE_DATA_AUTO_GLUE (
/*---------------------------------------------------------------------------*/
	void *p01,
	void *p02,
	void *p03,
	void *p04,
	void *p05,
	void *p06,
	void *p07,
	void *p08,
	void *p09) {

	int	argc=9;
	void	*argv[9];

	argv[0] = p01;
	argv[1] = p02;
	argv[2] = p03;
	argv[3] = p04;
	argv[4] = p05;
	argv[5] = p06;
	argv[6] = p07;
	argv[7] = p08;
	argv[8] = p09;
	return MODIFIER_ORDRE_DATA (argc, argv);

}


/* Translation Table as described in RFC1113 */
static const char cb64[]="ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/";

void encodeblock (unsigned char in[3], unsigned char out[4], int len) {

	/*
	** encodeblock
	**
	** encode 3 8-bit binary bytes as 4 '6-bit' characters
	*/

	out[0] = cb64[ in[0] >> 2 ];
	out[1] = cb64[ ((in[0] & 0x03) << 4) | ((in[1] & 0xf0) >> 4) ];
	out[2] = (unsigned char) (len > 1 ? cb64[ ((in[1] & 0x0f) << 2) | ((in[2] & 0xc0) >> 6) ] : '=');
	out[3] = (unsigned char) (len > 2 ? cb64[ in[2] & 0x3f ] : '=');

}


void encode_string (char *infile, char *outfile) {

	/*
	** encode_string
	**
	** base64 encode a string adding padding and line breaks as per spec.
	*/

	int		linesize=72;
	unsigned char 	in[3];
	unsigned char 	out[4];
	int 		i;
	int 		len;
	int 		blocksout=0;
	int 		i_infile;
	int 		i_outfile=0;

	for (i_infile=0 ; infile[i_infile]; ) {
		len = 0;
		for (i = 0; i < 3; i++ ) {
			if (infile[i_infile]) {
				in[i] = infile[i_infile++];
				len++;
			} else {
				in[i] = 0;
			}
		}
		if (len) {
			encodeblock (in, out, len);
			for( i = 0; i < 4; i++ ) {
				outfile[i_outfile++] = out[i];
			}
			blocksout++;
		}
		if (blocksout >= (linesize/4)) {
			if (blocksout) {
				outfile[i_outfile++] = '\r';
				outfile[i_outfile++] = '\n';
			}
			blocksout = 0;
		}
	}
	outfile[i_outfile] = 0;
}


/*---------------------------------------------------------------------------*/
void CODER_LOGIN_PASSWORD (int argc, void *argv[]) {
/*---------------------------------------------------------------------------*/

	IDL_STRING	*entree	= (IDL_STRING *)	argv[0];	/* entree: chaine a coder */
	char		*sortie	= (char *)		argv[1];	/* sortie: chaine codee */

	encode_string (IDL_STRING_STR(entree), sortie);

}

/*---------------------------------------------------------------------------*/
void CODER_LOGIN_PASSWORD_AUTO_GLUE (
/*---------------------------------------------------------------------------*/
	void	*p_entree,
	void	*p02) {

	int		argc=2;
	void		*argv[2];
	IDL_STRING	*entree;

	// p_entree -> entree
	entree = malloc (sizeof(IDL_STRING));
	IDL_StrStore (entree, p_entree);

	argv[0] = entree;
	argv[1] = p02;
	CODER_LOGIN_PASSWORD (argc, argv);

	free (entree);

}


/*---------------------------------------------------------------------------*/
int ANALYSER_LINKS (int argc, void *argv[]) {
/*---------------------------------------------------------------------------*/

	int 		nb	= *(int *)		argv[0];
	IDL_STRING	*links	= (IDL_STRING *)	argv[1];
	IDL_STRING	*nom1	= (IDL_STRING *)	argv[2];
	int 		no	= *(int *)		argv[3];

	int	i;
	int	j;
	int	ok;
	int	no1=0;
	
	if (no==-1) {
		// Parcours de la fin vers le dbut pour trouver la dernire occurence
		for (i=nb-1 ; i>=0 ; i--) {
			if (links[i].slen==0) continue;
			ok=1;
			for (j=0 ; j<nom1[0].slen ; j++) {
				if (nom1[0].s[j] == '?' || (nom1[0].s[j] == links[i].s[j])) {
				} else {
					ok=0;
					break;
				}
			}
		
			if (ok==1) {
				if (no==-1 || no==no1) return i;
				no1++;
			}

		}
		return -1;
	}

	// Parcours du dbut vers la fin pour trouver l'occurence numro 'no'
	for (i=0; i<nb ; i++) {
		if (links[i].slen==0) continue;
		ok=1;
		for (j=0 ; j<nom1[0].slen ; j++) {
			if (nom1[0].s[j] == '?' || (nom1[0].s[j] == links[i].s[j])) {
			} else {
				ok=0;
				break;
			}
		}
	
		if (ok==1) {
			if (no==-1 || no==no1) return i;
			no1++;
		}

	}

	return -1;

}

/*---------------------------------------------------------------------------*/
int ANALYSER_LINKS_AUTO_GLUE (
/*---------------------------------------------------------------------------*/
	void	*p_nb,
	void	*p_links,
	void	*p_nom1,
	void	*p04) {

	int		argc=4;
	void		*argv[4];
	int		nb = * (int *) p_nb;
	int		i;
	int		code;
	IDL_STRING	*links;
	IDL_STRING	*nom1;

	// p_links -> links
	links = malloc (nb * sizeof(IDL_STRING));
	for (i=0 ; i<nb ; i++) IDL_StrStore (links+i, p_links + i*1024);

	// p_nom1 -> nom1
	nom1 = malloc (sizeof(IDL_STRING));
	IDL_StrStore (nom1, p_nom1);

	argv[0] = p_nb;
	argv[1] = links;
	argv[2] = nom1;
	argv[3] = p04;
	code = ANALYSER_LINKS (argc, argv);

	free (links);
	free (nom1);

	return code;

}


/*---------------------------------------------------------------------------*/
int NBIDEM_STRING1_STRING2 (int argc, void *argv[]) {
/*---------------------------------------------------------------------------*/

	/* Entrees */
	IDL_STRING *s1	= (IDL_STRING *)	argv[0]; /* string1 */
	IDL_STRING *s2	= (IDL_STRING *)	argv[1]; /* string2 */

	/* Retourne le nombre de caractres de s1 trouvs dans s2  la mme place */

	int	i;
	int	nbidem=0;

	for (i=0 ; i<s1->slen ; i++) { /* Pour chaque caractres de s1 */

		if (i == s2->slen) {
			break;
		}

		if (s1->s[i] == s2->s[i]) {
			nbidem ++;
		}
	}

	return nbidem;

}

/*---------------------------------------------------------------------------*/
int NBIDEM_STRING1_STRING2_AUTO_GLUE (
/*---------------------------------------------------------------------------*/
	char *s1,
	char *s2) {

	/* Retourne le nombre de caractres de s1 trouvs dans s2  la mme place */

	int	i;
	int	nbidem=0;

	for (i=0 ; i<strlen(s1) ; i++) { /* Pour chaque caractres de s1 */

		if (i == strlen(s2)) {
			break;
		}

		if (s1[i] == s2[i]) {
			nbidem ++;
		}
	}

	return nbidem;

}


/*---------------------------------------------------------------------------*/
int chercherdico_time_table (double date, int nb, double *liste) {
/*---------------------------------------------------------------------------*/

	int	ideb=0;
	int	ifin=nb-1;
	int	d;
	int	f;
	int	index;

	d = ideb;
	f = ifin;

	while (d+1 != f) {

		index = (d+f)/2;

		if (date == liste[index]) {
			return index;
		} else if (date < liste[index]) {
			f = index;
		} else {
			d = index;
		}
	}

	if (date==liste[d]) return d;
	if (date==liste[f]) return f;
	return -1;
}


/*---------------------------------------------------------------------------*/
int SIMPLIFIER2_TIME_TABLE (int argc, void *argv[]) {
/*---------------------------------------------------------------------------*/

	/* Entrees */
	int 		nb2		= *(int *)		argv[0];
	double 		*liste2		= (double *)		argv[1];	// liste2[nb2]
	int 		nb1		= *(int *)		argv[2];
	double 		*start_date	= (double *)		argv[3];	// start_date[nb1]
	double 		*end_date	= (double *)		argv[4];	// end_date[nb1]

	/* Sorties */
	int 		*utilise2	= (int *)		argv[5];	// utilise2[nb2]

	int		i;
	int		j;
	int		i1;
	int		i2;

	for (i=0 ; i<nb1 ; i++) {

		if (start_date[i] > end_date[i]) continue;
		if ((i1 = chercherdico_time_table (start_date[i], nb2, liste2)) == -1) continue;
		if ((i2 = chercherdico_time_table (end_date[i], nb2, liste2)) == -1) continue;

		for (j=i1 ; j<=i2-1 ; j++) {
			utilise2[j]=1;
		}

	}

	return 0;

}

/*---------------------------------------------------------------------------*/
int SIMPLIFIER2_TIME_TABLE_AUTO_GLUE (
/*---------------------------------------------------------------------------*/
	void *p01,
	void *p02,
	void *p03,
	void *p04,
	void *p05,
	void *p06) {

	int	argc=6;
	void	*argv[6];

	argv[0] = p01;
	argv[1] = p02;
	argv[2] = p03;
	argv[3] = p04;
	argv[4] = p05;
	argv[5] = p06;
	return SIMPLIFIER2_TIME_TABLE (argc, argv);

}


/*---------------------------------------------------------------------------*/
int SIMPLIFIER3_TIME_TABLE (int argc, void *argv[]) {
/*---------------------------------------------------------------------------*/

	/* Entrees */
	int 		nb		= *(int *)		argv[0];
	int 		*utilise	= (int *)		argv[1];	// utilise[nb]
	double 		*liste		= (double *)		argv[2];	// liste[nb]

	/* Sorties */
	double 		*no1		= (double *)		argv[3];	// no1[nb]
	double 		*no2		= (double *)		argv[4];	// no2[nb]

	int		i;
	int		j;

	j=0;
	for (i=0 ; i<nb ; i++) {
		if (utilise[i]==1) {
			no1[j] = liste[i];
			if (j!=0) {
				if (no2[j-1] == no1[j]) {
					no1[j]=-1e31; // prolongation de l'intervalle prcedent
					j--;
				}
			}
			no2[j] = liste[i+1];
			j++;
		}
	}
	return 0;
}

/*---------------------------------------------------------------------------*/
int SIMPLIFIER3_TIME_TABLE_AUTO_GLUE (
/*---------------------------------------------------------------------------*/
	void *p01,
	void *p02,
	void *p03,
	void *p04,
	void *p05) {

	int	argc=5;
	void	*argv[5];

	argv[0] = p01;
	argv[1] = p02;
	argv[2] = p03;
	argv[3] = p04;
	argv[4] = p05;
	return SIMPLIFIER3_TIME_TABLE (argc, argv);

}

/*---------------------------------------------------------------------------*/
int NORMALIZE (int argc, void *argv[]) {
/*---------------------------------------------------------------------------*/

	int	normaliser	= *(int *)	argv[0];
	int	nbx_xdata	= *(int *)	argv[1];
	int	nbx_ydata	= *(int *)	argv[2];
	int	nby_ydata	= *(int *)	argv[3];
	float	*Zdata		= (float *)	argv[4];
	float	infini		= *(float *)	argv[5];

	int	x_data;
	int	y_data;
	int	ind_data;
	float	min		= infini;
	float	max		= infini;
	float	somme;
	float	mean;
	int	nb;

	if (normaliser==1) {

		// min et max pour chaque abscisse (ex: spectro time_energy)

		for (x_data=0 ; x_data<nbx_xdata ; x_data++) {

			min = infini;
			max = infini;

			for (y_data=0 ; y_data<nby_ydata ; y_data++) {

				ind_data = x_data+nbx_xdata*y_data;
				if (fini(Zdata[ind_data],infini)==0) continue;
				if (fini(min,infini)==0) min = max = Zdata[ind_data];
				if (Zdata[ind_data]<min) min=Zdata[ind_data];
				if (Zdata[ind_data]>max) max=Zdata[ind_data];

			}

			if (fini(min,infini)==0) continue;
			if (fini(max,infini)==0) continue;

			for (y_data=0 ; y_data<nby_ydata ; y_data++) {
				ind_data = x_data+nbx_xdata*y_data;
				if (fini(Zdata[ind_data],infini)==0) continue;
				Zdata[ind_data] = (min==max) ? 0 : (Zdata[ind_data]-min)/(max-min);
			}

		}

	} else if (normaliser==2) {

		// min max pour toute l'image (ex: spectro phi_theta);

		min = infini;
		max = infini;

		for (x_data=0 ; x_data<nbx_xdata ; x_data++) {

			for (y_data=0 ; y_data<nby_ydata ; y_data++) {

				ind_data = x_data+nbx_xdata*y_data;
				if (fini(Zdata[ind_data],infini)==0) continue;
				if (fini(min,infini)==0) min = max = Zdata[ind_data];
				if (Zdata[ind_data]<min) min=Zdata[ind_data];
				if (Zdata[ind_data]>max) max=Zdata[ind_data];

			}

		}

		if (fini(min,infini)==0) return 0;
		if (fini(max,infini)==0) return 0;

		for (x_data=0 ; x_data<nbx_xdata ; x_data++) {

				for (y_data=0 ; y_data<nby_ydata ; y_data++) {
				ind_data = x_data+nbx_xdata*y_data;
				if (fini(Zdata[ind_data],infini)==0) continue;
				Zdata[ind_data] = (min==max) ? 0 : (Zdata[ind_data]-min)/(max-min);
			}

		}

	} else if (normaliser==3) {

		// mean pour chaque abscisse (ex: spectro time_energy)

		for (x_data=0 ; x_data<nbx_xdata ; x_data++) {

			somme = 0;
			nb = 0;

			for (y_data=0 ; y_data<nby_ydata ; y_data++) {

				ind_data = x_data+nbx_xdata*y_data;
				if (fini(Zdata[ind_data],infini)==0) continue;
				somme += Zdata[ind_data];
				nb++;

			}

			if (nb==0) continue;
			mean = somme / nb;

			for (y_data=0 ; y_data<nby_ydata ; y_data++) {
				ind_data = x_data+nbx_xdata*y_data;
				if (fini(Zdata[ind_data],infini)==0) continue;
				Zdata[ind_data] = Zdata[ind_data]/mean;
			}

		}

	}

	return 0;

}


/*---------------------------------------------------------------------------*/
int NORMALIZE_AUTO_GLUE (
/*---------------------------------------------------------------------------*/
	void *p01,
	void *p02,
	void *p03,
	void *p04,
	void *p05,
	void *p06) {

	int	argc=6;
	void	*argv[6];

	argv[0] = p01;
	argv[1] = p02;
	argv[2] = p03;
	argv[3] = p04;
	argv[4] = p05;
	argv[5] = p06;
	return NORMALIZE (argc, argv);

}


/*---------------------------------------------------------------------------*/
int ELS_TURBO (int argc, void *argv[]) {
/*---------------------------------------------------------------------------*/

	int	*big		= (int *)	argv[0];	/* INPUT big[nbspins] */
	int	nbspins		= *(int *)	argv[1];	/* INPUT nbspins */
	int	*premier	= (int *)	argv[2];	/* OUTPUT premier[nbspins] */
	int	*nb		= (int *)	argv[3];	/* OUTPUT nb */

	int	ispin;

	*nb=0;
	premier[*nb] = 0;

	for (ispin=0 ; ispin<nbspins ; ispin++) {

		if (big[ispin] != big[premier[*nb]]) {

			(*nb)++;
			premier[*nb] = ispin;

		}

	}

	(*nb)++;

	return 0;

}

/*---------------------------------------------------------------------------*/
int ELS_TURBO_AUTO_GLUE (
/*---------------------------------------------------------------------------*/
	void *p01,
	void *p02,
	void *p03,
	void *p04) {

	int	argc=4;
	void	*argv[4];

	argv[0] = p01;
	argv[1] = p02;
	argv[2] = p03;
	argv[3] = p04;
	return ELS_TURBO (argc, argv);

}

/*---------------------------------------------------------------------------*/
void TURBO1_ARBRE (int argc, void *argv[]) {
/*---------------------------------------------------------------------------*/

	/* Entrees */
	int		batch	= *(int *)		argv[0]; /* batch */
	int		nb	= *(int *)		argv[1]; /* i */
	IDL_STRING	*arbre	= (IDL_STRING *)	argv[2]; /* string a analyser: arbre[i] */

	/* Sorties */
	IDL_STRING	*arbre1	= (IDL_STRING *)	argv[3]; /* sorties: arbre1[i] */
	IDL_STRING	*arbre2	= (IDL_STRING *)	argv[4]; /* sorties: arbre2[i] */

	char		s[10240];
	
	int		i;
	int		j;
	int		k;
	int		decalage;
	int		no1;
	int		no2;

	int		len;

	for (i=0 ; i<nb ; i++) {

		len = arbre[i].slen;

		no1 = -1;
		for (j=0 ; j<len ; j++) {
			if (arbre[i].s[j] == '#') {
				no1 = j;
				break;
			}
		}
		if (no1 != -1) {

			// ex: arbre[i] = "0 Proton Flux 0.48-0.97 Mev#    ACE P1 SC1 H_lo header"

			// ex: arbre1[i] = "0 Proton Flux 0.48-0.97 Mev"
			k = 0;
			for (j=0 ; j<no1 ; j++)
				s[k++] = arbre[i].s[j];
			s[k] = 0;

			IDL_StrStore (&arbre1[i],s);

			// ex: arbre[2] = "        ACE P1 SC1 H_lo header"
			k = 0;
			for (j=1+no1 ; j<len ; j++)
				s[k++] = arbre[i].s[j];
			s[k] = 0;
			IDL_StrStore (&arbre2[i],s);

		} else if (batch) {

			IDL_StrStore (&arbre1[i],IDL_STRING_STR(&arbre[i]));

		} else if (!batch) {

			// ex: arbre[i] = "2 ACE {01/Jan/2000 ... 01/Jan/9999}"

			no1 = -1;
			no2 = -1;
			for (j=0 ; j<len ; j++) {
				if (arbre[i].s[j] == '{')
					no1 = j;
				if (arbre[i].s[j] == '}') {
					no2 = j;
					//break; plus lent avec le break!
				}
			}
			if (no1==-1 || no2==-1) {
				IDL_StrStore (&arbre1[i],IDL_STRING_STR(&arbre[i]));
				continue;
			}

			sscanf (arbre[i].s,"%d",&decalage);

			k = 0;
			for (j=0 ; j<no1 ; j++)
				s[k++] = arbre[i].s[j];

			for (j=no1+decalage*3 ; j<=103 ; j++)
				s[k++] = '-';

			for (j=no1 ; j<len ; j++)
				s[k++] = arbre[i].s[j];
			s[k] = 0;

			// ex: arbre1[i] = "2 ACE ----------------------------------------- {01/Jan/2000 ... 01/Jan/9999}"
			IDL_StrStore (&arbre1[i],s);

		}

	}

}

/*---------------------------------------------------------------------------*/
void TURBO1_ARBRE_AUTO_GLUE (
/*---------------------------------------------------------------------------*/
	void	*p01,
	void	*p_nb,
	void	*p_arbre,
	void	*p_slen_arbre,
	void	*p_arbre1,
	void	*p_arbre2) {

	int		argc=5;
	void		*argv[5];
	int		nb = * (int *) p_nb;
	int		s_len_arbre = * (int *) p_slen_arbre;
	int		i;
	IDL_STRING	*arbre;
	IDL_STRING	*arbre1;
	IDL_STRING	*arbre2;

	arbre = malloc (nb * sizeof(IDL_STRING));
	for (i=0 ; i<nb ; i++) IDL_StrStore (arbre+i, p_arbre+i*s_len_arbre);

	arbre1 = malloc (nb * sizeof(IDL_STRING));
	for (i=0 ; i<nb ; i++) IDL_StrStore (arbre1+i, p_arbre1+i*1024);

	arbre2 = malloc (nb * sizeof(IDL_STRING));
	for (i=0 ; i<nb ; i++) IDL_StrStore (arbre2+i, p_arbre2+i*1024);

	argv[0] = p01;
	argv[1] = p_nb;
	argv[2] = arbre;
	argv[3] = arbre1;
	argv[4] = arbre2;
	TURBO1_ARBRE (argc, argv);

	// arbre1 -> p_arbre1
	for (i=0 ; i<nb ; i++) sprintf (p_arbre1+i*1024, "%s", IDL_STRING_STR(arbre1+i));

	// arbre2 -> p_arbre2
	for (i=0 ; i<nb ; i++) sprintf (p_arbre2+i*1024, "%s", IDL_STRING_STR(arbre2+i));

	free (arbre);
	free (arbre1);
	free (arbre2);

}


/*---------------------------------------------------------------------------*/
void TURBO2_ARBRE (int argc, void *argv[]) {
/*---------------------------------------------------------------------------*/

	/* Entrees */
	int		nb	= *(int *)		argv[0]; /* i */
	IDL_STRING	*v	= (IDL_STRING *)	argv[1]; /* string a analyser: v[i] */

	/* Sorties */
	int		*no	= (int *)		argv[2]; /* no[i] */
	IDL_STRING	*label	= (IDL_STRING *)	argv[3]; /* string a analyser: v[i] */

	char		s[10240];
	
	int		i;
	int		j;
	int		pos;
	int		len;
	int		dep;

	for (i=0 ; i<nb ; i++) {

		if (v[i].slen==0) continue;

		sscanf (v[i].s,"%d%n",&no[i],&dep);
		strcpy (s,v[i].s+dep+1);

		pos = -1;
		len = strlen(s);
		for (j=0 ; j<len ; j++) {
	
			if (s[j]==4) {
				pos=j;
				break;
			}

		}

		if (pos!=-1) {
			s[pos]='[';
			s[len]=']';
			s[len+1]=0;
		}

		IDL_StrStore (&label[i],s);

	}

}

/*---------------------------------------------------------------------------*/
void TURBO2_ARBRE_AUTO_GLUE (
/*---------------------------------------------------------------------------*/
	void	*p_nb,
	void	*p_v,
	void	*p_slen_v,
	void	*p03,
	void	*p_label) {

	int		argc=4;
	void		*argv[4];
	int		nb = * (int *) p_nb;
	int		slen_v = * (int *) p_slen_v;
	int		i;
	IDL_STRING	*v;
	IDL_STRING	*label;

	v = malloc (nb * sizeof(IDL_STRING));
	for (i=0 ; i<nb ; i++) IDL_StrStore (v+i, p_v+i*slen_v);

	label = malloc (nb * sizeof(IDL_STRING));
	for (i=0 ; i<nb ; i++) IDL_StrStore (label+i, p_label+i*1024);

	argv[0] = p_nb;
	argv[1] = v;
	argv[2] = p03;
	argv[3] = label;
	TURBO2_ARBRE (argc, argv);

	// label -> p_label
	for (i=0 ; i<nb ; i++) sprintf (p_label+i*1024, "%s", IDL_STRING_STR(label+i));

	free (v);
	free (label);

}


/*---------------------------------------------------------------------------*/
void DATAQUICK_TO_DATA (int argc, void *argv[]) {
/*---------------------------------------------------------------------------*/

	int		nbarg		= 0;
	int		nbenergies	= *(int *)	argv[nbarg++];
	int		nbspectres	= *(int *)	argv[nbarg++];
	int		nbcellules	= *(int *)	argv[nbarg++];
	int		nbangles	= *(int *)	argv[nbarg++];
	int		nbmasses	= *(int *)	argv[nbarg++];
	int		*solid		= (int *)	argv[nbarg++]; /* solid[nbspectres,nbcellules] */
	int		no 		= *(int *)	argv[nbarg++];
	size_t		*dataquick	= (size_t *)	argv[nbarg++];
	short		*coups		= (short *)	argv[nbarg++];

	int		ispectre;
	int		ienergie;
	int		nbcoups;
	int		icellule;
	int		imasse;
	int		iangle;
	int		coup_telemesure;
	unsigned char	*p;
	int		nbytes=2;
	int		i;

	if (nbarg != argc) return;

	bzero (coups, nbcellules*nbspectres*nbenergies*nbmasses*nbytes);

	for (ispectre=0 ; ispectre<nbspectres ; ispectre++) {
		for (ienergie=0 ; ienergie<nbenergies ; ienergie++) {
			if ((p = (unsigned char *) dataquick[indice3(ienergie,ispectre,no,nbenergies,nbspectres,INUTILE)]) != 0) {
				nbcoups = 256*p[0] + p[1];
				for (i=0 ; i<nbcoups ; i++) {
					icellule = p[2+4*i+0];
					imasse   = p[2+4*i+1];
					iangle = solid[indice2(ispectre,icellule,nbspectres,nbcellules)];
					coup_telemesure = p[2+4*i+2]*256 + p[2+4*i+3];
					coups[indice3(ienergie,iangle,imasse,nbenergies,nbangles,nbmasses)] = coup_telemesure;
				}
			}
		}
	}

}

/*---------------------------------------------------------------------------*/
void DATAQUICK_TO_DATA_AUTO_GLUE (
/*---------------------------------------------------------------------------*/
	void *p01,
	void *p02,
	void *p03,
	void *p04,
	void *p05,
	void *p06,
	void *p07,
	void *p08,
	void *p09) {

	int	argc=9;
	void	*argv[9];

	argv[0] = p01;
	argv[1] = p02;
	argv[2] = p03;
	argv[3] = p04;
	argv[4] = p05;
	argv[5] = p06;
	argv[6] = p07;
	argv[7] = p08;
	argv[8] = p09;
	DATAQUICK_TO_DATA (argc, argv);

}


/*---------------------------------------------------------------------------*/
void MOYENNER_VECTEUR (int argc, void *argv[]) {
/*---------------------------------------------------------------------------*/

	int	nbarg		=	0;
	int	nb		=	*(int *)	argv[nbarg++];
	double	*tabtdeb	=	(double *)	argv[nbarg++];
	double	*tabtfin	=	(double *)	argv[nbarg++];
	int	nb1		=	*(int *)	argv[nbarg++];
	double	*date1		=	(double *)	argv[nbarg++];
	float	*x1		=	(float *)	argv[nbarg++];
	float	*y1		=	(float *)	argv[nbarg++];
	float	*z1		=	(float *)	argv[nbarg++];
	float	*x2		=	(float *)	argv[nbarg++];
	float	*y2		=	(float *)	argv[nbarg++];
	float	*z2		=	(float *)	argv[nbarg++];
	int	*nbpts		=	(int *)		argv[nbarg++];

	int	i;
	int	j1;
	int	j2;
	int	j;
	int	nbj;
	double	tdeb;
	double	tfin;
	float	bx;
	float	by;
	float	bz;

	if (nbarg != argc) return;

	j1=0;
	for (i=0 ; i<nb ; i++) {
		tdeb = tabtdeb[i];
		tfin = tabtfin[i];

		/* Recherche du plus petit j1 tel que date1[j1]>=tdeb */
		for ( ; j1<nb1 && date1[j1]<tdeb ; j1++);
		if (j1>=nb1) break;

		/* Recherche du plus grand j2 tel que date1[j2]<=tfin */
		for (j2=j1 ; j2<nb1 && date1[j2]<=tfin ; j2++);
		j2--;
		nbj = j2-j1+1;
		if (nbj>0) {
			bx=by=bz=0.; /* Moyenne des valeurs de B dans le spin */
			for (j=j1 ; j<=j2 ; j++) {
				bx += x1[j];
				by += y1[j];
				bz += z1[j];
			}
			nbpts[i] = nbj;
			bx /= nbj;
			by /= nbj;
			bz /= nbj;
			x2[i] = bx;
			y2[i] = by;
			z2[i] = bz;
		}
		// ligne commente le 13/09/2016 sinon la moyenne ne marche pas si les fenetres en temps se chevauchent
		//if (j2>j1) j1=j2;

	}

}

/*---------------------------------------------------------------------------*/
void MOYENNER_VECTEUR_AUTO_GLUE (
/*---------------------------------------------------------------------------*/
	void *p01,
	void *p02,
	void *p03,
	void *p04,
	void *p05,
	void *p06,
	void *p07,
	void *p08,
	void *p09,
	void *p10,
	void *p11,
	void *p12) {

	int	argc=12;
	void	*argv[12];

	argv[ 0] = p01;
	argv[ 1] = p02;
	argv[ 2] = p03;
	argv[ 3] = p04;
	argv[ 4] = p05;
	argv[ 5] = p06;
	argv[ 6] = p07;
	argv[ 7] = p08;
	argv[ 8] = p09;
	argv[ 9] = p10;
	argv[10] = p11;
	argv[11] = p12;
	return MOYENNER_VECTEUR (argc, argv);

}


/*---------------------------------------------------------------------------*/
void GET_REP1_TO_REP2 (int argc, void *argv[]) {
/*---------------------------------------------------------------------------*/

	int	nbarg		= 0;
	int	nb		= *(int *)	argv[nbarg++];
	double	*date		= (double *)	argv[nbarg++];
	float	*x1		= (float *)	argv[nbarg++]; /* (x1, y1, z1) repere rep1 */
	float	*y1		= (float *)	argv[nbarg++];
	float	*z1		= (float *)	argv[nbarg++];
	float	*x2		= (float *)	argv[nbarg++]; /* (x2, y2, z2) repere rep2 */
	float	*y2		= (float *)	argv[nbarg++];
	float	*z2		= (float *)	argv[nbarg++];
	int	nbmat		= *(int *)	argv[nbarg++];
	double	*datemat	= (double *)	argv[nbarg++];
	float	*M00		= (float *)	argv[nbarg++];
	float	*M01		= (float *)	argv[nbarg++];
	float	*M02		= (float *)	argv[nbarg++];
	float	*M10		= (float *)	argv[nbarg++];
	float	*M11		= (float *)	argv[nbarg++];
	float	*M12		= (float *)	argv[nbarg++];
	float	*M20		= (float *)	argv[nbarg++];
	float	*M21		= (float *)	argv[nbarg++];
	float	*M22		= (float *)	argv[nbarg++];
	float	FILLVAL		= *(float *)	argv[nbarg++];
	double	DTMAX		= *(double *)	argv[nbarg++];

	int	i;
	int	j;
	float	m00;
	float	m01;
	float	m02;
	float	m10;
	float	m11;
	float	m12;
	float	m20;
	float	m21;
	float	m22;

	if (nbarg != argc) return;

	j=0;
	for (i=0 ; i<nb ; i++) {

		/* Recherche du plus petit j tel que datemat[j]>=date[i] */
		for ( ; j<nbmat && datemat[j]<date[i] ; j++);
		if (j>=nbmat) break;

		if (datemat[j]==date[i] || j==0) {
			/* Pas d'interpolation */
			m00 = M00[j];
			m01 = M01[j];
			m02 = M02[j];
			m10 = M10[j];
			m11 = M11[j];
			m12 = M12[j];
			m20 = M20[j];
			m21 = M21[j];
			m22 = M22[j];
		} else if (datemat[j]-datemat[j-1] <= DTMAX) {
			/* Interpolation des valeurs de la matrice */
			m00 = M00[j-1] + (M00[j]-M00[j-1])/(datemat[j]-datemat[j-1])*(date[i]-datemat[j-1]);
			m01 = M01[j-1] + (M01[j]-M01[j-1])/(datemat[j]-datemat[j-1])*(date[i]-datemat[j-1]);
			m02 = M02[j-1] + (M02[j]-M02[j-1])/(datemat[j]-datemat[j-1])*(date[i]-datemat[j-1]);
			m10 = M10[j-1] + (M10[j]-M10[j-1])/(datemat[j]-datemat[j-1])*(date[i]-datemat[j-1]);
			m11 = M11[j-1] + (M11[j]-M11[j-1])/(datemat[j]-datemat[j-1])*(date[i]-datemat[j-1]);
			m12 = M12[j-1] + (M12[j]-M12[j-1])/(datemat[j]-datemat[j-1])*(date[i]-datemat[j-1]);
			m20 = M20[j-1] + (M20[j]-M20[j-1])/(datemat[j]-datemat[j-1])*(date[i]-datemat[j-1]);
			m21 = M21[j-1] + (M21[j]-M21[j-1])/(datemat[j]-datemat[j-1])*(date[i]-datemat[j-1]);
			m22 = M22[j-1] + (M22[j]-M22[j-1])/(datemat[j]-datemat[j-1])*(date[i]-datemat[j-1]);
		} else {
			x2[i] = FILLVAL;
			y2[i] = FILLVAL;
			x2[i] = FILLVAL;
			continue;
		}

		if (x1[i]!= FILLVAL && y1[i]!=FILLVAL && z1[i]!=FILLVAL) {
			x2[i] = m00*x1[i] + m01*y1[i] + m02*z1[i];
			y2[i] = m10*x1[i] + m11*y1[i] + m12*z1[i];
			z2[i] = m20*x1[i] + m21*y1[i] + m22*z1[i];
		}
	}

}

/*---------------------------------------------------------------------------*/
void GET_REP1_TO_REP2_AUTO_GLUE (
/*---------------------------------------------------------------------------*/
	void *p01,
	void *p02,
	void *p03,
	void *p04,
	void *p05,
	void *p06,
	void *p07,
	void *p08,
	void *p09,
	void *p10,
	void *p11,
	void *p12,
	void *p13,
	void *p14,
	void *p15,
	void *p16,
	void *p17,
	void *p18,
	void *p19,
	void *p20,
	void *p21) {

	int	argc=21;
	void	*argv[21];

	argv[ 0] = p01;
	argv[ 1] = p02;
	argv[ 2] = p03;
	argv[ 3] = p04;
	argv[ 4] = p05;
	argv[ 5] = p06;
	argv[ 6] = p07;
	argv[ 7] = p08;
	argv[ 8] = p09;
	argv[ 9] = p10;
	argv[10] = p11;
	argv[11] = p12;
	argv[12] = p13;
	argv[13] = p14;
	argv[14] = p15;
	argv[15] = p16;
	argv[16] = p17;
	argv[17] = p18;
	argv[18] = p19;
	argv[19] = p20;
	argv[20] = p21;
	GET_REP1_TO_REP2 (argc, argv);

}


/*---------------------------------------------------------------------------*/
void CIS1CALIB_TO_FACTEURG (int argc, void *argv[]) {
/*---------------------------------------------------------------------------*/

	int	nbarg			= 0;
	int	nbcellules		= *(int *)	argv[nbarg++];
	int	nbtables		= *(int *)	argv[nbarg++];
	int	nbenergies		= *(int *)	argv[nbarg++];
	double	*CIS1_GEOM_FACTOR	= (double *)	argv[nbarg++]; /* CIS1_GEOM_FACTOR[8,8,2] */
	double	*facteurG		= (double *)	argv[nbarg++]; /* facteurG[2,nbcellules,nbtables,nbenergies] */

	int	i;
	int	nb;
	int	isensitivity;
	int	icellule;
	int	itable;
	int	ienergie;
	double	fg;

	if (nbarg != argc) return;

	for (isensitivity=0 ; isensitivity<2 ; isensitivity++)
		for (icellule=0 ; icellule<nbcellules ; icellule++)
			for (itable=0 ; itable<nbtables ; itable++)
				for (ienergie=0 ; ienergie<nbenergies ; ienergie++) {
					fg=0;
					nb=8/nbcellules;
					for (i=0 ; i<nb ; i++) 
						fg += CIS1_GEOM_FACTOR[indice3(ienergie*8/nbenergies,icellule*8/nbcellules+i,isensitivity, 8,8,2)]*1e-4;
					if (fg==0) fg=-1e31; /* Il ne faut pas de valeur nulle ! */
					facteurG[indice4(isensitivity,icellule,itable,ienergie, 2,nbcellules,nbtables,nbenergies)] = fg;
				}

}

/*---------------------------------------------------------------------------*/
void CIS1CALIB_TO_FACTEURG_AUTO_GLUE (
/*---------------------------------------------------------------------------*/
	void *p01,
	void *p02,
	void *p03,
	void *p04,
	void *p05) {

	int	argc=5;
	void	*argv[5];

	argv[0] = p01;
	argv[1] = p02;
	argv[2] = p03;
	argv[3] = p04;
	argv[4] = p05;
	CIS1CALIB_TO_FACTEURG (argc, argv);

}


/*---------------------------------------------------------------------------*/
void CIS1CALIB_TO_EFFICACITE (int argc, void *argv[]) {
/*---------------------------------------------------------------------------*/

	int	nbarg				= 0;
	int	nbcellules			= *(int *)	argv[nbarg++];
	int	nbmasses			= *(int *)	argv[nbarg++];
	int	nbtables			= *(int *)	argv[nbarg++];
	int	nbenergies			= *(int *)	argv[nbarg++];
	float	*Q				= (float *)	argv[nbarg++]; /* Q[nbmasses] */
	float	*E				= (float *)	argv[nbarg++]; /* E[nbenergies,3,nbtables] */
	double	CIS1_POST_ACCEL_VOLT		= *(double *)	argv[nbarg++];
	double	*CIS1_ANODE_EFF			= (double *)	argv[nbarg++]; /* CIS1_ANODE_EFF[4,4,8,2] */
	double	*CIS1_ABSOLUTE_EFFICIENCIES	= (double *)	argv[nbarg++]; /* CIS1_ABSOLUTE_EFFICIENCIES[4,2] */
	short	*masses				= (short *)	argv[nbarg++]; /* masses[6]: no des masses 1=H+ 2=He++ 3=He+ 4=O+*/
	double	*efficacite			= (double *)	argv[nbarg++]; /* efficacite[2,nbcellules,nbtables,nbenergies,nbmasses] */

	int	isensitivity;
	int	icellule;
	int	imasse;
	int	nb;
	int	i;
	int	itable;
	int	ienergie;
	double	M0;
	double	M1;
	double	M2;
	double	M3;
	double	CHARGE;
	double	x;
	double	eff;
	int	imasse1; /* numero de la masse 0=H+ 1=He++ 2=He+ 3=O+ */

	if (nbarg != argc) return;

	nb=8/nbcellules;
	for (isensitivity=0 ; isensitivity<2 ; isensitivity++)
		for (icellule=0 ; icellule<nbcellules ; icellule++)
			for (imasse=0 ; imasse<nbmasses ; imasse++) {
				M0=M1=M2=M3=0;
				imasse1=masses[imasse]-1;
				for (i=0 ; i<nb ; i++) {
					M0 += CIS1_ANODE_EFF[indice4(imasse1,0,icellule*8/nbcellules+i,isensitivity,4,4,8,2)];
					M1 += CIS1_ANODE_EFF[indice4(imasse1,1,icellule*8/nbcellules+i,isensitivity,4,4,8,2)];
					M2 += CIS1_ANODE_EFF[indice4(imasse1,2,icellule*8/nbcellules+i,isensitivity,4,4,8,2)];
					M3 += CIS1_ANODE_EFF[indice4(imasse1,3,icellule*8/nbcellules+i,isensitivity,4,4,8,2)];
				}
				M0 /= nb; M1 /= nb; M2 /= nb; M3 /= nb;
				CHARGE = Q[imasse];
				for (itable=0 ; itable<nbtables ; itable++)
					for (ienergie=0 ; ienergie<nbenergies ; ienergie++) {
						x = CHARGE*(E[indice3(ienergie,1,itable,nbenergies,3,nbtables)]+CIS1_POST_ACCEL_VOLT)*1e-3;
						eff = (M0 + M1*x + M2*x*x + M3*x*x*x)*CIS1_ABSOLUTE_EFFICIENCIES[indice2(imasse1,isensitivity,4,2)];
						if (eff==0) eff=-1e31; /* Il ne faut pas de valeur nulle ! */
						efficacite[indice5(isensitivity,icellule,itable,ienergie,imasse, 2,nbcellules,nbtables,nbenergies,nbmasses)] = eff;
					}
			}

}

/*---------------------------------------------------------------------------*/
void CIS1CALIB_TO_EFFICACITE_AUTO_GLUE(
/*---------------------------------------------------------------------------*/
	void *p01,
	void *p02,
	void *p03,
	void *p04,
	void *p05,
	void *p06,
	void *p07,
	void *p08,
	void *p09,
	void *p10,
	void *p11) {

	int	argc=11;
	void	*argv[11];

	argv[ 0] = p01;
	argv[ 1] = p02;
	argv[ 2] = p03;
	argv[ 3] = p04;
	argv[ 4] = p05;
	argv[ 5] = p06;
	argv[ 6] = p07;
	argv[ 7] = p08;
	argv[ 8] = p09;
	argv[ 9] = p10;
	argv[10] = p11;
	CIS1CALIB_TO_EFFICACITE (argc, argv);

}


/*---------------------------------------------------------------------------*/
void CIS2CALIB_TO_FACTEURG (int argc, void *argv[]) {
/*---------------------------------------------------------------------------*/

	int	nbarg			= 0;
	int	nbcellules		= *(int *)	argv[nbarg++];
	int	nbtables		= *(int *)	argv[nbarg++];
	int	nbenergies		= *(int *)	argv[nbarg++];
	double	*CIS2_GEOM_FACTOR	= (double *)	argv[nbarg++]; /* CIS2_GEOM_FACTOR[2] */
	double	*facteurG		= (double *)	argv[nbarg++]; /* facteurG[2,nbcellules,nbtables,nbenergies] */

	int	i;
	int	nb;
	int	isensitivity;
	int	icellule;
	int	itable;
	int	ienergie;
	double	fg;

	if (nbarg != argc) return;

	for (isensitivity=0 ; isensitivity<2 ; isensitivity++)
		for (icellule=0 ; icellule<nbcellules ; icellule++)
			for (itable=0 ; itable<nbtables ; itable++)
				for (ienergie=0 ; ienergie<nbenergies ; ienergie++) {
					fg=0;
					nb=16/nbcellules;
					for (i=0 ; i<nb ; i++) {
						fg += CIS2_GEOM_FACTOR[isensitivity]*1e-4;
					}
					if (isensitivity==0) { /* Ne faire la somme que pour le grand G */
						fg /= nb;
					}
					if (fg==0) fg=1; /* Il ne faut pas de valeur nulle ! */
					facteurG[indice4(isensitivity,icellule,itable,ienergie, 2,nbcellules,nbtables,nbenergies)] = fg;
				}

}

/*---------------------------------------------------------------------------*/
void CIS2CALIB_TO_FACTEURG_AUTO_GLUE (
/*---------------------------------------------------------------------------*/
	void *p01,
	void *p02,
	void *p03,
	void *p04,
	void *p05) {

	int	argc=5;
	void	*argv[5];

	argv[0] = p01;
	argv[1] = p02;
	argv[2] = p03;
	argv[3] = p04;
	argv[4] = p05;
	CIS2CALIB_TO_FACTEURG (argc, argv);

}


/*---------------------------------------------------------------------------*/
void CIS2CALIB_TO_EFFICACITE (int argc, void *argv[]) {
/*---------------------------------------------------------------------------*/

	int	nbarg			= 0;
	int	nbcellules		= *(int *)	argv[nbarg++];
	int	nbtables		= *(int *)	argv[nbarg++];
	int	nbenergies		= *(int *)	argv[nbarg++];
	float	*E			= (float *)	argv[nbarg++]; /* E[nbenergies,3,nbtables] */
	double	*CIS2_A			= (double *)	argv[nbarg++]; /* CIS2_A[2 sensitivity] */
	double	*CIS2_B			= (double *)	argv[nbarg++]; /* CIS2_A[2 sensitivity] */
	double	*CIS2_NORM_E		= (double *)	argv[nbarg++]; /* CIS2_NORM_E[2 sensitivity] */
	double	*CIS2_NORM_THETA	= (double *)	argv[nbarg++]; /* CIS2_NORM_THETA[2 sensitivity] */
	double	*CIS2_ANODE_EFF		= (double *)	argv[nbarg++]; /* CIS2_ANODE_EFF[2, 16 anode,2 sensitivity] */
	double	*CIS2_MCP_FITTING_PARAM	= (double *)	argv[nbarg++]; /* CIS2_MCP_FITTING_PARAM[5 para,3 ligne] */
	double	*efficacite		= (double *)	argv[nbarg++]; /* efficacite[2,nbcellules,nbtables,nbenergies,1] */

	int	i;
	int	isensitivity;
	int	icellule;
	int	itable;
	int	ienergie;
	int	ligne;
	int	nb;
	double	NORM_E;
	double	NORM_Theta;
	double	effTheta;
	double	energie;
	double	effE;
	double	T0;
	double	T1;
	double	T2;
	double	x;
	double	eff;
	double	E_g;
	double	TE;

	if (nbarg != argc) return;

	nb=16/nbcellules;
	for (isensitivity=0 ; isensitivity<2 ; isensitivity++) {
		NORM_E = CIS2_NORM_E[isensitivity];
		NORM_Theta = CIS2_NORM_THETA[isensitivity];
		for (icellule=0 ; icellule<nbcellules ; icellule++) { 
			if (isensitivity==0 && nbcellules==8) { /* Ordre 4..11 pour 'g' HIA 8 anodes */

				effTheta = CIS2_ANODE_EFF[indice3(1,icellule+4,isensitivity,2,16,2)];

			} else {

				effTheta=0;
				for (i=0 ; i<nb ; i++) 
					effTheta += CIS2_ANODE_EFF[indice3(1,nb*icellule+i,isensitivity,2,16,2)];
				effTheta /= nb;

			}
			for (itable=0 ; itable<nbtables ; itable++)
			for (ienergie=0 ; ienergie<nbenergies ; ienergie++) {
				energie = E[indice3(ienergie,1,itable,nbenergies,3,nbtables)];
				effE = CIS2_A[isensitivity]*energie+CIS2_B[isensitivity];
				if (energie < CIS2_MCP_FITTING_PARAM[indice2(3,0,5,3)])
					ligne=0;
				else if (energie < CIS2_MCP_FITTING_PARAM[indice2(3,1,5,3)])
					ligne=1;
				else
					ligne=2;
				T0  = CIS2_MCP_FITTING_PARAM[indice2(0,ligne,5,3)];
				T1  = CIS2_MCP_FITTING_PARAM[indice2(1,ligne,5,3)];
				T2  = CIS2_MCP_FITTING_PARAM[indice2(2,ligne,5,3)];
				E_g = CIS2_MCP_FITTING_PARAM[indice2(4,ligne,5,3)];
				x = energie+E_g;
				TE = T0 + T1*x + T2*x*x;
				eff = effE*effTheta*NORM_Theta/TE;
				eff = 1./eff;
				efficacite[indice5(isensitivity,icellule,itable,ienergie,0, 2,nbcellules,nbtables,nbenergies,1)] = eff;
			}
		}
	}

}

/*---------------------------------------------------------------------------*/
void CIS2CALIB_TO_EFFICACITE_AUTO_GLUE (
/*---------------------------------------------------------------------------*/
	void *p01,
	void *p02,
	void *p03,
	void *p04,
	void *p05,
	void *p06,
	void *p07,
	void *p08,
	void *p09,
	void *p10,
	void *p11) {

	int	argc=11;
	void	*argv[11];

	argv[ 0] = p01;
	argv[ 1] = p02;
	argv[ 2] = p03;
	argv[ 3] = p04;
	argv[ 4] = p05;
	argv[ 5] = p06;
	argv[ 6] = p07;
	argv[ 7] = p08;
	argv[ 8] = p09;
	argv[ 9] = p10;
	argv[10] = p11;
	CIS2CALIB_TO_EFFICACITE (argc, argv);

}


/*---------------------------------------------------------------------------*/
void START (int argc, void *argv[]) {
/*---------------------------------------------------------------------------*/

	int	nbarg	= 0;
	float	*angles	= (float *)	argv[nbarg++]; /* angles[nb1,nb2] */
	int	nb1	= *(int *)	argv[nbarg++];
	int	nb2	= *(int *)	argv[nbarg++];
	int	*start	= (int *)	argv[nbarg++]; /* start[nb1] */

	int	i1;
	int	i2;
	int	imin=0;
	float	min;
	float	tmp;

	if (nbarg != argc) return;

	for (i1=0 ; i1<nb1 ; i1++) {
		min=1e34;
		for (i2=0 ; i2<nb2 ; i2++) {
			tmp = angles[indice2(i1,i2,nb1,nb2)];
			if (tmp < min) {
				min = tmp;
				imin = i2;
			}
		}
		start[i1]=imin;
	}

}

/*---------------------------------------------------------------------------*/
void START_AUTO_GLUE (
/*---------------------------------------------------------------------------*/
	void *p01,
	void *p02,
	void *p03,
	void *p04) {

	int	argc=4;
	void	*argv[4];

	argv[0] = p01;
	argv[1] = p02;
	argv[2] = p03;
	argv[3] = p04;
	START (argc, argv);

}


/*---------------------------------------------------------------------------*/
void DATESPIN_TO_DATEPHI (int argc, void *argv[]) {
/*---------------------------------------------------------------------------*/

	int	nbarg		= 0;
	int	nbspins		= *(int *)	argv[nbarg++];
	int	nbspectres	= *(int *)	argv[nbarg++];
	double	*Xminspin	= (double *)	argv[nbarg++]; /* Xminspin[nbspins] */
	float	*tabpspin	= (float *)	argv[nbarg++]; /* tabpspin[nbspins] */
	int	B		= *(int *)	argv[nbarg++];
	double	*Xminspectre	= (double *)	argv[nbarg++]; /* Xminspectre[nbspins*nbspectres] */
	double	*Xmaxspectre	= (double *)	argv[nbarg++]; /* Xmaxspectre[nbspins*nbspectres] */

	int	ispin;
	int	ispectre;
	int	nospectre;
	float	duree;

	if (nbarg != argc) return;

	for (ispin=0 ; ispin<nbspins ; ispin++) {
		for (ispectre=0 ; ispectre<nbspectres ; ispectre++) {
			nospectre = ispin*nbspectres+ispectre;
			duree = tabpspin[ispin]/nbspectres;
			if (B==0) duree /= 8;
			Xminspectre [nospectre] = Xminspin[ispin] + ispectre*duree;
			Xmaxspectre [nospectre] = Xminspectre[nospectre] + duree;
		}
	}

}


/*---------------------------------------------------------------------------*/
void DATESPIN_TO_DATEPHI_AUTO_GLUE(
/*---------------------------------------------------------------------------*/
	void *p01,
	void *p02,
	void *p03,
	void *p04,
	void *p05,
	void *p06,
	void *p07) {

	int	argc=7;
	void	*argv[7];

	argv[0] = p01;
	argv[1] = p02;
	argv[2] = p03;
	argv[3] = p04;
	argv[4] = p05;
	argv[5] = p06;
	argv[6] = p07;
	return DATESPIN_TO_DATEPHI (argc, argv);

}


/*---------------------------------------------------------------------------*/
void PRODUITSPIN_TO_PRODUITPHI (int argc, void *argv[]) {
/*---------------------------------------------------------------------------*/

	int	nbarg		= 0;
	int	nbspins		= *(int *)	argv[nbarg++];
	int	nbspectres	= *(int *)	argv[nbarg++];
	short	*produitspin	= (short *)	argv[nbarg++]; /* produitspin[nbspins] */
	short	*produitphi	= (short *)	argv[nbarg++]; /* produitphi[nbspins*nbspectres] */

	int	ispin;
	int	ispectre;
	int	nospectre;

	if (nbarg != argc) return;

	for (ispin=0 ; ispin<nbspins ; ispin++)
		for (ispectre=0 ; ispectre<nbspectres ; ispectre++) {
			nospectre = ispin*nbspectres+ispectre;
			produitphi[nospectre] = produitspin[ispin];
		}

}


/*---------------------------------------------------------------------------*/
void PRODUITSPIN_TO_PRODUITPHI_AUTO_GLUE (
/*---------------------------------------------------------------------------*/
	void *p01,
	void *p02,
	void *p03,
	void *p04) {

	int	argc=4;
	void	*argv[4];

	argv[0] = p01;
	argv[1] = p02;
	argv[2] = p03;
	argv[3] = p04;
	PRODUITSPIN_TO_PRODUITPHI (argc, argv);

}


///*---------------------------------------------------------------------------*/
//void PUT_STRUCTURE (int argc, void *argv[]) {
///*---------------------------------------------------------------------------*/
//
//	int	nbarg		= 0;
//	char	*str		= (char *) argv[nbarg++];
//	int	size		= *(int *) argv[nbarg++];
//	int	value		= *(int *) argv[nbarg++];
//
//	/*	
//		Si value>=0, positionne tous les octets de str  value et mmorise les octets dans une variable statique
//		Si value<0,  restaure les valeurs mmorises dans str
//	*/
//
//
//	int		i;
//	static char	*memorise;
//
//	if (nbarg != argc) return;
//
//	if (value >= 0) {
//		memorise = (char *) malloc(size);
//		for (i=0 ; i<size ; i++) {
//			memorise[i] = str[i];
//			str[i] = value;
//		}
//	} else {
//		for (i=0 ; i<size ; i++) {
//			str[i] = memorise[i];
//		}
//		free (memorise);
//	}
//
//	return;
//
//}


///*---------------------------------------------------------------------------*/
//int GET_STRUCTURE_DEBUT (int argc, void *argv[]) {
///*---------------------------------------------------------------------------*/
//
//	int	nbarg		= 0;
//	char	*str		= (char *) argv[nbarg++];
//	int	size		= *(int *) argv[nbarg++];
//
//	int	i;
//
//	if (nbarg != argc) return -1;
//
//	for (i=0 ; i<size ; i++) {
//
//		if (str[i]) {
//			return i;
//		}
//
//	}
//
//	return -1;
//
//}


///*---------------------------------------------------------------------------*/
//int GET_STRUCTURE_DEBUT_STRING (int argc, void *argv[]) {
///*---------------------------------------------------------------------------*/
//
//	int		nbarg	= 0;
//	char		*str	= (char *) argv[nbarg++];
//	int		size	= *(int *) argv[nbarg++];
//	IDL_STRING	*val	= (IDL_STRING *) argv[nbarg++];
//
//	int		i;
//	IDL_STRING	*tmp;
//
//	if (nbarg != argc) return -1;
//
//	for (i=0 ; i+sizeof(val->slen)-1<size ; i++) {
//	
//		tmp = (IDL_STRING *) (str+i);
//		if (tmp->slen == val->slen) {
//			return i;
//		}
//
//	}
//		
//	return -1;
//
//}


/*---------------------------------------------------------------------------*/
void JOINDRE_STRUCTURES (int argc, void *argv[]) {
/*---------------------------------------------------------------------------*/

	/*

	Les donnes sont dans les structure src1 et src2, de taille d'enregistrement lsrc1 et lsrc2, des enregistrements no1  no2.
	Il faut recopier ces donnes dans la structure dst, de taille d'enregistrement ldst (src1 au dbut, src2  l'octet offset)

	lsrc1_util est le nombre d'octets de src1 qu'il faut copier
	lsrc2_util est le nombre d'octets de src2 qu'il faut copier

	*/

	int	nbarg		= 0;
	int	no1		= *(int *)	argv[nbarg++];
	int	no2		= *(int *)	argv[nbarg++];
	int	lsrc1		= *(int *)	argv[nbarg++];
	int	lsrc1_util	= *(int *)	argv[nbarg++];
	int	lsrc2		= *(int *)	argv[nbarg++];
	int	lsrc2_util	= *(int *)	argv[nbarg++];
	int	ldst		= *(int *)	argv[nbarg++];
	int	offset		= *(int *)	argv[nbarg++];
	byte1	*src1		= (byte1 *)	argv[nbarg++];
	byte1	*src2		= (byte1 *)	argv[nbarg++];
	byte1	*dst		= (byte1 *)	argv[nbarg++];

	int	i;

	if (nbarg != argc) return;

	for (i=0 ; i<=no2-no1 ; i++) {

		memcpy (dst+               (size_t)ldst*(size_t)i,  	src1+(size_t)lsrc1*(size_t)(no1+i), lsrc1_util);	// (size_t) pour 64 bits
		memcpy (dst+(size_t)offset+(size_t)ldst*(size_t)i, 	src2+(size_t)lsrc2*(size_t)(no1+i), lsrc2_util);	// (size_t) pour 64 bits

	}

}

/*---------------------------------------------------------------------------*/
void JOINDRE_STRUCTURES_AUTO_GLUE (
/*---------------------------------------------------------------------------*/
	void *p01,
	void *p02,
	void *p03,
	void *p04,
	void *p05,
	void *p06,
	void *p07,
	void *p08,
	void *p09,
	void *p10,
	void *p11) {

	int	argc=11;
	void	*argv[11];

	argv[ 0] = p01;
	argv[ 1] = p02;
	argv[ 2] = p03;
	argv[ 3] = p04;
	argv[ 4] = p05;
	argv[ 5] = p06;
	argv[ 6] = p07;
	argv[ 7] = p08;
	argv[ 8] = p09;
	argv[ 9] = p10;
	argv[10] = p11;
	JOINDRE_STRUCTURES (argc, argv);

}


/*---------------------------------------------------------------------------*/
void SELECTION (int argc, void *argv[]) {
/*---------------------------------------------------------------------------*/

	int	nbarg		= 0;
	int	nb		= *(int *)	argv[nbarg++];
	double	*tab_date	= (double *)	argv[nbarg++];
	int	nb1		= *(int *)	argv[nbarg++];
	double	*tab_date1	= (double *)	argv[nbarg++];
	double	*tab_date2	= (double *)	argv[nbarg++];
	byte1	*tab_ok		= (byte1 *)	argv[nbarg++];

	int	i;
	int	courant;

	if (nbarg != argc) return;

	courant = 0;
	for (i=0 ; i<nb ; i++) {

		while (tab_date[i] > tab_date2[courant] && courant<nb1) {
			courant++;
		}

		if (courant == nb1)
			break;

		if (tab_date[i] >= tab_date1[courant] && tab_date[i] <= tab_date2[courant]) {
			tab_ok[i]=1;
		}

	}

}

/*---------------------------------------------------------------------------*/
void SELECTION_AUTO_GLUE (
/*---------------------------------------------------------------------------*/
	void *p01,
	void *p02,
	void *p03,
	void *p04,
	void *p05,
	void *p06) {

	int	argc=6;
	void	*argv[6];

	argv[0] = p01;
	argv[1] = p02;
	argv[2] = p03;
	argv[3] = p04;
	argv[4] = p05;
	argv[5] = p06;
	return SELECTION (argc, argv);

}


/*---------------------------------------------------------------------------*/
void GET_DAYOFCR_CR (int argc, void *argv[]) {
/*---------------------------------------------------------------------------*/

	int		nbarg		= 0;
	int		NBVAL		= *(int *)	argv[nbarg++];
	int		NBX		= *(int *)	argv[nbarg++];
	int		NBY		= *(int *)	argv[nbarg++];
	double		*tabdate	= (double *)	argv[nbarg++]; /* date[NBVAL] */
	float		*tabfield	= (float *)	argv[nbarg++]; /* field[NBVAL] */
	double		*tabdate1	= (double *)	argv[nbarg++]; /* date1[NBY] */
	double		*tabdate2	= (double *)	argv[nbarg++]; /* date2[NBY] */
	float		*somme		= (float *)	argv[nbarg++]; /* somme[NBX,NBY] */
	int		*nb		= (int *)	argv[nbarg++]; /* nb[NBX,NBY] */

	double		date1=tabdate1[0];
	double		date2=tabdate2[0];
	int		x;
	int		y=0;
	int		i;

	for (i=0 ; i<NBVAL ; i++) {

		if (tabfield[i] < -1e30) continue;

		// Changement de carrington rotation ?
		while (tabdate[i]<date1 || tabdate[i]>date2) {
			y++;
			date1 = tabdate1[y];
			date2 = tabdate2[y];
		}

		x = (tabdate[i]-date1)*NBX/(date2-date1);
		// il ne faut jamais atteindre NBX
		if (x >= NBX) {
			x = NBX-1;
		}

		somme[indice2(x,y,NBX,NBY)] += tabfield[i];
		nb[indice2(x,y,NBX,NBY)]++;

	}

}

/*---------------------------------------------------------------------------*/
void GET_DAYOFCR_CR_AUTO_GLUE (
/*---------------------------------------------------------------------------*/
	void *p01,
	void *p02,
	void *p03,
	void *p04,
	void *p05,
	void *p06,
	void *p07,
	void *p08,
	void *p09) {

	int	argc=9;
	void	*argv[9];

	argv[0] = p01;
	argv[1] = p02;
	argv[2] = p03;
	argv[3] = p04;
	argv[4] = p05;
	argv[5] = p06;
	argv[6] = p07;
	argv[7] = p08;
	argv[8] = p09;
	GET_DAYOFCR_CR (argc, argv);

}


/*---------------------------------------------------------------------------*/
int INTERPOLER_STRUCTURE_MMS (int argc, void *argv[]) {
/*---------------------------------------------------------------------------*/

	int		nbarg			= 0;
	char		*tabdata32		= (char *)		argv[nbarg++];	// pointeur sur la structure 32E
	char		*tabdata64		= (char *)		argv[nbarg++];	// pointeur sur la structure 64E
	int		taille32		= *(int *)		argv[nbarg++];
	int		taille64		= *(int *)		argv[nbarg++];
	int		nblignes		= *(int *)		argv[nbarg++];
	int		nbchamps		= *(int *)		argv[nbarg++];
	int		*offset32		= (int *)		argv[nbarg++];
	int		*offset64		= (int *)		argv[nbarg++];
	int		notable			= *(int *)		argv[nbarg++];

	float		*pfloat32;
	double		*pdouble32;
	float		*pfloat64;
	double		*pdouble64;
	int		table=0; // initialisation sinon warning gcc
	float		count;
	float		count1;
	float		count2;
	int		ienergie;
	int		ispectre;
	int		icellule;
	int		nbcellules=16;
	int		nbspectres=32;
	int		nbenergies32=32;
	int		nbenergies64=64;
	long long	i;
	int		j;

	for (i=0 ; i<nblignes ; i++) {

		// recopie de la date
		pdouble32 = get_pdouble(tabdata32,taille32,offset32,i,0);
		pdouble64 = get_pdouble(tabdata64,taille64,offset64,i,0);
		*pdouble64 = *pdouble32;

		// les autres champs sauf le dernier (data)
		for (j=1 ; j<nbchamps-1 ; j++) {
			pfloat32 = get_pfloat(tabdata32,taille32,offset32,i,j);
			pfloat64 = get_pfloat(tabdata64,taille64,offset64,i,j);
			*pfloat64 = *pfloat32;
			if (j==notable) {
				table = *pfloat32;
			}
		}

		// le dernier champ (champ data)
		pfloat32 = get_pfloat(tabdata32,taille32,offset32,i,nbchamps-1);
		pfloat64 = get_pfloat(tabdata64,taille64,offset64,i,nbchamps-1);
		for (icellule=0 ; icellule<nbcellules ; icellule++) {
			for (ispectre=0 ; ispectre<nbspectres ; ispectre++) {
				for (ienergie=0 ; ienergie<nbenergies32 ; ienergie++) {	
					count = pfloat32[indice4(ienergie,ispectre,icellule,0,nbenergies32,nbspectres,nbcellules,1)];

					// table 0: 0, 2, 4, 8, ...
					// table 1: 1, 3, 5, 7, ...
					pfloat64[indice4(table+2*ienergie,ispectre,icellule,0,nbenergies64,nbspectres,nbcellules,1)] = count;
				}
			}
		}

		// interpolation pour les nergies manquantes
		if (table==0) {
			for (icellule=0 ; icellule<nbcellules ; icellule++) {
				for (ispectre=0 ; ispectre<nbspectres ; ispectre++) {
					for (ienergie=1 ; ienergie<nbenergies64 ; ienergie+=2) {	
						count1 = pfloat64[indice4(ienergie-1,ispectre,icellule,0,nbenergies64,nbspectres,nbcellules,1)];
						if (ienergie==63) {
							count2 = count1;
						} else {
							count2 = pfloat64[indice4(ienergie+1,ispectre,icellule,0,nbenergies64,nbspectres,nbcellules,1)];
						}
						pfloat64[indice4(ienergie,ispectre,icellule,0,nbenergies64,nbspectres,nbcellules,1)] = sqrt(count1*count2);
					}
				}
			}
		} else if (table==1) {
			for (icellule=0 ; icellule<nbcellules ; icellule++) {
				for (ispectre=0 ; ispectre<nbspectres ; ispectre++) {
					for (ienergie=0 ; ienergie<nbenergies64 ; ienergie+=2) {	
						count2 = pfloat64[indice4(ienergie+1,ispectre,icellule,0,nbenergies64,nbspectres,nbcellules,1)];
						if (ienergie==0) {
							count1 = count2;
						} else {
							count1 = pfloat64[indice4(ienergie-1,ispectre,icellule,0,nbenergies64,nbspectres,nbcellules,1)];
						}
						pfloat64[indice4(ienergie,ispectre,icellule,0,nbenergies64,nbspectres,nbcellules,1)] = sqrt(count1*count2);
					}
				}
			}
		}
	}

	return 1;

}


/*---------------------------------------------------------------------------*/
int INTERPOLER_STRUCTURE_MMS_AUTO_GLUE (
/*---------------------------------------------------------------------------*/
	void *p01,
	void *p02,
	void *p03,
	void *p04,
	void *p05,
	void *p06,
	void *p07,
	void *p08,
	void *p09) {

	int	argc=9;
	void	*argv[9];

	argv[0] = p01;
	argv[1] = p02;
	argv[2] = p03;
	argv[3] = p04;
	argv[4] = p05;
	argv[5] = p06;
	argv[6] = p07;
	argv[7] = p08;
	argv[8] = p09;
	return INTERPOLER_STRUCTURE_MMS (argc, argv);

}


/*---------------------------------------------------------------------------*/
void GET_INDEX_HSK (int argc, void *argv[]) {
/*---------------------------------------------------------------------------*/

	int	nbarg		= 0;
	int	nb_hsk		= *(int *)   	argv[nbarg++];	// nombre de valeurs HSK
	double	*date_hsk	= (double *) 	argv[nbarg++];	// datation milieu   HSK (en ms)
	double	*datedeb_hsk	= (double *) 	argv[nbarg++];	// datation debut    HSK (en ms)
	double	*datefin_hsk	= (double *) 	argv[nbarg++];	// datation fin      HSK (en ms)
	int	nb_data		= *(int *)   	argv[nbarg++];	// nombre de donnees DATA
	double	*date_data	= (double *) 	argv[nbarg++];	// datation          DATA (en ms)
	int	*ind		= (int *)  	argv[nbarg++];	// tableau de dimensions nb_data contenant en sortie les indices par rapport  HSK  utiliser pour DATA

	int			i;
	int			j;

	// Vrifier le nombre d'arguments
	if (nbarg != argc) return;

	#ifdef DEBUG
	printf ("nb_hsk=%d  nb_data=%d\n",nb_hsk,nb_data);
	#endif

	// Correction datedeb_hsk, datefin_hsk pour qu'il n'y ait pas de chevauchements
	for (i=0 ; i<nb_hsk ; i++) {
		if (i != 0) {
			datedeb_hsk[i] = (date_hsk[i-1] + date_hsk[i]) * 0.5;
		}
		if (i != nb_hsk-1) {
			datefin_hsk[i] = (date_hsk[i] + date_hsk[i+1]) * 0.5;
		}
	}

	// Trouver le premier point (j) dans DATA dont la date est comprise entre datedeb_hsk[0] et datefin_hsk[0]
	for (j=0 ; j<nb_data ; j++) {
		if (date_data[j] >= datedeb_hsk[0] && date_data[j] <= datefin_hsk[0]) {
			#ifdef DEBUG
			printf ("trouve j=%d\n",j);
			#endif
			break;
		}
	}

	//if (j == nb_data) {
	//	// Aucun point trouv
	//	return;
	//}

	//#ifdef DEBUG
	//printf ("j=%d\n",j);
	//#endif

	j = 0;

	for (i=0 ; i<nb_hsk ; i++) { // pour chaque donne HSK

		// trouver tous les points de DATA dont la datation est comprise entre datedeb_hsk[i] et datefin_hsk[i]
		for ( ; j<nb_data ; j++) {
			if (date_data[j] >= datedeb_hsk[i] && date_data[j] <= datefin_hsk[i]) { // OK
				ind[j] = i;
				#ifdef DEBUG
				printf ("OK i=%d j=%d\n",i,j);
				#endif
			} else if (date_data[j] > datefin_hsk[i]) { // passer aux donnes HSK suivantes
				#ifdef DEBUG
				printf ("i=%d j=%d passer aux donnees HSK suivantes\n",i,j);
				#endif
				break;
			} else {
				#ifdef DEBUG
				printf ("i=%d j=%d passer aux donnees DATA suivantes\n",i,j);
				#endif
			}
		}
	}
}

/*---------------------------------------------------------------------------*/
void GET_INDEX_HSK_AUTO_GLUE(
/*---------------------------------------------------------------------------*/
	void *p01,
	void *p02,
	void *p03,
	void *p04,
	void *p05,
	void *p06,
	void *p07) {

	int	argc=7;
	void	*argv[7];

	argv[0] = p01;
	argv[1] = p02;
	argv[2] = p03;
	argv[3] = p04;
	argv[4] = p05;
	argv[5] = p06;
	argv[6] = p07;
	GET_INDEX_HSK (argc, argv);

}

#define		INSIDE_CLIP	0
#define		LEFT_CLIP	1
#define		RIGHT_CLIP	2
#define		BOTTOM_CLIP	4
#define		TOP_CLIP	8

#define COMPUTE_CODE_GENERIC(code,x,y,xmin,xmax,ymin,ymax)	{				\
												\
	code = INSIDE_CLIP;									\
	if (x < xmin) {										\
		code |= LEFT_CLIP;								\
	} else if (x > xmax) {									\
		code |= RIGHT_CLIP;								\
	}											\
	if (y < ymin) {										\
		code |= BOTTOM_CLIP;								\
	} else if (y > ymax) {									\
		code |= TOP_CLIP;								\
	}											\
}

#define COHENSUTHERLANDCLIP_GENERIC(x1,y1,x2,y2,xmin,xmax,ymin,ymax)	{			\
												\
	COMPUTE_CODE_GENERIC (code1, x1, y1, xmin, xmax, ymin, ymax);				\
	COMPUTE_CODE_GENERIC (code2, x2, y2, xmin, xmax, ymin, ymax);				\
												\
	accept = 0;										\
	while (1) {										\
												\
		if (code1==0 && code2==0) {							\
			/* 2 points  l'intrieur du rectangle */				\
			accept = 1;								\
			break;									\
		} else if (code1 & code2) {							\
			/* 2 points  l'extrieur du rectangle */				\
			break;									\
		} else {									\
			/* il y a des segments  l'intrieur du rectangle */			\
			if (code1 != 0) {							\
				code_out = code1;						\
			} else {								\
				code_out = code2;						\
			}									\
			if (code_out & TOP_CLIP) {						\
				x = x1 + (x2 - x1) * (ymax - y1) / (y2 - y1);			\
				y = ymax;							\
			} else if (code_out & BOTTOM_CLIP) {					\
				x = x1 + (x2 - x1) * (ymin - y1) / (y2 - y1);			\
				y = ymin;							\
			} else if (code_out & RIGHT_CLIP) {					\
				y = y1 + (y2 - y1) * (xmax - x1) / (x2 - x1);			\
				x = xmax;							\
			} else { /* if (code_out & LEFT_CLIP) { */				\
				y = y1 + (y2 - y1) * (xmin - x1) / (x2 - x1);			\
				x = xmin;							\
			}									\
												\
			if (code_out == code1) {						\
				x1 = x;								\
				y1 = y;								\
				COMPUTE_CODE_GENERIC (code1, x1, y1, xmin, xmax, ymin, ymax);	\
			} else {								\
				x2 = x;								\
				y2 = y;								\
				COMPUTE_CODE_GENERIC (code2, x2, y2, xmin, xmax, ymin, ymax);	\
			}									\
		}										\
	}											\
												\
	if (accept) {										\
		if (*nbclip) {									\
			if (clipx[(*nbclip)-1] == x1 && clipy[(*nbclip)-1] == y1) {		\
				/* le point existe dja */					\
			} else {								\
				clipx[*nbclip] = x1;						\
				clipy[*nbclip] = y1;						\
				(*nbclip)++;							\
			}									\
		} else {									\
			clipx[*nbclip] = x1;							\
			clipy[*nbclip] = y1;							\
			(*nbclip)++;								\
		}										\
		clipx[*nbclip] = x2;								\
		clipy[*nbclip] = y2;								\
		(*nbclip)++;									\
	}											\
												\
}

#define CLIPPING_GENERIC(TYPEX,TYPEY) (int argc, void *argv[]) {								\
																\
	TYPEX	*tabx		= (TYPEX *)	argv[0];									\
	TYPEY	*taby		= (TYPEY *)	argv[1];									\
	int	nb		= *(int *)	argv[2];									\
	TYPEX	xmin		= *(TYPEX *)	argv[3];									\
	TYPEX	xmax		= *(TYPEX *)	argv[4];									\
	TYPEY	ymin		= *(TYPEY *)	argv[5];									\
	TYPEY	ymax		= *(TYPEY *)	argv[6];									\
	TYPEX	*clipx		= (TYPEX *)	argv[7];									\
	TYPEY	*clipy		= (TYPEY *)	argv[8];									\
	int	*nbclip		= (int *)	argv[9];									\
	int			i;												\
	int			code1;												\
	int			code2;												\
	int			accept;												\
	int			code_out;											\
	TYPEX			x1, x2, x;											\
	TYPEY			y1, y2, y;											\
	*nbclip = 0;														\
	/*printf ("DEBUT CLIPPING_AUTO_GLUE_GENERIC(%s,%s) nb=%d\n", #TYPEX, #TYPEY, nb);*/					\
	if (nb==1) {														\
		/* un seul point */												\
		if (tabx[0] >= xmin && tabx[0] <= xmax && taby[0] >= ymin && taby[0] <= ymax) {					\
			clipx[*nbclip] = tabx[0];										\
			clipy[*nbclip] = taby[0];										\
			(*nbclip)++;												\
		}														\
	} else {														\
		for (i=0 ; i<nb-1 ; i++) {											\
			x1 = tabx[i];												\
			y1 = taby[i];												\
			x2 = tabx[i+1];												\
			y2 = taby[i+1];												\
			COHENSUTHERLANDCLIP_GENERIC (x1, y1, x2, y2, xmin, xmax, ymin, ymax);					\
		}														\
	}															\
	/*printf ("FIN   CLIPPING_AUTO_GLUE_GENERIC(%s,%s) nbclip=%d\n", #TYPEX, #TYPEY, *nbclip);*/				\
}

void CLIPPING_LONG64_FLOAT	CLIPPING_GENERIC(long long,	float)
void CLIPPING_FLOAT_FLOAT	CLIPPING_GENERIC(float,		float)
void CLIPPING_DOUBLE_FLOAT	CLIPPING_GENERIC(double,	float)
void CLIPPING_DOUBLE_DOUBLE	CLIPPING_GENERIC(double,	double)

/*---------------------------------------------------------------------------*/
void CLIPPING_LONG64_FLOAT_AUTO_GLUE (
/*---------------------------------------------------------------------------*/
	void *p01,
	void *p02,
	void *p03,
	void *p04,
	void *p05,
	void *p06,
	void *p07,
	void *p08,
	void *p09,
	void *p10) {

	int	argc=10;
	void	*argv[10];

	argv[0] = p01;
	argv[1] = p02;
	argv[2] = p03;
	argv[3] = p04;
	argv[4] = p05;
	argv[5] = p06;
	argv[6] = p07;
	argv[7] = p08;
	argv[8] = p09;
	argv[9] = p10;
	CLIPPING_LONG64_FLOAT (argc, argv);

}

/*---------------------------------------------------------------------------*/
void CLIPPING_FLOAT_FLOAT_AUTO_GLUE (
/*---------------------------------------------------------------------------*/
	void *p01,
	void *p02,
	void *p03,
	void *p04,
	void *p05,
	void *p06,
	void *p07,
	void *p08,
	void *p09,
	void *p10) {

	int	argc=10;
	void	*argv[10];

	argv[0] = p01;
	argv[1] = p02;
	argv[2] = p03;
	argv[3] = p04;
	argv[4] = p05;
	argv[5] = p06;
	argv[6] = p07;
	argv[7] = p08;
	argv[8] = p09;
	argv[9] = p10;
	CLIPPING_FLOAT_FLOAT (argc, argv);

}

/*---------------------------------------------------------------------------*/
void CLIPPING_DOUBLE_FLOAT_AUTO_GLUE (
/*---------------------------------------------------------------------------*/
	void *p01,
	void *p02,
	void *p03,
	void *p04,
	void *p05,
	void *p06,
	void *p07,
	void *p08,
	void *p09,
	void *p10) {

	int	argc=10;
	void	*argv[10];

	argv[0] = p01;
	argv[1] = p02;
	argv[2] = p03;
	argv[3] = p04;
	argv[4] = p05;
	argv[5] = p06;
	argv[6] = p07;
	argv[7] = p08;
	argv[8] = p09;
	argv[9] = p10;
	CLIPPING_DOUBLE_FLOAT (argc, argv);

}

/*---------------------------------------------------------------------------*/
void CLIPPING_DOUBLE_DOUBLE_AUTO_GLUE (
/*---------------------------------------------------------------------------*/
	void *p01,
	void *p02,
	void *p03,
	void *p04,
	void *p05,
	void *p06,
	void *p07,
	void *p08,
	void *p09,
	void *p10) {

	int	argc=10;
	void	*argv[10];

	argv[0] = p01;
	argv[1] = p02;
	argv[2] = p03;
	argv[3] = p04;
	argv[4] = p05;
	argv[5] = p06;
	argv[6] = p07;
	argv[7] = p08;
	argv[8] = p09;
	argv[9] = p10;
	CLIPPING_DOUBLE_DOUBLE (argc, argv);

}



// Dclarations pour 
// 	Numerical Recipes in C
// 	The Art of Scientific Computing
// 	Second Edition
#define SIGN(a,b) ((b) >= 0.0 ? fabs(a) : -fabs(a))
static double sqrarg;
#define SQR(a) ((sqrarg=(a)) == 0.0 ? 0.0 : sqrarg*sqrarg)
#define UN 1
#define TINY 1.0e-20

/*---------------------------------------------------------------------------*/
void MY_LUDCMP (int argc, void *argv[]) {
/*---------------------------------------------------------------------------*/

	double	*a	= (double *)	argv[0]; /* a[n,n] */
	int	n	= *(int *)	argv[1];
	double	*indx	= (double *)	argv[2]; /* indx[n] */
	double	*d	= (double *)	argv[3];

	// Numerical Recipes in C
	// The Art of Scientific Computing
	// Second Edition
	//
	// void ludcmp(float **a, int n, int *indx, float *d)

	int	i,imax=0,j,k;
	double	big,dum,sum,temp;
	double	*vv;


	vv = (double *) malloc (n * sizeof(double));
	*d = 1.0;

	for (i=1 ; i<=n ; i++) {
		big = 0.0;
		for (j=1 ; j<=n ; j++)
			if ((temp=fabs(a[indice2(i-UN,j-UN,n,n)])) > big) big=temp;
		if (big == 0.0) {
			printf ("Singular matrix in routine LUDCMP");
		}
		vv[i-UN] = 1.0/big;
	}

	for (j=1 ; j<=n ; j++) {
		for (i=1 ; i<j ; i++) {
			sum = a[indice2(i-UN,j-UN,n,n)];
			for (k=1 ; k<i ; k++) sum -= a[indice2(i-UN,k-UN,n,n)]*a[indice2(k-UN,j-UN,n,n)];
			a[indice2(i-UN,j-UN,n,n)] = sum;
		}
		big = 0.0;
		for (i=j ; i<=n ; i++) {
			sum = a[indice2(i-UN,j-UN,n,n)];
			for (k=1 ; k<j ; k++)
				sum -= a[indice2(i-UN,k-UN,n,n)]*a[indice2(k-UN,j-UN,n,n)];
			a[indice2(i-UN,j-UN,n,n)] = sum;
			if ( (dum=vv[i-UN]*fabs(sum)) >= big) {
				big = dum;
				imax = i;
			}
		}
		if (j != imax) {
			for (k=1 ; k<=n ; k++) {
				dum = a[indice2(imax-UN,k-UN,n,n)];
				a[indice2(imax-UN,k-UN,n,n)] = a[indice2(j-UN,k-UN,n,n)];
				a[indice2(j-UN,k-UN,n,n)] = dum;
			}
			*d = -(*d);
			vv[imax-UN] = vv[j-UN];
		}
		indx[j-UN] = imax;
		if (a[indice2(j-UN,j-UN,n,n)] == 0.0) a[indice2(j-UN,j-UN,n,n)] = TINY;
		if (j != n) {
			dum = 1.0/(a[indice2(j-UN,j-UN,n,n)]);
			for (i=j+1 ; i<=n ; i++) a[indice2(i-UN,j-UN,n,n)] *= dum;
		}
	}

	free (vv);
}

/*---------------------------------------------------------------------------*/
void MY_LUDCMP_AUTO_GLUE (
/*---------------------------------------------------------------------------*/
	void *p01,
	void *p02,
	void *p03,
	void *p04) {

	int	argc=4;
	void	*argv[4];

	argv[0] = p01;
	argv[1] = p02;
	argv[2] = p03;
	argv[3] = p04;
	MY_LUDCMP (argc, argv);

}

/*---------------------------------------------------------------------------*/
void MY_TRIRED (int argc, void *argv[]) {
/*---------------------------------------------------------------------------*/

	double	*a	= (double *)	argv[0]; /* a[n,n] */
	int	n	= *(int *)	argv[1];
	double	*d	= (double *)	argv[2]; /* d[n] */
	double	*e	= (double *)	argv[3]; /* e[n] */

	// Numerical Recipes in C
	// The Art of Scientific Computing
	// Second Edition
	//
	// void tred2(float **a, int n, float d[], float e[])

	int	l, k, j, i;
	double	scale, hh, h, g, f;

	for (i=n ; i>=2 ; i--) {
		l = i-1;
		h = scale = 0.0;
		if (l > 1) {
			for (k=1 ; k<=l ; k++) {
				scale += fabs(a[indice2(i-UN,k-UN,n,n)]);
			}
			if (scale == 0.0) {
				e[i-UN] = a[indice2(i-UN,l-UN,n,n)];
			}
			else {
				for (k=1 ; k<=l ; k++) {
					a[indice2(i-UN,k-UN,n,n)] /= scale;
					h += a[indice2(i-UN,k-UN,n,n)] * a[indice2(i-UN,k-UN,n,n)];
				}
				f = a[indice2(i-UN,l-UN,n,n)];
				g = (f >= 0.0 ? -sqrt(h) : sqrt(h));
				e[i-UN] = scale * g;
				h -= f * g;
				a[indice2(i-UN,l-UN,n,n)] = f-g;
				f = 0.0;
				for (j=1 ; j<=l ; j++) {
					a[indice2(j-UN,i-UN,n,n)] = a[indice2(i-UN,j-UN,n,n)] / h;
					g = 0.0;
					for (k=1 ; k<=j ; k++) {
						g += a[indice2(j-UN,k-UN,n,n)] * a[indice2(i-UN,k-UN,n,n)];
					}
					for (k=j+1 ; k<=l ; k++) {
						g += a[indice2(k-UN,j-UN,n,n)] * a[indice2(i-UN,k-UN,n,n)];
					}
					e[j-UN] = g / h;
					f += e[j-UN] * a[indice2(i-UN,j-UN,n,n)];
				}
				hh = f / (h+h);
				for (j=1 ; j<=l ; j++) {
					f = a[indice2(i-UN,j-UN,n,n)];
					e[j-UN] = g = e[j-UN] - hh * f;
					for (k=1 ; k<=j ; k++) {
						a[indice2(j-UN,k-UN,n,n)] -= (f * e[k-UN] + g * a[indice2(i-UN,k-UN,n,n)]);
					}
				}
			}
		} else
			e[i-UN] = a[indice2(i-UN,l-UN,n,n)];
		d[i-UN] = h;
	}

	d[1-UN] = 0.0;
	e[1-UN] = 0.0;	
	for (i=1 ; i<=n ; i++) {
		l = i-1;
		if (d[i-UN]) {
			for (j=1 ; j<=l ; j++) {
				g = 0.0;
				for (k=1 ; k<=l ; k++) {
					g += a[indice2(i-UN,k-UN,n,n)] * a[indice2(k-UN,j-UN,n,n)];
				}
				for (k=1 ; k<=l ; k++) {
					a[indice2(k-UN,j-UN,n,n)] -= g * a[indice2(k-UN,i-UN,n,n)];
				}
			}
		}
		d[i-UN] = a[indice2(i-UN,i-UN,n,n)];
		a[indice2(i-UN,i-UN,n,n)] = 1.0;
		for (j=1 ; j<=l ; j++) {
			a[indice2(j-UN,i-UN,n,n)] = a[indice2(i-UN,j-UN,n,n)] = 0.0;
		}
	}

}

/*---------------------------------------------------------------------------*/
double pythag (double a, double b) {
/*---------------------------------------------------------------------------*/

	// Numerical Recipes in C
	// The Art of Scientific Computing
	// Second Edition
	//
	// float pythag(float a, float b)

	double absa,absb;

	absa = fabs(a);
	absb = fabs(b);
	if (absa > absb) {
		return absa*sqrt(1.0+SQR(absb/absa));
	} else {
		return (absb == 0.0 ? 0.0 : absb*sqrt(1.0+SQR(absa/absb)));
	}

}

/*---------------------------------------------------------------------------*/
void MY_TRIQL (int argc, void *argv[]) {
/*---------------------------------------------------------------------------*/

	double	*d	= (double *)	argv[0]; /* d[n] */
	double	*e	= (double *)	argv[1]; /* e[n] */
	int	n	= *(int *)	argv[2];
	double	*z	= (double *)	argv[3]; /* z[n,n] */

	// Numerical Recipes in C
	// The Art of Scientific Computing
	// Second Edition
	//
	// void tqli(float d[], float e[], int n, float **z)

	int	m,l,iter,i,k;
	double	s,r,p,g,f,dd,c,b;

	for (i=2 ; i<=n ; i++) {
		e[i-1-UN] = e[i-UN];
	}
	e[n-UN] = 0.0;

	for (l=1 ; l<=n ; l++) {
		iter = 0;
		do {
			for (m=l ; m<=n-1 ; m++) {
				dd = fabs(d[m-UN]) + fabs(d[m+1-UN]);
				if ((double)(fabs(e[m-UN])+dd) == dd) break;
			}
			if (m != l) {
				if (iter++ == 30) printf("Too many iterations in tqli");
				g = (d[l+1-UN]-d[l-UN])/(2.0*e[l-UN]);
				r = pythag(g,1.0);
				g = d[m-UN]-d[l-UN]+e[l-UN]/(g+SIGN(r,g));
				s = c = 1.0;
				p = 0.0;
				for (i=m-1 ; i>=l ; i--) {
					f = s*e[i-UN];
					b = c*e[i-UN];
					e[i+1-UN] = (r=pythag(f,g));
					if (r == 0.0) {
						d[i+1-UN] -= p;
						e[m-UN]=0.0;
						break;
					}
					s=f/r;
					c=g/r;
					g=d[i+1-UN]-p;
					r=(d[i-UN]-g)*s+2.0*c*b;
					d[i+1-UN]=g+(p=s*r);
					g=c*r-b;
					for (k=1 ; k<=n ; k++) {
						f = z[indice2(k-UN,i+1-UN,n,n)];
						z[indice2(k-UN,i+1-UN,n,n)] = s * z[indice2(k-UN,i-UN,n,n)]+c*f;
						z[indice2(k-UN,i-UN,n,n)]   = c * z[indice2(k-UN,i-UN,n,n)]-s*f;
					}
				}
				if (r == 0.0 && i >= l) continue;
				d[l-UN] -= p;
				e[l-UN] = g;
				e[m-UN] = 0.0;
			}
		} while (m != l);
	}
}

/*---------------------------------------------------------------------------*/
void az_el_to_x_y (double az_rad, double el_rad, double *x, double *y) {
/*---------------------------------------------------------------------------*/

	*x = 2 * sqrt(2.0) * cos (el_rad) * sin (az_rad/2) / sqrt (1 + cos(el_rad) * cos (az_rad/2));	// entre -2.8284271 et 2.8284271
	*y =     sqrt(2.0) * sin (el_rad)                  / sqrt (1 + cos(el_rad) * cos (az_rad/2));	// entre -1.4142135 et 1.4142135

}

/*---------------------------------------------------------------------------*/
int x_y_to_az_el (double x, double y, double *az, double *el) {
/*---------------------------------------------------------------------------*/

	double	z;
	double	tmp;

	tmp = 1 - (0.25*x)*(0.25*x) - (0.5*y)*(0.5*y);
	if (tmp < 0) return 0;
	z = sqrt (tmp);
	*az = 2 * atan ((z*x)/(2*(2*z*z-1)));
	*el = asin (z*y);

	return 1;

}

/*---------------------------------------------------------------------------*/
void HAMMER_AITOFF_MAP_IMAGE (int arcgc, void *argv[]) {
/*---------------------------------------------------------------------------*/
	int	nbarg		= 0;
	float	*image		= (float *)	argv[nbarg++];	// image[360,180]
	float	*image_new	= (float *)	argv[nbarg++];	// imagenew[nbxnew,nbynew]
	int	nbxnew		= *(int *) 	argv[nbarg++];	// 
	int	nbynew		= *(int *) 	argv[nbarg++];	// 
	float	infini		= *(float *)  	argv[nbarg++];	// 

	int	nbx=360;
	int	nby=180;
	int	iaz,iel;
	double	azmin_rad, azmax_rad, elmin_rad, elmax_rad;
	double  x, y;
	double  x1, y1;
	double	az, el;
	int	ix,iy;
	int	ix1,iy1;
	int	ix2,iy2;
	int	ix3,iy3;
	int	xmin=1000, xmax=-1000, ymin=1000, ymax=-1000;
	char	*nbutilise;

	for (ix=0 ; ix<nbxnew ; ix++) {
		for (iy=0 ; iy<nbynew ; iy++) {

			x = (double)(ix-283-0.5) / 100.0;
			y = (double)(iy-141-0.5) / 100.0;
			if (x_y_to_az_el (x,y,&az,&el) == 1) {
				az_el_to_x_y (az, el, &x1, &y1);
				if (fabs(x-x1)<0.01 && fabs(y-y1)<0.1) {
					az *= 180.0 / M_PI;
					el *= 180.0 / M_PI;
					iel = el + 90 - 0.5;
					iaz = az - 0.5; if (iaz < 0) iaz += 360;
					if (image_new[indice2(ix,iy,nbxnew,nbynew)] == infini) {
						image_new[indice2(ix,iy,nbxnew,nbynew)] = image[indice2(iaz,iel,360,180)];
					} else {
						printf ("change ...\n");
					}
				}
			}

		}

	}
}

/*---------------------------------------------------------------------------*/
void HAMMER_AITOFF_MAP_IMAGE_AUTO_GLUE (
/*---------------------------------------------------------------------------*/
	void	*p01,
	void	*p02,
	void	*p03,
	void	*p04,
	void	*p05) {

	int	argc=5;
	void	*argv[5];

	argv[0] = p01;
	argv[1] = p02;
	argv[2] = p03;
	argv[3] = p04;
	argv[4] = p05;
	HAMMER_AITOFF_MAP_IMAGE (argc, argv);

}


/*---------------------------------------------------------------------------*/
void HAMMER_AITOFF_MAP_GRID_LONS (int argc, void *argv[]) {
/*---------------------------------------------------------------------------*/
	int	nbarg		= 0;
	float	az		= *(float *)	argv[nbarg++];	//
	float	*lignex		= (float *)	argv[nbarg++];	// lignex[???]
	float	*ligney		= (float *)	argv[nbarg++];	// ligney[???]

	int	iel;
	double	az_rad, el_rad;
	double  x, y;
	int	ix, iy;

	for (iel=0 ; iel<180 ; iel+=1) {

		az_rad = (az - 180) * M_PI / 180.0;
		el_rad = (iel + 0.5 -  90) * M_PI / 180.0;

		az_el_to_x_y (az_rad, el_rad, &x, &y);
		ix = x * 100.0 + 0.5 + 283;
		iy = y * 100.0 + 0.5 + 141;

		lignex[iel] = ix;
		ligney[iel] = iy;

	}

}

/*---------------------------------------------------------------------------*/
void HAMMER_AITOFF_MAP_GRID_LONS_AUTO_GLUE (
/*---------------------------------------------------------------------------*/
	void	*p01,
	void	*p02,
	void	*p03) {

	int	argc=3;
	void	*argv[3];

	argv[0] = p01;
	argv[1] = p02;
	argv[2] = p03;
	HAMMER_AITOFF_MAP_GRID_LONS (argc, argv);

}

/*---------------------------------------------------------------------------*/
void HAMMER_AITOFF_MAP_GRID_LATS (int argc, void *argv[]) {
/*---------------------------------------------------------------------------*/
	int	nbarg		= 0;
	float	el		= *(float *)	argv[nbarg++];	//
	float	*lignex		= (float *)	argv[nbarg++];	// lignex[???]
	float	*ligney		= (float *)	argv[nbarg++];	// ligney[???]

	int	iaz;
	double	az_rad, el_rad;
	double  x, y;
	int	ix,iy;

	for (iaz=0 ; iaz<360 ; iaz+=1) {

		az_rad = (iaz - 180 + 0.5) * M_PI / 180.0;
		el_rad = (el -  90) * M_PI / 180.0;

		az_el_to_x_y (az_rad, el_rad, &x, &y);
		ix = x * 100.0 + 0.5 + 283;
		iy = y * 100.0 + 0.5 + 141;

		lignex[iaz] = ix;
		ligney[iaz] = iy;

	}

}

/*---------------------------------------------------------------------------*/
void HAMMER_AITOFF_MAP_GRID_LATS_AUTO_GLUE (
/*---------------------------------------------------------------------------*/
	void	*p01,
	void	*p02,
	void	*p03) {

	int	argc=3;
	void	*argv[3];

	argv[0] = p01;
	argv[1] = p02;
	argv[2] = p03;
	HAMMER_AITOFF_MAP_GRID_LATS (argc, argv);

}

/*---------------------------------------------------------------------------*/
void HAMMER_AITOFF_CONVERT (int argc, void *argv[]) {
/*---------------------------------------------------------------------------*/
	int	nbarg		= 0;
	float	az		= *(float *)	argv[nbarg++];	//
	float	el		= *(float *)	argv[nbarg++];	//
	float	*ix		= (float *)	argv[nbarg++];	//
	float	*iy		= (float *)	argv[nbarg++];	//

	double	az_rad, el_rad;
	double  x, y;

	az_rad = (az-180) * M_PI / 180.0;
	el_rad = el * M_PI / 180.0;

	az_el_to_x_y (az_rad, el_rad, &x, &y);
	*ix = x * 100.0 + 0.5 + 283;
	*iy = y * 100.0 + 0.5 + 141;

}

/*---------------------------------------------------------------------------*/
void HAMMER_AITOFF_CONVERT_AUTO_GLUE (
/*---------------------------------------------------------------------------*/
	void	*p01,
	void	*p02,
	void	*p03,
	void	*p04) {

	int	argc=4;
	void	*argv[4];

	argv[0] = p01;
	argv[1] = p02;
	argv[2] = p03;
	argv[3] = p04;
	HAMMER_AITOFF_CONVERT (argc, argv);

}

/*---------------------------------------------------------------------------*/
int MY_TRIANGULATE (int argc, void *argv[]) {
/*---------------------------------------------------------------------------*/
	double 		*X		=	(double *)	argv[0];  // Entres X[nbp]
	double 		*Y		=	(double *)	argv[1];  // Entres Y[nbp]
	int 		nbp		=	*(int *)	argv[2];  // Entres nbp
	int 		*TRIANGLES	=	(int *)		argv[3];  // Sorties TRIANGLES[3,nbp]
	int 		*nbt		=	(int *)		argv[4];  // Sorties
	IDL_STRING	*CL_ROOT	= 	(IDL_STRING *)	argv[5];  // Entres

	char	name[1024];
	char	input[1024];
	char	output[1024];
	char	cmd[1024];
	FILE	*fd;
	int	i;
	int	no1, no2, no3;

	strcpy (name, "fdist");
	sprintf (input, "%s.node", name);
	sprintf (output, "%s.1.ele", name);

	fd = fopen (input, "w");
	fprintf (fd, "%d 2 0 0\n", nbp);
	for (i=0 ; i<nbp ; i++) {
		fprintf (fd, "%d %30.15f %30.15f\n", i, X[i], Y[i]);
	}
	fclose (fd);

	// Lancement de triangle qui va lire INPUT et crer OUTPUT
	// 	-N : pas de sortie ".node"
	//	-Q: quiet
	sprintf (cmd, "%s/../TRIANGLE/triangle -N -Q %s", IDL_STRING_STR(CL_ROOT), name);
	system (cmd);

	fd = fopen (output, "r");
	fscanf (fd, "%d %*d %*d", nbt); // nombre de triangles puis 3 puis 2
	for (i=0 ; i<*nbt ; i++) {
		fscanf (fd, "%*d %d %d %d", &no1, &no2, &no3);
		TRIANGLES[indice2(0,i,3,INUTILE)] = no1;
		TRIANGLES[indice2(1,i,3,INUTILE)] = no2;
		TRIANGLES[indice2(2,i,3,INUTILE)] = no3;
	}
	fclose (fd);

	remove (input);
	remove (output);

	return 1;

}

/*---------------------------------------------------------------------------*/
int my_trigrid_check_triangle (int ix, int iy, int it, double x, double y, double *X, double *Y, double *Z, int *TRIANGLES, double *image, int nbx, int nby) {
/*---------------------------------------------------------------------------*/

	int	i1,i2,i3;
	double	x1,x2,x3;
	double	y1,y2,y3;
	double	det,a1,a2,a3;

	i1 = TRIANGLES[indice2(0,it,3,INUTILE)];
	i2 = TRIANGLES[indice2(1,it,3,INUTILE)];
	i3 = TRIANGLES[indice2(2,it,3,INUTILE)];

	x1 = X[i1];
	y1 = Y[i1];
	x2 = X[i2];
	y2 = Y[i2];
	x3 = X[i3];
	y3 = Y[i3];

	// coordonnes barycentriques
	det = (y2-y3)*(x1-x3) + (x3-x2)*(y1-y3);

	a1 = ((y2-y3)*(x-x3) + (x3-x2)*(y-y3)) / det;
	if (a1 < 0) return 0; //  l'extrieur du triangle

	a2 = ((y3-y1)*(x-x3) + (x1-x3)*(y-y3)) / det;
	if (a2 < 0) return 0; //  l'extrieur du triangle

	a3 = 1 - a1 - a2;
	if (a3 < 0) return 0; //  l'extrieur du triangle

	image[indice2(ix,iy,nbx,nby)] = Z[i1] * a1 + Z[i2] * a2 + Z[i3] * a3;

	return 1;

}

/*---------------------------------------------------------------------------*/
int MY_TRIGRID (int argc, void *argv[]) {
/*---------------------------------------------------------------------------*/
	int	nbarg		=	0;
	double 	*X		=	(double *)	argv[nbarg++];  // Entres X[nbp]
	double 	*Y		=	(double *)	argv[nbarg++];  // Entres Y[nbp]
	double 	*Z		=	(double *)	argv[nbarg++];  // Entres Y[nbp]
	int 	nbp		=	*(int *)	argv[nbarg++];  // Entres nbp
	int 	*TRIANGLES	=	(int *)		argv[nbarg++];  // Entres TRIANGLES[3,nbt]
	int 	nbt		=	*(int *)	argv[nbarg++];  // Entres nbt
	double 	xmin		=	*(double *)	argv[nbarg++];  // Entres
	double 	xmax		=	*(double *)	argv[nbarg++];  // Entres
	double 	ymin		=	*(double *)	argv[nbarg++];  // Entres
	double 	ymax		=	*(double *)	argv[nbarg++];  // Entres
	double 	*image		=	(double *)	argv[nbarg++];  // Sorties image[nbx,nby]
	int 	nbx		=	*(int *)	argv[nbarg++];  // Entres nbx
	int 	nby		=	*(int *)	argv[nbarg++];  // Entres nby
	int 	methode		=	*(int *)	argv[nbarg++];  // Entres methode


	int	ix;
	int	iy;
	int	it;
	double	x,y;

	int	i, i1,i2,i3;
	double	xtmin,xtmax,ytmin,ytmax;
	double	xt[3],yt[3];
	int	ixmin, ixmax, iymin, iymax;

	if (methode == 1) {

		// 0.034029961 sec

		// Balayage des triangles
		for (it=0 ; it<nbt ; it++) {

			i1 = TRIANGLES[indice2(0,it,3,INUTILE)];
			i2 = TRIANGLES[indice2(1,it,3,INUTILE)];
			i3 = TRIANGLES[indice2(2,it,3,INUTILE)];

			xt[0] = X[i1];
			yt[0] = Y[i1];
			xt[1] = X[i2];
			yt[1] = Y[i2];
			xt[2] = X[i3];
			yt[2] = Y[i3];

			xtmin = xtmax = xt[0];
			ytmin = ytmax = yt[0];
			for (i=1 ; i<3 ; i++) {
				if (xt[i] < xtmin) xtmin = xt[i];
				if (xt[i] > xtmax) xtmax = xt[i];
				if (yt[i] < ytmin) ytmin = yt[i];
				if (yt[i] > ytmax) ytmax = yt[i];
			}

			// balayage (xtmin xtmax) (ytmin ytmax)
			ixmin = (xtmin-xmin) / ((xmax-xmin)/nbx) - 0.5;
			ixmax = (xtmax-xmin) / ((xmax-xmin)/nbx) - 0.5;
			iymin = (ytmin-ymin) / ((ymax-ymin)/nby) - 0.5;
			iymax = (ytmax-ymin) / ((ymax-ymin)/nby) - 0.5;

			// extension en cas de problme d'arrondi
			ixmin--;
			ixmax++;
			iymin--;
			iymax++;

			// Ne pas dpasser les limites
			if (ixmin < 0)		ixmin = 0;
			if (ixmax >= nbx)	ixmax = nbx-1;
			if (iymin < 0)		iymin = 0;
			if (iymax >= nby)	iymax = nby-1;

			for (ix=ixmin ; ix<=ixmax ; ix++) {
				x = xmin + (ix+0.5) * (xmax-xmin)/nbx;
				for (iy=iymin ; iy<=iymax ; iy++) {
					y = ymin + (iy+0.5) * (ymax-ymin)/nby;
					if (my_trigrid_check_triangle (ix, iy, it, x, y, X, Y, Z, TRIANGLES, image, nbx, nby) == 1) {
					}
				}
			}
		}

	}

	if (methode == 2) {

		// 1.5674810 sec

		it = -1;

		for (ix=0 ; ix<nbx ; ix++) {

			x = xmin + (ix+0.5) * (xmax-xmin)/nbx;

			for (iy=0 ; iy<nby ; iy++) {

				y = ymin + (iy+0.5) * (ymax-ymin)/nby;

				if (it>=0 && it<nbt) {
					// est-on encore dans le dernier triangle utilis ?
					if (my_trigrid_check_triangle (ix, iy, it, x, y, X, Y, Z, TRIANGLES, image, nbx, nby) == 1) {
						// oui donc on a gagn du temps
						continue;
					}
				}

				for (it=0 ; it<nbt ; it++) {

					if (my_trigrid_check_triangle (ix, iy, it, x, y, X, Y, Z, TRIANGLES, image, nbx, nby) == 1) {
						break;
					}

				}
			
			}
		}


	}

	return 1;

}
