/*------------------------------------------------------------------------------
 *
 *	Fichier	: $RCSfile: rocotlibc.c,v $, v $Revision: 1.8 $
 *
 *	Date	: $Date: 2021/04/27 09:48:59 $
 *
 *	Auteur	: $Author: penou $
 *
 *	Version : %Z% version %I% de %M% du %G%
 *
 *------------------------------------------------------------------------------
 */


#include <stdio.h>

#include "f2c.h"


#define indice2(i1,i2,nb1,nb2)                      ((i1)+(nb1)*(i2))

struct {
	real sgst, cgst, gst, slong, srasn, sdecl, obliq;
	real gs1, gs2, gs3, gm1, gm2, gm3, ge1, ge2, ge3, gr1, gr2, gr3;
	real gmgs1, gmgs2, gmgs3, gegs1, gegs2, gegs3;
	real ps1, ps2, ps3, gd1, gd2, gd3, pe1, pe2, pe3, pr1, pr2, pr3;
	real sdze, cdze;
	real yeigm1, yeigm2, yeigm3, zeigm1, zeigm2, zeigm3;
	real rgmgs;
} s;

#define GS { \
	s.gs1 = cos(s.srasn) * cos(s.sdecl); \
	s.gs2 = sin(s.srasn) * cos(s.sdecl); \
	s.gs3 = sin(s.sdecl); }

#define GE { \
	/* *** ecliptic pole in GEI system */ \
	s.ge1 = 0.f; \
	s.ge2 = -sin(s.obliq);\
	s.ge3 = cos(s.obliq); }

#define GEGS { \
	/* *** cross product ExS in GEI system */ \
	s.gegs1 = s.ge2 * s.gs3 - s.ge3 * s.gs2; \
	s.gegs2 = s.ge3 * s.gs1 - s.ge1 * s.gs3; \
	s.gegs3 = s.ge1 * s.gs2 - s.ge2 * s.gs1; }

#define GST { \
	/* *** sin and cos of GMST */ \
	s.sgst = sin(s.gst); \
	s.cgst = cos(s.gst); }

#define GM { \
	/* *** dipole direction in GEI system */ \
	s.gm1 = s.gd1 * s.cgst - s.gd2 * s.sgst; \
	s.gm2 = s.gd1 * s.sgst + s.gd2 * s.cgst; \
	s.gm3 = s.gd3; }

#define GMGS { \
	/* *** cross product MxS in GEI system */ \
	s.gmgs1 = s.gm2 * s.gs3 - s.gm3 * s.gs2; \
	s.gmgs2 = s.gm3 * s.gs1 - s.gm1 * s.gs3; \
	s.gmgs3 = s.gm1 * s.gs2 - s.gm2 * s.gs1; }

#define RMGS { \
	s.rgmgs = sqrt(s.gmgs1 * s.gmgs1 + s.gmgs2 * s.gmgs2 + s.gmgs3 * s.gmgs3); }


#define DZE { \
	s.cdze = (s.ge1 * s.gm1 + s.ge2 * s.gm2 + s.ge3 * s.gm3) / s.rgmgs; \
	s.sdze = (s.ge1 * s.gmgs1 + s.ge2 * s.gmgs2 + s.ge3 * s.gmgs3) / s.rgmgs; }

#define EIGM { \
	/* *** computation of gei to gsm vectors */ \
	s.yeigm1 = s.gmgs1 / s.rgmgs; \
	s.yeigm2 = s.gmgs2 / s.rgmgs; \
	s.yeigm3 = s.gmgs3 / s.rgmgs; \
	s.zeigm1 = s.gs2 * s.yeigm3 - s.gs3 * s.yeigm2; \
	s.zeigm2 = s.gs3 * s.yeigm1 - s.gs1 * s.yeigm3; \
	s.zeigm3 = s.gs1 * s.yeigm2 - s.gs2 * s.yeigm1; }

/*---------------------------------------------------------------------------*/
int csundir_ (
	integer *iyear,
	integer *idoy,
	integer *ih, 
	integer *im,
	integer *is,
	real *gst,
	real *slong,
	real *sra,
	real *sdec,
	real *obliq) {
/*---------------------------------------------------------------------------*/

/* ---------------------------------------------------------------------- */

/* *   Class  : basic compute modules of Rocotlib Software */
/* *   Object : compute_sun_direction in GEI system */
/* *   Author : C.T. Russel 1971, rev. P.Robert,1992,01,02 */

/* *   Comment: calculates four quantities in gei system necessary for */
/*              coordinate transformations dependent on sun position */
/*              (and, hence, on universal time and season) */
/*              Initial code from C.T. Russel, cosmic electro-dynamics, */
/*              v.2, 184-196, 1971. */
/*              Adaptation P.Robert, November 1992. */
/*              Revised and F90 compatibility, P. Robert June 2001. */
/*              Optimisation of DBLE computations and comments, */
/*              P. Robert, December 2002 */

/* *   input  : iyear : year (1901-2099) */
/*              idoy : day of the year (1 for january 1) */
/*              ih,im,is : hours, minutes, seconds U.T. */

/* *   output : gst      greenwich mean sideral time (radians) */
/*              slong    longitude along ecliptic (radians) */
/*              sra      right ascension (radians) */
/*              sdec     declination of the sun (radians) */
/*              obliq    inclination of Earth's axis (radians) */

/* ---------------------------------------------------------------------- */

	/* System generated locals */
	real r__1;
	doublereal d__1;

	/* Local variables */
	static doublereal fday;
	static real cosd, sind, pisd, g, t;
	static integer ileap;
	static doublereal dj;
	static real sc, pi, vl, cob, sob, pre, slp;

	static doublereal c_b166 = 360.;

	if (*iyear < 1901 || *iyear > 2099) {
		return -1;
	}

	pi = acos(-1.f);
	pisd = pi / 180.f;

	/* *** Julian day and greenwich mean sideral time */

	fday = (doublereal) (*ih * 3600 + *im * 60 + *is) / 86400.;
	ileap = (*iyear - 1901) / 4;
	dj = (doublereal) ((*iyear - 1900) * 365 + ileap + *idoy) - .5 + fday;
	d__1 = dj * .9856473354 + 279.690983 + fday * 360. + 180.;
	*gst = (real) d_mod(&d__1, &c_b166) * pisd;

	/* *** longitude along ecliptic */

	d__1 = dj * .9856473354 + 279.696678;
	vl = (real) d_mod(&d__1, &c_b166);
	t = (real) (dj / 36525.);
	d__1 = dj * .985600267 + 358.475845;
	g = (real) d_mod(&d__1, &c_b166) * pisd;
	*slong = (vl + (1.91946f - t * .004789f) * sin(g) + sin(g * 2.f) * .020094f) * pisd;

	/* *** inclination of Earth's axis */

	*obliq = (23.45229f - t * .0130125f) * pisd;
	sob = sin(*obliq);
	cob = cos(*obliq);

	/*     precession of declination (about 0.0056 deg.) */

	pre = (.0055686f - t * 2.5e-6f) * pisd;

	/* *** declination of the sun */

	slp = *slong - pre;
	sind = sob * sin(slp);
	/* Computing 2nd power */
	r__1 = sind;
	cosd = sqrt(1.f - r__1 * r__1);
	sc = sind / cosd;
	*sdec = atan(sc);

	/* *** right ascension of the sun */

	*sra = pi - atan2(cob / sob * sc, -cos(slp) / cosd);

	return 1;
}

/*---------------------------------------------------------------------------*/
int cdipdir_(integer *iyear, integer *idoy, real *d1, real *d2, real *d3) {
/*---------------------------------------------------------------------------*/

    /* Initialized data */

    static real g65[105] = { 0.f,-30334.f,-2119.f,-1662.f,2997.f,1594.f,
	    1297.f,-2038.f,1292.f,856.f,957.f,804.f,479.f,-390.f,252.f,-219.f,
	    358.f,254.f,-31.f,-157.f,-62.f,45.f,61.f,8.f,-228.f,4.f,1.f,
	    -111.f,75.f,-57.f,4.f,13.f,-26.f,-6.f,13.f,1.f,13.f,5.f,-4.f,
	    -14.f,0.f,8.f,-1.f,11.f,4.f,8.f,10.f,2.f,-13.f,10.f,-1.f,-1.f,5.f,
	    1.f,-2.f,-2.f,-3.f,2.f,-5.f,-2.f,4.f,4.f,0.f,2.f,2.f,0.f,0.f,0.f,
	    0.f,0.f,0.f,0.f,0.f,0.f,0.f,0.f,0.f,0.f,0.f,0.f,0.f,0.f,0.f,0.f,
	    0.f,0.f,0.f,0.f,0.f,0.f,0.f,0.f,0.f,0.f,0.f,0.f,0.f,0.f,0.f,0.f,
	    0.f,0.f,0.f,0.f,0.f };
    static real h65[105] = { 0.f,0.f,5776.f,0.f,-2016.f,114.f,0.f,-404.f,
	    240.f,-165.f,0.f,148.f,-269.f,13.f,-269.f,0.f,19.f,128.f,-126.f,
	    -97.f,81.f,0.f,-11.f,100.f,68.f,-32.f,-8.f,-7.f,0.f,-61.f,-27.f,
	    -2.f,6.f,26.f,-23.f,-12.f,0.f,7.f,-12.f,9.f,-16.f,4.f,24.f,-3.f,
	    -17.f,0.f,-22.f,15.f,7.f,-4.f,-5.f,10.f,10.f,-4.f,1.f,0.f,2.f,1.f,
	    2.f,6.f,-4.f,0.f,-2.f,3.f,0.f,-6.f,0.f,0.f,0.f,0.f,0.f,0.f,0.f,
	    0.f,0.f,0.f,0.f,0.f,0.f,0.f,0.f,0.f,0.f,0.f,0.f,0.f,0.f,0.f,0.f,
	    0.f,0.f,0.f,0.f,0.f,0.f,0.f,0.f,0.f,0.f,0.f,0.f,0.f,0.f,0.f,0.f };
    static real g70[105] = { 0.f,-30220.f,-2068.f,-1781.f,3e3f,1611.f,1287.f,
	    -2091.f,1278.f,838.f,952.f,800.f,461.f,-395.f,234.f,-216.f,359.f,
	    262.f,-42.f,-160.f,-56.f,43.f,64.f,15.f,-212.f,2.f,3.f,-112.f,
	    72.f,-57.f,1.f,14.f,-22.f,-2.f,13.f,-2.f,14.f,6.f,-2.f,-13.f,-3.f,
	    5.f,0.f,11.f,3.f,8.f,10.f,2.f,-12.f,10.f,-1.f,0.f,3.f,1.f,-1.f,
	    -3.f,-3.f,2.f,-5.f,-1.f,6.f,4.f,1.f,0.f,3.f,-1.f,0.f,0.f,0.f,0.f,
	    0.f,0.f,0.f,0.f,0.f,0.f,0.f,0.f,0.f,0.f,0.f,0.f,0.f,0.f,0.f,0.f,
	    0.f,0.f,0.f,0.f,0.f,0.f,0.f,0.f,0.f,0.f,0.f,0.f,0.f,0.f,0.f,0.f,
	    0.f,0.f,0.f };
    static real h70[105] = { 0.f,0.f,5737.f,0.f,-2047.f,25.f,0.f,-366.f,251.f,
	    -196.f,0.f,167.f,-266.f,26.f,-279.f,0.f,26.f,139.f,-139.f,-91.f,
	    83.f,0.f,-12.f,100.f,72.f,-37.f,-6.f,1.f,0.f,-70.f,-27.f,-4.f,8.f,
	    23.f,-23.f,-11.f,0.f,7.f,-15.f,6.f,-17.f,6.f,21.f,-6.f,-16.f,0.f,
	    -21.f,16.f,6.f,-4.f,-5.f,10.f,11.f,-2.f,1.f,0.f,1.f,1.f,3.f,4.f,
	    -4.f,0.f,-1.f,3.f,1.f,-4.f,0.f,0.f,0.f,0.f,0.f,0.f,0.f,0.f,0.f,
	    0.f,0.f,0.f,0.f,0.f,0.f,0.f,0.f,0.f,0.f,0.f,0.f,0.f,0.f,0.f,0.f,
	    0.f,0.f,0.f,0.f,0.f,0.f,0.f,0.f,0.f,0.f,0.f,0.f,0.f,0.f };
    static real g75[105] = { 0.f,-30100.f,-2013.f,-1902.f,3010.f,1632.f,
	    1276.f,-2144.f,1260.f,830.f,946.f,791.f,438.f,-405.f,216.f,-218.f,
	    356.f,264.f,-59.f,-159.f,-49.f,45.f,66.f,28.f,-198.f,1.f,6.f,
	    -111.f,71.f,-56.f,1.f,16.f,-14.f,0.f,12.f,-5.f,14.f,6.f,-1.f,
	    -12.f,-8.f,4.f,0.f,10.f,1.f,7.f,10.f,2.f,-12.f,10.f,-1.f,-1.f,4.f,
	    1.f,-2.f,-3.f,-3.f,2.f,-5.f,-2.f,5.f,4.f,1.f,0.f,3.f,-1.f,0.f,0.f,
	    0.f,0.f,0.f,0.f,0.f,0.f,0.f,0.f,0.f,0.f,0.f,0.f,0.f,0.f,0.f,0.f,
	    0.f,0.f,0.f,0.f,0.f,0.f,0.f,0.f,0.f,0.f,0.f,0.f,0.f,0.f,0.f,0.f,
	    0.f,0.f,0.f,0.f,0.f };
    static real h75[105] = { 0.f,0.f,5675.f,0.f,-2067.f,-68.f,0.f,-333.f,
	    262.f,-223.f,0.f,191.f,-265.f,39.f,-288.f,0.f,31.f,148.f,-152.f,
	    -83.f,88.f,0.f,-13.f,99.f,75.f,-41.f,-4.f,11.f,0.f,-77.f,-26.f,
	    -5.f,10.f,22.f,-23.f,-12.f,0.f,6.f,-16.f,4.f,-19.f,6.f,18.f,-10.f,
	    -17.f,0.f,-21.f,16.f,7.f,-4.f,-5.f,10.f,11.f,-3.f,1.f,0.f,1.f,1.f,
	    3.f,4.f,-4.f,-1.f,-1.f,3.f,1.f,-5.f,0.f,0.f,0.f,0.f,0.f,0.f,0.f,
	    0.f,0.f,0.f,0.f,0.f,0.f,0.f,0.f,0.f,0.f,0.f,0.f,0.f,0.f,0.f,0.f,
	    0.f,0.f,0.f,0.f,0.f,0.f,0.f,0.f,0.f,0.f,0.f,0.f,0.f,0.f,0.f,0.f };
    static real g80[105] = { 0.f,-29992.f,-1956.f,-1997.f,3027.f,1663.f,
	    1281.f,-2180.f,1251.f,833.f,938.f,782.f,398.f,-419.f,199.f,-218.f,
	    357.f,261.f,-74.f,-162.f,-48.f,48.f,66.f,42.f,-192.f,4.f,14.f,
	    -108.f,72.f,-59.f,2.f,21.f,-12.f,1.f,11.f,-2.f,18.f,6.f,0.f,-11.f,
	    -7.f,4.f,3.f,6.f,-1.f,5.f,10.f,1.f,-12.f,9.f,-3.f,-1.f,7.f,2.f,
	    -5.f,-4.f,-4.f,2.f,-5.f,-2.f,5.f,3.f,1.f,2.f,3.f,0.f,0.f,0.f,0.f,
	    0.f,0.f,0.f,0.f,0.f,0.f,0.f,0.f,0.f,0.f,0.f,0.f,0.f,0.f,0.f,0.f,
	    0.f,0.f,0.f,0.f,0.f,0.f,0.f,0.f,0.f,0.f,0.f,0.f,0.f,0.f,0.f,0.f,
	    0.f,0.f,0.f,0.f };
    static real h80[105] = { 0.f,0.f,5604.f,0.f,-2129.f,-200.f,0.f,-336.f,
	    271.f,-252.f,0.f,212.f,-257.f,53.f,-297.f,0.f,46.f,150.f,-151.f,
	    -78.f,92.f,0.f,-15.f,93.f,71.f,-43.f,-2.f,17.f,0.f,-82.f,-27.f,
	    -5.f,16.f,18.f,-23.f,-10.f,0.f,7.f,-18.f,4.f,-22.f,9.f,16.f,-13.f,
	    -15.f,0.f,-21.f,16.f,9.f,-5.f,-6.f,9.f,10.f,-6.f,2.f,0.f,1.f,0.f,
	    3.f,6.f,-4.f,0.f,-1.f,4.f,0.f,-6.f,0.f,0.f,0.f,0.f,0.f,0.f,0.f,
	    0.f,0.f,0.f,0.f,0.f,0.f,0.f,0.f,0.f,0.f,0.f,0.f,0.f,0.f,0.f,0.f,
	    0.f,0.f,0.f,0.f,0.f,0.f,0.f,0.f,0.f,0.f,0.f,0.f,0.f,0.f,0.f,0.f };
    static real g85[105] = { 0.f,-29873.f,-1905.f,-2072.f,3044.f,1687.f,
	    1296.f,-2208.f,1247.f,829.f,936.f,780.f,361.f,-424.f,170.f,-214.f,
	    355.f,253.f,-93.f,-164.f,-46.f,53.f,65.f,51.f,-185.f,4.f,16.f,
	    -102.f,74.f,-62.f,3.f,24.f,-6.f,4.f,10.f,0.f,21.f,6.f,0.f,-11.f,
	    -9.f,4.f,4.f,4.f,-4.f,5.f,10.f,1.f,-12.f,9.f,-3.f,-1.f,7.f,1.f,
	    -5.f,-4.f,-4.f,3.f,-5.f,-2.f,5.f,3.f,1.f,2.f,3.f,0.f,0.f,0.f,0.f,
	    0.f,0.f,0.f,0.f,0.f,0.f,0.f,0.f,0.f,0.f,0.f,0.f,0.f,0.f,0.f,0.f,
	    0.f,0.f,0.f,0.f,0.f,0.f,0.f,0.f,0.f,0.f,0.f,0.f,0.f,0.f,0.f,0.f,
	    0.f,0.f,0.f,0.f };
    static real h85[105] = { 0.f,0.f,5500.f,0.f,-2197.f,-306.f,0.f,-310.f,
	    284.f,-297.f,0.f,232.f,-249.f,69.f,-297.f,0.f,47.f,150.f,-154.f,
	    -75.f,95.f,0.f,-16.f,88.f,69.f,-48.f,-1.f,21.f,0.f,-83.f,-27.f,
	    -2.f,20.f,17.f,-23.f,-7.f,0.f,8.f,-19.f,5.f,-23.f,11.f,14.f,-15.f,
	    -11.f,0.f,-21.f,15.f,9.f,-6.f,-6.f,9.f,9.f,-7.f,2.f,0.f,1.f,0.f,
	    3.f,6.f,-4.f,0.f,-1.f,4.f,0.f,-6.f,0.f,0.f,0.f,0.f,0.f,0.f,0.f,
	    0.f,0.f,0.f,0.f,0.f,0.f,0.f,0.f,0.f,0.f,0.f,0.f,0.f,0.f,0.f,0.f,
	    0.f,0.f,0.f,0.f,0.f,0.f,0.f,0.f,0.f,0.f,0.f,0.f,0.f,0.f,0.f,0.f };
    static real g90[105] = { 0.f,-29775.f,-1848.f,-2131.f,3059.f,1686.f,
	    1314.f,-2239.f,1248.f,802.f,939.f,780.f,325.f,-423.f,141.f,-214.f,
	    353.f,245.f,-109.f,-165.f,-36.f,61.f,65.f,59.f,-178.f,3.f,18.f,
	    -96.f,77.f,-64.f,2.f,26.f,-1.f,5.f,9.f,0.f,23.f,5.f,-1.f,-10.f,
	    -12.f,3.f,4.f,2.f,-6.f,4.f,9.f,1.f,-12.f,9.f,-4.f,-2.f,7.f,1.f,
	    -6.f,-3.f,-4.f,2.f,-5.f,-2.f,4.f,3.f,1.f,3.f,3.f,0.f,0.f,0.f,0.f,
	    0.f,0.f,0.f,0.f,0.f,0.f,0.f,0.f,0.f,0.f,0.f,0.f,0.f,0.f,0.f,0.f,
	    0.f,0.f,0.f,0.f,0.f,0.f,0.f,0.f,0.f,0.f,0.f,0.f,0.f,0.f,0.f,0.f,
	    0.f,0.f,0.f,0.f };
    static real h90[105] = { 0.f,0.f,5406.f,0.f,-2279.f,-373.f,0.f,-284.f,
	    293.f,-352.f,0.f,247.f,-240.f,84.f,-299.f,0.f,46.f,154.f,-153.f,
	    -69.f,97.f,0.f,-16.f,82.f,69.f,-52.f,1.f,24.f,0.f,-80.f,-26.f,0.f,
	    21.f,17.f,-23.f,-4.f,0.f,10.f,-19.f,6.f,-22.f,12.f,12.f,-16.f,
	    -10.f,0.f,-20.f,15.f,11.f,-7.f,-7.f,9.f,8.f,-7.f,2.f,0.f,2.f,1.f,
	    3.f,6.f,-4.f,0.f,-2.f,3.f,-1.f,-6.f,0.f,0.f,0.f,0.f,0.f,0.f,0.f,
	    0.f,0.f,0.f,0.f,0.f,0.f,0.f,0.f,0.f,0.f,0.f,0.f,0.f,0.f,0.f,0.f,
	    0.f,0.f,0.f,0.f,0.f,0.f,0.f,0.f,0.f,0.f,0.f,0.f,0.f,0.f,0.f,0.f };
    static real g95[105] = { 0.f,-29692.f,-1784.f,-2200.f,3070.f,1681.f,
	    1335.f,-2267.f,1249.f,759.f,940.f,780.f,290.f,-418.f,122.f,-214.f,
	    352.f,235.f,-118.f,-166.f,-17.f,68.f,67.f,68.f,-170.f,-1.f,19.f,
	    -93.f,77.f,-72.f,1.f,28.f,5.f,4.f,8.f,-2.f,25.f,6.f,-6.f,-9.f,
	    -14.f,9.f,6.f,-5.f,-7.f,4.f,9.f,3.f,-10.f,8.f,-8.f,-1.f,10.f,-2.f,
	    -8.f,-3.f,-6.f,2.f,-4.f,-1.f,4.f,2.f,2.f,5.f,1.f,0.f,0.f,0.f,0.f,
	    0.f,0.f,0.f,0.f,0.f,0.f,0.f,0.f,0.f,0.f,0.f,0.f,0.f,0.f,0.f,0.f,
	    0.f,0.f,0.f,0.f,0.f,0.f,0.f,0.f,0.f,0.f,0.f,0.f,0.f,0.f,0.f,0.f,
	    0.f,0.f,0.f,0.f };
    static real h95[105] = { 0.f,0.f,5306.f,0.f,-2366.f,-413.f,0.f,-262.f,
	    302.f,-427.f,0.f,262.f,-236.f,97.f,-306.f,0.f,46.f,165.f,-143.f,
	    -55.f,107.f,0.f,-17.f,72.f,67.f,-58.f,1.f,36.f,0.f,-69.f,-25.f,
	    4.f,24.f,17.f,-24.f,-6.f,0.f,11.f,-21.f,8.f,-23.f,15.f,11.f,-16.f,
	    -4.f,0.f,-20.f,15.f,12.f,-6.f,-8.f,8.f,5.f,-8.f,3.f,0.f,1.f,0.f,
	    4.f,5.f,-5.f,-1.f,-2.f,1.f,-2.f,-7.f,0.f,0.f,0.f,0.f,0.f,0.f,0.f,
	    0.f,0.f,0.f,0.f,0.f,0.f,0.f,0.f,0.f,0.f,0.f,0.f,0.f,0.f,0.f,0.f,
	    0.f,0.f,0.f,0.f,0.f,0.f,0.f,0.f,0.f,0.f,0.f,0.f,0.f,0.f,0.f,0.f };
    static real g00[105] = { 0.f,-29619.4f,-1728.2f,-2267.7f,3068.4f,1670.9f,
	    1339.6f,-2288.f,1252.1f,714.5f,932.3f,786.8f,250.f,-403.f,111.3f,
	    -218.8f,351.4f,222.3f,-130.4f,-168.6f,-12.9f,72.3f,68.2f,74.2f,
	    -160.9f,-5.9f,16.9f,-90.4f,79.f,-74.f,0.f,33.3f,9.1f,6.9f,7.3f,
	    -1.2f,24.4f,6.6f,-9.2f,-7.9f,-16.6f,9.1f,7.f,-7.9f,-7.f,5.f,9.4f,
	    3.f,-8.4f,6.3f,-8.9f,-1.5f,9.3f,-4.3f,-8.2f,-2.6f,-6.f,1.7f,-3.1f,
	    -.5f,3.7f,1.f,2.f,4.2f,.3f,-1.1f,2.7f,-1.7f,-1.9f,1.5f,-.1f,.1f,
	    -.7f,.7f,1.7f,.1f,1.2f,4.f,-2.2f,-.3f,.2f,.9f,-.2f,.9f,-.5f,.3f,
	    -.3f,-.4f,-.1f,-.2f,-.4f,-.2f,-.9f,.3f,.1f,-.4f,1.3f,-.4f,.7f,
	    -.4f,.3f,-.1f,.4f,0.f,.1f };
    static real h00[105] = { 0.f,0.f,5186.1f,0.f,-2481.6f,-458.f,0.f,-227.6f,
	    293.4f,-491.1f,0.f,272.6f,-231.9f,119.8f,-303.8f,0.f,43.8f,171.9f,
	    -133.1f,-39.3f,106.3f,0.f,-17.4f,63.7f,65.1f,-61.2f,.7f,43.8f,0.f,
	    -64.6f,-24.2f,6.2f,24.f,14.8f,-25.4f,-5.8f,0.f,11.9f,-21.5f,8.5f,
	    -21.5f,15.5f,8.9f,-14.9f,-2.1f,0.f,-19.7f,13.4f,12.5f,-6.2f,-8.4f,
	    8.4f,3.8f,-8.2f,4.8f,0.f,1.7f,0.f,4.f,4.9f,-5.9f,-1.2f,-2.9f,.2f,
	    -2.2f,-7.4f,0.f,.1f,1.3f,-.9f,-2.6f,.9f,-.7f,-2.8f,-.9f,-1.2f,
	    -1.9f,-.9f,0.f,-.4f,.3f,2.5f,-2.6f,.7f,.3f,0.f,0.f,.3f,-.9f,-.4f,
	    .8f,0.f,-.9f,.2f,1.8f,-.4f,-1.f,-.1f,.7f,.3f,.6f,.3f,-.2f,-.5f,
	    -.9f };
    static real g05[105] = { 0.f,-29556.8f,-1671.8f,-2340.5f,3047.f,1656.9f,
	    1335.7f,-2305.3f,1246.8f,674.4f,919.8f,798.2f,211.5f,-379.5f,
	    100.2f,-227.6f,354.4f,208.8f,-136.6f,-168.3f,-14.1f,72.9f,69.6f,
	    76.6f,-151.1f,-15.f,14.7f,-86.4f,79.8f,-74.4f,-1.4f,38.6f,12.3f,
	    9.4f,5.5f,2.f,24.8f,7.7f,-11.4f,-6.8f,-18.f,10.f,9.4f,-11.4f,-5.f,
	    5.6f,9.8f,3.6f,-7.f,5.f,-10.8f,-1.3f,8.7f,-6.7f,-9.2f,-2.2f,-6.3f,
	    1.6f,-2.5f,-.1f,3.f,.3f,2.1f,3.9f,-.1f,-2.2f,2.9f,-1.6f,-1.7f,
	    1.5f,-.2f,.2f,-.7f,.5f,1.8f,.1f,1.f,4.1f,-2.2f,-.3f,.3f,.9f,-.4f,
	    1.f,-.4f,.5f,-.3f,-.4f,0.f,-.4f,0.f,-.2f,-.9f,.3f,.3f,-.4f,1.2f,
	    -.4f,.7f,-.3f,.4f,-.1f,.4f,-.1f,-.3f };
    static real h05[105] = { 0.f,0.f,5080.f,0.f,-2594.9f,-516.7f,0.f,-200.4f,
	    269.3f,-524.5f,0.f,281.4f,-225.8f,145.7f,-304.7f,0.f,42.7f,179.8f,
	    -123.f,-19.5f,103.6f,0.f,-20.2f,54.7f,63.7f,-63.4f,0.f,50.3f,0.f,
	    -61.4f,-22.5f,6.9f,25.4f,10.9f,-26.4f,-4.8f,0.f,11.2f,-21.f,9.7f,
	    -19.8f,16.1f,7.7f,-12.8f,-.1f,0.f,-20.1f,12.9f,12.7f,-6.7f,-8.1f,
	    8.1f,2.9f,-7.9f,5.9f,0.f,2.4f,.2f,4.4f,4.7f,-6.5f,-1.f,-3.4f,-.9f,
	    -2.3f,-8.f,0.f,.3f,1.4f,-.7f,-2.4f,.9f,-.6f,-2.7f,-1.f,-1.5f,-2.f,
	    -1.4f,0.f,-.5f,.3f,2.3f,-2.7f,.6f,.4f,0.f,0.f,.3f,-.8f,-.4f,1.f,
	    0.f,-.7f,.3f,1.7f,-.5f,-1.f,0.f,.7f,.2f,.6f,.4f,-.2f,-.5f,-1.f };
    static real dg05[45] = { 0.f,8.8f,10.8f,-15.f,-6.9f,-1.f,-.3f,-3.1f,-.9f,
	    -6.8f,-2.5f,2.8f,-7.1f,5.9f,-3.2f,-2.6f,.4f,-3.f,-1.2f,.2f,-.6f,
	    -.8f,.2f,-.2f,2.1f,-2.1f,-.4f,1.3f,-.4f,0.f,-.2f,1.1f,.6f,.4f,
	    -.5f,.9f,-.2f,.2f,-.2f,.2f,-.2f,.2f,.5f,-.7f,.5f };
    static real dh05[45] = { 0.f,0.f,-21.3f,0.f,-23.3f,-14.f,0.f,5.4f,-6.5f,
	    -2.f,0.f,2.f,1.8f,5.6f,0.f,0.f,.1f,1.8f,2.f,4.5f,-1.f,0.f,-.4f,
	    -1.9f,-.4f,-.4f,-.2f,.9f,0.f,.8f,.4f,.1f,.2f,-.9f,-.3f,.3f,0.f,
	    -.2f,.2f,.2f,.4f,.2f,-.3f,.5f,.4f };
    static integer iy = -1;
    static integer id = -1;
    static integer ipr = -1;

    /* System generated locals */
    integer i__1;
    real r__1, r__2;

    /* Builtin functions */
    integer s_wsfe(cilist *), do_fio(integer *, char *, ftnlen), e_wsfe(void);
    //double sqrt(doublereal);

    /* Local variables */
    static integer iday;
    static real stcl, stsl, g[105], h__[105];
    static integer m, n;
    static real p, s, f2, f1, aa, g10, g11, h11, dt;
    static integer mn;
    static real sq, cl0, ct0, sl0, st0;
    static integer mnn;
    static real sqq, sqr;

/* ---------------------------------------------------------------------- */

/* *   Class  : basic compute modules of Rocotlib Software */
/* *   Object : compute_dipole_direction in GEO system */
/* *   Author : P. Robert, CRPE, 1992 +Tsyganenko 87 model */

/* *   Comment: Compute geodipole axis direction from International */
/*              Geomagnetic Reference Field (IGRF) models for time */
/*              interval 1965 to 2005. For time out of interval, */
/*              computation is made for nearest boundary. */
/*              Code extracted from geopack, N.A. Tsyganenko, Jan. 5 2001 */
/*              Revised P.R., November 23 2006, full compatible with last */
/*              revision of geopacklib of May 3 2005. */
/*              (see http://www.ngdc.noaa.gov/IAGA/vmod/igrf.html) */

/* *   input  :  iyear (1965 - 2005), idoy= day of year (1/1=1) */
/* *   output :  d1,d2,d3  cartesian dipole components in GEO system */

/* ---------------------------------------------------------------------- */


/*     Coefficients of the igrf field model, calculated for a given year */
/*     and day from their standard epoch values. */

















/* ---------------------------------------------------------------------- */

/* *** Computation are not done if date is the same as previous call */

    if (*iyear == iy && *idoy == id) {
	return 0;
    }

    iy = *iyear;
    id = *idoy;
    iday = *idoy;

/* *** Check date interval of validity */

/*     we are restricted by the interval 1965-2010, for which the igrf */
/*     coefficients are known; */
/*     if iyear is outside this interval, then the subroutine uses the */
/*     nearest limiting value and prints a warning: */

    if (iy < 1965) {
	iy = 1965;
	ipr = 1;
    }
    if (iy > 2010) {
	iy = 2010;
	ipr = 1;
    }

/* /c     calculate the array rec, containing coefficients for the */
/* /c     recursion relations, used in the igrf subroutine for calculating */
/* /c     the associate legendre polynomials and their derivatives: */
/* /c */
/* /      do n=1,14 */
/* /         n2=2*n-1 */
/* /         n2=n2*(n2-2) */
/* /c */
/* /         do m=1,n */
/* /            mn=n*(n-1)/2+m */
/* /            rec(mn)=float((n-m)*(n+m-2))/float(n2) */
/* /         enddo */
/* /      enddo */

/* *** Starting computations */

    if (iy < 1970) {
	goto L50;
    }
/* interpolate between 1965 - 1970 */
    if (iy < 1975) {
	goto L60;
    }
/* interpolate between 1970 - 1975 */
    if (iy < 1980) {
	goto L70;
    }
/* interpolate between 1975 - 1980 */
    if (iy < 1985) {
	goto L80;
    }
/* interpolate between 1980 - 1985 */
    if (iy < 1990) {
	goto L90;
    }
/* interpolate between 1985 - 1990 */
    if (iy < 1995) {
	goto L100;
    }
/* interpolate between 1990 - 1995 */
    if (iy < 2000) {
	goto L110;
    }
/* interpolate between 1995 - 2000 */
    if (iy < 2005) {
	goto L120;
    }

/*     extrapolate beyond 2005: */

/* interpolate between 2000 - 2005 */
    dt = (real) iy + (real) (iday - 1) / 365.25f - 2005.f;
    for (n = 1; n <= 105; ++n) {
	g[n - 1] = g05[n - 1];
	h__[n - 1] = h05[n - 1];
	if (n > 45) {
	    goto L40;
	}
	g[n - 1] += dg05[n - 1] * dt;
	h__[n - 1] += dh05[n - 1] * dt;
L40:
	;
    }
    goto L300;

/*     interpolate betweeen 1965 - 1970: */

L50:
    f2 = ((real) iy + (real) (iday - 1) / 365.25f - 1965) / 5.f;
    f1 = 1.f - f2;
    for (n = 1; n <= 105; ++n) {
	g[n - 1] = g65[n - 1] * f1 + g70[n - 1] * f2;
	h__[n - 1] = h65[n - 1] * f1 + h70[n - 1] * f2;
    }
    goto L300;

/*     interpolate between 1970 - 1975: */

L60:
    f2 = ((real) iy + (real) (iday - 1) / 365.25f - 1970) / 5.f;
    f1 = 1.f - f2;
    for (n = 1; n <= 105; ++n) {
	g[n - 1] = g70[n - 1] * f1 + g75[n - 1] * f2;
	h__[n - 1] = h70[n - 1] * f1 + h75[n - 1] * f2;
    }
    goto L300;

/*     interpolate between 1975 - 1980: */

L70:
    f2 = ((real) iy + (real) (iday - 1) / 365.25f - 1975) / 5.f;
    f1 = 1.f - f2;
    for (n = 1; n <= 105; ++n) {
	g[n - 1] = g75[n - 1] * f1 + g80[n - 1] * f2;
	h__[n - 1] = h75[n - 1] * f1 + h80[n - 1] * f2;
    }
    goto L300;

/*     interpolate between 1980 - 1985: */

L80:
    f2 = ((real) iy + (real) (iday - 1) / 365.25f - 1980) / 5.f;
    f1 = 1.f - f2;
    for (n = 1; n <= 105; ++n) {
	g[n - 1] = g80[n - 1] * f1 + g85[n - 1] * f2;
	h__[n - 1] = h80[n - 1] * f1 + h85[n - 1] * f2;
    }
    goto L300;

/*     interpolate between 1985 - 1990: */

L90:
    f2 = ((real) iy + (real) (iday - 1) / 365.25f - 1985) / 5.f;
    f1 = 1.f - f2;
    for (n = 1; n <= 105; ++n) {
	g[n - 1] = g85[n - 1] * f1 + g90[n - 1] * f2;
	h__[n - 1] = h85[n - 1] * f1 + h90[n - 1] * f2;
    }
    goto L300;

/*     interpolate between 1990 - 1995: */

L100:
    f2 = ((real) iy + (real) (iday - 1) / 365.25f - 1990) / 5.f;
    f1 = 1.f - f2;
    for (n = 1; n <= 105; ++n) {
	g[n - 1] = g90[n - 1] * f1 + g95[n - 1] * f2;
	h__[n - 1] = h90[n - 1] * f1 + h95[n - 1] * f2;
    }
    goto L300;

/*     interpolate between 1995 - 2000: */

L110:
    f2 = ((real) iy + (real) (iday - 1) / 365.25f - 1995) / 5.f;
    f1 = 1.f - f2;
    for (n = 1; n <= 105; ++n) {
/*     the 2000 coefficients (g00) go through the order 13, not 10 */
	g[n - 1] = g95[n - 1] * f1 + g00[n - 1] * f2;
	h__[n - 1] = h95[n - 1] * f1 + h00[n - 1] * f2;
    }
    goto L300;

/*     interpolate between 2000 - 2005: */

L120:
    f2 = ((real) iy + (real) (iday - 1) / 365.25f - 2000) / 5.f;
    f1 = 1.f - f2;
    for (n = 1; n <= 105; ++n) {
	g[n - 1] = g00[n - 1] * f1 + g05[n - 1] * f2;
	h__[n - 1] = h00[n - 1] * f1 + h05[n - 1] * f2;
    }
    goto L300;

/*   coefficients for a given year have been calculated; now multiply */
/*   them by schmidt normalization factors: */

L300:
    s = 1.f;

    for (n = 2; n <= 14; ++n) {
	mn = n * (n - 1) / 2 + 1;
	s = s * (real) ((n << 1) - 3) / (real) (n - 1);
	g[mn - 1] *= s;
	h__[mn - 1] *= s;
	p = s;

	i__1 = n;
	for (m = 2; m <= i__1; ++m) {
	    aa = 1.f;
	    if (m == 2) {
		aa = 2.f;
	    }
	    p *= sqrt(aa * (real) (n - m + 1) / (real) (n + m - 2));
	    mnn = mn + m - 1;
	    g[mnn - 1] *= p;
	    h__[mnn - 1] *= p;
	}
    }
    g10 = -g[1];
    g11 = g[2];
    h11 = h__[2];

/*     now calculate the components of the unit vector ezmag in geo */
/*     coord.system: */
/*     sin(teta0)*cos(lambda0), sin(teta0)*sin(lambda0), and cos(teta0) */
/*           st0 * cl0                st0 * sl0                ct0 */

/* Computing 2nd power */
    r__1 = g11;
/* Computing 2nd power */
    r__2 = h11;
    sq = r__1 * r__1 + r__2 * r__2;
    sqq = sqrt(sq);
/* Computing 2nd power */
    r__1 = g10;
    sqr = sqrt(r__1 * r__1 + sq);
    sl0 = -h11 / sqq;
    cl0 = -g11 / sqq;
    st0 = sqq / sqr;
    ct0 = g10 / sqr;

    stcl = st0 * cl0;
    stsl = st0 * sl0;

/* *** direction of dipole axis in GEO system: */

    *d1 = stcl;
    *d2 = stsl;
    *d3 = ct0;


    return 0;
}


/*---------------------------------------------------------------------------*/
int tgeigse (
	int iyear, int idoy, int ih, int im, int is,
	real *xgei, real *ygei, real *zgei,
	real *xgse, real *ygse, real *zgse) {
/*---------------------------------------------------------------------------*/

	if (csundir_(&iyear, &idoy, &ih, &im, &is, &s.gst, &s.slong, &s.srasn, &s.sdecl, &s.obliq) == -1)
		return -1;

	GS;
	GE;
	GEGS;

	*xgse = s.gs1   * *xgei + s.gs2   * *ygei + s.gs3   * * zgei;
	*ygse = s.gegs1 * *xgei + s.gegs2 * *ygei + s.gegs3 * *zgei;
	*zgse = s.ge1   * *xgei + s.ge2   * *ygei + s.ge3   * * zgei;

	return 1;

}


/*---------------------------------------------------------------------------*/
int tgsegsm (
	int iyear, int idoy, int ih, int im, int is,
	real *xgse, real *ygse, real *zgse,
	real *xgsm, real *ygsm, real *zgsm) {
/*---------------------------------------------------------------------------*/

	if (csundir_(&iyear, &idoy, &ih, &im, &is, &s.gst, &s.slong, &s.srasn, &s.sdecl, &s.obliq) == -1)
		return -1;
	cdipdir_(&iyear, &idoy, &s.gd1, &s.gd2, &s.gd3);

	GS;
	GE;
	GST;
	GM;
	GMGS;
	RMGS;
	DZE;

	*xgsm = *xgse;
	*ygsm =  s.cdze * *ygse + s.sdze * *zgse;
	*zgsm = -s.sdze * *ygse + s.cdze * *zgse;

	return 1;

}



/*---------------------------------------------------------------------------*/
//int tgeigsm (
//	int iyear, int idoy, int ih, int im, int is,
//	real *xgei, real *ygei, real *zgei,
//	real *xgsm, real *ygsm, real *zgsm) {
/*---------------------------------------------------------------------------*/
//
//	if (csundir_(&iyear, &idoy, &ih, &im, &is, &s.gst, &s.slong, &s.srasn, &s.sdecl, &s.obliq) == -1)
//		return -1;
//	cdipdir_(&iyear, &idoy, &s.gd1, &s.gd2, &s.gd3);
//
//	EIGM;
//
//	*xgsm = s.gs1    * *xgei + s.gs2    * *ygei + s.gs3    * * zgei;
//	*ygsm = s.yeigm1 * *xgei + s.yeigm2 * *ygei + s.yeigm3 * *zgei;
//	*zgsm = s.zeigm1 * *xgei + s.zeigm2 * *ygei + s.zeigm3 * *zgei;
//
//	return 1;
//
//}


/*---------------------------------------------------------------------------*/
int julday (int mm, int id, int iyyy, int *julian) {
/*---------------------------------------------------------------------------*/

	#define igreg1 588829

	int ja,jm,jy,jul;

	if (iyyy==0)
		return -1;

	if (iyyy < 0)
		iyyy = iyyy + 1; 
	if (mm > 2) {
		jy = iyyy;
		jm = mm+1;
	} else {
		jy = iyyy-1;
		jm = mm+13;
	}
	jul = (int)(365.25*jy) + (int)(30.6001*jm) + id + 1720995;

	if (id+31*(mm+12*iyyy) >= igreg1) {
		ja = (int)(0.01*jy);
		jul = jul + 2 - ja + (int)(0.25*ja);
	}
	*julian =  jul;

	return 0;

}


/*---------------------------------------------------------------------------*/
int annee_mois_jour_to_doy (int annee, int mois, int jour) {
/*---------------------------------------------------------------------------*/

	int	jul1=0; // initilisé sinon warning gcc
	int	jul0=0; // initilisé sinon warning gcc

	julday (mois, jour, annee, &jul1);
	julday (1   , 1   , annee, &jul0);
	return jul1 - jul0 + 1;

}


/*---------------------------------------------------------------------------*/
int REP1_TO_REP2 (int argc, void *argv[]) {
/*---------------------------------------------------------------------------*/

	#define	GEI_TO_GSE	1
	#define GSE_TO_GSM	2

	int	nbarg		= 0;
	int	repere		= *(int *)	argv[nbarg++]; /* 1=gei_to_gse, 2=gse_to_gsm */
	float	FILLVAL		= *(float *)	argv[nbarg++];
	int	nb		= *(int *)	argv[nbarg++];
	int	*ann		= (int *)	argv[nbarg++]; /* ann[nb] */
	int	*moi		= (int *)	argv[nbarg++]; /* moi[nb] */
	int	*jou		= (int *)	argv[nbarg++]; /* jou[nb] */
	int	*heu		= (int *)	argv[nbarg++]; /* heu[nb] */
	int	*min		= (int *)	argv[nbarg++]; /* min[nb] */
	int	*sec		= (int *)	argv[nbarg++]; /* sec[nb] */
	int	nbvecteurs	= *(int *)	argv[nbarg++];
	float	*tabx1		= (float *)	argv[nbarg++]; /* tabx1[nb,nbvecterurs] */
	float	*taby1		= (float *)	argv[nbarg++]; /* taby1[nb,nbvecterurs] */
	float	*tabz1		= (float *)	argv[nbarg++]; /* tabz1[nb,nbvecterurs] */
	float	*tabx2		= (float *)	argv[nbarg++]; /* tabx2[nb,nbvecterurs] */
	float	*taby2		= (float *)	argv[nbarg++]; /* taby2[nb,nbvecterurs] */
	float	*tabz2		= (float *)	argv[nbarg++]; /* tabz2[nb,nbvecterurs] */

	int	i,j;
	int	doy;
	float	x1, y1, z1;
	float	x2, y2, z2;

	for (i=0 ; i<nb ; i++) {

		doy = annee_mois_jour_to_doy (ann[i], moi[i], jou[i]);

		for (j=0 ; j<nbvecteurs; j++) {

			x1 = tabx1[indice2(i,j,nb,nbvecteurs)]; 
			y1 = taby1[indice2(i,j,nb,nbvecteurs)]; 
			z1 = tabz1[indice2(i,j,nb,nbvecteurs)]; 

			if (x1 != FILLVAL && y1 != FILLVAL && z1 != FILLVAL) /* Pas de calcul si FILLVAL */ {

				if (repere==GEI_TO_GSE) {
					tgeigse (ann[i], doy, heu[i], min[i], sec[i], &x1, &y1, &z1, &x2, &y2, &z2);
				} else if (repere==GSE_TO_GSM) {
					tgsegsm (ann[i], doy, heu[i], min[i], sec[i], &x1, &y1, &z1, &x2, &y2, &z2);
				}

				tabx2[indice2(i,j,nb,nbvecteurs)] = x2;
				taby2[indice2(i,j,nb,nbvecteurs)] = y2;
				tabz2[indice2(i,j,nb,nbvecteurs)] = z2;

			}
		}
	}

	return 0;

}

/*---------------------------------------------------------------------------*/
int REP1_TO_REP2_AUTO_GLUE (
/*---------------------------------------------------------------------------*/
	void	*p01,
	void	*p02,
	void	*p03,
	void	*p04,
	void	*p05,
	void	*p06,
	void	*p07,
	void	*p08,
	void	*p09,
	void	*p10,
	void	*p11,
	void	*p12,
	void	*p13,
	void	*p14,
	void	*p15,
	void	*p16) {

	int	argc=16;
	void	*argv[16];

	argv[ 0] = p01;
	argv[ 1] = p02;
	argv[ 2] = p03;
	argv[ 3] = p04;
	argv[ 4] = p05;
	argv[ 5] = p06;
	argv[ 6] = p07;
	argv[ 7] = p08;
	argv[ 8] = p09;
	argv[ 9] = p10;
	argv[10] = p11;
	argv[11] = p12;
	argv[12] = p13;
	argv[13] = p14;
	argv[14] = p15;
	argv[15] = p16;
	return REP1_TO_REP2 (argc, argv);

}
