/*------------------------------------------------------------------------------
 *
 *	Fichier	: $RCSfile: noninterpoler2d.c,v $, v $Revision: 1.11 $
 *
 *	Date	: $Date: 2021/04/27 09:48:59 $
 *
 *	Auteur	: $Author: penou $
 *
 *	Version : %Z% version %I% de %M% du %G%
 *
 *------------------------------------------------------------------------------
 */


#include <math.h>
#include <stdio.h>
#include <stdlib.h>

#include "infini.h"

/*---------------------------------------------------------------------------*/
int NONINTERPOLER2D (int argc, void *argv[]) {
/*---------------------------------------------------------------------------*/

	int	*x1_data	= (int *)	argv[0];
	int	*x2_data	= (int *)	argv[1];
	int	*xf_data	= (int *)	argv[2];
	int	nbx_xdata	= *(int *)	argv[3];
	int	*y1_data	= (int *)	argv[4];
	int	*y2_data	= (int *)	argv[5];
	int	*yf_data	= (int *)	argv[6];
	int	nbx_ydata	= *(int *)	argv[7];
	int	nby_ydata	= *(int *)	argv[8];
	int	*indY		= (int *)	argv[9];
	float	*Zdata		= (float *)	argv[10];
	float	*image		= (float *)	argv[11];
	int	*nb		= (int *)	argv[12];
	int	*utilise	= (int *)	argv[13];
	int	nbx		= *(int *)	argv[14];
	int	nby		= *(int *)	argv[15];
	int	moyenner	= *(int *)	argv[16];
	float	infini		= *(float *)	argv[17];
	short	*produitdata	= (short *)	argv[18];
	float	*produitimage	= (float *)	argv[19];


	int x_data,y_data,x_image,y_image,ind_image,ind_data,ind_ydata;

	for  (x_data=0 ; x_data<nbx_ydata ; x_data++) {

		/*	Plages d'energies totalement hors limite
			---------------------------------------- */
		for (y_data=0 ; y_data<nby_ydata ; y_data++) {
			if (y2_data[x_data+nbx_ydata*y_data]<0 || y1_data[x_data+nbx_ydata*y_data]>nby-1) {
				yf_data[x_data+nbx_ydata*y_data] = 0;
			}
		}

		/*	Plages d'energies partiellement visibles
			---------------------------------------- */
		for (y_data=0 ; y_data<nby_ydata ; y_data++) {
			if (y1_data[x_data+nbx_ydata*y_data]<0 && yf_data[x_data+nbx_ydata*y_data]) {
				y1_data[x_data+nbx_ydata*y_data] = 0;
			}
		}

		for (y_data=0 ; y_data<nby_ydata ; y_data++) {
			if (y2_data[x_data+nbx_ydata*y_data]>nby-1 && yf_data[x_data+nbx_ydata*y_data]) {
				y2_data[x_data+nbx_ydata*y_data] = nby-1;
			}
		}

		/*	Chevauchement des plages d'energies: ajustement eventuel de y2_data
			--------------------------------------------------------------------

			AVANT           APRES

			|    | y2 |      |    | y2 |
			|    |    |      |    |    |
			|    |    |      |    |    |
			|    |    |  ->  |    |    |
			| y2 | y1 |      |    | y1 |
			|    |    |      | y2 |    |
			|    |    |      |    |    |
			| y1 |    |      | y1 |    | */

		for (y_data=0 ; y_data<nby_ydata-1 ; y_data++) {
			if (y2_data[x_data+nbx_ydata*y_data]==y1_data[x_data+nbx_ydata*(y_data+1)] &&
				y2_data[x_data+nbx_ydata*y_data]!=y1_data[x_data+nbx_ydata*y_data]) {
				y2_data[x_data+nbx_ydata*y_data]--;
			}
		}

	}

	for (x_data=0 ; x_data<nbx_xdata ; x_data++) {

		if (indY[x_data]==-1) /* Table d'energie inconnue: on ne peut rien faire */
			continue;

		if (xf_data[x_data]==0)
			continue;

		for (x_image=x1_data[x_data] ; x_image<=x2_data[x_data] ; x_image++) {

			if (moyenner==0 && utilise[x_image])
				continue;

			for (y_data=0 ; y_data<nby_ydata ; y_data++) {
				ind_data  = x_data+nbx_xdata*y_data;
				ind_ydata = indY[x_data]+nbx_ydata*y_data;

				if (yf_data[ind_ydata]==0)
					continue;

				for (y_image=y1_data[ind_ydata] ; y_image<=y2_data[ind_ydata] ; y_image++) {

					ind_image = x_image+nbx*y_image;
					utilise[x_image] = 1;
					if (!fini(produitimage[x_image],infini)) {
						produitimage[x_image] = produitdata[x_data];
					}
					if (!moyenner) {
						nb[ind_image] = 1;
						if (fini(Zdata[ind_data],infini) && nonfini(image[ind_image],infini)) {
							image[ind_image] = Zdata[ind_data];
						}
					} else if (fini(Zdata[ind_data],infini)) {
						nb[ind_image]++;
						if (nonfini(image[ind_image],infini)) {
							image[ind_image] = Zdata[ind_data]; /* Premier acces */
						} else {
							image[ind_image] += Zdata[ind_data];
						}
					}
				}
			}
		}
	}

	return 0;

}

/*---------------------------------------------------------------------------*/
int NONINTERPOLER2D_AUTO_GLUE (
/*---------------------------------------------------------------------------*/
	void	*p01,
	void	*p02,
	void	*p03,
	void	*p04,
	void	*p05,
	void	*p06,
	void	*p07,
	void	*p08,
	void	*p09,
	void	*p10,
	void	*p11,
	void	*p12,
	void	*p13,
	void	*p14,
	void	*p15,
	void	*p16,
	void	*p17,
	void	*p18,
	void	*p19,
	void	*p20) {

	int	argc=20;
	void	*argv[20];

	argv[ 0] = p01;
	argv[ 1] = p02;
	argv[ 2] = p03;
	argv[ 3] = p04;
	argv[ 4] = p05;
	argv[ 5] = p06;
	argv[ 6] = p07;
	argv[ 7] = p08;
	argv[ 8] = p09;
	argv[ 9] = p10;
	argv[10] = p11;
	argv[11] = p12;
	argv[12] = p13;
	argv[13] = p14;
	argv[14] = p15;
	argv[15] = p16;
	argv[16] = p17;
	argv[17] = p18;
	argv[18] = p19;
	argv[19] = p20;
	return NONINTERPOLER2D (argc, argv);

}

