/*------------------------------------------------------------------------------
 *
 *	Fichier	: $RCSfile: my_plplot.c,v $, v $Revision: 1.1 $
 *
 *	Date	: $Date: 2021/05/17 13:55:53 $
 *
 *	Auteur	: $Author: penou $
 *
 *	Version : %Z% version %I% de %M% du %G%
 *
 *------------------------------------------------------------------------------
 */

#define PL_DOUBLE

#include <plplot/plplot.h>
#include <plplot/plevent.h>

typedef const PLFLT * const * PLFLT_MATRIX;


#include <unistd.h>
#include <sys/stat.h>
#include <libgen.h>

#include <stdio.h>
#include <stdlib.h>
#include <math.h>

#ifdef GDL
#include "libgdl.h"
#else
#include "export.h"
#endif

#include <string.h>
#include <sys/types.h>

#define indice2(i1,i2,nb1,nb2)				((i1)+(nb1)*(i2))

int	device_xsize = 0;	// en pixels si cran
int	device_ysize = 0;	// en pixels si cran
int	device_init = 0;	// 1 si la librarie a t initialise avec plinit()
double	device_charsize = 1;	// facteur taille caractres
double	device_charthick = 1;	// facteur epaisseur caractres
double	device_symsize = 1;	// facteur taille symboles
double	device_symthick = 1;	// facteur epaisseur trait

FILE	*fd_output;
char	nom_output[1024]="";

/*---------------------------------------------------------------------------*/
int SET_OUTPUT (int argc, void *argv[]) {
/*---------------------------------------------------------------------------*/
	IDL_STRING  	*nom		=	(IDL_STRING *)	argv[0]; // Entres

	strcpy (nom_output, IDL_STRING_STR(nom));

	return 1;

}

/*---------------------------------------------------------------------------*/
int SET_OUTPUT_AUTO_GLUE (
/*---------------------------------------------------------------------------*/
	void    *p_nom) {

	int		argc=1;
	void		*argv[1];
	int		code;
	IDL_STRING	*nom;

	// p_nom -> nom
	nom = malloc (sizeof(IDL_STRING));
	IDL_StrStore (nom, p_nom);

	argv[0] = nom;
	code = SET_OUTPUT (argc, argv);

	free (nom);

	return code;

}

/*---------------------------------------------------------------------------*/
int SET_PLOT (int argc, void *argv[]) {
/*---------------------------------------------------------------------------*/
	IDL_STRING  	*device		=	(IDL_STRING *)	argv[0]; // Entres
	IDL_STRING  	*filename	=	(IDL_STRING *)	argv[1]; // Entres
	int		*x_vsize	=	(int *)		argv[2]; // Sorties
	int		*y_vsize	=	(int *)		argv[3]; // Sorties

	PLFLT	p_xp, p_yp;
	PLINT	p_xleng, p_yleng, p_xoff, p_yoff;

	if (nom_output[0]) {
		fd_output = fopen (nom_output, "w");
		fprintf (fd_output, "SET_PLOT %d#%s %d#%s %d %d\n",
			device->slen, IDL_STRING_STR(device), filename->slen, IDL_STRING_STR(filename), *x_vsize, *y_vsize);
		fflush (fd_output);
		return 1;
	}

	if (device_init) {
		plspause (0);
		plend ();
	}

	if (strcmp(IDL_STRING_STR(device),"X")==0 || strcmp(IDL_STRING_STR(device),"WIN")==0) {

		plsetopt ("dev", "xwin");

		device_charsize = 0.35;
		device_symsize = 0.85;
		device_charthick = 1.00;
		device_symthick = 1.00;

	} else if (strcmp(IDL_STRING_STR(device),"PS")==0) {


		//plsetopt ("dev", "psc");	// bug dans la taille des polices
		//plsetopt ("dev", "psttfc");	// ok
		plsetopt ("dev", "pscairo");	// ok
		plsetopt ("o", IDL_STRING_STR(filename));

		device_charsize = 0.55;		// caractre
		device_charthick = 1.00;	// caractre

		device_symsize = 0.6;		// courbe
		device_symthick = 0.10;		// courbe

	} else if (strcmp(IDL_STRING_STR(device),"PNG")==0) {

		plsetopt ("dev", "pngqt");	// ok
		//plsetopt ("dev", "pngcairo");	// ok
		plsetopt ("o", IDL_STRING_STR(filename));

		device_charsize = 0.45;
		device_symsize = 0.55;
		device_charthick = 1.0;
		device_symthick = 1.00;

	}

	// background color blanc pour que les fenetres et les postscript soient sous fond blanc
	plscolbg (255,255,255);

	if (*x_vsize !=0 && *y_vsize != 0) {
		plspage (0, 0, *x_vsize, *y_vsize, 0, 0);
	}

	plinit ();
	device_init = 1;

	plgpage (&p_xp, &p_yp, &p_xleng, &p_yleng, &p_xoff, &p_yoff);

	*x_vsize = p_xleng;
	*y_vsize = p_yleng;

	device_xsize = p_xleng;
	device_ysize = p_yleng;

	return 1;

}

/*---------------------------------------------------------------------------*/
int SET_PLOT_AUTO_GLUE (
/*---------------------------------------------------------------------------*/
	void    *p_device,
	void    *p_filename,
	void    *p03,
	void    *p04) {

	int		argc=4;
	void		*argv[4];
	int		code;
	IDL_STRING	*device;
	IDL_STRING	*filename;

	// p_device -> device
	device = malloc (sizeof(IDL_STRING));
	IDL_StrStore (device, p_device);

	// p_filename -> filename
	filename = malloc (sizeof(IDL_STRING));
	IDL_StrStore (filename, p_filename);

	argv[0] = device;
	argv[1] = filename;
	argv[2] = p03;
	argv[3] = p04;
	code = SET_PLOT (argc, argv);

	free (device);
	free (filename);

	return code;

}

/*---------------------------------------------------------------------------*/
int END (int argc, void *argv[]) {
/*---------------------------------------------------------------------------*/

	if (nom_output[0]) {
		fprintf (fd_output, "END\n");
		fclose (fd_output);
		return 1;
	}

	plspause (0);
	plend ();
	device_init = 0;

	return 1;

}

/*---------------------------------------------------------------------------*/
int END_AUTO_GLUE (void) {
/*---------------------------------------------------------------------------*/

	int	argc=1;
	void	*argv[1];

	return END (argc, argv);

}

/*---------------------------------------------------------------------------*/
void data_to_dev (
/*---------------------------------------------------------------------------*/
	double	x1,	
	double	x2,
	double	y1,
	double	y2,
	double	xmin,
	double	xmax,
	double	ymin,
	double	ymax,
	double	xdata,
	double	ydata,
	double	*xdev,
	double	*ydev) {
/*---------------------------------------------------------------------------*/

	double	xs[2];
	double	ys[2];
	double	xnorm;
	double	ynorm;

	xs[0] = x1-xmin*(x2-x1)/(xmax-xmin);
	xs[1] = (x2-x1)/(xmax-xmin);
	ys[0] = y1-ymin*(y2-y1)/(ymax-ymin);
	ys[1] = (y2-y1)/(ymax-ymin);

	xnorm = xs[0] + xs[1]*xdata;
	ynorm = ys[0] + ys[1]*ydata;

	*xdev = xnorm * device_xsize;
	*ydev = ynorm * device_ysize;

}


/*---------------------------------------------------------------------------*/
int ERASE (int argc, void *argv[]) {
/*---------------------------------------------------------------------------*/

	if (nom_output[0]) {
		fprintf (fd_output, "ERASE\n");
		fflush (fd_output);
		return 1;
	}

	plclear ();

	return 1;

}

/*---------------------------------------------------------------------------*/
int ERASE_AUTO_GLUE (void) {
/*---------------------------------------------------------------------------*/

	int	argc=1;
	void	*argv[1];

	return ERASE (argc, argv);

}

#define MAX_LABEL	60
PLINT	label_nb;
PLFLT	label_val[MAX_LABEL];
char	label_lab[MAX_LABEL][100];
PLINT	label_phase;


/*---------------------------------------------------------------------------*/
void plslabelfunc_plot_axis (PLINT axis, PLFLT value, char *label, PLINT length, PLPointer PL_UNUSED(data)) {
/*---------------------------------------------------------------------------*/
// Fonction pour afficher un label dans PLOT

	if (label_phase==1) {

		label_val[label_nb] = value;

	} else if (label_phase == 2) {

		strcpy (label, label_lab[label_nb]);

	}

	label_nb++;

}

/*---------------------------------------------------------------------------*/
void compute_label (int label_log, double *tickv, int nbtickv) {
/*---------------------------------------------------------------------------*/

	int	i;
	int	j;
	int	nb_remove;
	int	nb_remove_all;
	int	log;
	double	val;
	double	valmin;
	double	valmax;
	int	noformat=0; // 1 pour %f et 2 pour %e
	char	format[1024];
	char	label1[MAX_LABEL][100];
	char	label2[MAX_LABEL][100];
	double	label_min;
	double	label_max;

	label_min = label_val[0];
	label_max = label_val[0];
	for (i=1 ; i<label_nb ; i++) {
		if (label_val[i] < label_min) label_min = label_val[i];
		if (label_val[i] > label_max) label_max = label_val[i];
	}

	for (i=0 ; i<label_nb ; i++) {
		log	= label_log;
		val	= log ? pow(10.,label_val[i])	: label_val[i];
		valmin	= label_min;
		valmax	= label_max;

		// pour essayer de faire comme IDL
		if (log==0) {
			if (valmax-valmin < 1e-6 || valmax-valmin > 1e6) {
				strcpy (format, "%.2e");
				noformat = 2;
			} else {
				strcpy (format, "%.6f");
				noformat = 1;
			}
		} else {
			if (valmin < -6 || valmax-valmin < -6 || valmax-valmin > 6 || valmax > 6) {
				strcpy (format, "%.2e");
				noformat = 2;
			} else {
				strcpy (format, "%.6f");
				noformat = 1;
			}
		}

		sprintf (label1[i], format, val);
		if (noformat==1) {
			label2[i][0] = 0;
		} else if (noformat==2) {
			for (j=0 ; j<strlen(label1[i]) ; j++) {
				if (label1[i][j]=='e') {
					sprintf (label2[i], "%s", label1[i]+j);
					label1[i][j] = 0;
					break;
				}
			}
		}

	}

	nb_remove_all = 0;
	for (i=0 ; i<label_nb ; i++) {
		nb_remove = 0;
		for (j=strlen(label1[i])-1 ; j>=0 ; j--) {
			if (label1[i][j] == '0') {
				nb_remove++;
			} else {
				if (label1[i][j] == '.') {
					nb_remove++;
				}
				break;
			}
		}
		if (i==0) {
			nb_remove_all = nb_remove;
		} else if (nb_remove < nb_remove_all) {
			nb_remove_all = nb_remove;
		}
	}


	for (i=0 ; i<label_nb ; i++) {
		label1[i][strlen(label1[i])-nb_remove_all] = 0;

		if (nbtickv==0) {
			if (label2[i][0]==0) {
				sprintf (label_lab[i], "%s", label1[i]);
			} else if (strcmp(label1[i],"0")==0 && strcmp(label2[i],"e+00")==0) {
				strcpy (label_lab[i], "0");
			} else {
				sprintf (label_lab[i], "%s%s", label1[i], label2[i]);
			}
		} else {
			label_lab[i][0] = 0;
			for (j=0 ; j<nbtickv ; j++) {
				if (label_val[i] == tickv[j]) {
					if (label2[i][0]==0) {
						sprintf (label_lab[i], "%s", label1[i]);
					} else if (strcmp(label1[i],"0")==0 && strcmp(label2[i],"e+00")==0) {
						strcpy (label_lab[i], "0");
					} else {
						sprintf (label_lab[i], "%s%s", label1[i], label2[i]);
					}
					break;
				}
			}
		}
	}

}

/*---------------------------------------------------------------------------*/
void graduer_axe (
/*---------------------------------------------------------------------------*/
	double	x1,
	double	x2,
	double	y1,
	double	y2,
	double	charsize,
	double	charthick,
	int	xaxis,	// 0=bas 1=haut 2=bas+haut
	double	xmin,
	double	xmax,
	int	xlog,
	int	xstyle,
	double	xticklen,
	int	xvalues,
	int	yaxis,	// 0=gauche 1=droite 2=gauche+droite
	double	ymin,
	double	ymax,
	int	ylog,
	int	ystyle,
	double	yticklen,
	int	yvalues,
	double	*ytickv,
	int	nbytickv) {
/*---------------------------------------------------------------------------*/

	int	myno;
	char	xopt[1024]="";
	char	yopt[1024]="";
	int	label_log;
	int	i;
	double	xpos;
	double	ypos;
	double	alignment;
	double	dx=1;
	double	dy=0;

	pllsty (1);
	plwidth (charthick * device_charthick); // valeurs sur axe

	for (myno=0 ; myno<2 ; myno++) {

		// Les 2 axes n'ont pas les mmes ticklen donc il faut faire en 2 fois:  myno==0 pour X et myno==1 pour Y

		xopt[0] = 0;
		yopt[0] = 0;

		if (myno==0 && xstyle != 5) {
			//printf ("PLOT xstyle=%d xticklen = %f\n", xstyle, xticklen);
			if (xaxis==0) {
				sprintf (xopt, "bnstfo");	// bas
			} else if (xaxis==1) {
				sprintf (xopt,  "cmstfo");	// haut
			} else if (xaxis==3) {
				sprintf (xopt, "bncstfo");	// bas+haut
			}
			if (xticklen < 0) sprintf (xopt+strlen(xopt),"i");
			if (xlog) sprintf (xopt+strlen(xopt),"l");
		}

		if (myno==1 && ystyle != 5) {
			//printf ("PLOT ystyle=%d yticklen = %f\n", ystyle, yticklen);
			if (yaxis==0) {
				sprintf (yopt, "bnstvfo");	// gauche
			} else if (yaxis==1) {
				sprintf (yopt, "cmstvfo");	// droite
			} else if (yaxis==3) {
				sprintf (yopt, "bncstfvo");	// gauche+droite
			}
			if (yticklen < 0) sprintf (yopt+strlen(yopt),"i");
			if (ylog) sprintf (yopt+strlen(yopt),"l");
		}

		plsmin (0, 0); // tick minor:		facteur=0 pour supprimer les minor tick
		plsmaj (0, 0); // tick major:		facteur=0 pour supprimer les major tick
		plschr (0, 0); // taille caractres: 	facteur=0 pour supprimer les labels

		plslabelfunc (plslabelfunc_plot_axis, NULL);
		label_nb = 0;
		label_phase = 1;
		plaxes (xmin, ymin, xopt, 0, 0, yopt, 0, 0);	// axes

		label_log = myno == 0 ? xlog : ylog;
		if (myno==0) {
			compute_label (label_log, NULL, 0);
		} else {
			compute_label (label_log, ytickv, nbytickv);
		}
		if ((myno==0 && xvalues==0) || (myno==1 && yvalues==0)) {
			for (i=0 ; i<label_nb ; i++) {
				label_lab[i][0] = 0;
			}
		}

		if ((myno==0 && xstyle!=5 && xticklen < 0) || (myno==1 && ystyle!=5 && yticklen < 0)) {
			// tentative de correction bug graduations vers l'extrieur

			// (1) afficher les labels
			plschr (0, charsize * device_charsize);				// taille caractres
			plvpor (0.0, 1.0, 0.0, 1.0);					// normalis
			plwind (0.0, 1.0, 0.0, 1.0);					// normalis
			plsdidev (0.0, 0.0, 0.0, 0.0);
			for (i=0 ; i<label_nb ; i++) {
				if (myno==0) {
					if (xaxis==0 || xaxis==3) {
						ypos = y1-fabs(xticklen) * (y2-y1) * 4.5;
						if (ypos < 0) ypos=0;
						alignment = 0.5;
					} else {
						ypos = y2+fabs(xticklen) * (y2-y1) * 4.5;
						if (ypos > 1) ypos=1;
						alignment = 0.5;
					}
					xpos = x1+(label_val[i]-xmin)/(xmax-xmin)*(x2-x1);
				} else {
					if (yaxis==0 || yaxis==3) {
						xpos = x1-fabs(yticklen) * (x2-x1) * 1.25;
						if (xpos < 0) xpos=0;
						alignment = 1;
					} else {
						xpos = x2+fabs(yticklen) * (x2-x1) * 1.25;
						if (xpos > 1) xpos=1;
						alignment = 0;
					}
					ypos = y1+(label_val[i]-ymin)/(ymax-ymin)*(y2-y1);
				}
				plptex (xpos, ypos, dx, dy, alignment, label_lab[i]);
			}


			// (2) afficher l'axe
			plschr (0, 0);
			if (myno==0) {
				plsmin (0, fabs(xticklen)*75*(y2-y1)); // tick minor
				plsmaj (0, fabs(xticklen)*75*(y2-y1)); // tick major
			} else {
				plsmin (0, fabs(yticklen)*75*(x2-x1)); // tick minor
				plsmaj (0, fabs(yticklen)*75*(x2-x1)); // tick major
			}
			plvpor (x1, x2, y1, y2);		// normalized par rapport  data
			plwind (xmin, xmax, ymin, ymax);	// data sinon ca ne marche pas
			label_nb = 0;
			label_phase = 2;
			plaxes (xmin, ymin, xopt, 0, 0, yopt, 0, 0);	// que les axes (sans les labels)

		} else {
			plschr (0, charsize * device_charsize);		// taille caractres
			if (myno==0 && xstyle != 5) {
				plsmin (0, fabs(xticklen)*75*(y2-y1)); // tick minor
				plsmaj (0, fabs(xticklen)*75*(y2-y1)); // tick major
			}
			if (myno==1 && ystyle != 5) {
				plsmin (0, fabs(yticklen)*75*(x2-x1)); // tick minor
				plsmaj (0, fabs(yticklen)*75*(x2-x1)); // tick major
			}
			plvpor (x1, x2, y1, y2);		// normalized par rapport  data
			plwind (xmin, xmax, ymin, ymax);	// data sinon ca ne marche pas
			label_nb = 0;
			label_phase = 2;
			plaxes (xmin, ymin, xopt, 0, 0, yopt, 0, 0);	// axes
		}
	}

}

/*---------------------------------------------------------------------------*/
int PLOT (int argc, void *argv[]) {
/*---------------------------------------------------------------------------*/
	int		nbarg		=	0;
	int		xlog		=	*(int *)	argv[nbarg++];
	int		ylog		=	*(int *)	argv[nbarg++];
	double		*x		=	(double *)	argv[nbarg++];
	double		*y		=	(double *)	argv[nbarg++];
	int		nb		=	*(int *)	argv[nbarg++];
	double		xmin		=	*(double *)	argv[nbarg++];
	double		xmax		=	*(double *)	argv[nbarg++];
	double		ymin		=	*(double *)	argv[nbarg++];
	double		ymax		=	*(double *)	argv[nbarg++];
	double		x1		=	*(double *)	argv[nbarg++];
	double		x2		=	*(double *)	argv[nbarg++];
	double		y1		=	*(double *)	argv[nbarg++];
	double		y2		=	*(double *)	argv[nbarg++];
	int		xstyle		=	*(int *)	argv[nbarg++];
	int		ystyle		=	*(int *)	argv[nbarg++];
	int		color		=	*(int *)	argv[nbarg++];
	int		linestyle	=	*(int *)	argv[nbarg++];
	int		nodata		=	*(int *)	argv[nbarg++];
	double		xticklen	=	*(double *)	argv[nbarg++];
	double		yticklen	=	*(double *)	argv[nbarg++];
	double		charsize	=	*(double *)	argv[nbarg++];
	int		psym		=	*(int *)	argv[nbarg++];
	double		symsize		=	*(double *)	argv[nbarg++];
	double		*xsym		=	(double *)	argv[nbarg++];
	double		*ysym		=	(double *)	argv[nbarg++];
	int		nbsym		=	*(int *)	argv[nbarg++];
	double		thick		=	*(double *)	argv[nbarg++];
	double		charthick	=	*(double *)	argv[nbarg++];
	int		xvalues		=	*(int *)	argv[nbarg++];
	int		yvalues		=	*(int *)	argv[nbarg++];
	double		*ytickv		=	(double *)	argv[nbarg++];
	int		nbytickv	=	*(int *)	argv[nbarg++];

	int	xaxis;
	int	yaxis;
	int	psym1;
	double	*tabx;
	double	*taby;
	double	dx;
	int	i;
	int	j;
	double	xminsym;
	double	xmaxsym;
	double	yminsym;
	double	ymaxsym;
	double	facteurx;
	double	facteury;
	double	xdata;
	double	ydata;
	double	xdev;
	double	ydev;

	if (nom_output[0]) {
		fprintf (fd_output, "PLOT %d %d %d ",xlog,ylog,nb);
		for (i=0 ; i<nb ; i++) {
			fprintf (fd_output, "%.10e",x[i]);
			if (i!=nb-1) fprintf (fd_output, " ");
		}
		fprintf (fd_output, " ");
		for (i=0 ; i<nb ; i++) {
			fprintf (fd_output, "%.10e",y[i]);
			if (i!=nb-1) fprintf (fd_output, " ");
		}
		fprintf (fd_output," %.10e %.10e %.10e %.10e %.10e %.10e %.10e %.10e %d %d %d", xmin, xmax, ymin, ymax, x1, x2, y1, y2, xstyle, ystyle, color);
		fprintf (fd_output," %d %d %.10e %.10e %.10e %d", linestyle, nodata, xticklen, yticklen, charsize, psym);
		fprintf (fd_output," %.10e", symsize);
		fprintf (fd_output," %d ",nbsym);
		for (i=0 ; i<nbsym ; i++) {
			fprintf (fd_output,"%.10e", xsym[i]);
			if (i!=nbsym-1) fprintf (fd_output," ");
		}
		fprintf (fd_output," ");
		for (i=0 ; i<nbsym ; i++) {
			fprintf (fd_output,"%.10e", ysym[i]);
			if (i!=nbsym-1) fprintf (fd_output," ");
		}
		fprintf (fd_output," %.10e %.10e %d %d %d ", thick, charthick, xvalues, yvalues, nbytickv);
		for (i=0 ; i<nbytickv ; i++) {
			fprintf (fd_output,"%.10e", ytickv[i]);
			if (i!=nbytickv-1) fprintf (fd_output," ");
		}
		fprintf (fd_output,"\n");
		fflush (fd_output);
		return 1;
	}

	plcol0 (color);

	pladv (1);
	plvpor (x1, x2, y1, y2);		// normalized par rapport  data
	plwind (xmin, xmax, ymin, ymax);	// data

	plschr (0, charsize * device_charsize);	// taille caractres
	plwidth (thick * device_symthick); // courbe

	if (psym) {

		// psym vaut entre 1 et 8 ou 10

		if (abs(psym) == 10) {

			// histogramme
			if (nb == 1) {
				pllsty (linestyle+1);
				plline (nb, x, y);		// plot
			} else {
				tabx = (double *) malloc (2 * nb * sizeof(double));
				taby = (double *) malloc (2 * nb * sizeof(double));
				for (i=0 ; i<nb ; i++) {
					if (i==0) {
						dx = x[i+1] - x[i];
						tabx[2*i+0] = x[i] - 0.5 * dx;
						tabx[2*i+1] = x[i] + 0.5 * dx;
					} else if (i==nb-1) {
						dx = x[i] - x[i-1];
						tabx[2*i+0] = x[i] - 0.5 * dx;
						tabx[2*i+1] = x[i] + 0.5 * dx;
					} else {
						tabx[2*i+0] = (x[i-1] + x[i]) * 0.5;
						tabx[2*i+1] = (x[i+1] + x[i]) * 0.5;
					}
					taby[2*i+0] = y[i];
					taby[2*i+1] = y[i];
				}
				pllsty (linestyle+1);
				plline (2*nb, tabx, taby);		// plot
				free (tabx);
				free (taby);
			}

		} else if (abs(psym) == 8) {

			// utiliser xsym, ysym, nbsym

			xminsym = xmaxsym = xsym[0];
			yminsym = ymaxsym = ysym[0];
			for (i=1 ; i<nbsym ; i++) {
				if (xsym[i] < xminsym) xminsym = xsym[i];
				if (xsym[i] > xmaxsym) xmaxsym = xsym[i];
				if (ysym[i] < yminsym) yminsym = ysym[i];
				if (ysym[i] > ymaxsym) ymaxsym = ysym[i];
			}
			facteurx = 10. / fabs(xmaxsym - xminsym);
			facteury = 10. / fabs(ymaxsym - yminsym);

			if (nbsym) {
				plvpor (0.0, 1.0, 0.0, 1.0);		// normalis
				plwind (0.0, device_xsize-1, 0.0, device_ysize-1);	// dev
				plsdidev (0.0, 0.0, 0.0, 0.0);
				tabx = (double *) malloc (nbsym * sizeof(double));
				taby = (double *) malloc (nbsym * sizeof(double));
				for (i=0 ; i<nb ; i++) {
					for (j=0 ; j<nbsym ; j++) {
						xdata = x[i];
						ydata = y[i];
						data_to_dev (x1,x2,y1,y2,xmin,xmax,ymin,ymax,xdata,ydata,&xdev,&ydev);
						tabx[j] = xdev + symsize * xsym[j] * facteurx;
						taby[j] = ydev + symsize * ysym[j] * facteury;
					}
					pllsty (linestyle+1);
					plline (nbsym, tabx, taby);		// plot
				}
				free (tabx);
				free (taby);
				plvpor (x1, x2, y1, y2);		// normalized par rapport  data
				plwind (xmin, xmax, ymin, ymax);	// data
			}

		} else {

			switch (abs(psym)) {

				case 1:		psym1=2;	break;
				case 2:		psym1=3;	break;
				case 3:		psym1='.';	break;
				case 4:		psym1=11;	break;
				case 5:		psym1=7;	break;
				case 6:		psym1=13;	break;
				case 7:		psym1=5;	break;
				default:	psym1=4;	break;
			}

			//printf ("psym=%d psym1=%d symsize=%f\n", psym, psym1, symsize);

			// psym		IDL			PLPLOT
			// 1		+			losange
			// 2		*			+
			// 3		.			*
			// 4		Diamond			cercle
			// 5		Triangle		X
			// 6		Square			Square
			// 7		X			Triangle
			// 8		Histogram		sorte de carr
			// 9					rond avec un point au centre
			// 10					sorte de carr
			// 11					losange
			// 12					toile
			// 13					carr

			plssym (0.0, symsize * device_symsize);	// symsize
			plpoin (nb, x, y, psym1);		// psym
		}

	}

	if (psym <= 0 && abs(psym) != 10) {

		// Linestyle	IDL			PLPLOT
		// 		0=Solid			1=Solid
		// 		1=Dotted		petit tirets
		// 		2=Dashed		3=Dashed
		// 		3=Dash Dot		grand tiret / vide / grand tiret / vide
		// 		4=Dash Dot Dot Dot	grand tiret / vide / petit tiret
		// 		5=Long Dashes		grand tiret / vide / petit tiret

		pllsty (linestyle+1);

		if (nodata==0) {
			plline (nb, x, y);		// plot
		}
	}

	plschr (0, charsize * device_charsize);	// taille caractres
	plwidth (charthick * device_charthick); // valeurs sur axe
	xaxis = 3;
	yaxis = 3;
	graduer_axe (x1, x2, y1, y2, charsize, charthick, xaxis, xmin, xmax, xlog, xstyle, xticklen, xvalues, yaxis, ymin, ymax, ylog, ystyle, yticklen, yvalues, ytickv, nbytickv);

	return 1;

}

/*---------------------------------------------------------------------------*/
int PLOT_AUTO_GLUE (
/*---------------------------------------------------------------------------*/
	void    *p01,
	void    *p02,
	void    *p03,
	void    *p04,
	void    *p05,
	void    *p06,
	void    *p07,
	void    *p08,
	void    *p09,
	void    *p10,
	void    *p11,
	void    *p12,
	void    *p13,
	void    *p14,
	void    *p15,
	void    *p16,
	void    *p17,
	void    *p18,
	void    *p19,
	void    *p20,
	void    *p21,
	void    *p22,
	void    *p23,
	void    *p24,
	void    *p25,
	void    *p26,
	void    *p27,
	void    *p28,
	void    *p29,
	void    *p30,
	void    *p31,
	void    *p32) {

	int	argc=32;
	void	*argv[32];

	argv[ 0] = p01;
	argv[ 1] = p02;
	argv[ 2] = p03;
	argv[ 3] = p04;
	argv[ 4] = p05;
	argv[ 5] = p06;
	argv[ 6] = p07;
	argv[ 7] = p08;
	argv[ 8] = p09;
	argv[ 9] = p10;
	argv[10] = p11;
	argv[11] = p12;
	argv[12] = p13;
	argv[13] = p14;
	argv[14] = p15;
	argv[15] = p16;
	argv[16] = p17;
	argv[17] = p18;
	argv[18] = p19;
	argv[19] = p20;
	argv[20] = p21;
	argv[21] = p22;
	argv[22] = p23;
	argv[23] = p24;
	argv[24] = p25;
	argv[25] = p26;
	argv[26] = p27;
	argv[27] = p28;
	argv[28] = p29;
	argv[29] = p30;
	argv[30] = p31;
	argv[31] = p32;
	return PLOT (argc, argv);

}

/*---------------------------------------------------------------------------*/
int AXIS (int argc, void *argv[]) {
/*---------------------------------------------------------------------------*/
	int		nbarg		=	0;
	int		axis		=	*(int *)	argv[nbarg++];
	int		xlog		=	*(int *)	argv[nbarg++];
	int		ylog		=	*(int *)	argv[nbarg++];
	double		xmin		=	*(double *)	argv[nbarg++];
	double		xmax		=	*(double *)	argv[nbarg++];
	double		ymin		=	*(double *)	argv[nbarg++];
	double		ymax		=	*(double *)	argv[nbarg++];
	double		x1		=	*(double *)	argv[nbarg++];
	double		x2		=	*(double *)	argv[nbarg++];
	double		y1		=	*(double *)	argv[nbarg++];
	double		y2		=	*(double *)	argv[nbarg++];
	int		color		=	*(int *)	argv[nbarg++];
	double		xticklen	=	*(double *)	argv[nbarg++];
	double		yticklen	=	*(double *)	argv[nbarg++];
	double		charsize	=	*(double *)	argv[nbarg++];
	double		charthick	=	*(double *)	argv[nbarg++];

	int	xaxis=0;
	int	yaxis=0;
	int	xstyle=5;
	int	ystyle=5;
	int	xvalues=1;
	int	yvalues=1;
	double	ytickv[2]={0,0};
	int	nbytickv=0;

	if (nom_output[0]) {
		fprintf (fd_output,"AXIS %d %d %d", axis, xlog, ylog);
		fprintf (fd_output," %.10e %.10e %.10e %.10e %.10e %.10e %.10e %.10e %d", xmin, xmax, ymin, ymax, x1, x2, y1, y2, color);
		fprintf (fd_output," %.10e %.10e %.10e %.10e\n", xticklen, yticklen, charsize, charthick);
		fflush (fd_output);
		return 1;
	}

	plcol0 (color);
	pladv (1);
	plvpor (x1, x2, y1, y2);		// normalized par rapport  data
	plwind (xmin, xmax, ymin, ymax);	// data

	if (axis==0) {
		xaxis = 0;
		yaxis = 0;
		xstyle = 1;
		ystyle = 5;
	} else if (axis==1) {
		xaxis = 1;
		yaxis = 0;
		xstyle = 1;
		ystyle = 5;
	} else if (axis==2) {
		xaxis = 0;
		yaxis = 0;
		xstyle = 5;
		ystyle = 1;
	} else if (axis==3) {
		xaxis = 0;
		yaxis = 1;
		xstyle = 5;
		ystyle = 1;
	}

	//printf ("charsize=%f charthick=%f\n", charsize, charthick);
	//printf ("xaxis=%d xmin=%f xmax=%f xlog=%d xstyle=%d xticklen=%f xvalues=%d\n", xaxis, xmin, xmax, xlog, xstyle, xticklen, xvalues);
	//printf ("yaxis=%d ymin=%f ymax=%f ylog=%d ystyle=%d yticklen=%f yvalues=%d\n", yaxis, ymin, ymax, ylog, ystyle, yticklen, yvalues);
	graduer_axe (x1, x2, y1, y2, charsize, charthick, xaxis, xmin, xmax, xlog, xstyle, xticklen, xvalues, yaxis, ymin, ymax, ylog, ystyle, yticklen, yvalues, ytickv, nbytickv);

	return 1;
}

/*---------------------------------------------------------------------------*/
int AXIS_AUTO_GLUE (
/*---------------------------------------------------------------------------*/
	void    *p01,
	void    *p02,
	void    *p03,
	void    *p04,
	void    *p05,
	void    *p06,
	void    *p07,
	void    *p08,
	void    *p09,
	void    *p10,
	void    *p11,
	void    *p12,
	void    *p13,
	void    *p14,
	void    *p15,
	void    *p16) {

	int	argc=16;
	void	*argv[16];

	argv[ 0] = p01;
	argv[ 1] = p02;
	argv[ 2] = p03;
	argv[ 3] = p04;
	argv[ 4] = p05;
	argv[ 5] = p06;
	argv[ 6] = p07;
	argv[ 7] = p08;
	argv[ 8] = p09;
	argv[ 9] = p10;
	argv[10] = p11;
	argv[11] = p12;
	argv[12] = p13;
	argv[13] = p14;
	argv[14] = p15;
	argv[15] = p16;
	return AXIS (argc, argv);

}

/*---------------------------------------------------------------------------*/
int XYOUTS (int argc, void *argv[]) {
/*---------------------------------------------------------------------------*/
	double		x		=	*(double *)	argv[0];
	double		y		=	*(double *)	argv[1];
	IDL_STRING 	*str		=	(IDL_STRING *)	argv[2];
	double		alignment	=	*(double *)	argv[3];
	double		charsize	=	*(double *)	argv[4];
	double		orientation	=	*(double *)	argv[5];
	int		couleur		=	*(int *)	argv[6];
	double		charthick	=	*(double *)	argv[7];

	double		dx;
	double		dy;
	double		dxC;
	double		dyC;
	char		str1[1024];
	char		str2[1024];
	int		i1;
	double		x1;
	double		y1;
	int		len;
	int		i;
	int		font=3;

	sprintf (str1, "%s", IDL_STRING_STR(str));

	if (nom_output[0]) {
		fprintf (fd_output,"XYOUTS %.10e %.10e %ld#%s %.10e %.10e %.10e %d %.10e\n", x, y, strlen(str1), str1, alignment, charsize, orientation, couleur, charthick);
		fflush (fd_output);
		return 1;
	}


	dx = cos (orientation / 180 * M_PI);
	dy = sin (orientation / 180 * M_PI) * device_xsize / device_ysize;
	dxC = cos ((orientation-90) / 180 * M_PI);
	dyC = sin ((orientation-90) / 180 * M_PI) * device_xsize / device_ysize;

	plwidth (charthick * device_charthick); // ne sert  rien ???
	plschr (0, charsize * device_charsize);	// taille caractres
	pladv (1);
	plcol0 (couleur);
	plvpor (0.0, 1.0, 0.0, 1.0);	// normalis
	plwind (0.0, 1.0, 0.0, 1.0);	// normalis
	plsdidev (0.0, 0.0, 0.0, 0.0);

	// Dcouper par "!C"
	len = strlen(str1);
	i1 = 0;
	x1 = x;
	y1 = y;
	for (i=0 ; i<len ; ) {
		if (str1[i]=='!' && i+1<len && str1[i+1]=='E') {
			// ex: H!E+ exposant (up)
			str2[i1++] = '#';
			str2[i1++] = 'u';
			i += 2;
		} else if (str1[i]=='!' && i+1<len && str1[i+1]=='U') {
			// ex: cm!U-3 exposant (up)
			str2[i1++] = '#';
			str2[i1++] = 'u';
			i += 2;
		} else if (str1[i]=='!' && i+1<len && str1[i+1]=='N') {
			// fin exposant
			str2[i1++] = '#';
			str2[i1++] = 'd';
			i += 2;
		} else if (str1[i]=='!' && i+1<len && str1[i+1]=='3') {
			font = 3;
			i += 2;
		} else if (str1[i]=='!' && i+1<len && str1[i+1]=='4') {
			font = 4;
			i += 2;
		} else if (font==4 && str1[i]=='h') {
			// theta (minuscule)
			str2[i1++] = '#';
			str2[i1++] = 'g';
			str2[i1++] = 'h';
			i++;
		} else if (font==4 && str1[i]=='u') {
			// phi (minuscule)
			str2[i1++] = '#';
			str2[i1++] = 'g';
			str2[i1++] = 'f';
			i++;
		} else if (font==4 && str1[i]=='R') {
			// sigma (majuscule)
			str2[i1++] = '#';
			str2[i1++] = 'g';
			str2[i1++] = 'S';
			i++;
		} else if (str1[i]=='!' && i+1<len && str1[i+1]=='C') {
			str2[i1] = 0;
			plptex (x1, y1, dx, dy, alignment, str2);
			i1 = 0;
			x1 += dxC * 0.00787700 * 1.75 * charsize * device_ysize / device_xsize;
			y1 += dyC * 0.00787700 * 1.75 * charsize;
			i += 2;
		} else {
			str2[i1] = str1[i];
			i1++;
			i++;
		}
	}
	str2[i1] = 0;
	plptex (x1, y1, dx, dy, alignment, str2);

	// pour tester les caractres grecs
	//plptex (x, y, dx, dy, alignment, "#ga#gb#gc#gd#ge#gf#gg#gh#gi#gj#gk#gl#gm#gn#go#gp#gq#gr#gs#gt#gu#gv#gw#gx#gy#gz\n");
	//plptex (x, y, dx, dy, alignment, "#gA#gB#gC#gD#gE#gF#gG#gH#gI#gJ#gK#gL#gM#gN#gO#gP#gQ#gR#gS#gT#gU#gV#gW#gX#gY#gZ\n");

	return 1;

}

/*---------------------------------------------------------------------------*/
int XYOUTS_AUTO_GLUE (
/*---------------------------------------------------------------------------*/
	void    *p01,
	void    *p02,
	void    *p_str,
	void    *p04,
	void    *p05,
	void    *p06,
	void    *p07,
	void    *p08) {

	int		argc=8;
	void		*argv[8];
	int		code;
	IDL_STRING	*str;

	// p_str -> str
	str = malloc (sizeof(IDL_STRING));
	IDL_StrStore (str, p_str);

	argv[0] = p01;
	argv[1] = p02;
	argv[2] = str;
	argv[3] = p04;
	argv[4] = p05;
	argv[5] = p06;
	argv[6] = p07;
	argv[7] = p08;
	code = XYOUTS (argc, argv);

	free (str);

	return code;

}

/*---------------------------------------------------------------------------*/
int TVLCT (int argc, void *argv[]) {
/*---------------------------------------------------------------------------*/
	int		*r		=	(int *)		argv[0];
	int		*v		=	(int *)		argv[1];
	int		*b		=	(int *)		argv[2];
	int		nb		=	*(int *)	argv[3];

	int		i;

	if (nom_output[0]) {
		fprintf (fd_output,"TVLCT %d ", nb);
		for (i=0 ; i<nb ; i++) {
			fprintf (fd_output,"%d", r[i]);
			if (i!=nb-1) fprintf (fd_output," ");
		}
		fprintf (fd_output," ");
		for (i=0 ; i<nb ; i++) {
			fprintf (fd_output,"%d", v[i]);
			if (i!=nb-1) fprintf (fd_output," ");
		}
		fprintf (fd_output," ");
		for (i=0 ; i<nb ; i++) {
			fprintf (fd_output,"%d", b[i]);
			if (i!=nb-1) fprintf (fd_output," ");
		}
		fprintf (fd_output,"\n");
		fflush (fd_output);
		return 1;
	}

	plscmap0 (r, v, b, nb);

	// pour que ERASE efface l'cran avec la bonne couleur (0)
	pladv (1);
	plcol0 (0);

	return 1;

}

/*---------------------------------------------------------------------------*/
int TVLCT_AUTO_GLUE (
/*---------------------------------------------------------------------------*/
	void    *p01,
	void    *p02,
	void    *p03,
	void    *p04) {

	int	argc=4;
	void	*argv[4];

	argv[0] = p01;
	argv[1] = p02;
	argv[2] = p03;
	argv[3] = p04;
	return TVLCT (argc, argv);

}

/*---------------------------------------------------------------------------*/
int TV (int argc, void *argv[]) {
/*---------------------------------------------------------------------------*/
	double		x1		=	*(double *)		argv[0];
	double		x2		=	*(double *)		argv[1];
	double		y1		=	*(double *)		argv[2];
	double		y2		=	*(double *)		argv[3];
	unsigned char	*image		=	(unsigned char *)	argv[4]; // Entres image[nbx,nby]
	int		nbx		=	*(int *)		argv[5]; // Entres nbx
	int		nby		=	*(int *)		argv[6]; // Entres nby

	int		i;
	int		j1;
	int		j2;
	int		couleur;

	PLFLT		x[4];
	PLFLT		y[4];

	int		j;

	if (nom_output[0]) {
		fprintf (fd_output,"TV %.10e %.10e %.10e %.10e %d %d ", x1, x2, y1, y2, nbx, nby);
		for (i=0 ; i<nbx ; i++) {
			for (j=0 ; j<nby ; j++) {
				fprintf (fd_output,"%d", image[indice2(i,j,nbx,nby)]);
				if (i!=nbx-1 || j!=nby-1) fprintf (fd_output," ");
			}
		}
		fprintf (fd_output,"\n");
		fflush (fd_output);
		return 1;
	}

	pladv (1);
	plvpor (x1, x2, y1, y2);
	plwind (0., nbx, 0, nby); // nbx et nby et non pas nbx-1 et nby-1

	plpsty (0);

	// Je ne comprends pas bien plimage et plimagefr, ca ne marche pas bien, j'en ai marre de cette me.de !

	for (i=0 ; i<nbx ; i++) {
		for (j1=0 ; j1<nby ; ) {
			couleur = image[indice2(i,j1,nbx,nby)];
			for (j2=j1 ; j2<nby ; j2++) {
				if (image[indice2(i,j2,nbx,nby)] == couleur) {
					//x[0] = i;		y[0] = j1;
					//x[1] = i;		y[1] = j2+1;
					//x[2] = i+1;		y[2] = j2+1;
					//x[3] = i+1;		y[3] = j1;
				} else {
					break;
				}
			}
			x[0] = i;		y[0] = j1;
			x[1] = i;		y[1] = j2;
			x[2] = i+1;		y[2] = j2;
			x[3] = i+1;		y[3] = j1;
			j1 = j2;
			plcol0 (couleur);
			plfill (4, x, y);
		}
	}

// Version plus lente
/*
	for (i=0 ; i<nbx ; i++) {
		for (j=0 ; j<nby ; j++) {
			couleur = image[indice2(i,j,nbx,nby)];
			x[0] = i;		y[0] = j;
			x[1] = i;		y[1] = j+1;
			x[2] = i+1;		y[2] = j+1;
			x[3] = i+1;		y[3] = j;
			plcol0 (couleur);
			plfill (4, x, y);
		}
	}
*/

	return 1;

}

/*---------------------------------------------------------------------------*/
int TV_AUTO_GLUE (
/*---------------------------------------------------------------------------*/
	void    *p01,
	void    *p02,
	void    *p03,
	void    *p04,
	void    *p05,
	void    *p06,
	void    *p07) {

	int	argc=7;
	void	*argv[7];

	argv[0] = p01;
	argv[1] = p02;
	argv[2] = p03;
	argv[3] = p04;
	argv[4] = p05;
	argv[5] = p06;
	argv[6] = p07;
	return TV (argc, argv);

}

/*---------------------------------------------------------------------------*/
int POLYFILL (int argc, void *argv[]) {
/*---------------------------------------------------------------------------*/
	double		*x		=	(double *)	argv[0];
	double		*y		=	(double *)	argv[1];
	int		nb		=	*(int *)	argv[2];
	int		color		=	*(int *)	argv[3];

	int		i;

	if (nom_output[0]) {
		fprintf (fd_output,"POLYFILL %d ", nb);
		for (i=0 ; i<nb ; i++) {
			fprintf (fd_output,"%.10e", x[i]);
			if (i!=nb-1) fprintf (fd_output," ");
		}
		fprintf (fd_output," ");
		for (i=0 ; i<nb ; i++) {
			fprintf (fd_output,"%.10e", y[i]);
			if (i!=nb-1) fprintf (fd_output," ");
		}
		fprintf (fd_output," %d\n",color);
		fflush (fd_output);
		return 1;
	}

	plvpor (0.0, 1.0, 0.0, 1.0);	// normalis
	plwind (0.0, 1.0, 0.0, 1.0);	// normalis
	plsdidev (0.0, 0.0, 0.0, 0.0);

	plcol0 (color);
	plpsty (0);
	plfill (nb-1, x, y);	// nb-1 car pas besoin de fermer le polygone avec plplot

	return 1;

}

/*---------------------------------------------------------------------------*/
int POLYFILL_AUTO_GLUE (
/*---------------------------------------------------------------------------*/
	void    *p01,
	void    *p02,
	void    *p03,
	void    *p04) {

	int	argc=4;
	void	*argv[4];

	argv[0] = p01;
	argv[1] = p02;
	argv[2] = p03;
	argv[3] = p04;
	return POLYFILL (argc, argv);

}

/*---------------------------------------------------------------------------*/
int CONTOUR (int argc, void *argv[]) {
/*---------------------------------------------------------------------------*/
	double		x1		=	*(double *)	argv[0];
	double		x2		=	*(double *)	argv[1];
	double		y1		=	*(double *)	argv[2];
	double		y2		=	*(double *)	argv[3];
	double		*image		=	(double *)	argv[4];
	int		nbx		=	*(int *)	argv[5];
	int		nby		=	*(int *)	argv[6];
	double		*levels		=	(double *)	argv[7];
	int		*colors		=	(int *)		argv[8];
	int		nb		=	*(int *)	argv[9];

	PLFLT		**z;
	PLcGrid2	cgrid2;
	PLFLT		clevel[1];
	PLINT		nlevel;
	
	int		i;
	int		j;

	if (nom_output[0]) {
		fprintf (fd_output,"CONTOUR %.10e %.10e %.10e %.10e %d %d ", x1, x2, y1, y2, nbx, nby);
		for (i=0 ; i<nbx ; i++) {
			for (j=0 ; j<nby ; j++) {
				fprintf (fd_output,"%.10e", image[indice2(i,j,nbx,nby)]);
				if (i!=nbx-1 || j!=nby-1) fprintf (fd_output," ");
			}
		}
		fprintf (fd_output," %d ",nb);
		for (i=0 ; i<nb ; i++) {
			fprintf (fd_output,"%.10e", levels[i]);
			if (i!=nb-1) fprintf (fd_output," ");
		}
		fprintf (fd_output," ");
		for (i=0 ; i<nb ; i++) {
			fprintf (fd_output,"%d", colors[i]);
			if (i!=nb-1) fprintf (fd_output," ");
		}
		fprintf (fd_output,"\n");
		fflush (fd_output);
		return 1;
	}

	pladv (1);
	plvpor (x1, x2, y1, y2);
	plwind (0, nbx, 0, nby);

	plAlloc2dGrid (&z, nbx, nby);

	plAlloc2dGrid (&cgrid2.xg, nbx, nby);
	plAlloc2dGrid (&cgrid2.yg, nbx, nby);
	cgrid2.nx = nbx;
	cgrid2.ny = nby;

	for (i = 0; i<nbx; i++) {
		for (j=0; j<nby; j++) {
			cgrid2.xg[i][j] = i;
			cgrid2.yg[i][j] = j;
			z[i][j] = image[indice2(i,j,nbx,nby)];
		}
        }

	for (i=0 ; i<nb ; i++) {
		clevel[0] = levels[i];
		nlevel = 1;
		plcol0 (colors[i]);
		plcont ((PLFLT_MATRIX) z, nbx, nby, 1, nbx, 1, nby, clevel, nlevel, pltr2, (void *) &cgrid2);
	}

	plFree2dGrid (z, nbx, nby);
	plFree2dGrid (cgrid2.xg, nbx, nby);
	plFree2dGrid (cgrid2.yg, nbx, nby);

	return 1;

}

/*---------------------------------------------------------------------------*/
int CONTOUR_AUTO_GLUE (
/*---------------------------------------------------------------------------*/
	void    *p01,
	void    *p02,
	void    *p03,
	void    *p04,
	void    *p05,
	void    *p06,
	void    *p07,
	void    *p08,
	void    *p09,
	void    *p10) {

	int	argc=10;
	void	*argv[10];

	argv[0] = p01;
	argv[1] = p02;
	argv[2] = p03;
	argv[3] = p04;
	argv[4] = p05;
	argv[5] = p06;
	argv[6] = p07;
	argv[7] = p08;
	argv[8] = p09;
	argv[9] = p10;
	return CONTOUR (argc, argv);

}

/*---------------------------------------------------------------------------*/
int SHADE_SURF (int argc, void *argv[]) {
/*---------------------------------------------------------------------------*/
	double		x1		=	*(double *)	argv[0];
	double		x2		=	*(double *)	argv[1];
	double		y1		=	*(double *)	argv[2];
	double		y2		=	*(double *)	argv[3];
	double		*image		=	(double *)	argv[4];
	int		nbx		=	*(int *)	argv[5];
	int		nby		=	*(int *)	argv[6];
	double		zmin		=	*(double *)	argv[7];
	double		zmax		=	*(double *)	argv[8];

	PLFLT		**zg;
	PLFLT		*xg;
	PLFLT		*yg;
//	PLFLT		clevel[10];
//	int		nlevel=10;
	int		i;
	int		j;

	if (nom_output[0]) {
		fprintf (fd_output,"SHADE_SURF %.10e %.10e %.10e %.10e %d %d ", x1, x2, y1, y2, nbx, nby);
		for (i=0 ; i<nbx ; i++) {
			for (j=0 ; j<nby ; j++) {
				fprintf (fd_output,"%.10e", image[indice2(i,j,nbx,nby)]);
				if (i!=nbx-1 || j!=nby-1) fprintf (fd_output," ");
			}
		}
		fprintf (fd_output," %.10e %.10e\n", zmin, zmax);
		fflush (fd_output);
		return 1;
	}

	pladv (1);
	plvpor (x1, x2, y1, y2);
	plwind (-1.0, 1.0, -1.0, 1.5);
	plw3d (1, 1, 1, 0, nbx, 0, nby, zmin, zmax, 75, 24);

	plcol0 (1);
	plAlloc2dGrid (&zg, nbx, nby);
	xg = (PLFLT *) malloc (nbx * sizeof(PLFLT));
	yg = (PLFLT *) malloc (nby * sizeof(PLFLT));

	for (i=0 ; i<nbx ; i++) {
		xg[i] = i + 0*0.5;
	}
	for (j=0 ; j<nby ; j++) {
		yg[j] = j + 0*0.5;
	}

	for (i = 0; i<nbx; i++) {
		for (j=0; j<nby; j++) {
			zg[i][j] = image[indice2(i,j,nbx,nby)];
		}
        }

//	for (i=0; i < nlevel; i++) {
//		clevel[i] = zmin + (i + 0.5) * (zmax - zmin) / nlevel;
//	}


	plot3d (xg, yg, (PLFLT_MATRIX) zg, nbx, nby, 3 | MAG_COLOR, 1);
	//plmeshc (xg, yg, (PLFLT_MATRIX) zg, nbx, nby, 3 | MAG_COLOR | BASE_CONT, clevel, nlevel);

	plFree2dGrid (zg, nbx, nby);
	free (xg);
	free (yg);

	return 1;

}

/*---------------------------------------------------------------------------*/
int SHADE_SURF_AUTO_GLUE (
/*---------------------------------------------------------------------------*/
	void    *p01,
	void    *p02,
	void    *p03,
	void    *p04,
	void    *p05,
	void    *p06,
	void    *p07,
	void    *p08,
	void    *p09) {

	int	argc=9;
	void	*argv[9];

	argv[0] = p01;
	argv[1] = p02;
	argv[2] = p03;
	argv[3] = p04;
	argv[4] = p05;
	argv[5] = p06;
	argv[6] = p07;
	argv[7] = p08;
	argv[8] = p09;
	return SHADE_SURF (argc, argv);

}

/*---------------------------------------------------------------------------*/
int GET_CURSOR (int argc, void *argv[]) {
/*---------------------------------------------------------------------------*/
	int		*keysym		=	(int *)	argv[0];
	int		*button		=	(int *)	argv[1];

	PLGraphicsIn	gin;


	for ( ; ; ) {

		if (plGetCursor (&gin)) {
			printf ("state=%u keysym=%u button=%u subwindow=%d string=%s pX=%d pY=%d dX=%f dY=%f wX=%f wY=%f\n",
					gin.state, gin.keysym, gin.button, gin.subwindow, gin.string, gin.pX, gin.pY, gin.dX, gin.dY, gin.wX, gin.wY);
			if (gin.keysym != 32) {
				*keysym = gin.keysym;
				*button = gin.button;
				break;
			}
		}

	}

	return 1;

}

/*---------------------------------------------------------------------------*/
int GET_CURSOR_AUTO_GLUE (
/*---------------------------------------------------------------------------*/
	void    *p01,
	void    *p02) {

	int	argc=2;
	void	*argv[2];

	argv[0] = p01;
	argv[1] = p02;
	return GET_CURSOR (argc, argv);

}

/*---------------------------------------------------------------------------*/
int REALISER_PLPLOT (char *fichier) {
/*---------------------------------------------------------------------------*/

	char		fonction[1024];
	char		device[1024];
	char		filename[1024];
	char		str[1024];
	char		xtitle[1024];
	int		*r;
	int		*v;
	int		*b;
	double		*xsym=NULL;
	double		*ysym=NULL;
	double		*ytickv=NULL;
	unsigned char	*image1;
	double		*image2;
	double		*levels;
	int		*colors;

	FILE		*fd;
	int		len;
	int		x_vsize;
	int		y_vsize;
	int		nb;
	int		i;
	int		j;
	double		x;
	double		y;
	char		car;
	double		alignment;
	double		charsize;
	double		orientation;
	int		couleur;
	double		charthick;
	int		xlog;
	int		ylog;
	double		*tabx;
	double		*taby;
	double		xmin, xmax, ymin, ymax;
	double		x1, x2, y1, y2;
	int		xstyle, ystyle;
	int		color, linestyle;
	int		nodata;
	double		xticklen, yticklen;
	int		psym;
	double		symsize;
	int		nbsym;
	double		thick;
	int		xvalues, yvalues;
	int		nbytickv;
	int		axis;
	int		nbx;
	int		nby;
	double		zmin;
	double		zmax;

	fd = fopen (fichier, "r");
	if (fd==NULL) {
		return 0;
	}

	for ( ; ; ) {

		if (feof (fd)) break;

		if (fscanf (fd, "%s", fonction) < 0) break;

		if (strcmp(fonction,"SET_PLOT")==0) {

			#ifdef DEBUG
			printf ("REALISER SET_PLOT\n");
			#endif

			fscanf (fd, "%d", &len);
			fscanf (fd, "%c", &car);
			for (i=0 ; i<len ; i++) {
				fscanf (fd, "%c", &device[i]);
			}
			device[i] = 0;
			fscanf (fd, "%d", &len);
			fscanf (fd, "%c", &car);
			for (i=0 ; i<len ; i++) {
				fscanf (fd, "%c", &filename[i]);
			}
			filename[i] = 0;
			fscanf (fd, "%d", &x_vsize);
			fscanf (fd, "%d", &y_vsize);
			#ifdef DEBUG
			printf ("  device=%s filename=%s x_vsize=%d y_vsize=%d\n", device, filename, x_vsize, y_vsize);
			#endif
			printf ("realiser %s -> %s\n", fichier, filename);
			SET_PLOT_AUTO_GLUE (&device,&filename,&x_vsize,&y_vsize);

		} else if (strcmp(fonction,"END")==0) {

			#ifdef DEBUG
			printf ("REALISER END\n");
			#endif

			END_AUTO_GLUE ();

		} else if (strcmp(fonction,"ERASE")==0) {

			#ifdef DEBUG
			printf ("REALISER ERASE\n");
			#endif

			ERASE_AUTO_GLUE ();

		} else if (strcmp(fonction,"PLOT")==0) {

			#ifdef DEBUG
			printf ("REALISER PLOT\n");
			#endif

			fscanf (fd, "%d %d %d", &xlog, &ylog, &nb);
			tabx = (double *) malloc (nb * sizeof(double));
			taby = (double *) malloc (nb * sizeof(double));
			for (i=0 ; i<nb ; i++) fscanf (fd, "%lf", &tabx[i]);
			for (i=0 ; i<nb ; i++) fscanf (fd, "%lf", &taby[i]);
			fscanf (fd," %lf %lf %lf %lf %lf %lf %lf %lf %d %d %d ",&xmin,&xmax,&ymin,&ymax,&x1,&x2,&y1,&y2,&xstyle,&ystyle,&color);
			fscanf (fd,"%d %d %lf %lf %lf %d", &linestyle, &nodata, &xticklen, &yticklen, &charsize, &psym);
			fscanf (fd,"%lf ", &symsize);
			fscanf (fd, "%d ", &nbsym);
			if (nbsym) {
				xsym = (double *) malloc (nbsym * sizeof(double));
				ysym = (double *) malloc (nbsym * sizeof(double));
				for (i=0 ; i<nbsym ; i++) fscanf (fd,"%lf",&xsym[i]);
				for (i=0 ; i<nbsym ; i++) fscanf (fd,"%lf",&ysym[i]);
			}
			fscanf (fd," %lf %lf %d %d %d", &thick, &charthick, &xvalues, &yvalues, &nbytickv);
			if (nbytickv) {
				ytickv = (double *) malloc (nbytickv * sizeof(double));
				for (i=0 ; i<nbytickv ; i++) fscanf (fd,"%lf",&ytickv[i]);
			}

			#ifdef DEBUG
			printf ("  xlog=%d ylog=%d nb=%d\n", xlog, ylog, nb);
			for (i=0 ; i<nb ; i++) printf ("  tabx[%d]=%f\n",i,tabx[i]);
			for (i=0 ; i<nb ; i++) printf ("  taby[%d]=%f\n",i,taby[i]);
			printf ("  xmin=%f xmax=%f ymin=%f ymax=%f x1=%f x2=%f y1=%f y2=%f xstyle=%d ystyle=%d color=%d\n",xmin,xmax,ymin,ymax,x1,x2,y1,y2,xstyle,ystyle,color);
			printf ("  linestyle=%d nodata=%d xticklen=%f yticklen=%f len=%d\n", linestyle, nodata, xticklen, yticklen, len);
			printf ("  charsize=%f psym=%d\n", charsize, psym);
			printf ("  symsize=%f\n",symsize);
			printf ("  nbsym=%d\n", nbsym);
			if (nbsym) {
				for (i=0 ; i<nbsym ; i++) printf ("  xsym[%d]=%f\n",i,xsym[i]);
				for (i=0 ; i<nbsym ; i++) printf ("  ysym[%d]=%f\n",i,ysym[i]);
			}
			printf ("  thick=%f charthick=%f xvalues=%d yvalues=%d nbytickv=%d\n", thick, charthick, xvalues, yvalues, nbytickv);
			#endif

			PLOT_AUTO_GLUE (&xlog, &ylog, tabx, taby, &nb, &xmin, &xmax, &ymin, &ymax, &x1, &x2, &y1, &y2,
				&xstyle, &ystyle, &color, &linestyle, &nodata, &xticklen, &yticklen, &charsize, &psym, &symsize,
				xsym, ysym, &nbsym, &thick, &charthick, &xvalues, &yvalues, ytickv, &nbytickv);

			free (tabx);
			free (taby);
			if (nbsym) {
				free (xsym);
				free (ysym);
			}
			if (nbytickv) free (ytickv);

		} else if (strcmp(fonction,"AXIS")==0) {

			#ifdef DEBUG
			printf ("REALISER AXIS\n");
			#endif

			fscanf (fd,"%d %d %d", &axis,&xlog,&ylog);
			fscanf (fd,"%lf %lf %lf %lf %lf %lf %lf %lf %d",&xmin,&xmax,&ymin,&ymax,&x1,&x2,&y1,&y2,&color);
			fscanf (fd,"%lf %lf %lf %lf\n", &xticklen, &yticklen, &charsize, &charthick);

			AXIS_AUTO_GLUE (&axis, &xlog, &ylog, &xmin, &xmax, &ymin, &ymax, &x1, &x2, &y1, &y2,
				&color, &xticklen, &yticklen, &charsize, &charthick);


		} else if (strcmp(fonction,"XYOUTS")==0) {

			#ifdef DEBUG
			printf ("REALISER XYOUT\n");
			#endif

			fscanf (fd, "%lf %lf %d", &x, &y, &len);
			fscanf (fd, "%c", &car);
			for (i=0 ; i<len ; i++) fscanf (fd, "%c", &str[i]);
			str[i] = 0;
			fscanf (fd, "%lf %lf %lf %d %lf\n", &alignment, &charsize, &orientation, &couleur, &charthick);

			#ifdef DEBUG
			printf ("  x=%f y=%f str=%s alignment=%f charsize=%f orientation=%f couleur=%d charthick=%f\n", x,y,str,alignment,charsize,orientation,couleur,charthick);
			#endif

			XYOUTS_AUTO_GLUE (&x, &y, &str, &alignment, &charsize, &orientation, &couleur, &charthick);

		} else if (strcmp(fonction,"TVLCT")==0) {

			#ifdef DEBUG
			printf ("REALISER TVLCT\n");
			#endif

			fscanf (fd, "%d", &nb);
			r = (int *) malloc (nb * sizeof(int));
			v = (int *) malloc (nb * sizeof(int));
			b = (int *) malloc (nb * sizeof(int));
			for (i=0 ; i<nb ; i++) fscanf (fd, "%d", &r[i]);
			for (i=0 ; i<nb ; i++) fscanf (fd, "%d", &v[i]);
			for (i=0 ; i<nb ; i++) fscanf (fd, "%d", &b[i]);
			#ifdef DEBUG
			printf ("  nb=%d r=",nb);
			for (i=0 ; i<nb ; i++) printf ("%d ",r[i]);
			for (i=0 ; i<nb ; i++) printf ("%d ",v[i]);
			for (i=0 ; i<nb ; i++) printf ("%d ",b[i]);
			printf ("\n");
			#endif

			TVLCT_AUTO_GLUE (r,v,b,&nb);
			free (r);
			free (v);
			free (b);

		} else if (strcmp(fonction,"TV")==0) {

			#ifdef DEBUG
			printf ("REALISER TV\n");
			#endif

			fscanf (fd,"%lf %lf %lf %lf %d %d ", &x1,&x2,&y1,&y2,&nbx,&nby);
			image1 = (unsigned char *) malloc (nbx * nby * sizeof(unsigned char));
			for (i=0 ; i<nbx ; i++) {
				for (j=0 ; j<nby ; j++) {
					fscanf (fd,"%hhd",&image1[indice2(i,j,nbx,nby)]);
				}
			}
			TV_AUTO_GLUE (&x1, &x2, &y1, &y2, image1, &nbx, &nby);

			free (image1);

		} else if (strcmp(fonction,"POLYFILL")==0) {

			#ifdef DEBUG
			printf ("REALISER POLYFILL\n");
			#endif

			fscanf (fd,"%d ", &nb);
			tabx = (double *) malloc (nb *sizeof(double));
			taby = (double *) malloc (nb *sizeof(double));
			for (i=0 ; i<nb ; i++) fscanf (fd,"%lf", &tabx[i]);
			for (i=0 ; i<nb ; i++) fscanf (fd,"%lf", &taby[i]);
			fscanf (fd," %d", &color);
			POLYFILL_AUTO_GLUE (tabx, taby, &nb, &color);

			free (tabx);
			free (taby);

		} else if (strcmp(fonction,"CONTOUR")==0) {

			#ifdef DEBUG
			printf ("REALISER CONTOUR\n");
			#endif

			fscanf (fd,"%lf %lf %lf %lf %d %d ", &x1, &x2, &y1, &y2, &nbx, &nby);
			image2 = (double *) malloc (nbx * nby * sizeof(double));
			for (i=0 ; i<nbx ; i++) {
				for (j=0 ; j<nby ; j++) {
					fscanf (fd,"%lf", &image2[indice2(i,j,nbx,nby)]);
				}
			}
			fscanf (fd,"%d ", &nb);
			levels = (double *) malloc (nb * sizeof(double));
			colors = (int *) malloc (nb * sizeof(int));
			for (i=0 ; i<nb ; i++) {
				fscanf (fd,"%lf",&levels[i]);
			}
			for (i=0 ; i<nb ; i++) {
				fscanf (fd,"%d",&colors[i]);
			}

			CONTOUR_AUTO_GLUE (&x1, &x2, &y1, &y2, image2, &nbx, &nby, levels, colors, &nb);

			free (image2);
			free (levels);
			free (colors);

		} else if (strcmp(fonction,"SHADE_SURF")==0) {

			#ifdef DEBUG
			printf ("REALISER SHADE_SURF\n");
			#endif

			fscanf (fd,"%lf %lf %lf %lf %d %d ",&x1,&x2,&y1,&y2,&nbx,&nby);
			image2 = (double *) malloc (nbx * nby * sizeof(double));
			for (i=0 ; i<nbx ; i++) {
				for (j=0 ; j<nby ; j++) {
					fscanf (fd,"%lf",&image2[indice2(i,j,nbx,nby)]);
				}
			}
			fscanf (fd,"%lf %lf\n",&zmin,&zmax);
			SHADE_SURF_AUTO_GLUE (&x1, &x2, &y1, &y2, image2, &nbx, &nby, &zmin, &zmax);

			free (image2);

		}

	}

	fclose(fd);

	return 1;

}

