/*------------------------------------------------------------------------------
 *
 *	Fichier	: $RCSfile: maglibc.c,v $, v $Revision: 1.6 $
 *
 *	Date	: $Date: 2021/04/27 09:48:59 $
 *
 *	Auteur	: $Author: penou $
 *
 *	Version : %Z% version %I% de %M% du %G%
 *
 *------------------------------------------------------------------------------
 */

#define indice2(i1,i2,nb1,nb2)	((i1)+(nb1)*(i2))

extern void valfix_ ();
extern void inigeo1_ ();
extern void segeo_ ();
extern void geogsm_ ();

/*---------------------------------------------------------------------------*/
int GSE_TO_GSM (int argc, void *argv[]) {
/*---------------------------------------------------------------------------*/

	float	FILLVAL		= *(float *)	argv[ 0];
	int	nb		= *(int *)	argv[ 1];
	int	*ann		= (int *)	argv[ 2]; /* ann[nb] */
	int	*moi		= (int *)	argv[ 3]; /* moi[nb] */
	int	*jou		= (int *)	argv[ 4]; /* jou[nb] */
	int	*heu		= (int *)	argv[ 5]; /* heu[nb] */
	int	*min		= (int *)	argv[ 6]; /* min[nb] */
	int	*sec		= (int *)	argv[ 7]; /* sec[nb] */
	int	nbvecteurs	= *(int *)	argv[ 8];
	float	*xgse		= (float *)	argv[ 9]; /* xgse[nb,nbvecterurs] */
	float	*ygse		= (float *)	argv[10]; /* ygse[nb,nbvecterurs] */
	float	*zgse		= (float *)	argv[11]; /* zgse[nb,nbvecterurs] */
	float	*xgsm		= (float *)	argv[12]; /* xgsm[nb,nbvecterurs] */
	float	*ygsm		= (float *)	argv[13]; /* ygsm[nb,nbvecterurs] */
	float	*zgsm		= (float *)	argv[14]; /* zgsm[nb,nbvecterurs] */

	int	i,j,ifail;
	double	year,djulc,alfag,tetdip,phidip,alfas,deltas,obliq;
	double	rig[3][3],rgi[3][3],rgdip[3][3],rdipg[3][3],rgsm[3][3],rsmg[3][3];
	double	tilt;
	double	rggsm[3][3],rgsmg[3][3],rsmgsm[3][3],rgsmsm[3][3],rgse[3][3],rseg[3][3],rigsm[3][3],rgsmi[3][3];
	double	xgse1,ygse1,zgse1,xgeo,ygeo,zgeo,xgsm1,ygsm1,zgsm1;

	valfix_ (&ifail);
	if (ifail) return -1;

	for (i=0 ; i<nb ; i++) {

		if (ifail==0) inigeo1_ (&ann[i],&moi[i],&jou[i],&heu[i],&min[i],&sec[i],
						&year,&djulc,&alfag,&tetdip,&phidip,&alfas,&deltas,&obliq,
						rig,rgi,rgdip,rdipg,rgsm,rsmg,
						&tilt,
						rggsm,rgsmg,rsmgsm,rgsmsm,rgse,rseg,rigsm,rgsmi,
						&ifail);
		if (ifail) return -1;

		for (j=0 ; j<nbvecteurs; j++) {

			/* Passage de float en double */
			xgse1 = xgse[indice2(i,j,nb,nbvecteurs)]; 
			ygse1 = ygse[indice2(i,j,nb,nbvecteurs)]; 
			zgse1 = zgse[indice2(i,j,nb,nbvecteurs)]; 

			if (xgse1 != FILLVAL && ygse1 != FILLVAL && zgse1 != FILLVAL) /* Pas de calcul si FILLVAL */ {

				/* Passage de gse en geo */
				segeo_ (rseg,&xgse1,&ygse1,&zgse1,&xgeo,&ygeo,&zgeo,&ifail);
				if (ifail) return -1;

				/* Passage de geo en gsm */
				geogsm_ (rggsm,&xgeo,&ygeo,&zgeo,&xgsm1,&ygsm1,&zgsm1,&ifail);
				if (ifail) return -1;

				/* Passage de double en float */
				xgsm[indice2(i,j,nb,nbvecteurs)] = xgsm1;
				ygsm[indice2(i,j,nb,nbvecteurs)] = ygsm1;
				zgsm[indice2(i,j,nb,nbvecteurs)] = zgsm1;

			}
		}
	}

	return 0;

}

/*---------------------------------------------------------------------------*/
int GSE_TO_GSM_AUTO_GLUE (
/*---------------------------------------------------------------------------*/
	void	*p01,
	void	*p02,
	void	*p03,
	void	*p04,
	void	*p05,
	void	*p06,
	void	*p07,
	void	*p08,
	void	*p09,
	void	*p10,
	void	*p11,
	void	*p12,
	void	*p13,
	void	*p14,
	void	*p15) {

	int	argc=15;
	void	*argv[15];

	argv[ 0] = p01;
	argv[ 1] = p02;
	argv[ 2] = p03;
	argv[ 3] = p04;
	argv[ 4] = p05;
	argv[ 5] = p06;
	argv[ 6] = p07;
	argv[ 7] = p08;
	argv[ 8] = p09;
	argv[ 9] = p10;
	argv[10] = p11;
	argv[11] = p12;
	argv[12] = p13;
	argv[13] = p14;
	argv[14] = p15;
	return GSE_TO_GSM (argc, argv);

}


