/* sun.f -- translated by f2c (version 19991025).
   You must link the resulting object file with the libraries:
	-lf2c -lm   (in that order)
*/

#include "f2c.h"

/* Common Block Declarations */

struct {
    doublereal pi, dpi, rad, deg, pid, xmu, rayt;
} util_;

#define util_1 util_

/* Table of constant values */

static doublereal c_b2 = 360.;

/* Subroutine */ int sun_(iyear, iday, fday, gst, alfas, deltas, obliq, ier)
integer *iyear, *iday;
doublereal *fday, *gst, *alfas, *deltas, *obliq;
integer *ier;
{

    /* System generated locals */
    doublereal d__1;

    /* Builtin functions */
    double d_mod(), sin(), sqrt(), atan(), tan(), cos(), atan2();

    /* Local variables */
    static doublereal cosd, sind, gstd, g, t;
    static integer ibiss;
    static doublereal slong, gd, dj, vl, slp, arg1, arg2;

/* * */
/* *********************************************************************** */
/* * */
/* *          "Copyright [c] CNES 98 - tous droits reserves" */
/* *          ********************************************** */
/* * */
/* *PRO MAGLIB */
/* * */
/* *VER 99.03.31 - V 1.0 */
/* *VER 01.06.05 - V 2.0 */
/* *VER 03.01.06 - V 2.1 */
/* * */
/* *AUT spec. CNES - JC KOSIK - janvier 1991 */
/* *AUT port. CISI */
/* * */
/* *ROL Theme : Astronomie et calculs d'orbite */
/* *ROL         Calcul du temps sideral et de la position du soleil */
/* *ROL         pour des annees comprises entre 1901 et 2099 avec */
/* *ROL         une precision de 0.006 degres. */
/* * */
/* *PAR iyear  (I) : annee (doit appartenir a 1901, 2099) */
/* * */
/* *PAR iday   (I) : numero du jour dans l'annee */
/* *PAR fday   (I) : secondes dans le jour */
/* * */
/* *PAR gst    (O) : temps sideral moyen de Greenwich (radians) */
/* * */
/* *PAR alfas  (O) : ascension droite du soleil (radians) */
/* *PAR deltas (O) : declinaison du soleil (radians) */
/* * */
/* *PAR obliq  (O) : obliquite de l'ecliptique (radians) */
/* * */
/* *PAR ier    (O) : code de retour */
/* * */
/* *NOT ier        : sans objet */
/* * */
/* *NOT common     : util */
/* * */
/* *INF utilise    : sans objet */
/* * */
/* *HST version 1.0 - 99.03.31 - creation de la maglib au CDPP */
/* *HST version 2.0 - 01.06.05 - correction de commentaires de code */
/* *HST version 2.1 - 03.01.06 - corrections en compilation avec g77 */
/* * */
/* *********************************************************************** */
/* * */

/*     --------------------------------- */
/* *FON Declaration identificateur rcs_id */
/*     --------------------------------- */


/*     -------------------------- */
/* *FON Declaration des parametres */
/*     -------------------------- */


/*     ---------------------------------- */
/* *FON Declaration des variables communes */
/*     ---------------------------------- */


/* *COM pi   : constante pi (obtenue a partir de acos(-1.)) */
/* *COM dpi  : constante 2 * pi */
/* *COM pid  : constante pi / 2 */
/* *COM rad  : facteur de conversion degres  ----> radians */
/* *COM deg  : facteur de conversion radians ----> degres */
/* *COM xmu  : constante de gravitation terrestre (km**3/sec**2) */
/* *COM rayt : rayon equatorial terrestre (km) */


/*     --------------------------------- */
/* *FON Declaration des variables locales */
/*     --------------------------------- */


/* *LOC Variables de travail intermediaires */


/*     --------------------------------- */
/* *FON Affectation identificateur rcs_id */
/*     --------------------------------- */


/*     ****************** */
/*     Debut de programme */
/*     ****************** */

    *ier = 0;

/*     ----------------------------------------------------- */
/* *FON Calcul de la date tenant compte des annees bisextiles */
/*     ----------------------------------------------------- */

    ibiss = (*iyear - 1901) / 4;
    dj = (doublereal) (*iyear - 1900) * 365. + (doublereal) ibiss + (
	    doublereal) (*iday) + *fday - .5;
    t = dj / 36525.;

/*     ------------------------------------------ */
/* *FON Calcul du temps sideral moyen de Greenwich */
/*     ------------------------------------------ */

    d__1 = dj * .9856473354 + 279.696678;
    vl = d_mod(&d__1, &c_b2);
    d__1 = dj * .9856473354 + 279.690983 + *fday * 360. + 180.;
    gstd = d_mod(&d__1, &c_b2);
    *gst = gstd * util_1.rad;

/*     ----------------------------------------------- */
/* *FON Calculs intermediaires pour obtenir l'ascension */
/* *FON et la declinaison du soleil */
/*     ----------------------------------------------- */

    d__1 = dj * .985600267 + 358.475845;
    gd = d_mod(&d__1, &c_b2);
    g = gd * util_1.rad;
    slong = vl + (1.91946 - t * .004789) * sin(g) + sin(g * 2.) * .020094;
    *obliq = (23.45229 - t * .0130125) * util_1.rad;
    slp = (slong - .005686) * util_1.rad;
    sind = sin(*obliq) * sin(slp);
/* Computing 2nd power */
    d__1 = sind;
    cosd = sqrt(1. - d__1 * d__1);

/*     ------------------------------------------------- */
/* *FON Calcul de l'ascension droite et de la declinaison */
/* *FON du soleil en radians */
/*     ------------------------------------------------- */

    *deltas = atan(sind / cosd);
    arg1 = sind / cosd / tan(*obliq);
    arg2 = -cos(slp) / cosd;
    *alfas = util_1.pi - atan2(arg1, arg2);

/*     **************** */
/*     Fin de programme */
/*     **************** */

    return 0;
} /* sun_ */

