/* solter00.f -- translated by f2c (version 19991025).
   You must link the resulting object file with the libraries:
	-lf2c -lm   (in that order)
*/

#include "f2c.h"

/* Table of constant values */

static integer c__1 = 1;

/* Subroutine */ int solter00_(iyear, imonth, iday, ihour, imin, isec, year, 
	alfag, alfas, deltas, obliq, tetdip, phidip, ier)
integer *iyear, *imonth, *iday, *ihour, *imin, *isec;
doublereal *year, *alfag, *alfas, *deltas, *obliq, *tetdip, *phidip;
integer *ier;
{

    /* System generated locals */
    doublereal d__1, d__2, d__3;

    /* Builtin functions */
    double sqrt(), atan(), asin();

    /* Local variables */
    static integer julc;
    extern integer julg_();
    static doublereal fjour, c11, g10, g11, h11, dt;
    static integer nujour;
    static doublereal gdt;
    extern /* Subroutine */ int sun_();
    static integer jul1;

/* * */
/* *********************************************************************** */
/* * */
/* *          "Copyright [c] CNES 98 - tous droits reserves" */
/* *          ********************************************** */
/* * */
/* *PRO MAGLIB */
/* * */
/* *VER 99.03.31 - V 1.0 */
/* *VER 01.06.05 - V 2.0 */
/* *VER 03.01.06 - V 2.1 */
/* *VER 01.01.07 - V 3.0 */
/* *VER 13.10.10 - V 4.0 */
/* * */
/* *AUT spec. CNES - JC KOSIK - janvier 1991 */
/* *AUT port. CISI */
/* * */
/* *ROL Theme : Astronomie et calculs d'orbite */
/* *ROL         Calcul de l'ascension droite de Greenwich. */
/* *ROL         Calcul de l'ascension droite et de la declinaison */
/* *ROL         du soleil. */
/* *ROL         Calcul de la position geographique du point ou le dipole */
/* *ROL         coupe l'hemisphere nord. */
/* * */
/* *PAR iyear  (I) : annee de la date (annee >= 2000 et < 2005) */
/* *PAR imonth (I) : mois de la date */
/* *PAR iday   (I) : jour de la date */
/* *PAR ihour  (I) : heures de la date */
/* *PAR imin   (I) : minutes de la date */
/* *PAR isec   (I) : secondes de la date */
/* * */
/* *PAR year   (O) : annee fractionnaire (>= 2000. et < 2005.) */
/* * */
/* *PAR alfag  (O) : ascension droite de Greenwich (radians) */
/* * */
/* *PAR alfas  (O) : ascension droite du soleil (radians) */
/* *PAR deltas (O) : declinaison du soleil (radians) */
/* * */
/* *PAR obliq  (O) : obliquite de l'ecliptique (radians) */
/* * */
/* *PAR tetdip (O) : colatitude geocentrique du point ou le dipole */
/* *PAR            : coupe l'hemisphere nord (radians) */
/* *PAR phidip (O) : longitude geocentrique du point ou le dipole */
/* *PAR            : coupe l'hemisphere nord (radians) */
/* * */
/* *PAR ier    (O) : code de retour */
/* * */
/* *NOT ier        : sans objet */
/* * */
/* *INF utilise    : julg, sun */
/* * */
/* *HST version 1.0 - 99.03.31 - creation de la maglib au CDPP */
/* *HST version 2.0 - 01.06.05 - correction de commentaires de code */
/* *HST version 2.1 - 03.01.06 - corrections en compilation avec g77 */
/* *HST version 3.0 - 01.01.07 - utilisation du champ igrf 2000 */
/* *HST version 4.0 - 13.10.10 - utilisation du champ dgrf00 (annee */
/* *HST                          fractionnaire entre 2000 et 2005) */
/* *HST                          solter.f devient solter00.f */
/* * */
/* *********************************************************************** */
/* * */

/*     --------------------------------- */
/* *FON Declaration identificateur rcs_id */
/*     --------------------------------- */


/*     -------------------------- */
/* *FON Declaration des parametres */
/*     -------------------------- */


/*     ---------------------------------- */
/* *FON Declaration des fonctions externes */
/*     ---------------------------------- */


/*     --------------------------------- */
/* *FON Declaration des variables locales */
/*     --------------------------------- */


/* *LOC Variables de travail intermediaires */


/*     --------------------------------- */
/* *FON Affectation identificateur rcs_id */
/*     --------------------------------- */


/*     ****************** */
/*     Debut de programme */
/*     ****************** */

    *ier = 0;

/*     ----------------------------- */
/* *FON Calcul de la date en secondes */
/*     ----------------------------- */

    fjour = (doublereal) ((*ihour * 60 + *imin) * 60 + *isec) / 86400.;

/*     -------------------------------- */
/* *FON Calcul du jour julien  CNES 1950 */
/*     -------------------------------- */

    julc = julg_(iday, imonth, iyear, ier);

    jul1 = julg_(&c__1, &c__1, iyear, ier);

/*     ---------------------------------------------------------- */
/* *FON Calcul du numero du jour compte a partir du 1er janvier de */
/* *FON l'annee courante */
/*     ---------------------------------------------------------- */

    nujour = julc - jul1 + 1;

/*     ----------------------------------------------------------- */
/* *FON Calcul de la position du soleil dans le repere equatorial a */
/* *FON gamma 50 */
/*     ----------------------------------------------------------- */

    sun_(iyear, &nujour, &fjour, alfag, alfas, deltas, obliq, ier);

    *year = (doublereal) (*iyear) + (doublereal) (nujour - 1) / 365.;

/*     ------------------------------------------------------------- */
/* *FON Calculs intermediaires pour obtenir les coordonnees du dipole */
/*     ------------------------------------------------------------- */

    dt = *year - 2e3;
    g10 = 29619.4 - dt * 12.954;
    g11 = 1728.2 - dt * 11.83;
    h11 = dt * 21.622 - 5186.1;

/* Computing 2nd power */
    d__1 = g11;
/* Computing 2nd power */
    d__2 = h11;
    c11 = sqrt(d__1 * d__1 + d__2 * d__2);
/* Computing 2nd power */
    d__1 = g11;
/* Computing 2nd power */
    d__2 = h11;
/* Computing 2nd power */
    d__3 = g10;
    gdt = sqrt(d__1 * d__1 + d__2 * d__2 + d__3 * d__3);

/*     --------------------------------------------------------------- */
/* *FON Calcul de la longitude et de la colatitude du dipole en radians */
/*     --------------------------------------------------------------- */

    *phidip = atan(h11 / g11);
    *tetdip = asin(c11 / gdt);

/*     **************** */
/*     Fin de programme */
/*     **************** */

    return 0;
} /* solter00_ */

