/* roise.f -- translated by f2c (version 19991025).
   You must link the resulting object file with the libraries:
	-lf2c -lm   (in that order)
*/

#include "f2c.h"

/* Subroutine */ int roise_(alfas, deltas, obliq, rise, rsei, ier)
doublereal *alfas, *deltas, *obliq, *rise, *rsei;
integer *ier;
{

    /* Builtin functions */
    double sin(), cos();

    /* Local variables */
    static integer i__, j;
    static doublereal cl, sl, cobliq, sobliq;

/* * */
/* *********************************************************************** */
/* * */
/* *          "Copyright [c] CNES 98 - tous droits reserves" */
/* *          ********************************************** */
/* * */
/* *PRO MAGLIB */
/* * */
/* *VER 99.03.31 - V 1.0 */
/* *VER 01.06.05 - V 2.0 */
/* *VER 03.01.06 - V 2.1 */
/* * */
/* *AUT spec. CNES - JC KOSIK - juin 1995 */
/* *AUT port. CISI */
/* * */
/* *ROL Theme : Changements de repere */
/* *ROL         Calcul de la matrice de passage du repere inertiel */
/* *ROL         au repere solaire ecliptique et de la matrice inverse. */
/* * */
/* *PAR alfas  (I) : ascension droite du soleil (radians) */
/* *PAR deltas (I) : declinaison du soleil (radians) */
/* *PAR obliq  (I) : obliquite de l'ecliptique (radians) */
/* * */
/* *PAR rise   (O) : matrice (3,3) de passage du repere inertiel */
/* *PAR            : au repere solaire ecliptique */
/* *PAR rsei   (O) : matrice (3,3) de passage du repere solaire */
/* *PAR            : ecliptique au repere inertiel */
/* * */
/* *PAR ier    (O) : code de retour */
/* * */
/* *NOT ier        : sans objet */
/* * */
/* *INF utilise    : sans objet */
/* * */
/* *HST version 1.0 - 99.03.31 - creation de la maglib au CDPP */
/* *HST version 2.0 - 01.06.05 - correction de commentaires de code */
/* *HST version 2.1 - 03.01.06 - corrections en compilation avec g77 */
/* * */
/* *********************************************************************** */
/* * */

/*     --------------------------------- */
/* *FON Declaration identificateur rcs_id */
/*     --------------------------------- */


/*     -------------------------- */
/* *FON Declaration des parametres */
/*     -------------------------- */


/*     --------------------------------- */
/* *FON Declaration des variables locales */
/*     --------------------------------- */

/* *LOC i,j : indices de boucles */

/* *LOC Variables de travail intermediaires */


/*     --------------------------------- */
/* *FON Affectation identificateur rcs_id */
/*     --------------------------------- */

    /* Parameter adjustments */
    rsei -= 4;
    rise -= 4;

    /* Function Body */

/*     ****************** */
/*     Debut de programme */
/*     ****************** */

    *ier = 0;

    sobliq = sin(*obliq);
    cobliq = cos(*obliq);

    sl = sin(*deltas) / sobliq;
    cl = cos(*alfas) * cos(*deltas);

/*     ------------------------- */
/* *FON Calcul de la matrice rise */
/*     ------------------------- */

    rise[4] = cl;
    rise[7] = cobliq * sl;
    rise[10] = sobliq * sl;
    rise[5] = -sl;
    rise[8] = cobliq * cl;
    rise[11] = sobliq * cl;
    rise[6] = 0.;
    rise[9] = -sobliq;
    rise[12] = cobliq;

/*     ------------------------------- */
/* *FON Calcul de la matrice transposee */
/*     ------------------------------- */

    for (i__ = 1; i__ <= 3; ++i__) {
	for (j = 1; j <= 3; ++j) {
	    rsei[i__ + j * 3] = rise[j + i__ * 3];
/* L20: */
	}
/* L10: */
    }

/*     **************** */
/*     Fin de programme */
/*     **************** */

    return 0;
} /* roise_ */

