/* rogsm.f -- translated by f2c (version 19991025).
   You must link the resulting object file with the libraries:
	-lf2c -lm   (in that order)
*/

#include "f2c.h"

/* Subroutine */ int rogsm_(rgdip, alfag, alfas, deltas, rgsm, rsmg, tilt, 
	ier)
doublereal *rgdip, *alfag, *alfas, *deltas, *rgsm, *rsmg, *tilt;
integer *ier;
{

    /* Builtin functions */
    double cos(), sin(), asin(), sqrt();

    /* Local variables */
    static doublereal rsun[9]	/* was [3][3] */, xsun, ysun, zsun;
    static integer i__, j;
    static doublereal dlons, dpsun, xdsun, ydsun, zdsun;
    extern /* Subroutine */ int geodip_();
    static doublereal cphids, sphids;
    extern /* Subroutine */ int promat_();

/* * */
/* *********************************************************************** */
/* * */
/* *          "Copyright [c] CNES 98 - tous droits reserves" */
/* *          ********************************************** */
/* * */
/* *PRO MAGLIB */
/* * */
/* *VER 99.03.31 - V 1.0 */
/* *VER 01.06.05 - V 2.0 */
/* *VER 03.01.06 - V 2.1 */
/* * */
/* *AUT spec. CNES - JC KOSIK - janvier 1991 */
/* *AUT port. CISI */
/* * */
/* *ROL Theme : Changements de repere */
/* *ROL         Calcul de la matrice de passage du repere geocentrique au */
/* *ROL         repere solaire magnetospherique et de la matrice inverse. */
/* * */
/* *PAR rgdip  (I) : matrice (3,3) de passage du repere geographique */
/* *PAR            : au repere dipolaire */
/* * */
/* *PAR alfag  (I) : ascension droite de Greenwich (radians) */
/* * */
/* *PAR alfas  (I) : ascension droite du soleil (radians) */
/* *PAR deltas (I) : declinaison du soleil (radians) */
/* * */
/* *PAR rgsm   (O) : matrice (3,3) de passage du repere geocentrique */
/* *PAR            : au repere solaire magnetique */
/* *PAR rsmg   (O) : matrice (3,3) de passage du repere solaire */
/* *PAR            : magnetique au repere geocentrique */
/* * */
/* *PAR tilt   (O) : angle de tilt (radians) */
/* * */
/* *PAR ier    (O) : code de retour */
/* * */
/* *NOT ier        : sans objet */
/* * */
/* *INF utilise    : geodip, promat */
/* * */
/* *HST version 1.0 - 99.03.31 - creation de la maglib au CDPP */
/* *HST version 2.0 - 01.06.05 - correction de commentaires de code */
/* *HST version 2.1 - 03.01.06 - corrections en compilation avec g77 */
/* * */
/* *********************************************************************** */
/* * */

/*     --------------------------------- */
/* *FON Declaration identificateur rcs_id */
/*     --------------------------------- */


/*     -------------------------- */
/* *FON Declaration des parametres */
/*     -------------------------- */


/*     --------------------------------- */
/* *FON Declaration des variables locales */
/*     --------------------------------- */

/* *LOC i,j : indices de boucles */

/* *LOC Variables de travail intermediaires */


/*     --------------------------------- */
/* *FON Affectation identificateur rcs_id */
/*     --------------------------------- */

    /* Parameter adjustments */
    rsmg -= 4;
    rgsm -= 4;
    rgdip -= 4;

    /* Function Body */

/*     ****************** */
/*     Debut de programme */
/*     ****************** */

    *ier = 0;

/*     --------------------------------------- */
/* *FON Calcul de la position du soleil dans le */
/* *FON repere geocentrique */
/*     --------------------------------------- */

    dlons = *alfas - *alfag;

    xsun = cos(*deltas) * cos(dlons);
    ysun = cos(*deltas) * sin(dlons);
    zsun = sin(*deltas);

/*     ----------------------------------------- */
/* *FON Calcul de la position dipolaire du soleil */
/*     ----------------------------------------- */

    geodip_(&rgdip[4], &xsun, &ysun, &zsun, &xdsun, &ydsun, &zdsun, ier);

    *tilt = asin(zdsun);
    dpsun = sqrt(xdsun * xdsun + ydsun * ydsun);

    cphids = xdsun / dpsun;
    sphids = ydsun / dpsun;

/*     ----------------------------------------------- */
/* *FON Calcul matrice rotation vers dipole vers soleil */
/*     ----------------------------------------------- */

    for (i__ = 1; i__ <= 3; ++i__) {
	for (j = 1; j <= 3; ++j) {
	    rsun[i__ + j * 3 - 4] = 0.;
/* L20: */
	}
/* L10: */
    }

    rsun[0] = cphids;
    rsun[3] = sphids;
    rsun[1] = -sphids;
    rsun[4] = cphids;
    rsun[8] = 1.;

/*     ---------------------------------------------------------------- */
/* *FON Calcul de la matrice de rotation (coordonnees geographiques vers */
/* *FON coordonnees solaires magnetiques) */
/*     ---------------------------------------------------------------- */

    promat_(rsun, &rgdip[4], &rgsm[4], &rsmg[4], ier);

/*     **************** */
/*     Fin de programme */
/*     **************** */

    return 0;
} /* rogsm_ */

