/* rogse.f -- translated by f2c (version 19991025).
   You must link the resulting object file with the libraries:
	-lf2c -lm   (in that order)
*/

#include "f2c.h"

/* Subroutine */ int rogse_(alfag, alfas, deltas, obliq, rgse, rseg, ier)
doublereal *alfag, *alfas, *deltas, *obliq, *rgse, *rseg;
integer *ier;
{

    /* Builtin functions */
    double cos(), sin();

    /* Local variables */
    static integer i__, j;
    static doublereal cobli, sobli, calfag, salfag, cxl, sxl;

/* * */
/* *********************************************************************** */
/* * */
/* *          "Copyright [c] CNES 98 - tous droits reserves" */
/* *          ********************************************** */
/* * */
/* *PRO MAGLIB */
/* * */
/* *VER 99.03.31 - V 1.0 */
/* *VER 01.06.05 - V 2.0 */
/* *VER 03.01.06 - V 2.1 */
/* * */
/* *AUT spec. CNES - JC KOSIK - janvier 1991 */
/* *AUT port. CISI */
/* * */
/* *ROL Theme : Changements de repere */
/* *ROL         Calcul de la matrice de passage du repere geocentrique au */
/* *ROL         repere solaire ecliptique et de la matrice inverse. */
/* * */
/* *PAR alfag  (I) : ascension droite de Greenwich (radians) */
/* * */
/* *PAR alfas  (I) : ascension droite du soleil (radians) */
/* *PAR deltas (I) : declinaison du soleil (radians) */
/* * */
/* *PAR obliq  (I) : obliquite de l'ecliptique (radians) */
/* * */
/* *PAR rgse   (O) : matrice (3,3) de passage du repere geocentrique */
/* *PAR            : au repere solaire ecliptique */
/* *PAR rseg   (O) : matrice (3,3) de passage du repere sola */
/* *ire */
/* *PAR            : ecliptique au repere geocentrique */
/* *PAR ier    (O) : code de retour */
/* * */
/* *NOT ier        : sans objet */
/* * */
/* *INF utilise    : sans objet */
/* * */
/* *HST version 1.0 - 99.03.31 - creation de la maglib au CDPP */
/* *HST version 2.0 - 01.06.05 - correction de commentaires de code */
/* *HST version 2.1 - 03.01.06 - corrections en compilation avec g77 */
/* * */
/* *********************************************************************** */
/* * */

/*     --------------------------------- */
/* *FON Declaration identificateur rcs_id */
/*     --------------------------------- */


/*     -------------------------- */
/* *FON Declaration des parametres */
/*     -------------------------- */


/*     --------------------------------- */
/* *FON Declaration des variables locales */
/*     --------------------------------- */

/* *LOC i,j : indices de boucles */

/* *LOC Variables de travail intermediaires */


/*     --------------------------------- */
/* *FON Affectation identificateur rcs_id */
/*     --------------------------------- */

    /* Parameter adjustments */
    rseg -= 4;
    rgse -= 4;

    /* Function Body */

/*     ****************** */
/*     Debut de programme */
/*     ****************** */

/*     --------------------------------------------- */
/* *FON Calculs intermediaires (angle de la rotation) */
/*     --------------------------------------------- */

    *ier = 0;

    cxl = cos(*alfas) * cos(*deltas);
    sxl = sin(*deltas) / sin(*obliq);
    cobli = cos(*obliq);
    sobli = sin(*obliq);
    calfag = cos(*alfag);
    salfag = sin(*alfag);

/*     ------------------------- */
/* *FON Calcul de la matrice rgse */
/*     ------------------------- */

    rgse[4] = cxl * calfag + cobli * sxl * salfag;
    rgse[7] = -cxl * salfag + cobli * sxl * calfag;
    rgse[10] = sobli * sxl;
    rgse[5] = -sxl * calfag + cobli * cxl * salfag;
    rgse[8] = sxl * salfag + cobli * cxl * calfag;
    rgse[11] = sobli * cxl;
    rgse[6] = -sobli * salfag;
    rgse[9] = -calfag * sobli;
    rgse[12] = cobli;

/*     -------------------------------------------- */
/* *FON Calcul de la matrice rseg transposee de rgse */
/*     -------------------------------------------- */

    for (i__ = 1; i__ <= 3; ++i__) {
	for (j = 1; j <= 3; ++j) {
	    rseg[i__ + j * 3] = rgse[j + i__ * 3];
/* L20: */
	}
/* L10: */
    }

/*     **************** */
/*     Fin de programme */
/*     **************** */

    return 0;
} /* rogse_ */

