/* rogdip.f -- translated by f2c (version 19991025).
   You must link the resulting object file with the libraries:
	-lf2c -lm   (in that order)
*/

#include "f2c.h"

/* Subroutine */ int rogdip_(tetdip, phidip, rgdip, rdipg, ier)
doublereal *tetdip, *phidip, *rgdip, *rdipg;
integer *ier;
{

    /* Builtin functions */
    double cos(), sin();

    /* Local variables */
    static integer i__, j;
    static doublereal cphid, ctetd, sphid, stetd;

/* * */
/* *********************************************************************** */
/* * */
/* *          "Copyright [c] CNES 98 - tous droits reserves" */
/* *          ********************************************** */
/* * */
/* *PRO MAGLIB */
/* * */
/* *VER 99.03.31 - V 1.0 */
/* *VER 01.06.05 - V 2.0 */
/* *VER 03.01.06 - V 2.1 */
/* * */
/* *AUT spec. CNES - JC KOSIK - janvier 1991 */
/* *AUT port. CISI */
/* * */
/* *ROL Theme : Changements de repere */
/* *ROL         Calcul de la matrice de passage du repere geocentrique */
/* *ROL         au repere dipolaire et de la matrice inverse. */
/* * */
/* *PAR tetdip (I) : colatitude geocentrique du point ou le dipole */
/* *PAR            : coupe l'hemisphere nord (radians) */
/* *PAR phidip (I) : longitude geocentrique du point ou le dipole */
/* *PAR            : coupe l'hemisphere nord (radians) */
/* * */
/* *PAR rgdip  (O) : matrice (3,3) de passage du repere geographique */
/* *PAR            : au repere dipolaire */
/* *PAR rdipg  (O) : matrice (3,3) de passage du repere dipolaire */
/* *PAR            : au repere geocentrique */
/* * */
/* *PAR ier    (O) : code de retour */
/* * */
/* *NOT ier        : sans objet */
/* * */
/* *INF utilise    : sans objet */
/* * */
/* *HST version 1.0 - 99.03.31 - creation de la maglib au CDPP */
/* *HST version 2.0 - 01.06.05 - correction de commentaires de code */
/* *HST version 2.1 - 03.01.06 - corrections en compilation avec g77 */
/* * */
/* *********************************************************************** */
/* * */

/*     --------------------------------- */
/* *FON Declaration identificateur rcs_id */
/*     --------------------------------- */


/*     -------------------------- */
/* *FON Declaration des parametres */
/*     -------------------------- */


/*     --------------------------------- */
/* *FON Declaration des variables locales */
/*     --------------------------------- */

/* *LOC i,j : indices de boucles */

/* *LOC Variables de travail intermediaires */


/*     --------------------------------- */
/* *FON Affectation identificateur rcs_id */
/*     --------------------------------- */

    /* Parameter adjustments */
    rdipg -= 4;
    rgdip -= 4;

    /* Function Body */

/*     ****************** */
/*     Debut de programme */
/*     ****************** */

    *ier = 0;

/*     ---------------------------------------------- */
/* *FON Calculs intermediaires (angles de la rotation) */
/*     ---------------------------------------------- */

    ctetd = cos(*tetdip);
    stetd = sin(*tetdip);
    cphid = cos(*phidip);
    sphid = sin(*phidip);

/*     -------------------------- */
/* *FON Calcul de la matrice rgdip */
/*     -------------------------- */

    rgdip[4] = ctetd * cphid;
    rgdip[7] = ctetd * sphid;
    rgdip[10] = -stetd;
    rgdip[5] = -sphid;
    rgdip[8] = cphid;
    rgdip[11] = 0.;
    rgdip[6] = stetd * cphid;
    rgdip[9] = stetd * sphid;
    rgdip[12] = ctetd;

/*     ---------------------------------------------- */
/* *FON Calcul de la matrice rdipg transposee de rgdip */
/*     ---------------------------------------------- */

    for (i__ = 1; i__ <= 3; ++i__) {
	for (j = 1; j <= 3; ++j) {
	    rdipg[i__ + j * 3] = rgdip[j + i__ * 3];
/* L20: */
	}
/* L10: */
    }

/*     **************** */
/*     Fin de programme */
/*     **************** */

    return 0;
} /* rogdip_ */

