/* inigeo1.f -- translated by f2c (version 19991025).
   You must link the resulting object file with the libraries:
	-lf2c -lm   (in that order)
*/

#include "f2c.h"

/* Subroutine */ int inigeo1_(iyear, imonth, iday, ihour, imin, isec, year, 
	djulc, alfag, tetdip, phidip, alfas, deltas, obliq, rig, rgi, rgdip, 
	rdipg, rgsm, rsmg, tilt, rggsm, rgsmg, rsmgsm, rgsmsm, rgse, rseg, 
	rise, rsei, ier)
integer *iyear, *imonth, *iday, *ihour, *imin, *isec;
doublereal *year, *djulc, *alfag, *tetdip, *phidip, *alfas, *deltas, *obliq, *
	rig, *rgi, *rgdip, *rdipg, *rgsm, *rsmg, *tilt, *rggsm, *rgsmg, *
	rsmgsm, *rgsmsm, *rgse, *rseg, *rise, *rsei;
integer *ier;
{

    extern integer julg_();
    extern /* Subroutine */ int roig_(), rogse_(), roise_();
    static doublereal fjour;
    extern /* Subroutine */ int rogsm_(), rogdip_();
    static integer ierjul;
    extern /* Subroutine */ int roggsm_(), rosmgs_(), solter00_(), solter10_()
	    , solter05_();
    static integer ier1, ier2, ier3, ier4, ier5, ier6, ier7, ier8;

/* * */
/* *********************************************************************** */
/* * */
/* *      "Copyright [c] CNES 98 - tous droits reserves" */
/* *      ********************************************** */
/* * */
/* *PRO MAGLIB */
/* * */
/* *VER 99.03.31 - V 1.0 */
/* *VER 01.10.23 - V 2.0 */
/* *VER 03.01.06 - V 2.1 */
/* *VER 01.01.07 - V 3.0 */
/* *VER 13.10.10 - V 4.0 */
/* * */
/* *AUT spec. CNES - JC KOSIK - janvier 1991 */
/* *AUT port. CISI */
/* * */
/* *ROL Theme : Modules d'initialisation */
/* *ROL         Initialisation de toutes les matrices de rotation */
/* *ROL         necessaires aux calculs geophysiques et geomagnetiques */
/* *ROL         pour CLUSTER, ainsi que l'angle de tilt, l'orientation */
/* *ROL         de l'axe du dipole, l'ascension droite et la declinaison */
/* *ROL         du soleil. */
/* * */
/* *PAR iyear  (I) : annee (>= 2000) */
/* *PAR imonth (I) : mois */
/* *PAR iday   (I) : jour */
/* *PAR ihour  (I) : heures */
/* *PAR imin   (I) : minutes */
/* *PAR isec   (I) : secondes */
/* * */
/* *PAR year   (O) : annee fractionnaire (>= 2000.) */
/* * */
/* *PAR djulc  (O) : date julienne CNES fractionnaire (depuis le 01/01/1950) */
/* * */
/* *PAR alfag  (O) : ascension droite de Greenwich (radians) */
/* *PAR tetdip (O) : colatitude geocentrique du point ou le dipole */
/* *PAR            : coupe l'hemisphere nord (radians) */
/* *PAR phidip (O) : longitude geocentrique du point ou le dipole */
/* *PAR            : coupe l'hemisphere nord (radians) */
/* * */
/* *PAR alfas  (O) : ascension droite du soleil (radians) */
/* *PAR deltas (O) : declinaison du soleil (radians) */
/* * */
/* *PAR obliq  (O) : obliquite de l'ecliptique (radians) */
/* * */
/* *PAR rig    (O) : matrice (3,3) de passage du repere inertiel */
/* *PAR            : au repere geocentrique */
/* *PAR rgi    (O) : matrice (3,3) de passage du repere geocentrique */
/* *PAR            : au repere inertiel */
/* * */
/* *PAR rgdip  (O) : matrice (3,3) de passage du repere geographique */
/* *PAR            : au repere dipolaire */
/* *PAR rdipg  (O) : matrice (3,3) de passage du repere dipolaire */
/* *PAR            : au repere geocentrique */
/* * */
/* *PAR rgsm   (O) : matrice (3,3) de passage du repere geocentrique */
/* *PAR            : au repere solaire magnetique */
/* *PAR rsmg   (O) : matrice (3,3) de passage du repere solaire */
/* *PAR            : magnetique au repere geocentrique */
/* * */
/* *PAR tilt   (O) : angle de tilt (radians) */
/* * */
/* *PAR rggsm  (O) : matrice (3,3) de passage du repere geocentrique */
/* *PAR            : au repere solaire magnetospherique */
/* *PAR rgsmg  (O) : matrice (3,3) de passage du repere solaire */
/* *PAR            : magnetospherique au repere geocentrique */
/* * */
/* *PAR rsmgsm (O) : matrice (3,3) de passage du repere solaire */
/* *PAR            : magnetique au repere solaire magnetospherique */
/* *PAR rgsmsm (O) : matrice (3,3) de passage du repere solaire */
/* *PAR            : magnetospherique au repere solaire magnetique */
/* * */
/* *PAR rgse   (O) : matrice (3,3) de passage du repere geocentrique */
/* *PAR            : au repere solaire ecliptique */
/* *PAR rseg   (O) : matrice (3,3) de passage du repere solaire */
/* *PAR            : ecliptique au repere geocentrique */
/* * */
/* *PAR rise   (O) : matrice (3,3) de passage du repere inertiel */
/* *PAR rsei   (O) : matrice (3,3) de passage du repere solaire */
/* * */
/* *PAR ier    (O) : code de retour */
/* * */
/* *NOT ier        : = 1 si iyear < 2000 */
/* * */
/* *INF utilise    : solter00, solter05, solter10, */
/* *INF utilise    : roig, rogdip, rogsm, roggsm, rogse, roise, rosmgs */
/* * */
/* *HST version 1.0 - 15.09.98 - creation de la maglib au CDPP */
/* *HST version 2.0 - 01.10.23 - ajout de soltern */
/* *HST version 2.1 - 03.01.06 - corrections en compilation avec g77 */
/* *HST version 3.0 - 01.01.07 - adoption des coefficients definitifs */
/* *HST                          du champ 2000 */
/* *HST version 4.0 - 13.10.10 - Calcule entre 2000 et 2014 */
/* * */
/* *********************************************************************** */
/* * */

/*     --------------------------------- */
/* *FON Declaration identificateur rcs_id */
/*     --------------------------------- */


/*     -------------------------- */
/* *FON Declaration des parametres */
/*     -------------------------- */


/*     ---------------------------------- */
/* *FON Declaration des fonctions externes */
/*     ---------------------------------- */


/*     --------------------------------- */
/* *FON Declaration des variables locales */
/*     --------------------------------- */

/* *LOVC ierjul : erreur sur calcul de la date julienne */

/* *LOC ier1 a ier8 : codes retour des modules appeles */



/*     --------------------------------- */
/* *FON Affectation identificateur rcs_id */
/*     --------------------------------- */

    /* Parameter adjustments */
    rsei -= 4;
    rise -= 4;
    rseg -= 4;
    rgse -= 4;
    rgsmsm -= 4;
    rsmgsm -= 4;
    rgsmg -= 4;
    rggsm -= 4;
    rsmg -= 4;
    rgsm -= 4;
    rdipg -= 4;
    rgdip -= 4;
    rgi -= 4;
    rig -= 4;

    /* Function Body */

/*     ****************** */
/*     Debut de programme */
/*     ****************** */

    *ier = 0;
    ier1 = 0;
    ier2 = 0;
    ier3 = 0;
    ier4 = 0;
    ier5 = 0;
    ier6 = 0;
    ier7 = 0;
    ier8 = 0;
    ierjul = 0;

/*     -------------------------------------- */
/* *FON Calcul de la date julienne CNES  djulc */
/*     -------------------------------------- */

    fjour = (doublereal) ((*ihour * 60 + *imin) * 60 + *isec) / 86400.;
    *djulc = (doublereal) julg_(iday, imonth, iyear, &ierjul) + fjour;

/*     ---------------------------------------------------------- */
/* *FON Calcul de la position inertielle de Greenwich et du soleil */
/* *FON et des angles d'orientation du dipole terrestre suivant */
/* *FON la periode, 2000-2005 ou 2005-2010 ou 2010-2015 */
/*     ---------------------------------------------------------- */

    if (*iyear >= 2000 && *iyear < 2005) {

	solter00_(iyear, imonth, iday, ihour, imin, isec, year, alfag, alfas, 
		deltas, obliq, tetdip, phidip, &ier1);

    } else if (*iyear >= 2005 && *iyear < 2010) {

	solter05_(iyear, imonth, iday, ihour, imin, isec, year, alfag, alfas, 
		deltas, obliq, tetdip, phidip, &ier1);

    } else if (*iyear >= 2010) {

	solter10_(iyear, imonth, iday, ihour, imin, isec, year, alfag, alfas, 
		deltas, obliq, tetdip, phidip, &ier1);

    } else {
	*ier = 1;
    }

/*     ------------------------------------------------------ */
/* *FON Calcul des matrices de passage du repere inertiel vers */
/* *FON le repere geographique */
/*     ------------------------------------------------------ */

    roig_(alfag, &rig[4], &rgi[4], &ier2);

/*     -------------------------------------------------------- */
/* *FON Calcul des matrices de passage du repere geographique au */
/* *FON repere dipolaire */
/*     -------------------------------------------------------- */

    rogdip_(tetdip, phidip, &rgdip[4], &rdipg[4], &ier3);

/*     ---------------------------------------------------------- */
/* *FON Calcul des matrices de passage du repere geographique vers */
/* *FON le repere solaire-magnetique */
/*     ---------------------------------------------------------- */

    rogsm_(&rgdip[4], alfag, alfas, deltas, &rgsm[4], &rsmg[4], tilt, &ier4);

/*     ---------------------------------------------------------- */
/* *FON Calcul des matrices de passage du repere geographique vers */
/* *FON le repere solaire-magnetospherique */
/*     ---------------------------------------------------------- */

    roggsm_(tilt, &rgsm[4], &rggsm[4], &rgsmg[4], &ier5);

/*     ----------------------------------------------------------- */
/* *FON Calcul des matrices de passage du repere inertiel au repere */
/* *FON solaire magnetospherique gsm */
/*     ----------------------------------------------------------- */

    rogse_(alfag, alfas, deltas, obliq, &rgse[4], &rseg[4], &ier6);

/*     ----------------------------------------------------------- */
/* *FON calcul des matrices de passage du repere inertiel au repere */
/* *FON solaire ecliptique */
/*     ----------------------------------------------------------- */

    roise_(alfas, deltas, obliq, &rise[4], &rsei[4], &ier7);

/*     ------------------------------------------------------------ */
/* *FON calcul des matrices de passage du repere sm au repere gsm et */
/* *FON inverse */
/*     ------------------------------------------------------------ */

    rosmgs_(tilt, &rsmgsm[4], &rgsmsm[4], &ier8);

/*     **************** */
/*     Fin de programme */
/*     **************** */

    return 0;
} /* inigeo1_ */

