/*------------------------------------------------------------------------------
 *
 *	Fichier	: $RCSfile: lint.c,v $, v $Revision: 1.5 $
 *
 *	Date	: $Date: 2017/09/29 14:15:12 $
 *
 *	Auteur	: $Author: penou $
 *
 *	Version : %Z% version %I% de %M% du %G%
 *
 *------------------------------------------------------------------------------
 */


#include <stdio.h>
#include <ctype.h>
#include "export.h"

/*---------------------------------------------------------------------------*/
int ischar (char x) {
/*---------------------------------------------------------------------------*/
/* Retourne 1 si x est une lettre */

	if (x >= 'a' && x <= 'z')	return 1;
	if (x >= 'A' && x <= 'Z')	return 1;
	//if (x == '')			return 1;
	//if (x == '')			return 1;
	//if (x == '')			return 1;
	//if (x == '')			return 1;

	return 0;

}

char	ligne[100*1024*1024];

/*---------------------------------------------------------------------------*/
void supprimer_commentaires_idl (IDL_STRING *ligneIDL) {
/*---------------------------------------------------------------------------*/

	/*

		Remplace ce qui est entre simple quote par la 'chaine'
		Remplace ce qui est entre double quote par la 'chaine'
		Supprime les commentaires
		Supprime les blancs et tabulations en dbut de ligne

		Supprimer ce qui est aprs le ';' d'un commentaire
		ATTENTION  '&nbsp;' qui n'est pas un commentaire     

	*/


	char	caractere;
	char	caractere1;
	int	i=0,j=0;

	if (ligneIDL->slen==0) return;

        while (i<ligneIDL->slen) {

		caractere = (ligneIDL->s)[i];
                if (caractere == ';') {
                        break;
		} else if (caractere=='\'' || caractere=='"') {
			ligne[j++] = caractere;

			if (caractere=='"') {
				// Octal genre "123 ?
				i++;
				if (i==ligneIDL->slen) break;
				caractere1 = (ligneIDL->s)[i];
				if (caractere1 >= '0' && caractere1 <= '8') {
					// c'est un octal donc pas un string
					continue;
				}
				i--;
			}

			for (i++ ; (ligneIDL->s[i] != caractere) && (i<ligneIDL->slen) ; i++) {
				// cherche le prochain ' ou ''
				ligne[j++] = ligneIDL->s[i] == '&' ? '#' : ligneIDL->s[i];	// ne pas mettre de &!
			}
			if (i==ligneIDL->slen) break; // non trouv!
			ligne[j++] = ligneIDL->s[i];
			i++;
		} else {
			ligne[j++] = caractere;
                        i++;
		}

	}

	ligne[j]=0;

	IDL_StrStore (ligneIDL,ligne);

}

/*---------------------------------------------------------------------------*/
char *get_html1 (IDL_STRING *ligneIDL) {
/*---------------------------------------------------------------------------*/

	/*

		Remplace '' par '&eacute;'
		Remplace '' par '&egrave;'
		Remplace '' par '&ecirc;'
		Remplace '' par '&agrave;'
		Remplace '' par '&ugrave;'
		Remplace '&' par '&amp;'
		Remplace '"' par '&quot;'
		Remplace "'" par '&#039;'
		Remplace "<" par '&lt;'
		Remplace ">" par '&gt;'
		
	*/


	char	caractere;
	int	i,j=0,k;

	char	EACUTE[]	= "&eacute;";
	char	EGRAVE[]	= "&egrave;";
	char	ECIRC[]		= "&egrave;";
	char	AGRAVE[]	= "&agrave;";
	char	UGRAVE[]	= "&ugrave;";
	char	AMP[]		= "&amp;";
	char	DOUBLE_QUOTE[]	= "&quot;";
	char	SIMPLE_QUOTE[]	= "&#039;";
	char	LT[]		= "&lt;";
	char	GT[]		= "&gt;";

	#define GET_HTML_ADD(TAB)	for (k=0 ; TAB[k] ; k++) ligne[j++] = TAB[k];

	if (ligneIDL->slen) {

		for (i=0 ; i<ligneIDL->slen ; i++) {

			caractere = (ligneIDL->s)[i];

	                switch (caractere)  {
	                        case '':	GET_HTML_ADD(EACUTE);		break;
	                        case '':	GET_HTML_ADD(EGRAVE);		break;
	                        case '':	GET_HTML_ADD(ECIRC);		break;
	                        case '':	GET_HTML_ADD(AGRAVE);		break;
        	                case '':	GET_HTML_ADD(UGRAVE);		break;
	                        case '&':	GET_HTML_ADD(AMP);		break;
	                        case '"':	GET_HTML_ADD(DOUBLE_QUOTE);	break;
	                        case '\'':	GET_HTML_ADD(SIMPLE_QUOTE);	break;
	                        case '<':	GET_HTML_ADD(LT);		break;
	                        case '>':	GET_HTML_ADD(GT);		break;
	                        default:	ligne[j++] = caractere;
			}

		}

	}

	ligne[j]=0;

	return ligne;

}

/*---------------------------------------------------------------------------*/
char *get_html2 (char *ligneIDL) {
/*---------------------------------------------------------------------------*/

	/*

		Remplace '' par '&eacute;'
		Remplace '' par '&egrave;'
		Remplace '' par '&ecirc;'
		Remplace '' par '&agrave;'
		Remplace '' par '&ugrave;'
		Remplace '&' par '&amp;'
		Remplace '"' par '&quot;'
		Remplace "'" par '&#039;'
		Remplace "<" par '&lt;'
		Remplace ">" par '&gt;'
		
	*/


	char		caractere;
	int		i,j=0,k;

	char		EACUTE[]	= "&eacute;";
	char		EGRAVE[]	= "&egrave;";
	char		ECIRC[]		= "&egrave;";
	char		AGRAVE[]	= "&agrave;";
	char		UGRAVE[]	= "&ugrave;";
	char		AMP[]		= "&amp;";
	char		DOUBLE_QUOTE[]	= "&quot;";
	char		SIMPLE_QUOTE[]	= "&#039;";
	char		LT[]		= "&lt;";
	char		GT[]		= "&gt;";

	#define GET_HTML_ADD(TAB)	for (k=0 ; TAB[k] ; k++) ligne[j++] = TAB[k];

	for (i=0 ; ; i++) {

		caractere = ligneIDL[i];

		if (caractere==0) break;

                switch (caractere)  {
                        case '':	GET_HTML_ADD(EACUTE);		break;
                        case '':	GET_HTML_ADD(EGRAVE);		break;
                        case '':	GET_HTML_ADD(ECIRC);		break;
                        case '':	GET_HTML_ADD(AGRAVE);		break;
                        case '':	GET_HTML_ADD(UGRAVE);		break;
                        case '&':	GET_HTML_ADD(AMP);		break;
                        case '"':	GET_HTML_ADD(DOUBLE_QUOTE);	break;
                        case '\'':	GET_HTML_ADD(SIMPLE_QUOTE);	break;
                        case '<':	GET_HTML_ADD(LT);		break;
                        case '>':	GET_HTML_ADD(GT);		break;
                        default:	ligne[j++] = caractere;
		}

	}

	ligne[j]=0;

	return ligne;

}


/*---------------------------------------------------------------------------*/
static IDL_VPTR get_html (IDL_STRING *ligneIDL) {
/*---------------------------------------------------------------------------*/

	/*

		Remplace '' par '&eacute;'
		Remplace '' par '&egrave;'
		Remplace '' par '&ecirc;'
		Remplace '' par '&agrave;'
		Remplace '' par '&ugrave;'
		Remplace '&' par '&amp;'
		Remplace '"' par '&quot;'
		Remplace "'" par '&#039;'
		Remplace "<" par '&lt;'
		Remplace ">" par '&gt;'
		
	*/


	char	caractere;
	int	i,j=0,k;

	char	EACUTE[]	= "&eacute;";
	char	EGRAVE[]	= "&egrave;";
	char	ECIRC[]		= "&egrave;";
	char	AGRAVE[]	= "&agrave;";
	char	UGRAVE[]	= "&ugrave;";
	char	AMP[]		= "&amp;";
	char	DOUBLE_QUOTE[]	= "&quot;";
	char	SIMPLE_QUOTE[]	= "&#039;";
	char	LT[]		= "&lt;";
	char	GT[]		= "&gt;";

	#define GET_HTML_ADD(TAB)	for (k=0 ; TAB[k] ; k++) ligne[j++] = TAB[k];

	if (ligneIDL->slen==0) {
		return IDL_StrToSTRING ("");
	}

	for (i=0 ; i<ligneIDL->slen ; i++) {

		caractere = (ligneIDL->s)[i];

                switch (caractere)  {
                        case '':	GET_HTML_ADD(EACUTE);		break;
                        case '':	GET_HTML_ADD(EGRAVE);		break;
                        case '':	GET_HTML_ADD(ECIRC);		break;
                        case '':	GET_HTML_ADD(AGRAVE);		break;
                        case '':	GET_HTML_ADD(UGRAVE);		break;
                        case '&':	GET_HTML_ADD(AMP);		break;
                        case '"':	GET_HTML_ADD(DOUBLE_QUOTE);	break;
                        case '\'':	GET_HTML_ADD(SIMPLE_QUOTE);	break;
                        case '<':	GET_HTML_ADD(LT);		break;
                        case '>':	GET_HTML_ADD(GT);		break;
                        default:	ligne[j++] = caractere;
		}

	}

	ligne[j]=0;

	return IDL_StrToSTRING (ligne);

}

/*---------------------------------------------------------------------------*/
static IDL_VPTR get_correct_line (IDL_STRING *ligneIDL) {
/*---------------------------------------------------------------------------*/

	/*

		Rajoute ventuellement le caractre de fin de chaine  la fin de la ligne et ';' aprs '$'

		retourne un STRING avec le message
		
	*/



	char	SIMPLE_QUOTE = '\'';
	char	DOUBLE_QUOTE = '"';
	char	POINT_VIRGULE = ';';
	char	DOLLAR = '$';
	int	inside_simple = 0;
	int	inside_double = 0;
	int	inside_octal = 0 ; // en IDL x="10 est un octal!
	int	i,j=0;
	char	c;

	char	INCORRECT_LINE_MISSING_SEMI_COLON_AFTER_DOLLAR[] 	= "INCORRECT LINE MISSING SEMI-COLON AFTER DOLLAR";
	char	INCORRECT_LINE_UNTERMINATED_SIMPLE_QUOTE[]		= "INCORRECT LINE UNTERMINATED SIMPLE-QUOTE";
	char	INCORRECT_LINE_UNTERMINATED_DOUBLE_QUOTE[]		= "INCORRECT LINE UNTERMINATED DOUBLE-QUOTE";
	char	OK[]							= "";

	int	nb = ligneIDL->slen;

	for (i=0 ; i<nb; i++) {
		c = (ligneIDL->s)[i];
		ligne[j++] = c;
		if (inside_simple) {
			if (c==SIMPLE_QUOTE) inside_simple = 0;
		} else if (inside_double) {
			if (c==DOUBLE_QUOTE) inside_double = 0;
		} else if (c==DOLLAR) {
			if (i+1 != nb) {
				c = (ligneIDL->s)[i+1];

				// ex: "TAIL$ELECTRON" est correct
				if (c>='a' && c<='z') continue;
				if (c>='A' && c<='Z') continue;
				if (c>='0' && c<='9') continue;

				for (i++; i<nb; i++) {
					c = (ligneIDL->s)[i];
					if (c==' ' || c=='\t') {
						ligne[j++] = c;
					} else if (c==POINT_VIRGULE) {
						for ( ; i<nb ; i++) ligne[j++] = (ligneIDL->s)[i];
						ligne[j] = 0;
						IDL_StrStore (ligneIDL,ligne);
						return IDL_StrToSTRING(OK);
					} else {
						// rajouter POINT_VIRGULE
						ligne[j++] = POINT_VIRGULE;
						for ( ; i<nb ; i++) ligne[j++] = (ligneIDL->s)[i];
						ligne[j] = 0;
						IDL_StrStore (ligneIDL,ligne);
						return IDL_StrToSTRING(INCORRECT_LINE_MISSING_SEMI_COLON_AFTER_DOLLAR);
					}
				}
			}
		} else if (c==SIMPLE_QUOTE) {
			inside_simple = 1;
		} else if (c==DOUBLE_QUOTE) {
			// OCTAL ou STRING ?
			c = (i+1<nb) ? (ligneIDL->s)[i+1] : ' ';
			if (c>='0' && c<='8') {
				inside_octal=1;
			} else {
				inside_double = 1;
			}
		} else if (c==POINT_VIRGULE) {
			for (i++ ; i<nb ; i++) ligne[j++] = (ligneIDL->s)[i];
			ligne[j] = 0;
			IDL_StrStore (ligneIDL,ligne);
			return IDL_StrToSTRING(OK);
		}
	}

	if (inside_simple) {
		// rajouter SIMPLE_QUOTE
		ligne[j++] = SIMPLE_QUOTE;
		ligne[j] = 0;
		IDL_StrStore (ligneIDL,ligne);
		return IDL_StrToSTRING(INCORRECT_LINE_UNTERMINATED_SIMPLE_QUOTE);
	} else if (inside_double) {
		// rajouter DOUBLE_QUOTE
		ligne[j++] = DOUBLE_QUOTE;
		ligne[j] = 0;
		IDL_StrStore (ligneIDL,ligne);
		return IDL_StrToSTRING(INCORRECT_LINE_UNTERMINATED_DOUBLE_QUOTE);
	} else {
		ligne[j] = 0;
		IDL_StrStore (ligneIDL,ligne);
		return IDL_StrToSTRING(OK);
	}

}


/*---------------------------------------------------------------------------*/
int sauter_espaces_tabulations (IDL_STRING *ligneIDL, int k) {
/*---------------------------------------------------------------------------*/

	int	i;

	if (ligneIDL->slen==0) return 0;

	for (i=k ; (ligneIDL->s[i]==' ' || ligneIDL->s[i]=='\t') ; i++);

	return i;

}

static IDL_MSG_DEF msg_arr[] = {
	{ "M_TM_INPRO", "%NLINT" }
};

static IDL_MSG_BLOCK msg_block;


/*---------------------------------------------------------------------------*/
static void lintc_supprimer_commentaires_idl (int argc, IDL_VPTR *argv) {
/*---------------------------------------------------------------------------*/

	IDL_STRING	*ligneIDL	=	(IDL_STRING *)	&(argv[0]->value.str);

	IDL_ENSURE_STRING (argv[0]);

	supprimer_commentaires_idl (ligneIDL);

}


/*---------------------------------------------------------------------------*/
static IDL_VPTR lintc_sauter_espaces_tabulations (int argc, IDL_VPTR *argv) {
/*---------------------------------------------------------------------------*/

	IDL_STRING	*ligneIDL	= (IDL_STRING *)	&(argv[0]->value.str);
	int		k		= (int)			argv[1]->value.l;

	int		code;

	//IDL_ENSURE_STRING (argv[0]);

	code = sauter_espaces_tabulations (ligneIDL,k);

	return IDL_GettmpLong(code);

}

/*---------------------------------------------------------------------------*/
static IDL_VPTR lintc_get_name_idl (int argc, IDL_VPTR *argv) {
/*---------------------------------------------------------------------------*/

	IDL_STRING	*IDLline	= (IDL_STRING *)	&(argv[0]->value.str);
	int		k		= (int)			argv[1]->value.l;
	int		*l		= (int *)		&(argv[2]->value.l);

	char		car;
	int		len;
	int		pos=k;
	int		i=k;

	//IDL_ENSURE_STRING (argv[0]);

	*l=0;
	len = IDLline->slen;
	if (len==0) goto EXIT;

	for (i=k; (i<len) && (IDLline->s[i]==' ' || IDLline->s[i]=='\t') ; i++);
	if (i==len) goto EXIT;

	pos = i;

	car = IDLline->s[i];
        if (ischar(car) || (car=='!') || (car== '_')) {

		// variable
		while (i < len) {

			car = IDLline->s[i];
			if (i+1<len && car==':' && IDLline->s[i+1]==':') {
				i += 2;
				continue;
			}
			if (	ischar(car) 		||
				(car>='0' && car<='9') 	||
				(car=='!')		||	// ! pour les variables systmes
				(car=='$')		||	// $ accept dans les champs des structures
				(car=='_'))	{
				i++;
			} else {
				break;
			}

		}

	} else if ((car>='0' && car<='9') || (car=='+') || (car=='-')) {

		// constante
		for ( ; i<len ; i++) {
			car = IDLline->s[i];
			if (	ischar(car)		||	// lettres acceptes dans les constantes ?
				(car>='0' && car<='9')	||
				(i==pos && car=='+')	||	// '+' pour le premier caractre uniquement
				(i==pos && car=='-')	||	// '-' pour le premier caractre uniquement
				(car=='.')		||
				(car=='_')) {
			} else {
				break;
			}
		}

	} else if (car=='.') {

		// constante
		for ( i++; i<len ; i++) {
			car = IDLline->s[i];
			if (	ischar(car)		||	// lettres acceptes dans les constantes ?
				(car>='0' && car<='9')	||
				(i==pos+1 && car=='+')	||	// '+' pour le second caractre uniquement
				(i==pos+1 && car=='-')	||	// '-' pour le second caractre uniquement
				(car=='_')) {
			} else {
				break;
			}
		}

		if (i-pos==1) {
			i=pos; // fausse alerte
		}

	}


EXIT:

	*l = i-pos;

	return IDL_GettmpLong(pos);

}

/*---------------------------------------------------------------------------*/
static IDL_VPTR lintc_get_name_c (int argc, IDL_VPTR *argv) {
/*---------------------------------------------------------------------------*/

	IDL_STRING	*IDLline	= (IDL_STRING *)	&(argv[0]->value.str);
	int		k		= (int)			argv[1]->value.l;
	int		*l		= (int *)		&(argv[2]->value.l);

	char		car;
	int		len;
	int		pos=k;
	int		i=k;

	//IDL_ENSURE_STRING (argv[0]);

	*l=0;
	len = IDLline->slen;
	if (len==0) goto EXIT;

	for (i=k; (i<len) && (IDLline->s[i]==' ' || IDLline->s[i]=='\t') ; i++);
	if (i==len) goto EXIT;

	pos = i;

	car = IDLline->s[i];
        if (ischar(car) || (car== '_')) {

		// variable
		while (i < len) {

			car = IDLline->s[i];
			if (	ischar(car) 		||
				(car>='0' && car<='9') 	||
				(car=='_'))	{
				i++;
			} else {
				break;
			}

		}

		if (i-pos==1) {
			i=pos; // fausse alerte
		}

	}


EXIT:

	*l = i-pos;

	return IDL_GettmpLong(pos);

}


/*---------------------------------------------------------------------------*/
static IDL_VPTR lintc_get_constant_c (int argc, IDL_VPTR *argv) {
/*---------------------------------------------------------------------------*/

	IDL_STRING	*IDLline	= (IDL_STRING *)	&(argv[0]->value.str);
	int		k		= (int)			argv[1]->value.l;
	int		*l		= (int *)		&(argv[2]->value.l);

	char		car;
	int		len;
	int		pos=k;
	int		i=k;

	//IDL_ENSURE_STRING (argv[0]);

	*l=0;
	len = IDLline->slen;
	if (len==0) goto EXIT;

	for (i=k; (i<len) && (IDLline->s[i]==' ' || IDLline->s[i]=='\t') ; i++);
	if (i==len) goto EXIT;

	pos = i;

	car = IDLline->s[i];
	if ((car>='0' && car<='9') || (car=='+') || (car=='-')) {

		// constante
		for ( ; i<len ; i++) {
			car = IDLline->s[i];
			if (	((car=='e' || car=='E') && i && (IDLline->s[i-1]>='0') && (IDLline->s[i-1]<='9'))	||	// exposant avec un chiffre avant
				((car=='f' || car=='F') && i && (IDLline->s[i-1]>='0') && (IDLline->s[i-1]<='9'))	||	// suffixe flottant avec un chiffre avant
				((car=='u' || car=='U') && i && (IDLline->s[i-1]>='0') && (IDLline->s[i-1]<='9'))	||	// suffixe entier avec un chiffre avant
				((car=='l' || car=='L') && i && (IDLline->s[i-1]>='0') && (IDLline->s[i-1]<='9'))	||	// suffixe entier avec un chiffre avant
				((car=='i' || car=='I') && i && (IDLline->s[i-1]>='0') && (IDLline->s[i-1]<='9'))	||	// suffixe entier avec un chiffre avant
				((car=='x' || car=='X') && i && (IDLline->s[i-1]>='0') && (IDLline->s[i-1]<='9'))	||	// suffixe entier avec un chiffre avant
				((car=='a' || car=='A') && (strncasecmp(&(IDLline->s[pos]),"0x",2)==0))			||	// hexa
				((car=='b' || car=='B') && (strncasecmp(&(IDLline->s[pos]),"0x",2)==0))			||	// hexa
				((car=='c' || car=='C') && (strncasecmp(&(IDLline->s[pos]),"0x",2)==0))			||	// hexa
				((car=='d' || car=='D') && (strncasecmp(&(IDLline->s[pos]),"0x",2)==0))			||	// hexa
				((car=='e' || car=='E') && (strncasecmp(&(IDLline->s[pos]),"0x",2)==0))			||	// hexa
				((car=='d' || car=='F') && (strncasecmp(&(IDLline->s[pos]),"0x",2)==0))			||	// hexa
				(car>='0' && car<='9')	||
				(i==pos && car=='+')	||	// '+' pour le premier caractre uniquement
				(i==pos && car=='-')	||	// '-' pour le premier caractre uniquement
				(car=='.')	) {
			} else {
				break;
			}
		}
		if (i-pos==1 && (IDLline->s[pos]=='+' || IDLline->s[pos]=='-')) {
			i=pos; // fausse alerte
		}

	} else if (car=='.') {

		// constante
		for ( i++; i<len ; i++) {
			car = IDLline->s[i];
			if (	((car=='e' || car=='E') && i && (IDLline->s[i-1]>='0') && (IDLline->s[i-1]<='9'))	||	// exposant avec un chiffre avant
				((car=='f' || car=='F') && i && (IDLline->s[i-1]>='0') && (IDLline->s[i-1]<='9'))	||	// suffixe flottant avec un chiffre avant
				((car=='u' || car=='U') && i && (IDLline->s[i-1]>='0') && (IDLline->s[i-1]<='9'))	||	// suffixe entier avec un chiffre avant
				((car=='l' || car=='L') && i && (IDLline->s[i-1]>='0') && (IDLline->s[i-1]<='9'))	||	// suffixe entier avec un chiffre avant
				((car=='i' || car=='I') && i && (IDLline->s[i-1]>='0') && (IDLline->s[i-1]<='9'))	||	// suffixe entier avec un chiffre avant
				((car=='x' || car=='X') && i && (IDLline->s[i-1]>='0') && (IDLline->s[i-1]<='9'))	||	// suffixe entier avec un chiffre avant
				((car=='a' || car=='A') && (strncasecmp(&(IDLline->s[pos]),"0x",2)==0))			||	// hexa
				((car=='b' || car=='B') && (strncasecmp(&(IDLline->s[pos]),"0x",2)==0))			||	// hexa
				((car=='c' || car=='C') && (strncasecmp(&(IDLline->s[pos]),"0x",2)==0))			||	// hexa
				((car=='d' || car=='D') && (strncasecmp(&(IDLline->s[pos]),"0x",2)==0))			||	// hexa
				((car=='e' || car=='E') && (strncasecmp(&(IDLline->s[pos]),"0x",2)==0))			||	// hexa
				((car=='d' || car=='F') && (strncasecmp(&(IDLline->s[pos]),"0x",2)==0))			||	// hexa
				(car>='0' && car<='9')	||
				(i==pos+1 && car=='+')	||	// '+' pour le second caractre uniquement
				(i==pos+1 && car=='-')	) {	// '-' pour le second caractre uniquement
			} else {
				break;
			}
		}

		if (i-pos==1) {
			i=pos; // fausse alerte
		}

	}


EXIT:

	*l = i-pos;

	return IDL_GettmpLong(pos);

}


/*---------------------------------------------------------------------------*/
static IDL_VPTR lintc_get_html (int argc, IDL_VPTR *argv) {
/*---------------------------------------------------------------------------*/

	IDL_STRING	*ligneIDL	=	(IDL_STRING *)	&(argv[0]->value.str);

	IDL_ENSURE_STRING (argv[0]);

	return get_html (ligneIDL);

}

/*---------------------------------------------------------------------------*/
static IDL_VPTR lintc_get_correct_line (int argc, IDL_VPTR *argv) {
/*---------------------------------------------------------------------------*/

	IDL_STRING	*ligneIDL	=	(IDL_STRING *)	&(argv[0]->value.str);

	IDL_ENSURE_STRING (argv[0]);

	return get_correct_line (ligneIDL);

}


/*---------------------------------------------------------------------------*/
static void lintc_code_to_html (int argc, IDL_VPTR *argv) {
/*---------------------------------------------------------------------------*/

	// -------------------------------------------------------------------------------
	// Traitement chaines avec '' ou "" et colorisation des mots signaler dans decl.couleur
	// -------------------------------------------------------------------------------
	//
	int		nbarg=0;

	int		is_IDL			= (int)			argv[nbarg++]->value.l;
	int		is_C			= (int)			argv[nbarg++]->value.l;
	IDL_STRING	*html_dir		= (IDL_STRING *)	&(argv[nbarg++]->value.str);
	IDL_STRING	*target			= (IDL_STRING *)	&(argv[nbarg++]->value.str);
	IDL_STRING	*nom_routine_html	= (IDL_STRING *)	&(argv[nbarg++]->value.str);
	IDL_STRING	*function_pro		= (IDL_STRING *)	&(argv[nbarg++]->value.str);
	IDL_STRING	*module			= (IDL_STRING *)	&(argv[nbarg++]->value.str);
	IDL_STRING	*name			= (IDL_STRING *)	&(argv[nbarg++]->value.str);
	IDL_STRING	*object			= (IDL_STRING *)	&(argv[nbarg++]->value.str);
	IDL_STRING	*previous		= (IDL_STRING *)	&(argv[nbarg++]->value.str);
	IDL_STRING	*next			= (IDL_STRING *)	&(argv[nbarg++]->value.str);

	IDL_STRING	*code			= (IDL_STRING *)	&(argv[nbarg++]->value.str);
	int		noligne1		= (int)			argv[nbarg++]->value.l;
	int		noligne2		= (int)			argv[nbarg++]->value.l;
	int		premiere_ligne		= (int)			argv[nbarg++]->value.l;
	int		derniere_ligne		= (int)			argv[nbarg++]->value.l;

	int		nb_prototypes		= (int)			argv[nbarg++]->value.l;
	IDL_STRING 	*prototype_name		= (IDL_STRING *)	argv[nbarg++]->value.arr->data;
	IDL_STRING 	*prototype_type		= (IDL_STRING *)	argv[nbarg++]->value.arr->data;

	IDL_STRING	*doc			= (IDL_STRING *)	&(argv[nbarg++]->value.str);

	int		nb_calledbys		= (int)			argv[nbarg++]->value.l;
	IDL_STRING 	*calledby_module	= (IDL_STRING *)	argv[nbarg++]->value.arr->data;
	IDL_STRING 	*calledby_function_pro	= (IDL_STRING *)	argv[nbarg++]->value.arr->data;
	IDL_STRING 	*calledby_name		= (IDL_STRING *)	argv[nbarg++]->value.arr->data;
	int 		*calledby_nb		= (int *)		argv[nbarg++]->value.arr->data;

	int		nb_calls		= (int)			argv[nbarg++]->value.l;
	IDL_STRING 	*call_module		= (IDL_STRING *)	argv[nbarg++]->value.arr->data;
	IDL_STRING 	*call_function_pro	= (IDL_STRING *)	argv[nbarg++]->value.arr->data;
	IDL_STRING 	*call_name		= (IDL_STRING *)	argv[nbarg++]->value.arr->data;
	int 		*call_nb		= (int *)		argv[nbarg++]->value.arr->data;

	int		nb_vars			= (int)			argv[nbarg++]->value.l;
	IDL_STRING 	*vars_type		= (IDL_STRING *)	argv[nbarg++]->value.arr->data;
	IDL_STRING 	*vars_name		= (IDL_STRING *)	argv[nbarg++]->value.arr->data;

	int		nb_labels		= (int)			argv[nbarg++]->value.l;
	IDL_STRING 	*labels_name		= (IDL_STRING *)	argv[nbarg++]->value.arr->data;

	int		nb_commons		= (int)			argv[nbarg++]->value.l;
	IDL_STRING 	*commons_common_name	= (IDL_STRING *)	argv[nbarg++]->value.arr->data;
	IDL_STRING 	*commons_var_name	= (IDL_STRING *)	argv[nbarg++]->value.arr->data;

	int		nb_msgs			= (int)			argv[nbarg++]->value.l;
	int 		*msg_noline		= (int *) 		argv[nbarg++]->value.arr->data;
	IDL_STRING 	*msg_txt1		= (IDL_STRING *)	argv[nbarg++]->value.arr->data;
	IDL_STRING 	*msg_txt2		= (IDL_STRING *)	argv[nbarg++]->value.arr->data;
	IDL_STRING 	*msg_class		= (IDL_STRING *)	argv[nbarg++]->value.arr->data;

	int		nb_clas			= (int)			argv[nbarg++]->value.l;
	int 		*cla_noline		= (int *) 		argv[nbarg++]->value.arr->data;
	int 		*cla_nochar		= (int *) 		argv[nbarg++]->value.arr->data;
	IDL_STRING 	*cla_type		= (IDL_STRING *)	argv[nbarg++]->value.arr->data;
	IDL_STRING 	*cla_word		= (IDL_STRING *)	argv[nbarg++]->value.arr->data;
	IDL_STRING 	*cla_extra		= (IDL_STRING *)	argv[nbarg++]->value.arr->data;
	IDL_STRING 	*cla_link		= (IDL_STRING *)	argv[nbarg++]->value.arr->data;

	int		i;
	int		pos1;
	int		len;
	int		noline;
	int		nochar;
	int		nex_index;
	int		next_cla_noline;
	int		next_cla_nochar;
	int		next_nomsg;
	int		next_index;
	int		premier_index;
	char		c,c1;
	char		string[1024*1024];
	int		k;
	int		trouve;
	int		ok;
	int		is_INCLUDE;
	char		*p;


	FILE		*fd;

/*
	printf ("is_IDL = %d\n",	is_IDL);
	printf ("is_INCLUDE = %d\n",	is_INCLUDE);
	printf ("html_dir = %s\n",	IDL_STRING_STR(html_dir));
	printf ("target = %s\n",	IDL_STRING_STR(target));
	printf ("s = %s\n",		IDL_STRING_STR(s));
	printf ("nb_msgs = %d\n",	nb_msgs);
	for (i=0 ; i<nb_msgs ; i++) {
		printf (" - %d noligne=[%d] txt1=[%s] txt2=[%s] class=[%s]\n",
				i,msg_noligne[i],IDL_STRING_STR(msg_txt1+i),IDL_STRING_STR(msg_txt2+i),IDL_STRING_STR(msg_class+i));
	}
	printf ("nb_clas = %d\n",	nb_clas);
	for (i=0 ; i<nb_clas ; i++) {
		printf (" - %d noligne=[%d] nochar=[%d] type=[%s] mot=[%s] lien=[%s]\n",
				i,cla_noligne[i],cla_nochar[i],IDL_STRING_STR(cla_type+i),IDL_STRING_STR(cla_mot+i),IDL_STRING_STR(cla_lien+i));
	}
*/

	is_INCLUDE = strcmp (IDL_STRING_STR(function_pro), "INCLUDE")==0;

	fd = fopen (IDL_STRING_STR(nom_routine_html),"w");

	fprintf (fd, "<!DOCTYPE HTML>\n");
	fprintf (fd, "<html>\n");
	fprintf (fd, "<head>\n");
	fprintf (fd, "<meta http-equiv=\"Content-Type\" content=\"text/html;charset=iso-8859-1\">\n");
	fprintf (fd, "<link href=\"%s/lint.css\" rel=\"stylesheet\" media=\"all\" type=\"text/css\">\n",	// feuille de style dans le <head>
		IDL_STRING_STR(html_dir));

	fprintf (fd, "<script src=\"%s/jquery.js\"></script>\n",
		IDL_STRING_STR(html_dir));
	fprintf (fd, "<link href=\"http://ajax.googleapis.com/ajax/libs/jqueryui/1.8/themes/base/jquery-ui.css\" rel=\"stylesheet\" type=\"text/css\"/>\n");
	fprintf (fd, "<script src=\"http://ajax.googleapis.com/ajax/libs/jquery/1.5/jquery.min.js\"></script>\n");
	fprintf (fd, "<script src=\"http://ajax.googleapis.com/ajax/libs/jqueryui/1.8/jquery-ui.min.js\"></script>\n");

	fprintf (fd, "<script>\n");
	fprintf (fd, "var call=0;\n");
	fprintf (fd, "var calledby=0;\n");
	fprintf (fd, "var vars=0;\n");
	fprintf (fd, "var labels=0;\n");
	fprintf (fd, "var commons=0;\n");
	fprintf (fd, "function changer_affichage_calledby (val) {\n");
	fprintf (fd, "	calledby = val;\n");
	fprintf (fd, "	if (calledby) {\n");
	fprintf (fd, "		$(\"table.calledby\").slideDown(0);\n");
	fprintf (fd, "	} else {\n");
	fprintf (fd, "		$(\"table.calledby\").slideUp(0);\n");
	fprintf (fd, "	}\n");
	fprintf (fd, "}\n");
	fprintf (fd, "function changer_affichage_call (val) {\n");
	fprintf (fd, "	call = val;\n");
	fprintf (fd, "	if (call) {\n");
	fprintf (fd, "		$(\"table.call\").slideDown(0);\n");
	fprintf (fd, "	} else {\n");
	fprintf (fd, "		$(\"table.call\").slideUp(0);\n");
	fprintf (fd, "	}\n");
	fprintf (fd, "}\n");
	fprintf (fd, "function changer_affichage_vars (val) {\n");
	fprintf (fd, "	vars = val;\n");
	fprintf (fd, "	if (vars) {\n");
	fprintf (fd, "		$(\"table.vars\").slideDown(0);\n");
	fprintf (fd, "	} else {\n");
	fprintf (fd, "		$(\"table.vars\").slideUp(0);\n");
	fprintf (fd, "	}\n");
	fprintf (fd, "}\n");
	fprintf (fd, "function changer_affichage_labels (val) {\n");
	fprintf (fd, "	labels = val;\n");
	fprintf (fd, "	if (labels) {\n");
	fprintf (fd, "		$(\"table.labels\").slideDown(0);\n");
	fprintf (fd, "	} else {\n");
	fprintf (fd, "		$(\"table.labels\").slideUp(0);\n");
	fprintf (fd, "	}\n");
	fprintf (fd, "}\n");
	fprintf (fd, "function changer_affichage_commons (val) {\n");
	fprintf (fd, "	commons = val;\n");
	fprintf (fd, "	if (commons) {\n");
	fprintf (fd, "		$(\"table.commons\").slideDown(0);\n");
	fprintf (fd, "	} else {\n");
	fprintf (fd, "		$(\"table.commons\").slideUp(0);\n");
	fprintf (fd, "	}\n");
	fprintf (fd, "}\n");
	fprintf (fd, "$(document).ready(function() {\n");
	fprintf (fd, "	$(\"button\").button();\n");
	fprintf (fd, "});\n");
	fprintf (fd, "</script>\n");

	fprintf (fd, "</head>\n");
	fprintf (fd, "<body>\n");


	fprintf (fd, "<table width=\"100%%\" border=\"0\">\n");
	fprintf (fd, "<tr>\n");

	// Lien Previous
	//  -------------
	fprintf (fd, "<td width=\"25%%\" align=\"left\">\n");
	if (previous->slen) {
		fprintf (fd, "Previous <a href=\"%s/%s/%s/%s.html\">%s</a>\n",
			IDL_STRING_STR(html_dir),
			IDL_STRING_STR(target),
			IDL_STRING_STR(module),
			IDL_STRING_STR(previous),
			IDL_STRING_STR(previous));
	}
	fprintf (fd, "</td>\n");

	// Lien index
	// ----------
	fprintf (fd, "<td width=\"50%%\" align=\"center\"><a href=\"%s/%s/index.html\">Index</a>&nbsp;<a href=\"%s/%s/modules.html\">Modules</a></td></td>\n",
		IDL_STRING_STR(html_dir),
		IDL_STRING_STR(target),
		IDL_STRING_STR(html_dir),
		IDL_STRING_STR(target));


	// Lien Next
	// ---------
	fprintf (fd, "<td width=\"25%%\" align=\"right\">\n");
	if (next->slen) {
		fprintf (fd, "Next <a href=\"%s/%s/%s/%s.html\">%s</a>\n",
			IDL_STRING_STR(html_dir),
			IDL_STRING_STR(target),
			IDL_STRING_STR(module),
			IDL_STRING_STR(next),
			IDL_STRING_STR(next));
	}
	fprintf (fd, "</td>\n");
	fprintf (fd, "</table>\n");


	// Nom FUNC/PRO
	//  ------------
	fprintf (fd, "<table width=\"100%%\" border=\"1\" style=\"border-collapse: collapse;\">\n");
	fprintf (fd, "<tr bgcolor=#00ff00><td align=\"center\">%s&nbsp;<b>", IDL_STRING_STR(function_pro));
 	if (object->slen) fprintf (fd,"%s::",IDL_STRING_STR(object));
	fprintf (fd, "%s</b>&nbsp;(<a href=\"%s/%s/%s.html\">%s</a>)</td></tr>\n",
		IDL_STRING_STR(name),
		IDL_STRING_STR(html_dir),
		IDL_STRING_STR(target),
		IDL_STRING_STR(module),
		IDL_STRING_STR(module));
	fprintf (fd, "</table>\n");


	// Messages d'erreur en ligne -2
	// -----------------------------
	trouve = 0;
	for (i=0 ; i<nb_msgs ; i++) {
		if (msg_noline[i] == -2) {	
			trouve = 1;
			fprintf (fd, "&nbsp;<span class=\"%s\">&nbsp;[%s&nbsp;%s]</span><br>\n",
					IDL_STRING_STR(msg_class+i),
					IDL_STRING_STR(msg_txt1+i),
					IDL_STRING_STR(msg_txt2+i));
		}
	}
	fprintf (fd,"<br>");

	// Prototype
	// ---------
	if (nb_prototypes) {
		fprintf (fd, "<table border=\"1\" style=\"border-collapse: collapse;\">\n");
		fprintf (fd, "<tr><th>Name</th><th>Input/Output</th></tr>\n");
		for (i=0 ; i<nb_prototypes ; i++) {
			fprintf (fd, "<tr><td>%s</td><td>%s</td></tr>\n",
				IDL_STRING_STR(prototype_name+i),
				IDL_STRING_STR(prototype_type+i));
		}
		fprintf (fd, "</table>\n");
	}


	// Messages d'erreur en ligne -1
	// -----------------------------
	trouve = 0;
	for (i=0 ; i<nb_msgs ; i++) {
		if (msg_noline[i] == -1) {	
			if (trouve==0) fprintf (fd,"<br><br>");
			trouve = 1;
			fprintf (fd, "&nbsp;<span class=\"%s\">&nbsp;[%s&nbsp;%s]</span><br>\n",
					IDL_STRING_STR(msg_class+i),
					IDL_STRING_STR(msg_txt1+i),
					IDL_STRING_STR(msg_txt2+i));
		}
	}

	// Messages d'erreur avec (noligne1 <= ligne) && (ligne <= noligne2) (arrive si erreur dans le prototype)
	// ------------------------------------------------------------------------------------------------------
	// Attention ne rien afficher si noligne2<noligne1 (peut arriver pour les fichiers INCLUDE)
	trouve = 0;
	if (noligne1<=noligne2) {
		for (i=0 ; i<nb_msgs ; i++) {
			if (noligne1 <= msg_noline[i] && msg_noline[i] <= noligne2) {	
				if (trouve==0) fprintf (fd,"<br><br>");
				trouve = 1;
				fprintf (fd, "&nbsp;<span class=\"%s\">&nbsp;[%s&nbsp;%s]</span><br>\n",
						IDL_STRING_STR(msg_class+i),
						IDL_STRING_STR(msg_txt1+i),
						IDL_STRING_STR(msg_txt2+i));
			}
		}
	}


	// Doc
	// ---
	fprintf (fd, "<div class=\"doc\">\n");
	fprintf (fd, "<pre>\n");
	fprintf (fd, "%s\n", get_html1(doc));
	fprintf (fd, "</pre>\n");
	fprintf (fd, "</div>\n");


	// Calledby
	//  --------
	fprintf (fd, "<button class=\"calledby\">Called by (%d)</button>\n",nb_calledbys);
	fprintf (fd, "<table class=\"calledby\" border=\"1\" style=\"border-collapse: collapse;\">\n");
	if (nb_calledbys) {
		fprintf (fd, "<tr><th>MODULE</th><th>NAME</th><th>NB</th></tr>\n");
		for (i=0 ; i<nb_calledbys ; i++) {
			fprintf (fd, "<tr>\n");
			fprintf (fd, "<td><a href=\"%s/%s/%s/%s_%s.html\">%s</a></td>\n",
				IDL_STRING_STR(html_dir),
				IDL_STRING_STR(target),
				IDL_STRING_STR(calledby_module+i),
				IDL_STRING_STR(calledby_function_pro+i),
				IDL_STRING_STR(calledby_name+i),
				IDL_STRING_STR(calledby_name+i));
			fprintf (fd, "<td><a href=\"%s/%s/%s.html\">%s</a></td>\n",
				IDL_STRING_STR(html_dir),
				IDL_STRING_STR(target),
				IDL_STRING_STR(calledby_module+i),
				IDL_STRING_STR(calledby_module+i));
			fprintf (fd, "<td>%d</td>\n", calledby_nb[i]);
			fprintf (fd, "</tr>\n");
		}
	} else {
		fprintf (fd, "<tr><td>None</td></tr>\n");
	}
	fprintf (fd, "</table>\n");


	// Calls
	// -----
	fprintf (fd, "<button class=\"call\">Calls (%d)</button>\n",nb_calls);
	fprintf (fd, "<table class=\"call\" border=\"1\" style=\"border-collapse: collapse;\">\n");
	if (nb_calls) {
		fprintf (fd, "<tr><th>MODULE</th><th>NAME</th><th>NB</th></tr>\n");
		for (i=0 ; i<nb_calls ; i++) {
			fprintf (fd, "<tr>\n");
			fprintf (fd, "<td><a href=\"%s/%s/%s/%s_%s.html\">%s</a></td>\n",
				IDL_STRING_STR(html_dir),
				IDL_STRING_STR(target),
				IDL_STRING_STR(call_module+i),
				IDL_STRING_STR(call_function_pro+i),
				IDL_STRING_STR(call_name+i),
				IDL_STRING_STR(call_name+i));
			fprintf (fd, "<td><a href=\"%s/%s/%s.html\">%s</a></td>\n",
				IDL_STRING_STR(html_dir),
				IDL_STRING_STR(target),
				IDL_STRING_STR(call_module+i),
				IDL_STRING_STR(call_module+i));
			fprintf (fd, "<td>%d</td>\n",call_nb[i]);
			fprintf (fd, "</tr>\n");
		}
	} else {
		fprintf (fd, "<tr><td>None</td></tr>\n");
	}
	fprintf (fd, "</table>\n");

	if (is_IDL) {
		// Vars
		// ----
		fprintf (fd, "<button class=\"vars\">Vars (%d)</button>\n",nb_vars);
		fprintf (fd, "<table class=\"vars\" border=\"1\" style=\"border-collapse: collapse;\">\n");
		if (nb_vars) {
			fprintf (fd, "<tr><th>TYPE</th><th>NAME</th></tr>\n");
			for (i=0 ; i<nb_vars ; i++) {
				fprintf (fd, "<tr><td>%s</td><td>%s</td></tr>\n",
					IDL_STRING_STR(vars_type+i),
					IDL_STRING_STR(vars_name+i));
			}
		} else {
			fprintf (fd, "<tr><td>None</td></tr>\n");
		}
		fprintf (fd, "</table>\n");
	}

	if (is_IDL) {
		// Labels
		// ------
		fprintf (fd, "<button class=\"labels\">Labels (%d)</button>\n",nb_labels);
		fprintf (fd, "<table class=\"labels\" border=\"1\" style=\"border-collapse: collapse;\">\n");
		if (nb_labels) {
			fprintf (fd, "<tr><th>NAME</th></tr>\n");
			for (i=0 ; i<nb_labels ; i++) {
				fprintf (fd, "<tr><td>%s</td></tr>\n", IDL_STRING_STR(labels_name+i));
			}
		} else {
			fprintf (fd, "<tr><td>None</td></tr>\n");
		}
		fprintf (fd, "</table>\n");
	}

	if (is_IDL) {
		//  Commons
		// --------
		fprintf (fd, "<button class=\"commons\">Commons (%d)</button>\n", nb_commons);
		fprintf (fd,"<table class=\"commons\" border=\"1\" style=\"border-collapse: collapse;\">\n");
		if (nb_commons) {
			fprintf (fd, "<tr><th>COMMON_NAME</th><th>VAR_NAMES</th></tr>\n");
			for (i=0 ; i<nb_commons ; i++) {
				fprintf (fd, "<tr><td>%s</td><td>%s</td></tr>",
						IDL_STRING_STR(commons_common_name+i),
						IDL_STRING_STR(commons_var_name+i));
			}
		} else {
			fprintf (fd, "<tr><td>None</td></tr>\n");
		}
		fprintf (fd, "</table>\n");
	}

	// Messages d'erreur en ligne 0
	// -----------------------------
	trouve = 0;
	for (i=0 ; i<nb_msgs ; i++) {
		if (msg_noline[i] == 0) {	
			if (trouve==0) fprintf (fd,"<br><br>");
			trouve = 1;
			fprintf (fd, "&nbsp;<span class=\"%s\">&nbsp;[%s&nbsp;%s]</span><br>\n",
					IDL_STRING_STR(msg_class+i),
					IDL_STRING_STR(msg_txt1+i),
					IDL_STRING_STR(msg_txt2+i));
		}
	}

	fprintf (fd, "<br>");

	// Code
	// ----
	fprintf (fd, "<div class=\"code\">\n");
	fprintf (fd, "<pre>\n");


	len = code->slen;
	pos1 = 0;			// numro d'octet dans s (commence  0)
	noline = premiere_ligne;	// numro de ligne dans s (commence  1)
	nochar = 0;			// numro de colonne dans s (commence  0)

	next_index = 0;					// index du prochain mot  coloriser
	next_cla_noline = cla_noline[next_index];	// numro de ligne du prochain mot  coloriser
	next_cla_nochar = cla_nochar[next_index];	// numro de colonne du prochain mot  coloriser

	if (nb_msgs == 0) {
		next_nomsg = -1;
	} else {
		next_nomsg = 0;
		// sauter les messages en ligne < premiere_ligne
		while (next_nomsg < nb_msgs && msg_noline[next_nomsg] < premiere_ligne) {
			next_nomsg++;
		}
	}

	while (pos1 < len) {

		// ne pas crire la dernire ligne qui contient 'END'
		if (noline == derniere_ligne) {
			if (is_IDL && !is_INCLUDE) {
				//   cause du fichier "expand_tilde.pro" qui se termine par "return,tname & end"
				if (pos1+2<len && strncasecmp(code->s+pos1,"END",3) == 0) {
					break;
				}
			}
		}

		c = code->s[pos1];

		if (noline == next_cla_noline && nochar == next_cla_nochar) {

			premier_index = next_index;
			if (strcmp((cla_type+next_index)->s,"CALL_USER")==0 || 
			    strcmp((cla_type+next_index)->s,"CALL_SYSTEM")==0 || 
                            strcmp((cla_type+next_index)->s,"CALL_INCLUDE")==0 ||
                            (strcmp((cla_type+next_index)->s,"CALL_SYSTEM")==0 && strcmp((cla_word+next_index)->s,"CALL_EXTERNAL")==0)) {
				// lien html pour les 'CALL_USER', 'CALL_INCLUDE' et 'CALL_EXTERNAL'

				ok=1;


				// boucle pour les cas ou il y en plusieurs mots  coloriser exactement au mme endoit
				// ca arrive par exemple si on appelle une FUNC/PRO dfinie dans plusieurs modules
				while (1) {
					if (next_index != premier_index) fprintf (fd," ");
					if ((cla_link+next_index)->slen>=5 && strncmp((cla_link+next_index)->s+(cla_link+next_index)->slen-5,".html",5)==0) {
						// ATTENTION: n'utiliser qu'une seule instance de get_html1 par printf
						fprintf (fd,"<a href=\"%s/%s/%s\">%s",
							IDL_STRING_STR(html_dir),
							IDL_STRING_STR(target),
							IDL_STRING_STR(cla_link+next_index),
							get_html1(cla_word+next_index));
						fprintf (fd,"%s</a>",
							get_html1(cla_extra+next_index));
					} else {
						// pas de lien
						// ATTENTION: n'utiliser qu'une seule instance de get_html1 par printf
						fprintf (fd,"<span class=\"%s\" title=\"%s\">%s",
							IDL_STRING_STR(cla_type+next_index),
							IDL_STRING_STR(cla_link+next_index),
							get_html1(cla_word+next_index));
						fprintf (fd,"%s</span>",
							get_html1(cla_extra+next_index));
					}
					next_index++;
					if (next_index >= nb_clas) break;
					if (cla_noline[next_index] != cla_noline[premier_index]) break;
					if (cla_nochar[next_index] != cla_nochar[premier_index]) break;
				}

			} else {
				// 'KEYWORD_IDL', 'CALL_SYSTEM', 'CONSTANT', 'KEYWORD'
				if (strncmp(&(code->s[pos1]),(cla_word+next_index)->s,(cla_word+next_index)->slen)==0) {
					ok=1;
					fprintf (fd,"<span class=\"%s\">",IDL_STRING_STR(cla_type+next_index));
					fprintf (fd,"%s",get_html1(cla_word+next_index));
					fprintf (fd,"</span>");
				} else {
					// ex: "print,ceil(1,/$
					//     "L64)
					ok=0;
				}
				next_index++;
			}
			if (next_index < nb_clas) {
				ok = (cla_noline[next_index]!=next_cla_noline || cla_nochar[next_index]!=next_cla_nochar);
				next_cla_noline = cla_noline[next_index];
				next_cla_nochar = cla_nochar[next_index];
			} else {
				next_cla_noline = -1;
				next_cla_nochar = -1;
			}
			if (ok) {
				pos1 += (cla_word+premier_index)->slen;
				nochar += (cla_word+premier_index)->slen;
			}

		} else if (is_IDL && (c == '\'' || c == '"')) {

			// chaine sur une seule ligne en IDL

			k=0;
			string[k++] = c;
			for ( ; k+pos1<len ; ) {
				c1 = code->s[k+pos1];
				if (c1 == c) break;
				string[k++] = c1;
			}
			string[k++] = c;
			string[k] = 0;
			fprintf (fd,"<span class=\"STRING\">%s</span>",get_html2(string));

			nochar += k;	
			pos1 += k;

		} else if (is_IDL && (c == ';')) {

			// commentaire sur une seule ligne en IDL

			k=0;
			string[k++] = c;
			for ( ; k+pos1<len ; ) {
				c1 = code->s[k+pos1];
				if (c1 == 10) break;
				string[k++] = c1;
			}
			string[k] = 0;
			fprintf (fd,"<span class=\"COMMENT\">%s</span>",get_html2(string));
			pos1 += k;
			nochar = 0;

			if (next_nomsg != -1 && next_nomsg < nb_msgs) {
				if (noline == msg_noline[next_nomsg]) {
					fprintf (fd,"&nbsp;<span class=\"%s\">[%s&nbsp;%s]</span>",
						IDL_STRING_STR(msg_class+next_nomsg),
						IDL_STRING_STR(msg_txt1+next_nomsg),
						IDL_STRING_STR(msg_txt2+next_nomsg));
					next_nomsg++;
					while (next_nomsg < nb_msgs && msg_noline[next_nomsg] == noline) {
						fprintf (fd,"&nbsp;<span class=\"%s\">[%s&nbsp;%s]</span>",
							IDL_STRING_STR(msg_class+next_nomsg),
							IDL_STRING_STR(msg_txt1+next_nomsg),
							IDL_STRING_STR(msg_txt2+next_nomsg));
						next_nomsg++;
					}
				}
			}

			fprintf (fd,"\n");	// on va  la ligne suivante

			noline++;
			pos1++;

		} else if (c == 10) {

			if (next_nomsg != -1 && next_nomsg < nb_msgs) {
				if (noline == msg_noline[next_nomsg]) {
					fprintf (fd,"&nbsp;<span class=\"%s\">[%s&nbsp;%s]</span>",
						IDL_STRING_STR(msg_class+next_nomsg),
						IDL_STRING_STR(msg_txt1+next_nomsg),
						IDL_STRING_STR(msg_txt2+next_nomsg));
					next_nomsg++;
					while (next_nomsg < nb_msgs && msg_noline[next_nomsg] == noline) {
						fprintf (fd,"&nbsp;<span class=\"%s\">[%s&nbsp;%s]</span>",
							IDL_STRING_STR(msg_class+next_nomsg),
							IDL_STRING_STR(msg_txt1+next_nomsg),
							IDL_STRING_STR(msg_txt2+next_nomsg));
						next_nomsg++;
					}
				}
			}

			fprintf (fd,"\n");
			pos1++;
			noline++;
			nochar = 0;

		} else if (is_IDL && (c == '&' || c == '$')) {

			fprintf (fd,"<span class=\"KEYWORD_IDL\">%c</span>",c);
			pos1++;
			nochar++;

		} else if (is_C && (c == '\'' || c == '"')) {

			// chaine ventuellement sur plusieurs lignes en C

			for ( k=0; k+pos1<len ; ) {
				c1 = code->s[k+pos1];
				string[k++] = c1;
				if (c1==10) {
					noline++;
					nochar = 0;
				} else {
					nochar++;
				}
				if (k>=2 && c1 == c) {
					// pas vident: " est un terminateur
					//	- sauf si avant on avait \ : "\""
					//   	- mais le dernier " est un terminateur son on avait 2 \ avant: "\\"
					if (code->s[k+pos1-2]!='\\' ||code->s[k+pos1-3]=='\\' ) {
						break;
					}
				}
			}
			string[k] = 0;
			fprintf (fd,"<span class=\"STRING\">%s</span>",get_html2(string));
			pos1 += k;

		} else if (is_C && (c == '/') && (pos1+1<len) && (code->s[pos1+1] == '*')) {

			// commentaire ventuellement sur plusieurs lignes en C

			for ( k=0; k+pos1<len ; ) {
				c1 = code->s[k+pos1];
				string[k++] = c1;
				if (c1==10) {
					noline++;
					nochar = 0;
				} else {
					nochar++;
				}
				if (code->s[k+pos1-2] == '*' && c1 == '/') {
					break;
				}
			}
			string[k] = 0;
			fprintf (fd,"<span class=\"COMMENT\">%s</span>",get_html2(string));
			pos1 += k;

		} else {

			string[0] = c;
			string[1] = 0;
			fprintf (fd,"%s",get_html2(string));
			pos1++;
			nochar++;

		}

	}


	fprintf (fd, "</pre>\n");
	fprintf (fd, "</div>\n");

	fprintf (fd, "<script>\n");
	fprintf (fd, "$(\"button.call\").click(function ()         { changer_affichage_call(1-call);})\n");
	fprintf (fd, "changer_affichage_call(call);\n");
	fprintf (fd, "$(\"button.calledby\").click(function ()     { changer_affichage_calledby(1-calledby);})\n");
	fprintf (fd, "changer_affichage_calledby(calledby);\n");
	fprintf (fd, "$(\"button.vars\").click(function ()         { changer_affichage_vars(1-vars);})\n");

	fprintf (fd, "changer_affichage_vars(vars);\n");
	fprintf (fd, "$(\"button.labels\").click(function ()       { changer_affichage_labels(1-labels);})\n");
	fprintf (fd, "changer_affichage_labels(labels);\n");

	fprintf (fd, "$(\"button.commons\").click(function ()      { changer_affichage_commons(1-commons);})\n");
	fprintf (fd, "changer_affichage_commons(commons);\n");
	fprintf (fd, "</script>\n");

	fprintf (fd, "</body>\n");
	fprintf (fd, "</html>\n");

	fclose (fd);
}


/*---------------------------------------------------------------------------*/
static void lintc_code_to_c (int argc, IDL_VPTR *argv) {
/*---------------------------------------------------------------------------*/

	// ----------------------
	// Gnration "code" en c
	// ----------------------
	//
	int		nbarg=0;

	int		is_IDL			= (int)			argv[nbarg++]->value.l;
	int		is_INCLUDE		= (int)			argv[nbarg++]->value.l;
	IDL_STRING	*html_dir		= (IDL_STRING *)	&(argv[nbarg++]->value.str);
	IDL_STRING	*target			= (IDL_STRING *)	&(argv[nbarg++]->value.str);
	IDL_STRING	*nom_routine_c		= (IDL_STRING *)	&(argv[nbarg++]->value.str);
	IDL_STRING	*function_pro		= (IDL_STRING *)	&(argv[nbarg++]->value.str);
	IDL_STRING	*module			= (IDL_STRING *)	&(argv[nbarg++]->value.str);
	IDL_STRING	*name			= (IDL_STRING *)	&(argv[nbarg++]->value.str);
	IDL_STRING	*object			= (IDL_STRING *)	&(argv[nbarg++]->value.str);
	IDL_STRING	*previous		= (IDL_STRING *)	&(argv[nbarg++]->value.str);
	IDL_STRING	*next			= (IDL_STRING *)	&(argv[nbarg++]->value.str);

	IDL_STRING	*code			= (IDL_STRING *)	&(argv[nbarg++]->value.str);
	int		noligne1		= (int)			argv[nbarg++]->value.l;
	int		noligne2		= (int)			argv[nbarg++]->value.l;
	int		premiere_ligne		= (int)			argv[nbarg++]->value.l;
	int		derniere_ligne		= (int)			argv[nbarg++]->value.l;

	int		nb_prototypes		= (int)			argv[nbarg++]->value.l;
	IDL_STRING 	*prototype_name		= (IDL_STRING *)	argv[nbarg++]->value.arr->data;
	IDL_STRING 	*prototype_type		= (IDL_STRING *)	argv[nbarg++]->value.arr->data;

	IDL_STRING	*doc			= (IDL_STRING *)	&(argv[nbarg++]->value.str);

	int		nb_vars			= (int)			argv[nbarg++]->value.l;
	IDL_STRING 	*vars_type		= (IDL_STRING *)	argv[nbarg++]->value.arr->data;
	IDL_STRING 	*vars_name		= (IDL_STRING *)	argv[nbarg++]->value.arr->data;

	int		nb_labels		= (int)			argv[nbarg++]->value.l;
	IDL_STRING 	*labels_name		= (IDL_STRING *)	argv[nbarg++]->value.arr->data;

	int		nb_commons		= (int)			argv[nbarg++]->value.l;
	IDL_STRING 	*commons_common_name	= (IDL_STRING *)	argv[nbarg++]->value.arr->data;
	IDL_STRING 	*commons_var_name	= (IDL_STRING *)	argv[nbarg++]->value.arr->data;

	int		nb_cccs			= (int)			argv[nbarg++]->value.l;
	int 		*ccc_noline		= (int *) 		argv[nbarg++]->value.arr->data;
	int 		*ccc_nochar		= (int *) 		argv[nbarg++]->value.arr->data;
	IDL_STRING 	*ccc_type		= (IDL_STRING *)	argv[nbarg++]->value.arr->data;
	IDL_STRING 	*ccc_word		= (IDL_STRING *)	argv[nbarg++]->value.arr->data;
	IDL_STRING 	*ccc_extra		= (IDL_STRING *)	argv[nbarg++]->value.arr->data;
	IDL_STRING 	*ccc_link		= (IDL_STRING *)	argv[nbarg++]->value.arr->data;

	int		pos1;
	int		len;
	int		noline;
	int		nochar;
	int		nex_index;
	int		next_ccc_noline;
	int		next_ccc_nochar;
	int		next_nomsg;
	int		next_index;
	int		premier_index;
	char		c,c1;
	char		string[1024*1024];
	int		i,k;
	int		trouve;
	int		ok;

	FILE		*fd;

/*
	printf ("is_IDL = %d\n",	is_IDL);
	printf ("is_INCLUDE = %d\n",	is_INCLUDE);
	printf ("html_dir = %s\n",	IDL_STRING_STR(html_dir));
	printf ("target = %s\n",	IDL_STRING_STR(target));
	printf ("s = %s\n",		IDL_STRING_STR(s));
	printf ("nb_msgs = %d\n",	nb_msgs);
	for (i=0 ; i<nb_msgs ; i++) {
		printf (" - %d noligne=[%d] txt1=[%s] txt2=[%s] class=[%s]\n",
				i,msg_noligne[i],IDL_STRING_STR(msg_txt1+i),IDL_STRING_STR(msg_txt2+i),IDL_STRING_STR(msg_class+i));
	}
	printf ("nb_clas = %d\n",	nb_clas);
	for (i=0 ; i<nb_clas ; i++) {
		printf (" - %d noligne=[%d] nochar=[%d] type=[%s] mot=[%s] lien=[%s]\n",
				i,cla_noligne[i],cla_nochar[i],IDL_STRING_STR(cla_type+i),IDL_STRING_STR(cla_mot+i),IDL_STRING_STR(cla_lien+i));
	}
*/

	fd = fopen (IDL_STRING_STR(nom_routine_c),"w");

	// Nom FUNC/PRO
	//  ------------
	fprintf (fd, "double %s (",IDL_STRING_STR(name));


	// Prototype
	// ---------
	if (nb_prototypes) {
		for (i=0 ; i<nb_prototypes ; i++) {
			if (i) {
				fprintf (fd, ", ");
			}
			fprintf (fd, "double %s", IDL_STRING_STR(prototype_name+i));
		}
	} else {
			fprintf (fd, "void");
	}

	fprintf (fd, ") {\n");


	// Doc
	// ---
	fprintf (fd, "/*\n%s\n*/\n", IDL_STRING_STR(doc));


	// Vars
	// ----
	if (nb_vars) {
		for (i=0 ; i<nb_vars ; i++) {
			if (strcmp(IDL_STRING_STR(vars_type+i),"VAR_FOR")==0) {
				fprintf (fd, "int %s; // %s\n",IDL_STRING_STR(vars_name+i),IDL_STRING_STR(vars_type+i));
			} else {
				fprintf (fd, "double %s; // %s\n",IDL_STRING_STR(vars_name+i),IDL_STRING_STR(vars_type+i));
			}
		}
	}
	fprintf (fd, "\n");



	//  Commons
	// --------
	if (nb_commons) {
		for (i=0 ; i<nb_commons ; i++) {
			fprintf (fd, "// COMMON %s %s\n", IDL_STRING_STR(commons_common_name+i), IDL_STRING_STR(commons_var_name+i));
		}
	}

	// Code
	// ----

	len = code->slen;
	pos1 = 0;			// numro d'octet dans s (commence  0)
	noline = premiere_ligne;	// numro de ligne dans s (commence  1)
	nochar = 0;			// numro de colonne dans s (commence  0)

	next_index = 0;					// index du prochain mot  coloriser
	next_ccc_noline = ccc_noline[next_index];	// numro de ligne du prochain mot  coloriser
	next_ccc_nochar = ccc_nochar[next_index];	// numro de colonne du prochain mot  coloriser

//printf ("code=[%s]\n",IDL_STRING_STR(code));

	while (pos1 < len) {

		c = code->s[pos1];

//printf ("c=[%c(%d)] pos1=%d noline=%d nochar=%d next_ccc_noline=%d next_ccc_nochar=%d\n",c,c,pos1,noline,nochar,next_ccc_noline,next_ccc_nochar);

		if (noline == next_ccc_noline && nochar == next_ccc_nochar) {

			premier_index = next_index;

			if (strcmp(ccc_type[next_index].s,"CONSTANT")==0) {

				// 'CONSTANT'
				fprintf (fd,"%s",IDL_STRING_STR(ccc_word+next_index));
				ok = 1;
				next_index++;

			} else {

				// 'KEYWORD_IDL', 'CALL_SYSTEM', 'CONSTANT', 'KEYWORD'
				ok=1;
				fprintf (fd,"%s",IDL_STRING_STR(ccc_extra+next_index));
				next_index++;
			}

			if (next_index < nb_cccs) {
				ok = (ccc_noline[next_index]!=next_ccc_noline || ccc_nochar[next_index]!=next_ccc_nochar);
				next_ccc_noline = ccc_noline[next_index];
				next_ccc_nochar = ccc_nochar[next_index];
			} else {
				next_ccc_noline = -1;
				next_ccc_nochar = -1;
			}
			if (ok) {
				pos1 += (ccc_word+premier_index)->slen;
				nochar += (ccc_word+premier_index)->slen;
			}

		} else if (is_IDL && (c == '\'' || c == '"')) {

			k=0;
			for ( i=1; i+pos1<len ; i++) {
				c1 = code->s[i+pos1];
				if (c1 == c) break;
				if (c1=='"' || c1=='\\') string[k++] = '\\';
				if (c1=='%') string[k++] = '%';
				string[k++] = c1;
			}
			string[k] = 0;
			fprintf (fd,"\"%s\"",string);

			nochar += i+1;
			pos1 += i+1;

		} else if (is_IDL && (c == ';')) {

			k=0;
			string[k++] = c;
			for ( ; k+pos1<len ; ) {
				c1 = code->s[k+pos1];
				if (c1 == 10) break;
				string[k++] = c1;
			}
			string[k] = 0;
			fprintf (fd,"//%s",1+string);
			pos1 += k;
			nochar = 0;

			fprintf (fd,"\n");	// on va  la ligne suivante

			noline++;
			pos1++;

		} else if (c == 10) {

			fprintf (fd,"\n");
			pos1++;
			noline++;
			nochar = 0;

		} else if (is_IDL && (c == '&' || c == '$')) {

			pos1++;
			nochar++;

		} else {

			string[0] = c;
			string[1] = 0;
			fprintf (fd,"%s",string);
			pos1++;
			nochar++;

		}

	}

	fclose (fd);
}

/*---------------------------------------------------------------------------*/
static IDL_VPTR lintc_int_to_str (int argc, IDL_VPTR *argv) {
/*---------------------------------------------------------------------------*/

	int	v	=	(int)	argv[0]->value.l;

	char	ligne[1024];

	sprintf (ligne,"%d",v);

	return IDL_StrToSTRING (ligne);

}


/*---------------------------------------------------------------------------*/
int IDL_Load (void) {
/*---------------------------------------------------------------------------*/

//										MAJUSCULE OBLIGATOIRE			MINARG	MAXARG	FLAGS	EXTRA	

	// FUNCTION
	static IDL_SYSFUN_DEF2 function_addr[] = { 
		{ {lintc_sauter_espaces_tabulations},				"LINTC_SAUTER_ESPACES_TABULATIONS",	2, 	2, 	0,	0 },
		{ {lintc_get_name_idl},						"LINTC_GET_NAME_IDL",			3, 	3, 	0,	0 },
		{ {lintc_get_name_c},						"LINTC_GET_NAME_C",			3, 	3, 	0,	0 },
		{ {lintc_get_constant_c},					"LINTC_GET_CONSTANT_C",			3, 	3, 	0,	0 },
		{ {lintc_get_html},						"LINTC_GET_HTML",			1, 	1, 	0,	0 },
		{ {lintc_get_correct_line},					"LINTC_GET_CORRECT_LINE",		1, 	1, 	0,	0 },
		{ {lintc_int_to_str},						"LINTC_INT_TO_STR",			1, 	1, 	0,	0 }
	};

	// PRO
	static IDL_SYSFUN_DEF2 procedure_addr[] = { 
		{ {(IDL_SYSRTN_GENERIC) lintc_supprimer_commentaires_idl},	"LINTC_SUPPRIMER_COMMENTAIRES_IDL",	1, 	1, 	0,	0 },
		{ {(IDL_SYSRTN_GENERIC) lintc_code_to_html},			"LINTC_CODE_TO_HTML",			50, 	50, 	0,	0 },
		{ {(IDL_SYSRTN_GENERIC) lintc_code_to_c},			"LINTC_CODE_TO_C",			35, 	35, 	0,	0 }
	};


	if (!(msg_block = IDL_MessageDefineBlock("Testmodule", IDL_CARRAY_ELTS(msg_arr), msg_arr))) return IDL_FALSE;

	return	IDL_SysRtnAdd(function_addr,		TRUE,	IDL_CARRAY_ELTS(function_addr)) &&
		IDL_SysRtnAdd(procedure_addr,		FALSE,	IDL_CARRAY_ELTS(procedure_addr));


}
