/*------------------------------------------------------------------------------
 *
 *	Fichier	: $RCSfile: libxml.c,v $, v $Revision: 1.11 $
 *
 *	Date	: $Date: 2021/04/27 09:48:59 $
 *
 *	Auteur	: $Author: penou $
 *
 *	Version : %Z% version %I% de %M% du %G%
 *
 *------------------------------------------------------------------------------
 */

#include <errno.h>


#include <unistd.h>
#include <stdio.h>
#include <stdlib.h>
#include <glob.h>
#include <sys/types.h>
#include <sys/stat.h>

#ifdef GDL
#include "libgdl.h"
#else
#include "export.h"
#endif

/*-------------------------------------------------------------------------------*/
int extraire_xml_variable_valeur (char *s, char *variable, char *valeur) {
/*-------------------------------------------------------------------------------*/

	// Cherche dans s xxx="yyy" ou xxx='yyy' et met xxx dans variable et yyy dans valeur
	// Sinon, met "" dans valeur et variable
	
	int	i,j;
	int	trouve;
	char	quote='"';

	variable[0]=valeur[0]=0;

	#ifdef DEBUG
	printf ("1) s=[%s]\n",s);	
	#endif
	// Sauter les blancs
	for ( i=0 ; s[i]==' ' || s[i]==9 || s[i]==10 || s[i]==13; i++);

	#ifdef DEBUG
	printf ("2) s+i=[%s]\n",s+i);	
	#endif
	j=0;
	trouve=0;
	for ( ; s[i]; ) {
		if (s[i]=='=' && (s[i+1]=='"' || s[i+1]=='\'')) {
			variable[j]=0;
			trouve=1;
			quote = s[i+1];
			break;
		} else {
			variable[j++]=s[i++];
		}
	
	}
	if (trouve==0) {
		variable[0]=valeur[0]=0;
		return -1;
	}

	#ifdef DEBUG
	printf ("variable=[%s]\n",variable);
	#endif

	i+=2;
	#ifdef DEBUG
	printf ("3) s+i=[%s]\n",s+i);	
	#endif
	j=0;
	trouve=0;
	for ( ; s[i]; ) {
		if (s[i]==quote) {
			valeur[j]=0;
			trouve=1;
			break;
		} else {
			valeur[j++]=s[i++];
		}
	
	}
	if (trouve==0) {
		variable[0]=valeur[0]=0;
		return -1;
	}

	return i+1;


}


/*---------------------------------------------------------------------------*/
int is_vide (char *s) {
/*---------------------------------------------------------------------------*/

	int	i;

	for (i=0 ; s[i] ; s++) {
		if (s[i]!=' ' && s[i]!=9 && s[i]!=10 && s[i]!=13) return 0;
	}
	return 1;

}



/*---------------------------------------------------------------------------*/
int WC_L (int argc, void *argv[]) {
/*---------------------------------------------------------------------------*/

	char *ligne			= (char *)		argv[0];

	char	*debut=NULL,*fin,*s1,*p;
	char	noeud[1024]="";
	int	code;
	char	valeur[102400];
	char	variable[1024];
	int	nb=0;
	int	fin_noeud=0;

	for ( debut=ligne ; *debut ; ) {
		// Traitement XML: toutes les donnes sont sur une seule ligne!

		s1 = strchr (debut, '<');
		if (s1 == NULL) break;

		if (noeud[0]) {
			*s1=0;
			nb++;
			if (fin_noeud) {
				nb++;
			}
		}

		debut = s1+1;

		fin = NULL;
		s1 = strchr (debut,'>');
		if (s1 == NULL) break;
		*s1 = 0;
		fin_noeud = *(s1-1)=='/';
		fin = s1;
		sscanf (debut,"%s",noeud);
			
		p = debut+strlen(noeud);
		for ( ; ; ) {
			code = extraire_xml_variable_valeur (p,variable, valeur);
			if (code==-1) break;
			if (noeud[0]) {
				nb++;
			}
			p+=code;
		}


		debut = fin+1;
	}

	if (debut!=NULL && noeud[0]) {
		nb++;
		if (fin_noeud) {
			nb++;
		}
	}

	return nb;

}

/*---------------------------------------------------------------------------*/
int WC_L_AUTO_GLUE (
/*---------------------------------------------------------------------------*/
	void	*p01) {

	int	argc=1;
	void	*argv[1];

	argv[0] = p01;
	return WC_L (argc, argv);

}

/*---------------------------------------------------------------------------*/
int LIRE (int argc, void *argv[]) {
/*---------------------------------------------------------------------------*/

	char		*ligne			= (char *)		argv[0];
	IDL_STRING	*dataxml		= (IDL_STRING *)	argv[1]; 	/* noeud:'' variable:'' valeur:'' */
	IDL_STRING	*nexitIDL		= (IDL_STRING *) 	argv[2]; 	/* ex: "TABLEDATA" */
	int 		is_fdl			= *(int *) 		argv[3];

	#define	NOEUD		0
	#define	VARIABLE	1
	#define VALEUR		2

	char		*debut=NULL,*fin,*s1,*p;
	char		noeud[1024]="";
	int		code;
	char		valeur[102400];
	char		variable[1024];
	int		nb=0;
	int		fin_noeud=0;
	char		tmp[1024];
	char		nexit[1024]="";
	IDL_STRING	*pstring;

	strcpy (nexit,IDL_STRING_STR(nexitIDL));

	for ( debut=ligne ; *debut ; ) {

		// Traitement XML: toutes les donnes sont sur une seule ligne!

		s1 = strchr (debut, '<');
		if (s1 == NULL) break;

		if (noeud[0]) {
			*s1=0;
			if (is_vide(debut)) debut[0]=0;
			#ifdef VERBOSE
			if (debut[0]) {
				printf ("***ICI1 [<%s>] valeur=[%s]\n",noeud,debut);
			} else {
				printf ("***ICI1 [<%s>]\n",noeud);
			}
			#endif

			if (strcmp(noeud,nexit)==0) return 0;
			if (strcmp(noeud,"!--")) {
				pstring = dataxml + (nb*3+NOEUD) * (is_fdl ? 2 : 1);
				if (is_fdl) {
					sprintf		(pstring->s, "%s%c",	noeud, 255);
				} else {
					IDL_StrStore	(pstring,		noeud);
				}
				pstring = dataxml + (nb*3+VALEUR) * (is_fdl ? 2 : 1);
				if (is_fdl) {
					sprintf		(pstring->s, "%s%c",	debut, 255);
				} else {
					IDL_StrStore	(pstring,		debut);
				}
				nb++;
			}
			if (fin_noeud) {
				if (strcmp(noeud,nexit)==0) return 0;
				sprintf (tmp,"/%s",noeud);
				#ifdef VERBOSE
				printf ("*** [<%s>]\n",tmp);
				#endif
				pstring = dataxml + (nb*3+NOEUD) * (is_fdl ? 2 : 1);
				if (is_fdl) {
					sprintf		(pstring->s, "%s%c",	tmp, 255);
				} else {
					IDL_StrStore	(pstring,		tmp);
				}
				// INUTILE IDL_StrStore (dataxml+nb*3+VALEUR, "");
				nb++;
			}
		}

		debut = s1+1;

		fin = NULL;
		s1 = strchr (debut,'>');
		if (s1 == NULL) break;
		*s1 = 0;
		fin_noeud = *(s1-1)=='/';
		fin = s1;
		sscanf (debut,"%s",noeud);
			
		#ifdef DEBUG
		printf ("debut=[%s] noeud=[%s]\n",debut,noeud);
		#endif

		p = debut+strlen(noeud);
		for ( ; ; ) {
			code = extraire_xml_variable_valeur (p,variable, valeur);
			if (code==-1) break;
			if (noeud[0]) {
				if (is_vide(valeur)) valeur[0]=0;
				#ifdef VERBOSE
				if (valeur[0]) {
					printf ("***ICI2 [<%s>] variable=[%s] valeur=[%s]\n",noeud,variable,valeur);
				} else {
					printf ("***ICI2 [<%s>] variable=[%s]\n",noeud,variable);
				}
				#endif
				if (strcmp(noeud,nexit)==0) return 0;
				if (strcmp(noeud,"!--")) {
					pstring = dataxml + (nb*3+NOEUD) * (is_fdl ? 2 : 1);
					if (is_fdl) {
						sprintf		(pstring->s, "%s%c",	noeud, 255);
					} else {
						IDL_StrStore	(pstring,		noeud);
					}
					pstring = dataxml + (nb*3+VARIABLE) * (is_fdl ? 2 : 1);
					if (is_fdl) {
						sprintf		(pstring->s, "%s%c",	variable, 255);
					} else {
						IDL_StrStore	(pstring,		variable);
					}
					pstring = dataxml + (nb*3+VALEUR) * (is_fdl ? 2 : 1);
					if (is_fdl) {
						sprintf		(pstring->s, "%s%c",	valeur, 255);
					} else {
						IDL_StrStore	(pstring,		valeur);
					}
					nb++;
				}
			}
			p+=code;
		}


		debut = fin+1;
	}

	if (debut!=NULL && noeud[0]) {
		if (is_vide(debut)) debut[0]=0;
		#ifdef VERBOSE
		if (debut[0]) {
			printf ("***ICI3 [<%s>] valeur=[%s]\n",noeud,debut);
		} else {
			printf ("***ICI3 [<%s>]\n",noeud);
		}
		#endif
		if (strcmp(noeud,nexit)==0) return 0;
		if (strcmp(noeud,"!--")) {
			pstring = dataxml + (nb*3+NOEUD) * (is_fdl ? 2 : 1);
			if (is_fdl) {
				sprintf		(pstring->s, "%s%c",	noeud, 255);
			} else {
				IDL_StrStore	(pstring,		noeud);
			}
			pstring = dataxml + (nb*3+VALEUR) * (is_fdl ? 2 : 1);
			if (is_fdl) {
				sprintf		(pstring->s, "%s%c",	debut, 255);
			} else {
				IDL_StrStore	(pstring,		debut);
			}
			nb++;
		}
		if (fin_noeud) {
			if (strcmp(noeud,nexit)==0) return 0;
			sprintf (tmp,"/%s",noeud);
			#ifdef VERBOSE
			printf ("*** [<%s>]\n",tmp);
			#endif
			pstring = dataxml + (nb*3+NOEUD) * (is_fdl ? 2 : 1);
			if (is_fdl) {
				sprintf		(pstring->s,"%s%c",	tmp, 255);
			} else {
				IDL_StrStore	(pstring,		tmp);
			}
			// INUTILE IDL_StrStore (dataxml+nb*3+VALEUR, "");
			nb++;
		}
	}

	return 0;

}

/*---------------------------------------------------------------------------*/
int LIRE_AUTO_GLUE (
/*---------------------------------------------------------------------------*/
	void	*p01,
	void	*p02,		// tableau de structure avec 3 champs de STRING: NOEUD, VARIABLE, VALEUR
	void	*p_nexitIDL,	// un STRING
	void	*p04) {

	int		argc=4;
	void		*argv[4];
	int		code;
	IDL_STRING	*nexitIDL;

	// p_nexitIDL -> nexitIDL
	nexitIDL = malloc (sizeof(IDL_STRING));
	IDL_StrStore (nexitIDL, p_nexitIDL);

	argv[0] = p01;
	argv[1] = p02;
	argv[2] = nexitIDL;
	argv[3] = p04;
	code = LIRE (argc, argv);

	return code;

}
