/*------------------------------------------------------------------------------
 *
 *	Fichier	: $RCSfile: interpoler2dy.c,v $, v $Revision: 1.11 $
 *
 *	Date	: $Date: 2021/04/27 09:48:59 $
 *
 *	Auteur	: $Author: penou $
 *
 *	Version : %Z% version %I% de %M% du %G%
 *
 *------------------------------------------------------------------------------
 */


#include <math.h>
#include <stdio.h>
#include <stdlib.h>

#include "infini.h"

/*---------------------------------------------------------------------------*/
int interpoler1d (
	float *tabymin, float *taby, float *tabymax, 
	float *tabz, 
	float ymin, float dy,
	int nb, int nby, float *tab, float infini) {
/*---------------------------------------------------------------------------*/

	/*
	Dimensions des tableaux:
		tabymin[nb]
		taby[nb]
		tabymax[nb]
		tab[nby]

	infini contient la valeur de Infini.
	*/

	int i;
	float kdebreel,kfinreel,*tabcoeff,yvrai;
	int kdebentier,kdeb,kfinentier,n,k,kfin;

	/* Cas ou l'on ne peut pas interpoler */
	if (nb==1) {
		k = (int)((taby[0]-ymin)/dy-0.5+0.5);
		if ((k >= 0) && (k <= nby-1))
			tab[k] = tabz[0];
	}

	/* Calcul du reel kdebreel tel que miny+(0.5+kdebreel)*dy=y(0) */
	kdebreel = (taby[0]-ymin)/dy-0.5;

	/* Calcul du plus petit entier kdebentier tel que kdebentier>=kdebreel */
	kdebentier = kdebreel;
	if (kdebreel > 0)
		if (kdebentier != kdebreel)
			kdebentier++;

	/* Calcul du plus petit entier kdeb tel que kdeb>=kdebentier et kdeb>=0 */
	kdeb = (kdebentier>0 && kdebentier<nby-1) ? kdebentier : 0;

	if (kdeb > nby-1)
		return 0;

	/* Calcul du reel kfinreel tel que miny+(0.5+kfinreel)*dy=y(nb-1) */
	kfinreel = (taby[nb-1]-ymin)/dy-0.5;

	/* Calcul du plus grand entier kfinentier tel que kfinentier<=kfinreel */
	kfinentier = kfinreel;
	if (kfinreel < 0)
		if (kfinentier != kfinreel)
			kfinentier++;

	/* Calcul du plus grand entier kfin tel que kfin<=kfinentier et kfin<=nby-1 */
	kfin = (kfinentier>0 && kfinentier<nby-1) ? kfinentier : nby-1;

	if ((tabcoeff = (float *)malloc((nb-1)*sizeof(float))) == NULL) return -1;
	for (i=0;i<nb-1;i++) {
		if (fini(tabz[i],infini) && fini(tabz[i+1],infini)) {
			tabcoeff[i] = (tabz[i]-tabz[i+1])/(taby[i]-taby[i+1]);
		} else {
			tabcoeff[i] = infini;
		}
	}

	n = 0;
	yvrai=ymin+(0.5+kdeb)*dy;
	/* On boucle de kdeb a kfin */
	for (k=kdeb;k<=kfin;k++) {
		for (;yvrai>taby[n+1];n++);
		if (fini(tabz[n],infini)) {
			if (fini(tabcoeff[n],infini)) {
				tab[k] = tabz[n]+tabcoeff[n]*(yvrai-taby[n]);
			} else if (yvrai<=tabymax[n]) {
				tab[k] = tabz[n];
			}
		} else if ((n<nb-1) && (fini(tabz[n+1],infini)) && (yvrai>=tabymin[n+1])) {
			tab[k] = tabz[n+1];
		}
		yvrai += dy;
	}

	free(tabcoeff);

	return 0;

}


/*---------------------------------------------------------------------------*/
int INTERPOLER2DY (int argc, void *argv[]) {
/*---------------------------------------------------------------------------*/


	int	*x1_data	= (int *)	argv[0];
	int	*x2_data	= (int *)	argv[1];
	int	*xf_data	= (int *)	argv[2];
	int	nbx_xdata	= *(int *)	argv[3];
	float	*Ymin_data	= (float *)	argv[4];
	float	*Ymoy_data	= (float *)	argv[5];
	float	*Ymax_data	= (float *)	argv[6];
	int	nbx_ydata	= *(int *)	argv[7];
	int	nby_ydata	= *(int *)	argv[8];
	int	*indY		= (int *)	argv[9];
	float	*Zdata		= (float *)	argv[10];
	float	*image		= (float *)	argv[11];
	int	*nb		= (int *)	argv[12];
	int	*utilise	= (int *)	argv[13];
	int	nbx		= *(int *)	argv[14];
	int	nby		= *(int *)	argv[15];
	float	ymin		= *(float *)	argv[16];
	float	dy		= *(float *)	argv[17];
	int	moyenner	= *(int *)	argv[18];
	float	infini		= *(float *)	argv[19];
	short	*produitdata	= (short *)	argv[20];
	float	*produitimage	= (float *)	argv[21];

	int x_data,x_image,j;

	float *taby,*tabymax,*tabymin,*tabz,*tab;
	int nby1_data;

	if ((taby=(float *)malloc((2+nby_ydata)*sizeof(float))) == NULL)	return -1;
	if ((tabymin=(float *)malloc((2+nby_ydata)*sizeof(float))) == NULL)	return -1;
	if ((tabymax=(float *)malloc((2+nby_ydata)*sizeof(float))) == NULL)	return -1;
	if ((tabz=(float *)malloc((2+nby_ydata)*sizeof(float))) == NULL)	return -1;
	if ((tab=(float *)malloc(nby*sizeof(float))) == NULL)			return -1;

	for (x_data=0 ; x_data<nbx_xdata ; x_data++) {

		if (indY[x_data]==-1) /* Table d'energie inconnue: on ne peut rien faire */
			continue;

		if (xf_data[x_data]==0)
			continue;

		for (j=0;j<nby_ydata;j++) {
			if (nonfini(Ymoy_data[indY[x_data]+nbx_ydata*j],infini)) {
				break;
			} else {
				tabymin[1+j] = Ymin_data[indY[x_data]+nbx_ydata*j];
				taby[1+j]    = Ymoy_data[indY[x_data]+nbx_ydata*j];
				tabymax[1+j] = Ymax_data[indY[x_data]+nbx_ydata*j];
				tabz[1+j]    = Zdata[x_data+nbx_xdata*j];
			}
		}
		nby1_data = j;

		tabymin[0] = tabymin[1]; 
		taby[0]    = tabymin[1]; 
		tabymax[0] = tabymax[1]; 
		tabz[0]    = tabz[1];

		tabymin[nby1_data+1] = tabymin[nby1_data];
		taby[nby1_data+1]    = tabymax[nby1_data];
		tabymax[nby1_data+1] = tabymax[nby1_data];
		tabz[nby1_data+1]    = tabz[nby1_data];

		for (j=0 ; j<nby ; j++) {
			tab[j]=infini;
		}

		if (interpoler1d(tabymin,taby,tabymax,tabz,ymin,dy,nby1_data+2,nby,tab,infini)==-1) {
			return -1;
		}

		for (x_image=x1_data[x_data] ; x_image<=x2_data[x_data] ; x_image++) {

			if (moyenner==0 && utilise[x_image])
				continue;

			if (!fini(produitimage[x_image],infini)) {
				produitimage[x_image] = produitdata[x_data];
			}
			utilise[x_image] = 1;
			for (j=0 ; j<nby ; j++) {
				if (!moyenner) {
					nb[x_image+nbx*j] = 1;
					if (fini(tab[j],infini) && nonfini(image[x_image+nbx*j],infini)) {
						image[x_image+nbx*j] = tab[j];
					}
				} else if (fini(tab[j],infini)) {
					nb[x_image+nbx*j]++;
					if (nonfini(image[x_image+nbx*j],infini)) {
						image[x_image+nbx*j] = tab[j]; /* Premier acces */
					} else {
						image[x_image+nbx*j] += tab[j];
					}
				}
			}
		}
	}

	free(taby);
	free(tabymin);
	free(tabymax);
	free(tabz);
	free(tab);

	return 0;

}

/*---------------------------------------------------------------------------*/
int INTERPOLER2DY_AUTO_GLUE (
/*---------------------------------------------------------------------------*/
	void	*p01,
	void	*p02,
	void	*p03,
	void	*p04,
	void	*p05,
	void	*p06,
	void	*p07,
	void	*p08,
	void	*p09,
	void	*p10,
	void	*p11,
	void	*p12,
	void	*p13,
	void	*p14,
	void	*p15,
	void	*p16,
	void	*p17,
	void	*p18,
	void	*p19,
	void	*p20,
	void	*p21,
	void	*p22) {

	int	argc=22;
	void	*argv[22];

	argv[ 0] = p01;
	argv[ 1] = p02;
	argv[ 2] = p03;
	argv[ 3] = p04;
	argv[ 4] = p05;
	argv[ 5] = p06;
	argv[ 6] = p07;
	argv[ 7] = p08;
	argv[ 8] = p09;
	argv[ 9] = p10;
	argv[10] = p11;
	argv[11] = p12;
	argv[12] = p13;
	argv[13] = p14;
	argv[14] = p15;
	argv[15] = p16;
	argv[16] = p17;
	argv[17] = p18;
	argv[18] = p19;
	argv[19] = p20;
	argv[20] = p21;
	argv[21] = p22;
	return INTERPOLER2DY (argc, argv);

}

