/*------------------------------------------------------------------------------
 *
 *	Fichier	: $RCSfile: interpoler2d_points.c,v $, v $Revision: 1.9 $
 *
 *	Date	: $Date: 2021/04/27 09:48:59 $
 *
 *	Auteur	: $Author: penou $
 *
 *	Version : %Z% version %I% de %M% du %G%
 *
 *------------------------------------------------------------------------------
 */


#include <math.h>
#include <stdio.h>
#include <stdlib.h>

#include "infini.h"

#define indice2(i1,i2,nb1,nb2)		((i1)+(nb1)*(i2))
#define indice3(i1,i2,i3,nb1,nb2,nb3)	((i1)+(nb1)*((i2)+(nb2)*(i3)))


/*---------------------------------------------------------------------------*/
int corriger (int x, int deb, int fin) {
/*---------------------------------------------------------------------------*/

	if (x<deb) return deb;
	if (x>fin) return fin;
	return x;

}

/*---------------------------------------------------------------------------*/
void Init_starty_endy (int nbx, int nby, int *starty, int *endy) {
/*---------------------------------------------------------------------------*/

	int x;

	for (x=0;x<nbx;x++) {
		starty[x] = nby;
		endy[x]   = -1;
	}

}


/*---------------------------------------------------------------------------*/
void InitSegment (int x1, int y1, int x2,int y2, int nbx, int nby,
	int *starty, int *endy) {
/*---------------------------------------------------------------------------*/

	int x,y,tmp;
	double pas,val;

	if (x2<x1) {
		tmp=y1; y1=y2; y2=tmp;
		tmp=x1; x1=x2; x2=tmp;
	}

	pas = x1==x2 ? 0 : (double)(y2-y1)/(double)(x2-x1);

	val = y1;
	for (x=x1;x<=x2;x++) {
		if (x>=0 && x<=nbx-1) {
			y = val;
			y = corriger (y,0,nby-1);
			if (y<starty[x]) starty[x] = y;
			if (y>endy[x]) endy[x]=y;
		}
		val += pas;
	}

}


/*---------------------------------------------------------------------------*/
void polygone (int i2, int tabi3[4],
	int nbx, int nby, int *starty, int *endy,
	double *x, double *y, float *z,
	double xmin, double ymin, double dx, double dy,
	int *noxmin, int *noxmax, float *z0) {
/*---------------------------------------------------------------------------*/

	int i,ind1,ind2;
	double x1,y1,x2,y2;
	int x1p,y1p,x2p,y2p;

	*noxmin=nbx;
	*noxmax=-1;
	Init_starty_endy (nbx, nby, starty, endy);
	for (i=0;i<4;i++) { 
		/* 4: description d'un polygone par ces 4 cotes */
		ind1 = tabi3[i];
		ind2 = i==3 ? tabi3[0] : tabi3[i+1];
		x1 = x[ind1]; y1 = y[ind1];
		x2 = x[ind2]; y2 = y[ind2];
		x1p = (x1-xmin)/dx; y1p = (y1-ymin)/dy;
		x2p = (x2-xmin)/dx; y2p = (y2-ymin)/dy;
		if (x1p<*noxmin) *noxmin=x1p;
		if (x2p>*noxmax) *noxmax=x2p;
		InitSegment (x1p, y1p, x2p, y2p, nbx, nby, starty, endy);
	}
	*noxmin = corriger (*noxmin, 0, nbx-1);
	*noxmax = corriger (*noxmax, 0, nbx-1);
	*z0 = z[i2];

}


/*---------------------------------------------------------------------------*/
int NONINTERPOLER2D_POINTS (int argc, void *argv[]) {
/*---------------------------------------------------------------------------*/

	double	*x	= (double *)	argv[0]; /* x[9,nb1,nb2]: x[i,j]=x[i+j*9] */
	double	*y	= (double *)	argv[1]; /* y[9,nb1,nb2]: y[i,j]=y[i+j*9] */
	float	*z	= (float *)	argv[2]; /* z[nb1,nb2] */
	int	nb1	= *(int *)	argv[3];
	int	nb2	= *(int *)	argv[4];
	double	xmin	= *(double *)	argv[5];
	double	xmax	= *(double *)	argv[6];
	int	nbx	= *(int *)	argv[7];
	float	ymin	= *(float *)	argv[8];
	float	ymax	= *(float *)	argv[9];
	int	nby	= *(int *)	argv[10];
	float	*image	= (float *)	argv[11]; /* image[nbx,nby]: image[i,j]=image[i+j*nbx] */

	double dx, dy;
	int no1,no2,nox,noy,noxmin,noxmax;
	float z0;
	int *starty,*endy;
	int i2,i3,tabi3[4];

	/*

	*             2 --------------- 1
	*	      /|             /|
	*	     / |            / |
	*	    /  |           /  |
	*	   /   |          /   |
	*	 3 ----|---------/ 0  |
	*	  |    |         |    |
	*	  |  6 ----------|----/ 5
	*	  |   /          |   /
	*	  |  /           |  /
	*	  | /            | /
	*	  |/             |/
	*	7  -------------- 4

	*/

	/* Definitions des 6 facettes du cube */
	int info[6][4] = {	{0,1,2,3},
				{4,5,6,7},
				{0,1,5,4},
				{2,1,5,6},
				{3,2,6,7},
				{3,0,4,7}};

	int i;

	dx = (xmax-xmin)/nbx;
	dy = (ymax-ymin)/nby;

	if ((starty = (int *)malloc(nbx*sizeof(starty))) == NULL) return -1;
	if ((endy = (int *)malloc(nbx*sizeof(int))) == NULL) return -1;

	for (no1=0 ; no1<nb1 ; no1++) {

		for (no2=0 ; no2<nb2 ; no2++) {

			i2 = indice2(no1,no2,nb1,nb2); /* indice de z[no1,no2] */
			i3 = indice3(0,no1,no2,9,nb1,nb2); /* indice de x[0,no1,no2] */

			for (i=0 ; i<6; i++) {

				tabi3[0]=i3+info[i][0];
				tabi3[1]=i3+info[i][1];
				tabi3[2]=i3+info[i][2];
				tabi3[3]=i3+info[i][3];
				polygone (i2, tabi3, nbx, nby, starty, endy, x, y, z, xmin, ymin, dx, dy, &noxmin, &noxmax, &z0);
				for (nox=noxmin ; nox<=noxmax ; nox++) {
					for (noy=starty[nox] ; noy<=endy[nox] ; noy++) {
						image[nox+noy*nbx] = z0;
					}
				}

			}
		}

	}

	free (starty);
	free (endy);

	return 0;

}

/*---------------------------------------------------------------------------*/
int NONINTERPOLER2D_POINTS_AUTO_GLUE (
/*---------------------------------------------------------------------------*/
	void	*p01,
	void	*p02,
	void	*p03,
	void	*p04,
	void	*p05,
	void	*p06,
	void	*p07,
	void	*p08,
	void	*p09,
	void	*p10,
	void	*p11,
	void	*p12) {

	int	argc=12;
	void	*argv[12];

	argv[ 0] = p01;
	argv[ 1] = p02;
	argv[ 2] = p03;
	argv[ 3] = p04;
	argv[ 4] = p05;
	argv[ 5] = p06;
	argv[ 6] = p07;
	argv[ 7] = p08;
	argv[ 8] = p09;
	argv[ 9] = p10;
	argv[10] = p11;
	argv[11] = p12;
	return NONINTERPOLER2D_POINTS (argc, argv);

}
