/*------------------------------------------------------------------------------
 *
 *	Fichier	: $RCSfile: get_data3d.c,v $, v $Revision: 1.205 $
 *
 *	Date	: $Date: 2021/09/20 08:59:57 $
 *
 *	Auteur	: $Author: penou $
 *
 *	Version : %Z% version %I% de %M% du %G%
 *
 *------------------------------------------------------------------------------
 */

// pour utiliser pow10f() et log10f() qui sont plus rapides que pow() et log()
#define _GNU_SOURCE
#define LOG10f(x) log10f(x)
#if defined (__WIN32__) || defined (__WIN64__) || defined (__APPLE__)
#define POW10f(x) powf(10,x)
#else
#define POW10f(x) pow10f(x)
#endif

#include <math.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#ifdef GDL
#include "libgdl.h"
#else
#include "export.h"
#endif


#include "infini.h"

#if defined (__linux__) || defined (__APPLE__)
	#define FINITE(x) finite(x)
#else
	#ifdef __WIN64__
	#include <ieeefp.h>
	#endif
	#define FINITE(x) finite(x)
#endif

#define indice2(i1,i2,nb1,nb2)				((i1)+(nb1)*(i2))
#define indice3(i1,i2,i3,nb1,nb2,nb3)			((i1)+(nb1)*((i2)+(nb2)*(i3)))
#define indice4(i1,i2,i3,i4,nb1,nb2,nb3,nb4)		((i1)+(nb1)*((i2)+(nb2)*((i3)+(nb3)*(i4))))
#define indice5(i1,i2,i3,i4,i5,nb1,nb2,nb3,nb4,nb5)	((i1)+(nb1)*((i2)+(nb2)*((i3)+(nb3)*((i4)+(nb4)*(i5)))))

//#define indice2_new(i1,i2,nb1,nb2)			((i1)+(i2)*(nb1))
#define indice3_new(i1,i2,i3,nb1,nb2,nb3)		((i1)+(i2)*(nb1)+(i3)*(nb1)*(nb2))
//#define indice4_new(i1,i2,i3,i4,nb1,nb2,nb3,nb4)	((i1)+(i2)*(nb1)+(i3)*(nb1)*(nb2)+(i4)*(nb1)*(nb2)*(nb3))
//#define indice5_new(i1,i2,i3,i4,i5,nb1,nb2,nb3,nb4,nb5)	((i1)+(i2)*(nb1)+(i3)*(nb1)*(nb2)+(i4)*(nb1)*(nb2)*(nb3)+(i5)*(nb1)*(nb2)*(nb3)*(nb4))

typedef unsigned char 			byte1;
typedef unsigned short			byte2;
typedef unsigned int			byte4;

#define is_CODIF(x)			(x==1)
#define is_HIA(x)			(x==2)
#define is_ELS(x)			(x==8 || x==20)
#define is_NPI(x)			(x==9 || x==21)
#define is_NPD1(x)			(x==10 || x==22)
#define is_NPD2(x)			(x==11 || x==23)
#define is_IMA(x)			(x==12 || x==24)
#define	is_DSP(x)			(x==15)
#define is_IMA_ASPERA3(x)		(x==12)
#define is_IMA_ASPERA4(x)		(x==24)
#define is_STEREO_SWEA(x)		(x==4)
#define is_DEMETER_IDP(x)		(x==16)
#define is_MAVEN_SWEA(x)		(x==67)
#define is_MAVEN_SWIA(x)		(x==70)
#define is_MMS_DES(x)			(x==88)
#define is_MMS_DIS(x)			(x==90)
#define is_JUNO_JADEE(x)		(x==84)
#define is_SOLAR_PAS(x)			(x==111)

#define MIN(x,y)			((x) <= (y) ? (x) : (y))
#define MAX(x,y)			((x) > (y) ? (x) : (y))

int	sauve_int;
#define PUSH_int(x)			sauve_int = x;
#define POP_int(x)			x = sauve_int;

double	sauve_double;
#define PUSH_double(x)			sauve_double = x;
#define POP_double(x)			x = sauve_double;

double	sauve_float;
#define PUSH_float(x)			sauve_float = x;
#define POP_float(x)			x = sauve_float;

#define CARRE(x)			((x)*(x))

#define FILLVAL_E30			1E30
#define FILLVAL_E31			1E31

float					val_demeter[256];
float					ratio_demeter[255];
float					demeter_histo_canal_prec;

#include <sys/time.h>


/*---------------------------------------------------------------------------*/
double nbsec (void) {
/*---------------------------------------------------------------------------*/

	struct timeval tv;
	struct timezone tz;
	gettimeofday (&tv,&tz);
	return tv.tv_sec+tv.tv_usec/1000000.;

}


/*---------------------------------------------------------------------------*/
#define DEBUT() 																						\
/*---------------------------------------------------------------------------*/															\
	int		TYPE_EFF		= TABINFO_INT[ 0];																\
	int		TYPE_FG			= TABINFO_INT[ 1];																\
	int		nbspins			= TABINFO_INT[ 2];																\
	int 		nbenergies		= TABINFO_INT[ 3];																\
	int 		nbspectres		= TABINFO_INT[ 4];																\
	int 		nbcellules		= TABINFO_INT[ 5];																\
	int 		nbangles		= TABINFO_INT[ 6];																\
	int 		nbmasses		= TABINFO_INT[ 7];																\
	int 		nbsensitivity		= TABINFO_INT[ 8];																\
	int 		nocis			= TABINFO_INT[ 9];																\
	int 		cjf			= TABINFO_INT[10];																\
	int 		respect_solid		= TABINFO_INT[11];																\
	int 		spin_average		= TABINFO_INT[12];																\
	int 		prodmin			= TABINFO_INT[13];																\
	int 		prodmax			= TABINFO_INT[14];																\
	int 		B			= TABINFO_INT[15];																\
	int 		nbtablesE		= TABINFO_INT[16];																\
	int 		nbtablesP		= TABINFO_INT[17];																\
	int 		optimise		= TABINFO_INT[18];																\
	int 		remove_bad_channel	= TABINFO_INT[19];																\
	int 		remove_hghost		= TABINFO_INT[20];																\
	int 		ordre_cluster		= TABINFO_INT[21];																\
	int 		nox			= TABINFO_INT[22];																\
	int 		noy			= TABINFO_INT[23];																\
	int 		noz			= TABINFO_INT[24];																\
	int 		noxx			= TABINFO_INT[25];																\
	int 		noxy			= TABINFO_INT[26];																\
	int 		noxz			= TABINFO_INT[27];																\
	int 		noyy			= TABINFO_INT[28];																\
	int 		noyz			= TABINFO_INT[29];																\
	int 		nozz			= TABINFO_INT[30];																\
	int 		use_long_var		= TABINFO_INT[31];																\
	int 		use_one_count_level	= TABINFO_INT[32];																\
	int 		is_pad			= TABINFO_INT[33];																\
	double 		energymin		= TABINFO_DOUBLE[ 0];																\
	double 		energymax		= TABINFO_DOUBLE[ 1];																\
	double 		amin			= TABINFO_DOUBLE[ 2];																\
	double 		amax			= TABINFO_DOUBLE[ 3];																\
	double 		ELECTRONVOLT		= TABINFO_DOUBLE[ 4];																\
	double 		level			= TABINFO_DOUBLE[ 5];																\
	double 		level2			= TABINFO_DOUBLE[ 6];																\
	double 		hghost_k1		= TABINFO_DOUBLE[ 7];																\
	double 		hghost_k2		= TABINFO_DOUBLE[ 8];																\
	double 		F_INFINITY		= TABINFO_DOUBLE[ 9];																\
	double		FILLVAL			= TABINFO_DOUBLE[10];																\
	double		COUNTFACTOR		= TABINFO_DOUBLE[11];																\
	double 		bgnd_e_remove		= TABINFO_DOUBLE[12];																\
	byte1		*p1;																					\
	byte2		*p2=NULL;																				\
	byte4		*p4;																					\
	float		*pfloat;																				\
	double		*pdouble;																				\
	int		ienergie=0;																				\
	int		itable=0;																				\
	int		icarte=0;																				\
	int		ispin=0;																				\
	int		ispectre=0;																				\
	int		icellule=0;																				\
	int		isensitivity=0;																				\
	unsigned char 	*pollution=(unsigned char *)malloc(nbangles);																\
	unsigned char	*okspectre=(unsigned char *)malloc(nbspectres);																\
	unsigned char 	*angle_used=(unsigned char *)malloc(nbangles);																\
	int		accumulation=0;																				\
	int		*sector=NULL;																				\
	double		eff=0; /* gcc */																			\
	double		fg=0; /* gcc */																				\
	float		denom;																					\
	int		lire_eff= (cjf>=C_SEC) && (cjf!=FDIST_TO_FDIST) && (cjf!=FLUX_TO_FLUX) && (cjf!=JE_TO_JE) && (cjf<=0xff);								\
	int		lire_fg= (cjf>=FLUX) && (cjf!=FDIST_TO_FDIST) && (cjf!=FLUX_TO_FLUX) && (cjf!=JE_TO_JE) && (cjf<=0xff);									\
	int		div_cjf= ((cjf&0xff)>=FLUX && (cjf&0xff)!=FLUX_INTEGRAL && (cjf&0xff)!=FDIST_TO_FLUX_INTEGRAL && (cjf&0xff)!=FLUX_TO_FLUX_INTEGRAL && (cjf&0xff)!=JE_TO_FLUX_INTEGRAL);	\
	unsigned char	*list_theta;																				\
	unsigned char	*list_phi;																				\
	int		iangle;																					\

/*---------------------------------------------------------------------------*/
#define FIN() 										\
/*---------------------------------------------------------------------------*/		\
	free (okspectre);								\
	free (pollution);								\
	free (angle_used);


/*
	TYPE_EFF:
		1: fonction(isensitivity,icellule,itable,ienergie,imasse)	DEFAUT
		2: fonction(icellule,ispectre,ienergie)				STEREO_SWEA + INTERBALL_ELEC12
		3: fonction(icellule,ispectre,ispin)				THEMIS_ESST + THEMIS_ISST
		4: fonction(icellule,ispectre,itable,ienergie)			MAVEN_SWEA
		5: fonction(icellule,ispectre,idataid)				BEPI_MEA1 + BEPI_MEA2
*/

#define get_eff_1 efficacite[indice5(isensitivity,icellule,itable,ienergie,imasse,	nbsensitivity,nbcellules,nbtablesE,nbenergies,nbmasses)]
#define get_eff_2 efficacite[indice3(icellule,ispectre,ienergie,			nbcellules,nbspectres,nbenergies)]
#define get_eff_3 efficacite[indice3(icellule,ispectre,ispin,				nbcellules,nbspectres,nbspins)]
#define get_eff_4 efficacite[indice4(ispectre,icellule,itable,ienergie,			nbspectres,nbcellules,nbtablesE,nbenergies)]
#define get_eff_5 efficacite[indice3(icellule,ispectre,idataid,				nbcellules,nbspectres,2)]

#define get_eff (TYPE_EFF==1?(get_eff_1):(TYPE_EFF==2?(get_eff_2):(TYPE_EFF==3?(get_eff_3):(TYPE_EFF==4?(get_eff_4):(get_eff_5)))))


/*
	TYPE_FG:
		1: fonction(isensitivity,icellule,itable,ienergie)		DEFAUT
		2: fonction(ienergie,icellule,ispectre,ipac)			ASPERA3_IMA + ASPERA4_IMA
		3: fonction(ienergie,ispin)					THEMIS_ESST + THEMIS_ISST + INTERBALL_ION12
		4: fonction(icellule,ispectre)					STEREO_SWEA + INTERBALL_ELEC12
		5: fonction(ispectre,itable,ienergie)				JUNO_JADEE
		6: fonction(icellule,ispectre,itable,ienergie)			MAVEN_SWEA
		7: fonction(icellule,ispectre,igeomfactor,idataid)		BEPI_MEA1 + BEPI_MEA2
*/

#define get_fg_1 facteurG[indice4(isensitivity,icellule,itable,ienergie,	nbsensitivity,nbcellules,nbtablesE,nbenergies)]
#define get_fg_2 facteurG[indice4(ienergie,icellule,ispectre,ipac,		nbenergies,nbcellules,nbspectres,INUTILE)]
#define get_fg_3 facteurG[indice2(ienergie,ispin,				nbenergies,nbspins)]
#define get_fg_4 facteurG[indice2(icellule,ispectre,				nbcellules,nbspectres)]
#define get_fg_5 facteurG[indice3(ispectre,itable,ienergie,			nbspectres,nbtablesE,nbenergies)]
#define get_fg_6 facteurG[indice4(ispectre,icellule,itable,ienergie,		nbspectres,nbcellules,nbtablesE,nbenergies)]
#define get_fg_7 facteurG[indice4(icellule,ispectre,igeomfactor,idataid,	nbcellules,nbspectres,9,2)]

/* fg en (m2.ster.(eV/eV)) */
#define get_fg (TYPE_FG==1?(get_fg_1):(TYPE_FG==2?(get_fg_2):(TYPE_FG==3?(get_fg_3):(TYPE_FG==4?(get_fg_4):(TYPE_FG==5?(get_fg_5):(TYPE_FG==6?(get_fg_6):(get_fg_7)))))))


/* E en eV */
#define get_E Emoy[indice2(itable,ienergie,nbtablesE,nbenergies)] * Q[imasse]

/* dE en eV */
#define get_dE (Emax[indice2(itable,ienergie,nbtablesE,nbenergies)] - Emin[indice2(itable,ienergie,nbtablesE,nbenergies)]) * Q[imasse]


#define	COUNT			 0
#define	COUNT_SPIN		 1
#define	COUNT_SEC		 2
#define	C_SEC			 3
#define	FLUX			 4
#define	FDIST			 5
#define	JE			 6
#define	FLUX_ALGO		 7
#define	FLUX_INTEGRAL		 8
#define	C_SEC_TARANIS		 9

#define	FDIST_TO_FLUX		10	// ex: MMS_DES pour passer de FDIST  FLUX
#define	FDIST_TO_FDIST		11	// ex: MMS_DES pour passer de FDIST  FDIST
#define	FDIST_TO_JE		12	// ex: MMS_DES pour passer de FDIST  JE
#define	FDIST_TO_FLUX_INTEGRAL	13	// ex: MMS_DES pour passer de FDIST  FLUX_INTEGRAL

#define	FLUX_TO_FLUX		14	// ex: MMS-FEEPSE pour passer de FLUX  FLUX
#define	FLUX_TO_FDIST		15	// ex: MMS-FEEPSE pour passer de FLUX  FDIST
#define	FLUX_TO_JE		16	// ex: MMS-FEEPSE pour passer de FLUX  JE
#define	FLUX_TO_FLUX_INTEGRAL	17	// ex: MMS-FEEPSE pour passer de FLUX  FLUX_INTEGRAL

#define	JE_TO_FLUX		18	// ex: MAVEN-SWEACDF pour passer de JE  FLUX
#define	JE_TO_FDIST		19	// ex: MAVEN-SWEACDF pour passer de JE  FDIST				
#define	JE_TO_JE		20	// ex: MAVEN-SWEACDF pour passer de JE  JE				
#define	JE_TO_FLUX_INTEGRAL	21	// ex: MAVEN-SWEACDF pour passer de JE  FLUX_INTEGRAL

/* 

	cjf:	0 = coups bruts / echantillon
		1 = coups bruts / spin
		2 = coups bruts / seconde
		3 = coups corriges / seconde
		4 = flux (en part/(sec.cm2.sr.keV))
		5 = fonction de distribution (en sec3/km6)
		6 = flux*energie (en keV/(sec.cm2.sr.keV))

	Pour la dernire nergie, le coup doit tre multipli par COUNTFACTOR
	(ex CODIF, HIA et DSP sauf mode RPA:
		EN MODE 16 ENERGIES, duree DOIT ETRE DIVISE PAR 2 POUR LA
		DERNIERE ENERGIE (LA PLUS FAIBLE) => LE COUP/SEC DOIT DONC ETRE 
		MULTIPLIE PAR 2

		EN MODE 8 ENERGIES, duree DOIT ETRE DIVISE PAR 4/3 POUR LA
		DERNIERE ENERGIE (LA PLUS FAIBLE) => LE COUP/SEC DOIT DONC ETRE 
		MULTIPLIE PAR 4/3
	)
*/

// noscc = numro spectre-cellule-carte
#define noscc indice3_new(ispectre,icellule,icarte,nbspectres,nbcellules,INUTILE)

// nocoup = indice pour accder au comptage (ienergie, ispectre, icellule, icarte, imasse)
#define nocoup indice3_new(ienergie,solid[noscc],imasse,nbenergies,nbangles,nbmasses)


// (size_t) pour 64 bits
#define get_p1(tabdata,no)	(byte1 *) (tabdata+(size_t)fin[1]*(size_t)(no+ispin)+debut[1])
#define get_p2(tabdata,no)	(byte2 *) (tabdata+(size_t)fin[2]*(size_t)(no+ispin)+debut[2])
#define get_p4(tabdata,no)	(byte4 *) (tabdata+(size_t)fin[4]*(size_t)(no+ispin)+debut[4])
#define get_pfloat(tabdata,no)	(float *) (tabdata+(size_t)fin[4]*(size_t)(no+ispin)+debut[4])
#define get_pdouble(tabdata,no)	(double *)(tabdata+(size_t)fin[4]*(size_t)(no+ispin)+debut[4])

/*---------------------------------------------------------------------------*/
#define GET_DENOM_DEADTIME() 																\
/*---------------------------------------------------------------------------*/										\
	if (deadtime[0]==0) { /* pour aller plus vite sur Cluster par exemple */									\
		denom = 1.0;																\
	} else {																	\
		denom = 1-deadtime[0]*val/(sector[noscc]*accumulation_duree); /* temps-mort */								\
		if (denom<deadtime[1]) denom=deadtime[1];												\
	}


/*---------------------------------------------------------------------------*/
#define COUP_TO_CJF(cjf) { 																			\
/*---------------------------------------------------------------------------*/ 												\
																						\
	/* 																					\
		Entres: 																			\
			val 																			\
			cjf: 																			\
				>=256																		\
				COUNT																		\
				COUNT_SPIN																	\
				COUNT_SEC																	\
				C_SEC																		\
				FLUX																		\
				FDIST																		\
				JE																		\
				FLUX_ALGO																	\
				C_SEC_TARANIS																	\
	*/																					\
																						\
	/* Sorties: val modifi suivant la valeur de cjf */															\
																						\
	denom = 1.0;																				\
																						\
	switch (cjf) {																				\
																						\
		case COUNT:																			\
				val /= sector[noscc];																\
				break; 																		\
																						\
																						\
		case COUNT_SPIN:																		\
				val /= sector[noscc]*accumulation;														\
				break;																		\
																						\
																						\
		case COUNT_SEC:																			\
				if (ienergie==nbenergies-1) val *= COUNTFACTOR; 												\
				GET_DENOM_DEADTIME();																\
				val /= denom*sector[noscc]*accumulation_duree;													\
				break;																		\
																						\
																						\
		case C_SEC:																			\
				if (ienergie==nbenergies-1) val *= COUNTFACTOR; 												\
				GET_DENOM_DEADTIME();																\
				val /= denom*sector[noscc]*accumulation_duree*eff;												\
				break;																		\
																						\
																						\
		case JE: /* retourne JE en keV/(sec.cm2.sr.keV) */ 														\
																						\
				if (ienergie==nbenergies-1) val *= COUNTFACTOR; 												\
				GET_DENOM_DEADTIME();																\
				val /= fg*1e4*denom*sector[noscc]*accumulation_duree*eff;											\
				break;																		\
																						\
																						\
		case FLUX: /* retourne le FLUX differentiel en part/(sec.cm2.sr.keV) */ 											\
																						\
				if (ienergie==nbenergies-1) val *= COUNTFACTOR; 												\
				GET_DENOM_DEADTIME();																\
				val /= (fg*1e4)*(get_E*1e-3)*denom*sector[noscc]*accumulation_duree*eff;									\
				break;																		\
																						\
		case FDIST: /* retourne FDIST en sec3/km6 */															\
																						\
				if (ienergie==nbenergies-1) val *= COUNTFACTOR; 												\
				GET_DENOM_DEADTIME();																\
				val *= MASSE[imasse]*MASSE[imasse]*1e18/(denom*sector[noscc]*accumulation_duree*eff*fg*2*get_E*get_E*ELECTRONVOLT*ELECTRONVOLT);		\
				break;																		\
																						\
		case FLUX_ALGO: /* retourne FLUX_ALGO en part/(sec.cm2.sr.keV) */ 												\
				val = val_demeter[ienergie];															\
				break;																		\
																						\
		case FLUX_INTEGRAL: /* retourne le FLUX integral en part/(sec.cm2.sr) */ 											\
																						\
				if (ienergie==nbenergies-1) val *= COUNTFACTOR; 												\
				GET_DENOM_DEADTIME();																\
				val *= (get_dE*1e-3);																\
				val /= (fg*1e4)*(get_E*1e-3)*denom*sector[noscc]*accumulation_duree*eff;									\
				break;																		\
																						\
		case C_SEC_TARANIS:																		\
				if (ienergie==nbenergies-1) val *= COUNTFACTOR; 												\
				GET_DENOM_DEADTIME();																\
				val /= denom*sector[noscc]*accumulation_duree*eff;												\
				val *= val_demeter[ienergie];															\
				break;																		\
																						\
		case FDIST_TO_FLUX:																		\
				val *= (2*get_E*ELECTRONVOLT*ELECTRONVOLT) / (MASSE[imasse]*MASSE[imasse]*1e18*1e4*1e-3);							\
				break;																		\
																						\
		case FDIST_TO_FDIST: /* ne rien faire */															\
				break;																		\
																						\
		case FDIST_TO_JE:																		\
				val *= (2*get_E*get_E*ELECTRONVOLT*ELECTRONVOLT)/(MASSE[imasse]*MASSE[imasse]*1e18*1e4);							\
				break;																		\
																						\
		case FDIST_TO_FLUX_INTEGRAL:																	\
				val *= get_dE*1e-3;																\
				val *= (2*get_E*ELECTRONVOLT*ELECTRONVOLT) / (MASSE[imasse]*MASSE[imasse]*1e18*1e4*1e-3);							\
				break;																		\
																						\
		case FLUX_TO_FLUX: /* ne rien faire */																\
				break;																		\
																						\
		case FLUX_TO_FDIST:																		\
				val *= (MASSE[imasse]*MASSE[imasse]*1e18*1e4*1e-3) / (2*get_E*ELECTRONVOLT*ELECTRONVOLT);							\
				break;																		\
																						\
		case FLUX_TO_JE:																		\
				val *= get_E*1e-3;																\
				break;																		\
																						\
		case FLUX_TO_FLUX_INTEGRAL:																	\
				val *= get_dE*1e-3;																\
				break;																		\
																						\
		case JE_TO_FLUX:																		\
				val /= get_E*1e-3;																\
				break;																		\
																						\
		case JE_TO_FDIST:																		\
				val *= (MASSE[imasse]*MASSE[imasse]*1e18*1e4) / (2*get_E*get_E*ELECTRONVOLT*ELECTRONVOLT);							\
				break;																		\
																						\
		case JE_TO_JE: /* ne rien faire */																\
				break;																		\
																						\
		case JE_TO_FLUX_INTEGRAL: 																	\
				val *= get_dE*1e-3;																\
				val /= get_E*1e-3;																\
				break;																		\
																						\
		default:																			\
				break;																		\
																						\
	}																					\
																						\
	if (is_MAVEN_SWEA(nocis) && denom==deadtime[1]) val = -1e31;														\
																						\
}

/*---------------------------------------------------------------------------*/
#define GET_SOLID() { 																\
/*---------------------------------------------------------------------------*/ 								\
																		\
	/* Avant les comptages il y a nbangles BYTE (list_theta) puis nbangles BYTE (list_phi) */						\
																		\
	list_theta = p1 - 2*nbangles; 														\
	list_phi   = p1 - 1*nbangles; 														\
																		\
	/* Initilialiser solid avec des -1 */													\
	for (icellule = 0 ; icellule < nbcellules ; icellule++) {										\
		for (ispectre = 0 ; ispectre < nbspectres ; ispectre++) {									\
			solid[noscc] = -1;													\
		}																\
	}																	\
																		\
	/* Mettre dans solid les nbangles connus */												\
	for (iangle = 0 ; iangle < nbangles ; iangle++) {											\
		icellule = list_theta[iangle];													\
		ispectre = list_phi[iangle];													\
		solid[noscc] = iangle;														\
		/*printf ("pad %02d: theta=%02d phi=%02d solid[%d]=%d\n",iangle,list_theta[iangle],list_phi[iangle],noscc,iangle);*/		\
	}																	\
																		\
}


/*---------------------------------------------------------------------------*/
#define COUP_TO_CJF1(cjf) { 															\
/*---------------------------------------------------------------------------*/ 								\
																		\
	/* int nbytes: 																\
		4+256:		val = (float *)p4 												\
		8+256:		val = (double *)p4												\
		1:		val = p1[nocoup]												\
		1+65536:	val = dico[p1[nocoup]]												\
		2:		val = p2[nocoup]												\
		2+65536		val = dico[p2[nocoup]]												\
		autre:		val = p4[nocoup] */												\
																		\
	/*printf ("solid(ispectre=%d icellule=%d icarte=%d]=%d\n",ispectre,icellule,icarte,solid[noscc]);*/					\
	if (solid[noscc]==-1) {															\
		val = -FILLVAL_E31;														\
	} else if (sector[noscc]<=0) {														\
		val = -FILLVAL_E31;														\
	} else {																\
		switch (nbytes) {														\
																		\
			case 4+256:														\
																		\
				val = pfloat[nocoup]; 												\
				/*if (bgnd_e_remove>=0 && bgnd_e_remove<nbenergies) {*/								\
					/* Nicolas Andr 20/07/2016 */										\
					/*val -= pfloat[indice3_new(bgnd_e_remove,solid[noscc],imasse,nbenergies,nbangles,nbmasses)];*/ 	\
					/*if (val<0) val=0;*/											\
				/*}*/														\
				if (FINITE(val)==0) val=-FILLVAL_E31;										\
				if (val>-1e-40 && val<1e-40) val=0;		/* Underflow */							\
				break;														\
																		\
			case 8+256: 														\
																		\
				val = pdouble[nocoup]; 												\
				if (FINITE(val)==0) val=-FILLVAL_E31;										\
				if (val>-1e-40 && val<1e-40) val=0;		/* Underflow */							\
				break;														\
																		\
			case 1: 														\
																		\
				val = p1[nocoup];												\
				break;														\
																		\
			case 1+65536: 														\
																		\
				val = dico[p1[nocoup]];												\
				break;														\
																		\
			case 2: 														\
																		\
				val = p2[nocoup]; 												\
				break;														\
																		\
			case 2+65536: 														\
																		\
				val = dico[p2[nocoup]]; 											\
				break;														\
																		\
			default: 														\
																		\
				val = p4[nocoup]; 												\
				break;														\
																		\
		} 																\
	}																	\
	if (use_one_count_level) val=1;														\
																		\
	if (val>0 || cjf==FLUX_ALGO) COUP_TO_CJF (cjf);												\
																		\
}


/*---------------------------------------------------------------------------*/
#define COUP_TO_CJF1_REMOVE_BAD_CHANNEL() {													\
/*---------------------------------------------------------------------------*/									\
																		\
	float		VAL1;															\
	float		VAL2;															\
																		\
	if (is_IMA_ASPERA3(nocis) && nbmasses==32) {												\
		if (imasse==0) {														\
			val=0;															\
		} else if (imasse==4||imasse==10||imasse==22) {											\
			imasse--;COUP_TO_CJF1(cjf);												\
			VAL1 = (val-IMA_NOISE[indice2(ienergie,imasse,nbenergies,nbmasses)]*level)*IMA_MASS_MULT[imasse]-level2;		\
			imasse+=2;COUP_TO_CJF1(cjf);												\
			VAL2 = (val-IMA_NOISE[indice2(ienergie,imasse,nbenergies,nbmasses)]*level)*IMA_MASS_MULT[imasse]-level2;		\
			imasse--;														\
			val= (VAL1+VAL2)/2.0; 													\
		} else {															\
			COUP_TO_CJF1 (cjf);													\
			val = (val-IMA_NOISE[indice2(ienergie,imasse,nbenergies,nbmasses)]*level)*IMA_MASS_MULT[imasse]-level2;			\
		}																\
		if (val<0) val=0;														\
	} else if (is_IMA_ASPERA4(nocis) && nbmasses==32) {											\
		COUP_TO_CJF1 (cjf);														\
		val = val-level2;														\
		if (val<0) val=0;														\
	} else {																\
		COUP_TO_CJF1 (cjf);														\
	}																	\
}


/*---------------------------------------------------------------------------*/
#define REMOVE_HGHOST() {															\
/*---------------------------------------------------------------------------*/									\
																		\
	int	LOCAL_MIN;															\
	int	LOCAL_MAX;															\
	double	LOCAL_A1 = 0;															\
	double	LOCAL_A2 = 0;															\
	int	LOCAL_IS_OXYGEN = (tabmass[0]==-5);												\
																		\
	if ((is_IMA_ASPERA3(nocis) || is_IMA_ASPERA4(nocis)) && nbmasses==32 && (LOCAL_IS_OXYGEN)) {						\
		PUSH_double(val);														\
		PUSH_int(imasse);														\
																		\
		/* RM_A1 = counts de H+(0) */													\
		LOCAL_MIN = IMA_POSITION1[indice3(ispin,ienergie,0,nbspins,nbenergies,INUTILE)] + 0.5;						\
		if (LOCAL_MIN<0) LOCAL_MIN=0;													\
		LOCAL_MAX = IMA_POSITION2[indice3(ispin,ienergie,0,nbspins,nbenergies,INUTILE)] + 0.5;						\
		if (LOCAL_MAX>nbmasses-1) LOCAL_MAX=nbmasses-1;											\
		for (imasse=LOCAL_MIN ; imasse<=LOCAL_MAX ; imasse++) {										\
			if (remove_bad_channel) {												\
				COUP_TO_CJF1_REMOVE_BAD_CHANNEL();										\
			} else {														\
				COUP_TO_CJF1(cjf);												\
			}															\
			LOCAL_A1 += val;													\
		}																\
																		\
		/* LOCAL_A2 = counts de He++ (1) */												\
		LOCAL_MIN = IMA_POSITION1[indice3(ispin,ienergie,1,nbspins,nbenergies,INUTILE)] + 0.5;						\
		if (LOCAL_MIN<0) LOCAL_MIN=0;													\
		LOCAL_MAX = IMA_POSITION2[indice3(ispin,ienergie,1,nbspins,nbenergies,INUTILE)] + 0.5;						\
		if (LOCAL_MAX>nbmasses-1) LOCAL_MAX=nbmasses-1;											\
		for (imasse=LOCAL_MIN ; imasse<=LOCAL_MAX ; imasse++) {										\
			if (remove_bad_channel) {												\
				COUP_TO_CJF1_REMOVE_BAD_CHANNEL();										\
			} else {														\
				COUP_TO_CJF1(cjf);												\
			}															\
			LOCAL_A2 += val;													\
		}																\
																		\
		POP_int(imasse);														\
		POP_double(val);														\
																		\
		if (is_IMA_ASPERA4(nocis) || IMA_PAC[ispin]==4) {										\
			val -= LOCAL_A1 / hghost_k2;												\
		} else if (IMA_PAC[ispin]==7) {													\
			val -= (LOCAL_A1 - LOCAL_A2) / hghost_k1;										\
		}																\
		if (val<0) val=0;														\
	}																	\
}

/*---------------------------------------------------------------------------*/
#define MAVEN_SWEA_CALIB_DEBUT() {														\
/*---------------------------------------------------------------------------*/									\
	if (is_MAVEN_SWEA(nocis)) maven_swea_calib_debut(CL_ROOT,facteurG,nbspectres,nbcellules,nbtablesE,nbenergies);				\
}																		\

/*---------------------------------------------------------------------------*/
#define MAVEN_SWEA_CALIB_GET() {														\
/*---------------------------------------------------------------------------*/									\
	if (is_MAVEN_SWEA(nocis)) {														\
		itable = !spin_average ? indY[ispin*nbspectres]:indY[ispin];									\
		maven_swea_calib_get(date+1950*0.5,itable,facteurG,efficacite,nbspectres,nbcellules,nbtablesE,nbenergies);			\
	}																	\
}																		\

/*---------------------------------------------------------------------------*/
#define MAVEN_SWEA_CALIB_FIN() {														\
/*---------------------------------------------------------------------------*/									\
	if (is_MAVEN_SWEA(nocis)) maven_swea_calib_fin(facteurG,nbspectres,nbcellules,nbtablesE,nbenergies);					\
}																		\


/*---------------------------------------------------------------------------*/
int julday (int mm, int id, int iyyy, int *julian) {
/*---------------------------------------------------------------------------*/

	#define igreg1 588829

	int ja,jm,jy,jul;

	if (iyyy==0)
		return -1;

	if (iyyy < 0)
		iyyy = iyyy + 1; 
	if (mm > 2) {
		jy = iyyy;
		jm = mm+1;
	} else {
		jy = iyyy-1;
		jm = mm+13;
	}
	jul = (int)(365.25*jy) + (int)(30.6001*jm) + id + 1720995;

	if (id+31*(mm+12*iyyy) >= igreg1) {
		ja = (int)(0.01*jy);
		jul = jul + 2 - ja + (int)(0.25*ja);
	}
	*julian = jul;

	return 0;

}

/*---------------------------------------------------------------------------*/
void caldat (int *mm, int *id, int *iyyy, int julian) {
/*---------------------------------------------------------------------------*/

	#define igreg2 2299161

	int je,jd,jc,jb,jalpha,ja;

	if (julian > igreg2) {
		jalpha = (int)(((julian-1867216)-0.25)/36524.25);
		ja = julian + 1 + jalpha - (int)(0.25*jalpha);
	} else
		ja = julian;

	jb = ja + 1524;
	jc = (int)(6680.0 + ((jb - 2439870)-122.1)/365.25);
	jd = 365*jc + (int)(0.25*jc);
	je = (int)((jb - jd)/30.6001);
	*id = jb - jd - (int)(30.6001*je);
	*mm = je - 1;
	if (*mm > 12)
		*mm = *mm - 12;
	*iyyy = jc - 4715;
	if (*mm > 2)
		*iyyy = *iyyy - 1;
	if (*iyyy <= 0)
		*iyyy = *iyyy - 1;

}


#define julian1958 2436205

/*---------------------------------------------------------------------------*/
void date_to_tu (double date, int *annee, int *mois, int *jour, int *heure, int *minute, double *seconde) {
/*---------------------------------------------------------------------------*/

	int	julian;

	julian = julian1958 + (int)(date/86400000);
	caldat (mois, jour, annee, julian);

	*seconde = (date - (double)(julian-julian1958)*86400000)/1000;
	*heure = *seconde / 3600;

	*seconde = *seconde - *heure*3600;

	*minute = *seconde / 60;

	*seconde = *seconde - *minute*60;

}

/*---------------------------------------------------------------------------*/
double tu_to_date (int ann, int moi, int jou, int heu, int min, double sec) {
/*---------------------------------------------------------------------------*/

	int	julian=0; // initialis sinon warning gcc
	int	nbjours;
	int	nbms;
	double	date;

	#define	julian1958 2436205

	// static variables to call julday() only when necessary
	static int ann1 = -1;
	static int moi1 = -1;
	static int jou1 = -1;
	static int julian1 = -1;

	if (ann==ann1 && moi==moi1 && jou==jou1) {
		julian = julian1;
	} else {
		julday (moi, jou, ann, &julian);
		ann1 = ann;
		moi1 = moi;
		jou1 = jou;
		julian1 = julian;
	}

	nbjours	= julian - julian1958;
	nbms	= heu*3600000. + min*60000. + (int)(sec*1000. +0.5); /* pb arrondi */
	date	= nbjours*86400000. + nbms;
	return date;

}


#define	MAVEN_SWEA_CALIB_MAX	10000
#define	MAVEN_SWEA_NBSPECTRES	6
#define	MAVEN_SWEA_NBCELLULES	16
#define	MAVEN_SWEA_NBTABLES	8
#define	MAVEN_SWEA_NBENERGIES	64
double	MAVEN_SWEA_CALIB_EIN64[64][8];
double	MAVEN_SWEA_CALIB_date[MAVEN_SWEA_CALIB_MAX];
double	MAVEN_SWEA_CALIB_cc[MAVEN_SWEA_CALIB_MAX];
double	MAVEN_SWEA_CALIB_ke[MAVEN_SWEA_CALIB_MAX];
double	MAVEN_SWEA_CALIB_ff[MAVEN_SWEA_CALIB_MAX][96];
int	MAVEN_SWEA_CALIB_nblignes;
int	MAVEN_SWEA_CALIB_noligne;
int	MAVEN_SWEA_CALIB_initialise = 0;
double	MAVEN_SWEA_CALIB_facteurG[MAVEN_SWEA_NBSPECTRES][MAVEN_SWEA_NBCELLULES][MAVEN_SWEA_NBTABLES][MAVEN_SWEA_NBENERGIES];

/*---------------------------------------------------------------------------*/
int maven_swea_calib_lire (IDL_STRING *CL_ROOT) {
/*---------------------------------------------------------------------------*/

	FILE	*fd;
	int	itable;
	int	ienergie;
	int	iligne;
	int	annee;
	int	mois;
	int	jour;
	int	heure;
	int	minute;
	double	seconde;
	double	date;
	int	i;
	char	ligne[10240];
	char	*p;
	int	dep;
	char	nom[1024];

	MAVEN_SWEA_CALIB_nblignes = 0;

	for (itable=0 ; itable<8 ; itable++) {
		for (ienergie=0 ; ienergie<64 ; ienergie++) {
			MAVEN_SWEA_CALIB_EIN64[ienergie][itable] = 0;
		}
	}

	sprintf (nom,"%s/resource/projets/maven/mvn_swe_calib.txt",IDL_STRING_STR(CL_ROOT));
	//printf ("nom=%s\n",nom);
	fd = fopen (nom,"r");
	while (1) {
		if (fgets (ligne, sizeof(ligne), fd) == NULL) break;
		p = ligne;
		if (sscanf (p, "EIN T%d%n", &itable, &dep) == 1) {
			p += dep;
			for (ienergie=0 ; ienergie<64 ; ienergie++) {
				sscanf (p,"%lf%n",&MAVEN_SWEA_CALIB_EIN64[ienergie][itable],&dep);
				p += dep;
			}
		} else if (sscanf (p,"%04d-%02d-%02dT%02d:%02d:%lfZ%n",&annee,&mois,&jour,&heure,&minute,&seconde,&dep)==6) {
			p += dep;
			MAVEN_SWEA_CALIB_date[MAVEN_SWEA_CALIB_nblignes] = tu_to_date (annee, mois, jour, heure, minute, seconde);
			sscanf (p,"%lf%n",&MAVEN_SWEA_CALIB_cc[MAVEN_SWEA_CALIB_nblignes],&dep);
			p += dep;
			sscanf (p,"%lf%n",&MAVEN_SWEA_CALIB_ke[MAVEN_SWEA_CALIB_nblignes],&dep);
			p += dep;
			for (i=0 ; i<96 ; i++) {
				sscanf (p,"%lf%n",&MAVEN_SWEA_CALIB_ff[MAVEN_SWEA_CALIB_nblignes][i],&dep);
				p += dep;
			}
			MAVEN_SWEA_CALIB_nblignes++;
		}
	}
	fclose (fd);

	// Correction tables non renseignes
	for (itable=0 ; itable<8 ; itable++) {
		for (ienergie=0 ; ienergie<64 ; ienergie++) {
			if (MAVEN_SWEA_CALIB_EIN64[ienergie][itable]==0) {
				MAVEN_SWEA_CALIB_EIN64[ienergie][itable] = MAVEN_SWEA_CALIB_EIN64[ienergie][3];
			}
		}
	}

	#ifdef XXX
	for (itable=0 ; itable<8 ; itable++) {
		for (ienergie=0 ; ienergie<64 ; ienergie++) {
			printf ("MAVEN_SWEA_CALIB_EIN64[%d][%d] = %f\n",ienergie,itable,MAVEN_SWEA_CALIB_EIN64[ienergie][itable]);
		}
	}

	for (iligne=0 ; iligne<MAVEN_SWEA_CALIB_nblignes ; iligne++) {
		date_to_tu (MAVEN_SWEA_CALIB_date[iligne], &annee, &mois, &jour, &heure, &minute, &seconde);
		printf ("%04d:%02d:%02dT%02d:%02d:%06.3fT %f %f %f .. %f\n",
				annee, mois, jour, heure, minute, seconde,
				MAVEN_SWEA_CALIB_cc[iligne],
				MAVEN_SWEA_CALIB_ke[iligne],
				MAVEN_SWEA_CALIB_ff[iligne][0],
				MAVEN_SWEA_CALIB_ff[iligne][95]);
	}
	#endif


	return 1;

}



/*---------------------------------------------------------------------------*/
void maven_swea_calib_debut (IDL_STRING *CL_ROOT, double *facteurG, int nbspectres, int nbcellules, int nbtablesE, int nbenergies) {
/*---------------------------------------------------------------------------*/

	int	ispectre;
	int	icellule;
	int	itable;
	int	ienergie;

	if (MAVEN_SWEA_CALIB_initialise == 0) {

		maven_swea_calib_lire(CL_ROOT);
		MAVEN_SWEA_CALIB_initialise = 1;

	}

	//printf ("nbspectres=%d nbcellules=%d nbtablesE=%d nbenergies=%d\n",nbspectres,nbcellules,nbtablesE,nbenergies);

	for (ispectre=0 ; ispectre<nbspectres; ispectre++) {
		for (icellule=0 ; icellule<nbcellules ; icellule++) {
			for (itable=0 ; itable<nbtablesE ; itable++) {
				for (ienergie=0 ; ienergie<nbenergies ; ienergie++) {
					MAVEN_SWEA_CALIB_facteurG[ispectre][icellule][itable][ienergie] = facteurG[indice4(ispectre,icellule,itable,ienergie,nbspectres,nbcellules,nbtablesE,nbenergies)];
				}
			}
		}
	}
}

/*---------------------------------------------------------------------------*/
void maven_swea_calib_fin (double *facteurG, int nbspectres, int nbcellules, int nbtablesE, int nbenergies) {
/*---------------------------------------------------------------------------*/

	int	ispectre;
	int	icellule;
	int	itable;
	int	ienergie;

	for (ispectre=0 ; ispectre<nbspectres; ispectre++) {
		for (icellule=0 ; icellule<nbcellules ; icellule++) {
			for (itable=0 ; itable<nbtablesE ; itable++) {
				for (ienergie=0 ; ienergie<nbenergies ; ienergie++) {
					facteurG[indice4(ispectre,icellule,itable,ienergie,nbspectres,nbcellules,nbtablesE,nbenergies)] = MAVEN_SWEA_CALIB_facteurG[ispectre][icellule][itable][ienergie];
				}
			}
		}
	}
}

/*---------------------------------------------------------------------------*/
void maven_swea_calib_chercher (double date) {
/*---------------------------------------------------------------------------*/

	if (date >= MAVEN_SWEA_CALIB_date[MAVEN_SWEA_CALIB_noligne] && date < MAVEN_SWEA_CALIB_date[MAVEN_SWEA_CALIB_noligne+1]) {
		return;
	}

	for (MAVEN_SWEA_CALIB_noligne=0 ; MAVEN_SWEA_CALIB_noligne<MAVEN_SWEA_CALIB_nblignes-1 ; MAVEN_SWEA_CALIB_noligne++) {
		if (date >= MAVEN_SWEA_CALIB_date[MAVEN_SWEA_CALIB_noligne] && date < MAVEN_SWEA_CALIB_date[MAVEN_SWEA_CALIB_noligne+1]) {
			return;
		}
	}

	MAVEN_SWEA_CALIB_noligne = 0; // pas trouv

}


/*---------------------------------------------------------------------------*/
void maven_swea_calib_get (double date, int itable, double *facteurG, double *efficacite, int nbspectres, int nbcellules, int nbtablesE, int nbenergies) {
/*---------------------------------------------------------------------------*/

	int	noligne;
	int	noff;
	double	cc,ke;
	double	dg[64];
	double	ff[96];
	double	energie=0; // sinon warning gcc
	int	ispectre;
	int	icellule;
	int	ienergie;
	int	i;
	double	energie1,energie2,energie3,energie4,dg1,dg2,dg3,dg4;
	double	date1, date2, cc1, cc2, ke1, ke2, ff1, ff2;

	if (efficacite[0]==1) return; //fichier CDF en JE

	maven_swea_calib_chercher (date);
	noligne = MAVEN_SWEA_CALIB_noligne;

	date1 = MAVEN_SWEA_CALIB_date[noligne+0];
	date2 = MAVEN_SWEA_CALIB_date[noligne+1];

	cc1 = MAVEN_SWEA_CALIB_cc[noligne+0];
	cc2 = MAVEN_SWEA_CALIB_cc[noligne+1];
	cc = cc1 + (date-date1)/(date2-date1)*(cc2-cc1);

	ke1 = MAVEN_SWEA_CALIB_ke[noligne+0];
	ke2 = MAVEN_SWEA_CALIB_ke[noligne+1];
	ke = ke1 + (date-date1)/(date2-date1)*(ke2-ke1);
	//printf ("noligne=%d cc=%f ke=%f\n",noligne,cc,ke);

	for (ienergie=0 ; ienergie<nbenergies ; ienergie++) {
		if (nbenergies==64) {
			energie = MAVEN_SWEA_CALIB_EIN64[ienergie][itable];
			dg[ienergie] = exp(-(CARRE((1./energie)*ke)));
		} else if (nbenergies==32) {
			energie1 = MAVEN_SWEA_CALIB_EIN64[2*ienergie+0][itable];
			energie2 = MAVEN_SWEA_CALIB_EIN64[2*ienergie+1][itable];
			dg1 = exp(-(CARRE((1./energie1)*ke)));
			dg2 = exp(-(CARRE((1./energie2)*ke)));
			dg[ienergie] = (dg1+dg2)*0.5;
		} else if (nbenergies==16) {
			energie1 = MAVEN_SWEA_CALIB_EIN64[4*ienergie+0][itable];
			energie2 = MAVEN_SWEA_CALIB_EIN64[4*ienergie+1][itable];
			energie3 = MAVEN_SWEA_CALIB_EIN64[4*ienergie+2][itable];
			energie4 = MAVEN_SWEA_CALIB_EIN64[4*ienergie+3][itable];
			dg1 = exp(-(CARRE((1./energie1)*ke)));
			dg2 = exp(-(CARRE((1./energie2)*ke)));
			dg3 = exp(-(CARRE((1./energie3)*ke)));
			dg4 = exp(-(CARRE((1./energie4)*ke)));
			dg[ienergie] = (dg1+dg2+dg3+dg4)*0.25;
		}
	}

	if (nbspectres==1 && nbcellules==1) {
		// utilise dg et cc
		for (ienergie=0 ; ienergie<nbenergies ; ienergie++) {
			facteurG[indice4(0,0,itable,ienergie,nbspectres,nbcellules,nbtablesE,nbenergies)] = MAVEN_SWEA_CALIB_facteurG[0][0][itable][ienergie] * dg[ienergie] / cc;
		}
	} else {
		// utilise dg, cc et ff
		for (i=0 ; i<96; i++) {
			ff1 = MAVEN_SWEA_CALIB_ff[noligne+0][i];
			ff2 = MAVEN_SWEA_CALIB_ff[noligne+1][i];
			ff[i] = ff1 + (date-date1)/(date2-date1)*(ff2-ff1);
			//printf ("ff1=%f ff2=%f ff[%d]=%f\n",MAVEN_SWEA_CALIB_ff1[noligne][i],MAVEN_SWEA_CALIB_ff2[noligne][i],i,ff[i]);
		}
		for (ienergie=0 ; ienergie<nbenergies ; ienergie++) {
			for (ispectre=0 ; ispectre<nbspectres; ispectre++) {
				for (icellule=0 ; icellule<nbcellules ; icellule++) {
					noff = ispectre*nbcellules + icellule; // Idem Dave Mitchell
					facteurG[indice4(ispectre,icellule,itable,ienergie,nbspectres,nbcellules,nbtablesE,nbenergies)] = MAVEN_SWEA_CALIB_facteurG[ispectre][icellule][itable][ienergie] * dg[ienergie] * ff[noff] / cc;
				}
			}
		}
	}

	//printf ("cc=%f ke=%f\n",cc,ke);

}


/*---------------------------------------------------------------------------*/
void sector_mask_to_solid (unsigned int sector_mask, int nbcellules, int *solid) {
/*---------------------------------------------------------------------------*/

	int	i;
	int	j=0;

	for (i=0 ; i<nbcellules ; i++) {

		solid[i] = ((sector_mask>>(nbcellules-1-i)) & 1) == 1 ? j++ : -1;

	}

}


/*---------------------------------------------------------------------------*/
float produit_scalaire_v1_v2 (float V1[3], float V2[3]) {
/*---------------------------------------------------------------------------*/

	return V1[0]*V2[0] + V1[1]*V2[1] + V1[2]*V2[2];

}

/*---------------------------------------------------------------------------*/
double produit_scalaire_v1_v2_double (double V1[3], double V2[3]) {
/*---------------------------------------------------------------------------*/

	return V1[0]*V2[0] + V1[1]*V2[1] + V1[2]*V2[2];

}

/*---------------------------------------------------------------------------*/
float module_v1 (float V1[3]) {
/*---------------------------------------------------------------------------*/

	return sqrt(V1[0]*V1[0] + V1[1]*V1[1] + V1[2]*V1[2]);

}

/*---------------------------------------------------------------------------*/
float module_xyz (float X, float Y, float Z) {
/*---------------------------------------------------------------------------*/

	return sqrt(X*X + Y*Y + Z*Z);

}


/*---------------------------------------------------------------------------*/
double module_v1_double (double V1[3]) {
/*---------------------------------------------------------------------------*/

	return sqrt(V1[0]*V1[0] + V1[1]*V1[1] + V1[2]*V1[2]);

}


/*---------------------------------------------------------------------------*/
void v1_vectoriel_v2 (float V1[3], float V2[3], float V3[3]) {
/*---------------------------------------------------------------------------*/

	V3[0] = V1[1]*V2[2]-V1[2]*V2[1];
	V3[1] = V1[2]*V2[0]-V1[0]*V2[2];
	V3[2] = V1[0]*V2[1]-V1[1]*V2[0];

}


/*---------------------------------------------------------------------------*/
void v1_vectoriel_v2_double (double V1[3], double V2[3], double V3[3]) {
/*---------------------------------------------------------------------------*/

	V3[0] = V1[1]*V2[2]-V1[2]*V2[1];
	V3[1] = V1[2]*V2[0]-V1[0]*V2[2];
	V3[2] = V1[0]*V2[1]-V1[1]*V2[0];

}


#define INTERPOLER_TAB_STD_GENERIQUE(nb1,t1,x1,nb2,t2,x2,FILLVAL,DTMAX,extrapoler,debug)								\
	/* On a une srie temporelle de nb1 points (temps=t1,ordonne=x1) que l'on veut interpoler aux nb2 points aux temps t2 */			\
	/* La serie doit etre fournie par temps croissant! */												\
	/* Retourne l'ordonne interpole dans x2. */													\
																			\
	int	i;																	\
	int	j;																	\
	double	t;																	\
	j=0;																		\
	for (i=0 ; i<nb2 ; i++) {															\
		t = t2[i];																\
																			\
		if (debug) printf ("Interpolation pour t=%f: ", t);											\
																			\
		/* Recherche du plus petit j tel que t1[j]>=t */											\
		for ( ; j<nb1 && t1[j]<t ; j++);													\
																			\
		if (extrapoler && j==nb1) {	/* extrapolation apres le dernier point */								\
			if (debug) printf ("ICI1 (a) nb1=%d DTMAX=%f x1[0]=%f t-t1[0]=%f",nb1,DTMAX,x1[0],t-t1[0]);					\
			if (nb1==1) {															\
				if (debug) printf ("ICI1 (aa) t-t1[0]=%f DTMAX=%f", t-t1[0], DTMAX);							\
				if ((t-t1[0]<DTMAX)) printf ("OK1");											\
				if ((t-t1[0]<DTMAX) && x1[0]!=FILLVAL) {										\
					x2[i] = x1[0];													\
					if (debug) printf ("ICI1 (b) x2[%d]=%f",i,x2[i]);								\
				}															\
			} else {															\
				j-=2;															\
				if (j>=0 && (t-t1[j+1]<DTMAX) && x1[j+1]!=FILLVAL && x1[j]!=FILLVAL && t1[j+1]!=t1[j]) {				\
					x2[i] = x1[j] + (x1[j+1]-x1[j])/(t1[j+1]-t1[j])*(t-t1[j]);							\
					if (debug) printf ("ICI1 (c) x2[%d]=%f",i,x2[i]);								\
					if (debug) printf ("%f extrapolation apres le dernier point, entre t=%f et t=%f", x2[i], t1[j], t1[j+1]);	\
				}															\
			}																\
			if (debug) printf ("ICI1 (d) x2[%d]=%f",i,x2[i]);										\
		} else if (t1[j]==t) {															\
			if (debug) printf ("ICI2 ");													\
			x2[i] = x1[j];															\
			if (debug) printf ("%f pas interpolation",x2[i]);										\
		} else if (extrapoler && j == 0) {		/* extrapolation avant le premier point	*/						\
			if (debug) printf ("ICI3 nb1=%d",nb1);												\
			if (nb1==1) {															\
				if ((t1[0]-t<DTMAX) && x1[0]!=FILLVAL) {										\
					x2[i] = x1[0];													\
				}															\
			} else {															\
				if ((t1[0]-t<DTMAX) && x1[1]!=FILLVAL && x1[0]!=FILLVAL && t1[1]!=t1[0]) {						\
					x2[i] = x1[0] + (x1[1]-x1[0])/(t1[1]-t1[0])*(t-t1[0]);								\
					if (debug) printf ("%f extrapolation avant le premier point, entre t=%f et t=%f", x2[i], t1[0], t1[1]);		\
				}															\
			}																\
		} else {																\
			if (debug) printf ("ICI4 j=%d nb1=%d ",j,nb1);											\
			j--;																\
			if ((t-t1[j]<DTMAX) && x1[j+1]!=FILLVAL && x1[j]!=FILLVAL && t1[j+1]!=t1[j] && j+1<nb1) {					\
				x2[i] = x1[j] + (x1[j+1]-x1[j])/(t1[j+1]-t1[j])*(t-t1[j]);								\
				if (debug) printf ("%f entre %f et %f interpolation DT=%f",x2[i],t1[j],t1[j+1],t-t1[j]);				\
			}																\
		}																	\
		if (debug) printf ("\n");														\
	}

/*---------------------------------------------------------------------------*/
void interpoler_tab_std_float (
/*---------------------------------------------------------------------------*/
	int	nb1,
	double	*t1,		// abscisse en entre
	float	*x1,		// ordonne en entre
	int	nb2,
	double	*t2,		// abscisse en entre
	float	*x2,		// ordonne en sortie
	float	FILLVAL,
	double	DTMAX,
	int	extrapoler,	// 1 pour extrapoler, 0 pour ne pas extrapoler
	int	debug) {
/*---------------------------------------------------------------------------*/

	INTERPOLER_TAB_STD_GENERIQUE(nb1,t1,x1,nb2,t2,x2,FILLVAL,DTMAX,extrapoler,debug)

}


/*---------------------------------------------------------------------------*/
void INTERPOLER_TAB_FLOAT (int argc, void *argv[]) {
/*---------------------------------------------------------------------------*/

	int	nbarg		= 0;
	int	nb2		= *(int *)	argv[nbarg++];
	double	*t2		= (double *)	argv[nbarg++];
	int	nb1		= *(int *)	argv[nbarg++];
	double	*t1		= (double *)	argv[nbarg++];
	float	*x1		= (float *)	argv[nbarg++];
	float	*x2		= (float *)	argv[nbarg++];
	float	FILLVAL		= *(float *)	argv[nbarg++];
	double	DTMAX		= *(double *)	argv[nbarg++];
	int	extrapoler	= *(int *)	argv[nbarg++];

	if (nbarg != argc) return;

	interpoler_tab_std_float (
		nb1,
		t1,
		x1,
		nb2,
		t2,
		x2,
		FILLVAL,
		DTMAX,
		extrapoler,
		0);

}

/*---------------------------------------------------------------------------*/
void INTERPOLER_TAB_FLOAT_AUTO_GLUE (
/*---------------------------------------------------------------------------*/
	void	*p01,
	void	*p02,
	void	*p03,
	void	*p04,
	void	*p05,
	void	*p06,
	void	*p07,
	void	*p08,
	void	*p09) {

	int	argc=9;
	void	*argv[9];

	argv[0] = p01;
	argv[1] = p02;
	argv[2] = p03;
	argv[3] = p04;
	argv[4] = p05;
	argv[5] = p06;
	argv[6] = p07;
	argv[7] = p08;
	argv[8] = p09;
	INTERPOLER_TAB_FLOAT (argc, argv);

}


/*------------------------------------------------------------------------------*/
void interpoler_tab_std_double (
/*------------------------------------------------------------------------------*/
	int	nb1,
	double	*t1,		// abscisse en entre
	double	*x1,		// ordonne en entre
	int	nb2,
	double	*t2,		// abscisse en entre
	double	*x2,		// ordonne en sortie
	double	FILLVAL,
	double	DTMAX,
	int	extrapoler,	// 1 pour extrapoler, 0 pour ne pas extrapoler
	int	debug) {
/*---------------------------------------------------------------------------*/

	INTERPOLER_TAB_STD_GENERIQUE(nb1,t1,x1,nb2,t2,x2,FILLVAL,DTMAX,extrapoler,debug)

}


/*---------------------------------------------------------------------------*/
void INTERPOLER_TAB_DOUBLE (int argc, void *argv[]) {
/*---------------------------------------------------------------------------*/

	int	nbarg		= 0;
	int	nb2		= *(int *)	argv[nbarg++];
	double	*t2		= (double *)	argv[nbarg++];
	int	nb1		= *(int *)	argv[nbarg++];
	double	*t1		= (double *)	argv[nbarg++];
	double	*x1		= (double *)	argv[nbarg++];
	double	*x2		= (double *)	argv[nbarg++];
	double	FILLVAL		= *(double *)	argv[nbarg++];
	double	DTMAX		= *(double *)	argv[nbarg++];
	int	extrapoler	= *(int *)	argv[nbarg++];

	if (nbarg != argc) return;

	interpoler_tab_std_double (
		nb1,
		t1,
		x1,
		nb2,
		t2,
		x2,
		FILLVAL,
		DTMAX,
		extrapoler,
		0);

}

/*---------------------------------------------------------------------------*/
void INTERPOLER_TAB_DOUBLE_AUTO_GLUE (
/*---------------------------------------------------------------------------*/
	void	*p01,
	void	*p02,
	void	*p03,
	void	*p04,
	void	*p05,
	void	*p06,
	void	*p07,
	void	*p08,
	void	*p09) {

	int	argc=9;
	void	*argv[9];

	argv[0] = p01;
	argv[1] = p02;
	argv[2] = p03;
	argv[3] = p04;
	argv[4] = p05;
	argv[5] = p06;
	argv[6] = p07;
	argv[7] = p08;
	argv[8] = p09;
	INTERPOLER_TAB_DOUBLE (argc, argv);
}

/*------------------------------------------------------------------------------*/
void interpoler_tab_quick_double (
	int	nb1,
	double	*x1,		// abscisse en entre
	double	*y1,		// ordonne en entre
	int	nb2,
	double	*x2,		// abscisse en entre
	double	*y2) {		// ordonne en sortie
/*---------------------------------------------------------------------------*/

	int	i;
	int	j;
	double	x;
	

	if (x1[0] < x1[1]) {

		// croissant

		j = 0;

		for (i=0 ; i<nb2 ; i++) {

			x = x2[i];

			/* Recherche du plus petit j tel que x1[j]>=x */
			for ( ; j<nb1 && x1[j]<x ; j++);

			if (j==nb1) {	/* extrapolation aprs le dernier point */

				j-=2;
				if (j>=0) {
					y2[i] = y1[j] + (y1[j+1]-y1[j]) / (x1[j+1]-x1[j]) * (x-x1[j]);
				}

			} else if (x1[j]==x) {

				y2[i] = y1[j];

			} else if (j == 0) {		/* extrapolation avant le premier point	*/

				y2[i] = y1[0] + (y1[1]-y1[0]) / (x1[1]-x1[0]) * (x-x1[0]);

			} else {

				j--;
				y2[i] = y1[j] + (y1[j+1]-y1[j]) / (x1[j+1]-x1[j]) * (x-x1[j]);

			}

		}

	} else {

		// dcroissant

		j = 0;

		for (i=0 ; i<nb2 ; i++) {

			x = x2[i];

			/* Recherche du plus petit j tel que x1[j]<=x */
			for ( ; j<nb1 && x1[j]>x ; j++);

			if (j==nb1) {	/* extrapolation aprs le dernier point */

				j-=2;
				if (j>=0) {
					y2[i] = y1[j] + (y1[j+1]-y1[j]) / (x1[j+1]-x1[j]) * (x-x1[j]);
				}

			} else if (x1[j]==x) {

				y2[i] = y1[j];

			} else if (j == 0) {		/* extrapolation avant le premier point	*/

				y2[i] = y1[0] + (y1[1]-y1[0]) / (x1[1]-x1[0]) * (x-x1[0]);

			} else {

				j--;
				y2[i] = y1[j] + (y1[j+1]-y1[j]) / (x1[j+1]-x1[j]) * (x-x1[j]);

			}

		}

	}

}


/*---------------------------------------------------------------------------*/
void GET_VB (int argc, void *argv[]) {
/*---------------------------------------------------------------------------*/

	int	nbarg			= 0;
	float	FILLVAL			= *(float *)	argv[nbarg++];	// entres: valeur simple
	int	nb			= *(int *)	argv[nbarg++];	// entres: nombre de valeurs dans les tableaux
	float	*Bx			= (float *)	argv[nbarg++];	// entres: Bx[nb]
	float	*By			= (float *)	argv[nbarg++];	// entres: By[nb]
	float	*Bz			= (float *)	argv[nbarg++];	// entres: Bz[nb]
	float	*Vx			= (float *)	argv[nbarg++];	// entres: Vx[nb]
	float	*Vy			= (float *)	argv[nbarg++];	// entres: Vy[nb]
	float	*Vz			= (float *)	argv[nbarg++];	// entres: Vz[nb]
	float	*Qx			= (float *)	argv[nbarg++];	// entres: Qx[nb]
	float	*Qy			= (float *)	argv[nbarg++];	// entres: Qy[nb]
	float	*Qz			= (float *)	argv[nbarg++];	// entres: Qz[nb]
	float	*Pp_nPa			= (float *)	argv[nbarg++];	// entres: Pp_nPa[nb]
	float	*Pper_nPa		= (float *)	argv[nbarg++];	// entres: Pper_nPa[nb]
	float	*N_cm3			= (float *)	argv[nbarg++];	// entres: N_cm3[nb]
	double	MASSE			= *(double *)	argv[nbarg++];	// entres: variable simple
	float	*Vxpar			= (float *)	argv[nbarg++];	// sorties: Vxpar[nb]
	float	*Vypar			= (float *)	argv[nbarg++];	// sorties: Vypar[nb]
	float	*Vzpar			= (float *)	argv[nbarg++];	// sorties: Vzpar[nb]
	float	*Vpar			= (float *)	argv[nbarg++];	// sorties: Vpar[nb]
	float	*Vxper			= (float *)	argv[nbarg++];	// sorties: Vxper[nb]
	float	*Vyper			= (float *)	argv[nbarg++];	// sorties: Vyper[nb]
	float	*Vzper			= (float *)	argv[nbarg++];	// sorties: Vzper[nb]
	float	*Vper			= (float *)	argv[nbarg++];	// sorties: Vper[nb]
	float	*Elx			= (float *)	argv[nbarg++];	// sorties: Elx[nb]
	float	*Ely			= (float *)	argv[nbarg++];	// sorties: Ely[nb]
	float	*Elz			= (float *)	argv[nbarg++];	// sorties: Elz[nb]
	float	*El			= (float *)	argv[nbarg++];	// sorties: El[nb]
	float	*Pm_nPa			= (float *)	argv[nbarg++];	// sorties: Pm_nPa[nb]
	float	*Pt_nPa			= (float *)	argv[nbarg++];	// sorties: Pt_nPa[nb]
	float	*Beta			= (float *)	argv[nbarg++];	// sorties: Beta[nb]
	float	*TBD_nPa		= (float *)	argv[nbarg++];	// sorties: TBD_nPa[nb]
	float	*Vxalfven_km_sec	= (float *)	argv[nbarg++];	// sorties: Vxalfven_km_sec[nb]
	float	*Vyalfven_km_sec	= (float *)	argv[nbarg++];	// sorties: Vyalfven_km_sec|nb]
	float	*Vzalfven_km_sec	= (float *)	argv[nbarg++];	// sorties: Vzalfven_km_sec[nb]
	float	*Valfven_km_sec		= (float *)	argv[nbarg++];	// sorties: Valfven_km_sec[nb]
	float	*Qxpar			= (float *)	argv[nbarg++];	// sorties: Qxpar[nb]
	float	*Qypar			= (float *)	argv[nbarg++];	// sorties: Qypar[nb]
	float	*Qzpar			= (float *)	argv[nbarg++];	// sorties: Qzpar[nb]
	float	*Qpar			= (float *)	argv[nbarg++];	// sorties: Qpar[nb]
	float	*Qxper			= (float *)	argv[nbarg++];	// sorties: Qxper[nb]
	float	*Qyper			= (float *)	argv[nbarg++];	// sorties: Qyper[nb]
	float	*Qzper			= (float *)	argv[nbarg++];	// sorties: Qzper[nb]
	float	*Qper			= (float *)	argv[nbarg++];	// sorties: Qper[nb]


	int	i;
	int	pb_B,pb_V;
	float 	B[3]={0,0,0};	// initialise sinon warning gcc "may be used uninitialized in this function"
	float	V[3]={0,0,0};	// initilaise sinon warning gcc "may be used uninitialized in this function"
	float	Q[3];
	float	V_vectoriel_B[3];
	// INUTILE float	Q_vectoriel_B[3];
	// INUTILE float	V_vectoriel_B_vectoriel_B[3];
	// INUTILE float	Q_vectoriel_B_vectoriel_B[3];
	float	module_B=0;
	float	produit_scalaire_V_B;
	float	produit_scalaire_Q_B;
	float	Vpar1;
	float	Qpar1;
	#define	MU0	(4*M_PI*1E-7)

	if (nbarg != argc) return;

	for (i=0 ; i<nb ; i++) {

		/*	Calcul de la vitesse d'Alfven: Valfven = B / SQRT(mu0*masse*densite)
			-------------------------------------------------------------------	*/
		if (N_cm3[i] != FILLVAL && N_cm3[i] >0 && Bx[i] != FILLVAL && By[i] != FILLVAL && Bz[i] != FILLVAL) {
			Vxalfven_km_sec[i] = (Bx[i]*1E-9) / sqrt(MU0*MASSE*(N_cm3[i]*1E6)) / 1E3;
			Vyalfven_km_sec[i] = (By[i]*1E-9) / sqrt(MU0*MASSE*(N_cm3[i]*1E6)) / 1E3;
			Vzalfven_km_sec[i] = (Bz[i]*1E-9) / sqrt(MU0*MASSE*(N_cm3[i]*1E6)) / 1E3;
			Valfven_km_sec[i] = module_xyz (Vxalfven_km_sec[i], Vyalfven_km_sec[i], Vzalfven_km_sec[i]);
		}

		/*	Calcul du vecteur CHAMP MAGNETIQUE (B)
			--------------------------------------	*/
		pb_B = (Bx[i]==FILLVAL) || (By[i]==FILLVAL) || (Bz[i]==FILLVAL);
		if (pb_B==0) { 
			B[0] = Bx[i];
			B[1] = By[i];
			B[2] = Bz[i];
			module_B = module_v1 (B);
			pb_B = module_B == 0;
		}

		/* 	Calcul de Qxpar, Qypar, Qzpar, Qpar, Qxper, Qyper, Qzper, Qper
			--------------------------------------------------------------	*/
		if (pb_B==0 && Qx[i] != FILLVAL && Qy[i] != FILLVAL && Qz[i] != FILLVAL) {
			Q[0] = Qx[i];
			Q[1] = Qy[i];
			Q[2] = Qz[i];
			produit_scalaire_Q_B = produit_scalaire_v1_v2 (Q, B);
			Qpar1 = produit_scalaire_Q_B / module_B;
			Qxpar[i] = B[0]/module_B*Qpar1;
			Qypar[i] = B[1]/module_B*Qpar1;
			Qzpar[i] = B[2]/module_B*Qpar1;
			Qpar[i]  = Qpar1;

			// INUTILE v1_vectoriel_v2 (Q, B, Q_vectoriel_B);
			// INUTILE v1_vectoriel_v2 (Q_vectoriel_B, B, Q_vectoriel_B_vectoriel_B);

			// INUTILE Qxper[i] = -Q_vectoriel_B_vectoriel_B[0] / (module_B*module_B);
			// INUTILE Qyper[i] = -Q_vectoriel_B_vectoriel_B[1] / (module_B*module_B);
			// INUTILE Qzper[i] = -Q_vectoriel_B_vectoriel_B[2] / (module_B*module_B);

			Qxper[i] = Q[0] - Qxpar[i];
			Qyper[i] = Q[1] - Qypar[i];
			Qzper[i] = Q[2] - Qzpar[i];
			Qper[i] = module_xyz (Qxper[i], Qyper[i], Qzper[i]);

		}

		/*	Calcul Pression magnetique: Pm = B*B/(2*mu0) en kg/(m.sec2) equivalent a Newton/m2 = Pa
			---------------------------------------------------------------------------------------	*/
		if (pb_B==0) {
			Pm_nPa[i] = ((Bx[i]*1E-9)*(Bx[i]*1E-9) + (By[i]*1E-9)*(By[i]*1E-9) + (Bz[i]*1E-9)*(Bz[i]*1E-9)) / (2*(4*M_PI*1E-7)) * 1E9;
			Pt_nPa[i] = Pp_nPa[i] + Pm_nPa[i];
		}

		/*	Calcul TBD = Pper + Pm 
			----------------------	*/
		if (Pper_nPa[i] != FILLVAL && Pm_nPa[i] != FILLVAL) {
			TBD_nPa[i] = Pper_nPa[i] + Pm_nPa[i];
		}

		/*	Calcul Beta = Pp / Pm sans unite
			--------------------------------	*/
		if (Pm_nPa[i] != 0 && Pm_nPa[i] != FILLVAL && Pp_nPa[i] != FILLVAL) {
			Beta[i] = Pp_nPa[i] / Pm_nPa[i];
		}


		/*	Calcul du vecteur VITESSE (V)
			-----------------------------	*/
		pb_V = (Vx[i]==FILLVAL) || (Vy[i]==FILLVAL) || (Vz[i]==FILLVAL);
		if (pb_V==0) { 
			V[0] = Vx[i];
			V[1] = Vy[i];
			V[2] = Vz[i];
		}

		/* 	Calcul de Vxpar, Vypar, Vzpar, Vpar, Vxper, Vyper, Vzper, Vper, Elx, Ely, Elz, El
			---------------------------------------------------------------------------------	*/
		if (pb_B==0 && pb_V==0) {
			produit_scalaire_V_B = produit_scalaire_v1_v2 (V, B);
			Vpar1 = produit_scalaire_V_B / module_B;
			Vxpar[i] = B[0]/module_B*Vpar1;
			Vypar[i] = B[1]/module_B*Vpar1;
			Vzpar[i] = B[2]/module_B*Vpar1;
			Vpar[i]  = Vpar1;

			v1_vectoriel_v2 (V, B, V_vectoriel_B);
			// INUTILE v1_vectoriel_v2 (V_vectoriel_B, B, V_vectoriel_B_vectoriel_B);

			// INUTILE Vxper[i] = -V_vectoriel_B_vectoriel_B[0] / (module_B*module_B);
			// INUTILE Vyper[i] = -V_vectoriel_B_vectoriel_B[1] / (module_B*module_B);
			// INUTILE Vzper[i] = -V_vectoriel_B_vectoriel_B[2] / (module_B*module_B);

			Vxper[i] = V[0] - Vxpar[i];
			Vyper[i] = V[1] - Vypar[i];
			Vzper[i] = V[2] - Vzpar[i];
			Vper[i] = module_xyz (Vxper[i], Vyper[i], Vzper[i]);

			Elx[i] = -V_vectoriel_B[0]/1e3;
			Ely[i] = -V_vectoriel_B[1]/1e3;
			Elz[i] = -V_vectoriel_B[2]/1e3;
			El[i] = module_xyz (Elx[i], Ely[i], Elz[i]);
		}
	}

}

/*---------------------------------------------------------------------------*/
void GET_VB_AUTO_GLUE (
/*---------------------------------------------------------------------------*/
	void	*p01,
	void	*p02,
	void	*p03,
	void	*p04,
	void	*p05,
	void	*p06,
	void	*p07,
	void	*p08,
	void	*p09,
	void	*p10,
	void	*p11,
	void	*p12,
	void	*p13,
	void	*p14,
	void	*p15,
	void	*p16,
	void	*p17,
	void	*p18,
	void	*p19,
	void	*p20,
	void	*p21,
	void	*p22,
	void	*p23,
	void	*p24,
	void	*p25,
	void	*p26,
	void	*p27,
	void	*p28,
	void	*p29,
	void	*p30,
	void	*p31,
	void	*p32,
	void	*p33,
	void	*p34,
	void	*p35,
	void	*p36,
	void	*p37,
	void	*p38,
	void	*p39,
	void	*p40,
	void	*p41,
	void	*p42,
	void	*p43) {

	int	argc=43;
	void	*argv[43];

	argv[ 0] = p01;
	argv[ 1] = p02;
	argv[ 2] = p03;
	argv[ 3] = p04;
	argv[ 4] = p05;
	argv[ 5] = p06;
	argv[ 6] = p07;
	argv[ 7] = p08;
	argv[ 8] = p09;
	argv[ 9] = p10;
	argv[10] = p11;
	argv[11] = p12;
	argv[12] = p13;
	argv[13] = p14;
	argv[14] = p15;
	argv[15] = p16;
	argv[16] = p17;
	argv[17] = p18;
	argv[18] = p19;
	argv[19] = p20;
	argv[20] = p21;
	argv[21] = p22;
	argv[22] = p23;
	argv[23] = p24;
	argv[24] = p25;
	argv[25] = p26;
	argv[26] = p27;
	argv[27] = p28;
	argv[28] = p29;
	argv[29] = p30;
	argv[30] = p31;
	argv[31] = p32;
	argv[32] = p33;
	argv[33] = p34;
	argv[34] = p35;
	argv[35] = p36;
	argv[36] = p37;
	argv[37] = p38;
	argv[38] = p39;
	argv[39] = p40;
	argv[40] = p41;
	argv[41] = p42;
	argv[42] = p43;
	GET_VB (argc, argv);

}


/*---------------------------------------------------------------------------*/
void matrice_transposee_double (double A[3][3], double AT[3][3]) {
/*---------------------------------------------------------------------------*/

	int	i;
	int	j;

	for (i=0 ; i<3 ; i++) {

		for (j=0 ; j<3 ; j++) {

			AT[i][j] = A[j][i];

		}

	}

			
}


/*---------------------------------------------------------------------------*/
void matrice_multiplier_double (double A[3][3], double B[3][3], double R[3][3]) {
/*---------------------------------------------------------------------------*/

	int	i;
	int	j;
	int	k;

	for (i=0 ; i<3 ; i++) {

		for (j=0 ; j<3 ; j++) {

			R[i][j] = 0;

			for (k=0 ; k<3 ; k++) {

				R[i][j] += A[i][k] * B[k][j];

			}

		}

	}

}


/*---------------------------------------------------------------------------*/
double min3_double (double X, double Y, double Z) {
/*---------------------------------------------------------------------------*/

	if (X < Y && X < Z)	return X;

	if (Y < X && Y < Z)	return Y;

	return Z;

}


/*---------------------------------------------------------------------------*/
double max3_double (double X, double Y, double Z) {
/*---------------------------------------------------------------------------*/

	if (X > Y && X > Z)	return X;

	if (Y > X && Y > Z)	return Y;

	return Z;

}


/*---------------------------------------------------------------------------*/
void INDYPHI (int argc, void *argv[]) {
/*---------------------------------------------------------------------------*/

	int	nbarg				= 0;
	int	nbspins				= *(int *)	argv[nbarg++];
	int	nbspectres1			= *(int *)	argv[nbarg++];
	int	nocis				= *(int *)	argv[nbarg++];
	short	*mag				= (short *)	argv[nbarg++]; /* mag[nbspins] */
	int	B				= *(int *)	argv[nbarg++]; 
	short	*hvtbl				= (short *)	argv[nbarg++]; /* hvtbl[nbspins] */
	short	*cis_mode			= (short *)	argv[nbarg++]; /* cis_mode[nbspins] */
	short	*sweep_number			= (short *)	argv[nbarg++]; /* sweep_number[nbspins] */
	int	*indYphi			= (int *)	argv[nbarg++]; /*	si sweep_number[0]=-1 alors indYphi[nbspins*nbspectres] 
											sinon                       indYphi[nbspins] */
	int	*start_pollution_solaire	= (int *)	argv[nbarg++]; /* start_pollution_solaire[nbspins] */
	int	*end_pollution_solaire		= (int *)	argv[nbarg++]; /* end_pollution_solaire[nbspins] */
	int	*indYphiorg			= (int *)	argv[nbarg++]; /* indYphiorg[nbspins] */

	int	nbspectres;
	int	ispin;
	int	ispectre;
	int	nospectre;
	int 	start_psolaire;
	int	end_psolaire;
	int	start_pantisolaire;
	int	end_pantisolaire;
	int 	use_sweep;

	if (nbarg != argc) return;

	use_sweep = sweep_number[0] != -1;

	nbspectres = use_sweep ? 32:nbspectres1;

	for (ispin=0 ; ispin<nbspins ; ispin++) { 

		if (is_CODIF(nocis)==0 && is_HIA(nocis)==0 && is_DSP(nocis)==0) {
			for (ispectre=0 ; ispectre<nbspectres ; ispectre++) { 
				nospectre = ispin*nbspectres+ispectre;
				indYphi[nospectre] = indYphiorg[ispin];
			}
			
		}

		if (mag[ispin]==1) continue; /* Mode Magnetospherique: on laisse la table a 0 */

		start_psolaire = start_pollution_solaire[ispin]; /* spectres ou le detecteur est pollue par le soleil */
		end_psolaire = end_pollution_solaire[ispin];

		if (is_CODIF(nocis)) { 

			for (ispectre=start_psolaire ; ispectre<=end_psolaire ; ispectre++) { 

				if (use_sweep) { 

					nospectre = ispectre % nbspectres;
					if (sweep_number[ispin]==nospectre)
						indYphi[ispin] = 1; /* Table 1 = table SW */
				} 

				else { 

					nospectre = ispin*nbspectres+(ispectre % nbspectres);
					indYphi[nospectre] = 1; /* Table 1 = table SW */
				}
			}
		}

		else if (is_HIA(nocis) || is_DSP(nocis)) { 

			if (B==1) /* Balayage G */ { 

				for (ispectre=0 ; ispectre<nbspectres ; ispectre++) { 

					nospectre = ispin*nbspectres+ispectre;
					indYphi[nospectre] = 9;
				}

				for (ispectre=start_psolaire ; ispectre<=end_psolaire ; ispectre++)/* pollution solaire */ { 

					nospectre = ispin*nbspectres+(ispectre % nbspectres);
					indYphi[nospectre] = 10; /* Table 10 = G vent solaire */
				}

				/* Uniquement en Priority SOLAR WIND (modes 0, 2 et 4) */
				if (cis_mode[ispin]==0 || cis_mode[ispin]==2 || cis_mode[ispin]==4) {

					start_pantisolaire = (start_psolaire + nbspectres/2) % nbspectres;
					end_pantisolaire = (end_psolaire + nbspectres/2) % nbspectres;

					for (ispectre=start_pantisolaire ; ispectre<=end_pantisolaire ; ispectre++) /* pollution antisolaire */ { 

						nospectre = ispin*nbspectres+(ispectre % nbspectres);
						indYphi[nospectre] = -1; /* Suppression des donnees */
					}
				}

			}

			else { 

				for (ispectre=0 ; ispectre<nbspectres ; ispectre++) /* tous les spectres sont en direction solaire */ { 

					nospectre = ispin*nbspectres+ispectre;
					indYphi[nospectre] = hvtbl[ispin];
				}
			}
		}
	}

}


/*---------------------------------------------------------------------------*/
void INDYPHI_AUTO_GLUE (
/*---------------------------------------------------------------------------*/
	void	*p01,
	void	*p02,
	void	*p03,
	void	*p04,
	void	*p05,
	void	*p06,
	void	*p07,
	void	*p08,
	void	*p09,
	void	*p10,
	void	*p11,
	void	*p12) {

	int	argc=12;
	void	*argv[12];

	argv[ 0] = p01;
	argv[ 1] = p02;
	argv[ 2] = p03;
	argv[ 3] = p04;
	argv[ 4] = p05;
	argv[ 5] = p06;
	argv[ 6] = p07;
	argv[ 7] = p08;
	argv[ 8] = p09;
	argv[ 9] = p10;
	argv[10] = p11;
	argv[11] = p12;
	return INDYPHI (argc, argv);

}


#define POLLUTION_SOLAIRE	1
#define POLLUTION_ANTISOLAIRE	2

/*---------------------------------------------------------------------------*/
void pollution_maj (
	int		nocis,
	int 		ispin,
	short		*cis_mode,
	int 		*start_pollution_solaire,
	int 		*end_pollution_solaire,
	int 		nbspectres,
	int 		nbcellules,
	int 		nbangles,
	int 		*solid,
	unsigned char 	*pollution) {
/*---------------------------------------------------------------------------*/

	int 	ispectre;
	int 	icellule;
	int 	iangle;
	int 	startantiSW;
	int	endantiSW;

	if (!is_CODIF(nocis) && !is_HIA(nocis) && !is_DSP(nocis))	/* pollution uniquement pour CODIF, HIA et DOUBLE STAR */
		return;

	for (iangle=0 ; iangle<nbangles ; iangle++)
		pollution [iangle] = 0;

	/* Les spectres direction solaire (entre start_pollution_solaire et end_pollution_solaire) sont pollues. 
	Toutes les cellules de ces spectres sont pollues. Mais puisque les coups des
	angles polaires sont parfois sommes, cela peut entrainer la pollution des
	cellules polaires des spectres adjacents.


	Cette pollution solaire est codee '1'. */

	for (ispectre=start_pollution_solaire[ispin] ; ; ispectre = ((ispectre+1) % nbspectres)) {

		for (icellule=0 ; icellule<nbcellules ; icellule++) 
			pollution [solid[indice2(ispectre,icellule,nbspectres,nbcellules)]] = POLLUTION_SOLAIRE;

		if (ispectre == end_pollution_solaire[ispin])
			break;
	}


	/* Pour HIA en priorite SOLAR WIND, c'est a dire pour les modes 0, 2, 4, les spectres anti-solaires sont aussi pollues.

	Cette pollution est codee '2'. */

	if ((is_HIA(nocis) || is_DSP(nocis)) && (cis_mode[ispin]==0 || cis_mode[ispin]==2 || cis_mode[ispin]==4)) {

		startantiSW = (start_pollution_solaire[ispin]+nbspectres/2) % nbspectres;
		endantiSW = (end_pollution_solaire[ispin]+nbspectres/2) % nbspectres;

		for (ispectre=startantiSW ; ; ispectre = ((ispectre+1) % nbspectres)) {

			for (icellule=0 ; icellule<nbcellules ; icellule++) 
				pollution [solid[indice2(ispectre,icellule,nbspectres,nbcellules)]] = POLLUTION_ANTISOLAIRE;

			if (ispectre == endantiSW)
				break;
		}

	}

}



/*---------------------------------------------------------------------------*/
#define POLLUTION_ON() {														\
/*---------------------------------------------------------------------------*/								\
																	\
/*	Ne dpend pas de imasse, dpend de												\
		- ispin															\
		- ispectre														\
		- icellule														\
		- ienergie														\
*/																	\
																	\
	if (mag[ispin]==1) {														\
																	\
		/* pas de pollution en mode magntospherique */										\
		pollue = 0;														\
																	\
	} else if (is_CODIF(nocis)) {													\
																	\
		/* CODIF */														\
																	\
		if (pollution[solid[indice2(ispectre,icellule,nbspectres,nbcellules)]] == POLLUTION_SOLAIRE &&				\
			Emin[indice2(1,ienergie,nbtablesE,nbenergies)] == Emax[indice2(1,ienergie,nbtablesE,nbenergies)]) {		\
																	\
			/* pollution solaire CODIF si la table 1  l'nergie demande est bloque */					\
			pollue = 1;													\
																	\
		} else {														\
																	\
			pollue = 0;													\
																	\
		}															\
																	\
	} else if (is_HIA(nocis) || is_DSP(nocis)) {											\
																	\
		/* Forcement HIA ou DSP */												\
																	\
		if (sensitivity[ispin]==0) {												\
																	\
			/* pas de pollution en low g HIA */										\
			pollue = 0;													\
																	\
		} else {														\
																	\
			if (pollution[solid[indice2(ispectre,icellule,nbspectres,nbcellules)]] == POLLUTION_SOLAIRE &&			\
				Emin[indice2(10,ienergie,nbtablesE,nbenergies)] == Emax[indice2(10,ienergie,nbtablesE,nbenergies)]) {	\
																	\
				/* pollution solaire HIA si la table 10  l'nergie demande est bloque */				\
				pollue = 1;												\
																	\
			} else if (pollution[solid[indice2(ispectre,icellule,nbspectres,nbcellules)]] == POLLUTION_ANTISOLAIRE) {	\
																	\
				/* pollution anti-solaire HIA  toutes les energies */							\
				pollue = 1;												\
																	\
			} else {													\
																	\
				pollue = 0;												\
			}														\
																	\
		}															\
																	\
	} else {															\
																	\
		/* pollution possible que pour CODIF, HIA et DSP */									\
		pollue = 0;														\
																	\
	}																\
}


/*---------------------------------------------------------------------------*/
void tabphi_to_okspectre (int B, int *tabphi, int nbspectres, int *start, int ispin,
	short *produit1, int prodmin, int prodmax, unsigned char *okspectre, int nocis) {
/*---------------------------------------------------------------------------*/

	int	i;
	int	dir;
	int	premier_spectre;
	int	dernier_spectre;

	if (produit1[ispin]<prodmin || produit1[ispin]>prodmax) {
		for (i=0 ; i<nbspectres ; i++) okspectre[i]=0;
		return;
	}

	if (tabphi[0]<0) {
		for (i=0 ; i<nbspectres ; i++) okspectre[i]=0; /* On rejette d'abord tous les spectres */

		/* Puis on garde ceux dans la direction demandee:
			- tabphi[0] = -1 pour Sun  dir=0
			- tabphi[0] = -2 pour Dawn dir=1
			- tabphi[0] = -3 pour Tail dir=2
			- tabphi[0] = -4 pour Dusk dir=3 */
		dir = -tabphi[0]-1; /* 0=Sun, 1=Dawn, 2=Tail, 3=Dusk */

		/* Pour CLUSTER, les donnees sont fournies dans l'ordre Sun, Dawn, Tail, Dusk */
		/* Pour DOUBLE-STAR, les donnees sont fournies dans l'ordre Sun, Dusk, Tail, Dawn */
		if (is_DSP(nocis)) { /* DSP et CLUSTER ne tournent pas dans le meme sens */
			if (dir == 1) {
				dir = 3;
			} else if (dir == 3) {
				dir = 1;
			}
		}
		if (B==0) {
			/* Balayage en petit g donc tous les spectres sont direction solaire */
			if (dir==0) {
				premier_spectre=0;
				dernier_spectre=nbspectres-1;
			} else {
				/* Donc rien dans les 3 autres directions */
				return;
			}
		} else {
			/* Grand G: selection en direction */
			premier_spectre = start[ispin]+nbspectres/4*dir;
			dernier_spectre = premier_spectre+nbspectres/4-1;
		}
		for (i=premier_spectre ; i<=dernier_spectre ; i++) okspectre[i % nbspectres]=1;
	} else {
		for (i=0 ; i<nbspectres ; i++) okspectre[i]=tabphi[i]; /* On garde les spectres specifies dans tabphi */
	}

}

/*----------------------------------------------------------------------------*/
double Cmoy (double x, double y) {
/*----------------------------------------------------------------------------*/
	/* x: Angle debut (en rad) */
	/* y: Angle fin (en rad) */

	/* Renvoie le cos moyen entre x et y */

	double	d;

	d=y-x;
	return 1./d*(sin(x+d)-sin(x));

}

/*----------------------------------------------------------------------------*/
double Smoy (double x, double y) {
/*----------------------------------------------------------------------------*/
	/* x: Angle debut (en rad) */
	/* y: Angle fin (en rad) */

	/* Renvoie le sin moyen entre x et y */

	double	d;

	d=y-x;
	return 1./d*(cos(x)-cos(x+d));

}


/*----------------------------------------------------------------------------*/
double C2moy (double x, double y) {
/*----------------------------------------------------------------------------*/
	/* x: Angle debut (en rad) */
	/* y: Angle fin (en rad) */

	/* Renvoie le cos*cos moyen entre x et y */

	double	d;

	d=y-x;
	return 1./(4*d)*(sin(2*(x+d))-sin(2*x)+2*d);

}


/*----------------------------------------------------------------------------*/
double S2moy (double x, double y) {
/*----------------------------------------------------------------------------*/
	/* x: Angle debut (en rad) */
	/* y: Angle fin (en rad) */

	/* Renvoie le sin*sin moyen entre x et y */

	double	d;

	d=y-x;
	return 1./(4*d)*(sin(2*x)-sin(2*(x+d))+2*d);

}


/*----------------------------------------------------------------------------*/
double CSmoy (double x, double y) {
/*----------------------------------------------------------------------------*/
	/* x: Angle debut (en rad) */
	/* y: Angle fin (en rad) */

	/* Renvoie le cos*sin moyen entre x et y */

	double	d;

	d=y-x;
	return 1./(2*d)*(sin(x+d)*sin(x+d)-sin(x)*sin(x));

}


/*----------------------------------------------------------------------------*/
double C2Smoy (double x, double y) {
/*----------------------------------------------------------------------------*/
	/* x: Angle debut (en rad) */
	/* y: Angle fin (en rad) */

	/* Renvoie le cos*cos*sin moyen entre x et y */

	double	d;

	d=y-x;
	return -1./(3*d)*(cos(x+d)*cos(x+d)*cos(x+d)-cos(x)*cos(x)*cos(x));

}


/*----------------------------------------------------------------------------*/
double S2Cmoy (double x, double y) {
/*----------------------------------------------------------------------------*/
	/* x: Angle debut (en rad) */
	/* y: Angle fin (en rad) */

	/* Renvoie le sin*sin*cos moyen entre x et y */

	double	d;

	d=y-x;
	return 1./(3*d)*(sin(x+d)*sin(x+d)*sin(x+d)-sin(x)*sin(x)*sin(x));

}


/*----------------------------------------------------------------------------*/
double C3moy (double x, double y) {
/*----------------------------------------------------------------------------*/
	/* x: Angle debut (en rad) */
	/* y: Angle fin (en rad) */

	/* Renvoie le cos*cos*cos moyen entre x et y */

	double	d;

	d=y-x;
	return 1./d*(sin(x+d)-sin(x)- 1./3*(sin(x+d)*sin(x+d)*sin(x+d)-sin(x)*sin(x)*sin(x)));
}


/*----------------------------------------------------------------------------*/
double module (double X, double Y, double Z) {
/*----------------------------------------------------------------------------*/

	/* Renvoie le module du vecteur (X,Y,Z) */

	return (sqrt(X*X + Y*Y + Z*Z));

}


#define DIM 3
/*----------------------------------------------------------------------------*/
int jacobi (double A[DIM][DIM], double D[DIM], double V[DIM][DIM]) {
/*----------------------------------------------------------------------------*/
/*
	A matrice symetrique. Cette fonction calcule les valeurs propres et
	les vecteurs propres de A.
	Le vecteur D contient les valeurs propres.
	V contient les vecteurs propres.
	Code retour =
		0  si algo ok
		-1 ne devrait jamais arriver
*/

	int	nrot;
	int	ip;	/* indice des lignes */
	int	iq;	/* indice des colonnes */
	int	i;	/* indice de boucle */
	int	j;	/* indice de boucle */
	double	B[DIM];
	double	Z[DIM];	/* accumule les termes t*a[p][q] */
	double	somme;	/* somme des valeurs absolues des termes extra-diagonaux */
	double	tresh;	/* seuil */
	double	h;
	double	t;
	double	g;
	double	c;
	double	s;
	double	tau;
	double	theta;
	#define	EPSILON 1.0E-9

	/* Initialisation de V avec la matrice unite */
	for (ip = 0 ; ip < DIM ; ip++) {
		for (iq = 0 ; iq < DIM ; iq++)
			V[ip][iq] = 0; 
		V[ip][ip] = 1;
	}

	/* Initialisation de B et D avec la diagonale de A */
	for (ip = 0 ; ip < DIM ; ip++) {
		B[ip] = A[ip][ip];
		D[ip] = A[ip][ip];
		Z[ip] = 0;
	}

	nrot = 0;

	for (i = 1 ; i <= 50 ; i++) {
		/* Somme des valeurs absolues des termes sub-diagonaux */
		somme = 0;
		for (ip = 0 ; ip < DIM-1 ; ip++)
			for (iq = ip + 1 ; iq < DIM ; iq++) 
				somme += fabs(A[ip][iq]);
		if (somme < EPSILON) /* La diagonalisation est termine */
			return 0;

		/* calcul du seuil */
		if (i < 4)
			tresh = 0.2 * somme / (double)(DIM*DIM);
		else
			tresh = 0;

		for (ip = 0 ; ip < DIM-1 ; ip++) {
			for (iq = ip + 1 ; iq < DIM ; iq++) {
				g = 100 * fabs(A[ip][iq]);
				/* Apres 4 tours de boucle, on saute la rotation si le terme extra-diagonal est trop petit */
				if (i > 4 && fabs(D[ip]) + g == fabs(D[ip]) && fabs(D[iq]) + g == fabs(D[iq])) {
					A[ip][iq] = 0;
				} else if (fabs(A[ip][iq]) > tresh) {
					h = D[iq] - D[ip];
					if (fabs(h) + g == fabs(h))
						t = A[ip][iq] / h;	/* t est egal a 1/(2theta) */
					else {
						theta = 0.5 * h / A[ip][iq];
						t = 1 / (fabs(theta) + sqrt(1 + theta*theta));
						if (theta < 0) t = -t;
					}
					c = 1 / sqrt(1 + t*t);
					s = t * c;
					tau = s / (1 + c);
					h = t * A[ip][iq];
					Z[ip] = Z[ip] - h;
					Z[iq] = Z[iq] + h;
					D[ip] = D[ip] - h;
					D[iq] = D[iq] + h;
					A[ip][iq] = 0;

					/* Cas des rotations 0 <= j < p */
					for (j = 0 ; j < ip ; j++) {
						g = A[j][ip];
						h = A[j][iq];
						A[j][ip] = g - s*(h + g*tau);
						A[j][iq] = h + s*(g - h*tau);
					}

					/* Cas des rotations p < j < q */
					for (j = ip + 1 ; j < iq ; j++) {
						g = A[ip][j];
						h = A[j][iq];
						A[ip][j] = g - s*(h + g*tau);
						A[j][iq] = h + s*(g - h*tau);
					}

					/* Cas des rotations q < j < DIM */
					for (j = iq + 1 ; j < DIM ; j++) {
						g = A[ip][j];
						h = A[iq][j];
						A[ip][j] = g - s*(h + g*tau);
						A[iq][j] = h + s*(g - h*tau);
					}

					for (j = 0 ; j < DIM ; j++) {
						g = V[j][ip];
						h = V[j][iq];
						V[j][ip] = g - s*(h + g*tau);
						V[j][iq] = h + s*(g - h*tau);
					}
					nrot++;
				}
			}
		}

		/* Mise a jour de D avec la somme des t*a[p][q] et reinitialise Z */
		for (ip = 0 ; ip < DIM ; ip++) {
			B[ip] = B[ip] + Z[ip];
			D[ip] = B[ip];
			Z[ip] = 0;
		}
	}

	return -1;

}

/*----------------------------------------------------------------------------*/
void P_to_tab (double *P, int *tab) {
/*----------------------------------------------------------------------------*/


	/*	Recherche de la valeur propre la plus differente des autres.
		tab[0] contiendra le numero de la valeur propre la plus differente 
		des autres. tab[1] contiendra la valeur propre la plus petite parmi
		les 2 autres. tab[2] contiendra la valeur propre restante */

	double	diff1;
	double	diff2;
	double	diff3;

	diff1 = fabs(P[0] - P[1]);
	diff2 = fabs(P[0] - P[2]);
	diff3 = fabs(P[1] - P[2]);
	if (diff1 < diff2 && diff1 < diff3) {
		/* 2 est la parallele */
		tab[0] = 2;
		if (P[0] < P[1]) {
			tab[1] = 0;
			tab[2] = 1;
		} else {
			tab[1] = 1;
			tab[2] = 0;
		}
	} else if (diff2 < diff1 && diff2 < diff3) {
		/* 1 est la parallele */
		tab[0] = 1;
		if (P[0] < P[2]) {
			tab[1] = 0;
			tab[2] = 2;
		} else {
			tab[1] = 2;
			tab[2] = 0;
		}
	} else {
		/* 0 est la parallele */
		tab[0] = 0;
		if (P[1] < P[2]) {
			tab[1] = 1;
			tab[2] = 2;
		} else {
			tab[1] = 2;
			tab[2] = 1;
		}
	}
}



/*----------------------------------------------------------------------------*/
void diagonaliser (double Pxx, double Pxy, double Pxz,
	double Pyy, double Pyz, double Pzz,
	double FILLVAL,
	float *Ppar, float *Pper1, float *Pper2,
	float *Ex, float *Ey, float *Ez,
	float *EV1x, float *EV1y, float *EV1z,
	float *EV2x, float *EV2y, float *EV2z,
	float *EV3x, float *EV3y, float *EV3z) {
/*----------------------------------------------------------------------------*/

	/*
	Le tenseur de pression	(Pxx Pxy Pxz)
				(Pxy Pyy Pyz)
				(Pxz Pyz Pzz) 

	est diagonalise pour obtenir 3 valeurs propres:

		- la plus differente des 3 est Ppar
		- la plus petite des 2 autres est Pper1
		- celle restante est Pper2
	*/

	double	A[3][3];
	double	V[3][3];
	double	P[3];
	int	tab[3];
	int	codret;
	#define	SEUIL 1e-5

	*Ppar=*Pper1=*Pper2=*Ex=*Ey=*Ez=FILLVAL;

	/* Verifions que la matrice des tenseurs n'est pas nulle */
	if (fabs(Pxx) < SEUIL && fabs(Pxy) < SEUIL && fabs(Pxz) < SEUIL && fabs(Pyy) < SEUIL && fabs(Pyz) < SEUIL && fabs(Pzz) < SEUIL) 
		return;

	A[0][0] =           Pxx;
	A[0][1] = A[1][0] = Pxy;
	A[0][2] = A[2][0] = Pxz;
	A[1][1] =           Pyy;
	A[1][2] = A[2][1] = Pyz;
	A[2][2] =           Pzz;

	codret = jacobi(A,P,V);
	/*	P contient les valeurs propres
		V contient les vecteurs propres */

	/* Les valeurs propres tres petites sont considerees comme nulles */
	if (fabs(P[0]) < SEUIL) P[0]=0;
	if (fabs(P[1]) < SEUIL) P[1]=0;
	if (fabs(P[2]) < SEUIL) P[2]=0;

	/* En cas de problme */
	if (codret == -1 || P[0] < 0 || P[1] < 0 || P[2] < 0) return;

	P_to_tab (P, tab);

	*Ppar  = P[tab[0]];
	*Pper1 = P[tab[1]];
	*Pper2 = P[tab[2]];

	/* Vecteur propre associe a la valeur propre par */
	*Ex = V[0][tab[0]];
	*Ey = V[1][tab[0]];
	*Ez = V[2][tab[0]];

	/* Premier vecteur propre */
	*EV1x = V[0][0];
	*EV1y = V[0][1];
	*EV1z = V[0][2];

	/* Second vecteur propre */
	*EV2x = V[1][0];
	*EV2y = V[1][1];
	*EV2z = V[1][2];

	/* Troisme vecteur propre */
	*EV3x = V[2][0];
	*EV3y = V[2][1];
	*EV3z = V[2][2];

}

/*---------------------------------------------------------------------------*/
void DIAGONALISER (int argc, void *argv[]) {
/*---------------------------------------------------------------------------*/

	int		nbarg			= 0;
	double		Pxx			= *(double *)		argv[nbarg++];
	double		Pxy			= *(double *)		argv[nbarg++];
	double		Pxz			= *(double *)		argv[nbarg++];
	double		Pyy			= *(double *)		argv[nbarg++];
	double		Pyz			= *(double *)		argv[nbarg++];
	double		Pzz			= *(double *)		argv[nbarg++];
	double		FILLVAL			= *(double *)		argv[nbarg++];
	float		*Ppar			= (float *)		argv[nbarg++];
	float		*Pper1			= (float *)		argv[nbarg++];
	float		*Pper2			= (float *)		argv[nbarg++];
	float		*Ex			= (float *)		argv[nbarg++];
	float		*Ey			= (float *)		argv[nbarg++];
	float		*Ez			= (float *)		argv[nbarg++];
	float		*EV1x			= (float *)		argv[nbarg++];
	float		*EV1y			= (float *)		argv[nbarg++];
	float		*EV1z			= (float *)		argv[nbarg++];
	float		*EV2x			= (float *)		argv[nbarg++];
	float		*EV2y			= (float *)		argv[nbarg++];
	float		*EV2z			= (float *)		argv[nbarg++];
	float		*EV3x			= (float *)		argv[nbarg++];
	float		*EV3y			= (float *)		argv[nbarg++];
	float		*EV3z			= (float *)		argv[nbarg++];

	diagonaliser (Pxx, Pxy, Pxz, Pyy, Pyz, Pzz,
			FILLVAL, Ppar, Pper1, Pper2, Ex, Ey, Ez, EV1x, EV1y, EV1z, EV2x, EV2y, EV2z, EV3x, EV3y, EV3z);

}


/*---------------------------------------------------------------------------*/
void GET_MATREP1_TO_MATREP2 (int argc, void *argv[]) {
/*---------------------------------------------------------------------------*/

	int	nbarg		= 0;
	int	nocis		= *(int *)	argv[nbarg++];	// Entres: numro de l'exprience (pour savoir si c'est CLUSTER)
	int	nb		= *(int *)	argv[nbarg++];	// Entres: nombre de valeurs dans les tableaux en entre
	double	*date		= (double *)	argv[nbarg++];	// Entres: date[nb] datation des tableaux avec nb valeurs
	int	nbmat		= *(int *)	argv[nbarg++];	// Entres: (utilis uniquement pour CLUSTER) nombre d'lments dans les tableaux datemat et M00, M01 ... M22
	double	*datemat	= (double *)	argv[nbarg++];	// Entres: (utilis uniquement pour CLUSTER) daterepgse[nbmat]
	float	*M00		= (float *)	argv[nbarg++];	// Entres: (utilis uniquement pour CLUSTER) M00[nbmat]
	float	*M01		= (float *)	argv[nbarg++];	// Entres: (utilis uniquement pour CLUSTER) M01[nbmat]
	float	*M02		= (float *)	argv[nbarg++];	// Entres: (utilis uniquement pour CLUSTER) M02[nbmat]
	float	*M10		= (float *)	argv[nbarg++];	// Entres: (utilis uniquement pour CLUSTER) M10[nbmat]
	float	*M11		= (float *)	argv[nbarg++];	// Entres: (utilis uniquement pour CLUSTER) M11[nbmat]
	float	*M12		= (float *)	argv[nbarg++];	// Entres: (utilis uniquement pour CLUSTER) M12[nbmat]
	float	*M20		= (float *)	argv[nbarg++];	// Entres: (utilis uniquement pour CLUSTER) M20[nbmat]
	float	*M21		= (float *)	argv[nbarg++];	// Entres: (utilis uniquement pour CLUSTER) M21[nbmat]
	float	*M22		= (float *)	argv[nbarg++];	// Entres: (utilis uniquement pour CLUSTER) M22[nbmat]
	float	FILLVAL		= *(float *)	argv[nbarg++];	// Entres: valeur fillaire utilise dans Bx, By, Bz, N_cm3, xx1, xy1, xz1, yy1, yz1, zz1
	float	*phi1		= (float *)	argv[nbarg++];	// Entres: (utilis uniquement pour CLUSTER) phi1[nb]
	float	*phi2		= (float *)	argv[nbarg++];	// Entres: (utilis uniquement pour CLUSTER) phi2[nb]
	float	*Bx		= (float *)	argv[nbarg++];	// Entres: Bx[nb]
	float	*By		= (float *)	argv[nbarg++];	// Entres: By[nb]
	float	*Bz		= (float *)	argv[nbarg++];	// Entres: Bz[nb]
	float	*N_cm3		= (float *)	argv[nbarg++];	// Entres: N_cm3[nb]
	float	*xx1		= (float *)	argv[nbarg++];	// Entres: lments[nb] de la matrice tenseur de pression
	float	*xy1		= (float *)	argv[nbarg++];	// Entres: lments[nb] de la matrice tenseur de pression
	float	*xz1		= (float *)	argv[nbarg++];	// Entres: lments[nb] de la matrice tenseur de pression
	float	*yy1		= (float *)	argv[nbarg++];	// Entres: lments[nb] de la matrice tenseur de pression
	float	*yz1		= (float *)	argv[nbarg++];	// Entres: lments[nb] de la matrice tenseur de pression
	float	*zz1		= (float *)	argv[nbarg++];	// Entres: lments[nb] de la matrice tenseur de pression
	float	*xx2		= (float *)	argv[nbarg++];	// Sorties: xx2[nb]
	float	*xy2		= (float *)	argv[nbarg++];	// Sorties: xy2[nb]
	float	*xz2		= (float *)	argv[nbarg++];	// Sorties: xz2[nb]
	float	*yy2		= (float *)	argv[nbarg++];	// Sorties: yy2[nb]
	float	*yz2		= (float *)	argv[nbarg++];	// Sorties: yz2[nb]
	float	*zz2		= (float *)	argv[nbarg++];	// Sorties: zz2[nb]
	float	*xx3		= (float *)	argv[nbarg++];	// Sorties: xx3[nb]
	float	*xy3		= (float *)	argv[nbarg++];	// Sorties: xy3[nb]
	float	*xz3		= (float *)	argv[nbarg++];	// Sorties: xz3[nb]
	float	*yy3		= (float *)	argv[nbarg++];	// Sorties: yy3[nb]
	float	*yz3		= (float *)	argv[nbarg++];	// Sorties: yz3[nb]
	float	*zz3		= (float *)	argv[nbarg++];	// Sorties: zz3[nb]
	float	*An		= (float *)	argv[nbarg++];	// Sorties: An[nb]
	float	*Ng		= (float *)	argv[nbarg++];	// Sorties: Ng[nb]
	float	*Ppar_b_eV_cm3	= (float *)	argv[nbarg++];	// Sorties: Ppar_b_eV_cm3[nb]
	float	*Pper1_b_eV_cm3	= (float *)	argv[nbarg++];	// Sorties: Pper1_b_eV_cm3[nb]
	float	*Pper2_b_eV_cm3	= (float *)	argv[nbarg++];	// Sorties: Pper2_b_eV_cm3[nb]
	float	*Tpar_b_eV	= (float *)	argv[nbarg++];	// Sorties: Tpar_b_eV[nb]
	float	*Tper1_b_eV	= (float *)	argv[nbarg++];	// Sorties: Tper1_b_eV[nb]
	float	*Tper2_b_eV	= (float *)	argv[nbarg++];	// Sorties: Tper2_b_eV[nb]

	int	i;
	int	j;

	double	P[3][3];
	double	A1[3][3];
	double	A1T[3][3];
	double	A2[3][3];
	double	A2T[3][3];
	double	R1[3][3];
	double	R2[3][3];
	double	R3[3][3];
	double	R4[3][3];
	double	R5[3][3];
	double	R6[3][3];
	double	b[3];
	double	Z[3];
	double	p1[3];
	double	module_p1;
	double	p2[3];
	double	A3T[3][3];
	double	A3[3][3];
	double	module_B;

	if (nbarg != argc) return;

	j=0;
	for (i=0 ; i<nb ; i++) {

		if (nocis==1 || nocis==2) {

			/* Recherche du plus petit j tel que datemat[j]>=date[i] */
			for ( ; j<nbmat && datemat[j]<date[i] ; j++);

			// on dit que la dernire donne attitude est valable 10 mn (600000 ms)
			if (j==nbmat) {
				if (j && (date[i]-datemat[j-1])<=600000) {
					j--;
				} else {
					break;
				}
			}

		}

		if (xx1[i]!=FILLVAL && xy1[i]!=FILLVAL && xz1[i]!=FILLVAL && yy1[i]!=FILLVAL && yz1[i]!=FILLVAL && zz1[i]!=FILLVAL && Bx[i]!=FILLVAL && By[i]!=FILLVAL && Bz[i]!=FILLVAL) {

			P[0][0] = xx1[i];			P[0][1] = xy1[i];			P[0][2] = xz1[i];
			P[1][0] = xy1[i];			P[1][1] = yy1[i];			P[1][2] = yz1[i];
			P[2][0] = xz1[i];			P[2][1] = yz1[i];			P[2][2] = zz1[i];

			if (nocis==1 || nocis==2) {
				A1[0][0] = cos(phi1[i] * M_PI / 180.);	A1[0][1] = cos(phi2[i] * M_PI / 180.);	A1[0][2] = 0;
				A1[1][0] = sin(phi1[i] * M_PI / 180.);	A1[1][1] = sin(phi2[i] * M_PI / 180.);	A1[1][2] = 0;
				A1[2][0] = 0;				A1[2][1] = 0;				A1[2][2] = -1;
			} else {
				// pourait tre sorti de la boucle ...
				A1[0][0] = 1;				A1[0][1] = 0;				A1[0][2] = 0;
				A1[1][0] = 0;				A1[1][1] = 1;				A1[1][2] = 0;
				A1[2][0] = 0;				A1[2][1] = 0;				A1[2][2] = 1;
			}
			matrice_transposee_double (A1, A1T);
			/* A1:	matrice permettant de passer du repere old=(SC) au repere new=(SR2):	new_sr2 = A1 . old_sc */
			/* A1T:	matrice permettant de passer du repere new=(SR2) au repere old=(SR2):	old_sc = A1T . new_sr2 */
			/* MATH: Si vecteur_X(old) = matrice_P * vecteur_X'(new) alors matrice_M'(nouveau) = P-1 . M . P */
			/* => P_sr2 = A1 . P_sc . A1T */
			matrice_multiplier_double (P, A1T, R1);		// R1 = P*A1T
			matrice_multiplier_double (A1, R1, R2);		// R2 = A1*(P*A1T)



			if (nocis==1 || nocis==2) {
				A2[0][0] = M00[j];			A2[0][1] = M01[j];			A2[0][2] = M02[j];
				A2[1][0] = M10[j];			A2[1][1] = M11[j];			A2[1][2] = M12[j];
				A2[2][0] = M20[j];			A2[2][1] = M21[j];			A2[2][2] = M22[j];
			} else {
				// pourait tre sorti de la boucle ...
				A2[0][0] = 1;				A2[0][1] = 0;				A2[0][2] = 0;
				A2[1][0] = 0;				A2[1][1] = 1;				A2[1][2] = 0;
				A2[2][0] = 0;				A2[2][1] = 0;				A2[2][2] = 1;
			}
			matrice_transposee_double (A2, A2T);
			/* A2:	matrice permettant de passer du repere old=(SR2) au repere new=(GSE):	new_gse = A2 . old_sr2 */
			/* A2T:	matrice permettant de passer du repere new=(GSE) au repere old=(SR2):	old_src = A2T . new_gse */
			/* MATH: Si vecteur_X(old) = matrice_P * vecteur_X'(new) alors matrice_M'(nouveau) = P-1 . M . P */
			/* => P_gse = A2 . P_sr2 . A2T */
			matrice_multiplier_double (R2, A2T, R3);	// R3 = (A1*(P*A1T))*A2T
			matrice_multiplier_double (A2, R3, R4);		// R4 = A2*((A1*(P*A1T))*A2T)

			// Stockage des rsultats dans (xx2, xy2, xz2, yy2, yz2, zz2)
			xx2[i] = R4[0][0];			xy2[i] = R4[0][1];			xz2[i] = R4[0][2];
								yy2[i] = R4[1][1];			yz2[i] = R4[1][2];
													zz2[i] = R4[2][2];

			/* b: vecteur unitaire le long de B */
			b[0] = Bx[i];
			b[1] = By[i];
			b[2] = Bz[i];
			module_B = module_v1_double (b);
			b[0] /= module_B;
			b[1] /= module_B;
			b[2] /= module_B;

			/* p1 = Z vectoriel b */
			Z[0] = 0.0;
			Z[1] = 0.0;
			Z[2] = 1.0;
			v1_vectoriel_v2_double (Z, b, p1);

			module_p1 = module_v1_double (p1);
			p1[0] /= module_p1;
			p1[1] /= module_p1;
			p1[2] /= module_p1;

			/* p2 = b vectoriel p1 */
			v1_vectoriel_v2_double (b, p1, p2);

			A3T[0][0] = b[0];	A3T[0][1] = p1[0];	A3T[0][2] = p2[0];
			A3T[1][0] = b[1];	A3T[1][1] = p1[1];	A3T[1][2] = p2[1];
			A3T[2][0] = b[2];	A3T[2][1] = p1[2];	A3T[2][2] = p2[2];
			matrice_transposee_double (A3T, A3);
			/* A3T:	matrice permettant de passer du repere old=(xgse,ygse,zgse) au repere new=(b,p1,p2):	old_gse = A3T . new_b */
			/* MATH: Si vecteur_X(old) = matrice_P * vecteur_X'(new) alors matrice_M'(nouveau) = P-1 . M . P */
			/* => P_b = A3 . P_gse . A3T */

			matrice_multiplier_double (R4, A3T, R5);	// R5 = (A2*((A1*(P*A1T))*A2T))*A3T
			matrice_multiplier_double (A3, R5, R6);		// R6 = A3*((A2*((A1*(P*A1T))*A2T))*A3T)


			// Stockage des rsultats dans (xx3, xy3, xz3, yy3, yz3, zz3)
			xx3[i] = R6[0][0];			xy3[i] = R6[0][1];			xz3[i] = R6[0][2];
								yy3[i] = R6[1][1];			yz3[i] = R6[1][2];
													zz3[i] = R6[2][2];

			if (xx3[i]!=0 || yy3[i]!=0 || zz3[i] !=0) {
				An[i] = min3_double (xx3[i], yy3[i], zz3[i]) / max3_double (xx3[i], yy3[i], zz3[i]);
				Ng[i] = max3_double (xy3[i], xz3[i], yz3[i]) / (1/3.*(xx3[i] + yy3[i] + zz3[i]));
			}

			
			Ppar_b_eV_cm3[i]	= xx3[i];
			Pper1_b_eV_cm3[i]	= yy3[i];
			Pper2_b_eV_cm3[i]	= zz3[i];
			Tpar_b_eV[i]		= (Ppar_b_eV_cm3[i]!=FILLVAL && N_cm3[i]!=0) ? Ppar_b_eV_cm3[i] / N_cm3[i] : FILLVAL;
			Tper1_b_eV[i]		= (Pper1_b_eV_cm3[i]!=FILLVAL && N_cm3[i]!=0) ? Pper1_b_eV_cm3[i] / N_cm3[i] : FILLVAL;
			Tper2_b_eV[i]		= (Pper2_b_eV_cm3[i]!=FILLVAL && N_cm3[i]!=0) ? Pper2_b_eV_cm3[i] / N_cm3[i] : FILLVAL;

		}
	}


}


/*---------------------------------------------------------------------------*/
void GET_MATREP1_TO_MATREP2_AUTO_GLUE (
/*---------------------------------------------------------------------------*/
	void	*p01,
	void	*p02,
	void	*p03,
	void	*p04,
	void	*p05,
	void	*p06,
	void	*p07,
	void	*p08,
	void	*p09,
	void	*p10,
	void	*p11,
	void	*p12,
	void	*p13,
	void	*p14,
	void	*p15,
	void	*p16,
	void	*p17,
	void	*p18,
	void	*p19,
	void	*p20,
	void	*p21,
	void	*p22,
	void	*p23,
	void	*p24,
	void	*p25,
	void	*p26,
	void	*p27,
	void	*p28,
	void	*p29,
	void	*p30,
	void	*p31,
	void	*p32,
	void	*p33,
	void	*p34,
	void	*p35,
	void	*p36,
	void	*p37,
	void	*p38,
	void	*p39,
	void	*p40,
	void	*p41,
	void	*p42,
	void	*p43,
	void	*p44,
	void	*p45,
	void	*p46,
	void	*p47) {

	int	argc=47;
	void	*argv[47];

	argv[ 0] = p01;
	argv[ 1] = p02;
	argv[ 2] = p03;
	argv[ 3] = p04;
	argv[ 4] = p05;
	argv[ 5] = p06;
	argv[ 6] = p07;
	argv[ 7] = p08;
	argv[ 8] = p09;
	argv[ 9] = p10;
	argv[10] = p11;
	argv[11] = p12;
	argv[12] = p13;
	argv[13] = p14;
	argv[14] = p15;
	argv[15] = p16;
	argv[16] = p17;
	argv[17] = p18;
	argv[18] = p19;
	argv[19] = p20;
	argv[20] = p21;
	argv[21] = p22;
	argv[22] = p23;
	argv[23] = p24;
	argv[24] = p25;
	argv[25] = p26;
	argv[26] = p27;
	argv[27] = p28;
	argv[28] = p29;
	argv[29] = p30;
	argv[30] = p31;
	argv[31] = p32;
	argv[32] = p33;
	argv[33] = p34;
	argv[34] = p35;
	argv[35] = p36;
	argv[36] = p37;
	argv[37] = p38;
	argv[38] = p39;
	argv[39] = p40;
	argv[40] = p41;
	argv[41] = p42;
	argv[42] = p43;
	argv[43] = p44;
	argv[44] = p45;
	argv[45] = p46;
	argv[46] = p47;
	GET_MATREP1_TO_MATREP2 (argc, argv);

}


/*---------------------------------------------------------------------------*/
void compute_quality (int nbenergies, int nbcellules, int nbspectres, float *LocalVx, float *LocalVy, float *LocalVz, float *tab_fdist, int ienergie, float *sampling, float *SamplFactor, float *QualN) {
/*---------------------------------------------------------------------------*/

	float		Vshell[3];
	float		Vshell2[3];
	float		Nshell;
	float		VTherm;
	int		icellule;
	int		ispectre;
	int		icellule1;
	int		ispectre1;
	float		val;
	float		val_max;
	int		icellule_max;
	int		ispectre_max;
	float		NSampl;
	float		NTherm;
	int		NThermLoc;
	float		Vcurr;

	Vshell[0]=Vshell[1]=Vshell[2]=Vshell2[0]=Vshell2[1]=Vshell2[2]=Nshell=0;
	for (icellule=0 ; icellule<nbcellules ; icellule++) {
		for (ispectre=0 ; ispectre<nbspectres ; ispectre++) {
			val = tab_fdist[indice2(icellule,ispectre,nbcellules,nbspectres)];
			Nshell += val;
			Vshell[0] += val * LocalVx[indice2(icellule,ispectre,nbcellules,nbspectres)];
			Vshell[1] += val * LocalVy[indice2(icellule,ispectre,nbcellules,nbspectres)];
			Vshell[2] += val * LocalVz[indice2(icellule,ispectre,nbcellules,nbspectres)];
			Vshell2[0] += val * CARRE(LocalVx[indice2(icellule,ispectre,nbcellules,nbspectres)]);
			Vshell2[1] += val * CARRE(LocalVy[indice2(icellule,ispectre,nbcellules,nbspectres)]);
			Vshell2[2] += val * CARRE(LocalVz[indice2(icellule,ispectre,nbcellules,nbspectres)]);
		}
	}
	if (Nshell) {
		Vshell[0] /= Nshell;
		Vshell[1] /= Nshell;
		Vshell[2] /= Nshell;
	}

	VTherm=0;
	for (icellule=0 ; icellule<nbcellules ; icellule++) {
		for (ispectre=0 ; ispectre<nbspectres ; ispectre++) {
			val = tab_fdist[indice2(icellule,ispectre,nbcellules,nbspectres)];
			VTherm += val * sqrt( CARRE(Vshell[0]-LocalVx[indice2(icellule,ispectre,nbcellules,nbspectres)]) +
						CARRE(Vshell[1]-LocalVy[indice2(icellule,ispectre,nbcellules,nbspectres)]) +
						CARRE(Vshell[2]-LocalVz[indice2(icellule,ispectre,nbcellules,nbspectres)]));
		}
	}

	// Recherche maximum de tab_fdist
	// ------------------------------
	val_max=icellule_max=ispectre_max=0;
	for (icellule=0 ; icellule<nbcellules ; icellule++) {
		for (ispectre=0 ; ispectre<nbspectres ; ispectre++) {
			val = tab_fdist[indice2(icellule,ispectre,nbcellules,nbspectres)];
			if (val > val_max) {
				val_max = val;
				icellule_max = icellule;
				ispectre_max = ispectre;
			}
		}
	}

	NSampl = NTherm = 0;

	// Start spectre variation Up/Down
	ispectre = ispectre_max;
	NThermLoc = 1;
	while (NThermLoc > 0 && ispectre < 2*nbspectres) {	// Up along spectre
		ispectre1 = (ispectre >= nbspectres) ? ispectre-nbspectres : ispectre;
		NThermLoc = 0;
		icellule = icellule_max;
		Vcurr = 0;
		while (Vcurr < VTherm && icellule < 2*nbcellules) {	// Up along cellule
			icellule1 = (icellule >= nbcellules) ? icellule-nbcellules : icellule;
			Vcurr = sqrt( CARRE(Vshell[0]-LocalVx[indice2(icellule1,ispectre1,nbcellules,nbspectres)]) +
					CARRE(Vshell[1]-LocalVy[indice2(icellule1,ispectre1,nbcellules,nbspectres)]) +
					CARRE(Vshell[2]-LocalVz[indice2(icellule1,ispectre1,nbcellules,nbspectres)]));
			if (Vcurr < VTherm) {
				NThermLoc++;
				if (sampling[indice3(ienergie,ispectre1,icellule1,nbenergies,nbspectres,nbcellules)] == 1.0) NSampl++;
			}
			icellule++;
		}
		icellule=icellule_max-1;
		Vcurr = 0;
		while (Vcurr < VTherm && icellule >= -nbcellules) {	// Down along spectre
			icellule1 = (icellule<0) ? nbcellules+icellule : icellule;
			Vcurr = sqrt( CARRE(Vshell[0]-LocalVx[indice2(icellule1,ispectre1,nbcellules,nbspectres)]) +
					CARRE(Vshell[1]-LocalVy[indice2(icellule1,ispectre1,nbcellules,nbspectres)]) +
					CARRE(Vshell[2]-LocalVz[indice2(icellule1,ispectre1,nbcellules,nbspectres)]));
			if (Vcurr < VTherm) {
				NThermLoc++;
				if (sampling[indice3(ienergie,ispectre1,icellule1,nbenergies,nbspectres,nbcellules)] == 1.0) NSampl++;
			}
			icellule--;
		}
		NTherm += NThermLoc;
		ispectre++;
	}

	ispectre = ispectre_max-1;
	NThermLoc = 1;
	while (NThermLoc > 0 && ispectre >= -nbspectres) {	// Down along spectre
		ispectre1 = (ispectre<0) ? nbspectres+ispectre : ispectre;
		NThermLoc = 0;
		icellule = icellule_max;
		Vcurr = 0;
		while (Vcurr < VTherm && icellule < 2*nbcellules) {	// Up along cellule
			icellule1 = (icellule>=nbcellules) ? icellule-nbcellules : icellule;
			Vcurr = sqrt( CARRE(Vshell[0]-LocalVx[indice2(icellule1,ispectre1,nbcellules,nbspectres)]) +
					CARRE(Vshell[1]-LocalVy[indice2(icellule1,ispectre1,nbcellules,nbspectres)]) +
					CARRE(Vshell[2]-LocalVz[indice2(icellule1,ispectre1,nbcellules,nbspectres)]));
			if (Vcurr < VTherm) {
				NThermLoc++;
				if (sampling[indice3(ienergie,ispectre1,icellule1,nbenergies,nbspectres,nbcellules)] == 1.0) NSampl++;
			}
			icellule++;
		}
		icellule=icellule_max-1;
		Vcurr=0;
		while (Vcurr < VTherm && icellule >= -nbcellules) {
			icellule1 = (icellule<0) ? nbcellules+icellule : icellule;
			Vcurr = sqrt( CARRE(Vshell[0]-LocalVx[indice2(icellule1,ispectre1,nbcellules,nbspectres)]) +
					CARRE(Vshell[1]-LocalVy[indice2(icellule1,ispectre1,nbcellules,nbspectres)]) +
					CARRE(Vshell[2]-LocalVz[indice2(icellule1,ispectre1,nbcellules,nbspectres)]));
			if (Vcurr < VTherm) {
				NThermLoc++;
				if (sampling[indice3(ienergie,ispectre1,icellule1,nbenergies,nbspectres,nbcellules)] == 1.0) NSampl++;
			}
			icellule--;
		}
		NTherm += NThermLoc;
		ispectre--;
	}

	if (NTherm > 0) {
		*SamplFactor += (float)NSampl / (float)NTherm * Nshell;
		*QualN += Nshell;
	}

#ifdef DEBUG
	printf ("Nshell=%f  Vshell=(%f,%f,%f)  Vshell2=(%f,%f,%f) VTherm=%f  val_max=%f  icellule_max=%d  ispectre_max=%d\n",
		Nshell,Vshell[0],Vshell[1],Vshell[2],Vshell2[0],Vshell2[1],Vshell2[2], VTherm, val_max, icellule_max, ispectre_max);
#endif

}


/*---------------------------------------------------------------------------*/
#define BOUCLE_CODER_DICO(entree,sortie,maxi) { 					\
/*---------------------------------------------------------------------------*/ 	\
											\
	int	i;									\
	int	j; /* un peu plus rapide en introduisant cette variable */		\
											\
	for (indice=0 ; indice<nbenergies*nbangles*nbmasses ; indice++) { 		\
											\
		coup = entree[indice]; 							\
											\
		j = *nbdico;								\
		for (i=0 ; i<j && dico[i]!=coup ; i++);					\
											\
		/*if (coup == 0) (*nbcoupsnuls)++; \*/ 					\
		sortie[indice] = i; 							\
		if (i==*nbdico) { 							\
			if (i==maxi) { 							\
				*nbdico=-1; 						\
				return; 						\
			} 								\
			dico[(*nbdico)++]=coup;						\
		} 									\
	} 										\
											\
}


/*---------------------------------------------------------------------------*/
void CODER_DICO (int argc, void *argv[]) {
/*---------------------------------------------------------------------------*/

	int	nbarg		= 0;
	int	nbspins		= *(int *)	argv[nbarg++];
	int	nbmasses	= *(int *)	argv[nbarg++];
	int	nbenergies	= *(int *)	argv[nbarg++];
	int	nbangles	= *(int *)	argv[nbarg++];
	char	*tabdata	= (char *)	argv[nbarg++];
	int	no1		= *(int *)	argv[nbarg++];
	int	*debut		= (int *)	argv[nbarg++];
	int	*fin		= (int *)	argv[nbarg++];
	int	*dico		= (int *)	argv[nbarg++];
	int	*nbdico		= (int *)	argv[nbarg++];
	char	*tabdatanew	= (char *)	argv[nbarg++];
	int	no1new		= *(int *)	argv[nbarg++];
	int	nbytes		= *(int *)	argv[nbarg++];
	int	nocis		= *(int *)	argv[nbarg++];
	int	*nbcoups	= (int *)	argv[nbarg++];
	int	*nbcoupsnuls	= (int *)	argv[nbarg++];

	int 	ispin;
	int	indice;
	int	coup;
	byte1 	*p1;
	byte2 	*p2;
	byte4 	*pin4;
	byte2 	*pin2;

	if (nbarg != argc) return;

	*nbcoupsnuls=0;

	for (ispin=0 ; ispin<nbspins ; ispin++) { 

		p1 = get_p1(tabdatanew,no1new);
		p2 = get_p2(tabdatanew,no1new);
		pin2 = get_p2(tabdata,no1);
		pin4 = get_p4(tabdata,no1);

		if (is_ELS(nocis) || is_NPI(nocis) || is_NPD1(nocis) || is_NPD2(nocis) || is_IMA(nocis)) {
			if (nbytes==1) {
				BOUCLE_CODER_DICO (pin2,p1,256);
			} else {
				BOUCLE_CODER_DICO (pin2,p2,65536);
			}
		} else {
			if (nbytes==1) {
				BOUCLE_CODER_DICO (pin4,p1,256);
			} else {
				BOUCLE_CODER_DICO (pin4,p2,65536);
			}
		}
	}

	*nbcoups = nbspins * nbenergies * nbangles * nbmasses;
}

/*---------------------------------------------------------------------------*/
void CODER_DICO_AUTO_GLUE (
/*---------------------------------------------------------------------------*/
	void	*p01,
	void	*p02,
	void	*p03,
	void	*p04,
	void	*p05,
	void	*p06,
	void	*p07,
	void	*p08,
	void	*p09,
	void	*p10,
	void	*p11,
	void	*p12,
	void	*p13,
	void	*p14,
	void	*p15,
	void	*p16) {

	int	argc=16;
	void	*argv[16];

	argv[ 0] = p01;
	argv[ 1] = p02;
	argv[ 2] = p03;
	argv[ 3] = p04;
	argv[ 4] = p05;
	argv[ 5] = p06;
	argv[ 6] = p07;
	argv[ 7] = p08;
	argv[ 8] = p09;
	argv[ 9] = p10;
	argv[10] = p11;
	argv[11] = p12;
	argv[12] = p13;
	argv[13] = p14;
	argv[14] = p15;
	argv[15] = p16;
	CODER_DICO (argc, argv);

}


/*
#define RACINE_NBITS	8
#define RACINE_NB	256
#define RACINE_MASQUE	0xFF

#define RACINE_NBITS	4
#define RACINE_NB	16
#define RACINE_MASQUE	0xF
*/

#define RACINE_NBITS	16
#define RACINE_NB	65536
#define RACINE_MASQUE	0xFFFF


int	RACINE_calloc	=	0;
int	RACINE_free	=	0;
char	message[1024];

/*---------------------------------------------------------------------------*/
int init_racine (size_t **racine) {
/*---------------------------------------------------------------------------*/

	*racine = (size_t *) calloc (RACINE_NB, sizeof(size_t));
	if (*racine == NULL)
		return -1;

	RACINE_calloc += RACINE_NB*sizeof(size_t);

	return 0;

}


/*---------------------------------------------------------------------------*/
int ajouter_racine (size_t *racine, int coup, int code) {
/*---------------------------------------------------------------------------*/

	int	i;
	size_t	*p;
	int	val;

	p = racine;

	for (i=0 ; i<32/RACINE_NBITS ; i++) {

		val = (coup >> (32-RACINE_NBITS*(i+1))) & RACINE_MASQUE;

		if (i == 32/RACINE_NBITS-1) {

			p[val] = code+1;

		} else {

			if (p[val] == 0) {

				p[val] = (size_t) ((size_t *) calloc (RACINE_NB, sizeof(size_t)));	// WARNING
				if (p[val] == (size_t)NULL)
					return -1;
				RACINE_calloc += RACINE_NB*sizeof(size_t);

			}
			p = (size_t *) p[val]; // WARNING
			
		}

	}

	return 0;

}


/*---------------------------------------------------------------------------*/
int chercher_racine (size_t *racine, int coup) {
/*---------------------------------------------------------------------------*/

	int	i;
	size_t	*p;
	int	val;
	int	code=0;

	p = racine;

	for (i=0 ; i<32/RACINE_NBITS ; i++) {

		val = (coup >> (32-RACINE_NBITS*(i+1))) & RACINE_MASQUE;

		if (i == 32/RACINE_NBITS-1) {

			code = p[val]-1;

		} else {

			if (p[val] == 0) {

				return -1;

			}

			p = (size_t *) p[val]; // WARNING

		}


	}

	
	return code;

}

/*---------------------------------------------------------------------------*/
void detruire_racine (size_t *racine, int niveau) {
/*---------------------------------------------------------------------------*/

	int	i;

	if (niveau == 32/RACINE_NBITS)

		return;

	for (i=0 ; i<RACINE_NB ; i++) {

		if (racine[i] != 0) {

			detruire_racine ((size_t *)racine[i],niveau+1); // WARNING

		}

	}

	RACINE_free += RACINE_NB*sizeof(size_t);
	free (racine);

}


/*---------------------------------------------------------------------------*/
#define BOUCLE_CODER_DICO_OPTIMISE(entree,sortie,maxi) { 					\
/*---------------------------------------------------------------------------*/ 		\
												\
	for (indice=0 ; indice<nbenergies*nbangles*nbmasses ; indice++) { 			\
		coup = entree[indice]; 								\
		i = chercher_racine (racine, coup); 						\
		if (i == -1) { 									\
												\
			i = *nbdico; 								\
			if (ajouter_racine (racine, coup, i) == -1) { 				\
				*nbdico=-1; 							\
				detruire_racine (racine,0); 					\
				sprintf (message,"ERROR with ajouter_racine"); 			\
				IDL_Message (IDL_M_NAMED_GENERIC, IDL_MSG_INFO, message); 	\
				return; 							\
												\
			} 									\
												\
		} 										\
												\
		/*if (coup == 0) (*nbcoupsnuls)++;*/						\
		sortie[indice] = i; 								\
												\
		if (i==*nbdico) { 								\
			if (i==maxi) { 								\
				*nbdico=-1; 							\
				detruire_racine (racine,0); 					\
				return; 							\
			} 									\
			dico[*nbdico]=coup; 							\
			(*nbdico)++; 								\
		} 										\
												\
	} 											\
}


/*---------------------------------------------------------------------------*/
void CODER_DICO_OPTIMISE (int argc, void *argv[]) {
/*---------------------------------------------------------------------------*/

	int	nbarg		= 0;
	int	nbspins		= *(int *)	argv[nbarg++];
	int	nbmasses	= *(int *)	argv[nbarg++];
	int	nbenergies	= *(int *)	argv[nbarg++];
	int	nbangles	= *(int *)	argv[nbarg++];
	char	*tabdata	= (char *)	argv[nbarg++];
	int	no1		= *(int *)	argv[nbarg++];
	int	*debut		= (int *)	argv[nbarg++];
	int	*fin		= (int *)	argv[nbarg++];
	int	*dico		= (int *)	argv[nbarg++];
	int	*nbdico		= (int *)	argv[nbarg++];
	char	*tabdatanew	= (char *)	argv[nbarg++];
	int	no1new		= *(int *)	argv[nbarg++];
	int	nbytes		= *(int *)	argv[nbarg++];
	int	nocis		= *(int *)	argv[nbarg++];
	int	*nbcoups	= (int *)	argv[nbarg++];
	int	*nbcoupsnuls	= (int *)	argv[nbarg++];
	int	*nballoc	= (int *)	argv[nbarg++];
	int	*nbfree		= (int *)	argv[nbarg++];

	int 	ispin;
	int	i;
	int	coup;
	int	indice;
	byte1 	*p1;
	byte2 	*p2;
	byte4 	*pin4;
	byte2 	*pin2;
	size_t	*racine;
	char	message[1024];

	if (nbarg != argc) return;

	RACINE_calloc = 0;
	RACINE_free = 0;

	if (init_racine (&racine) == -1) {
		*nbdico=-1;
		sprintf (message,"ERROR with init_racine");
		IDL_Message (IDL_M_NAMED_GENERIC, IDL_MSG_INFO, message);
		return;
	}

	*nbcoupsnuls=0;

	for (i=0 ; i<*nbdico ; i++) {

		if (ajouter_racine (racine, dico[i], i) == -1) {
			*nbdico=-1;
			detruire_racine (racine,0);
			sprintf (message,"ERROR with ajouter_racine");
			IDL_Message (IDL_M_NAMED_GENERIC, IDL_MSG_INFO, message);
			return;
		}

	}

	for (ispin=0 ; ispin<nbspins ; ispin++) { 
		p1 = get_p1(tabdatanew,no1new);
		p2 = get_p2(tabdatanew,no1new);
		pin2 = get_p2(tabdata,no1);
		pin4 = get_p4(tabdata,no1);

		if (is_ELS(nocis) || is_NPI(nocis) || is_NPD1(nocis) || is_NPD2(nocis) || is_IMA(nocis)) {
			if (nbytes==1) {
				BOUCLE_CODER_DICO_OPTIMISE (pin2,p1,256);
			} else {
				BOUCLE_CODER_DICO_OPTIMISE (pin2,p2,65536);
			}
		} else {
			if (nbytes==1) {
				BOUCLE_CODER_DICO_OPTIMISE (pin4,p1,256);
			} else {
				BOUCLE_CODER_DICO_OPTIMISE (pin4,p2,65536);
			}
		}
	}

	*nbcoups = nbspins * nbenergies * nbangles * nbmasses;

	detruire_racine (racine,0);

	*nballoc = RACINE_calloc;
	*nbfree = RACINE_free;

}

/*---------------------------------------------------------------------------*/
void CODER_DICO_OPTIMISE_AUTO_GLUE (
/*---------------------------------------------------------------------------*/
	void	*p01,
	void	*p02,
	void	*p03,
	void	*p04,
	void	*p05,
	void	*p06,
	void	*p07,
	void	*p08,
	void	*p09,
	void	*p10,
	void	*p11,
	void	*p12,
	void	*p13,
	void	*p14,
	void	*p15,
	void	*p16,
	void	*p17,
	void	*p18) {

	int	argc=18;
	void	*argv[18];

	argv[ 0] = p01;
	argv[ 1] = p02;
	argv[ 2] = p03;
	argv[ 3] = p04;
	argv[ 4] = p05;
	argv[ 5] = p06;
	argv[ 6] = p07;
	argv[ 7] = p08;
	argv[ 8] = p09;
	argv[ 9] = p10;
	argv[10] = p11;
	argv[11] = p12;
	argv[12] = p13;
	argv[13] = p14;
	argv[14] = p15;
	argv[15] = p16;
	argv[16] = p17;
	argv[17] = p18;
	CODER_DICO_OPTIMISE (argc, argv);

}


/*---------------------------------------------------------------------------*/
void DECODER_DICO (int argc, void *argv[]) {
/*---------------------------------------------------------------------------*/

	int	nbarg		= 0;
	int	nbspins		= *(int *)	argv[nbarg++];
	int	nbmasses	= *(int *)	argv[nbarg++];
	int	nbenergies	= *(int *)	argv[nbarg++];
	int	nbangles	= *(int *)	argv[nbarg++];
	char	*tabdata	= (char *)	argv[nbarg++];
	int	no1		= *(int *)	argv[nbarg++];
	int	*debut		= (int *)	argv[nbarg++];
	int	*fin		= (int *)	argv[nbarg++];
	int	*dico		= (int *)	argv[nbarg++];
	char	*tabdatanew	= (char *)	argv[nbarg++];
	int	no1new		= *(int *)	argv[nbarg++];
	int	nbytes		= *(int *)	argv[nbarg++];

	int 	ispin;
	int	indice;
	byte1 	*p1;
	byte2 	*p2;
	byte4 	*p4;

	if (nbarg != argc) return;

	for (ispin=0 ; ispin<nbspins ; ispin++) {
		p1 = get_p1(tabdata,no1);
		p2 = get_p2(tabdata,no1);
		p4 = get_p4(tabdatanew,no1new);
		for (indice=0 ; indice<nbenergies*nbangles*nbmasses ; indice++) {
			p4[indice] = nbytes==1 ? dico[p1[indice]] : dico[p2[indice]];
		}
	}

}

/*---------------------------------------------------------------------------*/
void DECODER_DICO_AUTO_GLUE (
/*---------------------------------------------------------------------------*/
	void	*p01,
	void	*p02,
	void	*p03,
	void	*p04,
	void	*p05,
	void	*p06,
	void	*p07,
	void	*p08,
	void	*p09,
	void	*p10,
	void	*p11,
	void	*p12) {

	int	argc=12;
	void	*argv[12];

	argv[ 0] = p01;
	argv[ 1] = p02;
	argv[ 2] = p03;
	argv[ 3] = p04;
	argv[ 4] = p05;
	argv[ 5] = p06;
	argv[ 6] = p07;
	argv[ 7] = p08;
	argv[ 8] = p09;
	argv[ 9] = p10;
	argv[10] = p11;
	argv[11] = p12;
	DECODER_DICO (argc, argv);

}


/*---------------------------------------------------------------------------*/
float modif_alpha (float alpha) {
/*---------------------------------------------------------------------------*/

	if (alpha<0)
		return 0;

	if (alpha > 180)
		return 180;

	return alpha;

}


/*---------------------------------------------------------------------------*/
void lubksb1_c (double *A, int *INDX, double *B) {
/*---------------------------------------------------------------------------*/

//
// Numerical Recipies: Solves the set of linear equation A.X = B
//

	/* A[4,4]: A[i,j]=x[i+4*j] */
	/* INDX[4]] */
	/* B[4]] */

	int 	i;
	int	ii=0;
	int	ip;
	int	j;
	double 	sum;
	int 	n=3;

	for (i=1 ; i<=n ; i++) {
		ip = INDX[i];
		sum = B[ip];
		B[ip] = B[i];
		if (ii)
			for (j=ii ; j<=i-1 ; j++)
				sum -= A[i+4*j] * B[j];
		else if (sum)
			ii = i;
		B[i] = sum;
	}

	for (i=n ; i>=1 ; i--) {
		sum = B[i];
		for (j=i+1 ; j<=n ; j++)
			sum -= A[i+4*j] * B[j];
		B[i] = sum / A[i+4*i];
	}

}


/*---------------------------------------------------------------------------*/
void projection_sur_plan (float *P, double *A1, int *INDX,
	double X1, double Y1, double Z1,
	double *X2, double *Y2, double *Z2) {
/*---------------------------------------------------------------------------*/
	/* 
		Entrees: X1, Y1, Z1
		Sorties: X2, Y2, Z2
	*/

	// En mettant X1, Y1 et Z1 en double TRIANGULATE donne pour CLUSTER: Points are co-linear, no solution 
	// Donc je laisse des FLOAT
	// Janvier 2021: je remets double mais corrige plus loin les points qui sont trop proches

	double B1[4];

	B1[1] = X1-P[0];
	B1[2] = Y1-P[1];
	B1[3] = Z1-P[2];

	lubksb1_c (A1,INDX,B1);

	*X2 = B1[1];
	*Y2 = B1[2];
	*Z2 = B1[3];

}


/*---------------------------------------------------------------------------*/
int cartesien_to_theta_phi (double x, double y, double z, int ordre_cluster, int nox, int noy, int noz,
	double *theta, double *phi) {
/*---------------------------------------------------------------------------*/

	float	latitude;	/* entre -90 deg et  +90 deg */
	float	longitude;	/* entre   0 deg et +360 deg */

	double	P[3];
	double	V1;
	double	V2;
	double	V3;
	double	V4;

	P[0] = x;
	P[1] = y;
	P[2] = z;
	V1 = P[noz];
	V2 = sqrt(P[nox]*P[nox]+P[noy]*P[noy]);
	V3 = P[noy];
	V4 = P[nox];

	/* Pas de atan2(0,0) */
	if ((V1==0 && V2==0) || (V3==0 && V4==0))
		return -1;

	latitude  = atan2 (V1, V2) * 180.0 / M_PI;
	longitude = atan2 (V3, V4) * 180.0 / M_PI;
	if (longitude < 0) longitude += 360;

	*theta = ordre_cluster ? latitude : longitude;
	*phi   = ordre_cluster ? longitude : latitude;

	return 0;

}


/*---------------------------------------------------------------------------*/
int appartient (float min, float max, float val, int isangle) {
/*---------------------------------------------------------------------------*/

	if (isangle && max<min) { 
		/* Passage des 360 deg */
		if ((min<=val && val<=(max+360)) || (min<=val+360 && val<=max))
			return 1;
	} else if (min<=val && val<=max)
		return 1;

	return 0;

}


/*---------------------------------------------------------------------------*/
int tab_to_no (float *min, float *max, int nb, float val, int no, int isangle) {
/*---------------------------------------------------------------------------*/

	int	i;

	if (no != -1 && appartient (min[no],max[no],val,isangle))
		return no;

	if (isangle==0) {

		/* Seulement pour les vitesses */
		if (min[0]<max[nb-1]) {
			// vitesses croissantes (ex: CLUSTER)
			if (val<min[0] || val>max[nb-1]) {
				return -1;
			}
		} else {
			// vitesses dcroissantes (ex: MMS)
			if (val<min[nb-1] || val>max[0]) {
				return -1;
			}
		}
		for (i=0 ; i<nb ; i++) {
			if (min[i]<=val && val<=max[i]) return i;
		}
		return -1;

	} else {

		/* Seulement pour les angles */
		for (i=0 ; i<nb ; i++) {
			if (appartient (min[i],max[i],val,isangle))
				return i;
			if (appartient (min[i],max[i],val+360,isangle)) // pour MMS
				return i;
		}

	}

	return -1;

}


/*---------------------------------------------------------------------------*/
float my_acos (float x) {
/*---------------------------------------------------------------------------*/

	/* Revoie une valeur entre 0 et PI */

	/* acos(1.000001) renvoie nan mais my_acos(1.000001) renvoie acos(1) */

	if (x>1) {
		return acos(1);
	} else if (x<-1) {
		return acos(-1);
	} else {
		return acos (x);
	}

}


/*---------------------------------------------------------------------------*/
void RLONG_RLAT_Z_TO_Z1 (int argc, void *argv[]) {
/*---------------------------------------------------------------------------*/

	int		nbarg				= 0;
	int		nb				= *(int *)	argv[nbarg++];
	double		*tabt				= (double *)	argv[nbarg++]; /* tabt[nb] */
	double		t1				= *(double *)	argv[nbarg++];
	double		t2				= *(double *)	argv[nbarg++];
	float		*tabdeb_RLONG			= (float *)	argv[nbarg++]; /* tabdeb_RLONG[nb] */
	float		*tabfin_RLONG			= (float *)	argv[nbarg++]; /* tabfin_RLONG[nb] */
	float		*tabdeb_RLAT			= (float *)	argv[nbarg++]; /* tabdeb_RLAT[nb] */
	float		*tabfin_RLAT			= (float *)	argv[nbarg++]; /* tabfin_RLAT[nb] */
	float		RESOLUTION			= *(float *)	argv[nbarg++];
	int		nbx				= *(int *)	argv[nbarg++];
	int		nby				= *(int *)	argv[nbarg++];
	float		*Z				= (float *)	argv[nbarg++]; /* Z[nb] */
	int		*nb1				= (int *)	argv[nbarg++]; /* nb1[nbx,nby] */
	float		*Z1				= (float *)	argv[nbarg++]; /* Z1[nbx,nby] */
	int		moins180plus180			= *(int *)	argv[nbarg++] ; /* 1 pour utiliser -180/180, 0 pour utiliser 0/360 */

	int		i;
	int		j;
	int		k;
	float		tmp1;
	float		tmp2;
	int		RLONG_MIN_MATRICE;
	int		RLONG_MAX_MATRICE;
	int		RLAT_MIN_MATRICE;
	int		RLAT_MAX_MATRICE;
	float		RLONG_MIN;
	float		RLONG_MAX;
	float		RLAT_MIN;
	float		RLAT_MAX;

	if (nbarg != argc) return;

	for (i=0 ; i<nb; i++) {

		if ((tabt[i] > t1) && (tabt[i] < t2)) {

			if ((tabdeb_RLONG[i]>-FILLVAL_E30) && (tabfin_RLONG[i]>-FILLVAL_E30) && (tabdeb_RLAT[i]>-FILLVAL_E30) && (tabfin_RLAT[i]>-FILLVAL_E30)) {

				tmp1 = tabdeb_RLONG[i]/RESOLUTION;
				tmp2 = tabfin_RLONG[i]/RESOLUTION;
				RLONG_MIN = MIN(tmp1,tmp2);
				RLONG_MAX = MAX(tmp1,tmp2);
				tmp1 = tabdeb_RLAT[i]/RESOLUTION;
				tmp2 = tabfin_RLAT[i]/RESOLUTION;
				RLAT_MIN = MIN (tmp1,tmp2);
				RLAT_MAX = MAX (tmp1,tmp2);

				// Mis en commentaire le 20/3/2015. A quoi ca servait ?
				// 11/06/2015: je remets ce test sinon des lignes horizontales apparaissent dans les tracs RLONG_RLAT de DEMETER
				if (RLONG_MAX - RLONG_MIN < 5.0/RESOLUTION) {

					RLONG_MIN_MATRICE = (moins180plus180 ? 180.0 : 0.0)/RESOLUTION + RLONG_MIN;
					RLONG_MAX_MATRICE = (moins180plus180 ? 180.0 : 0.0)/RESOLUTION + RLONG_MAX;
					RLAT_MIN_MATRICE  =  90.0/RESOLUTION + RLAT_MIN;
					RLAT_MAX_MATRICE  =  90.0/RESOLUTION + RLAT_MAX;

					/* Vrification pour tre sur de ne pas dborder du tableau Z1 */
					if (RLONG_MIN_MATRICE < 0) RLONG_MIN_MATRICE=0;
					if (RLONG_MAX_MATRICE < 0) RLONG_MAX_MATRICE=0;
					if (RLONG_MIN_MATRICE > nbx-1) RLONG_MIN_MATRICE=nbx-1;
					if (RLONG_MAX_MATRICE > nbx-1) RLONG_MAX_MATRICE=nbx-1;

					if (RLAT_MIN_MATRICE < 0) RLAT_MIN_MATRICE=0;
					if (RLAT_MAX_MATRICE < 0) RLAT_MAX_MATRICE=0;
					if (RLAT_MIN_MATRICE > nby-1) RLAT_MIN_MATRICE=nby-1;
					if (RLAT_MAX_MATRICE > nby-1) RLAT_MAX_MATRICE=nby-1;

					for (j=RLONG_MIN_MATRICE ; j<=RLONG_MAX_MATRICE; j++) {

						for (k=RLAT_MIN_MATRICE ; k<=RLAT_MAX_MATRICE; k++) {

							Z1[indice2(j,k,nbx,nby)] += Z[i];
							nb1[indice2(j,k,nbx,nby)]++;

						}

					}

				}

			}

		}

	}

}

/*---------------------------------------------------------------------------*/
void RLONG_RLAT_Z_TO_Z1_AUTO_GLUE (
/*---------------------------------------------------------------------------*/
	void	*p01,
	void	*p02,
	void	*p03,
	void	*p04,
	void	*p05,
	void	*p06,
	void	*p07,
	void	*p08,
	void	*p09,
	void	*p10,
	void	*p11,
	void	*p12,
	void	*p13,
	void	*p14,
	void	*p15) {

	int	argc=15;
	void	*argv[15];

	argv[ 0] = p01;
	argv[ 1] = p02;
	argv[ 2] = p03;
	argv[ 3] = p04;
	argv[ 4] = p05;
	argv[ 5] = p06;
	argv[ 6] = p07;
	argv[ 7] = p08;
	argv[ 8] = p09;
	argv[ 9] = p10;
	argv[10] = p11;
	argv[11] = p12;
	argv[12] = p13;
	argv[13] = p14;
	argv[14] = p15;
	RLONG_RLAT_Z_TO_Z1 (argc, argv);

}


/*---------------------------------------------------------------------------*/
void CREER3D_JUNO_JADEE (int argc, void *argv[]) {
/*---------------------------------------------------------------------------*/

	int		nbarg				= 0;
	char		*tabdata2d			= (char *)		argv[nbarg++]; // pointeur sur la structure 2D
	char		*tabdata3d			= (char *)		argv[nbarg++]; // pointeur sur la structure 3D
	int		taille2d			= *(int *)		argv[nbarg++];
	int		taille3d			= *(int *)		argv[nbarg++];
	int		nbchamps			= *(int *)		argv[nbarg++];
	int		*offset2d			= (int *)		argv[nbarg++];
	int		*offset3d			= (int *)		argv[nbarg++];
	int		nbspins				= *(int *)		argv[nbarg++];
	int		nbspectres3d			= *(int *)		argv[nbarg++];
	int		nbspectres2d			= *(int *)		argv[nbarg++];
	int		nbenergies			= *(int *)		argv[nbarg++];
	int		nbcellules3d			= *(int *)		argv[nbarg++];
	int		nbcellules2d			= *(int *)		argv[nbarg++];
	float		*thetamoy3d			= (float *)		argv[nbarg++]; /* thetamoy3d[nbcellules3d] en rad */
	float		*thetamoy2d			= (float *)		argv[nbarg++]; /* thetamoy2d[nbcellules2d] en rad */
	float		*phimoy3d			= (float *)		argv[nbarg++]; /* phimoy3d[nbspectres3d] en rad */
	float		*phimoy2d			= (float *)		argv[nbarg++]; /* phimoy2d[nbspectres2d,nbspins] en rad */
	float		*tabBx				= (float *)		argv[nbarg++]; /* tabBx[nbspins] */
	float		*tabBy				= (float *)		argv[nbarg++]; /* tabBy[nbspins] */
	float		*tabBz				= (float *)		argv[nbarg++]; /* tabBz[nbspins] */

	int		ispin;
	int		ispectre3d;
	int		ispectre2d;
	int		icellule3d;
	int		icellule2d;
	int		ienergie;
	double		champB[3];
	double		binMIN[3];
	double		binMOY[3];
	double		binMAX[3];
	double		moduleB;
	double		tmoy;
	double		pmoy;
	double		tabalphamoy2d[48],alphamoy;
	double		cosLAT;
	double		sinLAT;
	double		cosLONG;
	double		sinLONG;
	int		min,max;
	float		*pfloat2d;
	float		*pfloat3d;
	float		count;
	float		somme_count;
	int		nb_count;
	int		ok2d[48];
	int		tous_fillval;
	int		nospectre2d[48];

	if (nbarg != argc) return;

	for (ispin=0 ; ispin<nbspins ; ispin++) {

		// pointeurs sur le dernier champ qui est le champ data
		pfloat2d = (float *) (tabdata2d+(size_t)taille2d*(size_t)(ispin)+offset2d[nbchamps-1]);
		pfloat3d = (float *) (tabdata3d+(size_t)taille3d*(size_t)(ispin)+offset3d[nbchamps-1]);

		champB[0] = tabBx[ispin];
		champB[1] = tabBy[ispin];
		champB[2] = tabBz[ispin];
		if (champB[0] < -FILLVAL_E30 || champB[1] < -FILLVAL_E30 || champB[2] < -FILLVAL_E30) {
			/* On n'a pas le champ magntique: On ne peut rien faire */
			continue;
		}
		moduleB = module_v1_double(champB);
		if (moduleB == 0) {
			/* On ne peut rien faire */
			continue;
		}
		champB[0] /= moduleB;
		champB[1] /= moduleB;
		champB[2] /= moduleB;

		for (icellule2d=0 ; icellule2d<nbcellules2d ; icellule2d++) { 

			tmoy = thetamoy2d[icellule2d];
			cosLONG = cos(tmoy);
			sinLONG = sin(tmoy);

			tabalphamoy2d[icellule2d] = -1e31;
			nospectre2d[icellule2d] = -1;

			for (ispectre2d=0 ; ispectre2d<nbspectres2d ; ispectre2d++) { 

				if (nbspectres2d == 2) {
					// produit HRS_TWO: ne pas utiliser cette dflection si les comptages pour toutes les nergies valent FILLVAL
					tous_fillval = 1;
					for (ienergie=0 ; ienergie<nbenergies ; ienergie++) {
						if (pfloat2d[indice4(ienergie,ispectre2d,icellule2d,0,nbenergies,nbspectres2d,nbcellules2d,1)] > -FILLVAL_E30) {
							tous_fillval = 0;
							break;
						}
					}
					if (tous_fillval) continue;
				}

				nospectre2d[icellule2d] = ispectre2d;

				pmoy = phimoy2d[indice2(ispectre2d,ispin,nbspectres2d,nbspins)];
				cosLAT = cos(pmoy);
				sinLAT = sin(pmoy);

				binMOY[0] = cosLAT * cosLONG;
				binMOY[1] = cosLAT * sinLONG;
				binMOY[2] = sinLAT;

				tabalphamoy2d[icellule2d] = my_acos (produit_scalaire_v1_v2_double(binMOY,champB)) * 180. / M_PI;

			}

		}


		for (icellule3d=0 ; icellule3d<nbcellules3d ; icellule3d++) {

			tmoy = thetamoy3d[icellule3d];
			cosLONG = cos(tmoy);
			sinLONG = sin(tmoy);

			for (ispectre3d=0 ; ispectre3d<nbspectres3d ; ispectre3d++) { 

				pmoy = phimoy3d[ispectre3d];
				cosLAT = cos(pmoy);
				sinLAT = sin(pmoy);

				binMOY[0] = cosLAT * cosLONG;
				binMOY[1] = cosLAT * sinLONG;
				binMOY[2] = sinLAT;

				alphamoy = my_acos (produit_scalaire_v1_v2_double(binMOY,champB)) * 180. / M_PI;

				// Chercher les secteurs dont la diffrence en pitchangle est infrieure  7.5 deg
				for (icellule2d=0 ; icellule2d<nbcellules2d ; icellule2d++) {
					ok2d[icellule2d] = fabs(tabalphamoy2d[icellule2d]-alphamoy) < 7.5;
				}

				for (ienergie=0 ; ienergie<nbenergies ; ienergie++) {

					nb_count = 0;
					somme_count = 0;

					for (icellule2d=0 ; icellule2d<nbcellules2d ; icellule2d++) {
						if (ok2d[icellule2d]) {
							count = pfloat2d[indice4(ienergie,nospectre2d[icellule2d],icellule2d,0,nbenergies,nbspectres2d,nbcellules2d,1)];
							if (count < -FILLVAL_E30) continue;
							somme_count += count;
							nb_count++;
						}
					}

					count = nb_count ? somme_count / nb_count : -1e31;
					pfloat3d[indice4(ienergie,ispectre3d,icellule3d,0,nbenergies,nbspectres3d,nbcellules3d,1)] = count;
				}
			}
		}
	}

}

/*---------------------------------------------------------------------------*/
void CREER3D_JUNO_JADEE_AUTO_GLUE (
/*---------------------------------------------------------------------------*/
	void	*p01,
	void	*p02,
	void	*p03,
	void	*p04,
	void	*p05,
	void	*p06,
	void	*p07,
	void	*p08,
	void	*p09,
	void	*p10,
	void	*p11,
	void	*p12,
	void	*p13,
	void	*p14,
	void	*p15,
	void	*p16,
	void	*p17,
	void	*p18,
	void	*p19,
	void	*p20) {

	int	argc=20;
	void	*argv[20];

	argv[ 0] = p01;
	argv[ 1] = p02;
	argv[ 2] = p03;
	argv[ 3] = p04;
	argv[ 4] = p05;
	argv[ 5] = p06;
	argv[ 6] = p07;
	argv[ 7] = p08;
	argv[ 8] = p09;
	argv[ 9] = p10;
	argv[10] = p11;
	argv[11] = p12;
	argv[12] = p13;
	argv[13] = p14;
	argv[14] = p15;
	argv[15] = p16;
	argv[16] = p17;
	argv[17] = p18;
	argv[18] = p19;
	argv[19] = p20;
	CREER3D_JUNO_JADEE (argc, argv);

}

/*---------------------------------------------------------------------------*/
void GET_DATA_MOMENTS (int argc, void *argv[]) {
/*---------------------------------------------------------------------------*/

	/* si ordre_cluster==0, l'algo ne fonctionne que si indY ne depend pas du numero du spectre */

	int		nbarg				= 0;
	short		*sensitivity			= (short *)		argv[nbarg++]; /* sensitivity[nbspins] */
	short		*produit1			= (short *)		argv[nbarg++]; /* produit1[nbspins] */
	short		*cis_mode			= (short *)		argv[nbarg++]; /* cis_mode[nbspins] */
	int		*start				= (int *)		argv[nbarg++]; /* start[nbspins] */
	int		*solid				= (int *)		argv[nbarg++]; /* solid[nbspectres,nbcellules] */
	double		*deadtime			= (double *)		argv[nbarg++]; /* deadtime[2] */
	int		*sectorold			= (int *)		argv[nbarg++]; /* sectorold[nbspectres,nbcellules] */
	float		*duree_comptage			= (float *)		argv[nbarg++]; /* duree_comptage[nbspins] */ 
	int		*nb_accumulation		= (int *)		argv[nbarg++]; /* nb_accumulation[nbspins] */
	int		*tabtheta			= (int *)		argv[nbarg++]; /* tabtheta[nbcellules] */
	int		*tabphi				= (int *)		argv[nbarg++]; /* tabphi[nbspectres] */
	float		valE				= *(float *)		argv[nbarg++];
	int		*tabmass			= (int *)		argv[nbarg++]; /* tabmass[nbmasses] */
	float		*thetamin			= (float *)		argv[nbarg++]; /* thetamin en rad (voir produit__define.pro) */
	float		*thetamoy			= (float *)		argv[nbarg++]; /* thetamoy en rad (voir produit__define.pro) */
	float		*thetamax			= (float *)		argv[nbarg++]; /* thetamax en rad (voir produit__define.pro) */
	float		*phimin				= (float *)		argv[nbarg++]; /* phimin en rad (voir produit__define.pro) */
	float		*phimoy				= (float *)		argv[nbarg++]; /* phimoy en rad (voir produit__define.pro) */
	float		*phimax				= (float *)		argv[nbarg++]; /* phimax en rad (voir produit__define.pro) */
	int		*indY				= (int *)		argv[nbarg++]; /* indY[nbspins*nbspectres] */
	int		*indC				= (int *)		argv[nbarg++]; /* indC[nbspins] */
	int		*indP				= (int *)		argv[nbarg++]; /* indP[nbspins] */
	float		*Emin				= (float *)		argv[nbarg++]; /* Emin[nbtablesE,nbenergies] */
	float		*Emoy				= (float *)		argv[nbarg++]; /* Emoy[nbtablesE,nbenergies] */
	float		*Emax				= (float *)		argv[nbarg++]; /* Emax[nbtablesE,nbenergies] */
	float		*Q				= (float *)		argv[nbarg++]; /* Q[nbmasses] */
	double		*MASSE				= (double *)		argv[nbarg++]; /* MASSE[nbmasses] */
	double		*efficacite			= (double *)		argv[nbarg++]; /* efficacite[] */
	double		*facteurG			= (double *)		argv[nbarg++]; /* facteurG[] */
	float		*sampling			= (float *)		argv[nbarg++]; /* sampling[nbenergies,nbspectres,nbcellules] */
	char		*tabdata			= (char *)		argv[nbarg++];
	int		no1				= *(int *)		argv[nbarg++];
	int		*debut				= (int *)		argv[nbarg++];
	int		*fin				= (int *)		argv[nbarg++];
	float		*dico				= (float *)		argv[nbarg++];
	int		nbytes				= *(int *)		argv[nbarg++];
	int		nbchamps			= *(int *)		argv[nbarg++];
	float		*Z				= (float *)		argv[nbarg++]; /* Z[nbchamps,nbspins] */
	int		*erreur				= (int *)		argv[nbarg++]; /* code erreur retourne */
	int		*sectornew			= (int *)		argv[nbarg++]; /* sectornew[nbspectres,nbcellules] */
	double		sectornew_date			= *(double *)		argv[nbarg++];
	double		*xmin				= (double *)		argv[nbarg++]; /* xmin[nbspins] = datation de chaque spin */
	short		*mag				= (short *)		argv[nbarg++]; /* mag[nbspins] */
	int		*start_pollution_solaire	= (int *)		argv[nbarg++]; /* start_pollution_solaire[nbspins] */
	int		*end_pollution_solaire		= (int *)		argv[nbarg++]; /* end_pollution_solaire[nbspins] */
	unsigned int	*sector_mask			= (unsigned int *)	argv[nbarg++]; /* sector_mask[nbspins] */
	size_t		*dataquick			= (size_t *)		argv[nbarg++];
	float		*IMA_NOISE			= (float *)		argv[nbarg++]; /* IMA_NOISE[nbenergies,nbmasses] */
	float		*IMA_MASS_MULT			= (float *)		argv[nbarg++]; /* IMA_MASS_MULT[nbmasses] */
	float		*IMA_POSITION1			= (float *)		argv[nbarg++]; /* IMA_POSITION1[nbspins,nbenergies,10] */
	float		*IMA_POSITION2			= (float *)		argv[nbarg++]; /* IMA_POSITION2[nbspins,nbenergies,10] */
	unsigned char	*IMA_PAC			= (unsigned char *)	argv[nbarg++]; /* IMA_PAC[nbspins] */
	unsigned char	*MEA_GEOMFACTOR			= (unsigned char *)	argv[nbarg++]; /* MEA_GEOMFACTOR[nbspins] */
	unsigned char	*MEA_DATAID			= (unsigned char *)	argv[nbarg++]; /* MEA_DATAID[nbspins] */
	int		nblat_extended			= *(int *)		argv[nbarg++]; /* 0 pour ne pas etendre, N pour etendre a N latitudes */
	int		nolat_extended			= *(int *)		argv[nbarg++]; /* numero de la latitude a utiliser pour les latitudes tendues */
	int		quick_solid			= *(int *)		argv[nbarg++]; /* 1 pour memoriser les coups de chaque angle solid, 0 sinon */
	unsigned char	use_phi_variable		= *(int *)		argv[nbarg++]; /* 1 utiliser des latitudes variables */
	float		*SC_POT_VOLT			= (float *)		argv[nbarg++]; /* SC_POT_VOLT[nbspin] */
	int		*TABINFO_INT			= (int *)		argv[nbarg++];
	double		*TABINFO_DOUBLE			= (double *)		argv[nbarg++];
	int		use_VxVyVz			= *(int *)		argv[nbarg++]; /* 1 pour utiliser Vxyzext, 0 sinon */
	float		*Vxext_km_sec			= (float *)		argv[nbarg++];
	float		*Vyext_km_sec			= (float *)		argv[nbarg++];
	float		*Vzext_km_sec			= (float *)		argv[nbarg++];
	int		*numeros			= (int *)		argv[nbarg++]; /* numeros[14] */
	short		*start_energy			= (short *)		argv[nbarg++]; /* start_energy[nbspins] */
	short		*end_energy			= (short *)		argv[nbarg++]; /* end_energy[nbspins] */
	float		*emin_full			= (float *)		argv[nbarg++]; /* emin_full[nbcellules,nbspectres,nbenergies] */
	float		*emoy_full			= (float *)		argv[nbarg++]; /* emoy_full[nbcellules,nbspectres,nbenergies] */
	float		*emax_full			= (float *)		argv[nbarg++]; /* emax_full[nbcellules,nbspectres,nbenergies] */
	float		*azmin_full			= (float *)		argv[nbarg++]; /* azmin_full[nbcellules,nbspectres,nbenergies] */
	float		*azmoy_full			= (float *)		argv[nbarg++]; /* azmoy_full[nbcellules,nbspectres,nbenergies] */
	float		*azmax_full			= (float *)		argv[nbarg++]; /* azmax_full[nbcellules,nbspectres,nbenergies] */
	float		*elmin_full			= (float *)		argv[nbarg++]; /* elmin_full[nbcellules,nbspectres,nbenergies] */
	float		*elmoy_full			= (float *)		argv[nbarg++]; /* elmoy_full[nbcellules,nbspectres,nbenergies] */
	float		*elmax_full			= (float *)		argv[nbarg++]; /* elmax_full[nbcellules,nbspectres,nbenergies] */
	IDL_STRING	*CL_ROOT			= (IDL_STRING *)	argv[nbarg++];

	/*
	Si tabmass[0] est negatif, cela signifie qu'il faut rechercher la masse suivante:
		-1:  H+
		-2:  He++
		-3:  He+
		-4:  O++
		-5:  O+
		-6:  CO+
		-7:  O2+
		-8:  CO2+
		-9:  Heavy
		-10: All
	Pour l'ion no, utiliser les masses de IMA_POSITION1[spin,energie,no]  IMA_POSITION2[spin,energie,no]
	*/

	/* ordre_cluster:

		1 si	(thetamin, thetamax) definissant les cellules vont de -90 a  +90 deg (latitude)
			(phimin  , phimax  ) definissant les spectres vont de   0   360 deg (longitude)	

		0 si	(thetamin, thetamax) definissant les cellules vont de   0 a 360 deg (longitude)
			(phimin  , phimax  ) definissant les spectres vont de -90  +90 deg (latitude)	
	*/


	/* Code erreur:
		-1: erreur dans malloc
	*/

	int		i;
	int		iV=0; // initialis sinon warning gcc
	float		accumulation_duree;
	double		date;

	int		i_N_cm3;

	int		i_Vx_km_sec;
	int		i_Vy_km_sec;
	int		i_Vz_km_sec;
	int		i_V_km_sec;

	int		i_Ppar_eV_cm3;
	int		i_Pper1_eV_cm3;
	int		i_Pper2_eV_cm3;
	int		i_Tpar_eV;
	int		i_Tper1_eV;
	int		i_Tper2_eV;

	int		i_Qx_erg_sec_cm2;
	int		i_Qy_erg_sec_cm2;
	int		i_Qz_erg_sec_cm2;
	int		i_Q_erg_sec_cm2;

	int		i_Pxx_eV_cm3;
	int		i_Pxy_eV_cm3;
	int		i_Pxz_eV_cm3;
	int		i_Pyy_eV_cm3;
	int		i_Pyz_eV_cm3;
	int		i_Pzz_eV_cm3;

	int		i_Ei_eV_cm3;
	int		i_Ti_eV;
	int		i_Ex;
	int		i_Ey;
	int		i_Ez;

	int		i_Pp_nPa;

	int		i_Quality;

	int		i_EV1x;
	int		i_EV1y;
	int		i_EV1z;

	int		i_EV2x;
	int		i_EV2y;
	int		i_EV2z;

	int		i_EV3x;
	int		i_EV3y;
	int		i_EV3z;

	double		emin;
	double		emoy;
	double		emax;
	double		val;
	double		N;
	double		Vx;
	double		Vy;
	double		Vz;
	double		Vx_km_sec;
	double		Vy_km_sec;
	double		Vz_km_sec;
	double		V_km_sec;
	double		Qx;
	double		Qy;
	double		Qz;
	double		Pxx;
	double		Pxy;
	double		Pxz;
	double		Pyy;
	double		Pyz;
	double		Pzz;
	float		Ppar;
	float		Pper1;
	float		Pper2;
	float		Ex;
	float		Ey;
	float		Ez;
	float		EV1x;
	float		EV1y;
	float		EV1z;
	float		EV2x;
	float		EV2y;
	float		EV2z;
	float		EV3x;
	float		EV3y;
	float		EV3z;

	double		*LAT_DELTA;
	double		*LAT_DELTA_COS;
	double		*LAT_DELTA_COS2;
	double		*LAT_DELTA_COSSIN;
	double		*LAT_DELTA_COS2SIN;
	double		*LAT_DELTA_SIN2COS;
	double		*LAT_DELTA_COS3;


	double		*LONG_DELTA;
	double		*LONG_DELTA_COS;
	double		*LONG_DELTA_SIN;
	double		*LONG_DELTA_COS2;
	double		*LONG_DELTA_COSSIN;
	double		*LONG_DELTA_SIN2;

	double		*DV;
	double		*V2;
	double		V;
	double		*DVsurV2;
	double		*DVsurV;
	double		*DVfoisV;
	unsigned char	*okV;

	double		*AZ_FULL_DELTA;
	double		*AZ_FULL_DELTA_COS;
	double		*AZ_FULL_DELTA_SIN;
	double		*AZ_FULL_DELTA_COS2;
	double		*AZ_FULL_DELTA_COSSIN;
	double		*AZ_FULL_DELTA_SIN2;
	double		*EL_FULL_DELTA;
	double		*EL_FULL_DELTA_COS;
	double		*EL_FULL_DELTA_COS2;
	double		*EL_FULL_DELTA_COSSIN;
	double		*EL_FULL_DELTA_COS2SIN;
	double		*EL_FULL_DELTA_SIN2COS;
	double		*EL_FULL_DELTA_COS3;
	double		*E_FULL_EMIN;
	double		*E_FULL_DV;
	double		*E_FULL_V2;
	double		*E_FULL_DVsurV2;
	double		*E_FULL_DVsurV;
	double		*E_FULL_DVfoisV;
	unsigned char	*E_FULL_okV;
	double		azmin;
	double		azmax;
	double		elmin;
	double		elmax;
	double		emin1;
	double		emoy1;
	double		emax1;
	int		ifull;



	double 		a1;
	double		a2;
	double		a3;
	double		a4;
	double		a5;
	double		a6;
	double		tmpx;
	double		tmpy;
	double		tmpz;

	double		trace_eV_cm3;

	double		*memorise_CJF1;

	int		pollue;

	unsigned char	*channelok=NULL;
	int		pos1=0;
	int		pos2=0;
	unsigned char	*p;
	int		nbcoups;
	int		ind;

	int		ilong;
	int		ilong_fin;
	int		ilat;
	int		ilat_fin;
	int		nblong;
	int		nblat;
	double		latmin;
	double		latmax;
	double		longmin;
	double		longmax;
	double		longmin_fin;
	double		longmax_fin;
	int		longitude;
	int		latitude;
	int		imasse;
	int		nomasse;

	int		ipac;
	int		igeomfactor;
	int		idataid;

	float		SC_POT_VOLT_A_UTILISER;
	double		SC_POT_V2;
	double		SC_POT_E;
	double		SC_POT_CORR_N=1; // initialis sinon warning gcc
	double		SC_POT_CORR_V=1; // initialis sinon warning gcc
	double		SC_POT_CORR_P=1; // initialis sinon warning gcc
	double		SC_POT_CORR_Q=1; // initialis sinon warning gcc

	int 		imasse_deb;
	int 		imasse_fin;

	int		use_sampling;
	float		*LocalVx=NULL;
	float		*LocalVy=NULL;
	float		*LocalVz=NULL;
	float		*tab_fdist=NULL;
	float		tmoy;
	float		pmoy;
	float		cosT;
	float		sinT;
	float		cosP;
	float		sinP;
	float		cosLAT;
	float		sinLAT;
	float		cosLONG;
	float		sinLONG;
	float		SamplFactor;
	float		QualN;

	float		Vext_km_sec[3];

	int		is_tablecte; // 1 si la table d'nergie ne dpend ni de la longitude ni de la latitude

	double 		Vmin;
	double		Vmax;

	// Pour comparer les rsultats actuels avec l'ancienne mthode
	//#define COMPARE_MOMENTS

	#ifdef COMPARE_MOMENTS
	char		s[1024],s_old[1024];
	double		N_old;
	double		Vx_old;
	double		Vy_old;
	double		Vz_old;
	double		Qx_old;
	double		Qy_old;
	double		Qz_old;
	double		Pxx_old;
	double		Pxy_old;
	double		Pxz_old;
	double		Pyy_old;
	double		Pyz_old;
	double		Pzz_old;
	#endif

//	Pour THEMIS uniquement:
//		Pour 'eef_088x15': nrg_wt dans les routines Berkeley vaut [2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0]
// 		Pour 'eir_050x24': nrg_wt dans les routines Berkeley vaut [1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,2,2,2,2,2,2,2,0,0,0,0,0,0,0,0]
//	
//		emin et max sont issus de nrg_wt.
//		Indiquent comment sont regroupes les nergies: numro min et wt des nrgies utilises pour chaque palier
//		Pas indispensable dans les modes  32 nergies car nrg_wt vaut [1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1]
//		Pas indispensable dans les modes  16 nergies car nrg_wt vaut [2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2]
//		
//				              1   2   3   4   5   6   7   8   9  10  11  12  13  14  15  16  17  18  19  20  21  22  23  24  25  26  27  28  29  30  31  32
	int		emin_eef_088x15[15]={ 0,  2,  4,  6,  8, 10, 12, 14, 16, 18, 20, 22, 24, 26, 28};
	int		nrwt_eef_088x15[15]={ 2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2};

	int		emin_eir_050x24[24]={ 0,  1,  2,  3,  4,  5,  6,  7,  8,  9, 10, 11, 12, 13, 14, 15, 16, 18, 20, 22, 24, 26, 28, 30};
	int		nrwt_eir_050x24[24]={ 1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  2,  2,  2,  2,  2,  2,  2,  2};

	if (nbarg != argc) return;

	DEBUT ();
	MAVEN_SWEA_CALIB_DEBUT();

	// Faut-il utiliser sampling ? oui pour IMA-ASPERA4
	// non si toutes les valeurs de sampling[nbenergies,nbspectres,nbcellules] sont  1.0
	use_sampling = 0;
	if (tabmass[0] >= 0) {	// pas de sampling pour les modes avec selection de plusieurs ions
		for (ienergie=0 ; ienergie<nbenergies ; ienergie++) {
			for (ispectre=0 ; ispectre<nbspectres ; ispectre++) {
				for (icellule=0 ; icellule<nbcellules ; icellule++) {
					if (sampling[indice3(ienergie,ispectre,icellule,nbenergies,nbspectres,nbcellules)] != 1.0) {
						use_sampling=1;
					}
				}
			}
		}
	}

	if (use_sampling==1) {

		LocalVx   = (float *)malloc(nbsensitivity*nbcellules*nbspectres*sizeof(float));
		LocalVy   = (float *)malloc(nbsensitivity*nbcellules*nbspectres*sizeof(float));
		LocalVz   = (float *)malloc(nbsensitivity*nbcellules*nbspectres*sizeof(float));
		tab_fdist = (float *)malloc(nbcellules*nbspectres*sizeof(float));

		for (isensitivity=0 ; isensitivity<nbsensitivity ; isensitivity++) {

			for (icellule=0 ; icellule<nbcellules ; icellule++) {
				tmoy = thetamoy[indice2(isensitivity,icellule,nbsensitivity,nbcellules)];
				cosT = cos(tmoy*M_PI/180.);
				sinT = sin(tmoy*M_PI/180.);

				for (ispectre=0 ; ispectre<nbspectres ; ispectre++) {

					pmoy = phimoy[ispectre];
					cosP = cos(pmoy*M_PI/180.);
					sinP = sin(pmoy*M_PI/180.);

					cosLAT = ordre_cluster ? cosT : cosP;
					sinLAT = ordre_cluster ? sinT : sinP;
					cosLONG = ordre_cluster ? cosP : cosT;
					sinLONG = ordre_cluster ? sinP : sinT;

					LocalVx[indice2(icellule,ispectre,nbcellules,nbspectres)] = cosLAT*cosLONG;
					LocalVy[indice2(icellule,ispectre,nbcellules,nbspectres)] = cosLAT*sinLONG;
					LocalVz[indice2(icellule,ispectre,nbcellules,nbspectres)] = sinLAT;

				}
	
			}
	
		}
	}


	memorise_CJF1 = (double *)malloc(nbangles*sizeof(double));
	cjf = COUNT_SEC;	/* 2 pour avoir des coups/sec non corriges par eff */

	if (optimise) {

		/* Experience IMA */

		channelok = (unsigned char *) malloc (nbmasses);
		nbytes    = 2;
		p2        = (byte2 *)         malloc (nbenergies*nbcellules*nbspectres*nbmasses*nbytes);

		for (i=0 ; i<nbmasses ; i++)
			channelok[i]=1;
		if (is_IMA_ASPERA3(nocis) && nbmasses==32) {
			channelok[ 0]=0;
			channelok[ 4]=0;
			channelok[10]=0;
			channelok[22]=0;
		}

	}

	nblat = ordre_cluster ? nbcellules : nbspectres;
	if (nblat_extended) nblat=nblat_extended;
	nblong = ordre_cluster ? nbspectres : nbcellules;

	if (	(LAT_DELTA		= (double *)malloc(nbsensitivity*nblat*nbenergies*nbtablesP*sizeof(double))) == NULL ||
		(LAT_DELTA_COS		= (double *)malloc(nbsensitivity*nblat*nbenergies*nbtablesP*sizeof(double))) == NULL ||
		(LAT_DELTA_COS2		= (double *)malloc(nbsensitivity*nblat*nbenergies*nbtablesP*sizeof(double))) == NULL ||
		(LAT_DELTA_COSSIN	= (double *)malloc(nbsensitivity*nblat*nbenergies*nbtablesP*sizeof(double))) == NULL ||
		(LAT_DELTA_COS2SIN	= (double *)malloc(nbsensitivity*nblat*nbenergies*nbtablesP*sizeof(double))) == NULL ||
		(LAT_DELTA_SIN2COS	= (double *)malloc(nbsensitivity*nblat*nbenergies*nbtablesP*sizeof(double))) == NULL ||
		(LAT_DELTA_COS3		= (double *)malloc(nbsensitivity*nblat*nbenergies*nbtablesP*sizeof(double))) == NULL ||

		(EL_FULL_DELTA		= (double *)malloc(nbcellules*nbspectres*nbenergies*sizeof(double))) == NULL ||
		(EL_FULL_DELTA_COS	= (double *)malloc(nbcellules*nbspectres*nbenergies*sizeof(double))) == NULL ||
		(EL_FULL_DELTA_COS2	= (double *)malloc(nbcellules*nbspectres*nbenergies*sizeof(double))) == NULL ||
		(EL_FULL_DELTA_COSSIN	= (double *)malloc(nbcellules*nbspectres*nbenergies*sizeof(double))) == NULL ||
		(EL_FULL_DELTA_COS2SIN	= (double *)malloc(nbcellules*nbspectres*nbenergies*sizeof(double))) == NULL ||
		(EL_FULL_DELTA_SIN2COS	= (double *)malloc(nbcellules*nbspectres*nbenergies*sizeof(double))) == NULL ||
		(EL_FULL_DELTA_COS3	= (double *)malloc(nbcellules*nbspectres*nbenergies*sizeof(double))) == NULL ||

		(LONG_DELTA		= (double *)malloc(nbspins*nblong*nbenergies*sizeof(double))) == NULL ||
		(LONG_DELTA_COS		= (double *)malloc(nbspins*nblong*nbenergies*sizeof(double))) == NULL ||
		(LONG_DELTA_SIN		= (double *)malloc(nbspins*nblong*nbenergies*sizeof(double))) == NULL ||
		(LONG_DELTA_COS2	= (double *)malloc(nbspins*nblong*nbenergies*sizeof(double))) == NULL ||
		(LONG_DELTA_COSSIN	= (double *)malloc(nbspins*nblong*nbenergies*sizeof(double))) == NULL ||
		(LONG_DELTA_SIN2	= (double *)malloc(nbspins*nblong*nbenergies*sizeof(double))) == NULL ||

		(AZ_FULL_DELTA		= (double *)malloc(nbcellules*nbspectres*nbenergies*sizeof(double))) == NULL ||
		(AZ_FULL_DELTA_COS	= (double *)malloc(nbcellules*nbspectres*nbenergies*sizeof(double))) == NULL ||
		(AZ_FULL_DELTA_SIN	= (double *)malloc(nbcellules*nbspectres*nbenergies*sizeof(double))) == NULL ||
		(AZ_FULL_DELTA_COS2	= (double *)malloc(nbcellules*nbspectres*nbenergies*sizeof(double))) == NULL ||
		(AZ_FULL_DELTA_COSSIN	= (double *)malloc(nbcellules*nbspectres*nbenergies*sizeof(double))) == NULL ||
		(AZ_FULL_DELTA_SIN2	= (double *)malloc(nbcellules*nbspectres*nbenergies*sizeof(double))) == NULL ||

		(DV			= (double *)malloc(nbtablesE*nbenergies*sizeof(double))) == NULL ||
		(V2			= (double *)malloc(nbtablesE*nbenergies*sizeof(double))) == NULL ||
		(DVsurV2		= (double *)malloc(nbtablesE*nbenergies*sizeof(double))) == NULL ||
		(DVsurV			= (double *)malloc(nbtablesE*nbenergies*sizeof(double))) == NULL ||
		(DVfoisV		= (double *)malloc(nbtablesE*nbenergies*sizeof(double))) == NULL ||
		(okV			= (unsigned char *)malloc(nbtablesE*nbenergies*sizeof(unsigned char))) == NULL ||

		(E_FULL_EMIN		= (double *)malloc(nbcellules*nbspectres*nbenergies*sizeof(double))) == NULL ||
		(E_FULL_DV		= (double *)malloc(nbcellules*nbspectres*nbenergies*sizeof(double))) == NULL ||
		(E_FULL_V2		= (double *)malloc(nbcellules*nbspectres*nbenergies*sizeof(double))) == NULL ||
		(E_FULL_DVsurV2		= (double *)malloc(nbcellules*nbspectres*nbenergies*sizeof(double))) == NULL ||
		(E_FULL_DVsurV		= (double *)malloc(nbcellules*nbspectres*nbenergies*sizeof(double))) == NULL ||
		(E_FULL_DVfoisV		= (double *)malloc(nbcellules*nbspectres*nbenergies*sizeof(double))) == NULL ||
		(E_FULL_okV		= (unsigned char *)malloc(nbcellules*nbspectres*nbenergies*sizeof(unsigned char))) == NULL ||

		(okspectre		= (unsigned char *)malloc(nbspectres*sizeof(unsigned char))) == NULL) {

			*erreur = -1;
			return;

	}

	/* Nord - Sud */
	for (isensitivity=0 ; isensitivity<nbsensitivity ; isensitivity++) {

		for (ilat=0 ; ilat<nblat ; ilat++) {

			if (ordre_cluster==0 && use_phi_variable) {
				// Pour MAVEN-SWEA, MAVEN_SWIA, MAVEN_STATIC: phi dpend de ilat, ienergie et itable

				for (itable=0 ; itable<nbtablesP ; itable++) {
					for (ienergie=0 ; ienergie<nbenergies ; ienergie++) {
						i = indice3(ilat,ienergie,itable,nbspectres,nbenergies,nbtablesP);
						latmin = phimin[i];
						latmax = phimax[i];
						LAT_DELTA[i]         = latmax - latmin;
						LAT_DELTA_COS[i]     = LAT_DELTA[i] * Cmoy   (latmin, latmax);
						LAT_DELTA_COS2[i]    = LAT_DELTA[i] * C2moy  (latmin, latmax);
						LAT_DELTA_COSSIN[i]  = LAT_DELTA[i] * CSmoy  (latmin, latmax);
						LAT_DELTA_COS2SIN[i] = LAT_DELTA[i] * C2Smoy (latmin, latmax);
						LAT_DELTA_SIN2COS[i] = LAT_DELTA[i] * S2Cmoy (latmin, latmax);
						LAT_DELTA_COS3[i]    = LAT_DELTA[i] * C3moy  (latmin, latmax);
						//printf ("LAT_DELTA[%d] = %f\n", i,LAT_DELTA[i]);
					}
				}
			} else {
				i      = ordre_cluster ? indice2(isensitivity,ilat,nbsensitivity,nbcellules) : ilat;
				latmin = ordre_cluster ? thetamin[i] : phimin[i];
				latmax = ordre_cluster ? thetamax[i] : phimax[i];
				LAT_DELTA[i]         = latmax - latmin;
				LAT_DELTA_COS[i]     = LAT_DELTA[i] * Cmoy   (latmin, latmax);
				LAT_DELTA_COS2[i]    = LAT_DELTA[i] * C2moy  (latmin, latmax);
				LAT_DELTA_COSSIN[i]  = LAT_DELTA[i] * CSmoy  (latmin, latmax);
				LAT_DELTA_COS2SIN[i] = LAT_DELTA[i] * C2Smoy (latmin, latmax);
				LAT_DELTA_SIN2COS[i] = LAT_DELTA[i] * S2Cmoy (latmin, latmax);
				LAT_DELTA_COS3[i]    = LAT_DELTA[i] * C3moy  (latmin, latmax);
				//printf ("LAT_DELTA[%d] = %f\n", i,LAT_DELTA[i]);
			}
	
		}

	}

	/* Est - Ouest */
	for (ilong=0 ; ilong<nblong ; ilong++) {

		if (ordre_cluster==1 && use_phi_variable) {
			// Pour MMS_DES_brst_l2, MMS_DIS_brts_l2: phi dpend de ispin et ilong(==nbspectres)

			for (ispin=0 ; ispin<nbspins ; ispin++) {
				i = indice2(ispin,ilong,nbspins,nbspectres);
				longmin = phimin[i];
				longmax = phimax[i];
				if (longmax < longmin) longmax += 2*M_PI; /* au cas ou */

				LONG_DELTA[i]        = longmax - longmin;
				LONG_DELTA_COS[i]    = LONG_DELTA[i] * Cmoy  (longmin, longmax);
				LONG_DELTA_SIN[i]    = LONG_DELTA[i] * Smoy  (longmin, longmax);
				LONG_DELTA_COS2[i]   = LONG_DELTA[i] * C2moy (longmin, longmax);
				LONG_DELTA_COSSIN[i] = LONG_DELTA[i] * CSmoy (longmin, longmax);
				LONG_DELTA_SIN2[i]   = LONG_DELTA[i] * S2moy (longmin, longmax);
				//printf ("ICI LONG_DELTA[(%d,%d)] = %f\n", ispin,ilong,LONG_DELTA[i]);
				//printf ("ICI LONG_DELTA_COS[(%d,%d)] = %f\n", ispin,ilong,LONG_DELTA_COS[i]);

			}

		} else {

			i = ilong;
			longmin = ordre_cluster ? phimin[i] : thetamin[i];
			longmax = ordre_cluster ? phimax[i] : thetamax[i];
			if (longmax < longmin) longmax += 2*M_PI; /* arrive sur Swea-Stereo */

			for (ienergie=0 ; ienergie<nbenergies ; ienergie++) {

				if (quick_solid && use_long_var && nbenergies==15) {
					// Verrue pour THEMIS mode 'eef_088x15'
					longmin_fin = longmin     + emin_eef_088x15[ienergie]*(longmax-longmin)/(float)32;
					longmax_fin = longmin_fin + nrwt_eef_088x15[ienergie]*(longmax-longmin)/(float)32;

				} else if (quick_solid && use_long_var && nbenergies==24) {
					// Verrue pour THEMIS mode 'eir_050x24'
					longmin_fin = longmin     + emin_eir_050x24[ienergie]*(longmax-longmin)/(float)32;
					longmax_fin = longmin_fin + nrwt_eir_050x24[ienergie]*(longmax-longmin)/(float)32;

				} else {

					longmin_fin = use_long_var ? longmin + (ienergie+0)*(longmax-longmin)/(float)nbenergies : longmin;
					longmax_fin = use_long_var ? longmin + (ienergie+1)*(longmax-longmin)/(float)nbenergies : longmax;
				}

				//longmin_fin = longmin;
				//longmax_fin = longmax;

				ilong_fin = indice2(ilong,ienergie,nblong,nbenergies);
				LONG_DELTA[ilong_fin]        = longmax - longmin;
				LONG_DELTA_COS[ilong_fin]    = LONG_DELTA[ilong_fin] * Cmoy  (longmin_fin, longmax_fin);
				LONG_DELTA_SIN[ilong_fin]    = LONG_DELTA[ilong_fin] * Smoy  (longmin_fin, longmax_fin);
				LONG_DELTA_COS2[ilong_fin]   = LONG_DELTA[ilong_fin] * C2moy (longmin_fin, longmax_fin);
				LONG_DELTA_COSSIN[ilong_fin] = LONG_DELTA[ilong_fin] * CSmoy (longmin_fin, longmax_fin);
				LONG_DELTA_SIN2[ilong_fin]   = LONG_DELTA[ilong_fin] * S2moy (longmin_fin, longmax_fin);
				//printf ("LONG_DELTA[(%d,%d)] = %f\n", ilong,ienergie,LONG_DELTA[ilong_fin]);
			}

		}

	}


	if (tabmass[0]<0) {
		nomasse=nbmasses-tabmass[0]-1;	/* nbmasses si tabmass[0]==-1, nbmasses+1 si tabmass[0]==-2, ... */
	} else {
		nomasse=0; /* on ne sait jamais */
		for (i=0 ; i<nbmasses ;i++) {
			if (tabmass[i]==1) {
				nomasse=i;
				break;
			}
		}
	}

	for (itable=0 ; itable<nbtablesE ; itable++) {
		for (ienergie=0 ; ienergie<nbenergies ; ienergie++) {
			i = indice2(itable,ienergie,nbtablesE,nbenergies);
		/*

				|                    |    
				emin                 emax                okV
				|                    |
				|                    |
			x--x	|                    |                  0
			x-------|-----------x        |                  1
			x-------|--------------------|-------x          1
				|     x--------x     |                  1
				|     x--------------|-------x          1
				|                    |       x----x     0
		*/


			okV[i] = energymax>=Emin[i] && energymin<=Emax[i];
			emin = Emin[i] + valE;
			emoy = Emoy[i] + valE;
			emax = Emax[i] + valE;

			// Energies ngatives qui provoquent floating point invalid operation
			// ex: /home/penou/DATA/CLUSTER/SOFT/CLL3/resource/aspera3_moments3d_ima.cl.gz
			if (emin < 0) emin = 1e-11;
			if (emoy < 0) emoy = 1e-10;
			if (emax < 0) emax = 1e-9;

			// V2[] est utilis pour calculer SC_POT_CORR_N, SC_POT_CORR_V, SC_POT_CORR_P et SC_POT_CORR_Q
			V2[i] = 2*emoy*Q[nomasse]*ELECTRONVOLT/MASSE[nomasse];

// Code obsolte
//			// Ancienne mthode
//			//DV[i]      = sqrt(2*emax*Q[nomasse]*ELECTRONVOLT/MASSE[nomasse])-sqrt(2*emin*Q[nomasse]*ELECTRONVOLT/MASSE[nomasse]);
//
//			// Pour SST
//			DV[i]      = ((emax-emin)*Q[nomasse]*ELECTRONVOLT)/sqrt(2*MASSE[nomasse]*emoy*Q[nomasse]*ELECTRONVOLT);
//
//			V       = sqrt(2*emoy*Q[nomasse]*ELECTRONVOLT/MASSE[nomasse]);
//			//printf ("dE[(T%d,E%0d)]=%f  emax-emin=%f\n",itable,ienergie,MASSE[nomasse]*V[i]*DV[i]/ELECTRONVOLT,emax-emin);
//			DVsurV2[i] = DV[i]/V2[i];
//			DVsurV[i]  = DV[i]/V;
//			DVfoisV[i] = DV[i]*V;
			// Nouvelle mthode d'avril 2019: rsolution mathmatique de l'intgrale
			Vmin       = sqrt(2*emin*Q[nomasse]*ELECTRONVOLT/MASSE[nomasse]);
			Vmax       = sqrt(2*emax*Q[nomasse]*ELECTRONVOLT/MASSE[nomasse]);
			DVsurV2[i] = -1.0/Vmax - (-1.0/Vmin);		// intgrale de 1/(V*V) utilis pour N
			DVsurV[i]  = log(Vmax) - log(Vmin);		// intgrale de 1/V     utilis pour V
			DVfoisV[i] = 0.5*(Vmax*Vmax - Vmin*Vmin);	// intgrale de V       utilis pour Q
			DV[i]      = Vmax - Vmin;			// intgrale de 1       utilis pour P

		}
	}

	if (is_SOLAR_PAS(nocis)) {

		for (ienergie=0 ; ienergie<nbenergies ; ienergie++) {

			for (ispectre=0 ; ispectre<nbspectres ; ispectre++) {

				for (icellule=0 ; icellule<nbcellules ; icellule++) {

					ifull = indice3(icellule,ispectre,ienergie,nbcellules,nbspectres,nbenergies);

					// Initialisation  0
					AZ_FULL_DELTA[ifull]		= 0;
					AZ_FULL_DELTA_COS[ifull]	= 0;
					AZ_FULL_DELTA_SIN[ifull]	= 0;
					AZ_FULL_DELTA_COS2[ifull]	= 0;
					AZ_FULL_DELTA_COSSIN[ifull]	= 0;
					AZ_FULL_DELTA_SIN2[ifull]	= 0;

					EL_FULL_DELTA[ifull]		= 0;
					EL_FULL_DELTA_COS[ifull]	= 0;
					EL_FULL_DELTA_COS2[ifull]	= 0;
					EL_FULL_DELTA_COSSIN[ifull]	= 0;
					EL_FULL_DELTA_COS2SIN[ifull]	= 0;
					EL_FULL_DELTA_SIN2COS[ifull]	= 0;
					EL_FULL_DELTA_COS3[ifull]	= 0;

					E_FULL_EMIN[ifull]		= 0;
					E_FULL_okV[ifull]		= 0;
					E_FULL_V2[ifull]		= 0;
					E_FULL_DVsurV2[ifull]		= 0;
					E_FULL_DVsurV[ifull]		= 0;
					E_FULL_DVfoisV[ifull]		= 0;
					E_FULL_DV[ifull]		= 0;

					azmin = azmin_full[ifull];
					azmax = azmax_full[ifull];

					elmin = elmin_full[ifull];
					elmax = elmax_full[ifull];

					emin = emin_full[ifull];
					emax = emax_full[ifull];

					if (azmin < -1e30) continue;
					if (azmax < -1e30) continue;

					if (elmin < -1e30) continue;
					if (elmax < -1e30) continue;

					azmin = azmin / 180. * M_PI; // deg to rad
					azmax = azmax / 180. * M_PI; // deg to rad

					elmin = elmin / 180. * M_PI; // deg to rad
					elmax = elmax / 180. * M_PI; // deg to rad

					emin1 = emin + valE;
					emoy1 = emax + valE;
					emax1 = emax + valE;
					Vmin = sqrt(2*emin1*Q[nomasse]*ELECTRONVOLT/MASSE[nomasse]);
					Vmax = sqrt(2*emax1*Q[nomasse]*ELECTRONVOLT/MASSE[nomasse]);

					//printf ("elmin=%f elmax=%f azmin=%f azmax=%f\n",elmin,elmax,azmin,azmax);

					AZ_FULL_DELTA[ifull]		= azmax - azmin;
					AZ_FULL_DELTA_COS[ifull]	= AZ_FULL_DELTA[ifull] * Cmoy  (azmin, azmax);
					AZ_FULL_DELTA_SIN[ifull]	= AZ_FULL_DELTA[ifull] * Smoy  (azmin, azmax);
					AZ_FULL_DELTA_COS2[ifull]	= AZ_FULL_DELTA[ifull] * C2moy (azmin, azmax);
					AZ_FULL_DELTA_COSSIN[ifull]	= AZ_FULL_DELTA[ifull] * CSmoy (azmin, azmax);
					AZ_FULL_DELTA_SIN2[ifull]	= AZ_FULL_DELTA[ifull] * S2moy (azmin, azmax);

					EL_FULL_DELTA[ifull]		= elmax - elmin;
					EL_FULL_DELTA_COS[ifull]	= EL_FULL_DELTA[ifull] * Cmoy   (elmin, elmax);
					EL_FULL_DELTA_COS2[ifull]	= EL_FULL_DELTA[ifull] * C2moy  (elmin, elmax);
					EL_FULL_DELTA_COSSIN[ifull]	= EL_FULL_DELTA[ifull] * CSmoy  (elmin, elmax);
					EL_FULL_DELTA_COS2SIN[ifull]	= EL_FULL_DELTA[ifull] * C2Smoy (elmin, elmax);
					EL_FULL_DELTA_SIN2COS[ifull]	= EL_FULL_DELTA[ifull] * S2Cmoy (elmin, elmax);
					EL_FULL_DELTA_COS3[ifull]	= EL_FULL_DELTA[ifull] * C3moy  (elmin, elmax);

					E_FULL_EMIN[ifull]		= emin;
					E_FULL_okV[ifull]		= energymax>=emin && energymin<=emax;
					E_FULL_V2[ifull]		= 2*emoy1*Q[nomasse]*ELECTRONVOLT/MASSE[nomasse];
					E_FULL_DVsurV2[ifull]		= -1.0/Vmax - (-1.0/Vmin);	// intgrale de 1/(V*V) utilis pour N
					E_FULL_DVsurV[ifull]		= log(Vmax) - log(Vmin);	// intgrale de 1/V     utilis pour V
					E_FULL_DVfoisV[ifull]		= 0.5*(Vmax*Vmax - Vmin*Vmin);	// intgrale de V       utilis pour Q
					E_FULL_DV[ifull]		= Vmax - Vmin;			// intgrale de 1       utilis pour P

					//printf ("E_FULL_DV[%d] = %e Vmin=%lf Vmax=%lf\n",ifull,E_FULL_DV[ifull],Vmin,Vmax);

				}
			}

		}

	}

	if ((MASSE[nomasse]>9.1e-31) && (MASSE[nomasse]<9.2e-31)) { // masse de l'electron
		Q[nomasse]=-1;
	}

	for (ispin=0 ; ispin<nbspins ; ispin++) {

		tabphi_to_okspectre (B, tabphi, nbspectres, start, ispin, produit1, prodmin, prodmax, okspectre, nocis);

		pollution_maj (nocis, ispin, cis_mode, start_pollution_solaire, end_pollution_solaire, nbspectres, nbcellules, nbangles, solid, pollution);

		if (is_ELS(nocis)) sector_mask_to_solid (sector_mask[ispin], nbcellules, solid);

		i_N_cm3			= indice2(numeros[0],		ispin,nbchamps,nbspins);

		i_Vx_km_sec		= indice2(numeros[1]+nox,	ispin,nbchamps,nbspins);
		i_Vy_km_sec		= indice2(numeros[1]+noy,	ispin,nbchamps,nbspins);
		i_Vz_km_sec		= indice2(numeros[1]+noz,	ispin,nbchamps,nbspins);
		i_V_km_sec		= indice2(numeros[1]+3,		ispin,nbchamps,nbspins);

		i_Ppar_eV_cm3		= indice2(numeros[2],		ispin,nbchamps,nbspins);
		i_Pper1_eV_cm3		= indice2(numeros[2]+1,		ispin,nbchamps,nbspins);
		i_Pper2_eV_cm3		= indice2(numeros[2]+2,		ispin,nbchamps,nbspins);
		i_Tpar_eV		= indice2(numeros[3],		ispin,nbchamps,nbspins);
		i_Tper1_eV		= indice2(numeros[3]+1,		ispin,nbchamps,nbspins);
		i_Tper2_eV		= indice2(numeros[3]+2,		ispin,nbchamps,nbspins);

		i_Qx_erg_sec_cm2	= indice2(numeros[4]+nox,	ispin,nbchamps,nbspins);
		i_Qy_erg_sec_cm2	= indice2(numeros[4]+noy,	ispin,nbchamps,nbspins);
		i_Qz_erg_sec_cm2	= indice2(numeros[4]+noz,	ispin,nbchamps,nbspins);
		i_Q_erg_sec_cm2		= indice2(numeros[4]+3,		ispin,nbchamps,nbspins);

		i_Pxx_eV_cm3		= indice2(numeros[5]+noxx,	ispin,nbchamps,nbspins);
		i_Pxy_eV_cm3		= indice2(numeros[5]+noxy,	ispin,nbchamps,nbspins);
		i_Pxz_eV_cm3		= indice2(numeros[5]+noxz,	ispin,nbchamps,nbspins);
		i_Pyy_eV_cm3		= indice2(numeros[5]+noyy,	ispin,nbchamps,nbspins);
		i_Pyz_eV_cm3		= indice2(numeros[5]+noyz,	ispin,nbchamps,nbspins);
		i_Pzz_eV_cm3		= indice2(numeros[5]+nozz,	ispin,nbchamps,nbspins);

		i_Ei_eV_cm3		= indice2(numeros[6],		ispin,nbchamps,nbspins);
		i_Ti_eV			= indice2(numeros[7],		ispin,nbchamps,nbspins);

		i_Ex			= indice2(numeros[8]+nox,	ispin,nbchamps,nbspins);
		i_Ey			= indice2(numeros[8]+noy,	ispin,nbchamps,nbspins);
		i_Ez			= indice2(numeros[8]+noz,	ispin,nbchamps,nbspins);

		i_Pp_nPa		= indice2(numeros[9],		ispin,nbchamps,nbspins);
		i_Quality		= indice2(numeros[10],		ispin,nbchamps,nbspins);

		i_EV1x			= indice2(numeros[11]+nox,	ispin,nbchamps,nbspins);
		i_EV1y			= indice2(numeros[11]+noy,	ispin,nbchamps,nbspins);
		i_EV1z			= indice2(numeros[11]+noz,	ispin,nbchamps,nbspins);

		i_EV2x			= indice2(numeros[12]+nox,	ispin,nbchamps,nbspins);
		i_EV2y			= indice2(numeros[12]+noy,	ispin,nbchamps,nbspins);
		i_EV2z			= indice2(numeros[12]+noz,	ispin,nbchamps,nbspins);

		i_EV3x			= indice2(numeros[13]+nox,	ispin,nbchamps,nbspins);
		i_EV3y			= indice2(numeros[13]+noy,	ispin,nbchamps,nbspins);
		i_EV3z			= indice2(numeros[13]+noz,	ispin,nbchamps,nbspins);

		N=Vx=Vy=Vz=Qx=Qy=Qz=Pxx=Pxy=Pxz=Pyy=Pyz=Pzz=0;
		#ifdef COMPARE_MOMENTS
		N_old=Vx_old=Vy_old=Vz_old=Qx_old=Qy_old=Qz_old=Pxx_old=Pxy_old=Pxz_old=Pyy_old=Pyz_old=Pzz_old=0;
		#endif
		SamplFactor=0;
		QualN=0;

		ipac			= IMA_PAC[ispin];
		igeomfactor		= MEA_GEOMFACTOR[ispin];
		idataid			= MEA_DATAID[ispin];
		icarte			= indC[ispin];
		isensitivity		= sensitivity[ispin];
		accumulation		= nb_accumulation[ispin];
		accumulation_duree	= accumulation*duree_comptage[ispin];
		date			= xmin[ispin];
		MAVEN_SWEA_CALIB_GET();
		sector			= date < sectornew_date ? sectorold : sectornew;
		p1			= get_p1(tabdata,no1);

		if (is_pad) GET_SOLID();

		if (optimise) {

			/* Experience IMA */

			bzero (p2, nbenergies*nbcellules*nbspectres*nbmasses*2);
			for (ienergie=0 ; ienergie<nbenergies ; ienergie++) {
				for (ispectre=0 ; ispectre<nbspectres ; ispectre++) {
					if ((p = (unsigned char *) dataquick[indice3(ienergie,ispectre,no1+ispin,nbenergies,nbspectres,INUTILE)]) != 0) {
						nbcoups = 256*p[0] + p[1];
						ind = 2;
						for (i=0 ; i<nbcoups ; i++, ind += 4) {
							icellule = p[ind+0];
							imasse   = p[ind+1];
							p2[nocoup] = 256*p[ind+2] + p[ind+3];
						}
					}
				}
			}
		} else {
			p2 = get_p2(tabdata,no1);
		}
		p4 = get_p4(tabdata,no1);
		pfloat = get_pfloat(tabdata,no1);
		pdouble = get_pdouble(tabdata,no1);

		SC_POT_VOLT_A_UTILISER = SC_POT_VOLT[ispin];
		SC_POT_E = SC_POT_VOLT_A_UTILISER*Q[nomasse];
		SC_POT_V2 = 2*SC_POT_E*ELECTRONVOLT/MASSE[nomasse];

		if (is_MAVEN_SWEA(nocis) && SC_POT_VOLT_A_UTILISER==0) continue;

		for (ienergie=0 ; ienergie<nbenergies ; ienergie++) {

			if (ienergie < start_energy[ispin]) continue;	// pour acclrer SOLAR_PAS
			if (ienergie > end_energy[ispin]) continue;	// pour acclrer SOLAR_PAS

			is_tablecte = 1;
			for (ispectre=1 ; ispectre<nbspectres ; ispectre++) {
				if (indY[ispin*nbspectres+ispectre] != indY[ispin*nbspectres]) {
					is_tablecte = 0;
					break;
				}
			}

			if (quick_solid) {

				// Optimisation pour themis_eesa et themis_esst
				//
				// - utilisation de memorise_CJF1[]: gain de temps pour les grosses tables d'angles
				// - iV ne dpend pas ni de la latitude ni de la longitude
				// - il y a une seule masse

				imasse = nomasse;
				itable = indY[ispin*nbspectres+0]; /* 1er spectre */
				if (itable == -1) continue;
				iV = indice2(itable,ienergie,nbtablesE,nbenergies);
				if (okV[iV]==0) continue;
				// Correction potentiel satellite
				// ------------------------------
				if (Emin[iV] <= -SC_POT_E) continue;
				SC_POT_CORR_N = pow (1 + SC_POT_V2/V2[iV], 0.5);
				SC_POT_CORR_V = pow (1 + SC_POT_V2/V2[iV], 1.0);
				SC_POT_CORR_P = pow (1 + SC_POT_V2/V2[iV], 1.5);
				SC_POT_CORR_Q = pow (1 + SC_POT_V2/V2[iV], 2.0);
				for (iangle=0 ; iangle<nbangles ; iangle++) {
					memorise_CJF1[iangle]=-1;
				}
				for (longitude=0 ; longitude<nblong ; longitude++) { /* Est - Ouest: spectres */
					ispectre = longitude;
					if (okspectre[ispectre]==0) continue;
					a1=a2=a3=a4=a5=a6=0;
					for (latitude=0 ; latitude<nblat ; latitude++) { /* Nord - Sud: cellules */
						icellule = latitude;
						if (tabtheta[icellule]==0) continue;

						if (memorise_CJF1[solid[noscc]]!=-1) {
							val = memorise_CJF1[solid[noscc]];
						} else {
							COUP_TO_CJF1 (cjf);
							memorise_CJF1[solid[noscc]]=val;
						}
						if (val<-FILLVAL_E30 || val==0) continue;
						if ((fg  = get_fg ) < -FILLVAL_E30) continue; // get_data_moments
						if ((eff = get_eff) < -FILLVAL_E30) continue;
						val /= eff*0.5*fg;
						ilat = indice2(sensitivity[ispin],latitude,nbsensitivity,INUTILE);
						a1 += val * LAT_DELTA_COS[ilat];
						a2 += val * LAT_DELTA_COS2[ilat];
						a3 += val * LAT_DELTA_COSSIN[ilat];
						a4 += val * LAT_DELTA_COS2SIN[ilat]; 
						a5 += val * LAT_DELTA_SIN2COS[ilat];
						a6 += val * LAT_DELTA_COS3[ilat];
					}
					ilong_fin = indice2(longitude,ienergie,nblong,nbenergies);
					tmpx = a2 * LONG_DELTA_COS[ilong_fin];
					tmpy = a2 * LONG_DELTA_SIN[ilong_fin];
					tmpz = a3 * LONG_DELTA[ilong_fin];

					N   += a1 * LONG_DELTA[ilong_fin]		* DVsurV2[iV] 		* SC_POT_CORR_N;

					Vx  += tmpx 					* DVsurV[iV]		* SC_POT_CORR_V;
					Vy  += tmpy 					* DVsurV[iV]		* SC_POT_CORR_V;
					Vz  += tmpz 					* DVsurV[iV]		* SC_POT_CORR_V;

					Qx  += tmpx 					* DVfoisV[iV]		* SC_POT_CORR_Q;
					Qy  += tmpy 					* DVfoisV[iV]		* SC_POT_CORR_Q;
					Qz  += tmpz 					* DVfoisV[iV]		* SC_POT_CORR_Q;

					Pxx += a6 * LONG_DELTA_COS2[ilong_fin]		* DV[iV]		* SC_POT_CORR_P;
					Pxy += a6 * LONG_DELTA_COSSIN[ilong_fin]	* DV[iV]		* SC_POT_CORR_P;
					Pxz += a4 * LONG_DELTA_COS[ilong_fin]		* DV[iV]		* SC_POT_CORR_P;
					Pyy += a6 * LONG_DELTA_SIN2[ilong_fin]		* DV[iV]		* SC_POT_CORR_P;
					Pyz += a4 * LONG_DELTA_SIN[ilong_fin]		* DV[iV]		* SC_POT_CORR_P;
					Pzz += a5 * LONG_DELTA[ilong_fin]		* DV[iV]		* SC_POT_CORR_P;
				
				}

			} else if (ordre_cluster==1) {

				// Exprience avec ordre_cluster==1
				//
				// 	- cluster_codif
				// 	- cluster_hia
				// 	- cluster_peace
				// 	- dsp
				// 	- interball_electron
				// 	- themis_esst
				//	- themis_isst

				if (tabmass[0]<0) {
					pos1 = IMA_POSITION1[indice3(ispin,ienergie,-tabmass[0]-1,nbspins,nbenergies,INUTILE)] + 0.5; if (pos1<0) pos1=0;
					pos2 = IMA_POSITION2[indice3(ispin,ienergie,-tabmass[0]-1,nbspins,nbenergies,INUTILE)] + 0.5; if (pos2>nbmasses-1) pos2=nbmasses-1;
					imasse_deb = pos1;
					imasse_fin = pos2;
				} else {
					imasse_deb = nomasse;
					imasse_fin = nomasse;
				}

				if (is_tablecte) {
					itable = indY[ispin*nbspectres+0]; // spectre 0
					if (itable == -1) continue;
					iV = indice2(itable,ienergie,nbtablesE,nbenergies);
					if (okV[iV]==0) continue;


					// Correction potentiel satellite
					// ------------------------------
					if (Emin[iV] <= -SC_POT_E) continue;
					SC_POT_CORR_N = pow (1 + SC_POT_V2/V2[iV], 0.5);
					SC_POT_CORR_V = pow (1 + SC_POT_V2/V2[iV], 1.0);
					SC_POT_CORR_P = pow (1 + SC_POT_V2/V2[iV], 1.5);
					SC_POT_CORR_Q = pow (1 + SC_POT_V2/V2[iV], 2.0);

				}

				for (longitude=0 ; longitude<nblong ; longitude++) { /* Est - Ouest: spectres */

					ispectre = longitude;
					if (okspectre[ispectre]==0) continue;

					if (!is_tablecte) {

						itable = indY[ispin*nbspectres+ispectre];
						if (itable == -1) continue;
						iV = indice2(itable,ienergie,nbtablesE,nbenergies);
						if (okV[iV]==0) continue;


						// Correction potentiel satellite
						// ------------------------------
						if (Emin[iV] <= -SC_POT_E) continue;
						SC_POT_CORR_N = pow (1 + SC_POT_V2/V2[iV], 0.5);
						SC_POT_CORR_V = pow (1 + SC_POT_V2/V2[iV], 1.0);
						SC_POT_CORR_P = pow (1 + SC_POT_V2/V2[iV], 1.5);
						SC_POT_CORR_Q = pow (1 + SC_POT_V2/V2[iV], 2.0);

					}
	
					a1=a2=a3=a4=a5=a6=0;
					for (latitude=0 ; latitude<nblat ; latitude++) { /* Nord - Sud: cellules */

						icellule = latitude;
						if (tabtheta[icellule]==0) continue;

						ilat_fin = indice2(sensitivity[ispin],latitude,nbsensitivity,INUTILE);

						POLLUTION_ON (); if (pollue) continue;

						for (imasse=imasse_deb ; imasse<=imasse_fin ; imasse++) {
							if (remove_bad_channel) {
								COUP_TO_CJF1_REMOVE_BAD_CHANNEL ();
							} else {
								COUP_TO_CJF1 (cjf);
								if (val < -FILLVAL_E30) continue;
							}
							if (remove_hghost) REMOVE_HGHOST ();
							if (val != 0) {

								if ((fg  = get_fg ) < -FILLVAL_E30) continue; // get_data_moments
								if ((eff = get_eff) < -FILLVAL_E30) continue;
								//if (ispin==0) printf ("ienergie=%d icellule=%d ispectre=%d val=%e eff=%e fg=%e LAT=%e\n",ienergie,icellule,ispectre,val, eff,fg, LAT_DELTA_COS[ilat_fin]);
								val /= eff*0.5*fg;

								/* a1 .. a6 peuvent etre mis a jour uniquement lorsque val est non nul */
								a1 += val * LAT_DELTA_COS[ilat_fin];
								a2 += val * LAT_DELTA_COS2[ilat_fin];
								a3 += val * LAT_DELTA_COSSIN[ilat_fin];
								a4 += val * LAT_DELTA_COS2SIN[ilat_fin]; 
								a5 += val * LAT_DELTA_SIN2COS[ilat_fin];
								a6 += val * LAT_DELTA_COS3[ilat_fin];

							}

						}

					}

					/* Apres la contribution de toutes les latitudes */

					if (use_phi_variable) {
						// Pour MMS_DES_brst_l2, MMS_DIS_brst_l2, JUNO_JADEE: phi dpend de itable et ilong
						ilong_fin = indice2(ispin,ispectre,nbspins,nbspectres);
					} else {
						ilong_fin = indice2(longitude,ienergie,nblong,nbenergies);
					}

					tmpx = a2 * LONG_DELTA_COS[ilong_fin];
					tmpy = a2 * LONG_DELTA_SIN[ilong_fin];
					tmpz = a3 * LONG_DELTA[ilong_fin];

					N   += a1 * LONG_DELTA[ilong_fin]		* DVsurV2[iV] 		* SC_POT_CORR_N;

					Vx  += tmpx 					* DVsurV[iV]		* SC_POT_CORR_V;
					Vy  += tmpy 					* DVsurV[iV]		* SC_POT_CORR_V;
					Vz  += tmpz 					* DVsurV[iV]		* SC_POT_CORR_V;

					Qx  += tmpx 					* DVfoisV[iV]		* SC_POT_CORR_Q;
					Qy  += tmpy 					* DVfoisV[iV]		* SC_POT_CORR_Q;
					Qz  += tmpz 					* DVfoisV[iV]		* SC_POT_CORR_Q;

					Pxx += a6 * LONG_DELTA_COS2[ilong_fin]		* DV[iV]		* SC_POT_CORR_P;
					Pxy += a6 * LONG_DELTA_COSSIN[ilong_fin]	* DV[iV]		* SC_POT_CORR_P;
					Pxz += a4 * LONG_DELTA_COS[ilong_fin]		* DV[iV]		* SC_POT_CORR_P;
					Pyy += a6 * LONG_DELTA_SIN2[ilong_fin]		* DV[iV]		* SC_POT_CORR_P;
					Pyz += a4 * LONG_DELTA_SIN[ilong_fin]		* DV[iV]		* SC_POT_CORR_P;
					Pzz += a5 * LONG_DELTA[ilong_fin]		* DV[iV]		* SC_POT_CORR_P;
				}

			} else if (is_SOLAR_PAS(nocis)) {

				// Exprience solar_pas

				imasse = nomasse;
				itable = 0; // indispensable pour get_eff

				for (ispectre=0 ; ispectre<nbspectres ; ispectre++) { /* Nord - Sud: lvations */

					if (okspectre[ispectre] == 0) continue;

					for (icellule=0 ; icellule<nbcellules ; icellule++) { /* Est - Ouest: azimuths */

						if (tabtheta[icellule] == 0) continue;

						COUP_TO_CJF1(cjf);
						if (val < -FILLVAL_E30) continue;
						if (val != 0) {

							if ((fg  = get_fg ) < -FILLVAL_E30) continue; // get_data_moments
							if ((eff = get_eff) < -FILLVAL_E30) continue;

							val /= eff*0.5*fg;

							ifull = indice3(icellule,ispectre,ienergie,nbcellules,nbspectres,nbenergies);

							if (E_FULL_okV[ifull]==0) continue;


							// Correction potentiel satellite
							// ------------------------------
							if (E_FULL_EMIN[ifull] <= -SC_POT_E) continue;
							SC_POT_CORR_N = pow (1 + SC_POT_V2/E_FULL_V2[ifull], 0.5);
							SC_POT_CORR_V = pow (1 + SC_POT_V2/E_FULL_V2[ifull], 1.0);
							SC_POT_CORR_P = pow (1 + SC_POT_V2/E_FULL_V2[ifull], 1.5);
							SC_POT_CORR_Q = pow (1 + SC_POT_V2/E_FULL_V2[ifull], 2.0);

							/* a1 .. a6 peuvent etre mis a jour uniquement lorsque val est non nul */
							a1 = val * AZ_FULL_DELTA[ifull];
							a2 = val * AZ_FULL_DELTA_COS[ifull];
							a3 = val * AZ_FULL_DELTA_SIN[ifull];
							a4 = val * AZ_FULL_DELTA_COS2[ifull]; 
							a5 = val * AZ_FULL_DELTA_COSSIN[ifull];
							a6 = val * AZ_FULL_DELTA_SIN2[ifull];

							tmpx = a2 * EL_FULL_DELTA_COS2[ifull];
							tmpy = a3 * EL_FULL_DELTA_COS2[ifull];
							tmpz = a1 * EL_FULL_DELTA_COSSIN[ifull];

							N   += a1 * EL_FULL_DELTA_COS[ifull]		* E_FULL_DVsurV2[ifull]	* SC_POT_CORR_N;

							Vx  += tmpx 					* E_FULL_DVsurV[ifull]	* SC_POT_CORR_V;
							Vy  += tmpy 					* E_FULL_DVsurV[ifull]	* SC_POT_CORR_V;
							Vz  += tmpz 					* E_FULL_DVsurV[ifull]	* SC_POT_CORR_V;

							Qx  += tmpx 					* E_FULL_DVfoisV[ifull]	* SC_POT_CORR_Q;
							Qy  += tmpy 					* E_FULL_DVfoisV[ifull]	* SC_POT_CORR_Q;
							Qz  += tmpz 					* E_FULL_DVfoisV[ifull]	* SC_POT_CORR_Q;

							Pxx += a4 * EL_FULL_DELTA_COS3[ifull]		* E_FULL_DV[ifull]	* SC_POT_CORR_P;
							Pxy += a5 * EL_FULL_DELTA_COS3[ifull] 		* E_FULL_DV[ifull]	* SC_POT_CORR_P;
							Pxz += a2 * EL_FULL_DELTA_COS2SIN[ifull]	* E_FULL_DV[ifull]	* SC_POT_CORR_P;
							Pyy += a6 * EL_FULL_DELTA_COS3[ifull]		* E_FULL_DV[ifull]	* SC_POT_CORR_P;
							Pyz += a3 * EL_FULL_DELTA_COS2SIN[ifull]	* E_FULL_DV[ifull]	* SC_POT_CORR_P;
							Pzz += a1 * EL_FULL_DELTA_SIN2COS[ifull]	* E_FULL_DV[ifull]	* SC_POT_CORR_P;

						}

					}

				}

			} else if (ordre_cluster==0) {

				// Exprience avec ordre_cluster==0:
				//
				// 	- aspera3_els
				// 	- aspera3_ima
				// 	- aspera4_els
				//	- aspera4_ima
				//	- stereo_swea
				//	- maven_swea
				//	- solar_pas

				if (tabmass[0]<0) {
					pos1 = IMA_POSITION1[indice3(ispin,ienergie,-tabmass[0]-1,nbspins,nbenergies,INUTILE)] + 0.5; if (pos1<0) pos1=0;
					pos2 = IMA_POSITION2[indice3(ispin,ienergie,-tabmass[0]-1,nbspins,nbenergies,INUTILE)] + 0.5; if (pos2>nbmasses-1) pos2=nbmasses-1;
					imasse_deb = pos1;
					imasse_fin = pos2;
				} else {
					imasse_deb = nomasse;
					imasse_fin = nomasse;
				}

				if (is_tablecte) {
					itable = indY[ispin*nbspectres+0]; // spectre 0
					if (itable == -1) continue;
					iV = indice2(itable,ienergie,nbtablesE,nbenergies);
					if (okV[iV]==0) continue;

					// Correction potentiel satellite
					// ------------------------------
					if (Emin[iV] <= -SC_POT_E) continue;
					SC_POT_CORR_N = pow (1 + SC_POT_V2/V2[iV], 0.5);
					SC_POT_CORR_V = pow (1 + SC_POT_V2/V2[iV], 1.0);
					SC_POT_CORR_P = pow (1 + SC_POT_V2/V2[iV], 1.5);
					SC_POT_CORR_Q = pow (1 + SC_POT_V2/V2[iV], 2.0);
				}

				for (latitude=0 ; latitude<nblat ; latitude++) { /* Nord - Sud: spectres */

					ispectre = latitude;
					if (nblat_extended) ispectre = nolat_extended;
					if (okspectre[ispectre]==0) continue;

					if (!is_tablecte) {
						itable = indY[ispin*nbspectres+ispectre];
						if (itable == -1) continue;
						iV = indice2(itable,ienergie,nbtablesE,nbenergies);
						if (okV[iV]==0) continue;

						// Correction potentiel satellite
						// ------------------------------
						if (Emin[iV] <= -SC_POT_E) continue;
						SC_POT_CORR_N = pow (1 + SC_POT_V2/V2[iV], 0.5);
						SC_POT_CORR_V = pow (1 + SC_POT_V2/V2[iV], 1.0);
						SC_POT_CORR_P = pow (1 + SC_POT_V2/V2[iV], 1.5);
						SC_POT_CORR_Q = pow (1 + SC_POT_V2/V2[iV], 2.0);
					}
	
					a1=a2=a3=a4=a5=a6=0;
					for (longitude=0 ; longitude<nblong ; longitude++) { /* Est - Ouest: cellules */

						icellule = longitude;
						if (tabtheta[icellule]==0) continue;

						POLLUTION_ON (); if (pollue) continue;

						ilong_fin = indice2(longitude,ienergie,nblong,nbenergies);

						for (imasse=imasse_deb ; imasse<=imasse_fin ; imasse++) {
							if (remove_bad_channel) {
								COUP_TO_CJF1_REMOVE_BAD_CHANNEL ();
							} else {
								COUP_TO_CJF1(cjf);
								if (val < -FILLVAL_E30) continue;
							}
							if (remove_hghost) REMOVE_HGHOST ();
							if (val != 0) {

								if ((fg  = get_fg ) < -FILLVAL_E30) continue; // get_data_moments
								if ((eff = get_eff) < -FILLVAL_E30) continue;

								val /= eff*0.5*fg;

								/* a1 .. a6 peuvent etre mis a jour uniquement lorsque val est non nul */
								a1 += val * LONG_DELTA[ilong_fin];
								a2 += val * LONG_DELTA_COS[ilong_fin];
								a3 += val * LONG_DELTA_SIN[ilong_fin];
								a4 += val * LONG_DELTA_COS2[ilong_fin]; 
								a5 += val * LONG_DELTA_COSSIN[ilong_fin];
								a6 += val * LONG_DELTA_SIN2[ilong_fin];

							}

						}

					}

					/* Apres la contribution de toutes les longitudes */

					if (use_phi_variable) {
						// Pour MAVEN-SWEA: introduire ilat_fin qui dpend de itable et ienergie
						ilat_fin = indice3(latitude,ienergie,indP[ispin],nbspectres,nbenergies,nbtablesE);
					} else {
						ilat_fin = indice2(sensitivity[ispin],latitude,nbsensitivity,INUTILE);
					}

					tmpx = a2 * LAT_DELTA_COS2[ilat_fin];
					tmpy = a3 * LAT_DELTA_COS2[ilat_fin];
					tmpz = a1 * LAT_DELTA_COSSIN[ilat_fin];

					N   += a1 * LAT_DELTA_COS[ilat_fin]		* DVsurV2[iV] 		* SC_POT_CORR_N;

					Vx  += tmpx 					* DVsurV[iV]		* SC_POT_CORR_V;
					Vy  += tmpy 					* DVsurV[iV]		* SC_POT_CORR_V;
					Vz  += tmpz 					* DVsurV[iV]		* SC_POT_CORR_V;

					Qx  += tmpx 					* DVfoisV[iV]		* SC_POT_CORR_Q;
					Qy  += tmpy 					* DVfoisV[iV]		* SC_POT_CORR_Q;
					Qz  += tmpz 					* DVfoisV[iV]		* SC_POT_CORR_Q;

					Pxx += a4 * LAT_DELTA_COS3[ilat_fin]		* DV[iV]		* SC_POT_CORR_P;
					Pxy += a5 * LAT_DELTA_COS3[ilat_fin] 		* DV[iV]		* SC_POT_CORR_P;
					Pxz += a2 * LAT_DELTA_COS2SIN[ilat_fin]		* DV[iV]		* SC_POT_CORR_P;
					Pyy += a6 * LAT_DELTA_COS3[ilat_fin]		* DV[iV]		* SC_POT_CORR_P;
					Pyz += a3 * LAT_DELTA_COS2SIN[ilat_fin]		* DV[iV]		* SC_POT_CORR_P;
					Pzz += a1 * LAT_DELTA_SIN2COS[ilat_fin]		* DV[iV]		* SC_POT_CORR_P;

				}

			}

			#ifdef COMPARE_MOMENTS

			// Exprience autre que THEMIS qui marche dans tous les cas

			if (tabmass[0]<0) {
				pos1 = IMA_POSITION1[indice3(ispin,ienergie,-tabmass[0]-1,nbspins,nbenergies,INUTILE)] + 0.5; if (pos1<0) pos1=0;
				pos2 = IMA_POSITION2[indice3(ispin,ienergie,-tabmass[0]-1,nbspins,nbenergies,INUTILE)] + 0.5; if (pos2>nbmasses-1) pos2=nbmasses-1;
				imasse_deb = pos1;
				imasse_fin = pos2;
			} else {
				imasse_deb = nomasse;
				imasse_fin = nomasse;
			}

			for (longitude=0 ; longitude<nblong ; longitude++) { /* Est - Ouest */

				if (ordre_cluster==1) {
					ispectre = longitude;
					if (okspectre[ispectre]==0) continue;
					itable = indY[ispin*nbspectres+ispectre];
				} else {
					icellule = longitude;
					if (tabtheta[icellule]==0) continue;
					itable = indY[ispin*nbspectres+0]; /* On prend la table pour le permier spectre afin de connaitre iV maintenant */
				}
				if (itable == -1) continue;
				iV = indice2(itable,ienergie,nbtablesE,nbenergies);
				if (okV[iV]==0) continue;


				// Correction potentiel satellite
				// ------------------------------
				if (Emin[iV] <= -SC_POT_E) continue;
				SC_POT_CORR_N = pow (1 + SC_POT_V2/V2[iV], 0.5);
				SC_POT_CORR_V = pow (1 + SC_POT_V2/V2[iV], 1.0);
				SC_POT_CORR_P = pow (1 + SC_POT_V2/V2[iV], 1.5);
				SC_POT_CORR_Q = pow (1 + SC_POT_V2/V2[iV], 2.0);
	
				a1=a2=a3=a4=a5=a6=0;
				for (latitude=0 ; latitude<nblat ; latitude++) { /* Nord - Sud */

					if (use_phi_variable) {
						// Pour MAVEN-SWEA: introduire ilat_fin qui dpend de itable et ienergie
						ilat_fin = indice3(latitude,ienergie,indP[ispin],nbspectres,nbenergies,nbtablesE);
					} else {
						ilat_fin = indice2(sensitivity[ispin],latitude,nbsensitivity,INUTILE);
					}

					if (ordre_cluster==1) {
						icellule = latitude;
						if (tabtheta[icellule]==0) continue;
					} else {
						ispectre = latitude;
						if (nblat_extended) ispectre = nolat_extended;
						if (okspectre[ispectre]==0) continue;
					}

					POLLUTION_ON (); if (pollue) continue;

					for (imasse=imasse_deb ; imasse<=imasse_fin ; imasse++) {
						if (remove_bad_channel) {
							COUP_TO_CJF1_REMOVE_BAD_CHANNEL ();
						} else {
							COUP_TO_CJF1(cjf);
							if (val < -FILLVAL_E30) continue;
						}
						if (remove_hghost) REMOVE_HGHOST ();
						if (val != 0) {

							if ((fg  = get_fg ) < -FILLVAL_E30) continue; // get_data_moments
							if ((eff = get_eff) < -FILLVAL_E30) continue;

							val /= eff*0.5*fg;

							/* a1 .. a6 peuvent etre mis a jour uniquement lorsque val est non nul */
							a1 += val * LAT_DELTA_COS[ilat_fin];
							a2 += val * LAT_DELTA_COS2[ilat_fin];
							a3 += val * LAT_DELTA_COSSIN[ilat_fin];
							a4 += val * LAT_DELTA_COS2SIN[ilat_fin]; 
							a5 += val * LAT_DELTA_SIN2COS[ilat_fin];
							a6 += val * LAT_DELTA_COS3[ilat_fin];

						}

					}

				}


				/* Apres la contribution de toutes les latitudes */

				ilong_fin = indice2(longitude,ienergie,nblong,nbenergies);

				tmpx = a2 * LONG_DELTA_COS[ilong_fin];
				tmpy = a2 * LONG_DELTA_SIN[ilong_fin];
				tmpz = a3 * LONG_DELTA[ilong_fin];

				N_old   += a1 * LONG_DELTA[ilong_fin]		* DVsurV2[iV] 		* SC_POT_CORR_N;

				Vx_old  += tmpx 				* DVsurV[iV]		* SC_POT_CORR_V;
				Vy_old  += tmpy 				* DVsurV[iV]		* SC_POT_CORR_V;
				Vz_old  += tmpz 				* DVsurV[iV]		* SC_POT_CORR_V;

				Qx_old  += tmpx 				* DVfoisV[iV]		* SC_POT_CORR_Q;
				Qy_old  += tmpy 				* DVfoisV[iV]		* SC_POT_CORR_Q;
				Qz_old  += tmpz 				* DVfoisV[iV]		* SC_POT_CORR_Q;

				Pxx_old += a6*LONG_DELTA_COS2[ilong_fin]   	* DV[iV]		* SC_POT_CORR_P;
				Pxy_old += a6*LONG_DELTA_COSSIN[ilong_fin] 	* DV[iV]		* SC_POT_CORR_P;
				Pxz_old += a4*LONG_DELTA_COS[ilong_fin]    	* DV[iV]		* SC_POT_CORR_P;
				Pyy_old += a6*LONG_DELTA_SIN2[ilong_fin]   	* DV[iV]		* SC_POT_CORR_P;
				Pyz_old += a4*LONG_DELTA_SIN[ilong_fin]    	* DV[iV]		* SC_POT_CORR_P;
				Pzz_old += a5*LONG_DELTA[ilong_fin] 		* DV[iV]		* SC_POT_CORR_P;

			}
			#endif
				
			if (use_sampling==1) {
				cjf = FDIST;	/* fonction de distribution */
				imasse = nomasse;
				for (icellule=0 ; icellule<nbcellules ; icellule++) {
					for (ispectre=0 ; ispectre<nbspectres ; ispectre++) {
						tab_fdist[indice2(icellule,ispectre,nbcellules,nbspectres)]=0;
						if ((fg  = get_fg ) < -FILLVAL_E30) continue; // get_data_moments
						if ((eff = get_eff) < -FILLVAL_E30) continue;
						COUP_TO_CJF1 (cjf);
						if (val < -FILLVAL_E30) continue;
						tab_fdist[indice2(icellule,ispectre,nbcellules,nbspectres)]=val;
					}
				}

				compute_quality(nbenergies, nbcellules, nbspectres, LocalVx, LocalVy, LocalVz, tab_fdist, ienergie, sampling, &SamplFactor, &QualN);

				cjf = COUNT_SEC;	/* 2 pour avoir des coups/sec non corriges par eff */

			}

		}

		#ifdef COMPARE_MOMENTS
		if (fabs(N-N_old)>fabs(N)*0.01)			{ printf ("AIE N   old=%15.3e new=%15.3e\n",N_old,N); 		exit(-1);}
		if (fabs(Vx-Vx_old)>fabs(Vx)*0.01)		{ printf ("AIE Vx  old=%15.3e new=%15.3e\n",Vx_old,Vx); 	exit(-1);}
		if (fabs(Vy-Vy_old)>fabs(Vy)*0.01)		{ printf ("AIE Vy  old=%15.3e new=%15.3e\n",Vy_old,Vy); 	exit(-1);}
		if (fabs(Vz-Vz_old)>fabs(Vz)*0.01)		{ printf ("AIE Vz  old=%15.3e new=%15.3e\n",Vz_old,Vz); 	exit(-1);}
		if (fabs(Qx-Qx_old)>fabs(Qx)*0.01)		{ printf ("AIE Qx  old=%15.3e new=%15.3e\n",Qx_old,Qx); 	exit(-1);}
		if (fabs(Qy-Qy_old)>fabs(Qy)*0.01)		{ printf ("AIE Qy  old=%15.3e new=%15.3e\n",Qy_old,Qy); 	exit(-1);}
		if (fabs(Qz-Qz_old)>fabs(Qz)*0.01)		{ printf ("AIE Qz  old=%15.3e new=%15.3e\n",Qz_old,Qz); 	exit(-1);}
		if (fabs(Pxx-Pxx_old)>fabs(Pxx)*0.01)		{ printf ("AIE Pxx old=%15.3e new=%15.3e\n",Pxx_old,Pxx); 	exit(-1);}
		if (fabs(Pxy-Pxy_old)>fabs(Pxy)*0.01)		{ printf ("AIE Pxy old=%15.3e new=%15.3e\n",Pxy_old,Pxy); 	exit(-1);}
		if (fabs(Pxz-Pxz_old)>fabs(Pxz)*0.01)		{ printf ("AIE Pxz old=%15.3e new=%15.3e\n",Pxz_old,Pxz); 	exit(-1);}
		if (fabs(Pyy-Pyy_old)>fabs(Pyy)*0.01)		{ printf ("AIE Pyy old=%15.3e new=%15.3e\n",Pyy_old,Pyy); 	exit(-1);}
		if (fabs(Pyz-Pyz_old)>fabs(Pyz)*0.01)		{ printf ("AIE Pyz old=%15.3e new=%15.3e\n",Pyz_old,Pyz); 	exit(-1);}
		if (fabs(Pzz-Pzz_old)>fabs(Pzz)*0.01)		{ printf ("AIE Pzz old=%15.3e new=%15.3e\n",Pzz_old,Pzz); 	exit(-1);}
#ifdef xxx
		N = N_old;
		Vx = Vx_old;
		Vy = Vy_old;
		Vz = Vz_old;
		Qx = Qx_old;
		Qy = Qy_old;
		Qz = Qz_old;
		Pxx = Pxx_old;
		Pxy = Pxy_old;
		Pxz = Pxy_old;
		Pyy = Pyy_old;
		Pyz = Pyz_old;
		Pzz = Pzz_old;
#endif
		#endif



		Z[i_Quality] = (use_sampling==1) ? (QualN==0 ? 0.0 : SamplFactor / QualN) : 1.0;
	
		Z[i_N_cm3] = N/1e6;

		//Pour dtecter des densits ngatives
		//#define CHECK_DENSITE_NEGATIVE

		#ifdef CHECK_DENSITE_NEGATIVE
		if (N < 0) {
			printf ("N=%f\n",N);
			exit(0);
		}
		#endif

		if (N!=0) {
			Z[i_Vx_km_sec] = Vx/(Z[i_N_cm3]*1e6)/1e3;
			Z[i_Vy_km_sec] = Vy/(Z[i_N_cm3]*1e6)/1e3;
			Z[i_Vz_km_sec] = Vz/(Z[i_N_cm3]*1e6)/1e3;
			Z[i_V_km_sec]  = module (Z[i_Vx_km_sec],Z[i_Vy_km_sec],Z[i_Vz_km_sec]);
		} else {
			Z[i_Vx_km_sec] = FILLVAL;
			Z[i_Vy_km_sec] = FILLVAL;
			Z[i_Vy_km_sec] = FILLVAL;
			Z[i_V_km_sec]  = FILLVAL;
		}

		Z[i_Pxx_eV_cm3] = Pxx*MASSE[nomasse]*1e-6/ELECTRONVOLT;
		Z[i_Pxy_eV_cm3] = Pxy*MASSE[nomasse]*1e-6/ELECTRONVOLT;
		Z[i_Pxz_eV_cm3] = Pxz*MASSE[nomasse]*1e-6/ELECTRONVOLT;
		Z[i_Pyy_eV_cm3] = Pyy*MASSE[nomasse]*1e-6/ELECTRONVOLT;
		Z[i_Pyz_eV_cm3] = Pyz*MASSE[nomasse]*1e-6/ELECTRONVOLT;
		Z[i_Pzz_eV_cm3] = Pzz*MASSE[nomasse]*1e-6/ELECTRONVOLT;


		// use_VxVyVz==1 uniquement pour STEREO-SWEA et MAVEN-SWEA use_VxVyVz.
		// C'est pour ne pas utiliser la vitesse que l'on vient de calculer mais une vitesse qui est plus juste
		// Cad vitesse de PLASTIC pour STEREO-SWEA et vitesse de SWIA pour MAVEN-SWEA
		if (use_VxVyVz==1) {
			Vext_km_sec[0] = Vxext_km_sec[ispin];
			Vext_km_sec[1] = Vyext_km_sec[ispin];
			Vext_km_sec[2] = Vzext_km_sec[ispin];
		}
		Vx_km_sec = use_VxVyVz==1 ? Vext_km_sec[nox]				: Z[i_Vx_km_sec];
		Vy_km_sec = use_VxVyVz==1 ? Vext_km_sec[noy]				: Z[i_Vy_km_sec];
		Vz_km_sec = use_VxVyVz==1 ? Vext_km_sec[noz]				: Z[i_Vz_km_sec];
		V_km_sec  = use_VxVyVz==1 ? module (Vx_km_sec,Vy_km_sec,Vz_km_sec)	: Z[i_V_km_sec];

		/* Peut provoquer des Floating underflow ex: -6.465424e-39 qui est plus petit que -1.18e-38, le plus petit float sur 32 bits */
		/* Modif 04/03/2009: rajout du facteur 1e3 que j'avais oubli. Erreur dtecte lors du calcul de Q de Stereo en utilisant la vitesse de Plastic */
		Z[i_Qx_erg_sec_cm2] = 0.5*MASSE[nomasse]*1e3*Qx;
		Z[i_Qy_erg_sec_cm2] = 0.5*MASSE[nomasse]*1e3*Qy;
		Z[i_Qz_erg_sec_cm2] = 0.5*MASSE[nomasse]*1e3*Qz;

		/* Peut provoquer des Floating underflow (ex: CLUSTER COFIF o1 SC3 15 dec 2000 16h53  16h57) */
		/* Avril 2019: enlever N*M*V*V au tenseur de pression avant de calculer le flux de chaleur */
		Z[i_Pxx_eV_cm3] -= (Z[i_N_cm3])*MASSE[nomasse]*(Vx_km_sec*1e3)*(Vx_km_sec*1e3)/ELECTRONVOLT;
		Z[i_Pxy_eV_cm3] -= (Z[i_N_cm3])*MASSE[nomasse]*(Vx_km_sec*1e3)*(Vy_km_sec*1e3)/ELECTRONVOLT;
		Z[i_Pxz_eV_cm3] -= (Z[i_N_cm3])*MASSE[nomasse]*(Vx_km_sec*1e3)*(Vz_km_sec*1e3)/ELECTRONVOLT;
		Z[i_Pyy_eV_cm3] -= (Z[i_N_cm3])*MASSE[nomasse]*(Vy_km_sec*1e3)*(Vy_km_sec*1e3)/ELECTRONVOLT;
		Z[i_Pyz_eV_cm3] -= (Z[i_N_cm3])*MASSE[nomasse]*(Vy_km_sec*1e3)*(Vz_km_sec*1e3)/ELECTRONVOLT;
		Z[i_Pzz_eV_cm3] -= (Z[i_N_cm3])*MASSE[nomasse]*(Vz_km_sec*1e3)*(Vz_km_sec*1e3)/ELECTRONVOLT;

		// Unit tenseur de pression
		// -------------------------
		// JUNO JADEI: Rob Wilson l'exprime en kg/(m.s2)
		// Je l'exprime en eV/cm3
		// 1 eV = 1.602176565 * 1e-19 J
		// 1 J = 1kg m2 / s2
		// => 1 eV / cm3 = 1.602176565 * 1e-19 * kg * m2 / (cm3 * s2) = 1.602176565 * 1e-19 * kg * m2 / (1e-6 m3 . s2) = 1.602176565 * 1e-13 kg / (m.s2)
		//
		// MMS DES: exprim en nPa
		// Je l'exprime en eV/cm3
		// 1ev = 1.6 e-19 J
		// 1Pa = 1J / m3
		// => 1 eV / cm3 = 1.6e-19 J / cm3 = 1.6e-19 J / (1e-6 m3) = 1.6e-13 P = 1.6e-13*1e9 nPa = 1.6e-4 nPa

		// Unit flux de chaleur
		// ---------------------
		// JUNO JADEI: Rob Wilson l'exprime en kg/(m.s2)*m/s = kg / s3
		// Je l'exprime en erg / (s . cm2) = g . cm2 / (s3 . cm2) = g / s3
		// (1 erg = 1 g . cm2 / s2)
		// => 1 erg / ( s . cm2) = 1e-3 kg / s3
		//
		// MMS MDE: exprim en mW/m2
		// Je l'exprime en erg / (s . cm2) = g . cm2 / (s3 . cm2) = g / s3
		// 1 W = 1e7 erg / s
		// => 1 mW / m2 = 1e-3 W / m2 = 1e-3 * 1e7 erg /(s . m2) = 1e4 erg / (s . 1e4 . cm2) = 1 erg / (s . cm2)

		trace_eV_cm3 = Z[i_Pxx_eV_cm3] + Z[i_Pyy_eV_cm3] + Z[i_Pzz_eV_cm3];

		// 1e3*1e2 pour passer de km/sec en cm/sec
		// 1 erg = 1e-7 joule
		// 1e-4 pour passer de erg/(m2.sec) en erg/(cm2.sec)
		Z[i_Qx_erg_sec_cm2]  += - 0.5*(Vx_km_sec*1e3*1e2)*(trace_eV_cm3*   ELECTRONVOLT*1e7)
					-     (Vx_km_sec*1e3*1e2)*(Z[i_Pxx_eV_cm3]*ELECTRONVOLT*1e7)
					-     (Vy_km_sec*1e3*1e2)*(Z[i_Pxy_eV_cm3]*ELECTRONVOLT*1e7)
					-     (Vz_km_sec*1e3*1e2)*(Z[i_Pxz_eV_cm3]*ELECTRONVOLT*1e7)
					- 0.5*(Z[i_N_cm3]*1e6)*MASSE[nomasse]*(Vx_km_sec*1e3)*(V_km_sec*1e3)*(V_km_sec*1e3)*1e7*1e-4;

		Z[i_Qy_erg_sec_cm2]  += - 0.5*(Vy_km_sec*1e3*1e2)*(trace_eV_cm3*   ELECTRONVOLT*1e7)
					-     (Vx_km_sec*1e3*1e2)*(Z[i_Pxy_eV_cm3]*ELECTRONVOLT*1e7)
					-     (Vy_km_sec*1e3*1e2)*(Z[i_Pyy_eV_cm3]*ELECTRONVOLT*1e7)
					-     (Vz_km_sec*1e3*1e2)*(Z[i_Pyz_eV_cm3]*ELECTRONVOLT*1e7)
					- 0.5*(Z[i_N_cm3]*1e6)*MASSE[nomasse]*(Vy_km_sec*1e3)*(V_km_sec*1e3)*(V_km_sec*1e3)*1e7*1e-4;

		Z[i_Qz_erg_sec_cm2]  += - 0.5*(Vz_km_sec*1e3*1e2)*(trace_eV_cm3*   ELECTRONVOLT*1e7)
					-     (Vx_km_sec*1e3*1e2)*(Z[i_Pxz_eV_cm3]*ELECTRONVOLT*1e7)
					-     (Vy_km_sec*1e3*1e2)*(Z[i_Pyz_eV_cm3]*ELECTRONVOLT*1e7)
					-     (Vz_km_sec*1e3*1e2)*(Z[i_Pzz_eV_cm3]*ELECTRONVOLT*1e7)
					- 0.5*(Z[i_N_cm3]*1e6)*MASSE[nomasse]*(Vz_km_sec*1e3)*(V_km_sec*1e3)*(V_km_sec*1e3)*1e7*1e-4;

		/* Modif du 30/09/02: George Parks pense que les signes du flux de chaleur, calcules a partir des 
			3D, sont probablement inverses: le flux de chaleur doit etre oriente dans 
			le meme sens que la vitesse.
			Donc, j'inverse le sens des 3 composantes. */
		/* Modif du 04/03/2009: Depuis que j'ai rajout le facteur 1e3, il n'y a plus de raison de changer le signe des composantes */

		Z[i_Q_erg_sec_cm2]  = module (Z[i_Qx_erg_sec_cm2],Z[i_Qy_erg_sec_cm2],Z[i_Qz_erg_sec_cm2]);

		diagonaliser (Z[i_Pxx_eV_cm3], Z[i_Pxy_eV_cm3], Z[i_Pxz_eV_cm3], 
				Z[i_Pyy_eV_cm3], Z[i_Pyz_eV_cm3], Z[i_Pzz_eV_cm3],
				FILLVAL, &Ppar,&Pper1,&Pper2,&Ex,&Ey,&Ez,&EV1x,&EV1y,&EV1z,&EV2x,&EV2y,&EV2z,&EV3x,&EV3y,&EV3z);
		Z[i_Ppar_eV_cm3]  = Ppar;
		Z[i_Pper1_eV_cm3] = Pper1;
		Z[i_Pper2_eV_cm3] = Pper2;

		Z[i_Ex] = Ex;
		Z[i_Ey] = Ey;
		Z[i_Ez] = Ez;

		Z[i_EV1x] = EV1x;
		Z[i_EV1y] = EV1y;
		Z[i_EV1z] = EV1z;

		Z[i_EV2x] = EV2x;
		Z[i_EV2y] = EV2y;
		Z[i_EV2z] = EV2z;

		Z[i_EV3x] = EV3x;
		Z[i_EV3y] = EV3y;
		Z[i_EV3z] = EV3z;

		if (Ppar!=FILLVAL && N!=0) {
			Z[i_Tpar_eV]  = Z[i_Ppar_eV_cm3]/Z[i_N_cm3];
			Z[i_Tper1_eV] = Z[i_Pper1_eV_cm3]/Z[i_N_cm3];
			Z[i_Tper2_eV] = Z[i_Pper2_eV_cm3]/Z[i_N_cm3];
		} else {
			Z[i_Tpar_eV]  = FILLVAL;
			Z[i_Tper1_eV] = FILLVAL;
			Z[i_Tper2_eV] = FILLVAL;
		}

		Z[i_Ei_eV_cm3] = 0.5*(Z[i_Pxx_eV_cm3]+Z[i_Pyy_eV_cm3]+Z[i_Pzz_eV_cm3]);
		if (N != 0) {
			Z[i_Ti_eV] = (Z[i_Pxx_eV_cm3]+Z[i_Pyy_eV_cm3]+Z[i_Pzz_eV_cm3])/3./Z[i_N_cm3];
		} else {
			Z[i_Ti_eV] = FILLVAL;
		}

		Z[i_Pp_nPa] = (Z[i_Pxx_eV_cm3]+Z[i_Pyy_eV_cm3]+Z[i_Pzz_eV_cm3])*1.6E-19*1E6/3*1E9;

	}

	free (LAT_DELTA);
	free (LAT_DELTA_COS);
	free (LAT_DELTA_COS2);
	free (LAT_DELTA_COSSIN);
	free (LAT_DELTA_COS2SIN);
	free (LAT_DELTA_SIN2COS);
	free (LAT_DELTA_COS3);

	free (EL_FULL_DELTA);
	free (EL_FULL_DELTA_COS);
	free (EL_FULL_DELTA_COS2);
	free (EL_FULL_DELTA_COSSIN);
	free (EL_FULL_DELTA_COS2SIN);
	free (EL_FULL_DELTA_SIN2COS);
	free (EL_FULL_DELTA_COS3);

	free (LONG_DELTA);
	free (LONG_DELTA_COS);
	free (LONG_DELTA_SIN);
	free (LONG_DELTA_COS2);
	free (LONG_DELTA_COSSIN);
	free (LONG_DELTA_SIN2);

	free (AZ_FULL_DELTA);
	free (AZ_FULL_DELTA_COS);
	free (AZ_FULL_DELTA_SIN);
	free (AZ_FULL_DELTA_COS2);
	free (AZ_FULL_DELTA_COSSIN);
	free (AZ_FULL_DELTA_SIN2);

	free (DV);
	free (V2);
	free (DVsurV2);
	free (DVsurV);
	free (DVfoisV);
	free (okV);

	free (E_FULL_EMIN);
	free (E_FULL_DV);
	free (E_FULL_V2);
	free (E_FULL_DVsurV2);
	free (E_FULL_DVsurV);
	free (E_FULL_DVfoisV);
	free (E_FULL_okV);

	FIN ();
	MAVEN_SWEA_CALIB_FIN();

	if (optimise) free (channelok);
	if (optimise) free (p2);

	free (memorise_CJF1);

	if (LocalVx   != NULL) free(LocalVx);
	if (LocalVy   != NULL) free(LocalVy);
	if (LocalVz   != NULL) free(LocalVz);
	if (tab_fdist != NULL) free(tab_fdist);

	*erreur=0;

}

/*---------------------------------------------------------------------------*/
void GET_DATA_MOMENTS_AUTO_GLUE (
/*---------------------------------------------------------------------------*/
	void	*p01,
	void	*p02,
	void	*p03,
	void	*p04,
	void	*p05,
	void	*p06,
	void	*p07,
	void	*p08,
	void	*p09,
	void	*p10,
	void	*p11,
	void	*p12,
	void	*p13,
	void	*p14,
	void	*p15,
	void	*p16,
	void	*p17,
	void	*p18,
	void	*p19,
	void	*p20,
	void	*p21,
	void	*p22,
	void	*p23,
	void	*p24,
	void	*p25,
	void	*p26,
	void	*p27,
	void	*p28,
	void	*p29,
	void	*p30,
	void	*p31,
	void	*p32,
	void	*p33,
	void	*p34,
	void	*p35,
	void	*p36,
	void	*p37,
	void	*p38,
	void	*p39,
	void	*p40,
	void	*p41,
	void	*p42,
	void	*p43,
	void	*p44,
	void	*p45,
	void	*p46,
	void	*p47,
	void	*p48,
	void	*p49,
	void	*p50,
	void	*p51,
	void	*p52,
	void	*p53,
	void	*p54,
	void	*p55,
	void	*p56,
	void	*p57,
	void	*p58,
	void	*p59,
	void	*p60,
	void	*p61,
	void	*p62,
	void	*p63,
	void	*p64,
	void	*p65,
	void	*p66,
	void	*p67,
	void	*p68,
	void	*p69,
	void	*p70,
	void	*p71,
	void	*p72,
	void	*p73,
	void	*p74,
	void	*p75,
	void	*p76,
	void	*p77,
	void	*p_CL_ROOT) {

	int		argc=78;
	void		*argv[78];
	IDL_STRING	*CL_ROOT;

	// p_CL_ROOT -> CL_ROOT
	CL_ROOT = malloc (sizeof(IDL_STRING));
	IDL_StrStore (CL_ROOT, p_CL_ROOT);

	argv[ 0] = p01;
	argv[ 1] = p02;
	argv[ 2] = p03;
	argv[ 3] = p04;
	argv[ 4] = p05;
	argv[ 5] = p06;
	argv[ 6] = p07;
	argv[ 7] = p08;
	argv[ 8] = p09;
	argv[ 9] = p10;
	argv[10] = p11;
	argv[11] = p12;
	argv[12] = p13;
	argv[13] = p14;
	argv[14] = p15;
	argv[15] = p16;
	argv[16] = p17;
	argv[17] = p18;
	argv[18] = p19;
	argv[19] = p20;
	argv[20] = p21;
	argv[21] = p22;
	argv[22] = p23;
	argv[23] = p24;
	argv[24] = p25;
	argv[25] = p26;
	argv[26] = p27;
	argv[27] = p28;
	argv[28] = p29;
	argv[29] = p30;
	argv[30] = p31;
	argv[31] = p32;
	argv[32] = p33;
	argv[33] = p34;
	argv[34] = p35;
	argv[35] = p36;
	argv[36] = p37;
	argv[37] = p38;
	argv[38] = p39;
	argv[39] = p40;
	argv[40] = p41;
	argv[41] = p42;
	argv[42] = p43;
	argv[43] = p44;
	argv[44] = p45;
	argv[45] = p46;
	argv[46] = p47;
	argv[47] = p48;
	argv[48] = p49;
	argv[49] = p50;
	argv[50] = p51;
	argv[51] = p52;
	argv[52] = p53;
	argv[53] = p54;
	argv[54] = p55;
	argv[55] = p56;
	argv[56] = p57;
	argv[57] = p58;
	argv[58] = p59;
	argv[59] = p60;
	argv[60] = p61;
	argv[61] = p62;
	argv[62] = p63;
	argv[63] = p64;
	argv[64] = p65;
	argv[65] = p66;
	argv[66] = p67;
	argv[67] = p68;
	argv[68] = p69;
	argv[69] = p70;
	argv[70] = p71;
	argv[71] = p72;
	argv[72] = p73;
	argv[73] = p74;
	argv[74] = p75;
	argv[75] = p76;
	argv[76] = p77;
	argv[77] = CL_ROOT;
	GET_DATA_MOMENTS (argc, argv);

	free (CL_ROOT);

}


/*---------------------------------------------------------------------------*/
void GET_DATA_TIME_ENERGY_CJF (int argc, void *argv[]) {
/*---------------------------------------------------------------------------*/

	/*	
			Utilise dans les	spectros time_energy
						courbes energy_cjf et time_cjf
	*/

	int		nbarg				= 0;
	short		*sensitivity			= (short *)		argv[nbarg++]; /* sensitivity[nbspins] */
	short		*produit1			= (short *)		argv[nbarg++]; /* produit1[nbspins] */
	int		*tab1ienergy			= (int *)		argv[nbarg++]; /* tab1ienergy[nbspins] */
	int		*tab2ienergy			= (int *)		argv[nbarg++]; /* tab2ienergy[nbspins] */
	short		*mag				= (short *)		argv[nbarg++]; /* mag[nbspins] */
	int		*region_ok			= (int *)		argv[nbarg++]; /* region_ok[nbspins] */
	short		*cis_mode			= (short *)		argv[nbarg++]; /* cis_mode[nbspins] */
	int		*start				= (int *)		argv[nbarg++]; /* start[nbspins] */
	int		*solid				= (int *)		argv[nbarg++]; /* solid[nbspectres,nbcellules] */
	double		*deadtime			= (double *)		argv[nbarg++]; /* deadtime[2] */
	int		*sectorold			= (int *)		argv[nbarg++]; /* sectorold[nbspectres,nbcellules] */
	float		*duree_comptage			= (float *)		argv[nbarg++]; /* duree_comptage[nbspins] */ 
	int		*nb_accumulation		= (int *)		argv[nbarg++]; /* nb_accumulation[nbspins] */
	int		*tabtheta			= (int *)		argv[nbarg++]; /* tabtheta[nbcellules] */
	int		*tabphi				= (int *)		argv[nbarg++]; /* tabphi[nbspectres] */
	int		*tabmass			= (int *)		argv[nbarg++]; /* tabmass[nbmasses] */
	int		*indY				= (int *)		argv[nbarg++]; /* si spin_average=	1 alors indY[nbspins]
															0       indY[nbspins*nbspectres] */
	int		*indC				= (int *)		argv[nbarg++]; /* indC[nbspins] */
	float		*Emin				= (float *)		argv[nbarg++]; /* Emin[nbtablesE,nbenergies] */
	float		*Emoy				= (float *)		argv[nbarg++]; /* Emoy[nbtablesE,nbenergies] */
	float		*Emax				= (float *)		argv[nbarg++]; /* Emax[nbtablesE,nbenergies] */
	double		*efficacite			= (double *)		argv[nbarg++]; /* efficacite[] */
	double		*facteurG			= (double *)		argv[nbarg++]; /* facteurG[] */
	char		*tabdata			= (char *)		argv[nbarg++];
	int		no1				= *(int *)		argv[nbarg++];
	int		*debut				= (int *)		argv[nbarg++];
	int		*fin				= (int *)		argv[nbarg++];
	float		*dico				= (float *)		argv[nbarg++];
	int		nbytes				= *(int *)		argv[nbarg++];
	float		*Z				= (float *)		argv[nbarg++]; /* si spin_average=	1 alors Z[nbspins,nbenergies] 
															0       Z[nbspins*nbspectres,nbenergies]*/
	int		*sectornew			= (int *)		argv[nbarg++]; /* sectornew[nbspectres,nbcellules] */
	double		sectornew_date			= *(double *)		argv[nbarg++];
	double		*xmin				= (double *)		argv[nbarg++]; /* xmin[nbspins] = datation de chaque spin */
	float		*Q				= (float *)		argv[nbarg++]; /* Q[nbmasses] */
	double		*MASSE				= (double *)		argv[nbarg++]; /* MASSE[nbmasses] */
	int		*start_pollution_solaire	= (int *)		argv[nbarg++]; /* start_pollution_solaire[nbspins] */
	int		*end_pollution_solaire		= (int *)		argv[nbarg++]; /* end_pollution_solaire[nbspins] */
	unsigned int	*sector_mask			= (unsigned int *)	argv[nbarg++]; /* sector_mask[nbspins] */
	float		*max_val			= (float *)		argv[nbarg++]; /* max_val[nbspins] */
	float		*max_energie			= (float *)		argv[nbarg++]; /* max_energie[nbspins] */
	float		*max_theta			= (float *)		argv[nbarg++]; /* max_theta[nbspins] */
	float		*max_phi			= (float *)		argv[nbarg++]; /* max_phi[nbspins] */
	int		tof_phd				= *(int *)		argv[nbarg++]; /* Ne sert que pour ASPERA-NPD 1: TOF, 2: PHD */
	short		noproduit			= *(short *)		argv[nbarg++];
	int		infos_on			= *(int *)		argv[nbarg++];
	size_t		*dataquick			= (size_t *)		argv[nbarg++];
	float		*IMA_NOISE			= (float *)		argv[nbarg++]; /* IMA_NOISE[nbenergies,nbmasses] */
	float		*IMA_MASS_MULT			= (float *)		argv[nbarg++]; /* IMA_MASS_MULT[nbmasses] */
	float		*IMA_POSITION1			= (float *)		argv[nbarg++]; /* IMA_POSITION1[nbspins,nbenergies,10] */
	float		*IMA_POSITION2			= (float *)		argv[nbarg++]; /* IMA_POSITION2[nbspins,nbenergies,10] */
	unsigned char	*IMA_PAC			= (unsigned char *)	argv[nbarg++]; /* IMA_PAC[nbspins] */
	unsigned char	*MEA_GEOMFACTOR			= (unsigned char *)	argv[nbarg++]; /* MEA_GEOMFACTOR[nbspins] */
	unsigned char	*MEA_DATAID			= (unsigned char *)	argv[nbarg++]; /* MEA_DATAID[nbspins] */
	int		nbX				= *(int *)		argv[nbarg++];
	int		nbY				= *(int *)		argv[nbarg++];
	int		*TABINFO_INT			= (int *)		argv[nbarg++];
	double		*TABINFO_DOUBLE			= (double *)		argv[nbarg++];
	int		USEBIGZ				= *(int *)		argv[nbarg++];
	float		*BIGZ				= (float *)		argv[nbarg++]; /* BIGZ[nbspins,nbmasses,nbcellules,nbspectres,nbenergies] */
	float		*DEMETER_TAB_FULLNRJRATIO_IDP	= (float *)		argv[nbarg++]; /* DEMETER_TAB_FULLNRJRATIO_IDP[255] */
	float		*DEMETER_TAB_FULLNRJCOUNT_IDP	= (float *)		argv[nbarg++]; /* DEMETER_TAB_FULLNRJCOUNT_IDP[255] */
	float		*DEMETER_HISTO_PER_ENERGY_SPEC	= (float *)		argv[nbarg++]; /* DEMETER_HISTO_PER_ENERGY_SPEC[256,255] */
	float		*DEMETER_TABLE_DEMETER		= (float *)		argv[nbarg++]; /* DEMETER_TABLE_DEMETER[nbenergies] */
	float		*DEMETER_TABLE_TARANIS		= (float *)		argv[nbarg++]; /* DEMETER_TABLE_TARANIS[nbenergies] */
	short		*start_energy			= (short *)		argv[nbarg++]; /* start_energy[nbspins] */
	short		*end_energy			= (short *)		argv[nbarg++]; /* end_energy[nbspins] */
	IDL_STRING	*CL_ROOT			= (IDL_STRING *)	argv[nbarg++];

	/* remove bad channel pour ASPERA3:
		- pour imasse=0: suppression des coups
		- pour imasse=4,10,22: coup = (coup[imasse-1] + coup[imasse+1])/2
	*/

	/*
		Si tabmass[0] est negatif, cela signifie qu'il faut rechercher la masse suivante:
			-1:  H+
			-2:  He++
			-3:  He+
			-4:  O++
			-5:  O+
			-6:  CO+
			-7:  O2+
			-8:  CO2+
			-9:  Heavy
			-10: All
		Pour l'ion no, utiliser les masses de IMA_POSITION1[spin,energie,no]  IMA_POSITION2[spin,energie,no]
	*/


	/* 
		start [i]         = start [i] 
		solid [i,j]       = solid  [i + j*nbspectres] 
		sector [i,j]      = sector [i + j*nbspectres] 
		duree [i]         = duree [i] 
		Z[i,j]            = if spin_average	=1: Z [i + j*nbspins]
							=0: Z [i + j*nbspins*nbspectres]
	*/

	int		imasse;
	int		nospectre;
	float 		somme;
	float		accumulation_duree;
	float 		val=0;
	double 		date;
	int 		nb;
	float 		val0=0; /* initialisation sinon warning gcc */
	float 		E;

	int 		ievt;
	int		nbevt=0;
	int		phd=0;
	int 		tof=0;
	int		dir=0;
	int		coincidence=0;
	int		nbphd;
	unsigned int 	coup_telemesure=0;

	int		tab_nbphd[] = {0,	1,1,1,	2,2,2,	16,16,16};
	int		tab_dir[]   = {0,	0,1,2,	0,1,2,	0,1,2};

	int		nbcoups;
	unsigned char	*p;
	int		i;
	int		nbt=0;
	int		nbm=0;
	int		pollue;
	int		ind;
	unsigned char	*channelok=NULL;
	unsigned char	*liste=NULL;
	int		nbliste;
	int		pos1=0;
	int		pos2=0;
	int		nbsomme;
	int		nbZ = nbX*nbY;

	int		ipac;
	int		igeomfactor;
	int		idataid;
	int		j,jk;

	if (nbarg != argc) return;

	DEBUT ();
	MAVEN_SWEA_CALIB_DEBUT();

	if (is_NPD1(nocis) || is_NPD2(nocis)) { 
		for (i=0 ; i<nbZ ; i++)
			Z[i] = 0;
	} else {
		/* Remplissage de Z[*,*] avec F_INFINITY */
		for (i=0 ; i<nbZ ; i++)
			Z[i] = F_INFINITY;
	}

	if (optimise) {

		/* Experience IMA */

		channelok = (unsigned char *) malloc (nbmasses);
		liste     = (unsigned char *) malloc (nbmasses*nbcellules*2);
		nbytes    = 2;
		p2        = (byte2 *)         malloc (nbenergies*nbcellules*nbspectres*nbmasses*nbytes);

		for (i=0 ; i<nbmasses ; i++)
			channelok[i]=1;
		if (is_IMA_ASPERA3(nocis) && nbmasses==32) {
			channelok[ 0]=0;
			channelok[ 4]=0;
			channelok[10]=0;
			channelok[22]=0;
		}

		for (icellule=0 ; icellule<nbcellules ; icellule++)
			if (tabtheta[icellule])
				nbt++;
		for (imasse=0 ; imasse<nbmasses ; imasse++)
			if (tabmass[imasse])
				nbm++;

	}

	// Verrue DEMETER c/s_TARANIS
	if (is_DEMETER_IDP(nocis) && (cjf == C_SEC_TARANIS)) {
		for (ienergie=0 ; ienergie<nbenergies ; ienergie++) {
			val_demeter[ienergie] = DEMETER_TABLE_TARANIS[ienergie] / DEMETER_TABLE_DEMETER[ienergie]; // facteur par lequel on devra multipler les c/s
			//printf ("val_demeter[%d] = %f\n",ienergie,val_demeter[ienergie]);
		}
	}

	for (ispin=0 ; ispin<nbspins ; ispin++) {

		if (region_ok[ispin]==0) { 

			if (spin_average==0) {
				for (ispectre=0 ; ispectre<nbspectres ; ispectre++) {
					nospectre = ispin*nbspectres+ispectre;
					Z[nospectre]=1e34;
				}
			} else {
				Z[ispin]=1e34;
			}

			continue;

		}

		tabphi_to_okspectre (B, tabphi, nbspectres, start, ispin, produit1, prodmin, prodmax, okspectre, nocis);

		pollution_maj (nocis, ispin, cis_mode, start_pollution_solaire, end_pollution_solaire, nbspectres, nbcellules, nbangles, solid, pollution);

		if (is_ELS(nocis)) sector_mask_to_solid (sector_mask[ispin], nbcellules, solid);

		ipac			= IMA_PAC[ispin];
		igeomfactor		= MEA_GEOMFACTOR[ispin];
		idataid			= MEA_DATAID[ispin];
		icarte			= indC[ispin];
		isensitivity		= sensitivity[ispin];
		accumulation		= nb_accumulation[ispin];
		accumulation_duree	= accumulation*duree_comptage[ispin];
		date			= xmin[ispin];
		MAVEN_SWEA_CALIB_GET();
		sector			= date < sectornew_date ? sectorold : sectornew;
		p1			= get_p1(tabdata,no1);

		if (is_pad) GET_SOLID();

		if (optimise) {

			/* Experience IMA */

			bzero (p2, nbenergies*nbcellules*nbspectres*nbmasses*2);
			for (ienergie=0 ; ienergie<nbenergies ; ienergie++) {
				for (ispectre=0 ; ispectre<nbspectres ; ispectre++) {
					if ((p = (unsigned char *) dataquick[indice3(ienergie,ispectre,no1+ispin,nbenergies,nbspectres,INUTILE)]) != 0) {
						nbcoups = 256*p[0] + p[1];
						ind = 2;
						for (i=0 ; i<nbcoups ; i++, ind += 4) {
							icellule = p[ind+0];
							imasse   = p[ind+1];
							p2[nocoup] = 256*p[ind+2] + p[ind+3];
						}
					}
				}
			}
		} else {
			p2 = get_p2(tabdata,no1);
		}
		p4 = get_p4(tabdata,no1);
		pfloat = get_pfloat(tabdata,no1);
		pdouble = get_pdouble(tabdata,no1);

		if (is_NPD1(nocis) || is_NPD2(nocis)) { /* NPD */

			somme=0;

			#define	RAW	0
			#define	TOF	10

			if (	(noproduit==RAW && (tof_phd==1 || tof_phd==2))  ||
				/* RAW: 512 * 4 octets	(tof, direction, coincidence, stopph)
					|8 bits  |11 bits    |2 bits   |3 bits     |
					|phd     |tof(ns)    |direction|coincidence| */

				(noproduit==TOF && tof_phd==1) ||
				/* TOF: 256 TOF pour DIR0 puis 256 TOF pour DIR1 puis 256 TOF pour DIR3 */ 

				((noproduit>=1 && noproduit<=9) && (tof_phd==1 || tof_phd==2))
				/* BINNING: (16*16 ou 16*2 ou 16*1) * (1 ou 2 octets) (tof, ph, direction) */ ) {

				if (noproduit == RAW) {

					nbevt = 512;

				} else if (noproduit == TOF) {

					nbevt = 768;

				} else if (noproduit >= 1 && noproduit <= 9) {

					nbphd = tab_nbphd[noproduit];
					nbevt = nbphd*16; /* toujours 16 TOF */

				}

				for (ievt=0 ; ievt<nbevt ; ievt++) {

					/* coup_telemsure */
					if (noproduit == RAW) {

						coup_telemesure = p4[ievt];

					} else {

						if (nbytes==1) {

							coup_telemesure = p1[ievt];

						} else if (nbytes==1+65536) {

							coup_telemesure = dico[p1[ievt]];

						} else if (nbytes==2) {

							coup_telemesure = p2[ievt];

						} else if (nbytes==2+65536) {

							coup_telemesure = dico[p2[ievt]];

						}

					}

					if (noproduit == RAW) {		/* tof: 11 bits donc tof est en ns */

						tof = (coup_telemesure >> 5) & 0x7ff;

					} else if (noproduit >= 1 && noproduit <= 9) {

						tof = ievt % 16;

					} else if (noproduit == TOF) {

						tof = ievt % 256;

					}


					/* phd: sur 8 bits */
					if (noproduit == RAW) {

						phd = (coup_telemesure >> 16) & 0xff;

					} else if (noproduit >= 1 && noproduit <= 3) {

						phd = 0;

					} else if (noproduit >= 4 && noproduit <= 6) {

						phd = ievt / 16;

					} else if (noproduit >= 7 && noproduit <= 9) {
			
						phd = ievt / 16;

					} else if (noproduit == TOF) {

						phd = 0;

					}



					/* Selection en theta (dir) 			0: pour Stop 0
											1: pour Stop 1
											2: pour Stop 2 */

					if (noproduit == RAW) {

						dir = (coup_telemesure >> 3) & 0x3;	/* entre 0 et 3 */

						// 13/02/2021: La valeur 3 fait dborder tabdir[3]
						// ex: aspera4_cnesonly_npd1 20060205 record 3540
						if (dir == 3) continue;

					} else if (noproduit >= 1 && noproduit <= 9) {

						dir = tab_dir[noproduit];		/*	produit 1, 4, 7:	Stop 0
												produit 2, 5, 8:	Stop 1
												produit 3, 6, 9:	Stop 2 */

					} else if (noproduit == TOF) {

						dir = ievt / 256;			/* 	DIR 0 pour ievt de 0 a 255
												DIR 1 pour ievt de 256 a 511
												DIR 2 pour ievt de 512 a 767
											*/

					}


					/* Selection en phi (coincidence) 		0: 1 Start et 1 Stop
											1: N Start et 1 Stop
											2: 1 Start et N Stop
											3: N Start et N Stop
											4: 0 Start et ? Stop */
					if (noproduit == RAW) {

						coincidence = coup_telemesure & 0x7;	/* entre 0 et 7 */

					} else if (noproduit >= 1 && noproduit <= 9) {

						coincidence = 0; /* binning array will be exclued if coincidence level does not fit p 4/25 DigTOF in ASPERA/NPD */

					} else if (noproduit == TOF) {

						coincidence = 0; /* Le mode TOF ne tient compte que des evenements avec coincidence = 0 */

					}

					if (tof_phd==1) { /* spectro temps_TOF */

						if (noproduit == RAW || noproduit == TOF) {

							ienergie = tof;

						} else if (noproduit >= 1 && noproduit <= 9) {

							ienergie = tof;
			
						}

					} else if (tof_phd == 2) { /* spectro temps_PHD */

						ienergie = phd;

					}

					if (noproduit == RAW) {

						val = 1;

					} else if (noproduit >= 1 && noproduit <= 9) {

						val = coup_telemesure;

					} else if (noproduit == TOF) {

						val = coup_telemesure;

					}


					if (val != 0) {

						if (tabtheta[dir]) {
							if (tabphi[coincidence]) {
								if (tab1ienergy[0]==-2 || (tab1ienergy[ispin]!=-1 && tab2ienergy[ispin]!=-1 && 
									tab1ienergy[ispin]<=ienergie && tab2ienergy[ispin]>=ienergie)) {
									if (tab1ienergy[0]==-2) {
										Z[ispin + ienergie*nbspins] += val;
									} else {
										somme += val;
									}
								}
							}
						}
					}
				}

				if (tab1ienergy[0]!=-2) {
					Z[ispin] = somme;
				}

			}

			continue;
		}

		somme=nb=nbsomme=0;
		if (spin_average==0 && tab1ienergy[0]!=-2) {
			nospectre = ispin*nbspectres;
			val0 = Z[nospectre];
		}

		// Verrue DEMETER flux_algo
		if (is_DEMETER_IDP(nocis) && (cjf == FLUX_ALGO)) {
			cjf = COUNT;
			ispectre = 0;
			icellule = 0;
			imasse = 0;
			demeter_histo_canal_prec = 0;

			if (nbenergies==256) {
				for (j=0 ; j<255 ; j++) {

					ienergie = j+1;
					COUP_TO_CJF1 (cjf); // met  jour val

					ratio_demeter[j] = (val - demeter_histo_canal_prec) / DEMETER_TAB_FULLNRJCOUNT_IDP[j];

					val_demeter[ienergie] = ratio_demeter[j] * DEMETER_TAB_FULLNRJRATIO_IDP[j] * DEMETER_TAB_FULLNRJCOUNT_IDP[j] / 1000.0;
					demeter_histo_canal_prec = 0;
					for (jk=0 ; jk<=j ; jk++) {
						demeter_histo_canal_prec += DEMETER_HISTO_PER_ENERGY_SPEC[indice2(256-(j+3),jk,256,255)] * ratio_demeter[jk];
					}

				}

			} else if (nbenergies==128) {
				for (j=0 ; j<127 ; j++) {

					ienergie = j+1;
					COUP_TO_CJF1 (cjf); // met  jour val

					ratio_demeter[j] = (val - demeter_histo_canal_prec) / DEMETER_TAB_FULLNRJCOUNT_IDP[2*j];

					val_demeter[ienergie] = ratio_demeter[j] * DEMETER_TAB_FULLNRJRATIO_IDP[2*j] * DEMETER_TAB_FULLNRJCOUNT_IDP[2*j] / 4000.0;
					demeter_histo_canal_prec = 0;
					for (jk=0 ; jk<=j ; jk++) {
						demeter_histo_canal_prec += DEMETER_HISTO_PER_ENERGY_SPEC[indice2(256-(2*j+3),2*jk,256,255)] * ratio_demeter[jk];
					}
				}
			}
			cjf = FLUX_ALGO;
			val_demeter[0] = 0; // car val_demeter[0] n'a pas t calcul
		}


		for (ienergie=0 ; ienergie<nbenergies ; ienergie++) {

			if (ienergie < start_energy[ispin]) continue;	// pour acclrer SOLAR_PAS
			if (ienergie > end_energy[ispin]) continue;	// pour acclrer SOLAR_PAS

			if (tab1ienergy[0]==-2 || (tab1ienergy[ispin]!=-1 && tab2ienergy[ispin]!=-1 && tab1ienergy[ispin]<=ienergie && tab2ienergy[ispin]>=ienergie)) {
			} else {
				continue;
			}

			if (tab1ienergy[0]==-2) {
				somme=nb=nbsomme=0;
			}

			if (tabmass[0]<0) {
				pos1 = IMA_POSITION1[indice3(ispin,ienergie,-tabmass[0]-1,nbspins,nbenergies,INUTILE)] + 0.5; if (pos1<0) pos1=0;
				pos2 = IMA_POSITION2[indice3(ispin,ienergie,-tabmass[0]-1,nbspins,nbenergies,INUTILE)] + 0.5; if (pos2>nbmasses-1) pos2=nbmasses-1;
			}

			if (respect_solid) bzero (angle_used,nbangles);

			for (ispectre=0 ; ispectre<nbspectres ; ispectre++) {
				nospectre = ispin*nbspectres+ispectre;
				if (okspectre[ispectre]==0) {
					if (spin_average==0 && tab1ienergy[0]==-2) {
						Z[nospectre + (nbenergies-1-ienergie)*nbspectres*nbspins] = 1e34;
					}
					continue;
				}

				if (spin_average==0 && tab1ienergy[0]!=-2) {
					if (Z[nospectre] == val0) {
						Z[nospectre] = 0;
					}
				}
				itable = !spin_average ? indY[nospectre]:indY[ispin];
				if (itable==-1) continue;
				if (!spin_average) {
					somme=nb=nbsomme=0;
				}

				if (!optimise) {

					/* Experience autre que IMA */
					/* Parcours de toutes les masses et de toutes les cellules */
					/* Plus rapide en bouclant sur imasse puis sur icellule plutot que l'inverse ! */
					for (imasse=0 ; imasse<nbmasses ; imasse++) {
						if (tabmass[imasse]==0) continue;
						for (icellule=0 ; icellule<nbcellules ; icellule++) {

							if (tabtheta[icellule]==0) continue;

							POLLUTION_ON (); if (pollue) continue;
							if (lire_eff && ((eff = get_eff) < -FILLVAL_E30)) continue;
							if (lire_fg) {
								if (respect_solid) {
									if (angle_used[solid[indice3(ispectre,icellule,icarte,nbspectres,nbcellules,INUTILE)]]) continue;
									angle_used[solid[indice3(ispectre,icellule,icarte,nbspectres,nbcellules,INUTILE)]] = 1;
								}
								if ((fg = get_fg ) < -FILLVAL_E30) continue; // get_data_time_energy_cjf
							}
							// 20210210	if (remove_bad_channel) {
							// 20210210		COUP_TO_CJF1_REMOVE_BAD_CHANNEL ();
							// 20210210	} else {
								COUP_TO_CJF1 (cjf);
								if (val < -FILLVAL_E30) continue;
							// 20210210	}
							// 20210210	if (remove_hghost) REMOVE_HGHOST ();
							if (infos_on && val > max_val[spin_average ? ispin : nospectre]) {
								E = Emoy[indice2(itable,ienergie,nbtablesE,nbenergies)];
								if (E >= energymin && E <= energymax) {
									max_val    [spin_average ? ispin : nospectre] = val;
									max_energie[spin_average ? ispin : nospectre] = E;
									max_theta  [spin_average ? ispin : nospectre] = icellule;
									max_phi    [spin_average ? ispin : nospectre] = ispectre;
								}
							}
							if (USEBIGZ) BIGZ[indice5(ispin,imasse,icellule,ispectre,ienergie,nbspins,nbmasses,nbcellules,nbspectres,nbenergies)]=val;
							somme += val;
							nbsomme++;
							if (div_cjf) {
								nb++; /* J, f ou JE */
							}

						}
					}

				} else {

					/* Experience IMA */
					/* On pourrait utiliser le parcours classique des autres expriences */
					/* Mais on peut aller plus vite ici en parcourant seulement les coups non nuls pour 'ienergie' et 'ispectre' */

					if (tabmass[0]<0) {
						pos1 = IMA_POSITION1[indice3(ispin,ienergie,-tabmass[0]-1,nbspins,nbenergies,INUTILE)] + 0.5; if (pos1<0) pos1=0;
						pos2 = IMA_POSITION2[indice3(ispin,ienergie,-tabmass[0]-1,nbspins,nbenergies,INUTILE)] + 0.5; if (pos2>nbmasses-1) pos2=nbmasses-1;
					}

					nbliste = 0;
					/* Parcours des coups non nuls */
					if ((p = (unsigned char *) dataquick[indice3(ienergie,ispectre,no1+ispin,nbenergies,nbspectres,INUTILE)]) != 0) {
						nbcoups = 256*p[0] + p[1];
						for (i=0 ; i<nbcoups ; i++) {
							icellule = p[2+4*i+0];
							imasse   = p[2+4*i+1];
							if (channelok[imasse]==1) {
								liste[nbliste*2+0] = icellule;
								liste[nbliste*2+1] = imasse;
								nbliste++;
							}
						}
					}

					/* Rajout des channels qui posent probleme et dont le comptage peut devenir non nul */
					for (imasse=0 ; imasse<nbmasses ; imasse++) {
						if (channelok[imasse]==0) {
							for (icellule=0 ; icellule<nbcellules; icellule++) {
								liste[nbliste*2+0] = icellule;
								liste[nbliste*2+1] = imasse;
								nbliste++;
							}
						}
					}

					/* Parcours des coups qui sont dans liste */
					for (i=0 ; i<nbliste ; i++) { 
						icellule = liste[2*i+0];
						imasse   = liste[2*i+1];
						if (tabtheta[icellule] && (tabmass[imasse]==1 || (tabmass[0]<0 && imasse>=pos1 && imasse<=pos2))) {
							POLLUTION_ON (); if (pollue) continue;
							if (lire_eff && ((eff = get_eff) < -FILLVAL_E30)) continue;
							if (lire_fg && ((fg = get_fg ) < -FILLVAL_E30)) continue; // get_data_time_energy_cjf
							if (remove_bad_channel) {
								COUP_TO_CJF1_REMOVE_BAD_CHANNEL ();
							} else {
								COUP_TO_CJF1 (cjf);
								if (val < -FILLVAL_E30) continue;
							}
							if (remove_hghost) REMOVE_HGHOST ();
							if (infos_on && val > max_val[spin_average ? ispin : nospectre]) {
								E = Emoy[indice2(itable,ienergie,nbtablesE,nbenergies)];
								if (E >= energymin && E <= energymax) {
									max_val    [spin_average ? ispin : nospectre] = val;
									max_energie[spin_average ? ispin : nospectre] = E;
									max_theta  [spin_average ? ispin : nospectre] = icellule;
									max_phi    [spin_average ? ispin : nospectre] = ispectre;
								}
							}
							if (USEBIGZ) BIGZ[indice5(ispin,imasse,icellule,ispectre,ienergie,nbspins,nbmasses,nbcellules,nbspectres,nbenergies)]=val;
							somme += val;
							nbsomme++;
						}
					}
					if (div_cjf) { /* J, f ou JE */
						nb += nbt*nbm;
					}
				}

				if (!spin_average) {
					if (nb) {
						somme /= nb;
					}
					if (tab1ienergy[0]==-2) {
						Z[nospectre+(nbenergies-1-ienergie)*nbspectres*nbspins] = somme;
					} else {
						if (Z[nospectre] == val0) {
							if (nbsomme) Z[nospectre] = somme;
						} else {
							if (nbsomme) Z[nospectre] += somme;
						}
					}
				}
			}

			if (spin_average) { 
				if (tab1ienergy[0]==-2) {
					if (nbsomme) Z[ispin + (nbenergies-1-ienergie)*nbspins] = somme / (nb ? nb : 1);
				} else {
					if (nbsomme) Z[ispin] = somme / ( nb ? nb : 1); else Z[ispin] = -FILLVAL_E31;
				}
			} 

		} // for (ienergie)
	} // for (ispin)

	FIN ();
	MAVEN_SWEA_CALIB_FIN();

	if (optimise) free (channelok);
	if (optimise) free (liste);
	if (optimise) free (p2);

}


/*---------------------------------------------------------------------------*/
void GET_DATA_TIME_ENERGY_CJF_AUTO_GLUE (
/*---------------------------------------------------------------------------*/
	void	*p01,
	void	*p02,
	void	*p03,
	void	*p04,
	void	*p05,
	void	*p06,
	void	*p07,
	void	*p08,
	void	*p09,
	void	*p10,
	void	*p11,
	void	*p12,
	void	*p13,
	void	*p14,
	void	*p15,
	void	*p16,
	void	*p17,
	void	*p18,
	void	*p19,
	void	*p20,
	void	*p21,
	void	*p22,
	void	*p23,
	void	*p24,
	void	*p25,
	void	*p26,
	void	*p27,
	void	*p28,
	void	*p29,
	void	*p30,
	void	*p31,
	void	*p32,
	void	*p33,
	void	*p34,
	void	*p35,
	void	*p36,
	void	*p37,
	void	*p38,
	void	*p39,
	void	*p40,
	void	*p41,
	void	*p42,
	void	*p43,
	void	*p44,
	void	*p45,
	void	*p46,
	void	*p47,
	void	*p48,
	void	*p49,
	void	*p50,
	void	*p51,
	void	*p52,
	void	*p53,
	void	*p54,
	void	*p55,
	void	*p56,
	void	*p57,
	void	*p58,
	void	*p59,
	void	*p60,
	void	*p61,
	void	*p62,
	void	*p63,
	void	*p64,
	void	*p65,
	void	*p66,
	void	*p_CL_ROOT) {

	int		argc=67;
	void		*argv[67];
	IDL_STRING	*CL_ROOT;

	// p_CL_ROOT -> CL_ROOT
	CL_ROOT = malloc (sizeof(IDL_STRING));
	IDL_StrStore (CL_ROOT, p_CL_ROOT);

	argv[ 0] = p01;
	argv[ 1] = p02;
	argv[ 2] = p03;
	argv[ 3] = p04;
	argv[ 4] = p05;
	argv[ 5] = p06;
	argv[ 6] = p07;
	argv[ 7] = p08;
	argv[ 8] = p09;
	argv[ 9] = p10;
	argv[10] = p11;
	argv[11] = p12;
	argv[12] = p13;
	argv[13] = p14;
	argv[14] = p15;
	argv[15] = p16;
	argv[16] = p17;
	argv[17] = p18;
	argv[18] = p19;
	argv[19] = p20;
	argv[20] = p21;
	argv[21] = p22;
	argv[22] = p23;
	argv[23] = p24;
	argv[24] = p25;
	argv[25] = p26;
	argv[26] = p27;
	argv[27] = p28;
	argv[28] = p29;
	argv[29] = p30;
	argv[30] = p31;
	argv[31] = p32;
	argv[32] = p33;
	argv[33] = p34;
	argv[34] = p35;
	argv[35] = p36;
	argv[36] = p37;
	argv[37] = p38;
	argv[38] = p39;
	argv[39] = p40;
	argv[40] = p41;
	argv[41] = p42;
	argv[42] = p43;
	argv[43] = p44;
	argv[44] = p45;
	argv[45] = p46;
	argv[46] = p47;
	argv[47] = p48;
	argv[48] = p49;
	argv[49] = p50;
	argv[50] = p51;
	argv[51] = p52;
	argv[52] = p53;
	argv[53] = p54;
	argv[54] = p55;
	argv[55] = p56;
	argv[56] = p57;
	argv[57] = p58;
	argv[58] = p59;
	argv[59] = p60;
	argv[60] = p61;
	argv[61] = p62;
	argv[62] = p63;
	argv[63] = p64;
	argv[64] = p65;
	argv[65] = p66;
	argv[66] = CL_ROOT;
	GET_DATA_TIME_ENERGY_CJF (argc, argv);

	free (CL_ROOT);

}


/*---------------------------------------------------------------------------*/
void GET_DATA_MASS_ENERGY_CJF (int argc, void *argv[]) {
/*---------------------------------------------------------------------------*/

	/*
		Utilise dans les spectros massQ_energy et mass_energy
	*/

	int		nbarg				= 0;
	short		*sensitivity			= (short *)		argv[nbarg++]; /* sensitivity[nbspins] */
	int		*solid				= (int *)		argv[nbarg++]; /* solid[nbspectres,nbcellules] */
	double		*deadtime			= (double *)		argv[nbarg++]; /* deadtime[2] */
	int		*sectorold			= (int *)		argv[nbarg++]; /* sectorold[nbspectres,nbcellules] */
	float		*duree_comptage			= (float *)		argv[nbarg++]; /* duree_comptage[nbspins] */ 
	int		*nb_accumulation		= (int *)		argv[nbarg++]; /* nb_accumulation[nbspins] */
	int		*tabtheta			= (int *)		argv[nbarg++]; /* tabtheta[nbcellules] */
	int		*tabphi				= (int *)		argv[nbarg++]; /* tabphi[nbspectres] */
	int		*indY				= (int *)		argv[nbarg++]; /* si spin_average=	1 alors indY[nbspins]
															0       indY[nbspins*nbspectres] */
	int		*indC				= (int *)		argv[nbarg++]; /* indC[nbspins] */
	float		*Emin				= (float *)		argv[nbarg++]; /* Emin[nbtablesE,nbenergies] */
	float		*Emoy				= (float *)		argv[nbarg++]; /* Emoy[nbtablesE,nbenergies] */
	float		*Emax				= (float *)		argv[nbarg++]; /* Emax[nbtablesE,nbenergies] */
	double		*efficacite			= (double *)		argv[nbarg++]; /* efficacite[] */
	double		*facteurG			= (double *)		argv[nbarg++]; /* facteurG[] */
	char		*tabdata			= (char *)		argv[nbarg++];
	int		no1				= *(int *)		argv[nbarg++];
	int		*debut				= (int *)		argv[nbarg++];
	int		*fin				= (int *)		argv[nbarg++];
	float		*dico				= (float *)		argv[nbarg++];
	int		nbytes				= *(int *)		argv[nbarg++];
	float		*Z				= (float *)		argv[nbarg++]; /* si spin_average=	1 alors Z[nbspins,nbenergies] 
															0       Z[nbspins*nbspectres,nbenergies]*/
	int		*sectornew			= (int *)		argv[nbarg++]; /* sectornew[nbspectres,nbcellules] */
	double		sectornew_date			= *(double *)		argv[nbarg++];
	double		*xmin				= (double *)		argv[nbarg++]; /* xmin[nbspins] = datation de chaque spin */
	float		*Q				= (float *)		argv[nbarg++]; /* Q[nbmasses] */
	double		*MASSE				= (double *)		argv[nbarg++]; /* MASSE[nbmasses] */
	int		MQ				= *(int *)		argv[nbarg++];
	int		nbX				= *(int *)		argv[nbarg++];
	float		*TABLE				= (float *)		argv[nbarg++]; /* TABLE[nbmasses,nbenergies]: contient les valeurs de M/Q */
	float		*IMA_NOISE			= (float *)		argv[nbarg++]; /* IMA_NOISE[nbenergies,nbmasses] */
	float		*IMA_MASS_MULT			= (float *)		argv[nbarg++]; /* IMA_MASS_MULT[nbmasses] */
	unsigned char	*IMA_PAC			= (unsigned char *)	argv[nbarg++]; /* IMA_PAC[nbspins] */
	unsigned char	*MEA_GEOMFACTOR			= (unsigned char *)	argv[nbarg++]; /* MEA_GEOMFACTOR[nbspins] */
	unsigned char	*MEA_DATAID			= (unsigned char *)	argv[nbarg++]; /* MEA_DATAID[nbspins] */
	int		*TABINFO_INT			= (int *)		argv[nbarg++];
	double		*TABINFO_DOUBLE			= (double *)		argv[nbarg++];
	IDL_STRING	*CL_ROOT			= (IDL_STRING *)	argv[nbarg++];

	/* remove bad channel pour ASPERA3:
		- pour imasse=0: suppression des coups
		- pour imasse=4,10,22: coup = (coup[imasse-1] + coup[imasse+1])/2
	*/



	/* 
		start [i]         = start [i] 
		solid [i,j]       = solid  [i + j*nbspectres] 
		sector [i,j]      = sector [i + j*nbspectres] 
		duree [i]         = duree [i] 
		Z[i,j]            = if spin_average	=1: Z [i + j*nbspins]
							=0: Z [i + j*nbspins*nbspectres]
	*/

	int		imasse;
	float		somme;
	float		accumulation_duree;
	float		val;
	double		date;
	int		nb;
	int		ix;
	float		indice;

	int		ipac=IMA_PAC[0];
	int		igeomfactor=MEA_GEOMFACTOR[0];
	int		idataid=MEA_DATAID[0];

	if (nbarg != argc) return;

	DEBUT ();
	MAVEN_SWEA_CALIB_DEBUT();

	ispin = 0;

	icarte			= indC[ispin];
	isensitivity		= sensitivity[ispin];
	accumulation		= nb_accumulation[ispin];
	accumulation_duree	= accumulation*duree_comptage[ispin];
	date			= xmin[ispin];
	MAVEN_SWEA_CALIB_GET();
	sector			= date < sectornew_date ? sectorold : sectornew;
	p1			= get_p1(tabdata,no1);
	p2			= get_p2(tabdata,no1);
	p4			= get_p4(tabdata,no1);
	pfloat			= get_pfloat(tabdata,no1);
	pdouble			= get_pdouble(tabdata,no1);

	if (is_pad) GET_SOLID();

	for (ienergie=0 ; ienergie<nbenergies ; ienergie++) {
		for (imasse=0 ; imasse<nbmasses ; imasse++) {
			somme=nb=0;
			indice = TABLE[indice2(imasse,ienergie,nbmasses,nbenergies)];
			ix = (MQ == 0) ? imasse : (indice < 0 ? -1 : (int)(indice+0.5));
			if (MQ==0 || (ix>=0 && ix<nbX)) {
				for (ispectre=0 ; ispectre<nbspectres ; ispectre++) {
					if (tabphi[ispectre]==0) continue;
					itable = indY[ispin];
					if (itable==-1) continue;
					for (icellule=0 ; icellule<nbcellules ; icellule++) {
						if (tabtheta[icellule]==0) continue;
						if (lire_eff && ((eff = get_eff) < -FILLVAL_E30)) continue;
						if (lire_fg && ((fg = get_fg ) < -FILLVAL_E30)) continue; // get_data_mass_energy_cjf
						if (remove_bad_channel) {
							COUP_TO_CJF1_REMOVE_BAD_CHANNEL ();
						} else {
							COUP_TO_CJF1 (cjf);
							if (val < -FILLVAL_E30) continue;
						}
						// normal qu'il n'y ait pas de REMOVE_HGHOST ici
						somme += val;
						if (div_cjf) {
							nb++; /* J, f ou JE */
						}
					}
				}
				if (nb) {
					somme /= nb;
				}
				Z[ix + (nbenergies-1-ienergie)*nbX]=somme;
			}
		}
	}

	FIN ();
	MAVEN_SWEA_CALIB_FIN();

}

/*---------------------------------------------------------------------------*/
void GET_DATA_MASS_ENERGY_CJF_AUTO_GLUE (
/*---------------------------------------------------------------------------*/
	void	*p01,
	void	*p02,
	void	*p03,
	void	*p04,
	void	*p05,
	void	*p06,
	void	*p07,
	void	*p08,
	void	*p09,
	void	*p10,
	void	*p11,
	void	*p12,
	void	*p13,
	void	*p14,
	void	*p15,
	void	*p16,
	void	*p17,
	void	*p18,
	void	*p19,
	void	*p20,
	void	*p21,
	void	*p22,
	void	*p23,
	void	*p24,
	void	*p25,
	void	*p26,
	void	*p27,
	void	*p28,
	void	*p29,
	void	*p30,
	void	*p31,
	void	*p32,
	void	*p33,
	void	*p34,
	void	*p35,
	void	*p36,
	void	*p37,
	void	*p_CL_ROOT) {

	int		argc=38;
	void		*argv[38];
	IDL_STRING	*CL_ROOT;

	// p_CL_ROOT -> CL_ROOT
	CL_ROOT = malloc (sizeof(IDL_STRING));
	IDL_StrStore (CL_ROOT, p_CL_ROOT);

	argv[ 0] = p01;
	argv[ 1] = p02;
	argv[ 2] = p03;
	argv[ 3] = p04;
	argv[ 4] = p05;
	argv[ 5] = p06;
	argv[ 6] = p07;
	argv[ 7] = p08;
	argv[ 8] = p09;
	argv[ 9] = p10;
	argv[10] = p11;
	argv[11] = p12;
	argv[12] = p13;
	argv[13] = p14;
	argv[14] = p15;
	argv[15] = p16;
	argv[16] = p17;
	argv[17] = p18;
	argv[18] = p19;
	argv[19] = p20;
	argv[20] = p21;
	argv[21] = p22;
	argv[22] = p23;
	argv[23] = p24;
	argv[24] = p25;
	argv[25] = p26;
	argv[26] = p27;
	argv[27] = p28;
	argv[28] = p29;
	argv[29] = p30;
	argv[30] = p31;
	argv[31] = p32;
	argv[32] = p33;
	argv[33] = p34;
	argv[34] = p35;
	argv[35] = p36;
	argv[36] = p37;
	argv[37] = CL_ROOT;
	GET_DATA_MASS_ENERGY_CJF (argc, argv);

	free (CL_ROOT);

}


/*---------------------------------------------------------------------------*/
void GET_DATA_TIME_MASS_CJF (int argc, void *argv[]) {
/*---------------------------------------------------------------------------*/

	/*
		Utilise dans les spectros time_mass
	*/

	int		nbarg				= 0;
	short		*sensitivity			= (short *)		argv[nbarg++]; /* sensitivity[nbspins] */
	short		*produit1			= (short *)		argv[nbarg++]; /* produit1[nbspins] */
	short		*mag				= (short *)		argv[nbarg++]; /* mag[nbspins] */
	int		*region_ok			= (int *)		argv[nbarg++]; /* region_ok[nbspins] */
	short		*cis_mode			= (short *)		argv[nbarg++]; /* cis_mode[nbspins] */
	int		*start				= (int *)		argv[nbarg++]; /* start[nbspins] */
	int		*solid				= (int *)		argv[nbarg++]; /* solid[nbspectres,nbcellules] */
	double		*deadtime			= (double *)		argv[nbarg++]; /* deadtime[2] */
	int		*sectorold			= (int *)		argv[nbarg++]; /* sectorold[nbspectres,nbcellules] */
	float		*duree_comptage			= (float *)		argv[nbarg++]; /* duree_comptage[nbspins] */ 
	int		*nb_accumulation		= (int *)		argv[nbarg++]; /* nb_accumulation[nbspins] */
	int		*tabtheta			= (int *)		argv[nbarg++]; /* tabtheta[nbcellules] */
	int		*tabphi				= (int *)		argv[nbarg++]; /* tabphi[nbspectres] */
	int		*tab1ienergie			= (int *)		argv[nbarg++]; /* si spin_average=	1 alors tab1ienergy[nbspins]
															0       tab1ienergy[nbspins*nbspectres] */
	int		*tab2ienergie			= (int *)		argv[nbarg++]; /* si spin_average=	1 alors tab2ienergy[nbspins]
															0       tab2ienergy[nbspins*nbspectres] */
	int		*indY				= (int *)		argv[nbarg++]; /* si spin_average=	1 alors indY[nbspins]
															0       indY[nbspins*nbspectres] */
	int		*indC				= (int *)		argv[nbarg++]; /* indC[nbspins] */
	float		*Emin				= (float *)		argv[nbarg++]; /* Emin[nbtablesE,nbenergies] */
	float		*Emoy				= (float *)		argv[nbarg++]; /* Emoy[nbtablesE,nbenergies] */
	float		*Emax				= (float *)		argv[nbarg++]; /* Emax[nbtablesE,nbenergies] */
	double		*efficacite			= (double *)		argv[nbarg++]; /* efficacite[] */
	double		*facteurG			= (double *)		argv[nbarg++]; /* facteurG[] */
	char		*tabdata			= (char *)		argv[nbarg++];
	int		no1				= *(int *)		argv[nbarg++];
	int		*debut				= (int *)		argv[nbarg++];
	int		*fin				= (int *)		argv[nbarg++];
	float		*dico				= (float *)		argv[nbarg++];
	int		nbytes				= *(int *)		argv[nbarg++];
	float		*Z				= (float *)		argv[nbarg++]; /* si spin_average=	1 alors Z[nbspins,nbmasses] 
															0       Z[nbspins*nbspectres,nbmasses]*/
	int		*sectornew			= (int *)		argv[nbarg++]; /* sectornew[nbspectres,nbcellules] */
	double		sectornew_date			= *(double *)		argv[nbarg++];
	double		*xmin				= (double *)		argv[nbarg++]; /* xmin[nbspins] = datation de chaque spin */
	float		*Q				= (float *)		argv[nbarg++]; /* Q[nbmasses] */
	double		*MASSE				= (double *)		argv[nbarg++]; /* MASSE[nbmasses] */
	int		*start_pollution_solaire	= (int *)		argv[nbarg++]; /* start_pollution_solaire[nbspins] */
	int		*end_pollution_solaire		= (int *)		argv[nbarg++]; /* end_pollution_solaire[nbspins] */
	unsigned int	*sector_mask			= (unsigned int *)	argv[nbarg++]; /* sector_mask[nbspins] */
	size_t		*dataquick			= (size_t *)		argv[nbarg++];
	float		*IMA_NOISE			= (float *)		argv[nbarg++]; /* IMA_NOISE[nbenergies,nbmasses] */
	float		*IMA_MASS_MULT			= (float *)		argv[nbarg++]; /* IMA_MASS_MULT[nbmasses] */
	unsigned char	*IMA_PAC			= (unsigned char *)	argv[nbarg++]; /* IMA_PAC[nbspins] */
	unsigned char	*MEA_GEOMFACTOR			= (unsigned char *)	argv[nbarg++]; /* MEA_GEOMFACTOR[nbspins] */
	unsigned char	*MEA_DATAID			= (unsigned char *)	argv[nbarg++]; /* MEA_DATAID[nbspins] */
	int		*TABINFO_INT			= (int *)		argv[nbarg++];
	double		*TABINFO_DOUBLE			= (double *)		argv[nbarg++];
	IDL_STRING	*CL_ROOT			= (IDL_STRING *)	argv[nbarg++];

	/* remove bad channel pour ASPERA3:
		- pour imasse=0: suppression des coups
		- pour imasse=4,10,22: coup = (coup[imasse-1] + coup[imasse+1])/2
	*/

	/* 
		start [i]         = start [i] 
		solid [i,j]       = solid  [i + j*nbspectres] 
		sector [i,j]      = sector [i + j*nbspectres] 
		duree [i]         = duree [i] 
		Z[i,j]            = if spin_average	=1: Z [i + j*nbspins]
							=0: Z [i + j*nbspins*nbspectres]
	*/

	int		imasse;
	int		nospectre;
	int		ienergie1;
	int		ienergie2;
	float		val;
	float		somme;
	float		accumulation_duree;
	double 		date;
	int 		nb=0; /* initialise a cause de gcc */
	float		tab_somme[1024];
	int		nbcoups;
	unsigned char	*p;
	int		i;

	int		pollue;
	int		ind;
	unsigned char	*channelok=NULL;
	unsigned char	*liste=NULL;
	int		nbliste;

	int		ipac;
	int		igeomfactor;
	int		idataid;

	if (nbarg != argc) return;

	DEBUT ();
	MAVEN_SWEA_CALIB_DEBUT();

	if (optimise) {

		/* Experience IMA */

		channelok = (unsigned char *) malloc (nbmasses);
		liste     = (unsigned char *) malloc (nbmasses*nbcellules*2);
		nbytes    = 2;
		p2        = (byte2 *)         malloc (nbenergies*nbcellules*nbspectres*nbmasses*nbytes);

		for (i=0 ; i<nbmasses ; i++)
			channelok[i]=1;
		if (is_IMA_ASPERA3(nocis) && nbmasses==32) {
			channelok[ 0]=0;
			channelok[ 4]=0;
			channelok[10]=0;
			channelok[22]=0;
		}

	}

	for (ispin=0 ; ispin<nbspins ; ispin++) {

		if (region_ok[ispin]==0) { 

			if (spin_average==0) {
				for (ispectre=0 ; ispectre<nbspectres ; ispectre++) {
					nospectre = ispin*nbspectres+ispectre;
					Z[nospectre]=1e34;
				}
			} else {
				Z[ispin]=1e34;
			}

			continue;

		}

		tabphi_to_okspectre (B, tabphi, nbspectres, start, ispin, produit1, prodmin, prodmax, okspectre, nocis);

		pollution_maj (nocis, ispin, cis_mode, start_pollution_solaire, end_pollution_solaire, nbspectres, nbcellules, nbangles, solid, pollution);

		if (is_ELS(nocis)) sector_mask_to_solid (sector_mask[ispin], nbcellules, solid);

		ipac			= IMA_PAC[ispin];
		igeomfactor		= MEA_GEOMFACTOR[ispin];
		idataid			= MEA_DATAID[ispin];
		icarte			= indC[ispin];
		isensitivity		= sensitivity[ispin];
		accumulation		= nb_accumulation[ispin];
		accumulation_duree	= accumulation*duree_comptage[ispin];
		date			= xmin[ispin];
		MAVEN_SWEA_CALIB_GET();
		sector			= date < sectornew_date ? sectorold : sectornew;
		p1			= get_p1(tabdata,no1);

		if (is_pad) GET_SOLID();

		if (optimise) {

			/* Experience IMA */

			bzero (p2, nbenergies*nbcellules*nbspectres*nbmasses*2);
			for (ienergie=0 ; ienergie<nbenergies ; ienergie++) {
				for (ispectre=0 ; ispectre<nbspectres ; ispectre++) {
					if ((p = (unsigned char *) dataquick[indice3(ienergie,ispectre,no1+ispin,nbenergies,nbspectres,INUTILE)]) != 0) {
						nbcoups = 256*p[0] + p[1];
						ind = 2;
						for (i=0 ; i<nbcoups ; i++, ind += 4) {
							icellule = p[ind+0];
							imasse   = p[ind+1];
							p2[nocoup] = 256*p[ind+2] + p[ind+3];
						}
					}
				}
			}
		} else {
			p2 = get_p2(tabdata,no1);
		}
		p4 = get_p4(tabdata,no1);
		pfloat = get_pfloat(tabdata,no1);
		pdouble = get_pdouble(tabdata,no1);

		if (!optimise) {

			/* Experience autre que IMA */

			for (imasse=0 ; imasse<nbmasses ; imasse++) {
				somme=nb=0;
				for (ispectre=0 ; ispectre<nbspectres ; ispectre++) {
					if (okspectre[ispectre]==0) continue;
					nospectre = ispin*nbspectres+ispectre; 
					itable = spin_average==0 ? indY[nospectre]:indY[ispin];
					if (itable==-1) continue;
					ienergie1 = spin_average==0 ? tab1ienergie[nospectre]:tab1ienergie[ispin];
					ienergie2 = spin_average==0 ? tab2ienergie[nospectre]:tab2ienergie[ispin];
					if (ienergie1==-1 || ienergie2==-1 || ienergie1>ienergie2) {
						if (spin_average==0) Z[nospectre + imasse*nbspectres*nbspins]=1e34;
						continue;
					}
					if (spin_average==0) somme=nb=0;
					/* Un peu plus rapide en bouclant sur ienergie puis sur icellule plutot que l'inverse */
					for (ienergie=ienergie1 ; ienergie<=ienergie2 ; ienergie++) {
						for (icellule=0 ; icellule<nbcellules ; icellule++) {
							if (tabtheta[icellule]==0) continue;
							POLLUTION_ON (); if (pollue) continue;
							if (lire_eff && ((eff = get_eff) < -FILLVAL_E30)) continue;
							if (lire_fg && ((fg = get_fg ) < -FILLVAL_E30)) continue; // get_data_time_mass_cjf
							if (remove_bad_channel) {
								COUP_TO_CJF1_REMOVE_BAD_CHANNEL ();
							} else {
								COUP_TO_CJF1 (cjf);
								if (val < -FILLVAL_E30) continue;
							}
							// normal qu'il n'y ait pas de REMOVE_HGHOST ici
							somme += val;
							if (div_cjf) nb++; /* J, f ou JE */
						}
					}
					if (spin_average==0) {
						if (nb) somme /= nb;
						Z[nospectre + imasse*nbspectres*nbspins]=somme;
					}
				}
				if (spin_average==1) {
					if (nb) somme /= nb;
					Z[ispin + imasse*nbspins] = somme;
				}
			} 

		} else {

			/* Experience IMA */

			if (spin_average == 1) {
				for (imasse=0 ; imasse<nbmasses ; imasse++) {
					tab_somme[imasse] = 0;
				}
				nb = 0;
			}
			for (ispectre=0 ; ispectre<nbspectres ; ispectre++) {

				if (spin_average == 0) {
					for (imasse=0 ; imasse<nbmasses ; imasse++) {
						tab_somme[imasse] = 0;
					}
					nb = 0;
				}

				nospectre = ispin*nbspectres+ispectre;
				if (okspectre[ispectre]==0) continue;
				itable = spin_average==0 ? indY[nospectre]:indY[ispin];
				if (itable==-1) continue;
				ienergie1 = spin_average==0 ? tab1ienergie[nospectre]:tab1ienergie[ispin];
				ienergie2 = spin_average==0 ? tab2ienergie[nospectre]:tab2ienergie[ispin];
				for (ienergie=ienergie1 ; ienergie<=ienergie2 ; ienergie++) {

					nbliste = 0;
					/* Parcours des coups non nuls */
					if ((p = (unsigned char *) dataquick[indice3(ienergie,ispectre,no1+ispin,nbenergies,nbspectres,INUTILE)]) != 0) {
						nbcoups = 256*p[0] + p[1];
						for (i=0 ; i<nbcoups ; i++) {
							icellule = p[2+4*i+0];
							imasse   = p[2+4*i+1];
							if (channelok[imasse]==1) {
								liste[nbliste*2+0] = icellule;
								liste[nbliste*2+1] = imasse;
								nbliste++;
							}
						}
					}

					/* Rajout des channels qui posent probleme et dont le comptage peut devenir non nul */
					for (imasse=0 ; imasse<nbmasses ; imasse++) {
						if (channelok[imasse]==0) {
							for (icellule=0 ; icellule<nbcellules; icellule++) {
								liste[nbliste*2+0] = icellule;
								liste[nbliste*2+1] = imasse;
								nbliste++;
							}
						}
					}

					/* Parcours des coups qui sont dans liste */
					for (i=0 ; i<nbliste ; i++) { 
						icellule = liste[2*i+0];
						imasse   = liste[2*i+1];
						if (tabtheta[icellule]) {
							POLLUTION_ON (); if (pollue) continue;
							if (lire_eff && ((eff = get_eff) < -FILLVAL_E30)) continue;
							if (lire_fg && ((fg = get_fg ) < -FILLVAL_E30)) continue; // get_data_time_mass_cjf
							if (remove_bad_channel) {
								COUP_TO_CJF1_REMOVE_BAD_CHANNEL ();
							} else {
								COUP_TO_CJF1 (cjf);
								if (val < -FILLVAL_E30) continue;
							}
							// normal qu'il n'y ait pas de REMOVE_HGHOST ici
							tab_somme[imasse] += val;
						}
					}

					if (div_cjf) {
						for (icellule=0 ; icellule<nbcellules ; icellule++) {
							if (tabtheta[icellule]) {
								nb++; /* J, f ou JE */
							}
						}
					}
				}
				if (spin_average == 0) {
					for (imasse=0 ; imasse<nbmasses ; imasse++) {
						if (nb) tab_somme[imasse] /= nb;
						Z[nospectre + imasse*nbspectres*nbspins] = tab_somme[imasse];
					}
				}
			}
			if (spin_average == 1) {
				for (imasse=0 ; imasse<nbmasses ; imasse++) {
					if (nb) tab_somme[imasse] /= nb;
					Z[ispin + imasse*nbspins] = tab_somme[imasse];
				}
			}
		}
	}
	
	FIN ();
	MAVEN_SWEA_CALIB_FIN();

	if (optimise) free (channelok);
	if (optimise) free (liste);
	if (optimise) free (p2);

}


/*---------------------------------------------------------------------------*/
void GET_DATA_TIME_MASS_CJF_AUTO_GLUE (
/*---------------------------------------------------------------------------*/
	void	*p01,
	void	*p02,
	void	*p03,
	void	*p04,
	void	*p05,
	void	*p06,
	void	*p07,
	void	*p08,
	void	*p09,
	void	*p10,
	void	*p11,
	void	*p12,
	void	*p13,
	void	*p14,
	void	*p15,
	void	*p16,
	void	*p17,
	void	*p18,
	void	*p19,
	void	*p20,
	void	*p21,
	void	*p22,
	void	*p23,
	void	*p24,
	void	*p25,
	void	*p26,
	void	*p27,
	void	*p28,
	void	*p29,
	void	*p30,
	void	*p31,
	void	*p32,
	void	*p33,
	void	*p34,
	void	*p35,
	void	*p36,
	void	*p37,
	void	*p38,
	void	*p39,
	void	*p40,
	void	*p41,
	void	*p42,
	void	*p43,
	void	*p44,
	void	*p45,
	void	*p_CL_ROOT) {

	int		argc=46;
	void		*argv[46];
	IDL_STRING	*CL_ROOT;

	// p_CL_ROOT -> CL_ROOT
	CL_ROOT = malloc (sizeof(IDL_STRING));
	IDL_StrStore (CL_ROOT, p_CL_ROOT);

	argv[ 0] = p01;
	argv[ 1] = p02;
	argv[ 2] = p03;
	argv[ 3] = p04;
	argv[ 4] = p05;
	argv[ 5] = p06;
	argv[ 6] = p07;
	argv[ 7] = p08;
	argv[ 8] = p09;
	argv[ 9] = p10;
	argv[10] = p11;
	argv[11] = p12;
	argv[12] = p13;
	argv[13] = p14;
	argv[14] = p15;
	argv[15] = p16;
	argv[16] = p17;
	argv[17] = p18;
	argv[18] = p19;
	argv[19] = p20;
	argv[20] = p21;
	argv[21] = p22;
	argv[22] = p23;
	argv[23] = p24;
	argv[24] = p25;
	argv[25] = p26;
	argv[26] = p27;
	argv[27] = p28;
	argv[28] = p29;
	argv[29] = p30;
	argv[30] = p31;
	argv[31] = p32;
	argv[32] = p33;
	argv[33] = p34;
	argv[34] = p35;
	argv[35] = p36;
	argv[36] = p37;
	argv[37] = p38;
	argv[38] = p39;
	argv[39] = p40;
	argv[40] = p41;
	argv[41] = p42;
	argv[42] = p43;
	argv[43] = p44;
	argv[44] = p45;
	argv[45] = CL_ROOT;
	GET_DATA_TIME_MASS_CJF (argc, argv);

	free (CL_ROOT);

}


/*---------------------------------------------------------------------------*/
void GET_DATA_TIME_THETA_CJF (int argc, void *argv[]) {
/*---------------------------------------------------------------------------*/

	/*
		Utilise dans les spectros theta_phi et time_theta
	*/

	int		nbarg				= 0;
	short		*sensitivity			= (short *)		argv[nbarg++]; /* sensitivity[nbspins] */
	short		*produit1			= (short *)		argv[nbarg++]; /* produit1[nbspins] */
	short		*mag				= (short *)		argv[nbarg++]; /* mag[0:nbspins] */
	int		*region_ok			= (int *)		argv[nbarg++]; /* region_ok[nbspins] */
	short		*cis_mode			= (short *)		argv[nbarg++]; /* cis_mode[nbspins] */
	int		*start				= (int *)		argv[nbarg++]; /* start[nbspins] */
	int		*solid				= (int *)		argv[nbarg++]; /* solid[nbspectres,nbcellules] */
	double		*deadtime			= (double *)		argv[nbarg++]; /* deadtime[2] */
	int		*sectorold			= (int *)		argv[nbarg++]; /* sectorold[nbspectres,nbcellules] */
	float		*duree_comptage			= (float *)		argv[nbarg++]; /* duree_comptage[nbspins] */ 
	int		*nb_accumulation 		= (int *)		argv[nbarg++]; /* nb_accumulation[nbspins] */
	int		*tabtheta			= (int *)		argv[nbarg++]; /* tabtheta[nbcellules] */
	int		*tabphi				= (int *)		argv[nbarg++]; /* tabphi[nbspectres] */
	int		*tab1ienergie			= (int *)		argv[nbarg++]; /* si spin_average=	1 alors tab1ienergie[nbspins]
															0       tab1ienergie[nbspins*nbspectres] */
	int		*tab2ienergie			= (int *)		argv[nbarg++]; /* si spin_average=	1 alors tab2ienergie[nbspins]
															0       tab2ienergie[nbspins*nbspectres] */
	int		*tabmass			= (int *)		argv[nbarg++]; /* tabmass[nbmasses] */
	int		*indY				= (int *)		argv[nbarg++]; /* si spin_average=	1 alors indY[nbspins]
															0       indY[nbspins*nbspectres] */
	int		*indC				= (int *)		argv[nbarg++]; /* indC[nbspins] */
	float		*Emin				= (float *)		argv[nbarg++]; /* Emin[nbtablesE,nbenergies] */
	float		*Emoy				= (float *)		argv[nbarg++]; /* Emoy[nbtablesE,nbenergies] */
	float		*Emax				= (float *)		argv[nbarg++]; /* Emax[nbtablesE,nbenergies] */
	double		*efficacite			= (double *)		argv[nbarg++]; /* efficacite[] */
	double		*facteurG			= (double *)		argv[nbarg++]; /* facteurG[] */
	char		*tabdata			= (char *)		argv[nbarg++];
	int		no1				= *(int *)		argv[nbarg++];
	int		*debut				= (int *)		argv[nbarg++];
	int		*fin				= (int *)		argv[nbarg++];
	float		*dico				= (float *)		argv[nbarg++];
	int		nbytes				= *(int *)		argv[nbarg++];
	float		*Z				= (float *)		argv[nbarg++]; /* si spin_average=	1 alors Z[nbspins,nbcellules] 
															0       Z[nbspins*nbspectres,nbcellules]*/
	int		*sectornew			= (int *)		argv[nbarg++]; /* sectornew[nbspectres,nbcellules] */
	double		sectornew_date			= *(double *)		argv[nbarg++];
	double		*xmin				= (double *)		argv[nbarg++]; /* xmin[nbspins] = datation de chaque spin */
	float		*Q				= (float *)		argv[nbarg++]; /* Q[nbmasses] */
	double		*MASSE				= (double *)		argv[nbarg++]; /* MASSE[nbmasses] */
	int		*start_pollution_solaire	= (int *)		argv[nbarg++]; /* start_pollution_solaire[nbspins] */
	int		*end_pollution_solaire		= (int *)		argv[nbarg++]; /* end_pollution_solaire[nbspins] */
	unsigned int	*sector_mask			= (unsigned int *)	argv[nbarg++]; /* sector_mask[nbspins] */
	size_t		*dataquick			= (size_t *)		argv[nbarg++];
	float		*IMA_NOISE			= (float *)		argv[nbarg++]; /* IMA_NOISE[nbenergies,nbmasses] */
	float		*IMA_MASS_MULT			= (float *)		argv[nbarg++]; /* IMA_MASS_MULT[nbmasses] */
	float		*IMA_POSITION1			= (float *)		argv[nbarg++]; /* IMA_POSITION1[nbspins,nbenergies,10] */
	float		*IMA_POSITION2			= (float *)		argv[nbarg++]; /* IMA_POSITION2[nbspins,nbenergies,10] */
	unsigned char	*IMA_PAC			= (unsigned char *)	argv[nbarg++]; /* IMA_PAC[nbspins] */
	unsigned char	*MEA_GEOMFACTOR			= (unsigned char *)	argv[nbarg++]; /* MEA_GEOMFACTOR[nbspins] */
	unsigned char	*MEA_DATAID			= (unsigned char *)	argv[nbarg++]; /* MEA_DATAID[nbspins] */
	int		nbX				= *(int *)		argv[nbarg++];
	int		nbY				= *(int *)		argv[nbarg++];
	int		*TABINFO_INT			= (int *)		argv[nbarg++];
	double		*TABINFO_DOUBLE			= (double *)		argv[nbarg++];
	short		*start_energy			= (short *)		argv[nbarg++]; /* start_energy[nbspins] */
	short		*end_energy			= (short *)		argv[nbarg++]; /* end_energy[nbspins] */
	IDL_STRING	*CL_ROOT			= (IDL_STRING *)	argv[nbarg++];

	/* remove bad channel pour ASPERA3:
		- pour imasse=0: suppression des coups
		- pour imasse=4,10,22: coup = (coup[imasse-1] + coup[imasse+1])/2
	*/

	/*
		Si tabmass[0] est negatif, cela signifie qu'il faut rechercher la masse suivante:
			-1:  H+
			-2:  He++
			-3:  He+
			-4:  O++
			-5:  O+
			-6:  CO+
			-7:  O2+
			-8:  CO2+
			-9:  Heavy
			-10: All
		Pour l'ion no, utiliser les masses de IMA_POSITION1[spin,energie,no]  IMA_POSITION2[spin,energie,no]
	*/

	/* 
		start [i]         = start [i] 
		solid [i,j]       = solid  [i + j*nbspectres] 
		sector [i,j]      = sector [i + j*nbspectres] 
		duree [i]         = duree [i] 
		Z[i,j]            = if spin_average	=1: Z [i + j*nbspins]
							=0: Z [i + j*nbspins*nbspectres]
	*/

	int		ienergie1;
	int		ienergie2;
	int		nospectre;
	int		y;
	int		imasse;
	float 		val;
	float		somme;
	float		accumulation_duree;
	double 		date;
	int		nb=0;	/* initialise a cause de gcc */
	float 		tab_somme[1024];
	int		nbcoups;
	unsigned char	*p;
	int		i;

	int		pollue;
	int		ind;
	unsigned char	*channelok=NULL;
	unsigned char	*liste=NULL;
	int		nbliste;
	int		pos1=0;
	int		pos2=0;

	int		ipac;
	int		igeomfactor;
	int		idataid;

	int		nbsomme;
	int		nbZ = nbX*nbY;

	if (nbarg != argc) return;

	DEBUT ();
	MAVEN_SWEA_CALIB_DEBUT();

	/* Remplissage de Z[*,*] avec F_INFINITY */
	for (i=0 ; i<nbZ ; i++)
		Z[i] = F_INFINITY;

	if (optimise) {

		/* Experience IMA */

		channelok = (unsigned char *) malloc (nbmasses);
		liste     = (unsigned char *) malloc (nbmasses*nbcellules*2);
		nbytes    = 2;
		p2        = (byte2 *)         malloc (nbenergies*nbcellules*nbspectres*nbmasses*nbytes);

		for (i=0 ; i<nbmasses ; i++)
			channelok[i]=1;
		if (is_IMA_ASPERA3(nocis) && nbmasses==32) {
			channelok[ 0]=0;
			channelok[ 4]=0;
			channelok[10]=0;
			channelok[22]=0;
		}

	}

	for (ispin=0 ; ispin<nbspins ; ispin++) {

		if (region_ok[ispin]==0) { 

			if (spin_average==0) {
				for (ispectre=0 ; ispectre<nbspectres ; ispectre++) {
					nospectre = ispin*nbspectres+ispectre;
					Z[nospectre]=1e34;
				}
			} else {
				Z[ispin]=1e34;
			}

			continue;

		}

		tabphi_to_okspectre (B, tabphi, nbspectres, start, ispin, produit1, prodmin, prodmax, okspectre, nocis);

		pollution_maj (nocis, ispin, cis_mode, start_pollution_solaire, end_pollution_solaire, nbspectres, nbcellules, nbangles, solid, pollution);

		if (is_ELS(nocis)) sector_mask_to_solid (sector_mask[ispin], nbcellules, solid);

		ipac			= IMA_PAC[ispin];
		igeomfactor		= MEA_GEOMFACTOR[ispin];
		idataid			= MEA_DATAID[ispin];
		icarte			= indC[ispin];
		isensitivity		= sensitivity[ispin];
		accumulation		= nb_accumulation[ispin];
		accumulation_duree	= accumulation*duree_comptage[ispin];
		date			= xmin[ispin];
		MAVEN_SWEA_CALIB_GET();
		sector			= date < sectornew_date ? sectorold : sectornew;
		p1			= get_p1(tabdata,no1);

		if (is_pad) GET_SOLID();

		if (optimise) {

			/* Experience IMA */

			bzero (p2, nbenergies*nbcellules*nbspectres*nbmasses*2);
			for (ienergie=0 ; ienergie<nbenergies ; ienergie++) {
				for (ispectre=0 ; ispectre<nbspectres ; ispectre++) {
					if ((p = (unsigned char *) dataquick[indice3(ienergie,ispectre,no1+ispin,nbenergies,nbspectres,INUTILE)]) != 0) {
						nbcoups = 256*p[0] + p[1];
						ind = 2;
						for (i=0 ; i<nbcoups ; i++, ind += 4) {
							icellule = p[ind+0];
							imasse   = p[ind+1];
							p2[nocoup] = 256*p[ind+2] + p[ind+3];
						}
					}
				}
			}
		} else {
			p2 = get_p2(tabdata,no1);
		}
		p4 = get_p4(tabdata,no1);
		pfloat = get_pfloat(tabdata,no1);
		pdouble = get_pdouble(tabdata,no1);

		if (!optimise) {

			/* Experience autre que IMA pour les traces time_theta. 
				Toutes les experiences (y compris IMA) pour les traces phi_theta */

			for (icellule=0 ; icellule<nbcellules ; icellule++) {

				if (tabtheta[icellule]==0) continue;
				somme=nb=nbsomme=0;
				y = icellule;
				for (ispectre=0 ; ispectre<nbspectres ; ispectre++) {

					nospectre = ispin*nbspectres+ispectre;
					itable = spin_average==0 ? indY[nospectre]:indY[ispin];
					if (itable==-1) continue;
					ienergie1 = spin_average==0 ? tab1ienergie[nospectre]:tab1ienergie[ispin];
					ienergie2 = spin_average==0 ? tab2ienergie[nospectre]:tab2ienergie[ispin];
					if (ienergie1==-1 || ienergie2==-1 || ienergie1>ienergie2) {
						if (spin_average==0) Z[nospectre + y*nbspectres*nbspins]=1e34;
						continue;
					}
					if (spin_average==0) somme=nb=nbsomme=0;
					if (okspectre[ispectre]==0) continue;
					/* Plus rapide en bouclant sur imasse puis sur ienergie plutot que l'inverse ! */
					for (imasse=0 ; imasse < nbmasses ; imasse++) {
						if (tabmass[imasse]==1 || tabmass[0]<0) {
							for (ienergie=ienergie1 ; ienergie<=ienergie2 ; ienergie++) {

								if (ienergie < start_energy[ispin]) continue;	// pour acclrer SOLAR_PAS
								if (ienergie > end_energy[ispin]) continue;	// pour acclrer SOLAR_PAS

								if (tabmass[0]<0) {
									pos1 = IMA_POSITION1[indice3(ispin,ienergie,-tabmass[0]-1,nbspins,nbenergies,INUTILE)] + 0.5; if (pos1<0) pos1=0;
									pos2 = IMA_POSITION2[indice3(ispin,ienergie,-tabmass[0]-1,nbspins,nbenergies,INUTILE)] + 0.5; if (pos2>nbmasses-1) pos2=nbmasses-1;
								}
								if (tabmass[imasse]==1 || (tabmass[0]<0 && imasse>=pos1 && imasse<=pos2)) {
									POLLUTION_ON (); if (pollue) continue;
									if (lire_eff && ((eff = get_eff) < -FILLVAL_E30)) continue;
									if (lire_fg && ((fg = get_fg ) < -FILLVAL_E30)) continue; // get_data_time_theta_cjf
									if (remove_bad_channel) {
										COUP_TO_CJF1_REMOVE_BAD_CHANNEL ();
									} else {
										COUP_TO_CJF1 (cjf);
										if (val < -FILLVAL_E30) continue;
									}
									if (remove_hghost) REMOVE_HGHOST ();
									somme += val;
									nbsomme++;
									if (div_cjf) nb++; /* J, f ou JE */
								}
							}
							if (spin_average==0) {
								if (nb) somme /= nb;
								if (nbsomme) Z[nospectre + y*nbspectres*nbspins]=somme;
							}
						}
					}
				}
				if (spin_average==1) {
					if (nb) somme /= nb;
					if (nbsomme) Z[ispin + y*nbspins] = somme;
				}
			}

		} else {

			/* Experience IMA */

			if (spin_average == 1) {
				for (icellule=0 ; icellule<nbcellules ; icellule++) {
					tab_somme[icellule] = 0;
				}
				nb = 0;
			}

			for (ispectre=0 ; ispectre<nbspectres ; ispectre++) {

				if (spin_average == 0) {
					for (icellule=0 ; icellule<nbcellules ; icellule++) {
						tab_somme[icellule] = 0;
					}
					nb = 0;
				}

				nospectre = ispin*nbspectres + ispectre;

				if (okspectre[ispectre]==0) continue;
				itable = spin_average==0 ? indY[nospectre]:indY[ispin];
				if (itable==-1) continue;
				ienergie1 = spin_average==0 ? tab1ienergie[nospectre]:tab1ienergie[ispin];
				ienergie2 = spin_average==0 ? tab2ienergie[nospectre]:tab2ienergie[ispin];
				for (ienergie=ienergie1 ; ienergie<=ienergie2 ; ienergie++) {

					if (tabmass[0]<0) {
						pos1 = IMA_POSITION1[indice3(ispin,ienergie,-tabmass[0]-1,nbspins,nbenergies,INUTILE)] + 0.5; if (pos1<0) pos1=0;
						pos2 = IMA_POSITION2[indice3(ispin,ienergie,-tabmass[0]-1,nbspins,nbenergies,INUTILE)] + 0.5; if (pos2>nbmasses-1) pos2=nbmasses-1;
					}

					nbliste = 0;
					/* Parcours des coups non nuls */
					if ((p = (unsigned char *) dataquick[indice3(ienergie,ispectre,no1+ispin,nbenergies,nbspectres,INUTILE)]) != 0) {
						nbcoups = 256*p[0] + p[1];
						for (i=0 ; i<nbcoups ; i++) {
							icellule = p[2+4*i+0];
							imasse   = p[2+4*i+1];
							if (channelok[imasse]==1) {
								liste[nbliste*2+0] = icellule;
								liste[nbliste*2+1] = imasse;
								nbliste++;
							}
						}
					}

					/* Rajout des channels qui posent probleme et dont le comptage peut devenir non nul */
					for (imasse=0 ; imasse<nbmasses ; imasse++) {
						if (channelok[imasse]==0) {
							for (icellule=0 ; icellule<nbcellules; icellule++) {
								liste[nbliste*2+0] = icellule;
								liste[nbliste*2+1] = imasse;
								nbliste++;
							}
						}
					}

					/* Parcours des coups qui sont dans liste */
					for (i=0 ; i<nbliste ; i++) { 
						icellule = liste[2*i+0];
						imasse   = liste[2*i+1];
						if (tabmass[imasse]==1 || (tabmass[0]<0 && imasse>=pos1 && imasse<=pos2)) {
							POLLUTION_ON (); if (pollue) continue;
							if (lire_eff && ((eff = get_eff) < -FILLVAL_E30)) continue;
							if (lire_fg && ((fg = get_fg ) < -FILLVAL_E30)) continue; // get_data_time_theta_cjf
							if (remove_bad_channel) {
								COUP_TO_CJF1_REMOVE_BAD_CHANNEL ();
							} else {
								COUP_TO_CJF1 (cjf);
								if (val < -FILLVAL_E30) continue;
							}
							if (remove_hghost) REMOVE_HGHOST ();
							tab_somme[icellule] += val;
						}
					}

					if (div_cjf) {
						for (imasse=0 ; imasse<nbmasses ; imasse++) {
							if (tabmass[imasse] != 0) {
								nb++; /* J, f ou JE */
							}
						}
					}
				}
				if (spin_average == 0) {
					for (icellule=0 ; icellule<nbcellules ; icellule++) {
						if (nb) tab_somme[icellule] /= nb;
						Z[nospectre + icellule*nbspectres*nbspins] = tab_somme[icellule];
					}
				}
			}
			if (spin_average == 1) {
				for (icellule=0 ; icellule<nbcellules ; icellule++) {
					if (nb) tab_somme[icellule] /= nb;
					Z[ispin + icellule*nbspins] = tab_somme[icellule];
				}
			}
		}
	}

	FIN ();
	MAVEN_SWEA_CALIB_FIN();

	if (optimise) free (channelok);
	if (optimise) free (liste);
	if (optimise) free (p2);

}


/*---------------------------------------------------------------------------*/
void GET_DATA_TIME_THETA_CJF_AUTO_GLUE (
/*---------------------------------------------------------------------------*/
	void	*p01,
	void	*p02,
	void	*p03,
	void	*p04,
	void	*p05,
	void	*p06,
	void	*p07,
	void	*p08,
	void	*p09,
	void	*p10,
	void	*p11,
	void	*p12,
	void	*p13,
	void	*p14,
	void	*p15,
	void	*p16,
	void	*p17,
	void	*p18,
	void	*p19,
	void	*p20,
	void	*p21,
	void	*p22,
	void	*p23,
	void	*p24,
	void	*p25,
	void	*p26,
	void	*p27,
	void	*p28,
	void	*p29,
	void	*p30,
	void	*p31,
	void	*p32,
	void	*p33,
	void	*p34,
	void	*p35,
	void	*p36,
	void	*p37,
	void	*p38,
	void	*p39,
	void	*p40,
	void	*p41,
	void	*p42,
	void	*p43,
	void	*p44,
	void	*p45,
	void	*p46,
	void	*p47,
	void	*p48,
	void	*p49,
	void	*p50,
	void	*p51,
	void	*p52,
	void	*p_CL_ROOT) {

	int		argc=53;
	void		*argv[53];
	IDL_STRING	*CL_ROOT;

	// p_CL_ROOT -> CL_ROOT
	CL_ROOT = malloc (sizeof(IDL_STRING));
	IDL_StrStore (CL_ROOT, p_CL_ROOT);

	argv[ 0] = p01;
	argv[ 1] = p02;
	argv[ 2] = p03;
	argv[ 3] = p04;
	argv[ 4] = p05;
	argv[ 5] = p06;
	argv[ 6] = p07;
	argv[ 7] = p08;
	argv[ 8] = p09;
	argv[ 9] = p10;
	argv[10] = p11;
	argv[11] = p12;
	argv[12] = p13;
	argv[13] = p14;
	argv[14] = p15;
	argv[15] = p16;
	argv[16] = p17;
	argv[17] = p18;
	argv[18] = p19;
	argv[19] = p20;
	argv[20] = p21;
	argv[21] = p22;
	argv[22] = p23;
	argv[23] = p24;
	argv[24] = p25;
	argv[25] = p26;
	argv[26] = p27;
	argv[27] = p28;
	argv[28] = p29;
	argv[29] = p30;
	argv[30] = p31;
	argv[31] = p32;
	argv[32] = p33;
	argv[33] = p34;
	argv[34] = p35;
	argv[35] = p36;
	argv[36] = p37;
	argv[37] = p38;
	argv[38] = p39;
	argv[39] = p40;
	argv[40] = p41;
	argv[41] = p42;
	argv[42] = p43;
	argv[43] = p44;
	argv[44] = p45;
	argv[45] = p46;
	argv[46] = p47;
	argv[47] = p48;
	argv[48] = p49;
	argv[49] = p50;
	argv[50] = p51;
	argv[51] = p52;
	argv[52] = CL_ROOT;
	GET_DATA_TIME_THETA_CJF (argc, argv);

	free (CL_ROOT);

}


/*---------------------------------------------------------------------------*/
void GET_DATA_TIME_PHI_CJF (int argc, void *argv[]) {
/*---------------------------------------------------------------------------*/

	/*
		Utilise dans les spectros time_phi
	*/

	int		nbarg				= 0;
	short		*sensitivity			= (short *)		argv[nbarg++]; /* sensitivity[nbspins] */
	short		*produit1			= (short *)		argv[nbarg++]; /* produit1[nbspins] */
	short		*mag				= (short *)		argv[nbarg++]; /* mag[nbspins] */
	int		*region_ok			= (int *)		argv[nbarg++]; /* region_ok[nbspins] */
	short		*cis_mode			= (short *)		argv[nbarg++]; /* cis_mode[nbspins] */
	int		*start				= (int *)		argv[nbarg++]; /* start[nbspins] */
	int		*solid				= (int *)		argv[nbarg++]; /* solid[nbspectres,nbcellules] */
	double		*deadtime			= (double *)		argv[nbarg++]; /* deadtime[2] */
	int		*sectorold			= (int *)		argv[nbarg++]; /* sectorold[nbspectres,nbcellules] */
	float		*duree_comptage			= (float *)		argv[nbarg++]; /* duree_comptage[nbspins] */ 
	int		*nb_accumulation		= (int *)		argv[nbarg++]; /* nb_accumulation[nbspins] */
	int		*tabtheta			= (int *)		argv[nbarg++]; /* tabtheta[nbspectres] */
	int		*tabphi				= (int *)		argv[nbarg++]; /* tabphi[nbspectres] */
	int		*tab1ienergie			= (int *)		argv[nbarg++]; /* si spin_average=	1 alors tab1ienergie[nbspins]
															0       tab1ienergie[nbspins*nbspectres] */
	int		*tab2ienergie			= (int *)		argv[nbarg++]; /* si spin_average=	1 alors tab2ienergie[nbspins]
															0       tab2ienergie[nbspins*nbspectres] */
	int		*tabmass			= (int *)		argv[nbarg++]; /* tabmass[nbmasses] */
	int		*indY				= (int *)		argv[nbarg++]; /* si spin_average=	1 alors indY[nbspins]
															0       indY[nbspins*nbspectres] */
	int		*indC				= (int *)		argv[nbarg++]; /* indC[nbspins] */
	float		*Emin				= (float *)		argv[nbarg++]; /* Emin[nbtablesE,nbenergies] */
	float		*Emoy				= (float *)		argv[nbarg++]; /* Emoy[nbtablesE,nbenergies] */
	float		*Emax				= (float *)		argv[nbarg++]; /* Emax[nbtablesE,nbenergies] */
	double		*efficacite			= (double *)		argv[nbarg++]; /* efficacite[] */
	double		*facteurG			= (double *)		argv[nbarg++]; /* facteurG[] */
	char		*tabdata			= (char *)		argv[nbarg++];
	int		no1				= *(int *)		argv[nbarg++];
	int		*debut				= (int *)		argv[nbarg++];
	int		*fin				= (int *)		argv[nbarg++];
	float		*dico				= (float *)		argv[nbarg++];
	int		nbytes				= *(int *)		argv[nbarg++];
	float		*Z				= (float *)		argv[nbarg++]; /* si spin_average=	1 alors Z[nbspins,nbspectres] 
															0       Z[nbspins*nbspectres,nbspectres]*/
	short		*phase				= (short *)		argv[nbarg++]; /* phase[nbspins] */
	short		*phases				= (short *)		argv[nbarg++]; /* si spin_average=	1 alors phases[nbspins] 
															0       phases[nbspins*nbspectres]*/
	int		*sectornew			= (int *)		argv[nbarg++]; /* sectornew[nbspectres,nbcellules] */
	double		sectornew_date			= *(double *)		argv[nbarg++];
	double		*xmin				= (double *)		argv[nbarg++]; /* xmin[nbspins] = datation de chaque spin */
	float		*Q				= (float *)		argv[nbarg++]; /* Q[nbmasses] */
	double		*MASSE				= (double *)		argv[nbarg++]; /* MASSE[nbmasses] */
	int		*start_pollution_solaire	= (int *)		argv[nbarg++]; /* start_pollution_solaire[nbspins] */
	int		*end_pollution_solaire		= (int *)		argv[nbarg++]; /* end_pollution_solaire[nbspins] */
	unsigned int 	*sector_mask			= (unsigned int *)	argv[nbarg++]; /* sector_mask[nbspins] */
	size_t		*dataquick			= (size_t *)		argv[nbarg++];
	float		*IMA_NOISE			= (float *)		argv[nbarg++]; /* IMA_NOISE[nbenergies,nbmasses] */
	float		*IMA_MASS_MULT			= (float *)		argv[nbarg++]; /* IMA_MASS_MULT[nbmasses] */
	float		*IMA_POSITION1			= (float *)		argv[nbarg++]; /* IMA_POSITION1[nbspins,nbenergies,10] */
	float		*IMA_POSITION2			= (float *)		argv[nbarg++]; /* IMA_POSITION2[nbspins,nbenergies,10] */
	unsigned char	*IMA_PAC			= (unsigned char *)	argv[nbarg++]; /* IMA_PAC[nbspins] */
	unsigned char	*MEA_GEOMFACTOR			= (unsigned char *)	argv[nbarg++]; /* MEA_GEOMFACTOR[nbspins] */
	unsigned char	*MEA_DATAID			= (unsigned char *)	argv[nbarg++]; /* MEA_DATAID[nbspins] */
	int		nbX				= *(int *)		argv[nbarg++];
	int		nbY				= *(int *)		argv[nbarg++];
	int		*TABINFO_INT			= (int *)		argv[nbarg++];
	double		*TABINFO_DOUBLE			= (double *)		argv[nbarg++];
	short		*start_energy			= (short *)		argv[nbarg++]; /* start_energy[nbspins] */
	short		*end_energy			= (short *)		argv[nbarg++]; /* end_energy[nbspins] */
	IDL_STRING	*CL_ROOT			= (IDL_STRING *)	argv[nbarg++];

	/* remove bad channel pour ASPERA3:
		- pour imasse=0: suppression des coups
		- pour imasse=4,10,22: coup = (coup[imasse-1] + coup[imasse+1])/2
	*/

	/*
		Si tabmass[0] est negatif, cela signifie qu'il faut rechercher la masse suivante:
			-1:  H+
			-2:  He++
			-3:  He+
			-4:  O++
			-5:  O+
			-6:  CO+
			-7:  O2+
			-8:  CO2+
			-9:  Heavy
			-10: All
		Pour l'ion no, utiliser les masses de IMA_POSITION1[spin,energie,no]  IMA_POSITION2[spin,energie,no]
	*/

	/* 
	start [i]         = start [i] 
	solid [i,j]       = solid  [i + j*nbspectres] 
	sector [i,j]      = sector [i + j*nbspectres] 
	duree [i]         = duree [i] 
	Z[i,j]            = if spin_average	=1: Z [i + j*nbspins]
						=0: Z [i + j*nbspins*nbspectres]
	*/

	int		ienergie1;
	int		ienergie2;
	int		nospectre;
	int		y;
	int		imasse;
	float		val;
	float		somme;
	float		accumulation_duree;
	double		date;
	int		nb;
	int		nbcoups;
	unsigned char	*p;
	int		i;

	int		pollue;
	int		ind;
	unsigned char	*channelok=NULL;
	unsigned char	*liste=NULL;
	int		nbliste;
	int		pos1=0;
	int		pos2=0;

	int		ipac;
	int		igeomfactor;
	int		idataid;
	int		nbsomme;
	int		nbZ = nbX*nbY;

	if (nbarg != argc) return;

	DEBUT ();
	MAVEN_SWEA_CALIB_DEBUT();

	/* Remplissage de Z[*,*] avec F_INFINITY */
	for (i=0 ; i<nbZ ; i++)
		Z[i] = F_INFINITY;

	if (optimise) {

		/* Experience IMA */

		channelok = (unsigned char *) malloc (nbmasses);
		liste     = (unsigned char *) malloc (nbmasses*nbcellules*2);
		nbytes    = 2;
		p2        = (byte2 *)         malloc (nbenergies*nbcellules*nbspectres*nbmasses*nbytes);
	
		for (i=0 ; i<nbmasses ; i++)
			channelok[i]=1;
		if (is_IMA_ASPERA3(nocis) && nbmasses==32) {
			channelok[ 0]=0;
			channelok[ 4]=0;
			channelok[10]=0;
			channelok[22]=0;
		}

	}

	for (ispin=0 ; ispin<nbspins ; ispin++) {

		if (region_ok[ispin]==0) { 

			if (spin_average==0) {
				for (ispectre=0 ; ispectre<nbspectres ; ispectre++) {
					nospectre = ispin*nbspectres+ispectre;
					Z[nospectre]=1e34;
				}
			} else {
				Z[ispin]=1e34;
			}

			continue;

		}

		tabphi_to_okspectre (B, tabphi, nbspectres, start, ispin, produit1, prodmin, prodmax, okspectre, nocis);

		pollution_maj (nocis, ispin, cis_mode, start_pollution_solaire, end_pollution_solaire, nbspectres, nbcellules, nbangles, solid, pollution);

		if (is_ELS(nocis)) sector_mask_to_solid (sector_mask[ispin], nbcellules, solid);

		ipac			= IMA_PAC[ispin];
		igeomfactor		= MEA_GEOMFACTOR[ispin];
		idataid			= MEA_DATAID[ispin];
		icarte			= indC[ispin];
		isensitivity		= sensitivity[ispin];
		accumulation		= nb_accumulation[ispin];
		accumulation_duree	= accumulation*duree_comptage[ispin];
		date			= xmin[ispin];
		MAVEN_SWEA_CALIB_GET();
		sector			= date < sectornew_date ? sectorold : sectornew;
		p1			= get_p1(tabdata,no1);

		if (is_pad) GET_SOLID();

		if (optimise) {

			/* Experience IMA */

			bzero (p2, nbenergies*nbcellules*nbspectres*nbmasses*2);
			for (ienergie=0 ; ienergie<nbenergies ; ienergie++) {
				for (ispectre=0 ; ispectre<nbspectres ; ispectre++) {
					if ((p = (unsigned char *) dataquick[indice3(ienergie,ispectre,no1+ispin,nbenergies,nbspectres,INUTILE)]) != 0) {
						nbcoups = 256*p[0] + p[1];
						ind = 2;
						for (i=0 ; i<nbcoups ; i++, ind += 4) {
							icellule = p[ind+0];
							imasse   = p[ind+1];
							p2[nocoup] = 256*p[ind+2] + p[ind+3];
						}
					}
				}
			}
		} else {
			p2 = get_p2(tabdata,no1);
		}
		p4 = get_p4(tabdata,no1);
		pfloat = get_pfloat(tabdata,no1);
		pdouble = get_pdouble(tabdata,no1);

		if (!optimise) {

			/* Experience autre que IMA */

			if (spin_average==1) phases[ispin] = phase[ispin];
			for (ispectre=0 ; ispectre<nbspectres ; ispectre++) {

				if (okspectre[ispectre]==0) continue;
				somme=nb=nbsomme=0;
				y = ispectre;
				nospectre = ispin*nbspectres+ispectre;
				itable = spin_average==0 ? indY[nospectre]:indY[ispin];
				if (itable==-1) continue;
				ienergie1 = spin_average==0 ? tab1ienergie[nospectre]:tab1ienergie[ispin];
				ienergie2 = spin_average==0 ? tab2ienergie[nospectre]:tab2ienergie[ispin];
				if (spin_average==0) phases[nospectre]=phase[ispin];
				if (ienergie1==-1 || ienergie2==-1 || ienergie1>ienergie2) {
					if (spin_average==0) Z[nospectre + y*nbspectres*nbspins]=1e34;
					continue;
				}
				/* Plus rapide en bouclant sur ienergie puis sur imasse puis sur icellule */
				for (ienergie=ienergie1 ; ienergie<=ienergie2 ; ienergie++) {

					if (ienergie < start_energy[ispin]) continue;	// pour acclrer SOLAR_PAS
					if (ienergie > end_energy[ispin]) continue;	// pour acclrer SOLAR_PAS

					for (imasse=0 ; imasse < nbmasses ; imasse++) {
						if (tabmass[imasse] == 0) continue;
						for (icellule=0 ; icellule<nbcellules ; icellule++) {

							if (tabtheta[icellule]==0) continue;
							POLLUTION_ON (); if (pollue) continue;
							if (lire_eff && ((eff = get_eff) < -FILLVAL_E30)) continue;
							if (lire_fg && ((fg = get_fg ) < -FILLVAL_E30)) continue; // get_data_time_phi_cjf
							if (remove_bad_channel) {
								COUP_TO_CJF1_REMOVE_BAD_CHANNEL ();
							} else {
								COUP_TO_CJF1 (cjf);
								if (val < -FILLVAL_E30) continue;
							}
							if (remove_hghost) REMOVE_HGHOST ();
							somme += val;
							nbsomme++;
							if (div_cjf) nb++; /* J, f ou JE */
						}
					}
				}
				if (nb) somme /= nb;
				if (nbsomme) {
					if (spin_average) {
						Z[ispin + y*nbspins] = somme;
					} else {
						Z[nospectre + y*nbspectres*nbspins]=somme;
					}
				}
			}

		} else {

			/* Experience IMA */

			for (ispectre=0 ; ispectre<nbspectres ; ispectre++) {
				somme = nb = 0;
				if (okspectre[ispectre]==0) continue;
				nospectre = ispin*nbspectres+ispectre;
				itable = spin_average==0 ? indY[nospectre]:indY[ispin];
				if (itable==-1) continue;
				ienergie1 = spin_average==0 ? tab1ienergie[nospectre]:tab1ienergie[ispin];
				ienergie2 = spin_average==0 ? tab2ienergie[nospectre]:tab2ienergie[ispin];
				for (ienergie=ienergie1 ; ienergie<=ienergie2 ; ienergie++) {

					if (tabmass[0]<0) {
						pos1 = IMA_POSITION1[indice3(ispin,ienergie,-tabmass[0]-1,nbspins,nbenergies,INUTILE)] + 0.5; if (pos1<0) pos1=0;
						pos2 = IMA_POSITION2[indice3(ispin,ienergie,-tabmass[0]-1,nbspins,nbenergies,INUTILE)] + 0.5; if (pos2>nbmasses-1) pos2=nbmasses-1;
					}

					nbliste = 0;
					/* Parcours des coups non nuls */
					if ((p = (unsigned char *) dataquick[indice3(ienergie,ispectre,no1+ispin,nbenergies,nbspectres,INUTILE)]) != 0) {
						nbcoups = 256*p[0] + p[1];
						for (i=0 ; i<nbcoups ; i++) {
							icellule = p[2+4*i+0];
							imasse   = p[2+4*i+1];
							if (channelok[imasse]==1) {
								liste[nbliste*2+0] = icellule;
								liste[nbliste*2+1] = imasse;
								nbliste++;
							}
						}
					}

					/* Rajout des channels qui posent probleme et dont le comptage peut devenir non nul */
					for (imasse=0 ; imasse<nbmasses ; imasse++) {
						if (channelok[imasse]==0) {
							for (icellule=0 ; icellule<nbcellules; icellule++) {
								liste[nbliste*2+0] = icellule;
								liste[nbliste*2+1] = imasse;
								nbliste++;
							}
						}
					}

					/* Parcours des coups qui sont dans liste */
					for (i=0 ; i<nbliste ; i++) { 
						icellule = liste[2*i+0];
						imasse   = liste[2*i+1];
						if (tabtheta[icellule] && (tabmass[imasse]==1 || (tabmass[0]<0 && imasse>=pos1 && imasse<=pos2))) {
							POLLUTION_ON (); if (pollue) continue;
							if (lire_eff && ((eff = get_eff) < -FILLVAL_E30)) continue;
							if (lire_fg && ((fg = get_fg ) < -FILLVAL_E30)) continue; // get_data_time_phi_cjf
							if (remove_bad_channel) {
								COUP_TO_CJF1_REMOVE_BAD_CHANNEL ();
							} else {
								COUP_TO_CJF1 (cjf);
								if (val < -FILLVAL_E30) continue;
							}
							if (remove_hghost) REMOVE_HGHOST ();
							somme += val;
						}
					}
			
					if (div_cjf) {
						for (icellule=0 ; icellule<nbcellules ; icellule++) {
							if (tabtheta[icellule]) {
								for (imasse=0 ; imasse<nbmasses ; imasse++) {
									if (tabmass[imasse] != 0) {
										nb++; /* J, f ou JE */
									}
								}
							}
						}
					}
				}
				if (nb) somme /= nb;
				if (spin_average) {
					Z[ispin + ispectre*nbspins] = somme;
				} else {
					Z[nospectre + ispectre*nbspectres*nbspins] = somme;
				}
			}

		}

	}

	FIN ();
	MAVEN_SWEA_CALIB_FIN();

	if (optimise) free (channelok);
	if (optimise) free (liste);
	if (optimise) free (p2);

}

/*---------------------------------------------------------------------------*/
void GET_DATA_TIME_PHI_CJF_AUTO_GLUE (
/*---------------------------------------------------------------------------*/
	void	*p01,
	void	*p02,
	void	*p03,
	void	*p04,
	void	*p05,
	void	*p06,
	void	*p07,
	void	*p08,
	void	*p09,
	void	*p10,
	void	*p11,
	void	*p12,
	void	*p13,
	void	*p14,
	void	*p15,
	void	*p16,
	void	*p17,
	void	*p18,
	void	*p19,
	void	*p20,
	void	*p21,
	void	*p22,
	void	*p23,
	void	*p24,
	void	*p25,
	void	*p26,
	void	*p27,
	void	*p28,
	void	*p29,
	void	*p30,
	void	*p31,
	void	*p32,
	void	*p33,
	void	*p34,
	void	*p35,
	void	*p36,
	void	*p37,
	void	*p38,
	void	*p39,
	void	*p40,
	void	*p41,
	void	*p42,
	void	*p43,
	void	*p44,
	void	*p45,
	void	*p46,
	void	*p47,
	void	*p48,
	void	*p49,
	void	*p50,
	void	*p51,
	void	*p52,
	void	*p53,
	void	*p54,
	void	*p_CL_ROOT) {

	int		argc=55;
	void		*argv[55];
	IDL_STRING	*CL_ROOT;

	// p_CL_ROOT -> CL_ROOT
	CL_ROOT = malloc (sizeof(IDL_STRING));
	IDL_StrStore (CL_ROOT, p_CL_ROOT);

	argv[ 0] = p01;
	argv[ 1] = p02;
	argv[ 2] = p03;
	argv[ 3] = p04;
	argv[ 4] = p05;
	argv[ 5] = p06;
	argv[ 6] = p07;
	argv[ 7] = p08;
	argv[ 8] = p09;
	argv[ 9] = p10;
	argv[10] = p11;
	argv[11] = p12;
	argv[12] = p13;
	argv[13] = p14;
	argv[14] = p15;
	argv[15] = p16;
	argv[16] = p17;
	argv[17] = p18;
	argv[18] = p19;
	argv[19] = p20;
	argv[20] = p21;
	argv[21] = p22;
	argv[22] = p23;
	argv[23] = p24;
	argv[24] = p25;
	argv[25] = p26;
	argv[26] = p27;
	argv[27] = p28;
	argv[28] = p29;
	argv[29] = p30;
	argv[30] = p31;
	argv[31] = p32;
	argv[32] = p33;
	argv[33] = p34;
	argv[34] = p35;
	argv[35] = p36;
	argv[36] = p37;
	argv[37] = p38;
	argv[38] = p39;
	argv[39] = p40;
	argv[40] = p41;
	argv[41] = p42;
	argv[42] = p43;
	argv[43] = p44;
	argv[44] = p45;
	argv[45] = p46;
	argv[46] = p47;
	argv[47] = p48;
	argv[48] = p49;
	argv[49] = p50;
	argv[50] = p51;
	argv[51] = p52;
	argv[52] = p53;
	argv[53] = p54;
	argv[54] = CL_ROOT;
	GET_DATA_TIME_PHI_CJF (argc, argv);

	free (CL_ROOT);

}


/*---------------------------------------------------------------------------*/
void GET_DATA_DISTRIBUTION_PHASE1 (int argc, void *argv[]) {
/*---------------------------------------------------------------------------*/

	int		nbarg				= 0;
	short		*sensitivity			= (short *)		argv[nbarg++]; /* sensitivity[nbspins] */
	short		*produit1			= (short *)		argv[nbarg++]; /* produit1[nbspins] */
	short		*cis_mode			= (short *)		argv[nbarg++]; /* cis_mode[1] */
	int		*start				= (int *)		argv[nbarg++]; /* start[1] */
	int		*solid				= (int *)		argv[nbarg++]; /* solid[nbspectres,nbcellules] */
	double		*deadtime			= (double *)		argv[nbarg++]; /* deadtime[2] */
	int		*sectorold			= (int *)		argv[nbarg++]; /* sectorold[nbspectres,nbcellules] */
	float		*duree_comptage			= (float *)		argv[nbarg++]; /* duree_comptage[1] */ 
	int		*nb_accumulation		= (int *)		argv[nbarg++]; /* nb_accumulation[1] */
	int		*tabtheta			= (int *)		argv[nbarg++]; /* tabtheta[nbcellules] */
	int		*tabphi				= (int *)		argv[nbarg++]; /* tabphi[nbspectres] */
	int		*tabenergy			= (int *)		argv[nbarg++]; /* tabenergy[nbenergies] */
	int		*tabmass			= (int *)		argv[nbarg++]; /* tabmass[nbmasses] */
	int		*indY				= (int *)		argv[nbarg++]; /* indY[nbspectres] */
	int		*indC				= (int *)		argv[nbarg++]; /* indC[nbspins] */
	int		Ecroissant			= *(int *)		argv[nbarg++]; /* Ecroissant */
	float		*Emin				= (float *)		argv[nbarg++]; /* Emin[nbtablesE,nbenergies] */
	float		*Emoy				= (float *)		argv[nbarg++]; /* Emoy[nbtablesE,nbenergies] */
	float		*Emax				= (float *)		argv[nbarg++]; /* Emax[nbtablesE,nbenergies] */
	double 		*efficacite			= (double *)		argv[nbarg++]; /* efficacite[] */
	double 		*facteurG			= (double *)		argv[nbarg++]; /* facteurG[] */
	char		*tabdata			= (char *)		argv[nbarg++];
	int		no1				= *(int *)		argv[nbarg++];
	int		*debut				= (int *)		argv[nbarg++];
	int		*fin				= (int *)		argv[nbarg++];
	float		*dico				= (float *)		argv[nbarg++];
	int		nbytes				= *(int *)		argv[nbarg++];
	float		*Z				= (float *)		argv[nbarg++]; /* Z[nbcellules,nbspectres,nbenergies] */
	float		*Zun				= (float *)		argv[nbarg++]; /* Zun[nbcellules,nbspectres,nbenergies] */
	int		*sectornew			= (int *)		argv[nbarg++]; /* sectornew[nbspectres,nbcellules] */
	double 		sectornew_date			= *(double *)		argv[nbarg++];
	double 		*xmin				= (double *)		argv[nbarg++]; /* xmin[nbspins] = datation de chaque spin */
	float		*Q				= (float *)		argv[nbarg++]; /* Q[nbmasses] */
	double 		*MASSE				= (double *)		argv[nbarg++]; /* MASSE[nbmasses] */
	short		*mag				= (short *)		argv[nbarg++]; /* mag[nbspins] */
	int		*start_pollution_solaire	= (int *)		argv[nbarg++]; /* start_pollution_solaire[nbspins] */
	int		*end_pollution_solaire		= (int *)		argv[nbarg++]; /* end_pollution_solaire[nbspins] */
	unsigned int	*sector_mask			= (unsigned int *)	argv[nbarg++]; /* sector_mask[nbspins] */
	unsigned char	*IMA_PAC			= (unsigned char *)	argv[nbarg++]; /* IMA_PAC[nbspins] */
	unsigned char	*MEA_GEOMFACTOR			= (unsigned char *)	argv[nbarg++]; /* MEA_GEOMFACTOR[nbspins] */
	unsigned char	*MEA_DATAID			= (unsigned char *)	argv[nbarg++]; /* MEA_DATAID[nbspins] */
	int		*TABINFO_INT			= (int *)		argv[nbarg++];
	double		*TABINFO_DOUBLE			= (double *)		argv[nbarg++];
	IDL_STRING	*CL_ROOT			= (IDL_STRING *)	argv[nbarg++];


	/* 
		start [i]                   = start [i] 
		solid [i,j]                 = solid [i + j*nbspectres] 
		sector [i,j]                = sector[i + j*nbspectres] 
		duree [i]                   = duree [i] 
		Z [cellule,spectre,energie] = Z [indice3(cellule,spectre,energie,nbcellules,nbspectres,nbenergies)]
	*/

	float		val;
	float		accumulation_duree;
	double		date;
	int		imasse;

	int		pollue;

	int		ipac;
	int		igeomfactor;
	int		idataid;

	if (nbarg != argc) return;

	DEBUT ();
	MAVEN_SWEA_CALIB_DEBUT();

	ispin			= 0;
	ipac			= IMA_PAC[ispin];
	igeomfactor		= MEA_GEOMFACTOR[ispin];
	idataid			= MEA_DATAID[ispin];
	isensitivity		= sensitivity[ispin];
	accumulation		= nb_accumulation[ispin];
	accumulation_duree	= accumulation*duree_comptage[ispin];
	p1			= get_p1(tabdata,no1);
	p2			= get_p2(tabdata,no1);
	p4			= get_p4(tabdata,no1);
	pfloat			= get_pfloat(tabdata,no1);
	pdouble			= get_pdouble(tabdata,no1);

	if (is_pad) GET_SOLID();

	tabphi_to_okspectre (B, tabphi, nbspectres, start, ispin, produit1, prodmin, prodmax, okspectre, nocis);

	pollution_maj (nocis, ispin, cis_mode, start_pollution_solaire, end_pollution_solaire, nbspectres, nbcellules, nbangles, solid, pollution);

	if (is_ELS(nocis)) sector_mask_to_solid (sector_mask[ispin], nbcellules, solid);

	itable = indY[ispin];
	icarte = indC[ispin];
	date = xmin[ispin];
	MAVEN_SWEA_CALIB_GET();
	sector = date < sectornew_date ? sectorold : sectornew;

	if (itable != -1) {

		for (ienergie=0 ; ienergie<nbenergies ; ienergie++) {

			if (tabenergy[ienergie]==0) continue;

			for (ispectre=0 ; ispectre<nbspectres ; ispectre++) {

				if (tabphi[ispectre]==0) continue;

				for (icellule=0 ; icellule<nbcellules ; icellule++) {

					if (tabtheta[icellule]==0) continue;

					// 201903215: ne plus mettre 0 dans Z et Zun  cause de JUNO_JADEE:
					// sinon il sera impossible dans PHASE2 de savoir si le comptage valait FILLVAL
					// Pour JUNO_JADEE_HRS le comptage vaut FILLVAL pour (phi=0 pour et anodes 16..31) et pour (phi=1 et anodes 0..15)

					//Z [indice3(icellule,ispectre,nbenergies-1-ienergie,nbcellules,nbspectres,nbenergies)] = 0;
					//Zun [indice3(icellule,ispectre,nbenergies-1-ienergie,nbcellules,nbspectres,nbenergies)] = 0;

					if (okspectre[ispectre]==0) continue; /* Mettre ce test apres la mise a 0 de Z sinon pb dans phase 2 */

					for (imasse=0 ; imasse < nbmasses ; imasse++) {

						if (tabmass[imasse] == 0) continue;

						POLLUTION_ON (); if (pollue) continue;	/* cellule pollue: elle ne sera pas visualise */
						if (lire_eff && ((eff = get_eff) < -FILLVAL_E30)) continue;
						if (lire_fg && ((fg = get_fg ) < -FILLVAL_E30)) continue; // get_data_distribution_phase1

						/* Zun contient les flux associs  un coup de tlmesure gal  1 */
						val = 1;
						COUP_TO_CJF (cjf);
						if (Ecroissant) {
							Zun[indice3(icellule,ispectre,nbenergies-1-ienergie,nbcellules,nbspectres,nbenergies)] = val;
						} else {
							Z [indice3(icellule,ispectre,nbenergies-1-ienergie,nbcellules,nbspectres,nbenergies)] = val;
						}

						COUP_TO_CJF1 (cjf);
						if (val < -FILLVAL_E30) continue;

						if (Ecroissant) {
							// Energies croissantes dans le fichier: ex MMS et JUNO
							Z [indice3(icellule,ispectre,ienergie,nbcellules,nbspectres,nbenergies)] = val;
						} else {
							// Energies dcroissantes dans le fichier: ex CLUSTER
							Z [indice3(icellule,ispectre,nbenergies-1-ienergie,nbcellules,nbspectres,nbenergies)] = val;
						}

					}
				}
			}

		}
	}

	FIN ();

}

/*---------------------------------------------------------------------------*/
void GET_DATA_DISTRIBUTION_PHASE1_AUTO_GLUE (
/*---------------------------------------------------------------------------*/
	void	*p01,
	void	*p02,
	void	*p03,
	void	*p04,
	void	*p05,
	void	*p06,
	void	*p07,
	void	*p08,
	void	*p09,
	void	*p10,
	void	*p11,
	void	*p12,
	void	*p13,
	void	*p14,
	void	*p15,
	void	*p16,
	void	*p17,
	void	*p18,
	void	*p19,
	void	*p20,
	void	*p21,
	void	*p22,
	void	*p23,
	void	*p24,
	void	*p25,
	void	*p26,
	void	*p27,
	void	*p28,
	void	*p29,
	void	*p30,
	void	*p31,
	void	*p32,
	void	*p33,
	void	*p34,
	void	*p35,
	void	*p36,
	void	*p37,
	void	*p38,
	void	*p39,
	void	*p40,
	void	*p41,
	void	*p42,
	void	*p43,
	void	*p_CL_ROOT) {

	int		argc=44;
	void		*argv[44];
	IDL_STRING	*CL_ROOT;

	// p_CL_ROOT -> CL_ROOT
	CL_ROOT = malloc (sizeof(IDL_STRING));
	IDL_StrStore (CL_ROOT, p_CL_ROOT);

	argv[ 0] = p01;
	argv[ 1] = p02;
	argv[ 2] = p03;
	argv[ 3] = p04;
	argv[ 4] = p05;
	argv[ 5] = p06;
	argv[ 6] = p07;
	argv[ 7] = p08;
	argv[ 8] = p09;
	argv[ 9] = p10;
	argv[10] = p11;
	argv[11] = p12;
	argv[12] = p13;
	argv[13] = p14;
	argv[14] = p15;
	argv[15] = p16;
	argv[16] = p17;
	argv[17] = p18;
	argv[18] = p19;
	argv[19] = p20;
	argv[20] = p21;
	argv[21] = p22;
	argv[22] = p23;
	argv[23] = p24;
	argv[24] = p25;
	argv[25] = p26;
	argv[26] = p27;
	argv[27] = p28;
	argv[28] = p29;
	argv[29] = p30;
	argv[30] = p31;
	argv[31] = p32;
	argv[32] = p33;
	argv[33] = p34;
	argv[34] = p35;
	argv[35] = p36;
	argv[36] = p37;
	argv[37] = p38;
	argv[38] = p39;
	argv[39] = p40;
	argv[40] = p41;
	argv[41] = p42;
	argv[42] = p43;
	argv[43] = CL_ROOT;
	GET_DATA_DISTRIBUTION_PHASE1 (argc, argv);

	free (CL_ROOT);

}


/*---------------------------------------------------------------------------*/
void GET_DATA_DISTRIBUTION_PHASE2 (int argc, void *argv[]) {
/*---------------------------------------------------------------------------*/

	int	nbarg		= 0;
	int	nbcellules	= *(int *)	argv[nbarg++]; 
	int	nbspectres	= *(int *)	argv[nbarg++]; 
	int	nbenergies	= *(int *)	argv[nbarg++]; 
	float	*thetamin	= (float *)	argv[nbarg++]; /* thetamin[nbcellules,nbenergies] en deg */
	float	*thetamoy	= (float *)	argv[nbarg++]; /* thetamoy[nbcellules,nbenergies] en deg */
	float	*thetamax	= (float *)	argv[nbarg++]; /* thetamax[nbcellules,nbenergies] en deg */
	float	*phimin		= (float *)	argv[nbarg++]; /* phimin[nbspectres,nbenergies] en deg */
	float	*phimoy		= (float *)	argv[nbarg++]; /* phimoy[nbspectres,nbenergies] en deg */
	float	*phimax		= (float *)	argv[nbarg++]; /* phimax[nbspectres,nbenergies] en deg */
	float	*Vmin		= (float *)	argv[nbarg++]; /* Vmin[nbenergies] en km/sec */
	float	*Vmoy		= (float *)	argv[nbarg++]; /* Vmoy[nbenergies] en km/sec */
	float	*Vmax		= (float *)	argv[nbarg++]; /* Vmax[nbenergies] en km/sec */
	float	*Z		= (float *)	argv[nbarg++]; /* Z[nbcellules,nbspectres,nbenergies] */
	float	*Zun		= (float *)	argv[nbarg++]; /* Zun[nbcellules,nbspectres,nbenergies] */
	float	*P		= (float *)	argv[nbarg++]; /* P[3] */
	double	*Aorg		= (double *)	argv[nbarg++]; /* Aorg[4,4] Aorg[i,j]=Aorg[i+4*j] */
	double	*A		= (double *)	argv[nbarg++]; /* A[4,4] */
	int	*INDX		= (int *)	argv[nbarg++]; /* INDX[4] */
	double	*X2D		= (double *)	argv[nbarg++]; /* X2D[9,nbcellules*nbspectres*nbenergies] */
	double	*Y2D		= (double *)	argv[nbarg++]; /* Y2D[9,nbcellules*nbspectres*nbenergies] */
	double	*X3D		= (double *)	argv[nbarg++]; /* X3D[9,nbcellules*nbspectres*nbenergies] */
	double	*Y3D		= (double *)	argv[nbarg++]; /* Y3D[9,nbcellules*nbspectres*nbenergies] */
	double	*Z3D		= (double *)	argv[nbarg++]; /* Z3D[9,nbcellules*nbspectres*nbenergies] */
	float	*coups		= (float *)	argv[nbarg++]; /* coups[nbcellules*nbspectres*nbenergies] */
	float	*coupsun	= (float *)	argv[nbarg++]; /* coupsun[nbcellules*nbspectres*nbenergies] */
	int	*traite		= (int *)	argv[nbarg++]; /* traite[nbcellules*nbspectres*nbenergies] */
	int	is3D		= *(int *)	argv[nbarg++]; 
	double	*mindistmin	= (double *)	argv[nbarg++];
	float	infini		= *(float *)	argv[nbarg++];
	int	nbframes	= *(int *)	argv[nbarg++]; /*	une frame: VOLUME contient les donnees projetees sur le plan
									plusieurs frames: VOLUME contient les vraies donnees */
	int	*erreur		= (int *)	argv[nbarg++]; /* code erreur retourne -1: erreur dans malloc */
	float	xmin2d		= *(float *)	argv[nbarg++];
	float	xmax2d		= *(float *)	argv[nbarg++];
	int	nbx2d		= *(int *)	argv[nbarg++];
	float	ymin2d		= *(float *)	argv[nbarg++];
	float	ymax2d		= *(float *)	argv[nbarg++];
	int	nby2d		= *(int *)	argv[nbarg++];
	float	zmin2d		= *(float *)	argv[nbarg++];
	float	zmax2d		= *(float *)	argv[nbarg++];
	int	nbz2d		= *(int *)	argv[nbarg++];
	float	*image2d	= (float *)	argv[nbarg++]; /* image2d[nbx2d,nby2d] */
	int	maillage	= *(int *)	argv[nbarg++]; 
	int	VparVperp	= *(int *)	argv[nbarg++]; 
	int	ordre_cluster	= *(int *)	argv[nbarg++];
	int	nox		= *(int *)	argv[nbarg++];
	int	noy		= *(int *)	argv[nbarg++];
	int	noz		= *(int *)	argv[nbarg++];
	float	*Vx		= (float *)	argv[nbarg++]; /* km/sec */
	float	*Vy		= (float *)	argv[nbarg++]; /* km/sec */
	float	*Vz		= (float *)	argv[nbarg++]; /* km/sec */
	int 	nocis		= *(int *)	argv[nbarg++];

	double	tabX[9];
	double	tabY[9];
	double	tabZ[9];
	double	distmin;
	double	distmax;
	double	tab3D[3][9];
	double	*cos_latmin;
	double	*cos_latmoy;
	double	*cos_latmax;
	double	*sin_latmin;
	double	*sin_latmoy;
	double	*sin_latmax;
	double	*cos_longmin;
	double	*cos_longmoy;
	double	*cos_longmax;
	double	*sin_longmin;
	double	*sin_longmoy;
	double	*sin_longmax;
	int	icellule;
	int	ispectre;
	int	ienergie;
	int	i;
	int	i1=0;	/* initialise a cause de gcc */
	int	j;
	int	j1;
	int	k;
	int	nb;
	int	no=0;
	int	no1=0;
	int	ind;
	double	x2d;
	double	y2d;
	double	z2d;
	double	x3d;
	double	y3d;
	double	z3d;
	double	dx2d;
	double	dy2d;
	double	dz2d;
	double	theta_valeur;
	double	phi_valeur;
	double	vcarre_valeur;
	int	theta_no=-1;
	int	phi_no=-1;
	int	v_no=-1;
	int	nb2d;
	int	ind2d;
	int	ind3d;
	double	navance;
	double	avance=0;
	float	*Vcarremin;
	float	*Vcarremax;
	int	*nombre2d=NULL;
	int	ix;
	int	iy;
	double	x;
	double	y;
	float	Vmaxi=0;
	float	ymin2dorg;
	float	ymax2dorg;
	double	dy2dorg;
	int	nby2dorg;
	float	xmin2dorg;
	float	xmax2dorg;
	double	dx2dorg;
	int	nbx2dorg;
	int	nbptsenx;

	int	nblatitudes;
	int	nblongitudes;
	int	ilatitude;
	int	ilongitude;
	int	indice_latitude;
	int	indice_longitude;
	int	k1;

	double	dx;
	double	dy;

	if (nbarg != argc) return;

	if (Vx[0] < -FILLVAL_E30) Vx[0]=0;	// on ne connait pas la vitesse
	if (Vy[0] < -FILLVAL_E30) Vy[0]=0;	// on ne connait pas la vitesse
	if (Vz[0] < -FILLVAL_E30) Vz[0]=0;	// on ne connait pas la vitesse

	if (VparVperp!=1 && maillage) {

		if ((Vcarremin = (float *)malloc(nbenergies*sizeof(float))) == NULL || (Vcarremax = (float *)malloc(nbenergies*sizeof(float))) == NULL) {
			*erreur=-1;
			return;
		}

		for (i=0 ; i<nbenergies ; i++) {
			Vcarremin[i] = Vmin[i]*Vmin[i];
			Vcarremax[i] = Vmax[i]*Vmax[i];
			if (Vmax[i] > Vmaxi)
				Vmaxi = Vmax[i];
		}

		xmin2dorg = xmin2d;
		xmax2dorg = xmax2d;
		ymin2dorg = ymin2d;
		ymax2dorg = ymax2d;
		dy2dorg = (ymax2d-ymin2d)/(double) nby2d;
		dx2dorg = (xmax2d-xmin2d)/(double) nbx2d;
		nbx2dorg = nbx2d;
		nby2dorg = nby2d;

		if (VparVperp==2) {
	
			// on va balayer tout l'espace (Vpar1, Vpar2, Vperp) entre -Vmaxi et +Vmaxi
			// de (xmin=-Vmaxi,xmax=Vmaxi), (ymin=-Vmaxi,ymax=Vmaxi), (zmin=-Vmaxi,zmax=Vmaxi)

			if ((nombre2d = (int *)calloc(nbx2d*nby2d,sizeof(int))) == NULL) { /* initialise a 0 */
				*erreur=-1;
				return;
			}

			xmin2d = -Vmaxi;
			xmax2d = Vmaxi;

			ymin2d = -Vmaxi;
			ymax2d = Vmaxi;

			zmin2d = -Vmaxi;
			zmax2d = Vmaxi;

			nbx2d = (int) ((xmax2d-xmin2d)/dx2dorg);
			nby2d = nbx2d;
			nbz2d = nbx2d;

		}

		dx2d = (xmax2d-xmin2d)/(double) nbx2d;
		dy2d = (ymax2d-ymin2d)/(double) nby2d;
		dz2d = (zmax2d-zmin2d)/(double) nbz2d;

		nbptsenx = VparVperp==2 ? nbx2dorg : nbx2d;

		for (i=0 ; i<nbptsenx ; i++) {
			x2d = VparVperp==2 ? (xmin2dorg + (i+0.5)*(xmax2dorg-xmin2dorg)/nbx2dorg) : (xmin2d + dx2d*(0.5+i));
			if (VparVperp==2) {
				i1 = (x2d-xmin2dorg)/dx2dorg;
			}
			navance=100.*(1+nby2d*i)/(nbx2d*nby2d);
			navance=100.*i/nbptsenx;
			if (navance - avance >= 10) {
				avance = navance;
				//printf ("%6.2f %% Vx=%f Vy=%f Vz=%f\n",avance,Vx[0],Vy[0],Vz[0]);
			}
			for (j=0 ; j<nby2d ; j++) {
				y2d = ymin2d + dy2d*(0.5+j);
				nb2d = 0;
				ind2d = indice2 (i,j,nbx2d,nby2d);

				for (k=0 ; k<nbz2d ; k++) {

					/* Vecteurs de base du plan de projection:
						- en X: [Aorg[1,1], Aorg[2,1], Aorg[3,1]]
						- en Y: [Aorg[1,2], Aorg[2,2], Aorg[3,2]]
						- en Z: [Aorg[1,3], Aorg[2,3], Aorg[3,3]] */

					z2d = zmin2d + dz2d*(0.5+k);

					// Passage de (Vpar1, Vpar2, Vperp)  (Vx, Vy, Vz)
					x3d = P[0] + x2d*Aorg[1+4*1] + y2d*Aorg[1+4*2] + z2d*Aorg[1+4*3];
					y3d = P[1] + x2d*Aorg[2+4*1] + y2d*Aorg[2+4*2] + z2d*Aorg[2+4*3];
					z3d = P[2] + x2d*Aorg[3+4*1] + y2d*Aorg[3+4*2] + z2d*Aorg[3+4*3];

					x3d += Vx[0];	// 
					y3d += Vy[0];	// 
					z3d += Vz[0];	// 

					vcarre_valeur = x3d*x3d + y3d*y3d + z3d*z3d;

					if ( (v_no = tab_to_no (Vcarremin, Vcarremax, nbenergies, vcarre_valeur, v_no, 0)) != -1) {
						if (cartesien_to_theta_phi (x3d, y3d, z3d, ordre_cluster, nox, noy, noz, &theta_valeur, &phi_valeur) != -1) {
							if ( (theta_no = tab_to_no (thetamin+v_no*nbcellules, thetamax+v_no*nbcellules, nbcellules, theta_valeur, theta_no, 1)) != -1) {

								// Pour JUNO-JADEE il peut y avoir 2 phi valables, mais un seul avec un comptage ne valant pas FILLVAL
								if ( (phi_no = tab_to_no (phimin+v_no*nbspectres, phimax+v_no*nbspectres, nbspectres, phi_valeur, phi_no, 1)) != -1 ) {
									ind3d = indice3 (theta_no,phi_no,v_no,nbcellules,nbspectres,nbenergies);
									if (is_JUNO_JADEE(nocis)) {
										if (nonfini(Z[ind3d],infini)) {
											if (phi_no==0) {
												// Est-ce que phi_no==1 conviendrai ?
												if ( (phi_no = tab_to_no (phimin+v_no*nbspectres+1, phimax+v_no*nbspectres+1, nbspectres-1, phi_valeur, phi_no, 1)) != -1 ) {
													phi_no++;
													ind3d = indice3 (theta_no,phi_no,v_no,nbcellules,nbspectres,nbenergies);
												}
											}
										}
									}
									if (fini(Z[ind3d],infini)) {
										if (VparVperp==2) {
											j1 = (sqrt(y2d*y2d+z2d*z2d)-ymin2dorg)/dy2dorg;
											if (i1>=0 && i1<nbx2dorg && j1>=0 && j1<nby2dorg) {
												ind2d = indice2 (i1,j1,nbx2dorg,nby2dorg);
												if (nombre2d[ind2d]==0) {
													image2d[ind2d] = Z[ind3d];
												} else {
													image2d[ind2d] += Z[ind3d];
												}

												nombre2d[ind2d]++;
											}
										} else {
											if (nb2d==0) {
												image2d[ind2d] = Z[ind3d];
											} else {
												image2d[ind2d] += Z[ind3d];
											}
											nb2d++;
										}
									}
			
								}
							}
						}
					}
				} /* for k */

				if (VparVperp==0) {
					if (nb2d!=0) image2d[ind2d] /= nb2d;
				}
			} /* for j */
		} /* for i */

		if (VparVperp==2) {
			for (ind2d=0 ; ind2d<nbx2dorg*nby2dorg ; ind2d++)
				if (nombre2d[ind2d] >= 2)
					image2d[ind2d] /= nombre2d[ind2d];
		}

		free (Vcarremin);
		free (Vcarremax);
		*erreur=0;
		return;
	}

	nblatitudes  = ordre_cluster ? nbcellules : nbspectres;
	nblongitudes = ordre_cluster ? nbspectres : nbcellules;

	if (	(cos_latmin  = (double *)malloc(nblatitudes* nbenergies*sizeof(double))) == NULL ||
		(cos_latmoy  = (double *)malloc(nblatitudes* nbenergies*sizeof(double))) == NULL ||
		(cos_latmax  = (double *)malloc(nblatitudes* nbenergies*sizeof(double))) == NULL ||
		(sin_latmin  = (double *)malloc(nblatitudes* nbenergies*sizeof(double))) == NULL ||
		(sin_latmoy  = (double *)malloc(nblatitudes* nbenergies*sizeof(double))) == NULL ||
		(sin_latmax  = (double *)malloc(nblatitudes* nbenergies*sizeof(double))) == NULL ||
		(cos_longmin = (double *)malloc(nblongitudes*nbenergies*sizeof(double))) == NULL ||
		(cos_longmoy = (double *)malloc(nblongitudes*nbenergies*sizeof(double))) == NULL ||
		(cos_longmax = (double *)malloc(nblongitudes*nbenergies*sizeof(double))) == NULL ||
		(sin_longmin = (double *)malloc(nblongitudes*nbenergies*sizeof(double))) == NULL ||
		(sin_longmoy = (double *)malloc(nblongitudes*nbenergies*sizeof(double))) == NULL ||
		(sin_longmax = (double *)malloc(nblongitudes*nbenergies*sizeof(double))) == NULL) {

		*erreur=-1;
		return;
	}

	for (ilatitude=0 ; ilatitude<nblatitudes ; ilatitude++) {
		for (ienergie=0 ; ienergie<nbenergies ; ienergie++) {
			indice_latitude = indice2(ilatitude,ienergie,nblatitudes,nbenergies);
			cos_latmin[indice_latitude] = cos ((ordre_cluster ? thetamin[indice_latitude] : phimin[indice_latitude]) * M_PI/180.);
			cos_latmoy[indice_latitude] = cos ((ordre_cluster ? thetamoy[indice_latitude] : phimoy[indice_latitude]) * M_PI/180.);
			cos_latmax[indice_latitude] = cos ((ordre_cluster ? thetamax[indice_latitude] : phimax[indice_latitude]) * M_PI/180.);
			sin_latmin[indice_latitude] = sin ((ordre_cluster ? thetamin[indice_latitude] : phimin[indice_latitude]) * M_PI/180.);
			sin_latmoy[indice_latitude] = sin ((ordre_cluster ? thetamoy[indice_latitude] : phimoy[indice_latitude]) * M_PI/180.);
			sin_latmax[indice_latitude] = sin ((ordre_cluster ? thetamax[indice_latitude] : phimax[indice_latitude]) * M_PI/180.);
		}
	}

	for (ilongitude=0 ; ilongitude<nblongitudes ; ilongitude++) {
		for (ienergie=0 ; ienergie<nbenergies ; ienergie++) {
			indice_longitude = indice2(ilongitude,ienergie,nblongitudes,nbenergies);
			cos_longmin[indice_longitude] = cos ((ordre_cluster ? phimin[indice_longitude] : thetamin[indice_longitude]) * M_PI/180.);
			cos_longmoy[indice_longitude] = cos ((ordre_cluster ? phimoy[indice_longitude] : thetamoy[indice_longitude]) * M_PI/180.);
			cos_longmax[indice_longitude] = cos ((ordre_cluster ? phimax[indice_longitude] : thetamax[indice_longitude]) * M_PI/180.);
			sin_longmin[indice_longitude] = sin ((ordre_cluster ? phimin[indice_longitude] : thetamin[indice_longitude]) * M_PI/180.);
			sin_longmoy[indice_longitude] = sin ((ordre_cluster ? phimoy[indice_longitude] : thetamoy[indice_longitude]) * M_PI/180.);
			sin_longmax[indice_longitude] = sin ((ordre_cluster ? phimax[indice_longitude] : thetamax[indice_longitude]) * M_PI/180.);
		}
	}

	if ((nombre2d = (int *)calloc(nbx2d*nby2d,sizeof(int))) == NULL) { /* initialis a 0 */
		*erreur=-1;
		return;
	}

	*mindistmin=-1;
	for (icellule=0 ; icellule<nbcellules ; icellule++) {
		for (ispectre=0 ; ispectre<nbspectres ; ispectre++) {
			for (ienergie=0 ; ienergie<nbenergies ; ienergie++) {

				ind=indice3(icellule,ispectre,ienergie,nbcellules,nbspectres,nbenergies);
				if (!fini(Z[ind],infini)) continue;

				ilatitude  = ordre_cluster ? icellule : ispectre;
				ilongitude = ordre_cluster ? ispectre : icellule;

				indice_latitude = indice2(ilatitude,ienergie,nblatitudes,nbenergies);
				indice_longitude = indice2(ilongitude,ienergie,nblongitudes,nbenergies);

				tab3D[nox][0] = cos_latmin[indice_latitude]*cos_longmin[indice_longitude]*Vmin[ienergie] - Vx[0];
				tab3D[noy][0] = cos_latmin[indice_latitude]*sin_longmin[indice_longitude]*Vmin[ienergie] - Vy[0];
				tab3D[noz][0] = sin_latmin[indice_latitude]*                              Vmin[ienergie] - Vz[0];

				tab3D[nox][1] = cos_latmin[indice_latitude]*cos_longmin[indice_longitude]*Vmax[ienergie] - Vx[0];
				tab3D[noy][1] = cos_latmin[indice_latitude]*sin_longmin[indice_longitude]*Vmax[ienergie] - Vy[0];
				tab3D[noz][1] = sin_latmin[indice_latitude]*                              Vmax[ienergie] - Vz[0];

				tab3D[nox][2] = cos_latmin[indice_latitude]*cos_longmax[indice_longitude]*Vmax[ienergie] - Vx[0];
				tab3D[noy][2] = cos_latmin[indice_latitude]*sin_longmax[indice_longitude]*Vmax[ienergie] - Vy[0];
				tab3D[noz][2] = sin_latmin[indice_latitude]*                              Vmax[ienergie] - Vz[0];

				tab3D[nox][3] = cos_latmin[indice_latitude]*cos_longmax[indice_longitude]*Vmin[ienergie] - Vx[0];
				tab3D[noy][3] = cos_latmin[indice_latitude]*sin_longmax[indice_longitude]*Vmin[ienergie] - Vy[0];
				tab3D[noz][3] = sin_latmin[indice_latitude]*                              Vmin[ienergie] - Vz[0];

				tab3D[nox][4] = cos_latmax[indice_latitude]*cos_longmin[indice_longitude]*Vmin[ienergie] - Vx[0];
				tab3D[noy][4] = cos_latmax[indice_latitude]*sin_longmin[indice_longitude]*Vmin[ienergie] - Vy[0];
				tab3D[noz][4] = sin_latmax[indice_latitude]*                              Vmin[ienergie] - Vz[0];

				tab3D[nox][5] = cos_latmax[indice_latitude]*cos_longmin[indice_longitude]*Vmax[ienergie] - Vx[0];
				tab3D[noy][5] = cos_latmax[indice_latitude]*sin_longmin[indice_longitude]*Vmax[ienergie] - Vy[0];
				tab3D[noz][5] = sin_latmax[indice_latitude]*                              Vmax[ienergie] - Vz[0];

				tab3D[nox][6] = cos_latmax[indice_latitude]*cos_longmax[indice_longitude]*Vmax[ienergie] - Vx[0];
				tab3D[noy][6] = cos_latmax[indice_latitude]*sin_longmax[indice_longitude]*Vmax[ienergie] - Vy[0];
				tab3D[noz][6] = sin_latmax[indice_latitude]*                              Vmax[ienergie] - Vz[0];

				tab3D[nox][7] = cos_latmax[indice_latitude]*cos_longmax[indice_longitude]*Vmin[ienergie] - Vx[0];
				tab3D[noy][7] = cos_latmax[indice_latitude]*sin_longmax[indice_longitude]*Vmin[ienergie] - Vy[0];
				tab3D[noz][7] = sin_latmax[indice_latitude]*                              Vmin[ienergie] - Vz[0];

				tab3D[nox][8] = cos_latmoy[indice_latitude]*cos_longmoy[indice_longitude]*Vmoy[ienergie] - Vx[0];
				tab3D[noy][8] = cos_latmoy[indice_latitude]*sin_longmoy[indice_longitude]*Vmoy[ienergie] - Vy[0];
				tab3D[noz][8] = sin_latmoy[indice_latitude]*                              Vmoy[ienergie] - Vz[0];

				if (is3D==1) {
					X3D[indice2(8,no1,9,nbcellules*nbsepctres*nbenergies)] = tab3D[0][8] - Vx[0];
					Y3D[indice2(8,no1,9,nbcellules*nbsepctres*nbenergies)] = tab3D[1][8] - Vy[0];
					Z3D[indice2(8,no1,9,nbcellules*nbsepctres*nbenergies)] = tab3D[2][8] - Vz[0];
					coups[no1]=Z[ind];
					coupsun[no1]=Zun[ind];
					no1++;
					continue;
				}

				for (i=0 ; i<9 ; i++) { 
					/* Coordonnees dans le repre dfini par le plan de coupe */

					projection_sur_plan (P, A, INDX, tab3D[0][i], tab3D[1][i], tab3D[2][i], &tabX[i], &tabY[i], &tabZ[i]);

					//if (ienergie==10) {
					//	printf ("icellule=%d ispectre=%d ienergie=%d ilat=%d ilong=%d Vmin=%e Vmax=%e (%e , %e , %e) -> (%e , %e , %e)\n",
					//		icellule,ispectre,ienergie,ilat,ilong,Vmin[ienergie],Vmax[ienergie],tab3D[0][i], tab3D[1][i], tab3D[2][i], tabX[i], tabY[i], tabZ[i]);
					//	printf ("thetamin[ilat]=%e cos_latmin[ilat]=%e cos_longmin[ilong]=%e Vmin[ienergie]=%e Vx[0]=%e\n",
					//		thetamin[ilat],cos_latmin[ilat],cos_longmin[ilong],Vmin[ienergie],Vx[0]);
					//}
				}

				distmin = tabZ[0];
				distmax = tabZ[0];
				for (i=1 ; i<9 ; i++) {
					if (tabZ[i]<distmin) distmin=tabZ[i];
					if (tabZ[i]>distmax) distmax=tabZ[i];
				}
				//printf ("distmin=%e distmax=%e zmin2d=%f zmax2d=%e\n",distmin,distmax,zmin2d,zmax2d);
				if (distmin>0 && (*mindistmin<0 || distmin<*mindistmin)) *mindistmin=distmin;

				if (VparVperp || (distmin<=zmax2d && distmax>=zmin2d)) {
					/* Si la cellule appartient au plan de coupe */
					//printf ("icellule=%d ispectre=%d ienergie=%d appartient au plan de coupe\n",icellule,ispectre,ienergie);
					for (i=0 ; i<9 ; i++) {
						coups[no]=Z[ind];

						/* Coordonnees 2D dans le plan de coupe */
						X2D[indice2(i,no,9,nbcellules*nbsepctres*nbenergies)]=tabX[i];
						if (VparVperp==1) {
							Y2D[indice2(i,no,9,nbcellules*nbsepctres*nbenergies)]=sqrt(tabY[i]*tabY[i]+tabZ[i]*tabZ[i]);	/* Vperp */
						} else {
							Y2D[indice2(i,no,9,nbcellules*nbsepctres*nbenergies)]=tabY[i];
						}

						/* Coordonnees 3D dans le repre dfini par le plan de coupe */
						X3D[indice2(i,no,9,nbcellules*nbsepctres*nbenergies)] = P[0] + tabX[i]*Aorg[1+4*1] + tabY[i]*Aorg[1+4*2] - Vx[0];
						Y3D[indice2(i,no,9,nbcellules*nbsepctres*nbenergies)] = P[1] + tabX[i]*Aorg[2+4*1] + tabY[i]*Aorg[2+4*2] - Vy[0];
						Z3D[indice2(i,no,9,nbcellules*nbsepctres*nbenergies)] = P[2] + tabX[i]*Aorg[3+4*1] + tabY[i]*Aorg[3+4*2] - Vz[0];

						if (nbframes >=2) {
							/* On rajoute sa composante en Z pour les animations uniquement */
							X3D[indice2(i,no,9,nbcellules*nbsepctres*nbenergies)] += tabZ[i]*Aorg[1+4*3] - Vx[0];
							Y3D[indice2(i,no,9,nbcellules*nbsepctres*nbenergies)] += tabZ[i]*Aorg[2+4*3] - Vy[0];
							Z3D[indice2(i,no,9,nbcellules*nbsepctres*nbenergies)] += tabZ[i]*Aorg[3+4*3] - Vz[0];
						}
					}
					no++;
				}
			}
		}
	}

	if (VparVperp) {

		for (i=0 ; i<no ; i++) {

			x = X2D[indice2(8,i,9,nbcellules*nbsepctres*nbenergies)];	/* abscisse dans le plan de coupe */
			y = Y2D[indice2(8,i,9,nbcellules*nbsepctres*nbenergies)];	/* ordonnee dans le plan de coupe */

			ix = (x - xmin2d) / ((xmax2d - xmin2d) / nbx2d);		/* indice en abscisse dans l'image */
			iy = (y - ymin2d) / ((ymax2d - ymin2d) / nby2d);		/* indice en ordonnee dans l'image */

			if (ix >=0 && ix <nbx2d && iy>=0 && iy<nby2d) {

				if (nombre2d[indice2(ix,iy,nbx2d,nby2d)] == 0) {
					image2d[indice2(ix,iy,nbx2d,nby2d)] = coups[i];
				} else {
					image2d[indice2(ix,iy,nbx2d,nby2d)] += coups[i];
				}
				nombre2d[indice2(ix,iy,nbx2d,nby2d)] ++;

			}

		}

	} else if (is3D==0) {

		for (i=0 ; i<no ; i++) {
			if (traite[i]==0) {
				traite[i]=1;
				nb=1;
				for (j=i+1 ; j<no ; j++) {
					if (traite[j]==0) {

						dx = X2D[indice2(8,i,9,nbcellules*nbsepctres*nbenergies)] - X2D[indice2(8,j,9,nbcellules*nbsepctres*nbenergies)];
						dy = Y2D[indice2(8,i,9,nbcellules*nbsepctres*nbenergies)] - Y2D[indice2(8,j,9,nbcellules*nbsepctres*nbenergies)];
						// janvier 2021: utilisation de fabs(dx) et fabs(dy)
						// A partir de 1e-13, idl et gdl ne marchent pas bien pour /home/penou/DATA/CLUSTER/SOFT/CLL3/resource/cluster_distributions_h1.cl.gz
						// message idl: TRIANGULATE: Points are co-linear, no solution
						// OK pour IDL et FDL et triangle
						if (fabs(dx)<1e-5 && fabs(dy)<1e-5) {

							// Les points i et j sont  peu prs  la mme place
							// On fait la somme des valeurs
							traite[j]=2;
							if (fini(coups[j],infini)) {
								if (!fini(coups[i],infini)) {
									coups[i] = coups[j];
								} else {
									coups[i] += coups[j];
									nb++;
								}
							}
						}
					}
				}
				coups[i] /= nb;
			}
		}

	}

	free (cos_latmin);
	free (cos_latmoy);
	free (cos_latmax);
	free (sin_latmin);
	free (sin_latmoy);
	free (sin_latmax);
	free (cos_longmin);
	free (cos_longmoy);
	free (cos_longmax);
	free (sin_longmin);
	free (sin_longmoy);
	free (sin_longmax);
	free (nombre2d);

	*erreur=0;
	return;

}

/*---------------------------------------------------------------------------*/
void GET_DATA_DISTRIBUTION_PHASE2_AUTO_GLUE (
/*---------------------------------------------------------------------------*/
	void	*p01,
	void	*p02,
	void	*p03,
	void	*p04,
	void	*p05,
	void	*p06,
	void	*p07,
	void	*p08,
	void	*p09,
	void	*p10,
	void	*p11,
	void	*p12,
	void	*p13,
	void	*p14,
	void	*p15,
	void	*p16,
	void	*p17,
	void	*p18,
	void	*p19,
	void	*p20,
	void	*p21,
	void	*p22,
	void	*p23,
	void	*p24,
	void	*p25,
	void	*p26,
	void	*p27,
	void	*p28,
	void	*p29,
	void	*p30,
	void	*p31,
	void	*p32,
	void	*p33,
	void	*p34,
	void	*p35,
	void	*p36,
	void	*p37,
	void	*p38,
	void	*p39,
	void	*p40,
	void	*p41,
	void	*p42,
	void	*p43,
	void	*p44,
	void	*p45,
	void	*p46,
	void	*p47,
	void	*p48,
	void	*p49,
	void	*p50,
	void	*p51) {

	int	argc=51;
	void	*argv[51];

	argv[ 0] = p01;
	argv[ 1] = p02;
	argv[ 2] = p03;
	argv[ 3] = p04;
	argv[ 4] = p05;
	argv[ 5] = p06;
	argv[ 6] = p07;
	argv[ 7] = p08;
	argv[ 8] = p09;
	argv[ 9] = p10;
	argv[10] = p11;
	argv[11] = p12;
	argv[12] = p13;
	argv[13] = p14;
	argv[14] = p15;
	argv[15] = p16;
	argv[16] = p17;
	argv[17] = p18;
	argv[18] = p19;
	argv[19] = p20;
	argv[20] = p21;
	argv[21] = p22;
	argv[22] = p23;
	argv[23] = p24;
	argv[24] = p25;
	argv[25] = p26;
	argv[26] = p27;
	argv[27] = p28;
	argv[28] = p29;
	argv[29] = p30;
	argv[30] = p31;
	argv[31] = p32;
	argv[32] = p33;
	argv[33] = p34;
	argv[34] = p35;
	argv[35] = p36;
	argv[36] = p37;
	argv[37] = p38;
	argv[38] = p39;
	argv[39] = p40;
	argv[40] = p41;
	argv[41] = p42;
	argv[42] = p43;
	argv[43] = p44;
	argv[44] = p45;
	argv[45] = p46;
	argv[46] = p47;
	argv[47] = p48;
	argv[48] = p49;
	argv[49] = p50;
	argv[50] = p51;
	GET_DATA_DISTRIBUTION_PHASE2 (argc, argv);

}

/*---------------------------------------------------------------------------*/
void GET_DATA_TIME_PITCHANGLE_CJF (int argc, void *argv[]) {
/*---------------------------------------------------------------------------*/

	int		nbarg				= 0;
	int		is_time_energy			= *(int *)		argv[nbarg++]; /* 1=trac time_energy pour amin<=pitch<=amax 0=time_pithangle classique */
	short		*sensitivity			= (short *)		argv[nbarg++]; /* sensitivity[nbspins] */
	short		*produit1			= (short *)		argv[nbarg++]; /* produit1[nbspins] */
	short		*mag				= (short *)		argv[nbarg++]; /* mag[nbspins] */
	int		*region_ok			= (int *)		argv[nbarg++]; /* region_ok[nbspins] */
	short		*cis_mode			= (short *)		argv[nbarg++]; /* cis_mode[nbspins] */
	int		*start				= (int *)		argv[nbarg++]; /* start[nbspins] */
	int		*solid				= (int *)		argv[nbarg++]; /* solid[nbspectres,nbcellules] */
	double		*deadtime			= (double *)		argv[nbarg++]; /* deadtime[2] */
	int		*sectorold			= (int *)		argv[nbarg++]; /* sectorold[nbspectres,nbcellules] */
	float		*duree_comptage			= (float *)		argv[nbarg++]; /* duree_comptage[nbspins] */ 
	int		*nb_accumulation		= (int *)		argv[nbarg++]; /* nb_accumulation[nbspins] */
	int		*tabtheta			= (int *)		argv[nbarg++]; /* tabtheta[nbspectres] */
	int		*tabphi				= (int *)		argv[nbarg++]; /* tabphi[nbspectres] */
	int		*tab1ienergie			= (int *)		argv[nbarg++]; /* si spin_average=	1 alors tab1ienergie[nbspins]
															0       tab1ienergie[nbspins*nbspectres] */
	int		*tab2ienergie			= (int *)		argv[nbarg++]; /* si spin_average=	1 alors tab2ienergie[nbspins]
															0       tab2ienergie[nbspins*nbspectres] */
	int		*tabmass			= (int *)		argv[nbarg++]; /* tabmass[nbmasses] */
	int		*indY				= (int *)		argv[nbarg++]; /* si spin_average=	1 alors indY[nbspins]
															0       indY[nbspins*nbspectres] */
	int		*indC				= (int *)		argv[nbarg++]; /* indC[nbspins] */
	float		*Emin				= (float *)		argv[nbarg++]; /* Emin[nbtablesE,nbenergies] */
	float		*Emoy				= (float *)		argv[nbarg++]; /* Emoy[nbtablesE,nbenergies] */
	float		*Emax				= (float *)		argv[nbarg++]; /* Emax[nbtablesE,nbenergies] */
	double		*efficacite			= (double *)		argv[nbarg++]; /* efficacite[] */
	double		*facteurG			= (double *)		argv[nbarg++]; /* facteurG[] */
	char		*tabdata			= (char *)		argv[nbarg++];
	int		no1				= *(int *)		argv[nbarg++];
	int		*debut				= (int *)		argv[nbarg++];
	int		*fin				= (int *)		argv[nbarg++];
	float		*dico				= (float *)		argv[nbarg++];
	int		nbytes				= *(int *)		argv[nbarg++];
	float		*Z				= (float *)		argv[nbarg++]; /* si spin_average=	1 alors Z[nbspins,nbspectres] 
															0       Z[nbspins*nbspectres,nbspectres]*/
	int		*sectornew			= (int *)		argv[nbarg++]; /* sectornew[nbspectres,nbcellules] */
	double		sectornew_date			= *(double *)		argv[nbarg++];
	double		*xmin				= (double *)		argv[nbarg++]; /* xmin[nbspins] = datation de chaque spin */
	float		*Q				= (float *)		argv[nbarg++]; /* Q[nbmasses] */
	double		*MASSE				= (double *)		argv[nbarg++]; /* MASSE[nbmasses] */
	float		*tabBx				= (float *)		argv[nbarg++]; /* tabBx[nbspins] */
	float		*tabBy				= (float *)		argv[nbarg++]; /* tabBy[nbspins] */
	float		*tabBz				= (float *)		argv[nbarg++]; /* tabBz[nbspins] */
	int		nbalphas			= *(int *)		argv[nbarg++];
	float		*phimin				= (float *)		argv[nbarg++]; /* phimin[nbspins,nbspectres] en rad */
	float		*phimoy				= (float *)		argv[nbarg++]; /* phimoy[nbspins,nbspectres] en rad */
	float		*phimax				= (float *)		argv[nbarg++]; /* phimax[nbspins,nbspectres] en rad */
	float		*thetamin			= (float *)		argv[nbarg++]; /* thetamin[nbspins,nbcellules] en rad */
	float		*thetamoy			= (float *)		argv[nbarg++]; /* thetamoy[nbspins,nbcellules] en rad */
	float		*thetamax			= (float *)		argv[nbarg++]; /* thetamax[nbspins,nbcellules] en rad */
	int		*start_pollution_solaire	= (int *)		argv[nbarg++]; /* start_pollution_solaire[nbspins] */
	int		*end_pollution_solaire		= (int *)		argv[nbarg++]; /* end_pollution_solaire[nbspins] */
	unsigned int	*sector_mask			= (unsigned int *)	argv[nbarg++]; /* sector_mask[nbspins] */
	int		pad_thetaB			= *(int *)		argv[nbarg++]; /* 0=toutes les cellules, 1=juste les 2 cellules qui voient B */
	size_t		*dataquick			= (size_t *)		argv[nbarg++];
	float		*IMA_NOISE			= (float *)		argv[nbarg++]; /* IMA_NOISE[nbenergies,nbmasses] */
	float		*IMA_MASS_MULT			= (float *)		argv[nbarg++]; /* IMA_MASS_MULT[nbmasses] */
	float		*IMA_POSITION1			= (float *)		argv[nbarg++]; /* IMA_POSITION1[nbspins,nbenergies,10] */
	float		*IMA_POSITION2			= (float *)		argv[nbarg++]; /* IMA_POSITION2[nbspins,nbenergies,10] */
	unsigned char	*IMA_PAC			= (unsigned char *)	argv[nbarg++]; /* IMA_PAC[nbspins] */
	unsigned char	*MEA_GEOMFACTOR			= (unsigned char *)	argv[nbarg++]; /* MEA_GEOMFACTOR[nbspins] */
	unsigned char	*MEA_DATAID			= (unsigned char *)	argv[nbarg++]; /* MEA_DATAID[nbspins] */
	int		*TABINFO_INT			= (int *)		argv[nbarg++];
	double		*TABINFO_DOUBLE			= (double *)		argv[nbarg++];
	float		eminreel			= *(float *)		argv[nbarg++];
	float		emaxreel			= *(float *)		argv[nbarg++];
	float		*SC_POT_VOLT			= (float *)		argv[nbarg++]; /* SC_POT_VOLT[nbspin] */
	float		*Vx				= (float *)		argv[nbarg++]; /* km/sec */
	float		*Vy				= (float *)		argv[nbarg++]; /* km/sec */
	float		*Vz				= (float *)		argv[nbarg++]; /* km/sec */
	float		use_alpha			= *(float *)		argv[nbarg++]; /* utilis pour remplir use_cellules et use_spectres */
	int		*use_no			 	= (int *)		argv[nbarg++]; /*       use_no[nbcellules][nbspectres][nbenergies][nbspins] */
	char		*use_cellule			= (char *)		argv[nbarg++]; /*  use_cellule[nbcellules][nbspectres][nbenergies][nbspins] */
	char		*use_spectre			= (char *)		argv[nbarg++]; /*  use_spectre[nbcellules][nbspectres][nbenergies][nbspins] */
	char		*use_energy			= (char *)		argv[nbarg++]; /*   use_energy[nbcellules][nbspectres][nbenergies][nbspins] */
	float		*use_alphamin			= (float *)		argv[nbarg++]; /* use_alphamin[nbcellules][nbspectres][nbenergies][nbspins] */
	float		*use_alphamoy			= (float *)		argv[nbarg++]; /* use_alphamoy[nbcellules][nbspectres][nbenergies][nbspins] */
	float		*use_alphamax			= (float *)		argv[nbarg++]; /* use_alphamax[nbcellules][nbspectres][nbenergies][nbspins] */
	float		*use_cjf			= (float *)		argv[nbarg++]; /*      use_cjf[nbcellules][nbspectres][nbenergies][nbspins] */
	float		*use_rawcount			= (float *)		argv[nbarg++]; /* use_rawcount[nbcellules][nbspectres][nbenergies][nbspins] */
	IDL_STRING	*CL_ROOT			= (IDL_STRING *)	argv[nbarg++];
	// Si use_alpha vaut -1, on ne rempli pas use_cellule, use_spectre, use_energy, use_alphamin, use_alphamax, use_cjf
	// Sinon, pour les pitchangle qui on alphamin <= use_alpha <= alphamax, on rempli les tableaux


	/* 
	start [i]         = start [i] 
	solid [i,j]       = solid  [i + j*nbspectres] 
	sector [i,j]      = sector [i + j*nbspectres] 
	duree [i]         = duree [i] 
	Z[i,j]            = if spin_average	=1: Z [i + j*nbspins]
						=0: Z [i + j*nbspins*nbalphas]
	*/

	int		ienergie1;
	int		ienergie2;
	int		nospectre;
	float		val;
	float		somme;
	float		accumulation_duree;
	double		date;
	int		nb;
	float		tmp;
	float		tmin;
	float		tmoy;
	float		tmax;
	float		pmin;
	float		pmoy;
	float		pmax;
	float		alphamin;
	float		alphamoy;
	float		alphamax;
	int		y;
	int		ymin;
	int		ymax;
	float		champB[3];
	float		Cmoy[3];
	float		Bx;
	float		By;
	float		Bz;
	float		dT;
	float		dP;
	float		dLONG;
	float		dLAT;
	float		sinT;
	float		sinLAT;
	float		sinLONG;
	float		cosLAT;
	float		cosLONG;
	float		cosT;
	float		sinA;
	float		dA;
	float		cosP;
	float		sinP;
	float		module;
	float		*sommepitch = (float *)malloc(nbalphas*sizeof(float));

	float		ev,evmin,evmax;
	int		pollue;

	float		thetaB1, thetaB2;
	int		icelluleB1=0;	/* gcc */
	int		icelluleB2=0;	/* gcc */

	int		ipac;
	int		igeomfactor;
	int		idataid;
	float		V;
	float		tmpX;
	float		tmpY;
	float		tmpZ;
	double		*E_standard;
	double		*E_translat;
	//INUTILE double		*CmoyX_standard;
	double		*CmoyX_translat;
	//INUTILE double		*CmoyY_standard;
	double		*CmoyY_translat;
	//INUTILE double		*CmoyZ_standard;
	double		*CmoyZ_translat;
	double		*val_translat;

	int		imin;
	float		min;
	int		imax;
	float		max;
	int		nbX;
	double		min_val_translat;
	double		max_val_translat;
	double		tabX1[1024];
	double		tabX2[1024];
	double		tabY1[1024];
	double		tabY2[1024];
	double		tabCX1[1024], tabCX2[1024];
	double		tabCY1[1024], tabCY2[1024];
	double		tabCZ1[1024], tabCZ2[1024];

	double		limite_min;
	double		limite_max;
	float		limite3;
	float		limite4;

	int		imasse=0; /* initialise  0 pour STEREO-SWEA ou il n'y a pas de parcours de masse */

	/* pour IMA */
	unsigned char	*channelok=NULL;
	int		i;
	unsigned char	*p;
	int		nbcoups;
	int		ind;
	int		pos1=0;
	int		pos2=0;

	// pour Bulk
	int		Ecroissant;
	float		e1_ev;
	float		e2_ev;
	int		e1;
	int		e2;
	int		nbenergies_utiles;

	double		top1,top2,duree_boucle=0,duree_transfert_log=0,duree_interpoler=0,duree_avant_transfert=0,duree_pow=0;

	int		last_itable;
	float		tab_ev[1024];
	float		tab_V[1024];

	int		cjf1=0; // initialis sinon warning gcc
	int		cjf2=0; // initialis sinon warning gcc

	float 		min_plage_deg;
	float 		max_plage_deg;
	float 		min_couverture_deg;
	float 		max_couverture_deg;
	float		facteur;

	// DEBUG pour afficher des infos pour ispin==0
	//#define DEBUG

	if (nbarg != argc) return;

	DEBUT ();
	MAVEN_SWEA_CALIB_DEBUT();

	// Patch pour pouvoir utiliser amin=amax, on utiliser un slection de 1 deg atour de amin
	if (amin == amax) {
		if (amin < 1.0) {
			amin = 0.0;
			amax = 1.0;
		} else if (amin > 179.0) {
			amin = 179.0;
			amax = 180.0;
		} else {
			amin -= 0.5;
			amax += 0.5;
		}
	}


	E_standard	= (double *)malloc(nbenergies*sizeof(double));
	E_translat	= (double *)malloc(nbenergies*sizeof(double));
	//INUTILE CmoyX_standard	= (double *)malloc(nbenergies*sizeof(double));
	CmoyX_translat	= (double *)malloc(nbenergies*sizeof(double));
	//INUTILE CmoyY_standard	= (double *)malloc(nbenergies*sizeof(double));
	CmoyY_translat	= (double *)malloc(nbenergies*sizeof(double));
	//INUTILE CmoyZ_standard	= (double *)malloc(nbenergies*sizeof(double));
	CmoyZ_translat	= (double *)malloc(nbenergies*sizeof(double));
	val_translat	= (double *)malloc(nbenergies*sizeof(double));

	if (optimise) {

		/* Experience IMA */

		channelok = (unsigned char *) malloc (nbmasses);
		nbytes    = 2;
		p2        = (byte2 *)         malloc (nbenergies*nbcellules*nbspectres*nbmasses*nbytes);

		for (i=0 ; i<nbmasses ; i++)
			channelok[i]=1;
		if (is_IMA_ASPERA3(nocis) && nbmasses==32) {
			channelok[ 0]=0;
			channelok[ 4]=0;
			channelok[10]=0;
			channelok[22]=0;
		}

	}

	for (ispin=0 ; ispin<nbspins ; ispin++) {

		last_itable = -1; //  initialiser  chaque spin car SC_POT_VOLT dpend de ipsin

		if (region_ok[ispin]==0) { 

			if (spin_average==0) {
				for (ispectre=0 ; ispectre<nbspectres ; ispectre++) {
					nospectre = ispin*nbspectres+ispectre;
					Z[nospectre]=1e34;
				}
			} else {
				Z[ispin]=1e34;
			}

			continue;

		}

		tabphi_to_okspectre (B, tabphi, nbspectres, start, ispin, produit1, prodmin, prodmax, okspectre, nocis);

		pollution_maj (nocis, ispin, cis_mode, start_pollution_solaire, end_pollution_solaire, nbspectres, nbcellules, nbangles, solid, pollution);

		if (is_ELS(nocis)) sector_mask_to_solid (sector_mask[ispin], nbcellules, solid);

		ipac			= IMA_PAC[ispin];
		igeomfactor		= MEA_GEOMFACTOR[ispin];
		idataid			= MEA_DATAID[ispin];
		icarte			= indC[ispin];
		isensitivity		= sensitivity[ispin];
		accumulation		= nb_accumulation[ispin];
		accumulation_duree	= accumulation*duree_comptage[ispin];
		date			= xmin[ispin];
		MAVEN_SWEA_CALIB_GET();
		sector			= date < sectornew_date ? sectorold : sectornew;
		p1			= get_p1(tabdata,no1);

		if (is_pad) GET_SOLID();

		if (optimise) {

			/* Experience IMA */

			bzero (p2, nbenergies*nbcellules*nbspectres*nbmasses*2);
			for (ienergie=0 ; ienergie<nbenergies ; ienergie++) {
				for (ispectre=0 ; ispectre<nbspectres ; ispectre++) {
					if ((p = (unsigned char *) dataquick[indice3(ienergie,ispectre,no1+ispin,nbenergies,nbspectres,INUTILE)]) != 0) {
						nbcoups = 256*p[0] + p[1];
						ind = 2;
						for (i=0 ; i<nbcoups ; i++, ind += 4) {
							icellule = p[ind+0];
							imasse   = p[ind+1];
							p2[nocoup] = 256*p[ind+2] + p[ind+3];
						}
					}
				}
			}
		} else {
			p2 = get_p2(tabdata,no1);
		}
		p4			= get_p4(tabdata,no1);
		pfloat			= get_pfloat(tabdata,no1);
		pdouble			= get_pdouble(tabdata,no1);

		champB[0] = tabBx[ispin];
		champB[1] = tabBy[ispin];
		champB[2] = tabBz[ispin];
		module = module_v1(champB);

		if (module==0) {
			/* On ne peut rien faire (arrive sur Interball) */
			continue;
		}

		/* champB: champ magnetique en coordonnees cartesiennes normalises */
		champB[0] = Bx = tabBx[ispin] / module;
		champB[1] = By = tabBy[ispin] / module;
		champB[2] = Bz = tabBz[ispin] / module;

		if (pad_thetaB) {
			/* Determination du numero de la cellule (icellule1) qui voit suivant +B(thetaB1) */
			/* Determination du numero de la cellule (icellule2) qui voit suivant -B(thetaB2) */
			thetaB1 = atan2 (Bz,By) * 180.0 / M_PI;	/* Entre -180 et +180 deg */
			thetaB1 += 180;				/* Entre 0 et 360 deg */
			thetaB2 = thetaB1 - 180;
			if (thetaB2 < 0) thetaB2 += 360;
			for (icellule=0 ; icellule<nbcellules ; icellule++) {
				tmin = thetamin[indice2(ispin,icellule,nbspins,nbcellules)];
				tmax = thetamax[indice2(ispin,icellule,nbspins,nbcellules)];
				if (tmax < tmin) tmax += 360;
				if ( (tmin <= thetaB1) && (thetaB1 < tmax)) icelluleB1 = icellule;
				if ( (tmin <= thetaB2) && (thetaB2 < tmax)) icelluleB2 = icellule;
			}

		}

		if (spin_average==1) {
			for (y=0 ; y<nbalphas ; y++) {
				sommepitch[y]=0;
			}
		}

		for (ispectre=0 ; ispectre<nbspectres ; ispectre++) {

			if (okspectre[ispectre]==0) continue;

			nospectre = ispin*nbspectres+ispectre;

			pmin = phimin[indice2(ispin,ispectre,nbspins,nbspectres)];
			pmoy = phimoy[indice2(ispin,ispectre,nbspins,nbspectres)];
			pmax = phimax[indice2(ispin,ispectre,nbspins,nbspectres)];
			if (pmax < pmin) pmax += 360;
			dP = (pmax-pmin)/2.; /* Delta Phi */
			cosP = cos(pmoy*M_PI/180.);
			sinP = sin(pmoy*M_PI/180.);

			if (spin_average==0) {
				for (y=0 ; y<nbalphas ; y++) {
					sommepitch[y]=0;
				}
			}


			for (icellule=0 ; icellule<nbcellules ; icellule++) {

				if (pad_thetaB && (icellule!=icelluleB1 && icellule!=icelluleB2))
					continue;

				if (tabtheta[icellule]==0) continue;

				if (solid[noscc]==-1) continue; // 18/01/2016: pour ne garder que les cellules utilises dans les modes PAD de MAVEN_SWEA

				tmin = thetamin[indice2(ispin,icellule,nbspins,nbcellules)];
				tmoy = thetamoy[indice2(ispin,icellule,nbspins,nbcellules)];
				tmax = thetamax[indice2(ispin,icellule,nbspins,nbcellules)];
				if (tmax < tmin) tmax += 360;
				dT = (tmax-tmin)/2; /* Delta Theta */
				cosT = cos(tmoy*M_PI/180.);
				sinT = sin(tmoy*M_PI/180.);

				cosLAT = ordre_cluster ? cosT : cosP;
				sinLAT = ordre_cluster ? sinT : sinP;
				cosLONG = ordre_cluster ? cosP : cosT;
				sinLONG = ordre_cluster ? sinP : sinT;
				dLONG = ordre_cluster ? dP : dT;
				dLAT = ordre_cluster ? dT : dP;

				Cmoy[nox] = cosLAT*cosLONG;
				Cmoy[noy] = cosLAT*sinLONG;
				Cmoy[noz] = sinLAT;

				alphamoy = my_acos (produit_scalaire_v1_v2(Cmoy,champB))*180./M_PI;
				sinA = sin(alphamoy*M_PI/180.);

				/* B est defini par (Bx,By,Bz)
				La cellule est definie par T = Theta et P = Phi
				Alpha = A

				On a cosA = champB[nox].Cmoy[nox] + champB[noy].Cmoy[noy] + champB[noz].Cmoy[noz] (XX' + YY' + ZZ' = cosA)
				On a cosA = champB[nox].cosLAT.cosLONG + champB[noy].cosLAT.sinLONG + champB[noz].sinLAT

				Donc -sinA.dA = 	champB[nox].(-sinLAT.dLAT.cosLONG - cosLAT.sinLONG.dLONG)
						+	champB[noy].(-sinLAT.dLAT.sinLONG + cosLAT.cosLONG.dLONG)
						+	champB[noz].(cosLAT.dLAT)

				Donc -sinA.dA =		dLONG.(-champB[nox].cosLAT.sinLONG + champB[noy].cosLAT.cosLONG)
						+	dLAT.(-champB[nox].sinLAT.cosLONG - champB[noy].sinLAT.sinLONG + champB[noz].cosLAT)	

				dA = (dLONG.fabs(-champB[nox].cosLAT.sinLONG + champB[noy].cosLAT.cosLONG) +
					dLAT.fabs(-champB[nox].sinLAT.cosLONG - champB[noy].sinLAT.sinLONG + champB[noz].cosLAT)) / sinA

				*/

				if (sinA==0) {
					dA=0;
				} else {
					dA = (dLONG*fabs(-champB[nox]*cosLAT*sinLONG + champB[noy]*cosLAT*cosLONG) + 
						dLAT*fabs(-champB[nox]*sinLAT*cosLONG - champB[noy]*sinLAT*sinLONG + champB[noz]*cosLAT))/fabs(sinA);
					dA = fabs(dA);
				}

				somme=nb=0;
				itable = spin_average==0 ? indY[nospectre]:indY[ispin];
				if (itable==-1) continue;

				if (is_STEREO_SWEA(nocis) || is_MAVEN_SWEA(nocis) || is_MAVEN_SWIA(nocis) || is_MMS_DES(nocis) || is_MMS_DIS(nocis)) {

					if (is_MMS_DES(nocis) || is_MMS_DIS(nocis)) {
						// On accepte toutes les units: FDIST_TO_FLUX, FDIST_TO_FDIST, FDIST_TO_JE, FDIST_TO_FLUX_INTEGRAL
						cjf1 = FDIST_TO_FDIST;
						// On demande d'abord des FDIST_TO_FDIST
						// puis on interpole
						// puis repasse  l'unit demande
						cjf2 = cjf;
					} else if (is_STEREO_SWEA(nocis) || is_MAVEN_SWEA(nocis)) {
						// On n'accepte que FLUX, FDIST, JE et FLUX_INTEGRAL
						if (cjf==FLUX || cjf==FDIST || cjf==JE || cjf==FLUX_INTEGRAL) {
							cjf1 = FDIST;
							// on demande d'abord des FDIST
							// puis on interpole
							// puis on revient  l'unit demande
							switch (cjf) {
								case FLUX: 
									cjf2 = FDIST_TO_FLUX;
									break;
								case FDIST:
									cjf2 = FDIST_TO_FDIST;
									break;
								case JE:
									cjf2 = FDIST_TO_JE;
									break;
								case FLUX_INTEGRAL:
									cjf2 = FDIST_TO_FLUX_INTEGRAL;
									break;
							}
						} else if (cjf==JE_TO_FLUX) { // On demande d'abord des FDIST, puis on interpole, puis on repasse en FLUX
							cjf1 = JE_TO_FDIST;
							cjf2 = FDIST_TO_FLUX;
						} else if (cjf==JE_TO_FDIST) { // On demande d'abord des FDIST, puis on interpole, puis on repasse en FDIST
							cjf1 = JE_TO_FDIST;
							cjf2 = FDIST_TO_FDIST;
						} else if (cjf==JE_TO_JE) { // On demande d'abord des FDIST, puis on interpole, puis on repasse en JE
							cjf1 = JE_TO_FDIST;
							cjf2 = FDIST_TO_JE;
						} else if (cjf==JE_TO_FLUX_INTEGRAL) { // On demande d'abord des FDIST, puis on interpole, puis on repasse en FLUX_INTEGRAL
							cjf1 = JE_TO_FDIST;
							cjf2 = FDIST_TO_FLUX_INTEGRAL;
						} else {
							continue;
						}
					} else if (is_MAVEN_SWIA(nocis)) {
						// On n'accepte que FLUX+256, FDIST+256, JE+256
						if (cjf==FLUX+256 || cjf==FDIST+256 || cjf==JE+256) {
							cjf1 = FDIST;
							// on demande d'abord des FDIST
							// puis on interpole
							// puis on revient  l'unit demande
							switch (cjf) {
								case FLUX+256: 
									cjf1 = FLUX_TO_FDIST;
									cjf2 = FDIST_TO_FLUX;
									break;
								case FDIST+256:
									cjf1 = FDIST_TO_FDIST;
									cjf2 = FDIST_TO_FDIST;
									break;
								case JE+256:
									cjf1 = JE_TO_FDIST;
									cjf2 = FDIST_TO_JE;
									break;
							}
						} else {
							continue;
						}
					}

					/* passage dans le repre Bulk en utilisant Vx, Vy, Vz et SC_POT_VOLT */
					imasse=0;

					// Les nergies sont dcroissantes pour STEREO et MAVEN
					// Les nergies sont croissantes pour MMS
					Ecroissant = Emoy[indice2(itable,1,nbtablesE,nbenergies)] > Emoy[indice2(itable,0,nbtablesE,nbenergies)];

					// L'utilisateur demande entre eminreel et emaxreel
					// => (e1_ev,e2_ev) et (e1,e2)

					// En allant dans le sens des nergies, on va d'abord trouver e1 puis e2
				
					// eminreel trop petit ?
					if (Ecroissant) {
						ev    = Emoy[indice2(itable,0,nbtablesE,nbenergies)]*Q[imasse] - SC_POT_VOLT[ispin]; /* evmin en eV */
						evmin = Emin[indice2(itable,0,nbtablesE,nbenergies)]*Q[imasse] - SC_POT_VOLT[ispin]; /* evmin en eV */
						evmax = Emax[indice2(itable,0,nbtablesE,nbenergies)]*Q[imasse] - SC_POT_VOLT[ispin]; /* evmax en eV */
					} else {
						ev    = Emoy[indice2(itable,nbenergies-1,nbtablesE,nbenergies)]*Q[imasse] - SC_POT_VOLT[ispin]; /* evmin en eV */
						evmin = Emin[indice2(itable,nbenergies-1,nbtablesE,nbenergies)]*Q[imasse] - SC_POT_VOLT[ispin]; /* evmin en eV */
						evmax = Emax[indice2(itable,nbenergies-1,nbtablesE,nbenergies)]*Q[imasse] - SC_POT_VOLT[ispin]; /* evmax en eV */
					}
					if (eminreel < evmin) eminreel = ev;
					#ifdef DEBUG
					if (ispin==0) {
						printf ("eminreel=%f\n",eminreel);
					}
					#endif

					// emaxreel trop grand ?
					if (Ecroissant) {
						ev    = Emoy[indice2(itable,nbenergies-1,nbtablesE,nbenergies)]*Q[imasse] - SC_POT_VOLT[ispin]; /* evmin en eV */
						evmin = Emin[indice2(itable,nbenergies-1,nbtablesE,nbenergies)]*Q[imasse] - SC_POT_VOLT[ispin]; /* evmin en eV */
						evmax = Emax[indice2(itable,nbenergies-1,nbtablesE,nbenergies)]*Q[imasse] - SC_POT_VOLT[ispin]; /* evmax en eV */
					} else {
						ev    = Emoy[indice2(itable,0,nbtablesE,nbenergies)]*Q[imasse] - SC_POT_VOLT[ispin]; /* evmin en eV */
						evmin = Emin[indice2(itable,0,nbtablesE,nbenergies)]*Q[imasse] - SC_POT_VOLT[ispin]; /* evmin en eV */
						evmax = Emax[indice2(itable,0,nbtablesE,nbenergies)]*Q[imasse] - SC_POT_VOLT[ispin]; /* evmax en eV */
					}
					if (emaxreel > evmax) emaxreel = ev;
					#ifdef DEBUG
					if (ispin==0) {
						printf ("emaxreel=%f\n",emaxreel);
					}
					#endif

					e1_ev=e1=e2_ev=e2=-1;
					for (ienergie=0 ; ienergie<nbenergies ; ienergie++) {
						ev    = Emoy[indice2(itable,ienergie,nbtablesE,nbenergies)]*Q[imasse] - SC_POT_VOLT[ispin]; /* evmin en eV */
						evmin = Emin[indice2(itable,ienergie,nbtablesE,nbenergies)]*Q[imasse] - SC_POT_VOLT[ispin]; /* evmin en eV */
						evmax = Emax[indice2(itable,ienergie,nbtablesE,nbenergies)]*Q[imasse] - SC_POT_VOLT[ispin]; /* evmax en eV */
						if ((eminreel>=evmin) && (eminreel<=evmax)) {
							if (Ecroissant) {
								if (e1_ev==-1) e1_ev=ev;
								if (e1==-1) e1=ienergie;
							} else {
								if (e2_ev==-1) e2_ev=ev;
								if (e2==-1) e2=ienergie;
							}
						}
						if ((emaxreel>=evmin) && (emaxreel<=evmax)) {
							if (Ecroissant) {
								if (e2_ev==-1) e2_ev=ev;
								if (e2==-1) e2=ienergie;
							} else {
								if (e1_ev==-1) e1_ev=ev;
								if (e1==-1) e1=ienergie;
							}
						}
					}
					#ifdef DEBUG
					if (ispin==0) {
						printf ("e1_ev=%f e2_ev=%f\n",e1_ev,e2_ev);
						printf ("e1=%d e2=%d\n",e1,e2);
					}
					#endif


					// 12/06/2015: tests mis en commentaire car les FILLVAL ont t remplacs par 0
					//if (Vx[ispin] < -FILLVAL_E30) continue;	// on ne connait pas la vitesse
					//if (Vy[ispin] < -FILLVAL_E30) continue;	// on ne connait pas la vitesse
					//if (Vz[ispin] < -FILLVAL_E30) continue;	// on ne connait pas la vitesse

					// Calcule les tableaux suivants:
					//	CmoyX_translat[0:nbenergies-1]
					// 	CmoyY_translat[0:nbenergies-1]
					// 	CmoyZ_translat[0:nbenergies-1]
					// 	E_standard[0:nbenergies-1]
					// 	E_translat[0:nbenergies-1]
					// 	val_translat[0:nbenergies-1]
					// L'indice 0 correspond  l'nergie minimale en eV
					// L'indice nbenergies-1 correspond  l'nergie maximale en eV

					top1 = nbsec();
					for (ienergie=0 ; ienergie<nbenergies ; ienergie++) {

						// calcul dans val de fdist avec la vraie energie initiale, sans correction potentiel
						// Normalement, il ne faut utiliser que (cjf&255)=FDIST
						if (lire_fg && ((fg = get_fg) < -FILLVAL_E30)) { // get_data_time_pitchangle_cjf
							val = -FILLVAL_E31;
						} else if (lire_eff && ((eff = get_eff) < -FILLVAL_E30)) {
							val = -FILLVAL_E31;
						} else {
							COUP_TO_CJF1 (cjf1);
						}

						if (itable != last_itable) {

							// Ne recalculer ev et V que si la itable a chang

							ev = Emoy[indice2(itable,ienergie,nbtablesE,nbenergies)]*Q[imasse] - SC_POT_VOLT[ispin]; /* ev en eV */
							// Lavraud: potentiel  ne faire qu'apres COUP_TO_CJF1. Pourquoi ? ev n'est pas utilis dans COUP_TO_CJF1()

							V = sqrt(2*fabs(ev)*Q[imasse]*ELECTRONVOLT/MASSE[imasse]); /* V en m/sec */
							tab_ev[ienergie] = ev;
							tab_V[ienergie] = V;

						} else {

							ev = tab_ev[ienergie];
							V = tab_V[ienergie];

						}
						tmpX = Cmoy[0] - Vx[ispin] / (V*0.001); /* Vx en km/sec */
						tmpY = Cmoy[1] - Vy[ispin] / (V*0.001); /* Vy en km/sec */
						tmpZ = Cmoy[2] - Vz[ispin] / (V*0.001); /* Vz en km/sec */
						//Ebulk = 0.5*(Vbulk*1e3)*(Vbulk*1e3)*MASSE[imasse]/(Q[imasse]*ELECTRONVOLT); /* en eV */
						//module_v1(Cmoy)^2 car Energie et non Vitesse

						//INUTILE CmoyX_standard[ienergie] = Cmoy[0];
						//INUTILE CmoyY_standard[ienergie] = Cmoy[1];
						//INUTILE CmoyZ_standard[ienergie] = Cmoy[2];
						val_translat[ienergie]                = val;	// fdist
						E_standard[ienergie]                  = ev;	// standard avec correction potentiel
						E_translat[ienergie]                  = ev * (tmpX*tmpX + tmpY*tmpY + tmpZ*tmpZ);
						CmoyX_translat[ienergie]              = tmpX;
						CmoyY_translat[ienergie]              = tmpY;
						CmoyZ_translat[ienergie]              = tmpZ;

					}
					last_itable = itable;
					top2 = nbsec();
					duree_boucle += top2-top1;

					#ifdef DEBUG
					if (ispin==0) {
						printf ("ispin=%d ispectre=%d icellule=%d\n",
								ispin,ispectre,icellule);
						for (ienergie=0 ; ienergie<nbenergies ; ienergie++) {
							printf ("%d %d %d E_standard[%d]=%f  E_translat[%d]=%f\n",ispin,ispectre,icellule,ienergie,E_standard[ienergie],ienergie,E_translat[ienergie]);
						}
						for (ienergie=0 ; ienergie<nbenergies ; ienergie++) {
							printf ("%d %d %d val_translat[%d] = %f\n",ispin,ispectre,icellule,ienergie,val_translat[ienergie]);
						}
					}
					#endif

					// On a un spectre en nergies avec nbenergies valeurs de fdist
					//
					// exemple:
					//
					//     			fdist
					//
					//			|
					//			|
					//			|
					//			|
					//			|       x               x
					//			|      x xx     xxxx xxx x
					//   min_val_translat	|.....x        x         .
					//			|     .                  .
					//   		0	|-xxxx.----x--x-----x----.xxxxxxxxxx--------------> energies
					//            		      .                  .
					//            		     imin               imax
					//
					// Ce spectre corrrespond aux nergies E_translat
					// On va vouloir calculer les valeurs aux nergies E_standard. Pour l'interpolation il faut utiliser le log des valeurs.
					// On dtermine imin et imax, puis on remplace entre imin et imax les valeurs nulles par min_val_translat*0.001
					// Aprs interpolation, on remplace les valeurs infrieures  min_val_translat*0.01 par 0
					//
					// Mme si Vx, Vy et Vz sont nuls, E_translat et E_standard ne sont pas strictement identiques
					// (car le calcul du module de Cmoy qui est un vecteur unitaire ne donne pas exactement 1)
	
					// Mis en commantaire le 21/11/2017 pour la figure mms_benoit_2.cl
					// On ne trouve pas les mmes rsultats en dfinissant le symbole, c'est pas normal !
					//#define PENOU

#define INTERP_LOG

					top1 = nbsec();
					// Recherche valeur minimale positive non nulle de ce spectre en nergie (valeur min_val_translat)
					#ifndef PENOU
					imin = -1;
					#endif
					min_val_translat = 1e38;
					max_val_translat = 0;										// 06/07/2018
					for (ienergie=0 ; ienergie<nbenergies ; ienergie++) {
						if (val_translat[ienergie]>0 && val_translat[ienergie]<min_val_translat) {
							min_val_translat = val_translat[ienergie];
							#ifndef PENOU
							imin = ienergie;
							#endif
						}
						if (val_translat[ienergie]>0 && val_translat[ienergie]>max_val_translat) {		// 06/07/2018
							max_val_translat = val_translat[ienergie];					// 06/07/2018
						}											// 06/07/2018
					}
					#ifdef DEBUG
					if (ispin==0) {
						printf ("=> min_val_translat=%f\n",min_val_translat);
					}
					#endif


					#ifdef PENOU

						imin = 0;
						for (ienergie=nbenergies-1 ; ienergie>=0 ; ienergie--) {
							if ((Ecroissant==1 && E_translat[ienergie]<e1_ev) || (Ecroissant==0 && E_translat[ienergie]>e1_ev)) {
								imin = ienergie-1; // marge de 1
								break;
							}
						}
						if (imin<0) imin=0;

						imax = nbenergies-1;
						for (ienergie=0 ; ienergie<nbenergies ; ienergie++) {
							if ((Ecroissant==1 && E_translat[ienergie]>e2_ev) || (Ecroissant==0 && E_translat[ienergie]<e2_ev)) {
								imax = ienergie+1; // marge de 1
								break;
							}
						}
						if (imax>=nbenergies) imax=nbenergies-1;
						#ifdef DEBUG
						if (ispin==0) {
							printf ("imin=%d imax=%d\n",imin,imax);
						}
						#endif
						nbX = imax-imin+1;
						if (nbX<=1) continue;	// on ne peut pas interpoler avec un seul point

					#else

						if (imin==-1) continue; // il n'y a que des coups nuls

						// Recherche nergie minimale positive avec comptage positif non nul (imin)
						imin = -1;
						for (ienergie=0 ; ienergie<nbenergies ; ienergie++) {
							#ifdef INTERP_LOG
							if (E_translat[ienergie]>0 && val_translat[ienergie]>0) {
							#else
							if (E_translat[ienergie]>0) {
							#endif
								imin = ienergie;
								break;
							}
						}
						#ifdef DEBUG
						if (ispin==0) {
							printf ("=> imin=%d\n",imin);
						}
						#endif
						if (imin==-1) continue;	// ca va pas tre possible

						// Recherche nergie maximale positive avec comptage positif non nul (imax)
						imax = imin;
						for (ienergie=nbenergies-1 ; ienergie>=0 ; ienergie--) {
							#ifdef INTERP_LOG
							if (E_translat[ienergie]>0 && val_translat[ienergie]>0) {
							#else
							if (E_translat[ienergie]>0) {
							#endif
								imax = ienergie;
								break;
							}
						}
						#ifdef DEBUG
						if (ispin==0) {
							printf ("=> imax=%d\n",imax);
						}
						#endif
						nbX = imax-imin+1;
						if (nbX==1) continue;	// on ne peut pas interpoler avec un seul point

						// Optimisation: rduire (imin,imax) en ne gardant qu'une valeur avant e1_ev et qu'une valeur aprs e2_ev
						// ------------------------------------------------------------------------------------------------------
						#ifdef DEBUG
						if (ispin==0) {
							printf ("AVANT imin=%d imax=%d\n",imin,imax);
						}
						#endif
						for (ienergie=imax ; ienergie>=imin ; ienergie--) {
							if ((Ecroissant==1 && E_translat[ienergie]<e1_ev) || (Ecroissant==0 && E_translat[ienergie]>e1_ev)) {
								if (ienergie-1>imin) imin = ienergie-1; // marge de 1
								break;
							}
						}
						for (ienergie=imin ; ienergie<=imax ; ienergie++) {
							if ((Ecroissant==1 && E_translat[ienergie]>e2_ev) || (Ecroissant==0 && E_translat[ienergie]<e2_ev)) {
								if (ienergie+1<imax) imax = ienergie+1; // marge de 1
								break;
							}
						}
						#ifdef DEBUG
						if (ispin==0) {
							printf ("APRES imin=%d imax=%d\n",imin,imax);
						}
						#endif
						nbX = imax-imin+1;
						if (nbX==1) continue;	// on ne peut pas interpoler avec un seul point
					#endif

#ifdef INTERP_LOG
					// Y a t-il des 0 ? Si oui les remplacer par min_val_translat*0.001
					for (ienergie=0 ; ienergie<nbX ; ienergie++) {
						if (val_translat[ienergie+imin]<=0) {
							val_translat[ienergie+imin] = min_val_translat*0.001;
						}
					}
#endif
					#ifdef DEBUG
					if (ispin==0) {
						for (ienergie=0 ; ienergie<nbX ; ienergie++) {
							printf ("=> val_translat[%d] = %f\n",ienergie+imin,val_translat[ienergie+imin]);
						}
					}
					#endif
					top2 = nbsec();
					duree_avant_transfert += top2-top1;

					top1 = nbsec();
					nbenergies_utiles = e2-e1+1;
					for (ienergie=e1 ;ienergie<=e2 ; ienergie++) {
						tabX2[ienergie-e1] = E_standard[ienergie];
					}

					for (ienergie=0 ;ienergie<nbX ; ienergie++) {
						tabX1[ienergie] = E_translat[ienergie+imin];
						#ifdef INTERP_LOG
						tabY1[ienergie] = LOG10f(val_translat[ienergie+imin]);
						#else
						tabY1[ienergie] = val_translat[ienergie+imin];
						#endif
						tabCX1[ienergie] = CmoyX_translat[ienergie+imin];
						tabCY1[ienergie] = CmoyY_translat[ienergie+imin];
						tabCZ1[ienergie] = CmoyZ_translat[ienergie+imin];
					}
					top2 = nbsec();
					duree_transfert_log += top2-top1;

					top1 = nbsec();

					#ifdef DEBUG
					if (ispin==0) {
						for (ienergie=0 ; ienergie<nbX ; ienergie++) {
							printf ("tabX1[%d]=%f tabY1[%d]=%f\n",ienergie,tabX1[ienergie],ienergie,tabY1[ienergie]);
						}
					}
					#endif

					// calcule tabY2
					interpoler_tab_quick_double (nbX, tabX1, tabY1, nbenergies_utiles, tabX2, tabY2);

					// calcule tabCX2
					interpoler_tab_quick_double (nbX, tabX1, tabCX1, nbenergies_utiles, tabX2, tabCX2);

					// calcule tabCY2
					interpoler_tab_quick_double (nbX, tabX1, tabCY1, nbenergies_utiles, tabX2, tabCY2);

					// calcule tabCZ2
					interpoler_tab_quick_double (nbX, tabX1, tabCZ1, nbenergies_utiles, tabX2, tabCZ2);

					top2 = nbsec();
					duree_interpoler += top2-top1;


					#ifdef DEBUG
					if (ispin==0) {
						for (ienergie=0 ; ienergie<nbenergies_utiles ; ienergie++) {
							printf ("tabX2[%d]=%f tabY2[%d]=%f\n",ienergie,tabX2[ienergie],ienergie,tabY2[ienergie]);
						}
					}
					#endif

					top1 = nbsec();
					limite_min = Ecroissant ? tabX1[    0]*0.99 : tabX1[nbX-1]*0.99;
					limite_max = Ecroissant ? tabX1[nbX-1]*1.01 : tabX1[    0]*1.01;
					//limite3 = LOG10f(min_val_translat*0.01);
					//limite3 = LOG10f(min_val_translat*0.99); // 9/12/2016
					limite3 = LOG10f(min_val_translat*0.1); // 21/11/2017 pour la figure mms_benoit_2.cl sinon les coups  hautes nergies disparaissent
					limite4 = LOG10f(max_val_translat*10.0); // 06/07/2018 pour ne pas avoir de valeurs normes (vu avec Karim sur MAVEN_SWIA)
					for (ienergie=0 ; ienergie<nbenergies_utiles ; ienergie++) {
						if ( (tabX2[ienergie] > limite_max) || (tabX2[ienergie] < limite_min)) {
							// Que des valeurs nulles
							// facteur 1.01  cause des problmes d'arrondi
							#ifdef DEBUG
							if (ispin==0) {
								printf ("ICI1 tabX2[%d]=%f limite_min=%f limite_max=%f\n",ienergie,tabX2[ienergie],limite_min,limite_max);
							}
							#endif
							tabY2[ienergie] = 0;
						} else {
							#ifdef INTERP_LOG
							if (tabY2[ienergie] < limite3) {
								// valeur en dessous du minimum: c'est une valeur nulle
								#ifdef DEBUG
								if (ispin==0) {
									printf ("ICI3 ienergie=%d\n",ienergie);
								}
								#endif
								tabY2[ienergie] = 0;
							} else if (tabY2[ienergie] > limite4) {							// 06/07/2018
								// valeur en dessous du maximum: on la remplace par max_val_translat*10.0	// 06/07/2018
								tabY2[ienergie] = max_val_translat*10.0;					// 06/07/2018
							} else {
								// pow10f plus rapide que pow (10, ...) mais plus lent qu'en IDL ! Pourquoi ?
								tabY2[ienergie] = POW10f (tabY2[ienergie]);
							}
							#endif
						}
					}
					top2 = nbsec();
					duree_pow += top2-top1;


					#ifdef DEBUG
					if (ispin==0) {
						for (ienergie=0 ; ienergie<nbenergies_utiles ; ienergie++) {
							printf ("tabX2[%d]=%f tabY2[%d]=%f\n",ienergie,tabX2[ienergie],ienergie,tabY2[ienergie]);
						}
					}
					#endif

					for (ienergie=e1 ; ienergie<=e2 ; ienergie++) {

						POLLUTION_ON (); if (pollue) continue;

						val = tabY2[ienergie-e1];
				
						// On repasse maintenant en JE ou flux ...
						COUP_TO_CJF (cjf2);

						Cmoy[0] = tabCX2[ienergie-e1];
						Cmoy[1] = tabCY2[ienergie-e1];
						Cmoy[2] = tabCZ2[ienergie-e1];

						#ifdef DEBUG
						if (ispin==0) {
							printf ("val=%f Cmoy=%f %f %f\n",val,Cmoy[0],Cmoy[1],Cmoy[2]);
						}
						#endif

						tmp = module_xyz (Cmoy[0], Cmoy[1], Cmoy[2]);
						Cmoy[0] /= tmp;
						Cmoy[1] /= tmp;
						Cmoy[2] /= tmp;

						alphamoy = my_acos (produit_scalaire_v1_v2(Cmoy,champB))*180./M_PI;
						#define USE_DA
						#ifdef USE_DA
						alphamin = modif_alpha (alphamoy-dA);
						alphamax = modif_alpha (alphamoy+dA); 
						if (alphamin > alphamax) {
							tmp=alphamin;
							alphamin=alphamax;
							alphamax=tmp;
						}
						#else
						alphamin = alphamoy;
						alphamax = alphamoy;
						#endif

						#ifdef DEBUG
						if (ispin==0) {
							printf ("ispin=%d ienergie=%d alphamin=%f alphamax=%f val=%f\n",ispin,ienergie,alphamin,alphamax,val);
						}
						#endif
			
						/* ----- Dbut traitement pour Andrea Opitz ----- */
						if (alphamin <= use_alpha && use_alpha <= alphamax) {
							use_no      [indice4(icellule,ispectre,ienergie,ispin,nbcellules,nbspectres,nbenergies,nbspins)]=ispin;
							use_cellule [indice4(icellule,ispectre,ienergie,ispin,nbcellules,nbspectres,nbenergies,nbspins)]=icellule;
							use_spectre [indice4(icellule,ispectre,ienergie,ispin,nbcellules,nbspectres,nbenergies,nbspins)]=ispectre;
							use_energy  [indice4(icellule,ispectre,ienergie,ispin,nbcellules,nbspectres,nbenergies,nbspins)]=ienergie;
							use_alphamin[indice4(icellule,ispectre,ienergie,ispin,nbcellules,nbspectres,nbenergies,nbspins)]=alphamin;
							use_alphamoy[indice4(icellule,ispectre,ienergie,ispin,nbcellules,nbspectres,nbenergies,nbspins)]=alphamoy;
							use_alphamax[indice4(icellule,ispectre,ienergie,ispin,nbcellules,nbspectres,nbenergies,nbspins)]=alphamax;
							use_cjf[indice4(icellule,ispectre,ienergie,ispin,nbcellules,nbspectres,nbenergies,nbspins)]=val;
							PUSH_float(val);
							PUSH_int(cjf);
							cjf=0;		// coup brut
							COUP_TO_CJF1(cjf);
							use_rawcount[indice4(icellule,ispectre,ienergie,ispin,nbcellules,nbspectres,nbenergies,nbspins)]=val;
							POP_int(cjf);
							POP_float(val);
						}
						/* ----- Fin traitement pour Andrea Opitz ----- */	

						if (is_time_energy) {

							if (alphamax < amin) continue;
							if (alphamin > amax) continue;

							// Ancien algo: attribuer tous les coups
							facteur = 1.0;
							if (spin_average) {
								Z[ispin + (nbenergies-1-ienergie)*nbspins] += val * facteur;
							} else {
								Z[nospectre + (nbenergies-1-ienergie)*nbspectres*nbspins] += val * facteur;
							}
							sommepitch[nbenergies-1-ienergie] += facteur;

/*
							// Nouvel algo: n'attribuer qu'une fraction de val en fonction de la couverture en angle
							// IL Y A UN PROBLEME: si on demande entre 0 et 30 deg on a des valeurs, mais si on demande entre 0 et 179 deg toutes
							// les valeurs disparaissent!
							min_plage_deg = amin;
							max_plage_deg = amax;
							min_couverture_deg = alphamin < min_plage_deg ? min_plage_deg : alphamin;
							max_couverture_deg = alphamax > max_plage_deg ? max_plage_deg : alphamax;
							if (alphamin != alphamax && (max_couverture_deg - min_couverture_deg) / (max_plage_deg - min_plage_deg) >= 0.25) {
								// avoir une couverture d'au moins 25% de la bande en pitchangle pour viter de crer des points avec des valeurs trop faibles
								// qui faussent le minimum de la palette de couleurs du spectrogramme
								facteur = (max_couverture_deg - min_couverture_deg) / (alphamax - alphamin);

								if (spin_average) {
									Z[ispin + (nbenergies-1-ienergie)*nbspins] += val * facteur;
								} else {
									Z[nospectre + (nbenergies-1-ienergie)*nbspectres*nbspins] += val * facteur;
								}
								sommepitch[nbenergies-1-ienergie] += facteur;
							}
*/

						} else {

							ymin = alphamin * nbalphas / 180; if (ymin==nbalphas) ymin--;
							ymax = alphamax * nbalphas / 180; if (ymax==nbalphas) ymax--;

							for (y=ymin ; y<=ymax ; y++) {
								// Nouvel algo: n'attribuer qu'une fraction de val en fonction de la couverture en angle
								min_plage_deg = (y+0) * 180.0 / nbalphas;
								max_plage_deg = (y+1) * 180.0 / nbalphas;
								min_couverture_deg = alphamin < min_plage_deg ? min_plage_deg : alphamin;
								max_couverture_deg = alphamax > max_plage_deg ? max_plage_deg : alphamax;
								if (alphamin != alphamax && (max_couverture_deg - min_couverture_deg) / (max_plage_deg - min_plage_deg) >= 0.25) {
									// avoir une couverture d'au moins 25% de la bande en pitchangle pour viter de crer des points avec des valeurs trop faibles
									// qui faussent le minimum de la palette de couleurs du spectrogramme
									facteur = (max_couverture_deg - min_couverture_deg) / (alphamax - alphamin);
									if (spin_average==1) {
										Z[ispin + y*nbspins] += val * facteur;
									} else {
										Z[nospectre + y*nbspectres*nbspins] += val * facteur;
									}
									sommepitch[y] += facteur;
								}
							}

						}
					}

				} else {

					/* Pour les autres expriences: ne pas passer dans le repre Bulk */

					ienergie1 = spin_average==0 ? tab1ienergie[nospectre]:tab1ienergie[ispin];
					ienergie2 = spin_average==0 ? tab2ienergie[nospectre]:tab2ienergie[ispin];

					alphamin = modif_alpha (alphamoy-dA);
					alphamax = modif_alpha (alphamoy+dA); 

					if (alphamin > alphamax) {
						tmp=alphamin;
						alphamin=alphamax;
						alphamax=tmp;
					}

					ymin = alphamin * nbalphas / 180; if (ymin==nbalphas) ymin--;
					ymax = alphamax * nbalphas / 180; if (ymax==nbalphas) ymax--;

					if (ienergie1==-1 || ienergie2==-1 || ienergie1>ienergie2) {

						if (spin_average==0) {
							for (y=ymin ; y<=ymax ; y++) {
								Z[nospectre + y*nbspectres*nbspins]=1e34;
							}
						}

					} else {

						for (ienergie=ienergie1 ; ienergie<=ienergie2 ; ienergie++) {

							if (is_time_energy) somme=nb=0;

							POLLUTION_ON (); if (pollue) continue;
							if (tabmass[0]<0) {
								pos1 = IMA_POSITION1[indice3(ispin,ienergie,-tabmass[0]-1,nbspins,nbenergies,INUTILE)] + 0.5; if (pos1<0) pos1=0;
								pos2 = IMA_POSITION2[indice3(ispin,ienergie,-tabmass[0]-1,nbspins,nbenergies,INUTILE)] + 0.5; if (pos2>nbmasses-1) pos2=nbmasses-1;
							}
							for (imasse=0 ; imasse<nbmasses ; imasse++) {
								if (tabmass[imasse]==1 || (tabmass[0]<0 && imasse>=pos1 && imasse<=pos2)) {
									if (lire_eff && ((eff = get_eff) < -FILLVAL_E30)) continue;
									if (lire_fg && ((fg = get_fg ) < -FILLVAL_E30)) continue; // get_data_time_pitchangle_cjf
									if (remove_bad_channel) {
										COUP_TO_CJF1_REMOVE_BAD_CHANNEL ();
									} else {
										COUP_TO_CJF1 (cjf);
										if (val < -FILLVAL_E30) continue;
									}
									if (remove_hghost) REMOVE_HGHOST ();
									if (val < -FILLVAL_E30) continue;
									somme += val;
									nb++;
								}
							}
							if (is_time_energy) {
								if (alphamax < amin) continue;
								if (alphamin > amax) continue;
								if (nb) somme /= nb;
								if (spin_average) {
									Z[ispin + (nbenergies-1-ienergie)*nbspins] += somme;
								} else {
									Z[nospectre + (nbenergies-1-ienergie)*nbspectres*nbspins] += somme;
								}
								sommepitch[nbenergies-1-ienergie] += 1;
							}
							#ifdef DEBUG
							if (1 || ispin==0) {
								printf ("ienergie=%d alphamin=%f alphamax=%f somme=%f\n",ienergie,alphamin,alphamax,somme);
							}
							#endif
						}

						if (is_time_energy==0) {
							if (nb) somme /= nb;

							if (spin_average==1) {
								for (y=ymin ; y<=ymax ; y++) {
									Z[ispin + y*nbspins] += somme;
									sommepitch[y] += 1;
								}
							} else {
								for (y=ymin ; y<=ymax ; y++) {
									Z[nospectre + y*nbspectres*nbspins] += somme;
									sommepitch[y] += 1;
								}
							}
						}
					}

				}

			} /* for icellule */


			if (spin_average==0) {
				// marche aussi si is_time_energy==1 car nbalphas vaut nbenergies
				for (y=0 ; y<nbalphas ; y++) {
					if (sommepitch[y]) {
						Z[nospectre + y*nbspectres*nbspins] /= sommepitch[y];
					} else {
						Z[nospectre + y*nbspectres*nbspins] = -1e31;
					}
				}
			}

		} /* for ispectre */

		if (spin_average==1) {
			// marche aussi si is_time_energy==1 car nbalphas vaut nbenergies
			for (y=0 ; y<nbalphas ; y++) {
				if (sommepitch[y]) {
					Z[ispin + y*nbspins] /= sommepitch[y];
				} else {
					Z[ispin + y*nbspins] = -1e31;
				}
			}
		}

	}

	FIN ();
	MAVEN_SWEA_CALIB_FIN();

	free (sommepitch);

	free (E_standard);
	free (E_translat);
	//INUTILE free (CmoyX_standard);
	free (CmoyX_translat);
	//INUTILE free (CmoyY_standard);
	free (CmoyY_translat);
	//INUTILE free (CmoyZ_standard);
	free (CmoyZ_translat);
	free (val_translat);

//printf ("duree_boucle          = %fsec\n",duree_boucle);
//printf ("duree_avant_transfert = %fsec\n",duree_avant_transfert);
//printf ("duree_transfert_log   = %fsec\n",duree_transfert_log);
//printf ("duree_interpoler      = %fsec\n",duree_interpoler);
//printf ("duree_pow             = %fsec\n",duree_pow);

	if (optimise) free (channelok);
	if (optimise) free (p2);

}

/*---------------------------------------------------------------------------*/
void GET_DATA_TIME_PITCHANGLE_CJF_AUTO_GLUE (
/*---------------------------------------------------------------------------*/
	void	*p01,
	void	*p02,
	void	*p03,
	void	*p04,
	void	*p05,
	void	*p06,
	void	*p07,
	void	*p08,
	void	*p09,
	void	*p10,
	void	*p11,
	void	*p12,
	void	*p13,
	void	*p14,
	void	*p15,
	void	*p16,
	void	*p17,
	void	*p18,
	void	*p19,
	void	*p20,
	void	*p21,
	void	*p22,
	void	*p23,
	void	*p24,
	void	*p25,
	void	*p26,
	void	*p27,
	void	*p28,
	void	*p29,
	void	*p30,
	void	*p31,
	void	*p32,
	void	*p33,
	void	*p34,
	void	*p35,
	void	*p36,
	void	*p37,
	void	*p38,
	void	*p39,
	void	*p40,
	void	*p41,
	void	*p42,
	void	*p43,
	void	*p44,
	void	*p45,
	void	*p46,
	void	*p47,
	void	*p48,
	void	*p49,
	void	*p50,
	void	*p51,
	void	*p52,
	void	*p53,
	void	*p54,
	void	*p55,
	void	*p56,
	void	*p57,
	void	*p58,
	void	*p59,
	void	*p60,
	void	*p61,
	void	*p62,
	void	*p63,
	void	*p64,
	void	*p65,
	void	*p66,
	void	*p67,
	void	*p68,
	void	*p69,
	void	*p70,
	void	*p71,
	void	*p72,
	void	*p73,
	void	*p74,
	void	*p75,
	void	*p76,
	void	*p_CL_ROOT) {

	int		argc=77;
	void		*argv[77];
	IDL_STRING	*CL_ROOT;

	// p_CL_ROOT -> CL_ROOT
	CL_ROOT = malloc (sizeof(IDL_STRING));
	IDL_StrStore (CL_ROOT, p_CL_ROOT);

	argv[ 0] = p01;
	argv[ 1] = p02;
	argv[ 2] = p03;
	argv[ 3] = p04;
	argv[ 4] = p05;
	argv[ 5] = p06;
	argv[ 6] = p07;
	argv[ 7] = p08;
	argv[ 8] = p09;
	argv[ 9] = p10;
	argv[10] = p11;
	argv[11] = p12;
	argv[12] = p13;
	argv[13] = p14;
	argv[14] = p15;
	argv[15] = p16;
	argv[16] = p17;
	argv[17] = p18;
	argv[18] = p19;
	argv[19] = p20;
	argv[20] = p21;
	argv[21] = p22;
	argv[22] = p23;
	argv[23] = p24;
	argv[24] = p25;
	argv[25] = p26;
	argv[26] = p27;
	argv[27] = p28;
	argv[28] = p29;
	argv[29] = p30;
	argv[30] = p31;
	argv[31] = p32;
	argv[32] = p33;
	argv[33] = p34;
	argv[34] = p35;
	argv[35] = p36;
	argv[36] = p37;
	argv[37] = p38;
	argv[38] = p39;
	argv[39] = p40;
	argv[40] = p41;
	argv[41] = p42;
	argv[42] = p43;
	argv[43] = p44;
	argv[44] = p45;
	argv[45] = p46;
	argv[46] = p47;
	argv[47] = p48;
	argv[48] = p49;
	argv[49] = p50;
	argv[50] = p51;
	argv[51] = p52;
	argv[52] = p53;
	argv[53] = p54;
	argv[54] = p55;
	argv[55] = p56;
	argv[56] = p57;
	argv[57] = p58;
	argv[58] = p59;
	argv[59] = p60;
	argv[60] = p61;
	argv[61] = p62;
	argv[62] = p63;
	argv[63] = p64;
	argv[64] = p65;
	argv[65] = p66;
	argv[66] = p67;
	argv[67] = p68;
	argv[68] = p69;
	argv[69] = p70;
	argv[70] = p71;
	argv[71] = p72;
	argv[72] = p73;
	argv[73] = p74;
	argv[74] = p75;
	argv[75] = p76;
	argv[76] = CL_ROOT;
	GET_DATA_TIME_PITCHANGLE_CJF (argc, argv);

	free (CL_ROOT);

}


/*---------------------------------------------------------------------------*/
void GET_DATA_TIME_L_CJF (int argc, void *argv[]) {
/*---------------------------------------------------------------------------*/

	int		nbarg				= 0;
	short		*sensitivity			= (short *)		argv[nbarg++]; /* sensitivity[nbspins] */
	short		*produit1			= (short *)		argv[nbarg++]; /* produit1[nbspins] */
	short		*mag				= (short *)		argv[nbarg++]; /* mag[nbspins] */
	int		*region_ok			= (int *)		argv[nbarg++]; /* region_ok[nbspins] */
	short		*cis_mode			= (short *)		argv[nbarg++]; /* cis_mode[nbspins] */
	int		*start				= (int *)		argv[nbarg++]; /* start[nbspins] */
	int		*solid				= (int *)		argv[nbarg++]; /* solid[nbspectres,nbcellules] */
	double		*deadtime			= (double *)		argv[nbarg++]; /* deadtime[2] */
	int		*sectorold			= (int *)		argv[nbarg++]; /* sectorold[nbspectres,nbcellules] */
	float		*duree_comptage			= (float *)		argv[nbarg++]; /* duree_comptage[nbspins] */ 
	int		*nb_accumulation		= (int *)		argv[nbarg++]; /* nb_accumulation[nbspins] */
	int		*tabtheta			= (int *)		argv[nbarg++]; /* tabtheta[nbspectres] */
	int		*tabphi				= (int *)		argv[nbarg++]; /* tabphi[nbspectres] */
	int		*tab1ienergie			= (int *)		argv[nbarg++]; /* si spin_average=	1 alors tab1ienergie[nbspins]
															0       tab1ienergie[nbspins*nbspectres] */
	int		*tab2ienergie			= (int *)		argv[nbarg++]; /* si spin_average=	1 alors tab2ienergie[nbspins]
															0       tab2ienergie[nbspins*nbspectres] */
	int		imasse				= *(int *)		argv[nbarg++];
	int		*indY				= (int *)		argv[nbarg++]; /* si spin_average=	1 alors indY[nbspins]
															0       indY[nbspins*nbspectres] */
	int		*indC				= (int *)		argv[nbarg++]; /* indC[nbspins] */
	float		*Emin				= (float *)		argv[nbarg++]; /* Emin[nbtablesE,nbenergies] */
	float		*Emoy				= (float *)		argv[nbarg++]; /* Emoy[nbtablesE,nbenergies] */
	float		*Emax				= (float *)		argv[nbarg++]; /* Emax[nbtablesE,nbenergies] */
	double		*efficacite			= (double *)		argv[nbarg++]; /* efficacite[] */
	double		*facteurG			= (double *)		argv[nbarg++]; /* facteurG[] */
	char		*tabdata			= (char *)		argv[nbarg++];
	int		no1				= *(int *)		argv[nbarg++];
	int		*debut				= (int *)		argv[nbarg++];
	int		*fin				= (int *)		argv[nbarg++];
	float		*dico				= (float *)		argv[nbarg++];
	int		nbytes				= *(int *)		argv[nbarg++];
	float		*Z				= (float *)		argv[nbarg++]; /* si spin_average=	1 alors Z[nbspins,nbspectres] 
															0       Z[nbspins*nbspectres,nbspectres]*/
	int		*sectornew			= (int *)		argv[nbarg++]; /* sectornew[nbspectres,nbcellules] */
	double		sectornew_date			= *(double *)		argv[nbarg++];
	double		*xmin				= (double *)		argv[nbarg++]; /* xmin[nbspins] = datation de chaque spin */
	float		*Q				= (float *)		argv[nbarg++]; /* Q[nbmasses] */
	double		*MASSE				= (double *)		argv[nbarg++]; /* MASSE[nbmasses] */
	int		*tabL				= (int *)		argv[nbarg++]; /* tabL[nbspins] */
	int		nbL				= *(int *)		argv[nbarg++];
	int		*start_pollution_solaire	= (int *)		argv[nbarg++]; /* start_pollution_solaire[nbspins] */
	int		*end_pollution_solaire		= (int *)		argv[nbarg++]; /* end_pollution_solaire[nbspins] */
	unsigned int	*sector_mask			= (unsigned int *)	argv[nbarg++]; /* sector_mask[nbspins] */
	int		*translation			= (int *)		argv[nbarg++]; /* translation[nbspins] */
	int		nbX				= *(int *)		argv[nbarg++];
	int		moyenner			= *(int *)		argv[nbarg++];
	unsigned char	*IMA_PAC			= (unsigned char *)	argv[nbarg++]; /* IMA_PAC[nbspins] */
	unsigned char	*MEA_GEOMFACTOR			= (unsigned char *)	argv[nbarg++]; /* MEA_GEOMFACTOR[nbspins] */
	unsigned char	*MEA_DATAID			= (unsigned char *)	argv[nbarg++]; /* MEA_DATAID[nbspins] */
	int		*TABINFO_INT			= (int *)		argv[nbarg++];
	double		*TABINFO_DOUBLE			= (double *)		argv[nbarg++];
	float		*DEMETER_TABLE_DEMETER		= (float *)		argv[nbarg++]; /* DEMETER_TABLE_DEMETER[nbenergies] */
	float		*DEMETER_TABLE_TARANIS		= (float *)		argv[nbarg++]; /* DEMETER_TABLE_TARANIS[nbenergies] */
	IDL_STRING	*CL_ROOT			= (IDL_STRING *)	argv[nbarg++];

	/* 
	start [i]         = start [i] 
	solid [i,j]       = solid  [i + j*nbspectres] 
	sector [i,j]      = sector [i + j*nbspectres] 
	duree [i]         = duree [i] 
	Z[i,j]            = if spin_average=	1: Z [i + j*nbspins]
						=0: Z [i + j*nbspins*nbalphas]
	*/

	int		ienergie1;
	int		ienergie2;
	int		nospectre;
	float		val;
	float		accumulation_duree;
	double		date;
	int		x;
	int		y;
	int		*nb = (int *)malloc(nbX*nbL*sizeof(int));

	int		pollue;

	int		ipac;
	int		igeomfactor;
	int		idataid;

	if (nbarg != argc) return;

	DEBUT ();
	MAVEN_SWEA_CALIB_DEBUT();

	if (moyenner) {
		for (x=0 ; x<nbX ; x++) {
			for (y=0 ; y<nbL ; y++) {
				nb[x + y*nbX]=0;
			}
		}
	}

	// Verrue DEMETER c/s_TARANIS
	if (is_DEMETER_IDP(nocis) && (cjf == C_SEC_TARANIS)) {
		for (ienergie=0 ; ienergie<nbenergies ; ienergie++) {
			val_demeter[ienergie] = DEMETER_TABLE_TARANIS[ienergie] / DEMETER_TABLE_DEMETER[ienergie]; // facteur par lequel on devra multipler les c/s
			//printf ("val_demeter[%d] = %f\n",ienergie,val_demeter[ienergie]);
		}
	}

	for (ispin=0 ; ispin<nbspins ; ispin++) {

		if (region_ok[ispin]==0) { 

			if (spin_average==0) {
				for (ispectre=0 ; ispectre<nbspectres ; ispectre++) {
					nospectre = ispin*nbspectres+ispectre;
					Z[nospectre]=1e34;
				}
			} else {
				Z[ispin]=1e34;
			}

			continue;

		}

		tabphi_to_okspectre (B, tabphi, nbspectres, start, ispin, produit1, prodmin, prodmax, okspectre, nocis);

		pollution_maj (nocis, ispin, cis_mode, start_pollution_solaire, end_pollution_solaire, nbspectres, nbcellules, nbangles, solid, pollution);

		if (is_ELS(nocis)) sector_mask_to_solid (sector_mask[ispin], nbcellules, solid);

		ipac			= IMA_PAC[ispin];
		igeomfactor		= MEA_GEOMFACTOR[ispin];
		idataid			= MEA_DATAID[ispin];
		icarte			= indC[ispin];
		isensitivity		= sensitivity[ispin];
		accumulation		= nb_accumulation[ispin];
		accumulation_duree	= accumulation*duree_comptage[ispin];
		date			= xmin[ispin];
		MAVEN_SWEA_CALIB_GET();
		sector			= date < sectornew_date ? sectorold : sectornew;
		p1			= get_p1(tabdata,no1);
		p2			= get_p2(tabdata,no1);
		p4			= get_p4(tabdata,no1);
		pfloat			= get_pfloat(tabdata,no1);
		pdouble			= get_pdouble(tabdata,no1);

		if (is_pad) GET_SOLID();

		y = tabL[ispin];
		if ((y<0) || (y>=nbL)) continue;

		for (ispectre=0 ; ispectre<nbspectres ; ispectre++) {

			if (okspectre[ispectre]==0) continue;

			for (icellule=0 ; icellule<nbcellules ; icellule++) {

				if (tabtheta[icellule]==0) continue;

				nospectre = ispin*nbspectres+ispectre;
				itable = spin_average==0 ? indY[translation[nospectre]]:indY[translation[ispin]];
				if (itable==-1) continue;
				ienergie1 = spin_average==0 ? tab1ienergie[nospectre]:tab1ienergie[ispin];
				ienergie2 = spin_average==0 ? tab2ienergie[nospectre]:tab2ienergie[ispin];
				if (ienergie1==-1 || ienergie2==-1 || ienergie1>ienergie2) {
					continue;
				}

				for (ienergie=ienergie1 ; ienergie<=ienergie2 ; ienergie++) {

					POLLUTION_ON (); if (pollue) continue;
					if (lire_eff && ((eff = get_eff) < -FILLVAL_E30)) continue;
					if (lire_fg && ((fg = get_fg ) < -FILLVAL_E30)) continue; // get_data_time_L_cjf
					COUP_TO_CJF1 (cjf);
					if (val < -FILLVAL_E30) continue;
					Z[translation[spin_average==1? ispin:nospectre] + y*nbX] += val;
					if (moyenner) nb[translation[spin_average==1? ispin:nospectre] + y*nbX]++;
				}

			}

		}

	}

	if (moyenner) {
		for (x=0 ; x<nbX ; x++) {
			for (y=0 ; y<nbL ; y++) {
				if (nb[x + y*nbX]) {
					Z[x + y*nbX] /= nb[x + y*nbX];
				}
			}
		}
	}

	FIN ();
	MAVEN_SWEA_CALIB_FIN();

	free (nb);

}

/*---------------------------------------------------------------------------*/
void GET_DATA_TIME_L_CJF_AUTO_GLUE (
/*---------------------------------------------------------------------------*/
	void	*p01,
	void	*p02,
	void	*p03,
	void	*p04,
	void	*p05,
	void	*p06,
	void	*p07,
	void	*p08,
	void	*p09,
	void	*p10,
	void	*p11,
	void	*p12,
	void	*p13,
	void	*p14,
	void	*p15,
	void	*p16,
	void	*p17,
	void	*p18,
	void	*p19,
	void	*p20,
	void	*p21,
	void	*p22,
	void	*p23,
	void	*p24,
	void	*p25,
	void	*p26,
	void	*p27,
	void	*p28,
	void	*p29,
	void	*p30,
	void	*p31,
	void	*p32,
	void	*p33,
	void	*p34,
	void	*p35,
	void	*p36,
	void	*p37,
	void	*p38,
	void	*p39,
	void	*p40,
	void	*p41,
	void	*p42,
	void	*p43,
	void	*p44,
	void	*p45,
	void	*p46,
	void	*p47,
	void	*p48,
	void	*p49,
	void	*p50,
	void	*p_CL_ROOT) {

	int		argc=51;
	void		*argv[51];
	IDL_STRING	*CL_ROOT;

	// p_CL_ROOT -> CL_ROOT
	CL_ROOT = malloc (sizeof(IDL_STRING));
	IDL_StrStore (CL_ROOT, p_CL_ROOT);

	argv[ 0] = p01;
	argv[ 1] = p02;
	argv[ 2] = p03;
	argv[ 3] = p04;
	argv[ 4] = p05;
	argv[ 5] = p06;
	argv[ 6] = p07;
	argv[ 7] = p08;
	argv[ 8] = p09;
	argv[ 9] = p10;
	argv[10] = p11;
	argv[11] = p12;
	argv[12] = p13;
	argv[13] = p14;
	argv[14] = p15;
	argv[15] = p16;
	argv[16] = p17;
	argv[17] = p18;
	argv[18] = p19;
	argv[19] = p20;
	argv[20] = p21;
	argv[21] = p22;
	argv[22] = p23;
	argv[23] = p24;
	argv[24] = p25;
	argv[25] = p26;
	argv[26] = p27;
	argv[27] = p28;
	argv[28] = p29;
	argv[29] = p30;
	argv[30] = p31;
	argv[31] = p32;
	argv[32] = p33;
	argv[33] = p34;
	argv[34] = p35;
	argv[35] = p36;
	argv[36] = p37;
	argv[37] = p38;
	argv[38] = p39;
	argv[39] = p40;
	argv[40] = p41;
	argv[41] = p42;
	argv[42] = p43;
	argv[43] = p44;
	argv[44] = p45;
	argv[45] = p46;
	argv[46] = p47;
	argv[47] = p48;
	argv[48] = p49;
	argv[49] = p50;
	argv[50] = CL_ROOT;
	GET_DATA_TIME_L_CJF (argc, argv);

	free (CL_ROOT);

}
