/*------------------------------------------------------------------------------
 *
 *	Fichier	: $RCSfile: file.c,v $, v $Revision: 1.50 $
 *
 *	Date	: $Date: 2021/04/27 09:48:58 $
 *
 *	Auteur	: $Author: penou $
 *
 *	Version : %Z% version %I% de %M% du %G%
 *
 *------------------------------------------------------------------------------
 */

#include <errno.h>


#include <libgen.h>		// basename
#include <unistd.h>

#include <stdio.h>
#include <stdlib.h>
#include <glob.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <math.h>
#include <string.h>
#include <ctype.h>

#ifdef GDL
#include "libgdl.h"
#else
#include "export.h"
#endif


#include "zlib.h"

#define indice3(i1,i2,i3,nb1,nb2,nb3)	((i1)+(nb1)*((i2)+(nb2)*(i3)))

int		il_faut_swapper;
double		*liste=NULL;
int		nbliste=0;
int		noliste;
int		histogramme[86400];
double		date_deb_intervalle;
double		date_fin_intervalle;
char		message[1024];

#ifdef __WIN32__
	#define MY_FSEEK(a,b,c)	fseeko64(a,b,c)
	#define MY_OFF_T 	off64_t
	#define MY_FSTAT(a,b)	_stati64(a,b)
	#define MY_STAT		_stati64
#else
	#define MY_FSEEK(a,b,c) fseeko(a,b,c)
	#define MY_OFF_T 	off_t
	#define MY_FSTAT(a,b)	stat(a,b)
	#define MY_STAT		stat
#endif


#define ISGZ(nom) (strlen(nom)>=4 && strcmp(nom+strlen(nom)-3,".gz")==0)
#define OPEN(isgz,nom,masque) (isgz ? gzopenXXX (nom,masque) : fopen (nom,masque))
#define READ(isgz,fd,ligne,taille) (isgz ? gzreadXXX (fd, ligne, taille) : fread (ligne, 1, taille, fd))
#define SEEK(isgz,fd,offset,whence) (isgz ? gzseekXXX (fd, offset, whence) : MY_FSEEK (fd, offset, whence))
#define CLOSE(isgz,fd) (isgz ? gzcloseXXX (fd) : fclose (fd))
#define FEOF(isgz,fd) (isgz ? gzeofXXX (fd) : feof (fd))


#define indice2(i1,i2,nb1,nb2)	((i1)+(nb1)*(i2))

#define	MAX_CONSTANTES	10240
#define	MAX_BUFFER	10240
#define	MAX_VARIABLES	10240
#define GENRE_CONST     0
#define GENRE_VAR       1
#define GENRE_FCT       2

#define	SPACE		" "
#define	TAB		"/t"

#define PLUS		0
#define MOINS		1
#define MULT		2
#define DIV		3
#define	ABS		4
#define	ATAN		5
#define	COSH		6
#define	EXP		7
#define FRAC		8
#define INT		9
#define	LOG		10
#define	SINH		11
#define SQRT		12
#define SQR		13
#define ACOS		14
#define ASIN		15
#define	ATAN2		16
#define	COS		17
#define LOG10		18
#define POW		19
#define SIN		20
#define TANH		21
#define TAN		22
#define SUP		23
#define INF		24
#define AND		25
#define OR		26
#define SUPEGAL		27
#define INFEGAL		28
#define EGAL		29
#define DIFFERENT	30
#define SHL		31
#define SHR		32

typedef char un_buffer[MAX_BUFFER];
typedef struct une_boite {
	int			genre;
	int			index;
	struct une_boite	*gauche;
	struct une_boite	*droite;
} une_boite;
typedef char un_mnemonique[11];
typedef char une_table_erreurs[11][81];
typedef struct _REC_une_table_symboles {
	int defini;
	double valeur;
} _REC_une_table_symboles;
typedef _REC_une_table_symboles	une_table_symboles[MAX_VARIABLES];
typedef double			une_table_constantes[MAX_CONSTANTES];

static un_buffer		buffer;
static une_table_erreurs	table_erreurs;
static une_table_symboles	table_symboles;
static une_table_constantes	table_constantes;
static int 			err;
static int 			i_err;
static int 			nb_constantes;
static int			check;


static char			symboles[MAX_VARIABLES][128];
static int			nbsymboles;

void terme (int *i, une_boite **arbre);
void facteur (int *i, une_boite **arbre);

float		*energy_tables_v86;		// pour is_v86 TARANIS
float		*delta_plus_energy_tables_v86;	// pour is_v86 TARANIS
float		*delta_minus_energy_tables_v86;	// pour is_v86 TARANIS
int		has_energy_table_v86;		// pour is_v86 TARANIS
int		nbenergies_v86;			// pour is_v86 TARANIS
int		nbtables_v86;			// pour is_v86 TARANIS
int		itable_v86;			// pour is_v86 TARANIS
int		ienergie_v86;			// pour is_v86 TARANIS
int		j_energy_table_1_v86=0;		// pour is_v86 TARANIS
int		presents_v86[32*16*32];		// pour is_v86
int		nbpresents_v86;			// pour is_v86
int		no1_v86;			// pour is_v86
int		k_v86;				// pour is_v86
float		*pfloat_v86;			// pour is_v86
unsigned char	b5_v86[5];			// pour is_v86
long long	position_v86;			// pour is_v86
int 		nblignes_v86;			// pour is_v86

/*---------------------------------------------------------------------------*/
void creer_arbre (une_boite **arbre, int genre, int index,
			une_boite *gauche, une_boite *droite) {
/*---------------------------------------------------------------------------*/

	*arbre = malloc (sizeof (une_boite));
	(*arbre)->genre = genre;
	(*arbre)->index = index;
	(*arbre)->gauche = gauche;
	(*arbre)->droite = droite;

}


/*---------------------------------------------------------------------------*/
void erreur_alpha (int error, char *expression, char *msg) {
/*---------------------------------------------------------------------------*/

	char		tmp[1024];
	int		i;
	
	for (i=0 ; i<i_err-1; i++)
			tmp[i] = expression[i];
	tmp[i]=0;

	sprintf (msg, "%s|-> %s", tmp, table_erreurs[error - 1]);

}


/*---------------------------------------------------------------------------*/
int est_mnemonique (int *k, char *mnemonique) {
/*---------------------------------------------------------------------------*/

	int 		Result;
	unsigned int 	j;
	int 		ok;
	int 		i;

	i = *k;
	j = 1;
	ok = 1;

	if (strlen (buffer) - i < strlen (mnemonique))
		ok = 0;

	while (ok && j <= strlen (mnemonique))
		if (buffer[i - 1] == mnemonique[j - 1] ||
			buffer[i - 1] == toupper (mnemonique[j - 1])) {
			i++;
			j++;
		} else {
			ok = 0;
		}

	Result = ok;

	if (ok)
		*k = i;

	return Result;

}


/*---------------------------------------------------------------------------*/
char signe (int *i) {
/*---------------------------------------------------------------------------*/

	if (est_mnemonique (i, "+"))
		return '+';
	else if (est_mnemonique (i, "-"))
		return '-';
	else
		return ' ';

}


/*---------------------------------------------------------------------------*/
int est_chiffre (int i) {
/*---------------------------------------------------------------------------*/

	return isdigit (buffer[i - 1]);

}


/*---------------------------------------------------------------------------*/
int est_lettre (int i) {
/*---------------------------------------------------------------------------*/

	return isupper (toupper (buffer[i - 1]));

}



/*---------------------------------------------------------------------------*/
void identification_de_variable (int *i, une_boite **arbre) {
/*---------------------------------------------------------------------------*/

	/* Err = 1,2,3 */
	int 	debut;
	int	indice;
	int	j;
	char	symbole[1024];

	debut = *i;

	while (est_lettre (*i) || est_chiffre (*i) || buffer[*i - 1] == '_')
		(*i)++;

	if (*i == debut) {
		/* Erreur 2: Pas d'identificateur */
		err = 2;
		i_err = debut;
		return;
	}

	for (j=0 ; j<*i-debut ; j++)
		symbole[j] = buffer[debut-1+j];
	symbole[j] = 0;

	for (j=0 ; j < nbsymboles; j++)
		if (strcasecmp (symboles[j], symbole) == 0) 
			break;
	indice = j;

	if (indice < nbsymboles) {
		creer_arbre (arbre, GENRE_VAR, indice, NULL, NULL);
		if (check == 1) {
			table_symboles[indice].valeur = 1;
		}

	} else {
		/* Erreur 3: symbole inconnu */
		err = 3;
		i_err = debut;
	}

}



/*---------------------------------------------------------------------------*/
void separateur (int *i) {
/*---------------------------------------------------------------------------*/

	do {
	} while (est_mnemonique (i, SPACE) || est_mnemonique (i, TAB));

}


/*---------------------------------------------------------------------------*/
void sequence_de_chiffres (int *i, double *resultat, int *ok) {
/*---------------------------------------------------------------------------*/


	*resultat = 0.0;
	*ok = 0;

	while (est_chiffre (*i)) {
		*ok = 1;
		*resultat = *resultat * 10 + buffer[*i - 1] - '0';
		(*i)++;
	}

}


/*---------------------------------------------------------------------------*/
void constante_non_signee (int *i, une_boite **arbre, int *ok) {
/*---------------------------------------------------------------------------*/

	/* err = 6 */
	// 1:	''	-> erreur
	// 2:	'e'	-> erreur
	// 3:	'e1'	-> erreur
	// 4:	'1'	-> ok
	// 5:	'1e'	-> ok
	// 6:	'1e1'	-> ok
	// 7:	'.'	-> erreur
	// 8:	'.e'	-> erreur
	// 9:	'.e1'	-> erreur
	// 10:	'1.'	-> ok
	// 11:	'1.e'	-> ok
	// 12:	'1.e1'	-> ok
	// 13:	'.1'	-> ok
	// 14:	'.1e'	-> ok
	// 15:	'.1e1'	-> ok
	// 16:	'1.1'	-> ok
	// 17:	'1.1e'	-> ok
	// 18:	'1.1e1'	-> ok
	double res, resultat;
	int lesigne;
	int j, k;
	int ok1		=	-1;
	int ok2		=	-1;
	int ok3		=	-1;

	if (est_mnemonique (i, "m_pi")) {
		*ok = 1;
		resultat = M_PI;
	} else {
		sequence_de_chiffres (i, &resultat, &ok1);
		*ok = ok1;

		if (est_mnemonique (i, ".")) {
			j = *i;
			sequence_de_chiffres (i, &res, &ok2);
			*ok = ok1 || ok2;
			if (*ok == 0) {
				/* Erreur 6: syntax error */
				err = 6;
				i_err = *i;
				return;
			}
			for (k = 1; k <= *i - j; k++)
				res *= 0.1;
			resultat += res;
		}

		if (*ok && est_mnemonique (i, "e")) {
			*ok = 1;
			separateur (i);
			lesigne = signe (i);
			separateur (i);
			sequence_de_chiffres (i, &res, &ok3);
			if (ok1) {
				for (k = 1; k <= (long)floor(res + 0.5); k++) {
					if (lesigne == '-')
						resultat *= 0.1;
					else
						resultat *= 10;
				}
			}
		}
	}

	if (!*ok)
		return;

	nb_constantes++;
	table_constantes[nb_constantes] = resultat;
	creer_arbre(arbre, GENRE_CONST, nb_constantes, NULL, NULL);

}


/*---------------------------------------------------------------------------*/
void expression_simple (int *i, une_boite **arbre) {
/*---------------------------------------------------------------------------*/

	int		fin;
	int		lesigne;
	une_boite	*arbre1;
	une_boite	*arbre2;
	int		indice;

	separateur (i);

	lesigne = signe (i);

	terme (i, arbre);

	if (err == 0 && lesigne == '-') {
		nb_constantes++;
		table_constantes[nb_constantes] = 0.0;
		creer_arbre (&arbre1, GENRE_CONST, nb_constantes, NULL, NULL);
		creer_arbre (&arbre2, GENRE_FCT, MOINS, arbre1, *arbre);
		*arbre = arbre2;
	}

	if (err != 0)
		return;

	do {
		fin = 0;
		if (est_mnemonique (i, "+"))
			indice = PLUS;
		else if (est_mnemonique (i, "-"))
			indice = MOINS;
		else if (est_mnemonique (i,"||"))
			indice = OR;
		else
			indice = -1;
		if (indice != -1) {
			terme (i, &arbre1);
			if (err == 0) {
				switch (indice) {
					case PLUS:
						creer_arbre (&arbre2, GENRE_FCT, PLUS, *arbre, arbre1);
						*arbre = arbre2;
						break;

					case MOINS:
						creer_arbre (&arbre2, GENRE_FCT, MOINS, *arbre, arbre1);
						*arbre = arbre2;
						break;

					case OR:
						creer_arbre (&arbre2, GENRE_FCT, OR, *arbre, arbre1);
						*arbre = arbre2;
						break;
				}
			}
		} else
			fin = 1;
	} while (!(err != 0 || fin));

}

/*---------------------------------------------------------------------------*/
void expression (int *i, une_boite **arbre) {
/*---------------------------------------------------------------------------*/

	int		fin;
	une_boite	*arbre1;
	une_boite	*arbre2;

	expression_simple (i, arbre);

	fin = 0;
	if (err == 0) {
		do {
			separateur (i);
			if (est_mnemonique (i, ">=")) {
				separateur (i);
				facteur (i, &arbre1);
				if (err == 0) {
					creer_arbre (&arbre2, GENRE_FCT, SUPEGAL, *arbre, arbre1);
					*arbre = arbre2;
				}
			} else if (est_mnemonique (i, "<=")) {
				separateur (i);
				facteur (i, &arbre1);
				if (err == 0) {
					creer_arbre (&arbre2, GENRE_FCT, INFEGAL, *arbre, arbre1);
					*arbre = arbre2;
				}
			} else if (est_mnemonique (i, ">")) {
				separateur (i);
				facteur (i, &arbre1);
				if (err == 0) {
					creer_arbre (&arbre2, GENRE_FCT, SUP, *arbre, arbre1);
					*arbre = arbre2;
				}
			} else if (est_mnemonique (i, "<")) {
				separateur (i);
				facteur (i, &arbre1);
				if (err == 0) {
					creer_arbre (&arbre2, GENRE_FCT, INF, *arbre, arbre1);
					*arbre = arbre2;
				}
			} else if (est_mnemonique (i, "==")) {
				separateur (i);
				facteur (i, &arbre1);
				if (err == 0) {
					creer_arbre (&arbre2, GENRE_FCT, EGAL, *arbre, arbre1);
					*arbre = arbre2;
				}
			} else if (est_mnemonique (i, "!=")) {
				separateur (i);
				facteur (i, &arbre1);
				if (err == 0) {
					creer_arbre (&arbre2, GENRE_FCT, DIFFERENT, *arbre, arbre1);
					*arbre = arbre2;
				}
			} else
				fin = 1;
		} while (!(fin || err != 0));
	}

	separateur (i);
	
}


/*---------------------------------------------------------------------------*/
void appel_de_fonction (int *i, une_boite **arbre, int *ok) {
/*---------------------------------------------------------------------------*/

	int indice=-1;	// gcc
	une_boite *arbre1, *arbre2;

	*ok = 1;

	if (est_mnemonique (i, "abs"))
		indice = ABS;
	else if (est_mnemonique (i, "atan2"))
		indice = ATAN2;
	else if (est_mnemonique (i, "atan"))
		indice = ATAN;
	else if (est_mnemonique (i, "cosh"))
		indice = COSH;
	else if (est_mnemonique (i, "exp"))
		indice = EXP;
	else if (est_mnemonique (i, "frac"))
		indice = FRAC;
	else if (est_mnemonique (i, "int"))
		indice = INT;
	else if (est_mnemonique (i, "log10"))
		indice = LOG10;
	else if (est_mnemonique (i, "log"))
		indice = LOG;
	else if (est_mnemonique (i, "sinh"))
		indice = SINH;
	else if (est_mnemonique (i, "sqrt"))
		indice = SQRT;
	else if (est_mnemonique (i, "sqr"))
		indice = SQR;
	else if (est_mnemonique (i, "acos"))
		indice = ACOS;
	else if (est_mnemonique (i, "asin"))
		indice = ASIN;
	else if (est_mnemonique (i, "cos"))
		indice = COS;
	else if (est_mnemonique (i, "pow"))
		indice = POW;
	else if (est_mnemonique (i, "sin"))
		indice = SIN;
	else if (est_mnemonique (i, "tanh"))
		indice = TANH;
	else if (est_mnemonique (i, "tan"))
		indice = TAN;
	else
		*ok = 0;

	if (!*ok)
		return;

	separateur(i);

	if (est_mnemonique (i, "(")) {
		expression (i, &arbre1);
		if (indice == ATAN2 || indice == POW) {
			separateur (i);
			if (est_mnemonique (i, ","))
				expression (i, &arbre2);
			else {
				/* Erreur 11: "," attendu */
				err = 11;
				i_err = *i;
			}
		} else
			arbre2 = NULL;
		if (err == 0)
			if (!est_mnemonique (i, ")")) {
				/* Erreur 5: manque ")" apres le parametre */
				err = 5;
				i_err = *i;
			}
	} else {
		/* Erreur 4: manque "(" apres la fonction */
		err = 4;
		i_err = *i;
	}

	if (err == 0)
		creer_arbre (arbre, GENRE_FCT, indice, arbre1, arbre2);

}


/*---------------------------------------------------------------------------*/
void facteur (int *i, une_boite **arbre) {
/*---------------------------------------------------------------------------*/

	int lesigne;
	une_boite *arbre1, *arbre2;
	int ok;

	lesigne = signe (i);

	separateur (i);

	constante_non_signee (i, arbre, &ok);

	if (!ok) {

		if (err) {

		} else if (est_mnemonique (i, "(")) {

			expression (i, arbre);
			if (err != 0)
				return;
			if (!est_mnemonique (i, ")")) {
				/* Erreur 7: manque "(" */
				err = 7;
				i_err = *i;
			}

		} else {

			appel_de_fonction (i, arbre, &ok);

			if (!ok)
				identification_de_variable (i, arbre);

		}
	}

	if (err == 0 && lesigne == '-') {
		nb_constantes++;
		table_constantes[nb_constantes] = 0.0;
		creer_arbre (&arbre1, GENRE_CONST, nb_constantes, NULL, NULL);
		creer_arbre (&arbre2, GENRE_FCT, MOINS, arbre1, *arbre);
		*arbre = arbre2;
	}

}


/*---------------------------------------------------------------------------*/
void terme (int *i, une_boite **arbre) {
/*---------------------------------------------------------------------------*/

	int fin;
	une_boite *arbre1, *arbre2;

	separateur (i);

	facteur (i, arbre);

	fin = 0;
	if (err == 0) {
		do {
			separateur (i);
			if (est_mnemonique (i, "*")) {
				separateur (i);
				facteur (i, &arbre1);
				if (err == 0) {
					creer_arbre (&arbre2, GENRE_FCT, MULT, *arbre, arbre1);
					*arbre = arbre2;
				}
			} else if (est_mnemonique (i, "/")) {
				separateur (i);
				facteur (i, &arbre1);
				if (err == 0) {
					creer_arbre (&arbre2, GENRE_FCT, DIV, *arbre, arbre1);
					*arbre = arbre2;
				}
			} else if (est_mnemonique (i, "&&")) {
				separateur (i);
				facteur (i, &arbre1);
				if (err == 0) {
					creer_arbre (&arbre2, GENRE_FCT, AND, *arbre, arbre1);
					*arbre = arbre2;
				}
			} else if (est_mnemonique (i, "<<")) {
				separateur (i);
				facteur (i, &arbre1);
				if (err == 0) {
					creer_arbre (&arbre2, GENRE_FCT, SHL, *arbre, arbre1);
					*arbre = arbre2;
				}
			} else if (est_mnemonique (i, ">>")) {
				separateur (i);
				facteur (i, &arbre1);
				if (err == 0) {
					creer_arbre (&arbre2, GENRE_FCT, SHR, *arbre, arbre1);
					*arbre = arbre2;
				}
			} else
				fin = 1;
		} while (!(fin || err != 0));
	}

	separateur (i);

}


/*---------------------------------------------------------------------------*/
void construire_arbre (char *buffer1, une_boite **arbre, int *error) {
/*---------------------------------------------------------------------------*/

	int i;

	sprintf (buffer, "%s\377", buffer1);
	i = 1;
	err = 0;

	nb_constantes = -1;
	*arbre = NULL;

	expression (&i, arbre);
	if (err == 0 && (buffer[i - 1] & 255) != 255) {
		/* Erreur 8: expression mal terminee */
		err = 8;
		i_err = i;
	}
	*error = err;

}


/*---------------------------------------------------------------------------*/
void detruire_arbre (une_boite *arbre) {
/*---------------------------------------------------------------------------*/

	if (arbre == NULL)
		return;

	detruire_arbre (arbre->gauche);
	detruire_arbre (arbre->droite);
	free (arbre);

}


/*---------------------------------------------------------------------------*/
double eval (une_boite *arbre) {
/*---------------------------------------------------------------------------*/

	double Result=0, tampon1, tampon2, DUMMY, TEMP;

	if (arbre == NULL) {
		return 0.0;
	}

	if (err != 0) {
		return Result;
	}

	switch (arbre->genre) {

		case GENRE_CONST:
			Result = table_constantes[arbre->index];
			break;

		case GENRE_VAR:
			Result = table_symboles[arbre->index].valeur;
			break;

		case GENRE_FCT:
			switch (arbre->index) {

				case PLUS:
					tampon1 = eval (arbre->gauche);
					tampon2 = eval (arbre->droite);
					if (err == 0)
						Result = tampon1 + tampon2;
					break;

				case MOINS:
					tampon1 = eval (arbre->gauche);
					tampon2 = eval (arbre->droite);
					if (err == 0)
						Result = tampon1 - tampon2;
					break;

				case MULT:
					tampon1 = eval (arbre->gauche);
					if (tampon1 == 0) {	/* Optimisation */
						Result = 0;
					} else {
						tampon2 = eval (arbre->droite);
						if (err == 0)
							Result = tampon1 * tampon2;
					}
					break;

				case DIV:
					tampon1 = eval (arbre->gauche);
					tampon2 = eval (arbre->droite);
					if (tampon1 == 0) {	/* Optimisation qui peut faire que 0/0 = 0 */
						Result = 0;
					} else if (tampon2 == 0 && err == 0) {
						err = 9;
					} else if (err == 0)
						Result = tampon1 / tampon2;
					break;

				case SUP:
					tampon1 = eval (arbre->gauche);
					tampon2 = eval (arbre->droite);
					if (err == 0)
						Result = tampon1 > tampon2;
					break;

				case INF:
					tampon1 = eval (arbre->gauche);
					tampon2 = eval (arbre->droite);
					if (err == 0)
						Result = tampon1 < tampon2;
					break;

				case SUPEGAL:
					tampon1 = eval (arbre->gauche);
					tampon2 = eval (arbre->droite);
					if (err == 0)
						Result = tampon1 >= tampon2;
					break;

				case INFEGAL:
					tampon1 = eval (arbre->gauche);
					tampon2 = eval (arbre->droite);
					if (err == 0)
						Result = tampon1 <= tampon2;
					break;

				case EGAL:
					tampon1 = eval (arbre->gauche);
					tampon2 = eval (arbre->droite);
					if (err == 0)
						Result = tampon1 == tampon2;
					break;

				case DIFFERENT:
					tampon1 = eval (arbre->gauche);
					tampon2 = eval (arbre->droite);
					if (err == 0)
						Result = tampon1 != (int)tampon2;
					break;

				case SHL:
					tampon1 = eval (arbre->gauche);
					tampon2 = eval (arbre->droite);
					if (err == 0)
						Result = (int)tampon1 << (int)tampon2;
					break;

				case SHR:
					tampon1 = eval (arbre->gauche);
					tampon2 = eval (arbre->droite);
					if (err == 0)
						Result = (int)tampon1 >> (int)tampon2;
					break;

				case AND:
					tampon1 = eval (arbre->gauche);
					tampon2 = eval (arbre->droite);
					if (err == 0)
						Result = tampon1 && tampon2;
					break;

				case OR:
					tampon1 = eval (arbre->gauche);
					tampon2 = eval (arbre->droite);
					if (err == 0)
						Result = tampon1 || tampon2;
					break;

				case ABS:
					tampon1 = eval (arbre->gauche);
					if (err == 0)
						Result = fabs (tampon1);
					break;

				case ATAN:
					tampon1 = eval (arbre->gauche);
					if (err == 0)
						Result = atan (tampon1);
					break;

				case COS:
					tampon1 = eval (arbre->gauche);
					if (err == 0)
						Result = cos (tampon1);
					break;

				case EXP:
					tampon1 = eval (arbre->gauche);
					if (err == 0)
						Result = exp (tampon1);
					break;

				case FRAC:
					tampon1 = eval (arbre->gauche);
					if (err == 0)
						Result = modf (tampon1, &DUMMY);
					break;

				case INT:
					tampon1 = eval (arbre->gauche);
					if (err == 0) {
						modf (tampon1, &TEMP);
						Result = TEMP;
					}
					break;

				case LOG:
					tampon1 = eval (arbre->gauche);
					if (tampon1 <= 0 && err == 0) {
						err = 9;
					} else if (err == 0)
						Result = log (tampon1);
					break;

				case SIN:
					tampon1 = eval (arbre->gauche);
					if (err == 0)
						Result = sin (tampon1);
					break;

				case SQRT:
					tampon1 = eval (arbre->gauche);
					if (tampon1 < 0 && err == 0) {
						err = 9;
					} else if (err == 0)
						Result = sqrt(tampon1);
					break;

				case SQR:
					tampon1 = eval (arbre->gauche);
					if (err == 0)
						Result = tampon1 * tampon1;
					break;

				case ACOS:
					tampon1 = eval (arbre->gauche);
					if (err == 0 && (tampon1 < -1 || tampon1 > 1)) {
						err = 9;
					} else if (err == 0)
						Result = acos (tampon1);
					break;

				case ASIN:
					tampon1 = eval (arbre->gauche);
					if (err == 0 && (tampon1 < -1 || tampon1 > 1)) {
						err = 9;
					} else if (err == 0)
						Result = asin (tampon1);
					break;

				case ATAN2:
					tampon1 = eval (arbre->gauche);
					tampon2 = eval (arbre->droite);
					if (err == 0)
						Result = atan2 (tampon1, tampon2);
					break;

				case COSH:
					tampon1 = eval (arbre->gauche);
					if (err == 0)
						Result = 1.0 / 2 * (exp (tampon1) + exp (-tampon1));
					break;

				case LOG10:
					tampon1 = eval (arbre->gauche);
					if (err == 0 && tampon1 <= 0) {
						err = 9;
					} else
						Result = log (tampon1) / log(10.0);
					break;

				case POW:
					tampon1 = eval (arbre->gauche);
					if (err == 0) {
						tampon2 = eval (arbre->droite);
						if (err == 0)
							Result = pow (tampon1, tampon2);
					}
					break;

				case SINH:
					tampon1 = eval (arbre->gauche);
					if (err == 0)
						Result = 1.0 / 2 * (exp (tampon1) - exp (-tampon1));
					break;

				case TANH:
					tampon1 = eval (arbre->gauche);
					if (err == 0)
						Result = (exp (2 * tampon1) - 1) / (exp (2 * tampon1) + 1);
					break;

				case TAN:
					tampon1 = eval (arbre->gauche);
					if (err == 0)
						Result = tan (tampon1);
					break;

			}
			break;
	}
	return Result;

}



/*---------------------------------------------------------------------------*/
void evaluer_arbre (une_boite *arbre, double *resultat, int *error) {
/*---------------------------------------------------------------------------*/

	err = 0;
	*resultat = eval(arbre);
	*error = err;

}


/*---------------------------------------------------------------------------*/
void arbre_init (void) {
/*---------------------------------------------------------------------------*/

	strcpy (table_erreurs[0], "Variable identififier too long");
	strcpy (table_erreurs[1], "Expression expected");
	strcpy (table_erreurs[2], "Unknown variable identifier");
	strcpy (table_erreurs[3], "\"(\" expected after function indentifier");
	strcpy (table_erreurs[4], "\")\" expected after parameter");
	strcpy (table_erreurs[5], "Syntax error");
	strcpy (table_erreurs[6], "\")\" expected at the end of expression");
	strcpy (table_erreurs[7], "Expression incorrectly terminated");
	strcpy (table_erreurs[8], "Out of definition domain");
	strcpy (table_erreurs[9], "Incompatible value");
	strcpy (table_erreurs[10], "\",\" expected");

	nbsymboles=0;

}


/*---------------------------------------------------------------------------*/
int EVALUER_TABLEAU (int argc, void *argv[]) {
/*---------------------------------------------------------------------------*/

	IDL_STRING 	*expression_IDL	=	(IDL_STRING *)	argv[0]; /* (entre) expression mathmatique  valuer */
	IDL_STRING	*variable_IDL	=	(IDL_STRING *)	argv[1]; /* (entre) variable_IDL[nbvar]: noms des diffrentes variables */
	int		nb		=	*(int *)	argv[2]; 
	int		nbvar		=	*(int *)	argv[3]; 
	float		*tabvar		=	(float *)	argv[4]; /* (entre) tabvar[nbvar][nb]: nb valeurs des differentes variables */
	float		*taboutput	=	(float *)	argv[5]; /* (sortie) taboutput[nb]: nb resultat de l'valuation */
	int		*erreur		=	(int *)		argv[6];
	IDL_STRING	*erreur_msg_IDL	=	(IDL_STRING *)	argv[7];
	int		chk		=	*(int *)	argv[8]; /* (entre) 1 ou 0 */

	/*
	Si chk vaut 1, les variables utilises dans l'expression mathmatique auront leurs entres dans tabvar mises  1
	*/

	int		error;
	une_boite	*arbre;
	char		erreur_msg[1024]="";
	int		i;
	int		j;
	double		resultat;
	int		fillval=0;

	check = chk;

	*erreur = 0;

	arbre_init ();
	nbsymboles = nbvar;
	for (j=0 ; j<nbvar ; j++) {
		sprintf (symboles[j],"%s",IDL_STRING_STR(variable_IDL+j));
		#ifdef DEBUG
		IDL_Message (IDL_M_NAMED_GENERIC, IDL_MSG_INFO, symboles[j]);
		#endif
		if (check == 1)
			table_symboles[j].valeur = tabvar[j];
	}

	construire_arbre (IDL_STRING_STR(expression_IDL), &arbre, &error);
	if (check == 1) {
		for (j=0 ; j<nbvar ; j++) {
			tabvar[j] = table_symboles[j].valeur;
		}
	}

	if (error == 0) {

		for (i=0 ; i<nb ; i++) {

			for (j=0 ; j<nbvar ; j++) {
				table_symboles[j].valeur = tabvar[indice2(j,i,nbvar,nb)];
				fillval = table_symboles[j].valeur < -1e30;
				if (fillval)
					break;
			}
			if (fillval)
				resultat = -1e31;
			else
				evaluer_arbre (arbre, &resultat, &error);
			taboutput[i] = resultat;
		}
		error = 0;

	} else {

		erreur_alpha (error, IDL_STRING_STR(expression_IDL), erreur_msg);
		for (i=0 ; i<nb ; i++) {
			taboutput[i] = 0;
		}

	}


	//IDL_StrEnsureLength (erreur_msg_IDL, strlen(erreur_msg));
	IDL_StrStore (erreur_msg_IDL, erreur_msg);

	*erreur = (error != 0);
	detruire_arbre (arbre);

	return 0;

}

/*---------------------------------------------------------------------------*/
int EVALUER_TABLEAU_AUTO_GLUE (
/*---------------------------------------------------------------------------*/
	void	*p_expression_IDL,
	void	*p_variable_IDL,
	void	*p03,
	void	*p_nbvar,
	void	*p05,
	void	*p06,
	void	*p07,
	void	*p_erreur_msg_IDL,
	void	*p09) {

	int		argc=9;
	void		*argv[9];
	int		nbvar = * (int *) p_nbvar;
	int		i;
	int		code;
	IDL_STRING	*expression_IDL;
	IDL_STRING	*variable_IDL;
	IDL_STRING	*erreur_msg_IDL;

	// p_expression_IDL -> expression_IDL
	expression_IDL = malloc (sizeof(IDL_STRING));
	IDL_StrStore (expression_IDL, p_expression_IDL);

	// p_variable_IDL -> variable_IDL
	variable_IDL = malloc (nbvar * sizeof(IDL_STRING));
	for (i=0 ; i<nbvar ; i++) IDL_StrStore (variable_IDL+i, p_variable_IDL+i*1024);

	// p_erreur_msg_IDL -> erreur_msg_IDL
	erreur_msg_IDL = malloc (sizeof(IDL_STRING));
	IDL_StrStore (erreur_msg_IDL, p_erreur_msg_IDL);

	argv[0] = expression_IDL;
	argv[1] = variable_IDL;
	argv[2] = p03;
	argv[3] = p_nbvar;
	argv[4] = p05;
	argv[5] = p06;
	argv[6] = p07;
	argv[7] = erreur_msg_IDL;
	argv[8] = p09;
	code = EVALUER_TABLEAU (argc, argv);

	// erreur_msg_IDL -> p_erreur_msg_IDL
	sprintf (p_erreur_msg_IDL,"%s",IDL_STRING_STR(erreur_msg_IDL));

	free (expression_IDL);
	free (variable_IDL);
	free (erreur_msg_IDL);

	return code;

}


/*---------------------------------------------------------------------------*/
int EVALUER_SIMPLE (int argc, void *argv[]) {
/*---------------------------------------------------------------------------*/

	IDL_STRING 	*expression_IDL	=	(IDL_STRING *)	argv[0];
	double		*resultat	=	(double *)	argv[1];
	int		*erreur		=	(int *)		argv[2];
	IDL_STRING	*erreur_msg_IDL	=	(IDL_STRING *)	argv[3];

	int		error;
	une_boite	*arbre;
	char		erreur_msg[1024]="";

	*erreur = 0;
	*resultat = 0;


	arbre_init ();
	construire_arbre (IDL_STRING_STR(expression_IDL), &arbre, &error);

	if (error == 0) {

		evaluer_arbre (arbre, resultat, &error);

	} else {

		erreur_alpha (error, IDL_STRING_STR(expression_IDL), erreur_msg);

	}

	//IDL_StrEnsureLength (erreur_msg_IDL, strlen(erreur_msg));
	IDL_StrStore (erreur_msg_IDL, erreur_msg);

	*erreur = (error != 0);
	detruire_arbre (arbre);

	return 0;

}

/*---------------------------------------------------------------------------*/
int EVALUER_SIMPLE_AUTO_GLUE (
/*---------------------------------------------------------------------------*/
	void	*p_expression_IDL,
	void	*p02,
	void	*p03,
	void	*p_erreur_msg_IDL) {

	int		argc=4;
	void		*argv[4];
	int		code;
	IDL_STRING	*expression_IDL;
	IDL_STRING	*erreur_msg_IDL;

	// p_expression_IDL -> expression_IDL
	expression_IDL = malloc (sizeof(IDL_STRING));
	IDL_StrStore (expression_IDL, p_expression_IDL);

	// p_erreur_msg_IDL -> erreur_msg_IDL
	erreur_msg_IDL = malloc (sizeof(IDL_STRING));
	IDL_StrStore (erreur_msg_IDL, p_erreur_msg_IDL);

	argv[0] = expression_IDL;
	argv[1] = p02;
	argv[2] = p03;
	argv[3] = erreur_msg_IDL;
	code = EVALUER_SIMPLE (argc, argv);

	// erreur_msg_IDL -> p_erreur_msg_IDL
	sprintf (p_erreur_msg_IDL,"%s",IDL_STRING_STR(erreur_msg_IDL));

	free (expression_IDL);
	free (erreur_msg_IDL);

	return code;
}

/*---------------------------------------------------------------------------*/
int expression_externe (int etape, IDL_STRING *expression, int nb, IDL_STRING *nom_champ, double *valeur_champ, double *resultat,
			int *find,
			IDL_STRING *erreur_msg_IDL) {
/*---------------------------------------------------------------------------*/


	int			error=0;
	static une_boite	*arbre;
	int			i;
	char			erreur_msg[1024]="";
	int			impossible_a_evaluer=0;


	if (etape==1) {

		arbre_init ();
		nbsymboles = 0;
		for (i=0 ; i<nb ; i++) {
			if (find[i]) {
				sprintf (symboles[nbsymboles++],"%s",IDL_STRING_STR(nom_champ+i));
			}
		}
		construire_arbre (IDL_STRING_STR(expression), &arbre, &error);

	} else if (etape == 2) {

		nbsymboles = 0;
		for (i=0 ; i<nb ; i++) {
			if (find[i]) {
				table_symboles[nbsymboles++].valeur = valeur_champ[i];
				if (valeur_champ[i] < -1e30) {
					impossible_a_evaluer=1;
					break;
				}
			}
		}

		if (impossible_a_evaluer) {
			*resultat = -1e31;
		} else {
			evaluer_arbre (arbre, resultat, &error);
		}

	}

	if (error != 0) {

		erreur_alpha (error, IDL_STRING_STR(expression), erreur_msg);
		resultat = 0;

	}

	//IDL_StrEnsureLength (erreur_msg_IDL, strlen(erreur_msg));
	IDL_StrStore (erreur_msg_IDL, erreur_msg);

	return error;

}


/*---------------------------------------------------------------------------*/
int julday (int mm, int id, int iyyy, int *julian) {
/*---------------------------------------------------------------------------*/

	#define igreg1 588829

	int ja,jm,jy,jul;

	if (iyyy==0)
		return -1;

	if (iyyy < 0)
		iyyy = iyyy + 1; 
	if (mm > 2) {
		jy = iyyy;
		jm = mm+1;
	} else {
		jy = iyyy-1;
		jm = mm+13;
	}
	jul = (int)(365.25*jy) + (int)(30.6001*jm) + id + 1720995;

	if (id+31*(mm+12*iyyy) >= igreg1) {
		ja = (int)(0.01*jy);
		jul = jul + 2 - ja + (int)(0.25*ja);
	}
	*julian = jul;

	return 0;

}

/*---------------------------------------------------------------------------*/
void caldat (int *mm, int *id, int *iyyy, int julian) {
/*---------------------------------------------------------------------------*/

	#define igreg2 2299161

	int je,jd,jc,jb,jalpha,ja;

	if (julian > igreg2) {
		jalpha = (int)(((julian-1867216)-0.25)/36524.25);
		ja = julian + 1 + jalpha - (int)(0.25*jalpha);
	} else
		ja = julian;

	jb = ja + 1524;
	jc = (int)(6680.0 + ((jb - 2439870)-122.1)/365.25);
	jd = 365*jc + (int)(0.25*jc);
	je = (int)((jb - jd)/30.6001);
	*id = jb - jd - (int)(30.6001*je);
	*mm = je - 1;
	if (*mm > 12)
		*mm = *mm - 12;
	*iyyy = jc - 4715;
	if (*mm > 2)
		*iyyy = *iyyy - 1;
	if (*iyyy <= 0)
		*iyyy = *iyyy - 1;

}


#define julian1958 2436205

/*---------------------------------------------------------------------------*/
void date_to_tu (double date, int *annee, int *mois, int *jour, int *heure, int *minute, double *seconde) {
/*---------------------------------------------------------------------------*/

	int	julian;

	julian = julian1958 + (int)(date/86400000);
	caldat (mois, jour, annee, julian);

	*seconde = (date - (double)(julian-julian1958)*86400000)/1000;
	*heure = *seconde / 3600;

	*seconde = *seconde - *heure*3600;

	*minute = *seconde / 60;

	*seconde = *seconde - *minute*60;

}

/*---------------------------------------------------------------------------*/
void longdoubledate_to_tu (long double date, int *annee, int *mois, int *jour, int *heure, int *minute, double *seconde) {
/*---------------------------------------------------------------------------*/

	int	julian;

	julian = julian1958 + (int)(date/86400000);
	caldat (mois, jour, annee, julian);

	*seconde = (date - (double)(julian-julian1958)*86400000)/1000;
	*heure = *seconde / 3600;

	*seconde = *seconde - *heure*3600;

	*minute = *seconde / 60;

	*seconde = *seconde - *minute*60;

}

/*---------------------------------------------------------------------------*/
void nanodate_to_tu (long nanodate, int *annee, int *mois, int *jour, int *heure, int *minute, int *seconde, int *milli, int *micro, int *nano) {
/*---------------------------------------------------------------------------*/

	int	julian;
	long	tmp;
	int	nbjours;

	nbjours = nanodate / 86400000000000L;
	julian = julian1958 + nbjours;
	caldat (mois, jour, annee, julian);

	tmp	= nanodate - nbjours*86400000000000L;
	*heure    = tmp   / 3600000000000L;
	tmp     -= *heure * 3600000000000L;
	*minute   = tmp    / 60000000000L;
	tmp     -= *minute * 60000000000L;
	*seconde  = tmp /     1000000000L;
	tmp     -= *seconde * 1000000000L;
	*milli    = tmp   / 1000000L;
	tmp     -= *milli * 1000000L;
	*micro    = tmp   / 1000L;
	tmp     -= *micro * 1000L;
	*nano     = tmp;

}

/*---------------------------------------------------------------------------*/
double tu_to_date (int ann, int moi, int jou, int heu, int min, double sec) {
/*---------------------------------------------------------------------------*/

	int	julian=0; // initialis sinon warning gcc
	int	nbjours;
	int	nbms;
	double	date;

	// static variables to call julday() only when necessary
	static int ann1 = -1;
	static int moi1 = -1;
	static int jou1 = -1;
	static int julian1 = -1;

	if (ann==ann1 && moi==moi1 && jou==jou1) {
		julian = julian1;
	} else {
		julday (moi, jou, ann, &julian);
		ann1 = ann;
		moi1 = moi;
		jou1 = jou;
		julian1 = julian;
	}

	nbjours = julian - julian1958;
	nbms    = heu*3600000. + min*60000. + (int)(sec*1000. +0.5); /* pb arrondi */
	date    = nbjours*86400000. + nbms;
	return date;

}

/*---------------------------------------------------------------------------*/
int RENOMMER (int argc, void *argv[]) {
/*---------------------------------------------------------------------------*/

	IDL_STRING *nom1_IDL = (IDL_STRING *) argv[0]; 
	IDL_STRING *nom2_IDL = (IDL_STRING *) argv[1]; 

	int code;

	remove(IDL_STRING_STR(nom2_IDL));
	if (rename (IDL_STRING_STR(nom1_IDL),IDL_STRING_STR(nom2_IDL))!=0)
		code = -1;
	else
		code = 0;

	return code;

}

/*---------------------------------------------------------------------------*/
int RENOMMER_AUTO_GLUE (
/*---------------------------------------------------------------------------*/
	void	*p_nom1_IDL,
	void	*p_nom2_IDL) {

	int		argc=2;
	void		*argv[2];
	int		code;
	IDL_STRING	*nom1_IDL;
	IDL_STRING	*nom2_IDL;

	// p_nom1_IDL -> nom1_IDL
	nom1_IDL = malloc (sizeof(IDL_STRING));
	IDL_StrStore (nom1_IDL, p_nom1_IDL);

	// p_nom2_IDL -> nom2_IDL
	nom2_IDL = malloc (sizeof(IDL_STRING));
	IDL_StrStore (nom2_IDL, p_nom2_IDL);

	argv[0] = nom1_IDL;
	argv[1] = nom2_IDL;
	code = RENOMMER (argc, argv);

	free (nom1_IDL);
	free (nom2_IDL);

	return code;
}


/*---------------------------------------------------------------------------*/
int COPIER (int argc, void *argv[]) {
/*---------------------------------------------------------------------------*/

	IDL_STRING *nom1_IDL = (IDL_STRING *) argv[0]; 
	IDL_STRING *nom2_IDL = (IDL_STRING *) argv[1]; 

	/*

	Recopie le fichier nom1 dans nom2
	Retourne 0 si OK et 1 si PB

	*/

	FILE		*fd1=NULL;
	FILE		*fd2=NULL;
	char		*buffer=NULL;
	#define		copier_MAX	1024*1024
	int		code=1;
	int		read;

	if ((fd1 = fopen (IDL_STRING_STR(nom1_IDL),"rb")) == NULL)
		goto copier_EXIT;

	if ((fd2 = fopen (IDL_STRING_STR(nom2_IDL),"wb")) == NULL)
		goto copier_EXIT;

	if ((buffer = (char *)malloc (copier_MAX)) == NULL)
		goto copier_EXIT;

	while (!feof(fd1)) {

		read = fread (buffer, sizeof(char), copier_MAX, fd1);

		if (fwrite (buffer, sizeof(char), read, fd2) != read)
			goto copier_EXIT;

	}

	code = 0;

copier_EXIT:

	if (fd1 != NULL)    fclose (fd1);
	if (fd2 != NULL)    fclose (fd2);
	if (buffer != NULL) free (buffer);

	return code;

}

/*---------------------------------------------------------------------------*/
int COPIER_AUTO_GLUE (
/*---------------------------------------------------------------------------*/
	void	*p_nom1_IDL,
	void	*p_nom2_IDL) {

	int		argc=2;
	void		*argv[2];
	int		code;
	IDL_STRING	*nom1_IDL;
	IDL_STRING	*nom2_IDL;

	// p_nom1_IDL -> nom1_IDL
	nom1_IDL = malloc (sizeof(IDL_STRING));
	IDL_StrStore (nom1_IDL, p_nom1_IDL);

	// p_nom2_IDL -> nom2_IDL
	nom2_IDL = malloc (sizeof(IDL_STRING));
	IDL_StrStore (nom2_IDL, p_nom2_IDL);

	argv[0] = nom1_IDL;
	argv[1] = nom2_IDL;
	code = COPIER (argc, argv);

	free (nom1_IDL);
	free (nom2_IDL);

	return code;
}


/*---------------------------------------------------------------------------*/
int DETRUIRE (int argc, void *argv[]) {
/*---------------------------------------------------------------------------*/

	IDL_STRING *nom_IDL = (IDL_STRING *) argv[0]; 

	int code;

	if (remove (IDL_STRING_STR(nom_IDL))!=0)
		code = -1;
	else
		code = 0;

	return code;

}


/*---------------------------------------------------------------------------*/
int DETRUIRE_AUTO_GLUE (
/*---------------------------------------------------------------------------*/
	void	*p_nom_IDL) {

	int		argc=1;
	void		*argv[1];
	int		code;
	IDL_STRING	*nom_IDL;

	// p_nom_IDL -> nom_IDL
	nom_IDL = malloc (sizeof(IDL_STRING));
	IDL_StrStore (nom_IDL, p_nom_IDL);

	argv[0] = nom_IDL;
	code = DETRUIRE (argc, argv);

	free (nom_IDL);

	return code;
}

/*---------------------------------------------------------------------------*/
int DETRUIRE_REPERTOIRE (int argc, void *argv[]) {
/*---------------------------------------------------------------------------*/

	IDL_STRING *nom_IDL = (IDL_STRING *) argv[0]; 

	int code;

	if (rmdir (IDL_STRING_STR(nom_IDL))!=0)
		code = -1;
	else
		code = 0;

	return code;

}

/*---------------------------------------------------------------------------*/
int DETRUIRE_REPERTOIRE_AUTO_GLUE (
/*---------------------------------------------------------------------------*/
	void	*p_nom_IDL) {

	int		argc=1;
	void		*argv[1];
	int		code;
	IDL_STRING	*nom_IDL;

	// p_nom_IDL -> nom_IDL
	nom_IDL = malloc (sizeof(IDL_STRING));
	IDL_StrStore (nom_IDL, p_nom_IDL);

	argv[0] = nom_IDL;
	code = DETRUIRE_REPERTOIRE (argc, argv);

	free (nom_IDL);

	return code;
}


/*---------------------------------------------------------------------------*/
void init_byte_order (char *nom) {
/*---------------------------------------------------------------------------*/

// Les fichiers en ".x86" et ".v86" sont des binaires au format PC

	int	x = 1;
	int	is_x86;
	int	len=strlen(nom);

	is_x86 = (len>=5 && strcmp(nom+len-4,".x86")==0) || (len>=8 && strcmp(nom+len-7,".x86.gz")==0) || (len>=5 && strcmp(nom+len-4,".v86")==0) || (len>=5 && strcmp(nom+len-4,".n86")==0);

	if (*(char *)&x == 1) {		/* PC Byte Order */

		il_faut_swapper = 1;

	} else {			/* SUN Byte Order */

		il_faut_swapper = 0;

	}

	if (is_x86) {
		il_faut_swapper = 1 - il_faut_swapper;
	}

}


/*---------------------------------------------------------------------------*/
void swapper (unsigned char *p, int nb) {
/*---------------------------------------------------------------------------*/

	// Plus rapide de faire 3 if qu'un switch

	unsigned char	tmp;

	if (nb==2) {
		tmp=p[0] ; p[0]=p[1] ; p[1]=tmp;
	} else if (nb==4) {
		tmp=p[0] ; p[0]=p[3] ; p[3]=tmp;
		tmp=p[1] ; p[1]=p[2] ; p[2]=tmp;
	} else if (nb==8) {
		tmp=p[0] ; p[0]=p[7] ; p[7]=tmp;
		tmp=p[1] ; p[1]=p[6] ; p[6]=tmp;
		tmp=p[2] ; p[2]=p[5] ; p[5]=tmp;
		tmp=p[3] ; p[3]=p[4] ; p[4]=tmp;
	}
	

}


/*---------------------------------------------------------------------------*/
void lire_swap (unsigned char *src, unsigned char *dst, int nb) {
/*---------------------------------------------------------------------------*/

	int	i;
	int	j;

	for (i=0, j=nb-1 ; i<nb ; i++,j--) {
		dst[i] = src[j];
	}

}


#define		TYPE_CHAR		1
#define		TYPE_SHORT		2
#define		TYPE_INT		3
#define		TYPE_FLOAT		4
#define		TYPE_DOUBLE		5
#define		TYPE_UNSIGNED_SHORT	12
#define		TYPE_UNSIGNED_INT	13

/*---------------------------------------------------------------------------*/
int swap_structure (unsigned char *p, int taille, int nb) {
/*---------------------------------------------------------------------------*/


	int	i;

	for (i=0 ; i<nb ; i++) {
		swapper (p+i*taille, taille);
	}

	return 0;


}


/*---------------------------------------------------------------------------*/
double lire (unsigned char *p, int type, int swap) {
/*---------------------------------------------------------------------------*/


	short		s;
	unsigned short	us;
	int		i;
	unsigned int	ui;
	float		f;
	double		d;


	switch (type) {

		case TYPE_CHAR:
				return p[0];

		case TYPE_SHORT:	
				if (swap == 0) {
					return * ((short *) p);
				} else {
					lire_swap (p, (unsigned char *)&s, sizeof(s));
					return s;
				}

		case TYPE_UNSIGNED_SHORT:	
				if (swap == 0) {
					return * ((unsigned short *) p);
				} else {
					lire_swap (p, (unsigned char *)&us, sizeof(us));
					return us;
				}

		case TYPE_INT:	
				if (swap == 0) {
					return * ((int *) p);
				} else {
					lire_swap (p, (unsigned char *)&i, sizeof(i));
					return i;
				}

		case TYPE_UNSIGNED_INT:	
				if (swap == 0) {
					return * ((unsigned int *) p);
				} else {
					lire_swap (p, (unsigned char *)&ui, sizeof(ui));
					return ui;
				}

		case TYPE_FLOAT:
				if (swap == 0) {
					return * ((float *) p);
				} else {
					lire_swap (p, (unsigned char *)&f, sizeof(f));
					return f;
				}

		case TYPE_DOUBLE:
				if (swap == 0) {
					return * ((double *) p);
				} else {
					lire_swap (p, (unsigned char *)&d, sizeof(d));
					return d;
				}

		default:
				break;	

	}

	return -1e31;

}


/*---------------------------------------------------------------------------*/
int trouver_motif (char *chaine, int len_chaine, int indice, char *motif, int len_motif) {
/*---------------------------------------------------------------------------*/

	if (indice+len_motif > len_chaine-1)
		return 0;

	return strncmp (chaine+indice, motif, len_motif) == 0;

}


/*---------------------------------------------------------------------------*/
char *get_version_local (
	int		rapide,
	char		*chaine,		/* chaine de caractres contenant mYYYYMMDD et mSC */
	char		*mSC,
	char		*mYYYYMMDD,
	char		*mYEAT,
	char		*mYEAR,
	char		*mMONTH,
	char		*mMONTS,
	char		*mDAY,
	char		*mDOY,
	char		*mHOUR,
	char		*mMINUTE,
	char		*mSECOND,
	char		*mRESOURCE,
	int		vSC,
	char		*vYYYYMMDD,
	char		*vYEAT,
	char		*vYEAR,
	char		*vMONTH,
	char		*vMONTS,
	char		*vDAY,
	char		*vDOY,
	char		*vHOUR,
	char		*vMINUTE,
	char		*vSECOND,
	char		*vRESOURCE,
	int		no,
	int		*code) {
/*---------------------------------------------------------------------------*/

	/* 

	La fonction utilise une chaine masque qui est une copie de chaine en remplacant les occurences de:
		- mYYYYMMDD par vYYYYMMDD
		- mDOY par vDOY
		- mSC par vSC
		- mYEAT par vYEAT (annee sur 2 chiffres)
		- mYEAR par vYEAR
		- mMONTH par vMONTH
		- mMONTS par vMONTS (mois 01 ou 07)
		- mDAY par vDAY
		- mHOUR par vHOUR
		- mMINUTE par vHOUR
		- mSECOND par vSECOND
		- mRESOURCE par vRESOURCE

	Si rapide vaut 1, la fonction renvoie masque

	La fonction glob est ensuite appelle avec masque en argument de recherche.

	S'il y a des fichiers, la fonction positionne code  1 et renvoie:
		- le dernier fichier trouv si no==-1
		- fichier_trouve[no] trouv si 0<= no < nombre_de_fichiers_trouves
		- '' sinon
	Sinon, la fonction renvoie masque et positionne code  0.

	*/

	int		i;
	int		j;
	int		k;
	int		l;
	static glob_t	buffer;
	char		masque[1024];
	static char	resultat[1024];
	char		*p;
	char		svSC[1024];

	char		liste[1024];
	int		debut_liste;
	int		fin_liste;
	char		valeur_liste[1024];
	int		dep;

	int		len;

	if (rapide==0 && no>0) {

		if (buffer.gl_pathc>0) {
			if (0<=no && no<=buffer.gl_pathc-1) {
				sprintf (resultat, "%s", buffer.gl_pathv [no]);
			} else {
				resultat[0]=0;
			}
			*code = 1;
		} else {
			resultat[0]=0;
			*code = 0;
		}
		
		if (buffer.gl_pathc>0 && resultat[0]==0) {
			globfree (& buffer);
		}

		return resultat;

	}

	sprintf (svSC, "%d", vSC);

	buffer.gl_offs = 0;
	j=0;
	k=0;
	while (j < strlen(chaine)) {

		if (trouver_motif (chaine,strlen(chaine),j,mYYYYMMDD,strlen(mYYYYMMDD)) == 1) {

			for (i=0; i<strlen(vYYYYMMDD); i++)
				masque[k++]=vYYYYMMDD[i];
			j+=strlen(mYYYYMMDD);

		} else if (trouver_motif (chaine,strlen(chaine),j,mDOY,strlen(mDOY)) == 1) {

			for (i=0; i<strlen(vDOY); i++)
				masque[k++]=vDOY[i];
			j+=strlen(mDOY);

		} else if (trouver_motif (chaine,strlen(chaine),j,mYEAT,strlen(mYEAT)) == 1) {

			for (i=0; i<strlen(vYEAT); i++)
				masque[k++]=vYEAT[i];
			j+=strlen(mYEAR);

		} else if (trouver_motif (chaine,strlen(chaine),j,mYEAR,strlen(mYEAR)) == 1) {

			for (i=0; i<strlen(vYEAR); i++)
				masque[k++]=vYEAR[i];
			j+=strlen(mYEAR);

		} else if (trouver_motif (chaine,strlen(chaine),j,mMONTH,strlen(mMONTH)) == 1) {

			for (i=0; i<strlen(vMONTH); i++)
				masque[k++]=vMONTH[i];
			j+=strlen(mMONTH);

		} else if (trouver_motif (chaine,strlen(chaine),j,mMONTS,strlen(mMONTS)) == 1) {

			for (i=0; i<strlen(vMONTS); i++)
				masque[k++]=vMONTS[i];
			j+=strlen(mMONTS);

		} else if (trouver_motif (chaine,strlen(chaine),j,mDAY,strlen(mDAY)) == 1) {

			for (i=0; i<strlen(vDAY); i++)
				masque[k++]=vDAY[i];
			j+=strlen(mDAY);

		} else if (trouver_motif (chaine,strlen(chaine),j,mHOUR,strlen(mHOUR)) == 1) {

			for (i=0; i<strlen(vHOUR); i++)
				masque[k++]=vHOUR[i];
			j+=strlen(mHOUR);

		} else if (trouver_motif (chaine,strlen(chaine),j,mMINUTE,strlen(mMINUTE)) == 1) {

			for (i=0; i<strlen(vMINUTE); i++)
				masque[k++]=vMINUTE[i];
			j+=strlen(mMINUTE);

		} else if (trouver_motif (chaine,strlen(chaine),j,mSECOND,strlen(mSECOND)) == 1) {

			for (i=0; i<strlen(vSECOND); i++)
				masque[k++]=vSECOND[i];
			j+=strlen(mSECOND);

		} else if (trouver_motif (chaine,strlen(chaine),j,mRESOURCE,strlen(mRESOURCE)) == 1) {

			for (i=0; i<strlen(vRESOURCE); i++)
				masque[k++]=vRESOURCE[i];
			j+=strlen(mRESOURCE);

		} else if (trouver_motif (chaine,strlen(chaine),j,mSC,strlen(mSC)) == 1) {

			j += strlen(mSC);
			if (chaine[j] == '[') {

				/* debut_liste: position du premier caractre '[' */
				/* fin_liste:   position du premier caractre ']' */
				debut_liste = j;
				for ( fin_liste=j ; chaine[fin_liste] != 0 ; fin_liste++) {
					if (chaine[fin_liste] == ']')
						break;
				}

				j = fin_liste+1;

				/* Recopie dans liste de tout ce qui est entre [ et ] */
				strncpy (liste, chaine+debut_liste+1, fin_liste-debut_liste+1-2);
				liste[fin_liste-debut_liste+1-2]=0;

				p = liste;
				for (i=1 ; i<=vSC ; i++) { /* vaut 1, 2, 3, ... */
					if (sscanf (p, "%s%n", valeur_liste, &dep) != 1) {
						valeur_liste[0]=0;
						break;
					}
					if (i==vSC) {
						for (l=0; l<strlen(valeur_liste); l++)
							masque[k++]=valeur_liste[l];
					}
					p += dep;
				}
			} else {
				for (i=0; i<strlen(svSC); i++)
					masque[k++]=svSC[i];
			}

		} else {

			masque[k++]=chaine[j];
			j++;

		}

	}

	masque[k]=0;

	if (rapide==1) {
		sprintf (resultat, "%s", masque);
		*code = 1;
		buffer.gl_pathc=0;
		return resultat;
	}

	if (access (masque, F_OK) != -1) {
		/* Le fichier existe */
		sprintf (resultat, "%s", masque);
		*code = 1;
		buffer.gl_pathc=0;
		return resultat;
	}

	if (k) masque[k++]='*'; /* rajouter '*' pour les extensions en '.gz' et '.co.gz', mais ne pas avoir masque='*' tout seul */
	masque[k]=0;

	sprintf (resultat, "%s", masque);
	if (k) resultat[k-1]=0;

	glob (masque, GLOB_DOOFFS, NULL, & buffer);

	if (buffer.gl_pathc>0) {
		// Ne pas considrer les fichiers qui se terminent par ".tmp"
		// On ne peut pas le faire dans le glob donc je filtre ici.
		if (no==-1) {
			*code = 0;
			for (i=buffer.gl_pathc-1 ; i>=0 ; i--) {
				len = strlen(buffer.gl_pathv [i]);
				if (len < 4 || strcmp(buffer.gl_pathv [i] + len-4, ".tmp")) {
					// Ne se termine pas par ".tmp"
					sprintf (resultat, "%s", buffer.gl_pathv [i]);
					*code = 1;
					break;
				}
			}
		} else {
			*code = 0;
			for (i=0 ; i<buffer.gl_pathc ; i++) {
				len = strlen(buffer.gl_pathv [i]);
				if (len < 4 || strcmp(buffer.gl_pathv [i] + len-4, ".tmp")) {
					// Ne se termine pas par ".tmp"
					sprintf (resultat, "%s", buffer.gl_pathv [i]);
					*code = 1;
					break;
				}
			}
		}
	} else {
		*code = 0;
	}
		
	if (no == -1) globfree (& buffer);

	return resultat;

}


/*---------------------------------------------------------------------------*/
void voir_intervalle (double t1, double t2, int no) {
/*---------------------------------------------------------------------------*/

/*
	int		annee;
	int		mois;
	int		jour;
	int		heure;
	int		minute;
	double		seconde;

	date_to_tu (t1, &annee, &mois, &jour, &heure, &minute, &seconde);
	printf ("%04d %02d %02d %02d:%02d:%06.3f", annee, mois, jour, heure, minute, seconde);

	date_to_tu (t2, &annee, &mois, &jour, &heure, &minute, &seconde);
	printf (" - %04d %02d %02d %02d:%02d:%06.3f", annee, mois, jour, heure, minute, seconde);

	printf ("  (%4d)\n", no);
*/

}


/*---------------------------------------------------------------------------*/
void gerer2_intervalle (void) {
/*---------------------------------------------------------------------------*/

	if (date_deb_intervalle != -1) {
		voir_intervalle (date_deb_intervalle,date_fin_intervalle,noliste);

	}

}


/*---------------------------------------------------------------------------*/
void gerer1_intervalle (double resultat, double date, double dttrou) {
/*---------------------------------------------------------------------------*/

	static double	old_date=-1e31;

	//int		annee, mois, jour, heure, minute;
	//double	seconde;
	int		nbsec;

	//date_to_tu (date, &annee, &mois, &jour, &heure, &minute, &seconde);
	//printf ("%04d %02d %02d %02d %02d %06.3f %f\n",annee,mois,jour,heure,minute,seconde,resultat);

	if (resultat < -1e30) return; // donnes FILLVAL, arrive avec supersconstraint

	if (old_date > -1e30) {
		nbsec = (date - old_date) / 1000;
		if (nbsec> 0 && nbsec<86400) {
			histogramme[nbsec]++;
		}
	}
	old_date = date;

	if (resultat==1) {

		/* Gestion des trous de donnes > dttrou */
		if (date_deb_intervalle != -1 && (date - date_fin_intervalle > dttrou)) {
			voir_intervalle (date_deb_intervalle,date_fin_intervalle,noliste);
			date_deb_intervalle = -1;
		}

		if (date_deb_intervalle == -1) {
			date_deb_intervalle = date;
			if (noliste == nbliste-1) {
				nbliste *= 2;
				liste = (double *) realloc (liste, 2*nbliste*sizeof(double));
			}
			noliste++;
			liste[2*(noliste-1)] = date_deb_intervalle;
		}

		date_fin_intervalle = date;
		liste[2*(noliste-1)+1] = date_fin_intervalle;

	} else {

		if (date_deb_intervalle != -1) {
			voir_intervalle (date_deb_intervalle,date_fin_intervalle,noliste);
			date_deb_intervalle = -1;
		}

	}

}


/*---------------------------------------------------------------------------*/
int get_infos_bloc (int *offset_champ, int *taille_champ, int *nb_champ, int nbchamps, int *nb, int *debut, int *taille) {
/*---------------------------------------------------------------------------*/

	/* Combien de read pour lire la structure ? */

	int	i;
	int	lus;
	int	nochamp;

	i=0;
	*nb=0;

	debut[0] = offset_champ[0];
	lus=0;
	for (nochamp=0 ; nochamp<nbchamps ; nochamp++) {
		if (i != offset_champ[nochamp]) {
			taille[(*nb)++] = lus;
			debut[*nb] = nochamp;
			i = offset_champ[nochamp];
			lus = 0;
		}
		i += taille_champ[nochamp]*nb_champ[nochamp];
		lus += taille_champ[nochamp]*nb_champ[nochamp];
	}
	taille[(*nb)++] = lus;

	/*
	for (i=0 ; i<*nb ; i++)
		printf ("*** %d *** debut=%d  nb=%d\n", i,debut[i],taille[i]);
	*/

	return 0;

}

/*---------------------------------------------------------------------------*/
void lire_presents (int nbelts, FILE *fd, int *presents, int *nbpresents) {
/*--------------------------------------------------------------------------*/

// Lecture d'un tableau de nbelts bits
// Retourne ce tableau dans presents
// Retourne le nombre de bits  1 de presents dans nbpresents

	int		i;
	int		j;
	unsigned char	b;

	*nbpresents = 0;

	for (i=0 ; i<nbelts/8 ; i++) {
		fread (&b,1,sizeof(b),fd);
		for (j=0 ; j<8 ; j++) {
			presents[i*8 + j] = (b>>j) & 1;
			if ((b>>j) & 1) (*nbpresents)++;
		}
	}

}

/*---------------------------------------------------------------------------*/
int PARAMETER_COMPUTE (int argc, void *argv[]) {
/*---------------------------------------------------------------------------*/

	int		nbarg		=	0;
	IDL_STRING	*formule	=	(IDL_STRING *)		argv[nbarg++];
	double		date1		=	*(double *)		argv[nbarg++];
	double		date2		=	*(double *)		argv[nbarg++];
	unsigned char	*data		=	(unsigned char *)	argv[nbarg++]; /* pointeur sur la structure  lire */
	int		taille		=	*(int *)		argv[nbarg++]; /* nombre d'octets dans la structure */
	int		nbchamps	=	*(int *)		argv[nbarg++]; /* nombre de champs dans la structure */
	IDL_STRING	*nom_champ	=	(IDL_STRING *)		argv[nbarg++]; /* noms des champs dans la structure */
	int		*type_champ	=	(int *)			argv[nbarg++]; /* code du type des champs dans la structure */
	int		*offset_champ	=	(int *)			argv[nbarg++]; /* position en octets des champs dans la structure */
	IDL_STRING	*erreur_msg_IDL	=	(IDL_STRING *)		argv[nbarg++]; /* Sortie: message d'erreur ventuel */
	int		nblignes	=	*(int *)		argv[nbarg++]; /* nombre de lignes dans data */
	int		*find		=	(int *)			argv[nbarg++]; /* 1 pour les variables utilises, 0 sinon */
	IDL_STRING	*output		=	(IDL_STRING *)		argv[nbarg++]; /* nom du fichier cef  crer */

	/*
	Valeur de retour:
		0:	OK
		-1:	pas de champ DATE
		>=1:	erreur dans la formule
			1:	"Variable identififier too long"
			2:	"Expression expected"
			3:	"Unknown variable identifier"
			4:	"\"(\" expected after function indentifier"
			5:	"\")\" expected after parameter"
			6:	"Number expected after exponant"
			7:	"\")\" expected at the end of expression"
			8:	"Expression incorrectly terminated"
			9:	"Out of definition domain"
			10:	"Incompatible value"
			11:	"\";\" expected"

	*/

	/*

	Valeurs possibles pour type_champ:

		1:	byte				1 octet		unsigned char
		2:	entier				2 octets	short
		3:	entier				4 octets	int
		4:	float				4 octets	float
		5:	double				8 octets	double
		12:	entier non sign		2 octets	unsigned short
		13:	entier non sign		4 octets	unsigned int
		7:	chaine de caractre

	*/

	int		i;
	double		*valeur_champ;
	int		no;
	int		nochamp;
	FILE		*fd;
	int		error;
	double		resultat;
	int		noDATE=-1;
	char		erreur_msg[1024]="";
	int		*debut_read;
	int		*taille_read;
	int		annee;
	int		mois;
	int		jour;
	int		heure;
	int		minute;
	double		seconde;

	valeur_champ = (double *)        malloc (nbchamps*sizeof(double));
	debut_read   = (int *)           malloc (nbchamps*sizeof(int));
	taille_read  = (int *)           malloc (nbchamps*sizeof(int));

	if ( (error = expression_externe (1, formule, nbchamps, nom_champ, valeur_champ, &resultat, find, erreur_msg_IDL)) != 0) {
		goto EXIT;
	}

	for (i=0 ; i<nbchamps ; i++) {
		if (strcmp (IDL_STRING_STR(nom_champ+i), "DATE")==0) {
			noDATE=i;
		}
	}

	if (noDATE < 0) {
		error = -1;
		sprintf (erreur_msg, "No DATE field found in data file");
		//IDL_StrEnsureLength (erreur_msg_IDL, strlen(erreur_msg));
		IDL_StrStore (erreur_msg_IDL, erreur_msg);
		goto EXIT;
	}


	date_to_tu (date1, &annee, &mois, &jour, &heure, &minute, &seconde);

	fd = fopen (IDL_STRING_STR(output), "a");
	printf ("Writing %s %04d-%02d-%02d %02d:%02d:%06.3f ... ", IDL_STRING_STR(output), annee, mois, jour, heure, minute, seconde);

	// On passe en revue tous les enregistrements lus et on value la valeur de la contrainte

	//printf ("FORMULE nblignes=%d\n",nblignes);
	for (i=0; i<nblignes; i++) {

		for (nochamp=0 ; nochamp<nbchamps ; nochamp++) {
			if (find[nochamp]) {
				valeur_champ[nochamp] = lire (data+i*taille + offset_champ[nochamp], type_champ[nochamp], 0);	/* IDL a dja swapp */
			}
		}

		if ((valeur_champ[noDATE] < date1) || (valeur_champ[noDATE] > date2))
			continue;

		if ( (error = expression_externe (2, formule, nbchamps, nom_champ, valeur_champ, &resultat, find, erreur_msg_IDL)) != 0) {
			goto EXIT;
		}

		date_to_tu (valeur_champ[noDATE], &annee, &mois, &jour, &heure, &minute, &seconde);
		fprintf (fd,"%04d-%02d-%02dT%02d:%02d:%09.6fZ,%12.5E;\n",annee,mois,jour,heure,minute,seconde,resultat);

	}
	printf ("%04d-%02d-%02d %02d:%02d:%06.3f\n", annee, mois, jour, heure, minute, seconde);

	fclose (fd);

EXIT:

	free (valeur_champ);
	free (debut_read);
	free (taille_read);

	return error;

}

/*---------------------------------------------------------------------------*/
int PARAMETER_COMPUTE_AUTO_GLUE (
/*---------------------------------------------------------------------------*/
	void	*p_formule,
	void	*p02,
	void	*p03,
	void	*p04,
	void	*p05,
	void	*p_nbchamps,
	void	*p_nom_champ,
	void	*p08,
	void	*p09,
	void	*p_erreur_msg_IDL,
	void	*p11,
	void	*p12,
	void	*p_output) {

	int		argc=13;
	void		*argv[13];
	int		nbchamps = * (int *) p_nbchamps;
	int		i;
	int		code;
	IDL_STRING	*formule;
	IDL_STRING	*nom_champ;
	IDL_STRING	*erreur_msg_IDL;
	IDL_STRING	*output;

	// p_formule -> formule
	formule = malloc (sizeof(IDL_STRING));
	IDL_StrStore (formule, p_formule);

	// p_nom_champ -> nom_champ
	nom_champ = malloc (nbchamps * sizeof(IDL_STRING));
	for (i=0 ; i<nbchamps ; i++) IDL_StrStore (nom_champ+i, p_nom_champ+i*1024);

	// p_erreur_msg_IDL -> erreur_msg_IDL
	erreur_msg_IDL = malloc (sizeof(IDL_STRING));
	IDL_StrStore (erreur_msg_IDL, p_erreur_msg_IDL);

	// p_output -> output
	output = malloc (sizeof(IDL_STRING));
	IDL_StrStore (output, p_output);

	argv[ 0] = formule;
	argv[ 1] = p02;
	argv[ 2] = p03;
	argv[ 3] = p04;
	argv[ 4] = p05;
	argv[ 5] = p_nbchamps;
	argv[ 6] = nom_champ;
	argv[ 7] = p08;
	argv[ 8] = p09;
	argv[ 9] = erreur_msg_IDL;
	argv[10] = p11;
	argv[11] = p12;
	argv[12] = output;
	code = PARAMETER_COMPUTE (argc, argv);

	// erreur_msg_IDL -> p_erreur_msg_IDL
	sprintf (p_erreur_msg_IDL,"%s",IDL_STRING_STR(erreur_msg_IDL));

	free (formule);
	free (nom_champ);
	free (erreur_msg_IDL);
	free (output);

	return code;
}

/*---------------------------------------------------------------------------*/
long long get_position (unsigned char val[5]) {
/*---------------------------------------------------------------------------*/
// Retourne une valeur code sur 5 octets.

	long long position;

	position = val[0];

	position <<= 8;
	position += val[1];

	position <<= 8;
	position += val[2];

	position <<= 8;
	position += val[3];

	position <<= 8;
	position += val[4];

	return position;

}

/*---------------------------------------------------------------------------*/
int get_energy_table_v86 (FILE *fd, int isgz, int offset) {
/*---------------------------------------------------------------------------*/

	int		itable;
	#ifdef DEBUG
	int		ienergie;
	#endif
	unsigned char	b5[5];
	long long	position;

	energy_tables_v86 = NULL;
	delta_plus_energy_tables_v86 = NULL;
	delta_minus_energy_tables_v86 = NULL;

	// Patch pour TARANIS: les tables d'nergies sont prsentes
	SEEK (isgz, fd, 0, SEEK_SET);
	if (READ (isgz, fd, &nblignes_v86, 4) != sizeof(int)) {
		return -2;
	}

	#ifdef DEBUG
	printf ("nblignes_v86=%d\n",nblignes_v86);
	#endif

	SEEK (isgz, fd, offset+0*(MY_OFF_T)5, SEEK_SET);
	if (READ (isgz, fd, b5, 5) != 5) {
		return -2;
	}
	position = get_position (b5);

	has_energy_table_v86 = position != 4+5*nblignes_v86;
	#ifdef DEBUG
	printf ("has_energy_table_v86=%d\n",has_energy_table_v86);
	#endif
	if (has_energy_table_v86) {
		SEEK (isgz, fd, offset+nblignes_v86*(MY_OFF_T)5, SEEK_SET);
		if (READ (isgz, fd, b5, 5) != 5) {
			return -2;
		}
		position = get_position(b5);

		SEEK (isgz, fd, position, SEEK_SET);
		if (READ (isgz, fd, &nbenergies_v86, 4) != sizeof(int)) {
			return -2;
		}
		#ifdef DEBUG
		printf ("nbenergies_v86=%d\n",nbenergies_v86);
		#endif
		if (READ (isgz, fd, &nbtables_v86, 4) != sizeof(int)) {
			return -2;
		}
		#ifdef DEBUG
		printf ("nbtables_v86=%d\n",nbtables_v86);
		#endif

		energy_tables_v86 = malloc (nbtables_v86 * nbenergies_v86 * sizeof(float));
		if (energy_tables_v86 == NULL) {
			return-2;
		}
		delta_plus_energy_tables_v86 = malloc (nbtables_v86 * nbenergies_v86 * sizeof(float));
		if (delta_plus_energy_tables_v86 == NULL) {
			return -2;
		}
		delta_minus_energy_tables_v86= malloc (nbtables_v86 * nbenergies_v86 * sizeof(float));
		if (delta_minus_energy_tables_v86 == NULL) {
			return -2;
		}
		
		for (itable=0 ; itable<nbtables_v86 ; itable++) {
			if (READ (isgz, fd, &energy_tables_v86[itable*nbenergies_v86], nbenergies_v86*sizeof(float)) != nbenergies_v86*sizeof(float)) {
				return -2;
			}
			if (READ (isgz, fd, &delta_plus_energy_tables_v86[itable*nbenergies_v86], nbenergies_v86*sizeof(float)) != nbenergies_v86*sizeof(float)) {
				return -2;
			}
			if (READ (isgz, fd, &delta_minus_energy_tables_v86[itable*nbenergies_v86], nbenergies_v86*sizeof(float)) != nbenergies_v86*sizeof(float)) {
				return -2;
			}

			#ifdef DEBUG
			printf ("energy_tables_v86[%d] = ", itable);
			for (ienergie=0 ; ienergie<nbenergies_v86; ienergie++) {
				printf ("%e ",energy_tables_v86[itable*nbenergies_v86+ienergie]);
			}
			printf ("\n");

			printf ("delta_plus_energy_tables_v86[%d] = ", itable);
			for (ienergie=0 ; ienergie<nbenergies_v86 ; ienergie++) {
				printf ("%e ",delta_plus_energy_tables_v86[itable*nbenergies_v86+ienergie]);
			}
			printf ("\n");

			printf ("delta_minus_energy_tables_v86[%d] = ", itable);
			for (ienergie=0 ; ienergie<nbenergies_v86 ; ienergie++) {
				printf ("%e ",delta_minus_energy_tables_v86[itable*nbenergies_v86+ienergie]);
			}
			printf ("\n");

			printf ("\n");
			#endif
		}
	}

	return 0;

}

/*---------------------------------------------------------------------------*/
int CONSTRAINT_COMPUTE_INTERVALS (int argc, void *argv[]) {
/*---------------------------------------------------------------------------*/

	int		nbarg		=	0;
	IDL_STRING	*formule	=	(IDL_STRING *)		argv[nbarg++];
	double		date1		=	*(double *)		argv[nbarg++];
	double		date2		=	*(double *)		argv[nbarg++];
	double		dttrou		=	*(double *)		argv[nbarg++];
	int		is_v86		=	*(int *)		argv[nbarg++]; /* 1 si l'extension est ".v86", 0 sinon */
	IDL_STRING	*nom		=	(IDL_STRING *)		argv[nbarg++];

	unsigned char	*enreg		=	(unsigned char *)	argv[nbarg++]; /* pointeur sur la structure  lire */
	int		taille		=	*(int *)		argv[nbarg++]; /* nombre d'octets dans la structure */
	int		nbchamps	=	*(int *)		argv[nbarg++]; /* nombre de champs dans la structure */
	IDL_STRING	*nom_champ	=	(IDL_STRING *)		argv[nbarg++]; /* noms des champs dans la structure */
	int		*type_champ	=	(int *)			argv[nbarg++]; /* code du type des champs dans la structure */
	int		*offset_champ	=	(int *)			argv[nbarg++]; /* position en octets des champs dans la structure */
	int		*taille_champ	=	(int *)			argv[nbarg++]; /* taille en octets des champs dans la structure */
	int		*nb_champ	=	(int *)			argv[nbarg++]; /* nombre d'elements des champs dans la structure */

	int		*nbintervalle	=	(int *)			argv[nbarg++]; /* Sortie: nombre d'intervalles trouvs */
	IDL_STRING	*erreur_msg_IDL	=	(IDL_STRING *)		argv[nbarg++]; /* Sortie: message d'erreur ventuel */
	int		nblignes	=	*(int *)		argv[nbarg++]; /* 0 s'il faut lire les fichiers ou nombre de lignes dans enreg */
	int		*find		=	(int *)			argv[nbarg++]; /* 1 pour les variables utilises, 0 sinon */

	/*
	Si nblignes est > 0 alors IDL a dja lu les donnes dans enreg pour un jour donne. Il ne faut donc pas les lire en C.

	*/

	/*
	Valeur de retour:
		0:	OK
		-1:	pas de champ DATE
		>=1:	erreur dans la formule
			1:	"Variable identififier too long"
			2:	"Expression expected"
			3:	"Unknown variable identifier"
			4:	"\"(\" expected after function indentifier"
			5:	"\")\" expected after parameter"
			6:	"Number expected after exponant"
			7:	"\")\" expected at the end of expression"
			8:	"Expression incorrectly terminated"
			9:	"Out of definition domain"
			10:	"Incompatible value"
			11:	"\";\" expected"

	*/

	/*

	Valeurs possibles pour type_champ:

		1:	byte				1 octet		unsigned char
		2:	entier				2 octets	short
		3:	entier				4 octets	int
		4:	float				4 octets	float
		5:	double				8 octets	double
		12:	entier non sign		2 octets	unsigned short
		13:	entier non sign		4 octets	unsigned int
		7:	chaine de caractre

	*/

	int		i;
	int		j;
	double		*valeur_champ;
	int		no;
	int		nochamp;
	FILE		*fd;
	int		error;
	double		resultat;
	int		noDATE=-1;
	char		erreur_msg[1024]="";
	int		lus=0;
	int		nb_read;
	int		*debut_read;
	int		*taille_read;
	int		isgz;

	int		ok;

	int		offset;

	if (nbliste==0) {
		nbliste = 100;
		liste = (double *) malloc(2*nbliste*sizeof(double));
		noliste = 0;
		date_deb_intervalle = -1;
		for (i=0 ; i<86400 ; i++) {
			histogramme[i] = -1;
		}
	}

	valeur_champ = (double *)        malloc (nbchamps*sizeof(double));
	debut_read   = (int *)           malloc (nbchamps*sizeof(int));
	taille_read  = (int *)           malloc (nbchamps*sizeof(int));

	if ( (error = expression_externe (1, formule, nbchamps, nom_champ, valeur_champ, &resultat, find, erreur_msg_IDL)) != 0) {
		goto EXIT;
	}

	for (i=0 ; i<nbchamps ; i++) {
		if (strcmp (IDL_STRING_STR(nom_champ+i), "DATE")==0) {
			noDATE=i;
		}
	}

	if (noDATE < 0) {
		error = -1;
		sprintf (erreur_msg, "No DATE field found in data file");
		//IDL_StrEnsureLength (erreur_msg_IDL, strlen(erreur_msg));
		IDL_StrStore (erreur_msg_IDL, erreur_msg);
		goto EXIT;
	}


	if (nblignes == 0) {

		// On va lire le fichier binaire correspondant  date1 et, pour chaque enregistrement, on value la valeur de la contrainte

		isgz = ISGZ(IDL_STRING_STR(nom));
		ok = ((fd = OPEN(isgz, IDL_STRING_STR(nom), "rb")) != NULL);
		init_byte_order (IDL_STRING_STR(nom));

		if (ok) {

			if (is_v86) {

				offset = 4;
				if (get_energy_table_v86 (fd, isgz, offset) == -2) {
					goto EXIT;
				}

				// Se positionner  l'enregistrement 0
				SEEK (isgz, fd, offset+0*(MY_OFF_T)5, SEEK_SET);
				if (READ (isgz, fd, b5_v86, 5) != 5) {
					goto EXIT;
				}
				position_v86 = get_position(b5_v86);
				SEEK (isgz, fd, position_v86, SEEK_SET);

				j_energy_table_1_v86 = nbchamps-2-nbenergies_v86-nbenergies_v86-nbenergies_v86+1;

			}

			get_infos_bloc (offset_champ, taille_champ, nb_champ, nbchamps, &nb_read, debut_read, taille_read);

			for (no=0 ; ; no++) {

				// boucle sur les enregistrements (no=1 pour le premier)

				if (is_v86) {

					if (no == nblignes_v86) break;
			
					for (j=0 ; j<nbchamps ; j++) {

						if (j != nbchamps-1) {
				
							if (has_energy_table_v86 && j>=j_energy_table_1_v86) {
								// Cas TARANIS (has_energy_table_v86 vaut 1):
								// 	nbchamps-2-nbenergies_v86-nbenergies_v86-nbenergies_v86+1	...	nbchamps-2-nbenergies_v86-nbenergies_v86:	energy_table
								// 	nbchamps-2-nbenergies_v86-nbenergies_v86+1			...	nbchamps-2-nbenergies_v86:			delta_plus_energy_table
								// 	nbchamps-2-nbenergies_v86+1 					...	nbchamps-2:					delta_minus_energy_table
								if (j==j_energy_table_1_v86) {
									if (READ (isgz, fd, &itable_v86, sizeof(int)) != sizeof(int)) {
										goto EXIT;
									}
									for (ienergie_v86=0 ; ienergie_v86<nbenergies_v86 ; ienergie_v86++) {
										*(float *) (enreg+offset_champ[j+0*nbenergies_v86+ienergie_v86]) =             energy_tables_v86[itable_v86*nbenergies_v86+ienergie_v86];
										*(float *) (enreg+offset_champ[j+1*nbenergies_v86+ienergie_v86]) =  delta_plus_energy_tables_v86[itable_v86*nbenergies_v86+ienergie_v86];
										*(float *) (enreg+offset_champ[j+2*nbenergies_v86+ienergie_v86]) = delta_minus_energy_tables_v86[itable_v86*nbenergies_v86+ienergie_v86];
									}
								} else {
									// ne rien faire
								}
							} else {
								if (READ (isgz, fd, enreg+offset_champ[j], taille_champ[j]) != taille_champ[j]) {
									goto EXIT;
								}
							}

						} else {

							// Lecture presents
							lire_presents (nb_champ[j], fd, presents_v86, &nbpresents_v86);

							// Lecture de nbpresents valeurs: 4 temps: 45.43, 52.58, 79.93, 35.38
							//lus = READ (isgz, fd, enreg+offset_champ[i], nbpresents*taille_champ[i]);
							//if (lus<=0) break;

							// ou sauter les nbpresents valeurs. 4 temps 73, 10.21, 9.77, 12.20
							// Plus rapide apparement ...
							SEEK (isgz, fd, (MY_OFF_T)nbpresents_v86*taille_champ[j], SEEK_CUR);

						}

					}

				} else {

					for (i=0 ; i<nb_read ; i++) {

						lus = READ (isgz, fd, enreg+offset_champ[debut_read[i]], taille_read[i]);
						if (lus<=0) break;

					}
					if (lus<=0) break;

				}

				for (nochamp=0 ; nochamp<nbchamps ; nochamp++) {
					if (find[nochamp]) {
						valeur_champ[nochamp] = lire (enreg + offset_champ[nochamp], type_champ[nochamp], il_faut_swapper);
						
					}
				}

				if ((valeur_champ[noDATE] < date1) || (valeur_champ[noDATE] > date2))
					continue;

				if ( (error = expression_externe (2, formule, nbchamps, nom_champ, valeur_champ, &resultat, find, erreur_msg_IDL)) != 0) {
					goto EXIT;
				}

				gerer1_intervalle (resultat, valeur_champ[noDATE], dttrou);

			}

			CLOSE (isgz, fd);

		}

	} else {

		// On passe en revue tous les enregistrements lus et on value la valeur de la contrainte

		//printf ("FORMULE nblignes=%d\n",nblignes);
		for (i=0; i<nblignes; i++) {

			for (nochamp=0 ; nochamp<nbchamps ; nochamp++) {
				if (find[nochamp]) {
					valeur_champ[nochamp] = lire (enreg+i*taille + offset_champ[nochamp], type_champ[nochamp], 0);	/* IDL a dja swapp */
				}
			}

			if ((valeur_champ[noDATE] < date1) || (valeur_champ[noDATE] > date2))
				continue;

			if ( (error = expression_externe (2, formule, nbchamps, nom_champ, valeur_champ, &resultat, find, erreur_msg_IDL)) != 0) {
				goto EXIT;
			}

			gerer1_intervalle (resultat, valeur_champ[noDATE], dttrou);

		}


	}

	gerer2_intervalle ();

EXIT:

	*nbintervalle = noliste;
	free (valeur_champ);
	free (debut_read);
	free (taille_read);

	if (is_v86 && energy_tables_v86 != NULL) free (energy_tables_v86);
	if (is_v86 && delta_plus_energy_tables_v86 != NULL) free (delta_plus_energy_tables_v86);
	if (is_v86 && delta_minus_energy_tables_v86 != NULL) free (delta_minus_energy_tables_v86);

	return error;

}

/*---------------------------------------------------------------------------*/
int CONSTRAINT_COMPUTE_INTERVALS_AUTO_GLUE (
/*---------------------------------------------------------------------------*/
	void	*p_formule,
	void	*p02,
	void	*p03,
	void	*p04,
	void	*p05,
	void	*p_nom,
	void	*p07,
	void	*p08,
	void	*p_nbvar,
	void	*p_nom_champ,
	void	*p11,
	void	*p12,
	void	*p13,
	void	*p14,
	void	*p15,
	void	*p_erreur_msg_IDL,
	void	*p17,
	void	*p18) {

	int		argc=18;
	void		*argv[18];
	int		nbvar = * (int *) p_nbvar;
	int		i;
	int		code;
	IDL_STRING	*formule;
	IDL_STRING	*nom;
	IDL_STRING	*nom_champ;
	IDL_STRING	*erreur_msg_IDL;

	// p_formule -> formule
	formule = malloc (sizeof(IDL_STRING));
	IDL_StrStore (formule, p_formule);

	// p_nom -> nom
	nom = malloc (sizeof(IDL_STRING));
	IDL_StrStore (nom, p_nom);

	// p_nom_champ -> nom_champ
	nom_champ = malloc (nbvar * sizeof(IDL_STRING));
	for (i=0 ; i<nbvar ; i++) IDL_StrStore (nom_champ+i, p_nom_champ+i*1024);

	// p_erreur_msg_IDL -> erreur_msg_IDL
	erreur_msg_IDL = malloc (sizeof(IDL_STRING));
	IDL_StrStore (erreur_msg_IDL, p_erreur_msg_IDL);

	argv[ 0] = formule;
	argv[ 1] = p02;
	argv[ 2] = p03;
	argv[ 3] = p04;
	argv[ 4] = p05;
	argv[ 5] = nom;
	argv[ 6] = p07;
	argv[ 7] = p08;
	argv[ 8] = p_nbvar;
	argv[ 9] = nom_champ;
	argv[10] = p11;
	argv[11] = p12;
	argv[12] = p13;
	argv[13] = p14;
	argv[14] = p15;
	argv[15] = erreur_msg_IDL;
	argv[16] = p17;
	argv[17] = p18;
	code = CONSTRAINT_COMPUTE_INTERVALS (argc, argv);

	// erreur_msg_IDL -> p_erreur_msg_IDL
	sprintf (p_erreur_msg_IDL,"%s",IDL_STRING_STR(erreur_msg_IDL));

	free (formule);
	free (nom);
	free (nom_champ);
	free (erreur_msg_IDL);

	return code;

}

/*---------------------------------------------------------------------------*/
int CONSTRAINT_GET_INTERVALS (int argc, void *argv[]) {
/*---------------------------------------------------------------------------*/

	int		nbarg		= 	0;
	double		*tabdate	=	(double *)	argv[nbarg++];

	int	max;
	int	nbsec=0; // sinon message gcc
	int	i;

	// Chercher la valeur maxi dans histogramme
	max = -1;
	for (i=0 ; i<86400 ; i++) {
		if (histogramme[i] > max) {
			max = histogramme[i];
			nbsec = i;
		}
	}

	// Chercher la plus petite valeur non nulle dans histogramme
	for (i=1 ; i<86400 ; i++) {
		if (histogramme[i]) {
			nbsec = i;
			break;
		}
	}

	printf ("Automatic resolution = %d sec\n",nbsec);

	// Etendre les intervalles de +/- nbsec*0.5
	for (i=0 ; i<noliste ; i++) {
		liste[2*i+0] -= nbsec*1000*0.5;
		liste[2*i+1] += nbsec*1000*0.5;
	}
	

	for (i=0 ; i<noliste ; i++) {
		tabdate[2*i+0] = liste[2*i+0];
		tabdate[2*i+1] = liste[2*i+1];
	}

	nbliste = 0;
	noliste = -1;
	free (liste);

	return 0;

}

/*---------------------------------------------------------------------------*/
int CONSTRAINT_GET_INTERVALS_AUTO_GLUE (
/*---------------------------------------------------------------------------*/
	void	*p01) {

	int	argc=1;
	void	*argv[1];

	argv[0] = p01;
	return CONSTRAINT_GET_INTERVALS (argc, argv);

}

/*---------------------------------------------------------------------------*/
int LIRE_ENREG (int argc, void *argv[]) {
/*---------------------------------------------------------------------------*/

	int		nbarg		=	0;
	int		is_v86		=	*(int *)		argv[nbarg++]; /* 1 si l'extension est ".v86", 0 sinon */
	IDL_STRING	*nom		=	(IDL_STRING *)		argv[nbarg++];
	int		taillef		=	*(int *)		argv[nbarg++]; /* nombre d'octets dans le fichier d'un enregisterment */
	int		offset		=	*(int *)		argv[nbarg++];
	int		no		=	*(int *)		argv[nbarg++];
	int		nb		=	*(int *)		argv[nbarg++];
	unsigned char	*enreg		=	(unsigned char *)	argv[nbarg++]; /* pointeur sur la structure  lire */
	int		taille		=	*(int *)		argv[nbarg++]; /* nombre d'octets dans la structure */
	int		nbchamps	=	*(int *)		argv[nbarg++]; /* nombre de champs dans la structure */
	int		*type_champ	=	(int *)			argv[nbarg++]; /* code du type des champs dans la structure */
	int		*offset_champ	=	(int *)			argv[nbarg++]; /* position en octets des champs dans la structure */
	int		*taille_champ	=	(int *)			argv[nbarg++]; /* nombre d'octets des champs dans la structure */
	int		*nb_champ	=	(int *)			argv[nbarg++]; /* nombre d'elements des champs dans la structure */

	/*
	Valeur de retour:
		0:	OK
		-1:	erreur
		>=1:	erreur dans la formule
	*/

	/*

	Valeurs possibles pour type_champ:

		1:	byte				1 octet		unsigned char
		2:	entier				2 octets	short
		3:	entier				4 octets	int
		4:	float				4 octets	float
		5:	double				8 octets	double
		12:	entier non sign		2 octets	unsigned short
		13:	entier non sign		4 octets	unsigned int
		7:	chaine de caractre

	*/

	FILE		*fd=NULL;
	int		i;
	int		j;
	int		nochamp;
	int		code=0;
	int		nb_read;
	int		*debut_read;
	int		*taille_read;
	int		isgz;


	init_byte_order (IDL_STRING_STR(nom));

	debut_read   = (int *) malloc (nbchamps*sizeof(int));
	taille_read  = (int *) malloc (nbchamps*sizeof(int));

	get_infos_bloc (offset_champ, taille_champ, nb_champ, nbchamps, &nb_read, debut_read, taille_read);

	/*
	printf ("lire_enreg nom=%s  nb=%d offset=%d  no=%d  taillef=%d  fseek=%d\n",IDL_STRING_STR(nom), nb,offset,no,taillef,offset+no*taillef);
	*/

	isgz = ISGZ(IDL_STRING_STR(nom));
	if ((fd = OPEN (isgz, IDL_STRING_STR(nom), "rb")) == NULL) {
		code=-1;
		goto EXIT;
	}

	if (is_v86) {

		if (get_energy_table_v86 (fd, isgz, offset) == -2) {
			code =-2;
			goto EXIT;
		}

		// se positionner  l'enregistrement no
		SEEK (isgz, fd, offset+no*(MY_OFF_T)5, SEEK_SET);
		if (READ (isgz, fd, b5_v86, 5) != 5) {
			code = -2;
			goto EXIT;
		}
		position_v86 = get_position(b5_v86);
		SEEK (isgz, fd, position_v86, SEEK_SET);

		j_energy_table_1_v86 = nbchamps-2-nbenergies_v86-nbenergies_v86-nbenergies_v86+1;

	} else {
		// Pas la peine de faire un SEEK si offset==no==0
		if (offset || no) SEEK (isgz, fd, offset+no*(MY_OFF_T)taillef, SEEK_SET);
	}

	for (i=0; i<nb; i++) {

		if (is_v86) {

			for (j=0 ; j<nbchamps ; j++) {

				if (j != nbchamps-1) {
				
					if (has_energy_table_v86 && j>=j_energy_table_1_v86) {
						// Cas TARANIS (has_energy_table_v86 vaut 1):
						// 	nbchamps-2-nbenergies_v86-nbenergies_v86-nbenergies_v86+1	...	nbchamps-2-nbenergies_v86-nbenergies_v86:	energy_table
						// 	nbchamps-2-nbenergies_v86-nbenergies_v86+1			...	nbchamps-2-nbenergies_v86:			delta_plus_energy_table
						// 	nbchamps-2-nbenergies_v86+1 					...	nbchamps-2:					delta_minus_energy_table
						if (j==j_energy_table_1_v86) {
							if (READ (isgz, fd, &itable_v86, sizeof(int)) != sizeof(int)) {
								code = -2;
								goto EXIT;
							}
							for (ienergie_v86=0 ; ienergie_v86<nbenergies_v86 ; ienergie_v86++) {
								*(float *) (enreg+(size_t)i*(size_t)taille+offset_champ[j+0*nbenergies_v86+ienergie_v86]) =             energy_tables_v86[itable_v86*nbenergies_v86+ienergie_v86];
								*(float *) (enreg+(size_t)i*(size_t)taille+offset_champ[j+1*nbenergies_v86+ienergie_v86]) =  delta_plus_energy_tables_v86[itable_v86*nbenergies_v86+ienergie_v86];
								*(float *) (enreg+(size_t)i*(size_t)taille+offset_champ[j+2*nbenergies_v86+ienergie_v86]) = delta_minus_energy_tables_v86[itable_v86*nbenergies_v86+ienergie_v86];
							}
						} else {
							// ne rien faire
						}
					} else {
						if (READ (isgz, fd, enreg+(size_t)i*(size_t)taille+offset_champ[j], taille_champ[j]) != taille_champ[j]) {
							code = -2;
							goto EXIT;
						}
					}
				} else {
					// Lecture presents
					lire_presents (nb_champ[j], fd, presents_v86, &nbpresents_v86);

					// Lecture de nbpresents valeurs
					if (READ (isgz, fd, enreg+(size_t)i*(size_t)taille+offset_champ[j], nbpresents_v86*taille_champ[j]) != nbpresents_v86*taille_champ[j]) {
						code = -2;
						goto EXIT;
					}

					// Dplacement des valeurs lues aux positions indiques dans presents
					no1_v86 = nbpresents_v86-1;
					pfloat_v86 = (float *) (enreg+(size_t)i*(size_t)taille+offset_champ[j]);
					for (k_v86=nb_champ[j]-1 ; k_v86>=0 ; k_v86--) {
						if (presents_v86[k_v86]) {
							pfloat_v86[k_v86] = pfloat_v86[no1_v86];
							no1_v86--;
						} else {
							pfloat_v86[k_v86] = 0;
						}
					}

				}

			}

		} else {

			for (j=0 ; j<nb_read ; j++) {

				if (READ (isgz, fd, enreg+(size_t)i*(size_t)taille+offset_champ[debut_read[j]], taille_read[j]) != taille_read[j]) {
					code = -2;
					goto EXIT;
				}

			}

		}

		if (il_faut_swapper) {

			for (nochamp=0 ; nochamp<nbchamps ; nochamp++) {

				swap_structure (enreg + (size_t)i*(size_t)taille + offset_champ[nochamp], taille_champ[nochamp], nb_champ[nochamp]);

			}

		}
	}


EXIT:

	if (fd != NULL) CLOSE (isgz, fd);
	free (debut_read);
	free (taille_read);

	if (is_v86 && energy_tables_v86 != NULL) free (energy_tables_v86);
	if (is_v86 && delta_plus_energy_tables_v86 != NULL) free (delta_plus_energy_tables_v86);
	if (is_v86 && delta_minus_energy_tables_v86 != NULL) free (delta_minus_energy_tables_v86);

	return code;

}


/*---------------------------------------------------------------------------*/
int LIRE_ENREG_AUTO_GLUE (
/*---------------------------------------------------------------------------*/
	void *p01,
	void *p_nom,
	void *p03,
	void *p04,
	void *p05,
	void *p06,
	void *p07,
	void *p08,
	void *p09,
	void *p10,
	void *p11,
	void *p12,
	void *p13) {

	int		argc=13;
	void		*argv[13];
	int		code;
	IDL_STRING	*nom;

	// p_nom -> nom
	nom = malloc (sizeof(IDL_STRING));
	IDL_StrStore (nom, p_nom);

	argv[ 0] = p01;
	argv[ 1] = nom;
	argv[ 2] = p03;
	argv[ 3] = p04;
	argv[ 4] = p05;
	argv[ 5] = p06;
	argv[ 6] = p07;
	argv[ 7] = p08;
	argv[ 8] = p09;
	argv[ 9] = p10;
	argv[10] = p11;
	argv[11] = p12;
	argv[12] = p13;
	code = LIRE_ENREG (argc, argv);

	free (nom);

	return code;

}


/*---------------------------------------------------------------------------*/
int CHERCHER_DERNIER_FICHIER (int argc, void *argv[]) {
/*---------------------------------------------------------------------------*/

	int		nbarg			=	0;
	int		rapide			=	*(int *)		argv[nbarg++];
	IDL_STRING	*masque			=	(IDL_STRING *)		argv[nbarg++];
	int		vSC			=	*(int *)		argv[nbarg++];
	IDL_STRING	*vYYYYMMDD		=	(IDL_STRING *)		argv[nbarg++];
	IDL_STRING	*vYEAR			=	(IDL_STRING *)		argv[nbarg++];
	IDL_STRING	*vMONTH			=	(IDL_STRING *)		argv[nbarg++];
	IDL_STRING	*vDAY			=	(IDL_STRING *)		argv[nbarg++];
	IDL_STRING	*vDOY			=	(IDL_STRING *)		argv[nbarg++];
	IDL_STRING	*vHOUR			=	(IDL_STRING *)		argv[nbarg++];
	IDL_STRING	*vMINUTE		=	(IDL_STRING *)		argv[nbarg++];
	IDL_STRING	*vSECOND		=	(IDL_STRING *)		argv[nbarg++];
	IDL_STRING	*vRESOURCE		=	(IDL_STRING *)		argv[nbarg++];
	int		no			=	*(int *)		argv[nbarg++];
	IDL_STRING	*nom			=	(IDL_STRING *)		argv[nbarg++];

	char	*p;
	int	code;
	char	vMONTS[3];
	int	mois;
	char	vYEAT[3];
	int	annee;

	sscanf (IDL_STRING_STR(vMONTH),"%d",&mois);
	sprintf (vMONTS,"%02d",mois<=6 ? 1 : 7);

	sscanf (IDL_STRING_STR(vYEAR),"%d",&annee);
	sprintf (vYEAT,"%02d",annee%100);

	p = get_version_local ( rapide, IDL_STRING_STR(masque),
				"$SC",
				"$YYYYMMDD",
				"$YEAT",
				"$YEAR",
				"$MONTH",
				"$MONTS",
				"$DAY",
				"$DOY",
				"$HOUR",
				"$MINUTE",
				"$SECOND",
				"$RESOURCE",
				vSC,
				IDL_STRING_STR(vYYYYMMDD),
				vYEAT,
				IDL_STRING_STR(vYEAR),
				IDL_STRING_STR(vMONTH),
				vMONTS,
				IDL_STRING_STR(vDAY),
				IDL_STRING_STR(vDOY),
				IDL_STRING_STR(vHOUR),
				IDL_STRING_STR(vMINUTE),
				IDL_STRING_STR(vSECOND),
				IDL_STRING_STR(vRESOURCE),
				no,
				&code);
	//IDL_StrEnsureLength (nom, strlen(p));
	IDL_StrStore (nom, p);

	return code;

}


/*---------------------------------------------------------------------------*/
int CHERCHER_DERNIER_FICHIER_AUTO_GLUE (
/*---------------------------------------------------------------------------*/
	void *p01,
	void *p_masque,
	void *p03,
	void *p_vYYYYMMDD,
	void *p_vYEAR,
	void *p_vMONTH,
	void *p_vDAY,
	void *p_vDOY,
	void *p_vHOUR,
	void *p_vMINUTE,
	void *p_vSECOND,
	void *p_vRESOURCE,
	void *p13,
	void *p_nom) {

	int		argc=14;
	void		*argv[14];
	int		code;
	IDL_STRING	*masque;
	IDL_STRING	*vYYYYMMDD;
	IDL_STRING	*vYEAR;
	IDL_STRING	*vMONTH;
	IDL_STRING	*vDAY;
	IDL_STRING	*vDOY;
	IDL_STRING	*vHOUR;
	IDL_STRING	*vMINUTE;
	IDL_STRING	*vSECOND;
	IDL_STRING	*vRESOURCE;
	IDL_STRING	*nom;

	// p_masque -> masque
	masque = malloc (sizeof(IDL_STRING));
	IDL_StrStore (masque, p_masque);

	// p_vYYYYMMDD -> vYYYYMMDD
	vYYYYMMDD = malloc (sizeof(IDL_STRING));
	IDL_StrStore (vYYYYMMDD, p_vYYYYMMDD);

	// p_vYEAR -> vYEAR
	vYEAR = malloc (sizeof(IDL_STRING));
	IDL_StrStore (vYEAR, p_vYEAR);

	// p_vMONTH -> vMONTH
	vMONTH = malloc (sizeof(IDL_STRING));
	IDL_StrStore (vMONTH, p_vMONTH);

	// p_vDAY -> vDAY
	vDAY = malloc (sizeof(IDL_STRING));
	IDL_StrStore (vDAY, p_vDAY);

	// p_vDOY -> vDOY
	vDOY = malloc (sizeof(IDL_STRING));
	IDL_StrStore (vDOY, p_vDOY);

	// p_vHOUR -> vHOUR
	vHOUR = malloc (sizeof(IDL_STRING));
	IDL_StrStore (vHOUR, p_vHOUR);

	// p_vMINUTE -> vMINUTE
	vMINUTE = malloc (sizeof(IDL_STRING));
	IDL_StrStore (vMINUTE, p_vMINUTE);

	// p_vSECOND -> vSECOND
	vSECOND = malloc (sizeof(IDL_STRING));
	IDL_StrStore (vSECOND, p_vSECOND);

	// p_vRESOURCE -> vRESOURCE
	vRESOURCE = malloc (sizeof(IDL_STRING));
	IDL_StrStore (vRESOURCE, p_vRESOURCE);

	// p_nom -> nom
	nom = malloc (sizeof(IDL_STRING));
	IDL_StrStore (nom, p_nom);

	argv[ 0] = p01;
	argv[ 1] = masque;
	argv[ 2] = p03;
	argv[ 3] = vYYYYMMDD;
	argv[ 4] = vYEAR;
	argv[ 5] = vMONTH;
	argv[ 6] = vDAY;
	argv[ 7] = vDOY;
	argv[ 8] = vHOUR;
	argv[ 9] = vMINUTE;
	argv[10] = vSECOND;
	argv[11] = vRESOURCE;
	argv[12] = p13;
	argv[13] = nom;
	code = CHERCHER_DERNIER_FICHIER (argc, argv);

	// nom -> p_nom
	sprintf (p_nom,"%s",IDL_STRING_STR(nom));

	free (masque);
	free (vYYYYMMDD);
	free (vYEAR);
	free (vMONTH);
	free (vDAY);
	free (vDOY);
	free (vHOUR);
	free (vMINUTE);
	free (vSECOND);
	free (vRESOURCE);
	free (nom);

	return code;
}


/*---------------------------------------------------------------------------*/
int MY_FILE_INFO (int argc, void *argv[]) {
/*---------------------------------------------------------------------------*/

	int		nbarg		=	0;
	IDL_STRING	*nom		=	(IDL_STRING *)		argv[nbarg++];
	char		*exists		=	(char *)		argv[nbarg++];
	long long	*mtime		=	(long long *)		argv[nbarg++]; // 64 bits
	long long	*size		=	(long long *)		argv[nbarg++]; // 64 bits

	struct MY_STAT	info;

	if (MY_FSTAT (IDL_STRING_STR(nom), &info) != 0) {
		*exists = *mtime = *size = 0;
		return -1;
	}
	*exists = 1;
	*mtime = info.st_mtime;
	*size = info.st_size;

	return 0;

}

/*---------------------------------------------------------------------------*/
int MY_FILE_INFO_AUTO_GLUE (
/*---------------------------------------------------------------------------*/
	void	*p_nom,
	void	*p02,
	void	*p03,
	void	*p04) {

	int		argc=4;
	void		*argv[4];
	int		code;
	IDL_STRING	*nom;

	// p_nom -> nom
	nom = malloc (sizeof(IDL_STRING));
	IDL_StrStore (nom, p_nom);

	argv[0] = nom;
	argv[1] = p02;
	argv[2] = p03;
	argv[3] = p04;
	code = MY_FILE_INFO (argc, argv);

	free (nom);

	return code;

}


/*---------------------------------------------------------------------------*/
int FILELENGTHC (int argc, void *argv[]) {
/*---------------------------------------------------------------------------*/

	int			nbarg		=	0;
	IDL_STRING		*nom		=	(IDL_STRING *)		argv[nbarg++];
	long long		*taille		=	(long long *)		argv[nbarg++];	/* taille du fichier renvoyee sur 64 bits (que l'OS soit en 32 ou 64 bits) */

	int		len;
	struct MY_STAT	info;
	FILE		*fd = NULL;
	unsigned char	buffer[4];
	int		code = -1;

	len = strlen (IDL_STRING_STR(nom));

	if ((len>=4) && strcmp (IDL_STRING_STR(nom)+len-3, ".gz")==0) {	/* fichier .gz */

		if ((fd = fopen (IDL_STRING_STR(nom),"rb")) == NULL) goto EXIT;
		if (MY_FSEEK (fd, -4, SEEK_END) != 0) goto EXIT;
		if (fread (buffer, 1, 4, fd) != 4) goto EXIT;
		*taille = buffer[0] | (buffer[1]<<8) | (buffer[2]<<16) | (buffer[3]<<24);
		code = 0;

	} else {							/* fichier normal */

		if (MY_FSTAT (IDL_STRING_STR(nom), &info) != 0)
			return -1;
		*taille = info.st_size;
		code = 0;

	}

EXIT:
	if (fd != NULL) fclose (fd);

	return code;

}


/*---------------------------------------------------------------------------*/
int FILELENGTHC_AUTO_GLUE (
/*---------------------------------------------------------------------------*/
	void	*p_nom_IDL,
	void	*p02) {

	int		argc=2;
	void		*argv[2];
	int		code;
	IDL_STRING	*nom_IDL;

	// p_nom_IDL -> nom_IDL
	nom_IDL = malloc (sizeof(IDL_STRING));
	IDL_StrStore (nom_IDL, p_nom_IDL);

	argv[0] = nom_IDL;
	argv[1] = p02;
	code = FILELENGTHC (argc, argv);

	free (nom_IDL);

	return code;

}


/*---------------------------------------------------------------------------*/
int decompresser_zlib (char *nomgz, char *fichier) {
/*---------------------------------------------------------------------------*/
	/*

	Retourne:
		<0	si PB
		0 	si OK
	*/

	#define		MAX	1024*1024

	FILE		*fd1=NULL;
	FILE		*fd2=NULL;
	char		*buffer=NULL;
	int		code=0;
	int		read;
	int		isgz=0; /* gcc */

	if ((fd2 = fopen (fichier,"wb")) == NULL) {
		code = -1;
		goto EXIT;
	}

	isgz = ISGZ(nomgz);
	if ((fd1 = OPEN (isgz, nomgz,"rb")) == NULL) {
		code = -2;
		goto EXIT;
	}

	if ((buffer = (char *)malloc (MAX)) == NULL) {
		code = -2;
		goto EXIT;
	}

	for ( ; ; ) {

		read = READ (isgz, fd1, buffer, MAX);
		if (read < 0) {
			code = -3;
			goto EXIT;
		}
		if (read == 0) break;
		if (fwrite (buffer, sizeof(char), read, fd2) != read) {
			code = 1;
			goto EXIT;
		}
	}


EXIT:

	if (fd1 != NULL)	CLOSE (isgz,fd1);
	if (fd2 != NULL)	fclose(fd2);
	if (buffer != NULL)	free (buffer);

	return code;

}


/*---------------------------------------------------------------------------*/
int DECOMPRESSER (int argc, void *argv[]) {
/*---------------------------------------------------------------------------*/

	/* Entrees */
	IDL_STRING *nom1	= (IDL_STRING *) argv[0]; /* fichier .gz a decompresser */
	IDL_STRING *nom2	= (IDL_STRING *) argv[1]; /* fichier nom2 a creer */

	return decompresser_zlib (IDL_STRING_STR(nom1), IDL_STRING_STR(nom2));

}

/*---------------------------------------------------------------------------*/
int DECOMPRESSER_AUTO_GLUE (
/*---------------------------------------------------------------------------*/
	void	*p_nom1,
	void	*p_nom2) {

	int		argc=2;
	void		*argv[2];
	int		code;
	IDL_STRING	*nom1;
	IDL_STRING	*nom2;

	// p_nom1 -> nom1
	nom1 = malloc (sizeof(IDL_STRING));
	IDL_StrStore (nom1, p_nom1);

	// p_nom2 -> nom2
	nom2 = malloc (sizeof(IDL_STRING));
	IDL_StrStore (nom2, p_nom2);

	argv[0] = nom1;
	argv[1] = nom2;
	code = DECOMPRESSER (argc, argv);

	free (nom1);
	free (nom2);

	return code;
}


/*---------------------------------------------------------------------------*/
int TRAITER_FORMULE (int argc, void *argv[]) {
/*---------------------------------------------------------------------------*/

	int		nbarg		=	0;
	IDL_STRING	*formule	=	(IDL_STRING *)		argv[nbarg++];
	unsigned char	*enreg		=	(unsigned char *)	argv[nbarg++]; /* pointeur sur la structure  lire */
	int		nblignes	=	*(int *)		argv[nbarg++]; /* nombre de lignes dans enreg */
	int		taille		=	*(int *)		argv[nbarg++]; /* nombre d'octets dans la structure */
	int		nbchamps	=	*(int *)		argv[nbarg++]; /* nombre de champs dans la structure */
	IDL_STRING	*nom_champ	=	(IDL_STRING *)		argv[nbarg++]; /* noms des champs dans la structure */
	int		*type_champ	=	(int *)			argv[nbarg++]; /* code du type des champs dans la structure */
	int		*offset_champ	=	(int *)			argv[nbarg++]; /* position en octets des champs dans la structure */
	double		*y		=	(double *)		argv[nbarg++]; /* resultat */
	IDL_STRING	*erreur_msg_IDL	=	(IDL_STRING *)		argv[nbarg++]; /* Sortie: message d'erreur ventuel */
	int		*find		=	(int *)			argv[nbarg++]; /* 1 pour les variables utilises, 0 sinon */

	/*
	Valeur de retour:
		0:	OK
		>=1:	erreur dans la formule
			1:	"Variable identififier too long"
			2:	"Expression expected"
			3:	"Unknown variable identifier"
			4:	"\"(\" expected after function indentifier"
			5:	"\")\" expected after parameter"
			6:	"Number expected after exponant"
			7:	"\")\" expected at the end of expression"
			8:	"Expression incorrectly terminated"
			9:	"Out of definition domain"
			10:	"Incompatible value"
			11:	"\";\" expected"

	*/

	/*

	Valeurs possibles pour type_champ:

		1:	byte				1 octet		unsigned char
		2:	entier				2 octets	short
		3:	entier				4 octets	int
		4:	float				4 octets	float
		5:	double				8 octets	double
		12:	entier non sign		2 octets	unsigned short
		13:	entier non sign		4 octets	unsigned int
		7:	chaine de caractre

	*/

	int		i;
	double		*valeur_champ;
	int		nochamp;
	int		error=0;
	double		resultat;

	il_faut_swapper = 0; /* IDL a dja swapp si ncessaire*/

	valeur_champ = (double *) malloc (nbchamps*sizeof(double));

	if ( (error = expression_externe (1, formule, nbchamps, nom_champ, valeur_champ, &resultat, find, erreur_msg_IDL)) != 0) {
		goto EXIT;
	}


	/*
	printf ("FORMULE nblignes=%d\n",nblignes);
	*/
	for (i=0; i<nblignes; i++) {

		for (nochamp=0 ; nochamp<nbchamps ; nochamp++) {
			if (find[nochamp]) {
				valeur_champ[nochamp] = lire (enreg+i*taille + offset_champ[nochamp], type_champ[nochamp], 0);	/* IDL a dja swapp */
			}
		}

		error = expression_externe (2, formule, nbchamps, nom_champ, valeur_champ, &y[i], find, erreur_msg_IDL);
	}

EXIT:
	free (valeur_champ);
	return error;

}


/*---------------------------------------------------------------------------*/
int TRAITER_FORMULE_AUTO_GLUE (
/*---------------------------------------------------------------------------*/
	void	*p_formule,
	void	*p02,
	void	*p03,
	void	*p04,
	void	*p_nbchamps,
	void	*p_nom_champ,
	void	*p07,
	void	*p08,
	void	*p09,
	void	*p_erreur_msg_IDL,
	void	*p11) {

	int		argc=11;
	void		*argv[11];
	int		nbchamps = * (int *) p_nbchamps;
	int		i;
	int		code;
	IDL_STRING	*formule;
	IDL_STRING	*nom_champ;
	IDL_STRING	*erreur_msg_IDL;

	// p_formule -> formule
	formule = malloc (sizeof(IDL_STRING));
	IDL_StrStore (formule, p_formule);

	// p_nom_champ -> nom_champ
	nom_champ = malloc (nbchamps * sizeof(IDL_STRING));
	for (i=0 ; i<nbchamps ; i++) IDL_StrStore (nom_champ+i, p_nom_champ+i*1024);

	// p_erreur_msg_IDL -> erreur_msg_IDL
	erreur_msg_IDL = malloc (sizeof(IDL_STRING));
	IDL_StrStore (erreur_msg_IDL, p_erreur_msg_IDL);

	argv[ 0] = formule;
	argv[ 1] = p02;
	argv[ 2] = p03;
	argv[ 3] = p04;
	argv[ 4] = p_nbchamps;
	argv[ 5] = nom_champ;
	argv[ 6] = p07;
	argv[ 7] = p08;
	argv[ 8] = p09;
	argv[ 9] = erreur_msg_IDL;
	argv[10] = p11;
	code = TRAITER_FORMULE (argc, argv);

	// erreur_msg_IDL -> p_erreur_msg_IDL
	sprintf (p_erreur_msg_IDL,"%s",IDL_STRING_STR(erreur_msg_IDL));

	free (formule);
	free (nom_champ);
	free (erreur_msg_IDL);

	return code;

}


/*---------------------------------------------------------------------------*/
int GET_SIZEOF_SIZE_T (int argc, void *argv[]) {
/*---------------------------------------------------------------------------*/

	return sizeof(size_t);

}

/*---------------------------------------------------------------------------*/
int GET_SIZEOF_SIZE_T_AUTO_GLUE () {
/*---------------------------------------------------------------------------*/
	int	argc=0;
	void	*argv[1];

	return GET_SIZEOF_SIZE_T (argc, argv);
}


/*---------------------------------------------------------------------------*/
void LIRE_FICHIERVAR (int argc, void *argv[]) {
/*---------------------------------------------------------------------------*/

	int		nbarg		= 0;
	IDL_STRING	*nom_IDL	= (IDL_STRING *)	argv[nbarg++];
	int		nbspins		= *(int *)		argv[nbarg++];
	int		nbenergies	= *(int *)		argv[nbarg++];
	int		nbspectres	= *(int *)		argv[nbarg++];
	int		offset		= *(int *)		argv[nbarg++];
	size_t		*dataquick	= (size_t *)		argv[nbarg++];

	FILE		*fd;
	int		ispin;
	int		nbcoups;
	unsigned char	tmp[2];
	int		ienergie;
	int		ispectre;
	unsigned char	*tmp2;
	size_t		adresse;
	int		isgz;

	if (nbarg != argc) return;

	isgz = ISGZ(IDL_STRING_STR(nom_IDL));
	fd = OPEN (isgz, IDL_STRING_STR(nom_IDL),"rb");	/* b sinon probleme sous Windows*/

	SEEK (isgz, fd , offset, SEEK_SET);

	for (ispin=0 ; ispin<nbspins ; ispin++) {

		for (ienergie=0 ; ienergie<nbenergies ; ienergie++) {
	
			for (ispectre=0 ; ispectre<nbspectres ; ispectre++) {

				READ (isgz, fd, tmp, sizeof(tmp));
				nbcoups = 256*tmp[0] + tmp[1];
				if (nbcoups > 0) {
					tmp2 = (unsigned char *) malloc (2 + 4*nbcoups);
					tmp2[0] = tmp[0];
					tmp2[1] = tmp[1];
					READ (isgz, fd, tmp2+2, 4*nbcoups);
					adresse = (size_t) tmp2;
				} else {
					adresse = 0;
				}

				dataquick[indice3(ienergie,ispectre,ispin,nbenergies,nbspectres,INUTILE)] = adresse;

			}

		}

	}

	CLOSE (isgz, fd);

}

/*---------------------------------------------------------------------------*/
void LIRE_FICHIERVAR_AUTO_GLUE (
/*---------------------------------------------------------------------------*/
	void	*p_nom_IDL,
	void	*p02,
	void	*p03,
	void	*p04,
	void	*p05,
	void	*p06) {

	int		argc=6;
	void		*argv[6];
	IDL_STRING	*nom_IDL;

	// p_nom_IDL -> nom_IDL
	nom_IDL = malloc (sizeof(IDL_STRING));
	IDL_StrStore (nom_IDL, p_nom_IDL);

	argv[0] = nom_IDL;
	argv[1] = p02;
	argv[2] = p03;
	argv[3] = p04;
	argv[4] = p05;
	argv[5] = p06;
	LIRE_FICHIERVAR (argc, argv);

	free (nom_IDL);

}

/*---------------------------------------------------------------------------*/
void LIBERE_DATAQUICK (int argc, void *argv[]) {
/*---------------------------------------------------------------------------*/

	int	nbarg		= 0;
	int	nbenergies	= *(int *)	argv[nbarg++];
	int	nbspectres	= *(int *)	argv[nbarg++];
	int	no1		= *(int *)	argv[nbarg++];
	int	no2		= *(int *)	argv[nbarg++];
	size_t	*dataquick	= (size_t *)	argv[nbarg++];

	int		ispin;
	int		ienergie;
	int		ispectre;
	unsigned char	*p;


	if (nbarg != argc) return;

	for (ispin=no1 ; ispin<=no2 ; ispin++) {

		for (ienergie=0 ; ienergie<nbenergies ; ienergie++) {

			for (ispectre=0 ; ispectre<nbspectres ; ispectre++) {
			
				if ((p = (unsigned char *) dataquick[indice3(ienergie,ispectre,no1+ispin,nbenergies,nbspectres,INUTILE)]) != 0) {

					free (p);
					dataquick[indice3(ienergie,ispectre,no1+ispin,nbenergies,nbspectres,INUTILE)] = 0;

				}

			}

		}

	}

}

/*---------------------------------------------------------------------------*/
void LIBERE_DATAQUICK_AUTO_GLUE (
/*---------------------------------------------------------------------------*/
	void	*p01,
	void	*p02,
	void	*p03,
	void	*p04,
	void	*p05) {

	int	argc=5;
	void	*argv[5];

	argv[0] = p01;
	argv[1] = p02;
	argv[2] = p03;
	argv[3] = p04;
	argv[4] = p05;
	LIBERE_DATAQUICK (argc, argv);

}

/*---------------------------------------------------------------------------*/
int FINDFILE (int argc, void *argv[]) {
/*---------------------------------------------------------------------------*/
	IDL_STRING	*masque = (IDL_STRING *)	argv[0]; 
	int		phase	= *(int *)		argv[1];
	IDL_STRING	*links	= (IDL_STRING *)	argv[2];

	static glob_t	buffer;
	int		i;
	char		*p;

	if (phase==2) {

		for (i=0 ; i<buffer.gl_pathc ; i++) {
			p = basename (buffer.gl_pathv[i]);
			//IDL_StrEnsureLength (links+i, strlen(p));
			IDL_StrStore (links+i, p);
		}
		globfree (&buffer);
		return 0;
	}

	buffer.gl_offs = 0;
	glob (IDL_STRING_STR(masque), GLOB_DOOFFS, NULL, & buffer);
	return buffer.gl_pathc;

}

/*---------------------------------------------------------------------------*/
int FINDFILE_AUTO_GLUE (
/*---------------------------------------------------------------------------*/
	void	*p_masque,
	void	*p02,
	void	*p_links,
	void	*p_nb) {

	int		argc=3;
	void		*argv[3];
	int		code;
	int		i;
	int		nb = * (int *) p_nb;
	IDL_STRING	*masque;
	IDL_STRING	*links;

	// p_masque -> masque
	masque = malloc (sizeof(IDL_STRING));
	IDL_StrStore (masque, p_masque);

	// p_links -> links
	links = malloc (nb * sizeof(IDL_STRING));
	for (i=0 ; i<nb ; i++) IDL_StrStore (links+i, IDL_STRING_STR((IDL_STRING *) (p_links + i*1024)));

	argv[0] = masque;
	argv[1] = p02;
	argv[2] = links;
	code = FINDFILE (argc, argv);

	// links -> p_links
	for (i=0 ; i<nb ; i++) strcpy (p_links+i*1024, IDL_STRING_STR(links+i));

	free (masque);
	free (links);

	return code;

}


/*---------------------------------------------------------------------------*/
int COMPARE_FICHIER (int argc, void *argv[]) {
/*---------------------------------------------------------------------------*/

	IDL_STRING *nom1_IDL = (IDL_STRING *) argv[0]; 
	IDL_STRING *nom2_IDL = (IDL_STRING *) argv[1]; 

	/*

	Compare les fichiers nom1 et nom2
	Retourne 0 si OK et 1 si PB

	*/
	FILE 		*fd1=NULL;
	FILE 		*fd2=NULL;
	char		*buffer1=NULL;
	char		*buffer2=NULL;
	struct stat	info1;
	struct stat	info2;
	#define		MAX	1024*1024
	int		code=1;
	int		read1;
	int		read2;
	int		isgz1;
	int		isgz2;

	isgz1 = ISGZ(IDL_STRING_STR(nom1_IDL));
	isgz2 = ISGZ(IDL_STRING_STR(nom2_IDL));

	if (isgz1==0 && isgz2==0) {

		if (stat (IDL_STRING_STR(nom1_IDL), &info1) != 0)
			return 1;

		if (stat (IDL_STRING_STR(nom2_IDL), &info2) != 0)
			return 1;

		if (info1.st_size != info2.st_size)
			return 1;

	}

	if ((fd1 = OPEN (isgz1,IDL_STRING_STR(nom1_IDL),"rb")) == NULL) 
		goto EXIT;

	if ((fd2 = OPEN (isgz2,IDL_STRING_STR(nom2_IDL),"rb")) == NULL)
		goto EXIT;

	if ((buffer1 = (char *)malloc (MAX)) == NULL)
		goto EXIT;

	if ((buffer2 = (char *)malloc (MAX)) == NULL)
		goto EXIT;

	while (!FEOF(isgz2,fd2)) {

		read1 = READ (isgz1, fd1, buffer1, MAX);
		read2 = READ (isgz2, fd2, buffer2, MAX);

		if (read1 != read2)
			goto EXIT;

		if (memcmp (buffer1, buffer2,read1) != 0)
			goto EXIT;
		

	}

	code = FEOF(isgz1,fd1) ? 0 : 1;

	

EXIT:

	if (fd1 != NULL) CLOSE (isgz1,fd1);
	if (fd2 != NULL) CLOSE (isgz2,fd2);
	if (buffer1 != NULL) free (buffer1);
	if (buffer2 != NULL) free (buffer2);

	return code;

}

/*---------------------------------------------------------------------------*/
int COMPARE_FICHIER_AUTO_GLUE (
/*---------------------------------------------------------------------------*/
	void	*p_nom1_IDL,
	void	*p_nom2_IDL) {

	int		argc=2;
	void		*argv[2];
	int		code;
	IDL_STRING	*nom1_IDL;
	IDL_STRING	*nom2_IDL;

	// p_nom1_IDL -> nom1_IDL
	nom1_IDL = malloc (sizeof(IDL_STRING));
	IDL_StrStore (nom1_IDL, p_nom1_IDL);

	// p_nom2_IDL -> nom2_IDL
	nom2_IDL = malloc (sizeof(IDL_STRING));
	IDL_StrStore (nom2_IDL, p_nom2_IDL);

	argv[0] = nom1_IDL;
	argv[1] = nom2_IDL;
	code = COMPARE_FICHIER (argc, argv);

	free (nom1_IDL);
	free (nom2_IDL);

	return code;

}

/*---------------------------------------------------------------------------*/
int TARANIS_FILE_EVENT_COMPUTE (int argc, void *argv[]) {
/*---------------------------------------------------------------------------*/

	int		nbarg			=	0;
	IDL_STRING	*nom			=	(IDL_STRING *)		argv[nbarg++];
	int		taille			=	*(int *)		argv[nbarg++];	/* nombre d'octets dans le fichier d'un enregisterment */
	int		offset			=	*(int *)		argv[nbarg++];
	int		no			=	*(int *)		argv[nbarg++];	/* commencer  lire  l'enregistrement no */
	int		nb			=	*(int *)		argv[nbarg++];	/* lire nb enregistrements */
	int		offset_date		=	*(int *)		argv[nbarg++];
	int		offset_type		=	*(int *)		argv[nbarg++];
	int		offset_sensor		=	*(int *)		argv[nbarg++];
	int		offset_raw_energy	=	*(int *)		argv[nbarg++];

	int		nb_tmp			=	*(int *)		argv[nbarg++];
	int		nbenergies		=	*(int *)		argv[nbarg++];
	double		*tmp_date		=	(double *)		argv[nbarg++];
	float		*tmp_data		=	(float *)		argv[nbarg++]; // tmp_data[nbenergies,nb_tmp]

	int		event_type		=	*(int *)		argv[nbarg++];
	int		event_sensor		=	*(int *)		argv[nbarg++];


	/*
	Valeur de retour:
		0:	OK
		-1:	erreur lors de l'ouverture du fichier
		-2:	erreur lors de la lecture du fichier
	*/

	FILE		*fd=NULL;
	int		i;
	int		j=0;
	unsigned char	buffer[1024];
	int		isgz;
	int		code=1;

	double		date;
	unsigned char	type;
	unsigned char	sensor;
	unsigned char	raw_energy;

	long		nbsec;
	double		nbmilli;


	isgz = ISGZ(IDL_STRING_STR(nom));
	if ((fd = OPEN (isgz, IDL_STRING_STR(nom), "rb")) == NULL) {
		code=-1;
		goto EXIT;
	}

	// Pas la peine de faire un SEEK si offset==no==0
	if (offset || no) SEEK (isgz, fd, offset+no*(MY_OFF_T)taille, SEEK_SET);

	for (i=0; i<nb; i++) {

		if (READ (isgz, fd, buffer, taille) != taille) {
			code = -2;
			goto EXIT;
		}

		date		= * (double *)        (buffer + offset_date);
		type		= * (unsigned char *) (buffer + offset_type);
		sensor		= * (unsigned char *) (buffer + offset_sensor);
		raw_energy	= * (unsigned char *) (buffer + offset_raw_energy);

		if (type==event_type && sensor==event_sensor) {

			// seconde correspondante
			nbsec = date / 1000;
			nbmilli = nbsec * 1000;

			// Chercher nbmilli dans tmp_date en commencant au dernier j utilis
			for ( ; j<nb_tmp ; j++) {
				if (tmp_date[j] == nbmilli) {
					tmp_data[indice2(raw_energy,j,nbenergies,nb_tmp)]++;
					break;
				}
			}

		}

	}

EXIT:

	if (fd != NULL) CLOSE (isgz, fd);

	return code;

}

/*---------------------------------------------------------------------------*/
int TARANIS_FILE_EVENT_COMPUTE_AUTO_GLUE (
/*---------------------------------------------------------------------------*/
	void	*p_nom,
	void	*p02,
	void	*p03,
	void	*p04,
	void	*p05,
	void	*p06,
	void	*p07,
	void	*p08,
	void	*p09,
	void	*p10,
	void	*p11,
	void	*p12,
	void	*p13,
	void	*p14,
	void	*p15) {

	int		argc=15;
	void		*argv[15];
	int		code;
	IDL_STRING	*nom;

	// p_nom -> nom
	nom = malloc (sizeof(IDL_STRING));
	IDL_StrStore (nom, p_nom);

	argv[ 0] = nom;
	argv[ 1] = p02;
	argv[ 2] = p03;
	argv[ 3] = p04;
	argv[ 4] = p05;
	argv[ 5] = p06;
	argv[ 6] = p07;
	argv[ 7] = p08;
	argv[ 8] = p09;
	argv[ 9] = p10;
	argv[10] = p11;
	argv[11] = p12;
	argv[12] = p13;
	argv[13] = p14;
	argv[14] = p15;
	code = TARANIS_FILE_EVENT_COMPUTE (argc, argv);

	free (nom);

	return code;

}

/*---------------------------------------------------------------------------*/
int TARANIS_IDEE_GET_DATA_EVENT (int argc, void *argv[]) {
/*---------------------------------------------------------------------------*/

	int		nbarg			=	0;
	IDL_STRING	*nom			=	(IDL_STRING *)		argv[nbarg++];
	int		taille			=	*(int *)		argv[nbarg++];	/* nombre d'octets dans le fichier d'un enregisterment */
	int		no			=	*(int *)		argv[nbarg++];	/* commencer  lire  l'enregistrement no */
	int		nb			=	*(int *)		argv[nbarg++];	/* lire nb enregistrements */
	int		offset_date		=	*(int *)		argv[nbarg++];
	int		offset_correction	=	*(int *)		argv[nbarg++];
	int		offset_type		=	*(int *)		argv[nbarg++];
	int		offset_sensor		=	*(int *)		argv[nbarg++];
	int		offset_raw_energy	=	*(int *)		argv[nbarg++];
	int		offset_conv_energy	=	*(int *)		argv[nbarg++];
	int		offset_orbit_number	=	*(int *)		argv[nbarg++];
	int		offset_event_number	=	*(int *)		argv[nbarg++];
	long		nbtemps			=	*(long *)		argv[nbarg++];
	int		nbenergies		=	*(int *)		argv[nbarg++];
	int		nbtables		=	*(int *)		argv[nbarg++];
	float		*spectreX		=	(float *)		argv[nbarg++]; // spectreX[nbenergies*nbtables]
	float		*spectreY		=	(float *)		argv[nbarg++]; // spectreY[nbenergies*nbtables]
	float		*courbeY		=	(float *)		argv[nbarg++]; // courbeY[nbtemps]
	unsigned char	*tab_event_type		=	(unsigned char*)	argv[nbarg++]; // tab_event_type[4]
	unsigned char	*tab_event_sensor	=	(unsigned char*)	argv[nbarg++]; // tab_event_sensor[8]
	int		event_emin		=	*(int *)		argv[nbarg++];
	int		event_emax		=	*(int *)		argv[nbarg++];
	double		date1			=	*(double *)		argv[nbarg++];
	long		correction1		=	*(long *)		argv[nbarg++]; // nombre de nanoseconde a ajouter  date1
	double		date2			=	*(double *)		argv[nbarg++];
	long		correction2		=	*(long *)		argv[nbarg++]; // nombre de nanoseconde a ajouter  date2
	double		event_dt_millisec	=	*(double *)		argv[nbarg++];
	int		use_raw_energy		=	*(unsigned int *)	argv[nbarg++];
	int		output_ascii		=	*(int *)		argv[nbarg++];	// 1 pour faire une sortie ascii, 0 sinon
	IDL_STRING 	*filename_ascii		=	(IDL_STRING *)		argv[nbarg++];


	/*
	Valeur de retour:
		 1:	OK
		-1:	erreur lors de l'ouverture du fichier
		-2:	erreur lors de la lecture du fichier
		-3:	nbtables est trop petit
	*/

	FILE		*fd=NULL;
	int		i;
	int		j=0;
	int		itable;
	int		indice;
	unsigned char	buffer[1024];
	int		isgz;
	int		isgz_ascii=0; // initialisation sinon warning gcc
	int		code=1;

	double		date;
	short		correction;
	double		old_date=0;
	unsigned char	type;
	unsigned char	sensor;
	unsigned char	raw_energy;
	float		conv_energy;
	float		val_energy;
	unsigned int	orbit_number;
	unsigned short	event_number;

	FILE		*fd_ascii=NULL;

	int		annee;
	int		mois;
	int		jour;
	int		heure;
	int		minute;
	double		seconde;
	long double	longdoubledate;
	long double	longdoubledate1;
	long double	longdoubledate2;


	isgz = ISGZ(IDL_STRING_STR(nom));
	if ((fd = OPEN (isgz, IDL_STRING_STR(nom), "rb")) == NULL) {
		code=-1;
		goto EXIT;
	}

	if (output_ascii) {
		isgz_ascii = ISGZ(IDL_STRING_STR(filename_ascii));
		if ((fd_ascii = OPEN (isgz_ascii, IDL_STRING_STR(filename_ascii), "a")) == NULL) {
			code=-1;
			goto EXIT;
		}
	}

	longdoubledate1 = date1 + correction1 * 1e-6L; // L obligatoire sinon le rsultat n'est pas bon

	longdoubledate2 = date2 + correction2 * 1e-6L; // L obligatoire sinon le rsultat n'est pas bon

	// Pas la peine de faire un SEEK si no==0
	if (no) SEEK (isgz, fd, no*(MY_OFF_T)taille, SEEK_SET);

	for (i=0; i<nb; i++) {

		if (READ (isgz, fd, buffer, taille) != taille) {
			code = -2;
			goto EXIT;
		}

		date = * (double *) (buffer + offset_date);

		if (old_date != 0 && date < old_date) {
			orbit_number	= * (unsigned int *)   (buffer + offset_orbit_number);
			event_number	= * (unsigned short *) (buffer + offset_event_number);
			printf ("  *** AIE_DATE  orbit=%06d  event=%03d  old_date=%lf  date=%lf  dt_millisec=%lf\n",orbit_number,event_number,old_date,date,date-old_date);
		}
		old_date = date;

		correction 		= * (short *)		(buffer + offset_correction);
		longdoubledate = date + correction * 1e-6L; // L obligatoire sinon le rsultat n'est pas bon

		// ne garder que les dates entre date1 et date2 sinon core cumped
		if (longdoubledate < longdoubledate1) continue;
		if (longdoubledate > longdoubledate2) continue;

		type		= * (unsigned char *) (buffer + offset_type);
		sensor		= * (unsigned char *) (buffer + offset_sensor);
		raw_energy	= * (unsigned char *) (buffer + offset_raw_energy);
		conv_energy	= * (float *)         (buffer + offset_conv_energy);
	
		if (output_ascii) {
			orbit_number	= * (unsigned int *)   (buffer + offset_orbit_number);
			event_number	= * (unsigned short *) (buffer + offset_event_number);
			longdoubledate_to_tu (longdoubledate, &annee, &mois, &jour, &heure, &minute, &seconde);
			if (isgz_ascii) {
				gzprintfXXX (fd_ascii,
							"%04d %02d %02d %02d %02d %09.6f %d %d %d %f %d %d\n",
							annee, mois, jour, heure, minute, seconde,
							type, sensor, raw_energy, conv_energy, orbit_number, event_number);
			} else {
				fprintf (fd_ascii,
							"%04d %02d %02d %02d %02d %09.6f %d %d %d %f %d %d\n",
							annee, mois, jour, heure, minute, seconde,
							type, sensor, raw_energy, conv_energy, orbit_number, event_number);
			}
		}

		if (type > 3) {
			printf (" *** AIE_TYPE type=%d\n",type);
			continue;
		}

		if (sensor > 7) {
			printf (" *** AIE_SENSOR sensor=%d\n",sensor);
			continue;
		}

		if (raw_energy > 63) {
			printf (" *** AIE_RAW_ENERGY raw_energy=%d\n",raw_energy);
			continue;
		}

		if (tab_event_type[type] && tab_event_sensor[sensor]) {

			if (raw_energy >= event_emin && raw_energy <= event_emax) {

				j = (longdoubledate - longdoubledate1) / (long double) event_dt_millisec;
				if (j < 0) {
					continue;
				} else if (j >= nbtemps) {
					continue;
				} else {
					if (courbeY[j] < -1e30) {
						courbeY[j] = 1;
					} else {
						courbeY[j]++;
					}
				}

				val_energy = use_raw_energy ? raw_energy : conv_energy;
				// Existe-il un point j avec spectreX[j] == val_energy ?
				for (itable=0 ; itable<nbtables ; itable++) {
					indice = raw_energy + 64*type + itable*nbenergies;
					if (spectreX[indice] == val_energy) {
						// trouve
						spectreY[indice]++;
						break;
					} else if (spectreX[indice] < -1e30) {
						// on rajoute un point
						spectreX[indice] = val_energy;
						spectreY[indice] = 1;
						break;
					}
				}
				if (itable == nbtables) {
					code = -3;
					goto EXIT;
				}

			}

		}

	}

EXIT:

	if (fd != NULL) CLOSE (isgz, fd);
	if (output_ascii) {
		if (fd_ascii != NULL) CLOSE (isgz_ascii,fd_ascii);
	}

	return code;

}

/*---------------------------------------------------------------------------*/
int TARANIS_IDEE_GET_DATA_EVENT_AUTO_GLUE (
/*---------------------------------------------------------------------------*/
	void	*p_nom,
	void	*p02,
	void	*p03,
	void	*p04,
	void	*p05,
	void	*p06,
	void	*p07,
	void	*p08,
	void	*p09,
	void	*p10,
	void	*p11,
	void	*p12,
	void	*p13,
	void	*p14,
	void	*p15,
	void	*p16,
	void	*p17,
	void	*p18,
	void	*p19,
	void	*p20,
	void	*p21,
	void	*p22,
	void	*p23,
	void	*p24,
	void	*p25,
	void	*p26,
	void	*p27,
	void	*p28,
	void	*p29,
	void	*p_filename_ascii) {

	int		argc=30;
	void		*argv[30];
	int		code;
	IDL_STRING	*nom;
	IDL_STRING	*filename_ascii;

	// p_nom -> nom
	nom = malloc (sizeof(IDL_STRING));
	IDL_StrStore (nom, p_nom);

	// p_filename_ascii -> filename_ascii
	filename_ascii = malloc (sizeof(IDL_STRING));
	IDL_StrStore (filename_ascii, p_filename_ascii);

	argv[ 0] = nom;
	argv[ 1] = p02;
	argv[ 2] = p03;
	argv[ 3] = p04;
	argv[ 4] = p05;
	argv[ 5] = p06;
	argv[ 6] = p07;
	argv[ 7] = p08;
	argv[ 8] = p09;
	argv[ 9] = p10;
	argv[10] = p11;
	argv[11] = p12;
	argv[12] = p13;
	argv[13] = p14;
	argv[14] = p15;
	argv[15] = p16;
	argv[16] = p17;
	argv[17] = p18;
	argv[18] = p19;
	argv[19] = p20;
	argv[20] = p21;
	argv[21] = p22;
	argv[22] = p23;
	argv[23] = p24;
	argv[24] = p25;
	argv[25] = p26;
	argv[26] = p27;
	argv[27] = p28;
	argv[28] = p29;
	argv[29] = filename_ascii;
	code = TARANIS_IDEE_GET_DATA_EVENT (argc, argv);

	free (nom);
	free (filename_ascii);

	return code;

}

/*---------------------------------------------------------------------------*/
int TARANIS_XGRE_GET_DATA_EVENT (int argc, void *argv[]) {
/*---------------------------------------------------------------------------*/

	int		nbarg				=	0;
	IDL_STRING	*nom				=	(IDL_STRING *)		argv[nbarg++];
	int		taille				=	*(int *)		argv[nbarg++];	/* nombre d'octets dans le fichier d'un enregisterment */
	int		no				=	*(int *)		argv[nbarg++];	/* commencer  lire  l'enregistrement no */
	int		nb				=	*(int *)		argv[nbarg++];	/* lire nb enregistrements */
	int		offset_date			=	*(int *)		argv[nbarg++];
	int		offset_correction		=	*(int *)		argv[nbarg++];
	int		offset_sensor			=	*(int *)		argv[nbarg++];
	int		offset_raw_energy_pup		=	*(int *)		argv[nbarg++];
	int		offset_conv_energy_pup		=	*(int *)		argv[nbarg++];
	int		offset_raw_energy_labr3		=	*(int *)		argv[nbarg++];
	int		offset_conv_energy_labr3	=	*(int *)		argv[nbarg++];
	int		offset_raw_energy_pdown		=	*(int *)		argv[nbarg++];
	int		offset_conv_energy_pdown	=	*(int *)		argv[nbarg++];
	int		offset_orbit_number		=	*(int *)		argv[nbarg++];
	int		offset_event_number		=	*(int *)		argv[nbarg++];
	long		nbtemps				=	*(long *)		argv[nbarg++];
	int		nbenergies			=	*(int *)		argv[nbarg++];
	int		nbtables			=	*(int *)		argv[nbarg++];
	float		emin				=	*(float *)		argv[nbarg++];
	float		emax				=	*(float *)		argv[nbarg++];
	float		*spectreX			=	(float *)		argv[nbarg++]; // spectreX[nbenergies*nbtables]
	float		*spectreY			=	(float *)		argv[nbarg++]; // spectreY[nbenergies*nbtables]
	float		*courbeY			=	(float *)		argv[nbarg++]; // courbeY[nbtemps]
	unsigned char	*tab_event_sensor		=	(unsigned char*)	argv[nbarg++]; // tab_event_sensor[4]
	unsigned char	*tab_event_plane		=	(unsigned char *)	argv[nbarg++]; // tab_event_plane[3]
	int		*tab_event_emin			=	(int *)			argv[nbarg++]; // tab_event_emin[3]
	int		*tab_event_emax			=	(int *)			argv[nbarg++]; // tab_event_emax[3]
	double		date1				=	*(double *)		argv[nbarg++];
	long		correction1			=	*(long *)		argv[nbarg++]; // nombre de nanoseconde a ajouter  date1
	double		date2				=	*(double *)		argv[nbarg++];
	long		correction2			=	*(long *)		argv[nbarg++]; // nombre de nanoseconde a ajouter  date2
	double		event_dt_millisec		=	*(double *)		argv[nbarg++];
	int		use_raw_energy			=	*(unsigned int *)	argv[nbarg++];
	int		output_ascii			=	*(int *)		argv[nbarg++];	// 1 pour faire une sortie ascii, 0 sinon
	IDL_STRING 	*filename_ascii			=	(IDL_STRING *)		argv[nbarg++];


	/*
	Valeur de retour:
		 1:	OK
		-1:	erreur lors de l'ouverture du fichier
		-2:	erreur lors de la lecture du fichier
		-3:	nbtables est trop petit
	*/

	FILE		*fd=NULL;
	int		i;
	int		j=0;
	int		itable;
	int		indice;
	unsigned char	buffer[1024];
	int		isgz;
	int		isgz_ascii=0; // initialisation sinon warning gcc
	int		code=1;

	double		date;
	short		correction;
	double		old_date=0;
	unsigned char	sensor;
	unsigned short	raw_energy_pup;
	float		conv_energy_pup;
	unsigned short	raw_energy_labr3;
	float		conv_energy_labr3;
	unsigned short	raw_energy_pdown;
	float		conv_energy_pdown;
	int		raw_energy=0; // initialisation sinon warning gcc
	float		conv_energy=0; // initialisation sinon warning gcc
	float		val_energy;
	unsigned int	orbit_number;
	unsigned short	event_number;
	int		nbplanes;
	float		pas_energy;

	FILE		*fd_ascii=NULL;

	int		annee;
	int		mois;
	int		jour;
	int		heure;
	int		minute;
	double		seconde;
	long double	longdoubledate;
	long double	longdoubledate1;
	long double	longdoubledate2;


	isgz = ISGZ(IDL_STRING_STR(nom));
	if ((fd = OPEN (isgz, IDL_STRING_STR(nom), "rb")) == NULL) {
		code=-1;
		goto EXIT;
	}

	if (output_ascii) {
		isgz_ascii = ISGZ(IDL_STRING_STR(filename_ascii));
		if ((fd_ascii = OPEN (isgz_ascii, IDL_STRING_STR(filename_ascii), "a")) == NULL) {
			code=-1;
			goto EXIT;
		}
	}

	nbplanes = tab_event_plane[0] + tab_event_plane[1] + tab_event_plane[2];

	pas_energy = (emax - emin) / nbenergies;

	longdoubledate1 = date1 + correction1 * 1e-6L; // L obligatoire sinon le rsultat n'est pas bon

	longdoubledate2 = date2 + correction2 * 1e-6L; // L obligatoire sinon le rsultat n'est pas bon

	// Forcer utilisation de conv_enery si on utilise plus d'un plan
	if (nbplanes != 1) use_raw_energy = 0;

	// Pas la peine de faire un SEEK si no==0
	if (no) SEEK (isgz, fd, no*(MY_OFF_T)taille, SEEK_SET);

	for (i=0; i<nb; i++) {

		if (READ (isgz, fd, buffer, taille) != taille) {
			code = -2;
			goto EXIT;
		}

		date = * (double *) (buffer + offset_date);

		if (old_date != 0 && date < old_date) {
			orbit_number		= * (unsigned int *)	(buffer + offset_orbit_number);
			event_number		= * (unsigned short *)	(buffer + offset_event_number);
			printf (" *** AIE_DATE  orbit=%06d  event=%03d  old_date=%lf  date=%lf  dt_millisec=%lf\n",orbit_number,event_number,old_date,date,date-old_date);
		}
		old_date = date;


		correction 		= * (short *)		(buffer + offset_correction);
		longdoubledate = date + correction * 1e-6L; // L obligatoire sinon le rsultat n'est pas bon

		// ne garder que les dates entre longdoubledate1 et longdoubledate2
		if (longdoubledate < longdoubledate1) continue;
		if (longdoubledate > longdoubledate2) continue;

		sensor			= * (unsigned char *)  (buffer + offset_sensor);
		raw_energy_pup		= * (unsigned short *) (buffer + offset_raw_energy_pup);
		conv_energy_pup		= * (float *)          (buffer + offset_conv_energy_pup);
		raw_energy_labr3	= * (unsigned short *) (buffer + offset_raw_energy_labr3);
		conv_energy_labr3	= * (float *)          (buffer + offset_conv_energy_labr3);
		raw_energy_pdown	= * (unsigned short *) (buffer + offset_raw_energy_pdown);
		conv_energy_pdown	= * (float *)          (buffer + offset_conv_energy_pdown);


		if (output_ascii) {
			orbit_number		= * (unsigned int *)	(buffer + offset_orbit_number);
			event_number		= * (unsigned short *)	(buffer + offset_event_number);
			longdoubledate_to_tu (longdoubledate, &annee, &mois, &jour, &heure, &minute, &seconde);
			if (isgz_ascii) {
				gzprintfXXX (fd_ascii, 
							"%04d %02d %02d %02d %02d %12.9f %d %d %f %d %f %d %f %d %d\n",
							annee, mois, jour, heure, minute, seconde,
							sensor,
							raw_energy_pup, conv_energy_pup,
							raw_energy_labr3, conv_energy_labr3,
							raw_energy_pdown, conv_energy_pdown,
							orbit_number, event_number);
			} else {
				fprintf (fd_ascii,
							"%04d %02d %02d %02d %02d %12.9f %d %d %f %d %f %d %f %d %d\n",
							annee, mois, jour, heure, minute, seconde,
							sensor,
							raw_energy_pup, conv_energy_pup,
							raw_energy_labr3, conv_energy_labr3,
							raw_energy_pdown, conv_energy_pdown,
							orbit_number, event_number);
			}
		}

		if (sensor > 3) {
			printf (" *** AIE_SENSOR sensor=%d\n",sensor);
			continue;
		}

		if (raw_energy_pup > 255) {
			printf (" *** AIE_RAW_ENERGY_PUP raw_energy_pup=%d\n",raw_energy_pup);
			continue;
		}

		if (raw_energy_labr3 > 1023) {
			printf (" *** AIE_RAW_ENERGY_LABR3 raw_energy_labr3=%d\n",raw_energy_labr3);
			continue;
		}

		if (raw_energy_pdown > 255) {
			printf (" *** AIE_RAW_ENERGY_PDOWN raw_energy_pdown=%d\n",raw_energy_pdown);
			continue;
		}

		if (tab_event_sensor[sensor] == 0) continue;

		if (nbplanes == 0) continue; // il ne faut rien faire du tout

		j = (longdoubledate - longdoubledate1) / (long double) event_dt_millisec;

		if (j < 0) {
			continue;
		} else if (j >= nbtemps) {
			continue;
		} else {
			if (courbeY[j] < -1e30) {
				courbeY[j] = 1;
			} else {
				courbeY[j]++;
			}
		}


		raw_energy = 0;
		conv_energy = 0;

		// On va mettre dans conv_energy la somme des conv_energy des plans utiliss

		if (tab_event_plane[0]) {
			if (raw_energy_pup < tab_event_emin[0]) continue;
			if (raw_energy_pup > tab_event_emax[0]) continue;
			raw_energy	+= raw_energy_pup;
			conv_energy	+= conv_energy_pup;
		}

		if (tab_event_plane[1]) {
			if (raw_energy_labr3 < tab_event_emin[1]) continue;
			if (raw_energy_labr3 > tab_event_emax[1]) continue;
			raw_energy	+= raw_energy_labr3;
			conv_energy	+= conv_energy_labr3;
		}

		if (tab_event_plane[2]) {
			if (raw_energy_pdown < tab_event_emin[2]) continue;
			if (raw_energy_pdown > tab_event_emax[2]) continue;
			raw_energy	+= raw_energy_pdown;
			conv_energy	+= conv_energy_pdown;
		}

		if (nbplanes > 1) {
			// On utilise une table de nbenergies valeurs entre emin et max
			indice = (int) ((conv_energy - emin) / pas_energy);
			val_energy = emin + (indice + 0.5) * pas_energy;
		} else {
			val_energy = use_raw_energy ? raw_energy : conv_energy;
		}


		// Existe-il un point j avec spectreX[j] == val_energy ?
		for (itable=0 ; itable<nbtables ; itable++) {

			if (nbplanes > 1) {
				indice = (int) ((conv_energy - emin) / pas_energy);
			} else {
				indice = 0;
				if (tab_event_plane[0]) indice += raw_energy_pup;
				if (tab_event_plane[1]) indice += raw_energy_labr3;
				if (tab_event_plane[2]) indice += raw_energy_pdown;
			}

			indice += itable*nbenergies;
			if (spectreX[indice] == val_energy) {
				// trouve
				spectreY[indice]++;
				break;
			} else if (spectreX[indice] < -1e30) {
				// on rajoute un point
				spectreX[indice] = val_energy;
				spectreY[indice] = 1;
				break;
			}
		}
		if (itable == nbtables) {
			printf ("COLLISION: pup=(%d %f) labr3=(%d %f) pdown=(%d %f)\n",
				raw_energy_pup, conv_energy_pup,
				raw_energy_labr3, conv_energy_labr3,
				raw_energy_pdown, conv_energy_pdown);
			code = -3;
			goto EXIT;
		}

	}

EXIT:

	if (fd != NULL) CLOSE (isgz, fd);
	if (output_ascii) {
		if (fd_ascii != NULL) CLOSE (isgz_ascii,fd_ascii);
	}

	return code;

}

/*---------------------------------------------------------------------------*/
int TARANIS_XGRE_GET_DATA_EVENT_AUTO_GLUE (
/*---------------------------------------------------------------------------*/
	void	*p_nom,
	void	*p02,
	void	*p03,
	void	*p04,
	void	*p05,
	void	*p06,
	void	*p07,
	void	*p08,
	void	*p09,
	void	*p10,
	void	*p11,
	void	*p12,
	void	*p13,
	void	*p14,
	void	*p15,
	void	*p16,
	void	*p17,
	void	*p18,
	void	*p19,
	void	*p20,
	void	*p21,
	void	*p22,
	void	*p23,
	void	*p24,
	void	*p25,
	void	*p26,
	void	*p27,
	void	*p28,
	void	*p29,
	void	*p30,
	void	*p31,
	void	*p32,
	void	*p33,
	void	*p34,
	void	*p_filename_ascii) {

	int		argc=35;
	void		*argv[35];
	int		code;
	IDL_STRING	*nom;
	IDL_STRING	*filename_ascii;

	// p_nom -> nom
	nom = malloc (sizeof(IDL_STRING));
	IDL_StrStore (nom, p_nom);

	// p_filename_ascii -> filename_ascii
	filename_ascii = malloc (sizeof(IDL_STRING));
	IDL_StrStore (filename_ascii, p_filename_ascii);

	argv[ 0] = nom;
	argv[ 1] = p02;
	argv[ 2] = p03;
	argv[ 3] = p04;
	argv[ 4] = p05;
	argv[ 5] = p06;
	argv[ 6] = p07;
	argv[ 7] = p08;
	argv[ 8] = p09;
	argv[ 9] = p10;
	argv[10] = p11;
	argv[11] = p12;
	argv[12] = p13;
	argv[13] = p14;
	argv[14] = p15;
	argv[15] = p16;
	argv[16] = p17;
	argv[17] = p18;
	argv[18] = p19;
	argv[19] = p20;
	argv[20] = p21;
	argv[21] = p22;
	argv[22] = p23;
	argv[23] = p24;
	argv[24] = p25;
	argv[25] = p26;
	argv[26] = p27;
	argv[27] = p28;
	argv[28] = p29;
	argv[29] = p30;
	argv[30] = p31;
	argv[31] = p32;
	argv[32] = p33;
	argv[33] = p34;
	argv[34] = filename_ascii;
	code = TARANIS_XGRE_GET_DATA_EVENT (argc, argv);

	free (nom);
	free (filename_ascii);

	return code;

}

/*---------------------------------------------------------------------------*/
int TARANIS_GET_DATA_ORBIT (int argc, void *argv[]) {
/*---------------------------------------------------------------------------*/

	int		nbarg			=	0;
	IDL_STRING	*nom			=	(IDL_STRING *)		argv[nbarg++];
	int		taille			=	*(int *)		argv[nbarg++];	/* nombre d'octets dans le fichier d'un enregisterment */
	int		no			=	*(int *)		argv[nbarg++];	/* commencer  lire  l'enregistrement no */
	int		nb			=	*(int *)		argv[nbarg++];	/* lire nb enregistrements */
	int		offset_date		=	*(int *)		argv[nbarg++];
	int		offset_orbit		=	*(int *)		argv[nbarg++];
	double		date0			=	*(double *)		argv[nbarg++];
	float		*courbeY		=	(float *)		argv[nbarg++]; // courbeY[nbtemps]

	/*
	Valeur de retour:
		 1:	OK
		-1:	erreur lors de l'ouverture du fichier
		-2:	erreur lors de la lecture du fichier
	*/

	FILE		*fd=NULL;
	int		i;
	int		j=0;
	unsigned char	buffer[1024];
	int		isgz;
	int		code=1;

	double		date;
	double		old_date=0;
	unsigned int	orbit;

	isgz = ISGZ(IDL_STRING_STR(nom));
	if ((fd = OPEN (isgz, IDL_STRING_STR(nom), "rb")) == NULL) {
		code=-1;
		goto EXIT;
	}

	// Pas la peine de faire un SEEK si no==0
	if (no) SEEK (isgz, fd, no*(MY_OFF_T)taille, SEEK_SET);

	for (i=0; i<nb; i++) {

		if (READ (isgz, fd, buffer, taille) != taille) {
			code = -2;
			goto EXIT;
		}

		date = * (double *) (buffer + offset_date);

		if (old_date != 0 && date < old_date) {
			printf (" *** AIE_DATE  old_date=%lf  date=%lf  dt_millisec=%lf\n",old_date,date,date-old_date);
		}
		old_date = date;

		orbit = * (unsigned int *) (buffer + offset_orbit);

		j = date/1000 - date0/1000;
		courbeY[j] = orbit;

	}

EXIT:

	if (fd != NULL) CLOSE (isgz, fd);

	return code;

}

/*---------------------------------------------------------------------------*/
int TARANIS_GET_DATA_ORBIT_AUTO_GLUE (
/*---------------------------------------------------------------------------*/
	void	*p_nom,
	void	*p02,
	void	*p03,
	void	*p04,
	void	*p05,
	void	*p06,
	void	*p07,
	void	*p08) {

	int		argc=8;
	void		*argv[8];
	int		code;
	IDL_STRING	*nom;

	// p_nom -> nom
	nom = malloc (sizeof(IDL_STRING));
	IDL_StrStore (nom, p_nom);

	argv[0] = nom;
	argv[1] = p02;
	argv[2] = p03;
	argv[3] = p04;
	argv[4] = p05;
	argv[5] = p06;
	argv[6] = p07;
	argv[7] = p08;
	code = TARANIS_GET_DATA_ORBIT (argc, argv);

	free (nom);

	return code;

}

/*---------------------------------------------------------------------------*/
int TARANIS_ASCII_OUTPUT_TIME_Y (int argc, void *argv[]) {
/*---------------------------------------------------------------------------*/

	int		nbarg			=	0;
	int		nb			=	*(int *)		argv[nbarg++];
	long		*nanodate		=	(long *)		argv[nbarg++]; // courbeX[nb]
	float		*courbeY		=	(float *)		argv[nbarg++]; // courbeY[nb]
	IDL_STRING 	*filename_ascii		=	(IDL_STRING *)		argv[nbarg++];

	int		code=1;
	int		isgz_ascii=0; // initialisation sinon warning gcc
	FILE		*fd_ascii=NULL;
	int		annee;
	int		mois;
	int		jour;
	int		heure;
	int		minute;
	int		seconde;
	int		milli;
	int		micro;
	int		nano;
	int		i;

	isgz_ascii = ISGZ(IDL_STRING_STR(filename_ascii));
	if ((fd_ascii = OPEN (isgz_ascii, IDL_STRING_STR(filename_ascii), "a")) == NULL) {
		code=-1;
		goto EXIT;
	}

	for (i=0 ; i<nb ; i++) {

		nanodate_to_tu (nanodate[i], &annee, &mois, &jour, &heure, &minute, &seconde, &milli, &micro, &nano);
		if (isgz_ascii) {
			gzprintfXXX (fd_ascii,
						"%04d %02d %02d %02d %02d %02d.%03d%03d%03d %f\n",
						annee, mois, jour, heure, minute, seconde, milli, micro, nano, courbeY[i]);
		} else {
			fprintf (fd_ascii,
						"%04d %02d %02d %02d %02d %02d.%03d%03d%03d %f\n",
						annee, mois, jour, heure, minute, seconde, milli, micro, nano, courbeY[i]);
		}
	}

EXIT:

	if (fd_ascii != NULL) CLOSE (isgz_ascii,fd_ascii);

	return code;

}

/*---------------------------------------------------------------------------*/
int TARANIS_ASCII_OUTPUT_TIME_Y_AUTO_GLUE (
/*---------------------------------------------------------------------------*/
	void	*p01,
	void	*p02,
	void	*p03,
	void	*p_filename_ascii) {

	int		argc=4;
	void		*argv[4];
	int		code;
	IDL_STRING	*filename_ascii;

	// p_filename_ascii -> filename_ascii
	filename_ascii = malloc (sizeof(IDL_STRING));
	IDL_StrStore (filename_ascii, p_filename_ascii);

	argv[0] = p01;
	argv[1] = p02;
	argv[2] = p03;
	argv[3] = filename_ascii;
	code = TARANIS_ASCII_OUTPUT_TIME_Y (argc, argv);

	free (filename_ascii);

	return code;

}

/*---------------------------------------------------------------------------*/
int TARANIS_ASCII_OUTPUT_X_Y (int argc, void *argv[]) {
/*---------------------------------------------------------------------------*/

	int		nbarg			=	0;
	int		nb			=	*(int *)		argv[nbarg++];
	float		*courbeX		=	(float *)		argv[nbarg++]; // courbeX[nb]
	float		*courbeY		=	(float *)		argv[nbarg++]; // courbeY[nb]
	IDL_STRING 	*filename_ascii		=	(IDL_STRING *)		argv[nbarg++];

	int		code=1;
	int		isgz_ascii=0; // initialisation sinon warning gcc
	FILE		*fd_ascii=NULL;
	int		i;

	isgz_ascii = ISGZ(IDL_STRING_STR(filename_ascii));
	if ((fd_ascii = OPEN (isgz_ascii, IDL_STRING_STR(filename_ascii), "a")) == NULL) {
		code=-1;
		goto EXIT;
	}

	for (i=0 ; i<nb ; i++) {

		if (isgz_ascii) {
			gzprintfXXX (fd_ascii,
						"%f %f\n",
						courbeX[i], courbeY[i]);
		} else {
			fprintf (fd_ascii,
						"%f %f\n",
						courbeX[i], courbeY[i]);
		}
	}

EXIT:

	if (fd_ascii != NULL) CLOSE (isgz_ascii,fd_ascii);

	return code;

}

/*---------------------------------------------------------------------------*/
int TARANIS_ASCII_OUTPUT_X_Y_AUTO_GLUE (
/*---------------------------------------------------------------------------*/
	void	*p01,
	void	*p02,
	void	*p03,
	void	*p_filename_ascii) {

	int		argc=4;
	void		*argv[4];
	int		code;
	IDL_STRING	*filename_ascii;

	// p_filename_ascii -> filename_ascii
	filename_ascii = malloc (sizeof(IDL_STRING));
	IDL_StrStore (filename_ascii, p_filename_ascii);

	argv[0] = p01;
	argv[1] = p02;
	argv[2] = p03;
	argv[3] = filename_ascii;
	code = TARANIS_ASCII_OUTPUT_X_Y (argc, argv);

	free (filename_ascii);

	return code;

}

/*---------------------------------------------------------------------------*/
int TARANIS_SEARCH_LIST_ORBIT (int argc, void *argv[]) {
/*---------------------------------------------------------------------------*/

	int		nbarg			=	0;
	IDL_STRING	*nom			=	(IDL_STRING *)		argv[nbarg++];
	int		taille			=	*(int *)		argv[nbarg++];	/* nombre d'octets dans le fichier d'un enregisterment */
	int		nb			=	*(int *)		argv[nbarg++];	/* lire nb enregistrements */
	int		offset_orbit		=	*(int *)		argv[nbarg++];
	int		valeur			=	*(int *)		argv[nbarg++]; // Valeur  chercher
	int		*no1			=	(int *)			argv[nbarg++]; // valeur  renvoyer
	int		*no2			=	(int *)			argv[nbarg++]; // valeur  renvoyer

	/*
	Valeur de retour:
		 1:	OK
		-1:	erreur lors de l'ouverture du fichier
		-2:	erreur lors de la lecture du fichier
	*/

	FILE		*fd=NULL;
	int		i;
	unsigned char	buffer[1024];
	int		isgz;
	int		code=1;
	unsigned int	orbit;

	isgz = ISGZ(IDL_STRING_STR(nom));
	if ((fd = OPEN (isgz, IDL_STRING_STR(nom), "rb")) == NULL) {
		code=-1;
		goto EXIT;
	}

	for (i=0; i<nb; i++) {

		if (READ (isgz, fd, buffer, taille) != taille) {
			code = -2;
			goto EXIT;
		}

		orbit = * (int *) (buffer + offset_orbit);
		if (orbit < valeur) {
		} else if (orbit == valeur) {
			if (*no1==-1) *no1 = i;
			*no2 = i;
		} else {
			if (*no1!=-1) break;
		}

	}

EXIT:

	if (fd != NULL) CLOSE (isgz, fd);

	return code;

}

/*---------------------------------------------------------------------------*/
int TARANIS_SEARCH_LIST_ORBIT_AUTO_GLUE (
/*---------------------------------------------------------------------------*/
	void	*p_nom,
	void	*p02,
	void	*p03,
	void	*p04,
	void	*p05,
	void	*p06,
	void	*p07) {

	int		argc=7;
	void		*argv[7];
	int		code;
	IDL_STRING	*nom;

	// p_nom -> nom
	nom = malloc (sizeof(IDL_STRING));
	IDL_StrStore (nom, p_nom);

	argv[0] = nom;
	argv[1] = p02;
	argv[2] = p03;
	argv[3] = p04;
	argv[4] = p05;
	argv[5] = p06;
	argv[6] = p07;
	code = TARANIS_SEARCH_LIST_ORBIT (argc, argv);

	free (nom);

	return code;

}

/*---------------------------------------------------------------------------*/
int TARANIS_SEARCH_LIST_DATE1 (int argc, void *argv[]) {
/*---------------------------------------------------------------------------*/

	int		nbarg			=	0;
	IDL_STRING	*nom			=	(IDL_STRING *)		argv[nbarg++];
	int		taille			=	*(int *)		argv[nbarg++];	/* nombre d'octets dans le fichier d'un enregisterment */
	int		nb			=	*(int *)		argv[nbarg++];	/* lire nb enregistrements */
	int		offset_date1		=	*(int *)		argv[nbarg++];
	double		valeur			=	*(double *)		argv[nbarg++]; // Valeur  chercher
	int		*no			=	(int *)			argv[nbarg++]; // valeur  renvoyer

	/*
	Valeur de retour:
		 1:	OK
		-1:	erreur lors de l'ouverture du fichier
		-2:	erreur lors de la lecture du fichier
	*/

	FILE		*fd=NULL;
	int		i;
	unsigned char	buffer[1024];
	int		isgz;
	int		code=1;
	double		date1;

	isgz = ISGZ(IDL_STRING_STR(nom));
	if ((fd = OPEN (isgz, IDL_STRING_STR(nom), "rb")) == NULL) {
		code=-1;
		goto EXIT;
	}

	for (i=0; i<nb; i++) {

		if (READ (isgz, fd, buffer, taille) != taille) {
			code = -2;
			goto EXIT;
		}

		date1 = * (double *) (buffer + offset_date1);
		if (date1 <= valeur) {
			*no = i;
		} else {
			break;
		}

	}

EXIT:

	if (fd != NULL) CLOSE (isgz, fd);

	return code;

}

/*---------------------------------------------------------------------------*/
int TARANIS_SEARCH_LIST_DATE1_AUTO_GLUE (
/*---------------------------------------------------------------------------*/
	void	*p_nom,
	void	*p02,
	void	*p03,
	void	*p04,
	void	*p05,
	void	*p06) {

	int		argc=6;
	void		*argv[6];
	int		code;
	IDL_STRING	*nom;

	// p_nom -> nom
	nom = malloc (sizeof(IDL_STRING));
	IDL_StrStore (nom, p_nom);

	argv[0] = nom;
	argv[1] = p02;
	argv[2] = p03;
	argv[3] = p04;
	argv[4] = p05;
	argv[5] = p06;
	code = TARANIS_SEARCH_LIST_DATE1 (argc, argv);

	free (nom);

	return code;

}
