/*------------------------------------------------------------------------------
 *
 *      Fichier : $RCSfile: conf_borland.c,v $, v $Revision: 1.9 $
 *
 *      Date    : $Date: 2013/02/18 13:53:10 $
 *
 *      Auteur  : $Author: penou $
 *
 *      Version : %Z% version %I% de %M% du %G%
 *
 *------------------------------------------------------------------------------
 */


#include <stdio.h>
#include <string.h>
#include <stdlib.h>
#include <dir.h>

int main (void) {

	FILE    *fd1;
	FILE    *fd2;
	char    ligne[1024];
	char    s1[1024];
	char    s2[1024];
	char    s3[1024];
	int	ok;
	char	*DSP_ROOT="/DATA/DOUBLE_STAR";
	char	chemin[1024];


	fd1 = fopen ("inc/strings_bcc32.h","w");
	/* ---------------------------------- */

	fprintf (fd1,"extern int strcasecmp (char *s1, char *s2);\n");
	fprintf (fd1,"extern int strncasecmp (char *s1, char *s2, int n);\n");

	fclose (fd1);



	fd1 = fopen ("src/strings_bcc32.c","w");
	/* ---------------------------------- */

	fprintf (fd1,"#include <string.h>\n");
	fprintf (fd1,"#include <stdio.h>\n");
	fprintf (fd1,"#include <stdlib.h>\n");
	fprintf (fd1,"/*---------------------------------------------------------------------------*/\n");
	fprintf (fd1,"int strcasecmp (char *s1, char *s2) {\n");
	fprintf (fd1,"/*---------------------------------------------------------------------------*/\n");
	fprintf (fd1,"char   *s1new;\n");
	fprintf (fd1,"char    *s2new;\n");
	fprintf (fd1,"int     code;\n");
	fprintf (fd1,"s1new = strdup (s1);\n");
	fprintf (fd1,"strupr (s1new);\n");
	fprintf (fd1,"s2new = strdup (s2);\n");
	fprintf (fd1,"strupr (s2new);\n");
	fprintf (fd1,"code = strcmp (s1new, s2new);\n");
	fprintf (fd1,"free (s1new);\n");
	fprintf (fd1,"free (s2new);\n");
	fprintf (fd1,"return code;\n");
	fprintf (fd1,"}\n");
	fprintf (fd1,"/*---------------------------------------------------------------------------*/\n");
	fprintf (fd1,"int strncasecmp (char *s1, char *s2, int n) {\n");
	fprintf (fd1,"/*---------------------------------------------------------------------------*/\n");
	fprintf (fd1,"char    *s1new;\n");
	fprintf (fd1,"char    *s2new;\n");
	fprintf (fd1,"int     code;\n");
	fprintf (fd1,"s1new = strdup (s1);\n");
	fprintf (fd1,"strupr (s1new);\n");
	fprintf (fd1,"s2new = strdup (s2);\n");
	fprintf (fd1,"strupr (s2new);\n");
	fprintf (fd1,"code = strncmp (s1new, s2new, n);\n");
	fprintf (fd1,"free (s1new);\n");
	fprintf (fd1,"free (s2new);\n");
	fprintf (fd1,"return code;\n");
	fprintf (fd1,"}\n");

	fclose (fd1);



	fd1 = fopen ("src/EXTERNAL.c","r");
	/* ----------------------------- */

	fd2 = fopen ("src/EXTERNAL_bcc32.c","w");

	while ( ! feof(fd1) ) {

		if (fgets (ligne, sizeof(ligne), fd1) != NULL) {
			ok = 1;
			if (sscanf (ligne,"%s %s",s1,s2) == 2) {
				if (strcmp(s1,"int")==0 && 
					(strcmp (s2,"CALIB_Init")==0 || strcmp (s2,"CALIB_Lire")==0 || strcmp (s2,"CALIB_Close")==0)) {
					fprintf (fd2,"int _export%s",ligne+3);
					ok=0;
				}
			}
			if (ok==1) 
				fprintf (fd2,"%s",ligne);
		}
	}
	fclose (fd1);
	fclose (fd2);

	fd1 = fopen ("../LIB/src/TIMES.c","r");
	/* -------------------------- */

	fd2 = fopen ("../LIB/src/TIMES_bcc32.c","w");

	while ( ! feof(fd1) ) {

		if (fgets (ligne, sizeof(ligne), fd1) != NULL) {
			if (sscanf (ligne,"%s %s",s1,s2) == 2) {
				if (strcmp(s1,"void")==0 && strcmp(s2,"Get_date_time")==0) fprintf (fd2, "#ifdef XXX\n");
				if (strcmp(s1,"t_err")==0 && strcmp(s2,"Check_date")==0) fprintf (fd2, "#endif\n");
			}
			fprintf (fd2,"%s",ligne);
		}
	}
	fclose (fd1);
	fclose (fd2);

	fd1 = fopen ("../LIB/src/FILES.c","r");
	/* -------------------------- */

	fd2 = fopen ("../LIB/src/FILES_bcc32.c","w");

	while ( ! feof(fd1) ) {

		if (fgets (ligne, sizeof(ligne), fd1) != NULL) {
			if (sscanf (ligne,"%s %s",s1,s2) == 2) {
				if (strcmp(s1,"t_err")==0 && strcmp(s2,"Create_tmp_directory")==0) fprintf (fd2, "#ifdef XXX\n");
				if (strcmp(s1,"FILE")==0 && strcmp(s2,"*")==0) fprintf (fd2, "#endif\n");
			}
			fprintf (fd2,"%s",ligne);
		}
	}
	fclose (fd1);
	fclose (fd2);


	fd1 = fopen ("inc/glob.h","w");
	/* ------------------------- */

	fprintf (fd1, "#define GLOB_DOOFFS (1 << 3)\n");
	fprintf (fd1, "#define GLOB_APPEND (1 << 5)\n");
	fprintf (fd1, "typedef struct {\n");
	fprintf (fd1, "char 	**gl_pathv;\n");
	fprintf (fd1, "int	gl_pathc;\n");
	fprintf (fd1, "int	gl_offs;\n");
	fprintf (fd1, "} glob_t;\n");
	fprintf (fd1, "extern void globfree (glob_t *buffer);\n");
	fprintf (fd1, "extern int glob (char *masque, int flags, int (*errfunc) (const char *, int), glob_t *buffer);\n");

	fclose (fd1);


	fd1 = fopen ("src/glob.c","w");
	/* ------------------------- */

	fprintf (fd1, "#include <stdio.h>\n");
	fprintf (fd1, "#include <stdlib.h>\n");
	fprintf (fd1, "#include <string.h>\n");
	fprintf (fd1, "#include <dir.h>\n");
	fprintf (fd1, "#include \"glob.h\"\n");
	fprintf (fd1, "#define MAX 100\n");
	fprintf (fd1, "char *my_dirname (char *s) {\n");
	fprintf (fd1, "	int	i;\n");
	fprintf (fd1, "	static	char path[1024];\n");
	fprintf (fd1, "	for (i=strlen(s) ; i>=0 ; i--) {\n");
	fprintf (fd1, "		if (s[i]=='/' || s[i]== '\\\\') {\n");
	fprintf (fd1, "			strncpy (path, s, i+1);\n");
	fprintf (fd1, "			path[i+1] = '\\0';\n");
	fprintf (fd1, "			return path;\n");
	fprintf (fd1, "		}\n");
	fprintf (fd1, "	}\n");
	fprintf (fd1, "	path[0] = '\\0';\n");
	fprintf (fd1, "	return path;\n");
	fprintf (fd1, "}\n");
	fprintf (fd1, "void globfree (glob_t *buffer) {\n");
	fprintf (fd1, "	int 	i;\n");
	fprintf (fd1, "	for (i=0 ; i<buffer->gl_pathc ; i++) \n");
	fprintf (fd1, "		free (buffer->gl_pathv[i]);\n");
	fprintf (fd1, "	if (buffer->gl_pathc) free (buffer->gl_pathv);\n");
	fprintf (fd1, "}\n");
	fprintf (fd1, "int glob (char *masque, int flags, int (*errfunc) (const char *, int), glob_t *buffer) {\n");
	fprintf (fd1, "	int	done;\n");
	fprintf (fd1, "	struct ffblk	f;\n");
	fprintf (fd1, "	int	len;\n");
	fprintf (fd1, "	char	*base;\n");
	fprintf (fd1, "	base = my_dirname (masque);\n");
	fprintf (fd1, "	len = strlen(base);\n");
	fprintf (fd1, "	if ((flags & GLOB_APPEND) == 0) {\n");
	fprintf (fd1, "		buffer -> gl_pathc = 0;\n");
	fprintf (fd1, "	}\n");
	fprintf (fd1, "	done = findfirst (masque, &f, 0);\n");
	fprintf (fd1, "	while (!done)  {\n");
	fprintf (fd1, "		if (buffer->gl_pathc == 0) {\n");
	fprintf (fd1, "			buffer -> gl_pathv = (char **) malloc (MAX * sizeof (char **));\n");
	fprintf (fd1, "		} else if ((buffer->gl_pathc % MAX) == 0) {\n");
	fprintf (fd1, "			buffer -> gl_pathv = (char **) realloc (buffer->gl_pathv, (buffer->gl_pathc + MAX) * sizeof (char **));\n");
	fprintf (fd1, "		}\n");
	fprintf (fd1, "		buffer->gl_pathv[buffer->gl_pathc] = (char *) malloc ( 1 + len + strlen(f.ff_name));\n");
	fprintf (fd1, "		sprintf (buffer->gl_pathv[buffer->gl_pathc], \"%%s%%s\",base,f.ff_name);\n");
	fprintf (fd1, "		buffer -> gl_pathc ++;\n");
	fprintf (fd1, "		done = findnext (&f);\n");
	fprintf (fd1, "	}\n");
	fprintf (fd1, "	return 0;\n");
	fprintf (fd1, "}\n");

	fclose (fd1);

	
	/* Partie concernant DSTAR */
	mkdir ("tmp");

	fd1 = fopen ("tmp/inttypes.h","w");
	/* ----------------------------- */

	fprintf (fd1, "typedef unsigned char uint8_t;\n");
	fprintf (fd1, "typedef unsigned short uint16_t;\n");
	fprintf (fd1, "typedef short int16_t;\n");
	fprintf (fd1, "typedef int int32_t;\n");
	fprintf (fd1, "typedef unsigned int uint32_t;\n");

	fclose (fd1);


	fd1 = fopen ("tmp/libgen.h","w");
	/* --------------------------- */

	fprintf (fd1, "#define STDOUT_FILENO 1\n");

	fclose (fd1);


	fd1 = fopen ("tmp/unistd.h","w");
	/* --------------------------- */

	fclose (fd1);


	fd1 = fopen ("tmp/glob.h","w");
	/* ------------------------- */

	fprintf (fd1, "#define GLOB_DOOFFS (1 << 3)\n");
	fprintf (fd1, "#define GLOB_APPEND (1 << 5)\n");
	fprintf (fd1, "typedef struct {\n");
	fprintf (fd1, "char 	**gl_pathv;\n");
	fprintf (fd1, "int	gl_pathc;\n");
	fprintf (fd1, "int	gl_offs;\n");
	fprintf (fd1, "} glob_t;\n");
	fprintf (fd1, "extern void globfree (glob_t *buffer);\n");
	fprintf (fd1, "extern int glob (char *masque, int flags, int (*errfunc) (const char *, int), glob_t *buffer);\n");

	fclose (fd1);


	fd1 = fopen ("tmp/glob.c","w");
	/* ------------------------- */

	fprintf (fd1, "#include <stdio.h>\n");
	fprintf (fd1, "#include <stdlib.h>\n");
	fprintf (fd1, "#include <string.h>\n");
	fprintf (fd1, "#include <dir.h>\n");
	fprintf (fd1, "#include \"glob.h\"\n");
	fprintf (fd1, "#define MAX 100\n");
	fprintf (fd1, "char *my_dirname (char *s) {\n");
	fprintf (fd1, "	int	i;\n");
	fprintf (fd1, "	static	char path[1024];\n");
	fprintf (fd1, "	for (i=strlen(s) ; i>=0 ; i--) {\n");
	fprintf (fd1, "		if (s[i]=='/' || s[i]== '\\\\') {\n");
	fprintf (fd1, "			strncpy (path, s, i+1);\n");
	fprintf (fd1, "			path[i+1] = '\\0';\n");
	fprintf (fd1, "			return path;\n");
	fprintf (fd1, "		}\n");
	fprintf (fd1, "	}\n");
	fprintf (fd1, "	path[0] = '\\0';\n");
	fprintf (fd1, "	return path;\n");
	fprintf (fd1, "}\n");
	fprintf (fd1, "void globfree (glob_t *buffer) {\n");
	fprintf (fd1, "	int 	i;\n");
	fprintf (fd1, "	for (i=0 ; i<buffer->gl_pathc ; i++) \n");
	fprintf (fd1, "		free (buffer->gl_pathv[i]);\n");
	fprintf (fd1, "	if (buffer->gl_pathc) free (buffer->gl_pathv);\n");
	fprintf (fd1, "}\n");
	fprintf (fd1, "int glob (char *masque, int flags, int (*errfunc) (const char *, int), glob_t *buffer) {\n");
	fprintf (fd1, "	int	done;\n");
	fprintf (fd1, "	struct ffblk	f;\n");
	fprintf (fd1, "	int	len;\n");
	fprintf (fd1, "	char	*base;\n");
	fprintf (fd1, "	base = my_dirname (masque);\n");
	fprintf (fd1, "	len = strlen(base);\n");
	fprintf (fd1, "	if ((flags & GLOB_APPEND) == 0) {\n");
	fprintf (fd1, "		buffer -> gl_pathc = 0;\n");
	fprintf (fd1, "	}\n");
	fprintf (fd1, "	done = findfirst (masque, &f, 0);\n");
	fprintf (fd1, "	while (!done)  {\n");
	fprintf (fd1, "		if (buffer->gl_pathc == 0) {\n");
	fprintf (fd1, "			buffer -> gl_pathv = (char **) malloc (MAX * sizeof (char **));\n");
	fprintf (fd1, "		} else if ((buffer->gl_pathc % MAX) == 0) {\n");
	fprintf (fd1, "			buffer -> gl_pathv = (char **) realloc (buffer->gl_pathv, (buffer->gl_pathc + MAX) * sizeof (char **));\n");
	fprintf (fd1, "		}\n");
	fprintf (fd1, "		buffer->gl_pathv[buffer->gl_pathc] = (char *) malloc ( 1 + len + strlen(f.ff_name));\n");
	fprintf (fd1, "		sprintf (buffer->gl_pathv[buffer->gl_pathc], \"%%s%%s\",base,f.ff_name);\n");
	fprintf (fd1, "		buffer -> gl_pathc ++;\n");
	fprintf (fd1, "		done = findnext (&f);\n");
	fprintf (fd1, "	}\n");
	fprintf (fd1, "	return 0;\n");
	fprintf (fd1, "}\n");

	fclose (fd1);

	fd1 = fopen ("tmp/strings_bcc32.h","w");
	/* ---------------------------------- */

	fprintf (fd1,"extern int strcasecmp (char *s1, char *s2);\n");
	fprintf (fd1,"extern int strncasecmp (char *s1, char *s2, int n);\n");

	fclose (fd1);



	fd1 = fopen ("tmp/strings_bcc32.c","w");
	/* ---------------------------------- */

	fprintf (fd1,"#include <string.h>\n");
	fprintf (fd1,"#include <stdio.h>\n");
	fprintf (fd1,"#include <stdlib.h>\n");
	fprintf (fd1,"/*---------------------------------------------------------------------------*/\n");
	fprintf (fd1,"int strcasecmp (char *s1, char *s2) {\n");
	fprintf (fd1,"/*---------------------------------------------------------------------------*/\n");
	fprintf (fd1,"char   *s1new;\n");
	fprintf (fd1,"char    *s2new;\n");
	fprintf (fd1,"int     code;\n");
	fprintf (fd1,"s1new = strdup (s1);\n");
	fprintf (fd1,"strupr (s1new);\n");
	fprintf (fd1,"s2new = strdup (s2);\n");
	fprintf (fd1,"strupr (s2new);\n");
	fprintf (fd1,"code = strcmp (s1new, s2new);\n");
	fprintf (fd1,"free (s1new);\n");
	fprintf (fd1,"free (s2new);\n");
	fprintf (fd1,"return code;\n");
	fprintf (fd1,"}\n");
	fprintf (fd1,"/*---------------------------------------------------------------------------*/\n");
	fprintf (fd1,"int strncasecmp (char *s1, char *s2, int n) {\n");
	fprintf (fd1,"/*---------------------------------------------------------------------------*/\n");
	fprintf (fd1,"char    *s1new;\n");
	fprintf (fd1,"char    *s2new;\n");
	fprintf (fd1,"int     code;\n");
	fprintf (fd1,"s1new = strdup (s1);\n");
	fprintf (fd1,"strupr (s1new);\n");
	fprintf (fd1,"s2new = strdup (s2);\n");
	fprintf (fd1,"strupr (s2new);\n");
	fprintf (fd1,"code = strncmp (s1new, s2new, n);\n");
	fprintf (fd1,"free (s1new);\n");
	fprintf (fd1,"free (s2new);\n");
	fprintf (fd1,"return code;\n");
	fprintf (fd1,"}\n");

	fclose (fd1);

	fd1 = fopen ("tmp/types.h","w");
	/* -------------------------- */

	fprintf (fd1, "typedef unsigned char uint8_t;\n");
	fprintf (fd1, "typedef unsigned short uint16_t;\n");
	fprintf (fd1, "typedef short int16_t;\n");
	fprintf (fd1, "typedef int int32_t;\n");

	fclose (fd1);



	sprintf (chemin,"%s/SOFT/CALIB/src/CALIB.c",DSP_ROOT);
	fd1 = fopen (chemin,"r");
	/* ------------------ */

	fd2 = fopen ("tmp/CALIB.c","w");

	while ( ! feof(fd1) ) {

		if (fgets (ligne, sizeof(ligne), fd1) != NULL) {
			ok = 1;
			if (sscanf (ligne,"%s %s %s",s1,s2,s3) == 3) {
				if (strcmp(s1,"static")==0 && strcmp(s2,"int")==0 && strcmp(s3,"Compare")==0) {
					fprintf (fd2,"static int cdecl %s\n",ligne+12);
					ok=0;
				}
			}
			if (ok==1) 
				fprintf (fd2,"%s",ligne);
		}
	}
	fclose (fd1);
	fclose (fd2);


	sprintf (chemin,"%s/SOFT/CALIB/src/EXTERNAL.c",DSP_ROOT);
	fd1 = fopen (chemin,"r");
	/* ------------------- */

	fd2 = fopen ("tmp/EXTERNAL.c","w");

	while ( ! feof(fd1) ) {

		if (fgets (ligne, sizeof(ligne), fd1) != NULL) {
			ok = 1;
			if (sscanf (ligne,"%s %s",s1,s2) == 2) {
				if (strcmp(s1,"t_err")==0 && 
					(strcmp (s2,"CALIB_Init")==0 || strcmp (s2,"CALIB_Lire")==0 || strcmp (s2,"CALIB_Close")==0)) {
					fprintf (fd2,"int _export%s",ligne+5);
					ok=0;
				}
			}
			if (ok==1) 
				fprintf (fd2,"%s",ligne);
		}
	}
	fclose (fd1);
	fclose (fd2);


	sprintf (chemin,"%s/SOFT/LIB/src/INTERFACE.c",DSP_ROOT);
	fd1 = fopen (chemin,"r");
	/* ------------------- */

	fd2 = fopen ("tmp/INTERFACE.c","w");

	fprintf (fd2, "#include <borutil.h>\n");
	fprintf (fd2, "#include <io.h>\n");
	fprintf (fd1, "char *dirname (char *s) {\n");
	fprintf (fd1, "	int	i;\n");
	fprintf (fd1, "	static	char path[1024];\n");
	fprintf (fd1, "	for (i=strlen(s) ; i>=0 ; i--) {\n");
	fprintf (fd1, "		if (s[i]=='/' || s[i]== '\\\\') {\n");
	fprintf (fd1, "			strncpy (path, s, i+1);\n");
	fprintf (fd1, "			path[i+1] = '\\0';\n");
	fprintf (fd1, "			return path;\n");
	fprintf (fd1, "		}\n");
	fprintf (fd1, "	}\n");
	fprintf (fd1, "	path[0] = '\\0';\n");
	fprintf (fd1, "	return path;\n");
	fprintf (fd1, "}\n");
	while ( ! feof(fd1) ) {

		if (fgets (ligne, sizeof(ligne), fd1) != NULL) {
			fprintf (fd2,"%s",ligne);
		}
	}
	fclose (fd1);
	fclose (fd2);


	sprintf (chemin,"%s/SOFT/CALIB/src/HIA.c",DSP_ROOT);
	fd1 = fopen (chemin,"r");
	/* ------------------- */

	fd2 = fopen ("tmp/HIA.c","w");

	fprintf (fd2, "#include <strings_bcc32.h>\n");
	while ( ! feof(fd1) ) {

		if (fgets (ligne, sizeof(ligne), fd1) != NULL) {
			fprintf (fd2,"%s",ligne);
		}
	}
	fclose (fd1);
	fclose (fd2);


	sprintf (chemin,"%s/SOFT/LIB/src/TIMES.c",DSP_ROOT);
	fd1 = fopen (chemin,"r");
	/* ------------------- */

	fd2 = fopen ("tmp/TIMES.c","w");

	fprintf (fd2, "#include <strings_bcc32.h>\n");
	while ( ! feof(fd1) ) {

		if (fgets (ligne, sizeof(ligne), fd1) != NULL) {
			fprintf (fd2,"%s",ligne);
		}
	}
	fclose (fd1);
	fclose (fd2);

	return 0;

	

}
