/***************************************************************************************************
 *
 *	Fichier	: $RCSfile: MAIN.c,v $
 *
 *	Version	: $Revision: 1.14 $
 *
 *	Auteur	: $Author: barthe $
 *
 *	Date	: $Date: 2005/11/03 15:03:23 $
 *
 *	==========================================================================================
 *
 *	Module principal du CLL de niveau 3
 */

#define	MODULE_NAME	"MAIN"

#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#include "CISLIB.h"
#include "CONTEXTE.h"
#include "INTERFACE.h"
#include "IDL.h"
#include "ORBITE.h"
#include "JSOC.h"


/*	Variable utilisees pour le traitement des options de la ligne de commande
 */
extern	char *		optarg;
extern	int		optind;
extern	int		optopt;
extern	int		opterr;
static	char *		ifile = NULL;
static	char *		ofile = NULL;


/***************************************************************************************************
 *
 *	Notice utilisation de la commande
 *	---------------------------------
 */
int	Usage (char * commande)
{
	char  *		fonction = FNAME ("Usage");
	int		code = ERR_argument;

	Affiche_erreur (fonction, "Syntaxe : %s [<options>] <sat> F1 F2 F3 F4 F5", commande);
	Affiche_erreur (fonction, "");
	Affiche_erreur (fonction, "<sat>  Numero satellite parmi 1234");
	Affiche_erreur (fonction, "F1     Fichier contenant la liste des fichiers en entree");
	Affiche_erreur (fonction, "F2     Fichier contenant la date de traitement");
	Affiche_erreur (fonction, "F3     Fichier contenant la liste des fichiers en sortie");
	Affiche_erreur (fonction, "F4     Nom repertoire contenant les fichiers temporaires");
	Affiche_erreur (fonction, "F5     Fichier contenant la liste des fichiers generes");
	Affiche_erreur (fonction, "");
	Affiche_erreur (fonction, "Avec <options> parmi :");
	Affiche_erreur (fonction, "");
	Affiche_erreur (fonction, "-i <fichier> Genere la liste des fichiers en entree");
	Affiche_erreur (fonction, "-o <fichier> Genere la liste des fichiers en sortie");
	Affiche_erreur (fonction, "");

EXIT:	return code;
}


/***************************************************************************************************
 *
 *	Traitement des options de la ligne de commande
 *	----------------------------------------------
 */
int	Traite_options (int argc, char ** argv)
{
	char *		fonction = FNAME ("Traite_options");
	int		code = OK;
	char *		syntaxe = "i:o:";
	char		option;

	/*	Inhiber messages d'erreur de getopt
	 */
	opterr = 0;

	while ((option = getopt (argc, argv, syntaxe)) != EOF) {

		switch (option) {

		case 'i' :	ifile = optarg;
				break;
		case 'o' :	ofile = optarg;
				break;
		case '?' :	code = Usage (argv [0]);
				Affiche_erreur (fonction, "Option -%c incorrecte", optopt);
				goto EXIT;
		}
	}

	if (ifile != NULL && ofile != NULL) {

		code = Genere_masques_fichiers (ifile, ofile);
		exit (code);
	}

	if (argc - optind != 6) {

		code = Usage (argv [0]);
		goto EXIT;
	}

EXIT:	return code;
}
	

/***************************************************************************************************
 *
 *	Fonction principale
 *	-------------------
 */
int	main (int argc, char ** argv)
{
	char *		fonction = FNAME ("main");
	int		code = OK;
	int		temp = 0;

	if (Erreur (code = Traite_options (argc, argv))) goto EXIT;

	param.satellite = atoi (argv [optind]);

	if (param.satellite < 1 || param.satellite > 4) {

		Affiche_erreur (fonction, "Numero satellite %d incorrect", param.satellite);
		code = ERR_satellite;
		goto EXIT;
	}

/**	Supprime le 2005-09-07
 *
 *	if (Erreur (code = Verifie_types ())) goto EXIT;
 */

	code = Chargement_parametres (argv [optind+1], argv [optind+2], argv [optind+3], argv [optind+4], argv [optind+5]);

	if (Erreur (code)) goto EXIT;

	if (Erreur (code = Lecture_contexte (Nom_fichier_produit (CONTEXT))))	goto EXIT;

	Set_trace_level (contexte.niveau_trace);


	switch (contexte.site_production) {

	case CTM:	if (Erreur (code = Creation_PPD_file ()))		goto EXIT;

			if (Erreur (code = Creation_fichier_orbite (10)))	code = WARNING;

			if (Erreur (code = Prepare_parametres ())) 		goto EXIT;

			break;

	case CSPI:	if (Erreur (code = Creation_PPD_file ()))		goto EXIT;

			if (Erreur (code = Creation_fichier_orbite (1)))	code = WARNING;

			Affiche_trace (1, fonction, "Pas de generation fichier parametres IDL");

			break;

	case JSOC:	if (Erreur (code = Creation_JSOC_spectro ()))		goto EXIT;

			break;

	default:	Affiche_erreur (fonction, "Site de production incorrect : %s", 
				Lib_site (contexte.site_production));
			code = ERROR;
			goto EXIT;
	}

	/*	Sortie si traitement correct
	 */
	temp = Genere_liste_sortie (param.resultat);

	Affiche_trace (1, fonction, "Execution correcte");

	return code;

EXIT:	/*	Sortie sur erreur
	 */
	if (strlen (param.resultat) != 0) temp = Genere_liste_sortie (param.resultat);

	Affiche_erreur (fonction, "Sortie sur erreur");

	return code;
}
