C	====================================================
C
C       Fichier : $RCSfile: LIB_FOR.for,v $ 
C
C	Version	: $Revision: 1.8 $
C
C       Date    : $Date: 2002/07/16 15:48:09 $
C
C       Auteur  : $Author: barthe $
C
C       Version : %Z% version %I% de %M% du %G%
C
C	Regroupement des diverses routines Fortran utilisees
C
C	====================================================


C   =====================================================================
C   Routine permettant d'ouvrir le fichier specifie dans l'unite specifie
C
C   Origine : specifique
C   =====================================================================
C
      SUBROUTINE OPENF (UNIT,FNAME,ERREUR)
C
      INTEGER		UNIT
      CHARACTER*150	FNAME
      INTEGER		ERREUR

C   Ouverture du fichier
C   --------------------
      ERREUR=0
      OPEN (UNIT, FILE=FNAME, STATUS='OLD', ERR=100)
      RETURN

C   Si erreur ouverture fichier
C   ---------------------------
100   ERREUR=1
      RETURN
      END


C   ==================================================
C   Routine permettant de refermer le fichier specifie
C
C   Origine : specifique
C   ==================================================
C
      SUBROUTINE CLOSEF (UNIT)
C
      INTEGER		UNIT

      CLOSE (UNIT)

      RETURN
      END


C   =================================
C   Routine retournant le Julian Day
C
C   Origine : jd2000.for (CDROM ESOC)
C   =================================
C	
      SUBROUTINE JD2000(DAY,JEAR,MONTH,KDAY,JHR,MI,SEC)
C
CP  GIVES THE NEW MOD. JULIAN DAY (MJD=0.0 ON 2000/JAN/1 AT 0:00:00)
CP  FOR INPUT CALENDAR DATES BETWEEN 1950/JAN/1 AND 2099/DEC/31.
C
C   MJD(2000) = MJD(1950) - 18262.0
C
CI  (INT*4) JEAR = YEAR WITH 2 OR 4 DIGITS; 2 DIGITS => 1950 TO 2049
CI  (INT*4) MONTH = MONTH
CI  (INT*4) KDAY = DAY
CI  (INT*4) JHR = HOUR
CI  (INT*4) MI = MINUTE
CI  (REAL*8) SEC = SECOND.
CO  (REAL*8) DAY = MOD. JUL. DAY, REFERRED TO 2000.
C
      IMPLICIT REAL*8(A-H,O-Z)

      JJ = (14 - MONTH)/12
      L = JEAR - JJ - 1900*(JEAR/1900) + 100*(2000/(JEAR+1951))
      DAY = KDAY-36496+(1461*L)/4+(367*(MONTH-2+JJ*12))/12
      DAY = DAY + (DFLOAT((JHR*60 + MI)*60) + SEC)/864.D2

      RETURN
      END

C   ======================================
C   Routine calculant les donnees d'orbite
C
C   Origine : orbit.for (CDROM ESOC)
C   ======================================

      SUBROUTINE ORBIT(DAY,KODE,LFILE,IERROR,NSAT,X,REVNUM)
CP  ORBIT: RETRIEVAL ROUTINE FOR COMPRESSED CLUSTER ORBIT
C
C   INPUT:
CI  DAY (R*8) = MODIFIED JULIAN DAY, FROM 2000, FOR THE STATE VECTOR
CI  KODE (I*4) = NUMBER OF COMPONENTS OF STATE VECTOR = DIM. OF ARRAY
C              X(); = 3 FOR S/C POSITION, = 6 FOR POSITION & VELOCITY
CI  LFILE (I*4) = LOGICAL NUMBER OF INPUT DATA FILE
C   OUTPUT:
CO  IERROR (I*4) = RETURN CODE: 0=NO ERROR, 1='DAY' TOO EARLY, 2=TOO
C            LATE, 3=TIME GAP IN DATA, 4=WRONG VALUE OF 'KODE',
C            5=FILE CONTENT INCONSISTENT, 6=READ ERROR FROM DATA FILE
CO  NSAT (I*4) = SATELLITE NUMBER; 1, 2, 3, 4
CO  X(KODE) (R*8) = SPACECRAFT POSITION, KM (AND VELOCITY, KM/S)
CO  REVNUM (R*8) = REVOLUTION NUMBER
C
CF  READS A SEQUENTIAL FORMATTED FILE WITH LOGICAL NUMBER 'LFILE'
C
      IMPLICIT REAL*8(A-H,O-Z)
      DIMENSION Y(6),COEFF(10,6),X(KODE)
C   INITIALISE FILE NUMBER TO FORCE FILE READING AT FIRST CALL
      DATA MFILE/-9999/
      SAVE
C
C  INITIALISE ERROR CODES
      IERROR = 0
      IF(KODE .LE. 0) GOTO 504
      IF(KODE .GT. 6) GOTO 504
C
C  ALWAYS REWIND IF A NEW FILE NUMBER IS USED
      IF(LFILE .NE. MFILE) GOTO 10
C
C  CHECK IF 'DAY' IS INSIDE LAST READ RECORD BLOCK
      IF(DAY .GT. DAYEND + 1.D-4) GOTO 20
      IF(DAY .GE. DAYBEG - 1.D-4) GOTO 70
C
C  INITIALISE THE READING FROM THE FILE
10    DAYFIR = 99.D9
      DAYLAS = 99.D9
      MFILE = LFILE
      REWIND LFILE
C
20    CONTINUE
C  READ 1ST RECORD IN A BLOCK
      READ(LFILE,41,ERR=506,END=509) NSAT
41    FORMAT(I3)
C  IF: NSTA = A SATELLITE NUMBER; THEN THIS IS 1ST RECORD IN A BLOCK
      IF(NSAT .LE. 0) GOTO 20
      IF(NSAT .GT. 4) GOTO 20
C
C  READ 2ND RECORD IN THE BLOCK
CF  NREC = RECORD IDENTIFICATION, SHALL BE = 200 + NSAT
CF  DAYBEG = BEGIN TIME OF THE RECORD (MJD)
CF  DAYEND = END TIME OF THE RECORD (MJD)
CF  EPOCH = EPOCH OF REFERENCE STATE VECTOR (MJD)
CF  REVEPO = REVOLUTION NUMBER AT EPOCH
CF  SMAXIS = SEMIMAJOR AXIS FOR THE KEPLER ORBIT
CF  OMOTIN = INVERSE MEAN MOTION FOR THE KEPLER ORBIT
      READ(LFILE,42,ERR=506,END=509)
     &NREC,DAYBEG,DAYEND,EPOCH,REVEPO,SMAXIS,OMOTIN
42    FORMAT(I3,2F12.6,F15.9,F11.3,2F13.5)
C  CHECK CONSISTENCY OF FILE
      IF(NREC .NE. 200 + NSAT) GOTO 505
      IF(DAYBEG .GT. DAYEND) GOTO 505
C
C  DAYFIR = START TIME OF 1ST RECORD ON 1ST BLOCK ON THE FILE - MARGIN
      DAYFIR = DMIN1(DAYFIR,DAYBEG - 1.D-4)
C  ERROR RETURN IF 'DAY' IS BEFORE START OF FILE (WITH MARGIN)
      IF(DAY .LT. DAYFIR) GOTO 501
C  ERROR RETURN IF THERE IS A GAP FROM LAST BLOCK (WITH MARGIN)
      IF(DAYBEG .GT. DAYLAS) GOTO 503
C  DAYLAS = END TIME OF LAST READ RECORD BLOCK + MARGIN
      DAYLAS = DAYEND + 2.D-4
C
C  CONTINUE READ IF 'DAY' IS AFTER END OF THIS RECORD BLOCK
      IF(DAY .GT. DAYEND + 1.D-4) GOTO 20
C  REWIND WHEN 'DAY' IS EARLIER THAN START OF PRESENT RECORD BLOCK
      IF(DAY .LT. DAYBEG - 1.D-4) GOTO 10
C
C  READ 3RD RECORD IN THE BLOCK
CF  NREC = RECORD IDENTIFICATION, SHALL BE = 300 + NUMBER OF POL.COEFF.
CF  Y(6) = REFERENCE STATE VECTOR FOR KEPLER ORBIT (KM, KM/S)
CF  RDIST = S/C EARTH CENTRE DISTANCE AT EPOCH
      READ(LFILE,43,ERR=506,END=505) NREC,Y,RDIST
43    FORMAT(I3,3F11.3,3F11.7,F11.3)

C  CHECK CONSISTENCY OF FILE
      IF(NREC .GT. 310) GOTO 505
      IF(NREC .LT. 300) GOTO 505
C   KOEFF = NUMBER OF POLYNOMIAL COEFFICIENTS, BETWEEN 0 AND 10
      KOEFF = NREC - 300
C
C  IF THERE ARE NO COEFFICIENTS IN THIS BLOCK
      IF(KOEFF. LE. 0) GOTO 70
      DO 60 K = 1,KOEFF
CF  NREC = RECORD IDENT. = KOEFF + 11*K
CF  COEFF(10,6) = MATRIX WITH UP TO 10 COEFFICIENTS OF THE CHEBYSHEV
CF  POLYNOMIAL FOR EACH OF THE 6 COMPONENTS OF THE STATE VECTOR
      READ(LFILE,44,ERR=506,END=505) NREC,(COEFF(K,I),I=1,6)
44    FORMAT(I3,3F11.3,3F11.7)
C
C  CHECK CONSISTENCY OF FILE
      IF(11*K + KOEFF .NE. NREC) GOTO 505
60    CONTINUE
C  END OF BLOCK READING SEQUENCE
70    CONTINUE
C
C  TIME CONVERTED TO DIFFERENCE IN MEAN ANOMALY
      DMANOM = (DAY - EPOCH)*864.D2/OMOTIN
C  ORBIT NUMBER
      REVNUM = REVEPO + DMANOM/6.2831853072D0
C
C  START MODELLING KEPLER ORBIT
      ARIN = SMAXIS/RDIST
      ARM = (RDIST - SMAXIS)/SMAXIS
      RVWAM = (Y(1)*Y(4) + Y(2)*Y(5) + Y(3)*Y(6))*OMOTIN/SMAXIS**2
C  CALC. OF ECC. ANOMALY BY NEWTON'S ITERATION
      TAM = DMANOM - RVWAM
      COMP = 1.D-7 + 1.D-10*DABS(TAM)
      B = TAM
C  ITERATIONS TO SOLVE KEPLER'S EQUATION:
      DO 130 ITER = 1,15
      GO = DCOS(B)
      G1 = DSIN(B)
      BET = TAM - ARM*G1 + RVWAM*GO
      D = (BET - B)/(1.D0 + ARM*GO + RVWAM*G1)
      B = B + D
C  THIS GIVES THE ACCURACY  1.D-14 IN B & THE G'S
      IF(DABS(D) .LE. COMP) GOTO 140
130   CONTINUE
C  NO CONVERGENCE, ERROR RETURN
      GOTO 505
140   CONTINUE
      GO = GO - D*G1
      G1 = G1 + D*GO
      G2 = 1.D0 - GO
      G3 = B - G1
      FX = 1.D0  - G2*ARIN
      GX = (DMANOM - G3)*OMOTIN
C
      K = MIN0(KODE,3)
      DO 150 J = 1,K
150   X(J) = FX*Y(J) + GX*Y(J+3)
C
      IF(KODE .LE. 3) GOTO 170
      RX = DSQRT(X(1)**2 + X(2)**2 + X(3)**2)
      FT = -G1*SMAXIS*ARIN/(OMOTIN*RX)
      GT = 1.D0 - G2*SMAXIS/RX
      DO 160 J = 4,KODE
160   X(J) = FT*Y(J-3) + GT*Y(J)
C  END OF MODELLING KEPLER ORBIT
170   CONTINUE
C
C  CHECK IF POLYNOMIAL COEFFICIENTS ARE REQUIRED (1 IS NOT WORTH WHILE)
      IF(KOEFF .LE. 1) GOTO 600
C  MID-POINT & SCALE FACTOR FOR CHEBYSHEV POLYNOMIAL
      DAYMID = 0.5D0*(DAYBEG + DAYEND)
      SCALE = 4.D0/(DAYEND - DAYBEG)
C  ADD CHEBYSHEV POLYNOMIAL TO KEPLER STATE VECTOR
      S = SCALE*(DAY - DAYMID)
      PA = 1.D0
      P = S*0.5D0
C
C  'KODE' = NUMBER OF COMPONENTS OF THE STATE VECTOR
      DO 200 J = 1,KODE
200   X(J) = X(J) + COEFF(1,J) + COEFF(2,J)*P
C
      IF(KOEFF .LE. 2) GOTO 600
      DO 210 L = 3,KOEFF
      PB = PA
      PA = P
      P = S*PA - PB
      DO 210 J = 1,KODE
210   X(J) = X(J) + COEFF(L,J)*P
230   CONTINUE
C
      GOTO 600
C  ERROR RETURNS; IERROR = 5, 6, 4, 3, 2 OR 1
509   CONTINUE
C  END-OF-FILE ONLY IF AT LEAST ONE RECORD HAS BEEN READ
      IF(DAYLAS .LT. 1.D9) GOTO 502
505   IERROR = -1
506   IERROR = IERROR + 2
504   IERROR = IERROR + 1
503   IERROR = IERROR + 1
502   IERROR = IERROR + 1
501   IERROR = IERROR + 1
C  FORCE A RE-INITIALISATION OF READ AT NEXT CALL AFTER AN ERROR
      MFILE = -9999
600   RETURN
      END


C   ===================================================
C   Routine permettant de calculer la direction solaire
C
C   Origine : recupere pour CLUSTER I
C             modifiee pour ajouter le parametre obliq
C   ===================================================
C
      subroutine csundi(iyear,idoty,ihour,imin,isec,
     >                  gst,slong,sra,sdec,obliq)
C
C     compute_sun_direction in GEI system
C
C    (from C.T. Russel,cosmic electro-dynamics,v.2, 184-196, 1971)
C
C     calculates four quantities in gei system necessary for
C     coordinate transformations dependent on sun position
C     (and, hence, on universal time and season)
C
C     input :  iyear : year (1901-2099)
C              idoty : day of the year (1 for january 1)
C              ihour,imin,isec : hours, minutes, seconds U.T.
C
C     output: gst      greenwich mean sideral time (radians)
C             slong    longitude along ecliptic (radians)
C             sra      right ascension (radians)
C             sdec     declination of the sun (radians)
C
C     Ajoute le 16/07/2002 (Alain BARTHE)
C
C             obliq    obliquite du soleil (radians)	
C
C
C
      double precision dj,fday,rad
      data rad/57.2957795130823d0/
C
      if(iyear.lt.1901.or.iyear.gt.2099) then
                           print*,'year must be beetween 1901 and 2099'
                           print*,'error in call csundi'
                           stop 'error csundi'
                                     endif
C
      fday=dble((ihour*3600.+imin*60.+isec)/86400.)
      dj=365*(iyear-1900)+(iyear-1901)/4+idoty-0.5d0+fday
      t=dj/36525.
      vl=dmod(279.696678+0.9856473354*dj,360.d0)
      gst=dmod(279.690983+.9856473354*dj+360.*fday+180.,360.d0)/rad
C
      g=dmod(358.475845+0.985600267*dj,360.d0)/rad
      slong=(vl+(1.91946-0.004789*t)*sin(g)+0.020094*sin(2.*g))/rad
      if(slong.gt.6.2831853) slong=slong-6.2831853
      if(slong.lt.0.)        slong=slong+6.2831853
C
      obliq=(23.45229-0.0130125*t)/rad
      sob=sin(obliq)
      sind=sob*sin(slong-9.924e-5)
      cosd=sqrt(1.-sind**2)
      sc=sind/cosd
      sdec=atan(sc)
      sra=3.141592654-atan2(cos(obliq)/sob*sc,-cos(slong)/cosd)
C
      return
      end

C   =====================================================================
C   Routine permettant de calculer la matrice de precession 2000
C
C   Origine : CDROM ESOC
C   =====================================================================
C
      SUBROUTINE PR2000(DAY,P)
CP  COMPUTES THE PRECESSION MATRIX P(3,3) FOR CONVERTING A VECTOR
C IN MEAN GEOCENTRIC EQUATORIAL SYSTEM OF 2000.0 TO MEAN-OF-DATE.
C REF: THE ASTRONOMICAL ALMANAC 1985 PAGE B18.
C
CINPUT:  DAY = MJD2000 = MOD. JULIAN DAY FOR THE MEAN-OF-DATE SYSTEM
C            = MJD(1950) - 18262.0
C
COUTPUT: P(3,3) = PRECESSION MATRIX FOR THE TRANSFORMATION:
C     R(MEAN-OF-DATE) = P(,)*R(2000)
C
      IMPLICIT REAL*8 (A-H,O-Z)
      DIMENSION P(3,3)
C
C CONVERT TO STANDARD EPOCH J2000.0 = 2000 JAN 1 AT 12:00:00
      T = DAY - 0.5D0
C
C  GZ=GREEK Z(A), ZA=Z(A), TH=THETA, ACCORDING TO THE REFERENCE.
C ORIGINAL, WITH TJC = (DAY-0.5D0)/36525.D0  IN JULIAN CENTURIES:
C     GZ = RAD*TJC*(0.6406161D0 + TJC*(839.D-7 + TJC*5.D-6))
C     ZA = GZ + RAD*TJC*TJC*(2202.D-7 + TJC*1.D-7)
C     TH = RAD*TJC*(0.5567530D0 - TJC*(1185.D-7 + TJC*116.D-7))
C
      GZ = T*(0.3061153D-6 + T*(0.10976D-14 + T*0.179D-20))
      ZA = GZ + T*T*(0.2881D-14 + T*0.358D-22)
      TH = T*(0.2660417D-6 - T*(0.1550D-14 + T*0.41549D-20))
C
      CGZ=DCOS(GZ)
      SGZ=DSIN(GZ)
      CZA=DCOS(ZA)
      SZA=DSIN(ZA)
      CTH=DCOS(TH)
      STH=DSIN(TH)
      P(1,1) = CGZ*CZA*CTH - SGZ*SZA
      P(1,2) = -SGZ*CZA*CTH - CGZ*SZA
      P(1,3) = -CZA*STH
      P(2,1) = CGZ*SZA*CTH + SGZ*CZA
      P(2,2) = -SGZ*SZA*CTH + CGZ*CZA
      P(2,3) = -SZA*STH
      P(3,1) = CGZ*STH
      P(3,2) = -SGZ*STH
      P(3,3) = CTH
      RETURN
      END
