/***************************************************************************************************
 *
 *	Fichier	: $RCSfile: IDL.c,v $
 *
 *	Version	: $Revision: 1.14 $
 *
 *	Auteur	: $Author: penou $
 *
 *	Date	: $Date: 2007/07/19 10:35:56 $
 *
 *	==========================================================================================
 *
 *	Ce module a pour but la preparation d'un fichier de parametres
 *	que l'on fournira a l'application IDL
 */

#define	MODULE_NAME	"IDL"

#include "CISLIB.h"
#include "INTERFACE.h"
#include "CONTEXTE.h"
#include "IDL.h"

#define	PARAM_FILE	"Parametres_IDL"		/* Cle de creation du fichier de parametres	*/

#define	PPD_FMT1	"R %d %lf %*d %*d %*d %*d %f %f %f %f %f %f %f %f %f %f %f %f %f %f %f"
#define	PPD_FMT2	"%% SW : %f %f %f %f"

#define	M_Hp		1.6726E-27			/* Masse H+ en Kg				*/
#define	M_Hepp		6.6951E-27			/* Masse He++ en Kg				*/


/***************************************************************************************************
 *
 *	Creation du fichier PPD binaire a partir du PPD Flat File
 *	---------------------------------------------------------
 */
int	Creation_PPD_file (void)
{
	char *		fonction = FNAME ("Creation_PPD_file");
	int		code = OK;
	FILE *		entree = NULL;
	FILE *		sortie = NULL;
	char		buffer [300];
	int		stat, lus, numero, nbre_record;
	double		time_ms;
	float		dens [6], velo [9], temp [4], pkin;

	if ((entree = Ouverture_produit (PPD, "rt")) == NULL) {

		Affiche_erreur (fonction, "Ouverture fichier PPD flat file impossible");
		code = ERR_fopen;
		goto EXIT;
	}

	if (contexte.site_production == CSPI) 
		sortie = Ouverture_produit (PPD_BIN, "w");
	else	sortie = Ouverture_fichier_temporaire ("PPD", "w");

	if (sortie == NULL) {

		Affiche_erreur (fonction, "Creation fichier PPD impossible");
		code = ERR_fopen;
		goto EXIT;
	}

	Affiche_trace (1, fonction, "Creation fichier PPD");

	nbre_record = 0;

	stat = Read_line (buffer, entree);

	while (stat == OK) {

		if (buffer [0] != 'R') {

			stat = Read_line (buffer, entree);
			continue;
		}

		lus = sscanf (buffer, PPD_FMT1, 
			& numero, & time_ms,
			& dens [0], & dens [1], & dens [2], & dens [3], & dens [4], 
			& velo [0], & velo [1], & velo [2], & velo [3], & velo [4], & velo [5], 
			& temp [0], & temp [1], & temp [2], & temp [3]);

		if (lus == 17) {

			/*	Lire la seconde ligne, qui contient eventuellement les donnees He ++
			 */
			stat = Read_line (buffer, entree);
			
			lus = sscanf (buffer, PPD_FMT2, & dens [5], & velo [6], & velo [7], & velo [8]);

			if (lus == 4) {

				stat = Read_line (buffer, entree);
			}
			else {	dens [5] = FILL_VALUE;
				velo [6] = FILL_VALUE;	
				velo [7] = FILL_VALUE;	
				velo [8] = FILL_VALUE;	
			}
			nbre_record ++;

			/*	Calcul de la pression cinetique HIA
			 */
			pkin = 0.0;

			if (! (Filaire (dens [4]) || Filaire (velo [3]) || Filaire (velo [4]) || Filaire (velo [5])))
				pkin += dens [4] * M_Hp * 
					(velo [3] * velo [3] + velo [4] * velo [4] + velo [5] * velo [5]);

			if (! (Filaire (dens [5]) || Filaire (velo [6]) || Filaire (velo [7]) || Filaire (velo [8])))
				pkin += dens [5] * M_Hepp * 
					(velo [6] * velo [6] + velo [7] * velo [7] + velo [8] * velo [8]);

			if (pkin != 0.0)
				pkin = 0.5 * pkin * 1e12 *1e9;
			else	pkin = FILL_VALUE;

			Affiche_trace (3, fonction, "H+    % 1.4e  % 1.4e  % 1.4e  % 1.4e",
				dens [4], velo [3], velo [4], velo [5]);

			Affiche_trace (3, fonction, "He++  % 1.4e  % 1.4e  % 1.4e  % 1.4e",
				dens [5], velo [6], velo [7], velo [8]);

			Affiche_trace (3, fonction, "Pkin  % 1.4e", pkin);

			
			/*	Conversion necessaire en nombre de milli secondes depuis 1958
			 */
			time_ms = Epoch_time_to_milli (time_ms);
				
			fwrite (& time_ms, sizeof (double), 1, sortie);
			fwrite (& dens,    sizeof (float),  6, sortie);
			fwrite (& velo,    sizeof (float),  9, sortie);
			fwrite (& temp,    sizeof (float),  4, sortie);
			fwrite (& pkin,    sizeof (float),  1, sortie);
		}
	}
	Affiche_trace (1, fonction, "Nombre enregistrements : %d", nbre_record);

EXIT:	if (entree != NULL) fclose (entree);
	if (sortie != NULL) fclose (sortie);

	return code;
}


/***************************************************************************************************
 *
 *	Prepare le fichier de parametres que l'on fournira a IDL
 *	--------------------------------------------------------
 */
int	Prepare_parametres (void)
{
	char *		fonction = FNAME ("Prepare_parametres");
	int		code = OK;
	FILE *		sortie = NULL;

	Affiche_trace (1, fonction, "Cle = %s", PARAM_FILE);
	
	if ((sortie = Ouverture_fichier_temporaire (PARAM_FILE, "wt")) == NULL) {

		Affiche_erreur (fonction, "Creation fichier parametres impossible");
		code = ERR_fopen;
		goto EXIT;
	}

	fprintf (sortie, "Satellite    = %d\n", param.satellite);
	fprintf (sortie, "Annee        = %04d\n", param.annee);
	fprintf (sortie, "Mois         = %02d\n", param.mois);
	fprintf (sortie, "Jour         = %02d\n", param.jour);
	fprintf (sortie, "Site         = %s\n", Lib_site (contexte.site_production));
	fprintf (sortie, "Niveau_trace = %d\n", Get_trace_level());

	fprintf (sortie, "PPD_file     = %s\n", Nom_fichier_temporaire ("PPD"));
	fprintf (sortie, "ORBIT_file   = %s\n", Nom_fichier_temporaire ("ORBIT"));

	fprintf (sortie, "COD_12       = %s\n", Nom_fichier_produit (COD_12));
	fprintf (sortie, "COD_13       = %s\n", Nom_fichier_produit (COD_13));
	fprintf (sortie, "COD_15       = %s\n", Nom_fichier_produit (COD_15));
	fprintf (sortie, "COD_16       = %s\n", Nom_fichier_produit (COD_16));
	fprintf (sortie, "COD_17       = %s\n", Nom_fichier_produit (COD_17));
	fprintf (sortie, "COD_18       = %s\n", Nom_fichier_produit (COD_18));
	fprintf (sortie, "COD_19       = %s\n", Nom_fichier_produit (COD_19));
	fprintf (sortie, "COD_20       = %s\n", Nom_fichier_produit (COD_20));
	fprintf (sortie, "COD_21       = %s\n", Nom_fichier_produit (COD_21));
	fprintf (sortie, "COD_22       = %s\n", Nom_fichier_produit (COD_22));
	fprintf (sortie, "COD_29       = %s\n", Nom_fichier_produit (COD_29));
	fprintf (sortie, "COD_47       = %s\n", Nom_fichier_produit (COD_47));
	fprintf (sortie, "COD_49       = %s\n", Nom_fichier_produit (COD_49));

	fprintf (sortie, "HIA_05       = %s\n", Nom_fichier_produit (HIA_05));
	fprintf (sortie, "HIA_06       = %s\n", Nom_fichier_produit (HIA_06));
	fprintf (sortie, "HIA_08       = %s\n", Nom_fichier_produit (HIA_08));
	fprintf (sortie, "HIA_10       = %s\n", Nom_fichier_produit (HIA_10));
	fprintf (sortie, "HIA_14       = %s\n", Nom_fichier_produit (HIA_14));
	fprintf (sortie, "HIA_15       = %s\n", Nom_fichier_produit (HIA_15));
	fprintf (sortie, "HIA_16       = %s\n", Nom_fichier_produit (HIA_16));
	fprintf (sortie, "HIA_17       = %s\n", Nom_fichier_produit (HIA_17));
	fprintf (sortie, "HIA_21       = %s\n", Nom_fichier_produit (HIA_21));
	fprintf (sortie, "HIA_22       = %s\n", Nom_fichier_produit (HIA_22));
	fprintf (sortie, "HIA_23       = %s\n", Nom_fichier_produit (HIA_23));
	fprintf (sortie, "HIA_24       = %s\n", Nom_fichier_produit (HIA_24));

	fprintf (sortie, "COD_SPECTRO  = %s\n", Nom_fichier_produit (COD_SPECTRO));
	fprintf (sortie, "HIA_SPECTRO  = %s\n", Nom_fichier_produit (HIA_SPECTRO));

EXIT:	if (sortie != NULL) fclose (sortie);

	return code;
}
