/***************************************************************************************************
 *
 *	Fichier	: $RCSfile: EXTERNAL.c,v $
 *
 *	Version	: $Revision: 1.16 $
 *
 *	Auteur	: $Author: penou $
 *
 *	Date	: $Date: 2007/07/27 13:11:21 $
 *
 *	==========================================================================================
 *
 *	Interface IDL - C pour l'acces aux calibrations
 *
 *	NORMALEMENT CE FICHIER DOIT ETRE SUPPRIME DE CET EMPLACEMENT
 *
 *	IL SERA NORMALEMENT SOUS EXTERNAL/src
 */

#define	MODULE_NAME	"EXTERNAL"

#include "CISLIB.h"
#include "CATALOG.h"
#include "CALIB.h"
#include "export.h"

static	IDL_MEMINT	dimension [IDL_MAX_ARRAY_DIM];


/***************************************************************************************************
 *
 *	Importe l'ordre des masses CODIF vers IDL
 *	-----------------------------------------
 */
int	Import_MASS (void)
{
	char *		fonction = FNAME ("Import_MASS");
	int		code = OK;

	dimension [0] = NB_MASSE_COD_07;

	IDL_ImportNamedArray ("k_position", 
		1, dimension, IDL_TYP_LONG, (UCHAR *) k_position, NULL, NULL);

EXIT:	return code;
}


/***************************************************************************************************
 *
 *	Importe les calibrations des moments vers IDL
 *	---------------------------------------------
 */
int	Import_moments (void)
{
	char *		fonction = FNAME ("Import_P07");
	int		code = OK;

	dimension [0] = 2;
	dimension [1] = NB_ENERGIE;
	dimension [2] = NB_SENSITIVITE;
	dimension [3] = NB_MASSE_MAX;
	
	IDL_ImportNamedArray ("k_densite", 
		4, dimension, IDL_TYP_FLOAT, (UCHAR *) k_densite, NULL, NULL);
	
	dimension [0] = 2;
	dimension [1] = 3;
	dimension [2] = NB_ENERGIE;
	dimension [3] = NB_SENSITIVITE;
	dimension [4] = NB_MASSE_MAX;

	IDL_ImportNamedArray ("k_vitesse", 
		5, dimension, IDL_TYP_FLOAT, (UCHAR *) k_vitesse, NULL, NULL);
	
	dimension [0] = 2;
	dimension [1] = 6;
	dimension [2] = NB_ENERGIE;
	dimension [3] = NB_SENSITIVITE;
	dimension [4] = NB_MASSE_MAX;

	IDL_ImportNamedArray ("k_pression", 
		5, dimension, IDL_TYP_FLOAT, (UCHAR *) k_pression, NULL, NULL);
	
EXIT:	return code;
}


/***************************************************************************************************
 *
 *	Importe les coefficients du produit CIS1 vers IDL
 *	-------------------------------------------------
 */
int	Import_CIS1 (void)
{
	char *		fonction = FNAME ("Import_CIS");
	int		code = OK;

	dimension [0] = NB_CIS_MODE;
	dimension [1] = 64;
	dimension [2] = NB_TLM_RATE + 1;

	IDL_ImportNamedArray ("cis1_accumulation_spin", 
		3, dimension, IDL_TYP_LONG, (UCHAR *) cis1_accumulation_spin, NULL, NULL);

	dimension [0] = 8;
	dimension [1] = NB_ANODE_CIS1;
	dimension [2] = NB_SENSITIVITE;

	IDL_ImportNamedArray ("cis1_geom_factor", 
		3, dimension, IDL_TYP_FLOAT, (UCHAR *) cis1_geom_factor, NULL, NULL);

	dimension [0] = 8;
	dimension [1] = NB_ANODE_CIS1;
	dimension [2] = NB_SENSITIVITE;

	IDL_ImportNamedArray ("cis1_rpa_geom_factor", 
		3, dimension, IDL_TYP_FLOAT, (UCHAR *) cis1_rpa_geom_factor, NULL, NULL);

	dimension [0] = 3;

	IDL_ImportNamedArray ("cis1_anal_k_factor", 
		1, dimension, IDL_TYP_FLOAT, (UCHAR *) cis1_anal_k_factor, NULL, NULL);

	dimension [0] = NB_SENSITIVITE;

	IDL_ImportNamedArray ("cis1_anal_alpha_angle", 
		1, dimension, IDL_TYP_FLOAT, (UCHAR *) cis1_anal_alpha_angle, NULL, NULL);

	dimension [0] = 1;

	IDL_ImportNamedArray ("cis1_post_accel_volt",
		1, dimension, IDL_TYP_FLOAT, (UCHAR *) & cis1_post_accel_volt, NULL, NULL);

	dimension [0] = 2;

	IDL_ImportNamedArray ("cis1_dead_times",
		1, dimension, IDL_TYP_FLOAT, (UCHAR *) cis1_dead_times, NULL, NULL);

	dimension [0] = NB_MASSE_MAX;
	dimension [1] = NB_DEGRE;
	dimension [2] = NB_ANODE_CIS1;
	dimension [3] = NB_SENSITIVITE;

	IDL_ImportNamedArray ("cis1_anode_eff",
		4, dimension, IDL_TYP_FLOAT, (UCHAR *) cis1_anode_eff, NULL, NULL);

	dimension [0] = 2;
	dimension [1] = 3;
	dimension [2] = 2;

	IDL_ImportNamedArray ("cis1_dens_corr_coeff_P7",
		3, dimension, IDL_TYP_FLOAT, (UCHAR *) cis1_dens_corr_coeff_P7, NULL, NULL);

	dimension [0] = 2;
	dimension [1] = 3;
	dimension [2] = 2;

	IDL_ImportNamedArray ("cis1_dens_corr_coeff_P9",
		3, dimension, IDL_TYP_FLOAT, (UCHAR *) cis1_dens_corr_coeff_P9, NULL, NULL);

	dimension [0] = 3;
	dimension [1] = 31;
	dimension [2] = 2;

	IDL_ImportNamedArray ("cis1_energy_sweep_table_31",
		3, dimension, IDL_TYP_FLOAT, (UCHAR *) cis1_energy_sweep_table_31, NULL, NULL);

	dimension [0] = 3;
	dimension [1] = 16;
	dimension [2] = 2;

	IDL_ImportNamedArray ("cis1_energy_sweep_table_16",
		3, dimension, IDL_TYP_FLOAT, (UCHAR *) cis1_energy_sweep_table_16, NULL, NULL);

	dimension [0] = 3;
	dimension [1] = 8;
	dimension [2] = 2;

	IDL_ImportNamedArray ("cis1_energy_sweep_table_8",
		3, dimension, IDL_TYP_FLOAT, (UCHAR *) cis1_energy_sweep_table_8, NULL, NULL);

	dimension [0] = 3;
	dimension [1] = 32;

	IDL_ImportNamedArray ("cis1_energy_sweep_table_prom",
		2, dimension, IDL_TYP_FLOAT, (UCHAR *) cis1_energy_sweep_table_prom, NULL, NULL);

	dimension [0] = 3;
	dimension [1] = 16;

	IDL_ImportNamedArray ("cis1_energy_sweep_table_rpa",
		2, dimension, IDL_TYP_FLOAT, (UCHAR *) cis1_energy_sweep_table_rpa, NULL, NULL);

EXIT:	return code;
}


/***************************************************************************************************
 *
 *	Importe les coefficients du produit CIS2 vers IDL
 *	-------------------------------------------------
 */
int	Import_CIS2 (void)
{
	char *		fonction = FNAME ("Import_CIS");
	int		code = OK;

	dimension [0] = NB_CIS_MODE;
	dimension [1] = 64;
	dimension [2] = NB_TLM_RATE + 1;

	IDL_ImportNamedArray ("cis2_accumulation_spin", 
		3, dimension, IDL_TYP_LONG, (UCHAR *) cis2_accumulation_spin, NULL, NULL);

	dimension [0] = NB_SENSITIVITE;

	IDL_ImportNamedArray ("cis2_geom_factor",
		1, dimension, IDL_TYP_FLOAT, (UCHAR *) cis2_geom_factor, NULL, NULL);

	dimension [0] = 3;

	IDL_ImportNamedArray ("cis2_anal_k_factor",
		1, dimension, IDL_TYP_FLOAT, (UCHAR *) cis2_anal_k_factor, NULL, NULL);

	dimension [0] = NB_SENSITIVITE;

	IDL_ImportNamedArray ("cis2_anal_alpha_angle",
		1, dimension, IDL_TYP_FLOAT, (UCHAR *) cis2_anal_alpha_angle, NULL, NULL);

	dimension [0] = 2;
	dimension [1] = NB_ANODE_CIS2;
	dimension [2] = NB_SENSITIVITE;

	IDL_ImportNamedArray ("cis2_anode_eff",
		3, dimension, IDL_TYP_FLOAT, (UCHAR *) cis2_anode_eff, NULL, NULL);

	dimension [0] = 2;

	IDL_ImportNamedArray ("cis2_dead_times",
		1, dimension, IDL_TYP_FLOAT, (UCHAR *) cis2_dead_times, NULL, NULL);

	dimension [0] = NB_SENSITIVITE;

	IDL_ImportNamedArray ("cis2_a",
		1, dimension, IDL_TYP_FLOAT, (UCHAR *) cis2_a, NULL, NULL);

	dimension [0] = NB_SENSITIVITE;

	IDL_ImportNamedArray ("cis2_b",
		1, dimension, IDL_TYP_FLOAT, (UCHAR *) cis2_b, NULL, NULL);

	dimension [0] = NB_SENSITIVITE;

	IDL_ImportNamedArray ("cis2_norm_e",
		1, dimension, IDL_TYP_FLOAT, (UCHAR *) cis2_norm_e, NULL, NULL);

	dimension [0] = NB_SENSITIVITE;

	IDL_ImportNamedArray ("cis2_norm_theta",
		1, dimension, IDL_TYP_FLOAT, (UCHAR *) cis2_norm_theta, NULL, NULL);

	dimension [0] = 5;
	dimension [1] = 3;

	IDL_ImportNamedArray ("cis2_MCP_fitting_param",
		2, dimension, IDL_TYP_FLOAT, (UCHAR *) cis2_MCP_fitting_param, NULL, NULL);

	dimension [0] = 3;
	dimension [1] = 62;
	dimension [2] = 11;

	IDL_ImportNamedArray ("cis2_energy_sweep_table_62",
		3, dimension, IDL_TYP_FLOAT, (UCHAR *) cis2_energy_sweep_table_62, NULL, NULL);

	dimension [0] = 3;
	dimension [1] = 31;
	dimension [2] = 11;

	IDL_ImportNamedArray ("cis2_energy_sweep_table_31",
		3, dimension, IDL_TYP_FLOAT, (UCHAR *) cis2_energy_sweep_table_31, NULL, NULL);

	dimension [0] = 3;
	dimension [1] = 16;
	dimension [2] = 11;

	IDL_ImportNamedArray ("cis2_energy_sweep_table_16",
		3, dimension, IDL_TYP_FLOAT, (UCHAR *) cis2_energy_sweep_table_16, NULL, NULL);

	dimension [0] = 3;
	dimension [1] = 32;

	IDL_ImportNamedArray ("cis2_energy_sweep_table_prom",
		2, dimension, IDL_TYP_FLOAT, (UCHAR *) cis2_energy_sweep_table_prom, NULL, NULL);

EXIT:	return code;
}


/***************************************************************************************************
 *
 *	Importe les coefficients du produit EFF vers IDL
 *	------------------------------------------------
 */
int	Import_EFF (void)
{
	char *		fonction = FNAME ("Import_EFF");
	int		code = OK;

	dimension [0] = 4;
	dimension [1] = 2;

	IDL_ImportNamedArray ("cis1_absolute_efficiencies",
		2, dimension, IDL_TYP_FLOAT, (UCHAR *) cis1_absolute_efficiencies, NULL, NULL);

EXIT:	return code;
}


/***************************************************************************************************
 *
 *	Initialisation des calibrations pour IDL
 *	----------------------------------------
 */
int	CALIB_Init (int argc, void ** argv)
{
	char *		fonction = FNAME ("CALIB_Init");
	int		code = OK;
	int		satellite;
	IDL_STRING *	catalogue;
	int		version;

	if (argc != 3) {

		Affiche_erreur (fonction, "Syntaxe : CALIB_Init <satellite> <catalogue> <version>\n");
		code = ERROR;
		goto EXIT;
	}

	satellite = * (int *)  argv [0];
	catalogue = (IDL_STRING *) argv [1];
	version   = * (int *)  argv [2];
	
	if (catalogue->slen == 0) {

		Affiche_erreur (fonction, "Satellite %d : catalogue calibrations non defini", satellite);
		code = ERROR;
		goto EXIT;
	}

	Affiche_trace (1, fonction, "Satellite = %d", satellite);
	Affiche_trace (1, fonction, "Catalogue = %s", catalogue->s);
	Affiche_trace (1, fonction, "Version   = %d", version);

	code = Ouverture_calibration (satellite, catalogue->s, version);

EXIT:	return code;
}


/***************************************************************************************************
 *
 *	Cloture de l'acces aux calibrations a partir d'IDL
 *	--------------------------------------------------
 */
int	CALIB_Close (int argc, void ** argv)
{
	char *		fonction = FNAME ("CALIB_Close");
	int		code = OK;

	Affiche_trace (1, fonction, "");
	code = Cloture_calibration ();

EXIT:	return code;
}


/***************************************************************************************************
 *
 *	Lecture d'un produit de calibration pour IDL
 *	--------------------------------------------
 */
int	CALIB_Lire (int argc, void ** argv)
{
	char *		fonction = FNAME ("CALIB_Lire");
	int		code = OK;
	double		date, date_deb, date_fin;
	IDL_STRING *	produit;

	if (argc != 3) {

		Affiche_erreur (fonction, "Syntaxe : CALIB_LIRE <produit> <date> <fin_validite>");
		code = ERROR;
		goto EXIT;
	}

	produit = (IDL_STRING *) argv [0];

	date = * (double *) argv [1];

	* (double *) argv [2] = 0.0;

	Affiche_trace (3, fonction, "%-10s %s", produit->s, Milli_to_Ascii_time (date));

	code = Lecture_calibration (produit->s, date);

	if (Erreur (code)) goto EXIT;

	code = Validite_calibration (produit->s, & date_deb, & date_fin);

	if (Erreur (code)) goto EXIT;

	if (strcmp (produit->s, "MASS") == 0)	code = Import_MASS ();
	if (strcmp (produit->s, "P02")  == 0)	code = Import_moments ();
	if (strcmp (produit->s, "P04")  == 0)	code = Import_moments ();
	if (strcmp (produit->s, "P07")  == 0)	code = Import_moments ();
	if (strcmp (produit->s, "P09")  == 0)	code = Import_moments ();
	if (strcmp (produit->s, "CIS1") == 0)	code = Import_CIS1 ();
	if (strcmp (produit->s, "CIS2") == 0)	code = Import_CIS2 ();
	if (strcmp (produit->s, "EFF")  == 0)	code = Import_EFF ();

	* (double *) argv [2] = date_fin;

EXIT:	return code;
}
