/***************************************************************************************************
 *
 *	Fichier	: $RCSfile: ENTETE.c,v $
 *
 *	Version	: $Revision: 1.11 $
 *
 *	Auteur	: $Author: barthe $
 *
 *	Date	: $Date: 2015/05/06 08:38:37 $
 *
 *	==========================================================================================
 *
 *	Ce module est charge de la lecture de l'entete des fichiers de niveau 1
 *
 *	ATTENTION	Ce module est partage par les CLL2 et CLL3
 *
 *	- Auparavant: lien logique dans la base CVS
 *	- Maintenant : deux fichiers separes
 */

#define	MODULE_NAME	"ENTETE"

#include "CISLIB.h"
#include "ENTETE.h"

#ifdef	LOST_PACKET
#define	NB_HEADER_FIELDS	23
#else
#define	NB_HEADER_FIELDS	22
#endif


/***************************************************************************************************
 *
 *	Lecture d'une entete produit sur fichier
 *	----------------------------------------
 */
int	Lecture_entete_produit (t_prod_header * entete, FILE * pf)
{
	char *		fonction = FNAME ("Lecture_entete_produit");
	int		code = OK;
	int		stat = 0;

	stat +=	fread (& entete->indice,		sizeof (WORD), 	1, pf);
	stat +=	fread (& entete->time_in_ms,		sizeof (double),1, pf);
	stat +=	fread (& entete->cis_day,		sizeof (WORD), 	1, pf);
	stat +=	fread (& entete->cis_milli,		sizeof (DWORD),	1, pf);
	stat +=	fread (& entete->cis_micro,		sizeof (WORD), 	1, pf);
	stat +=	fread (& entete->scet_day,		sizeof (WORD), 	1, pf);
	stat +=	fread (& entete->scet_milli,		sizeof (DWORD),	1, pf);
	stat +=	fread (& entete->scet_micro,		sizeof (WORD), 	1, pf);
	stat +=	fread (& entete->spin_frame,		sizeof (WORD), 	1, pf);
	stat +=	fread (& entete->spin_packet,		sizeof (WORD), 	1, pf);
	stat +=	fread (& entete->pspin,			sizeof (float),	1, pf); 
	stat +=	fread (& entete->sp_phase_pulse,	sizeof (WORD), 	1, pf);
	stat +=	fread (& entete->sensitivity,		sizeof (WORD), 	1, pf);
	stat +=	fread (& entete->tlm_rate,		sizeof (WORD),  1, pf);
	stat +=	fread (& entete->op_mode,		sizeof (WORD),  1, pf);
	stat +=	fread (& entete->burst_mode,		sizeof (WORD), 	1, pf);
	stat +=	fread (& entete->produit,		sizeof (WORD), 	1, pf);

#ifdef	LOST_PACKET
	stat += fread (& entete->received,		sizeof (BYTE), 	1, pf);
	stat +=	fread (& entete->change_mode,		sizeof (BYTE), 	1, pf);
#else
	stat +=	fread (& entete->change_mode,		sizeof (WORD), 	1, pf);
#endif
	stat +=	fread (& entete->phase_instr,		sizeof (WORD), 	1, pf);
	stat +=	fread (& entete->instrument,		sizeof (WORD), 	1, pf);
	stat +=	fread (& entete->phase_codif,		sizeof (WORD), 	1, pf);
	stat +=	fread (& entete->taille_produit,	sizeof (WORD),  1, pf);

	if (stat != NB_HEADER_FIELDS) {

		if (stat == 0 && feof (pf)) {

			code = WAR_eof;
		}
		else {	
			Affiche_erreur (fonction, "Lecture de %d champs sur %d", stat, NB_HEADER_FIELDS);
			code = ERR_fread;
		}
	}

EXIT:	return code;
}


/***************************************************************************************************
 *
 *	Affiche entete du produit
 *	-------------------------
 */
int	Affiche_entete_produit (t_prod_header * entete)
{
	char *		fonction = FNAME ("Affiche_entete_produit");
	int		code = OK;

	Affiche_trace (3, fonction, "Time        = %s", 
			Milli_to_Ascii_time_milli (entete->time_in_ms));
	Affiche_trace (3, fonction, "Instrument  = %d", entete->instrument);
	Affiche_trace (3, fonction, "Sensitivity = %d", entete->sensitivity);
	Affiche_trace (3, fonction, "Spin frame  = %d", entete->spin_frame);
	Affiche_trace (3, fonction, "Spin packet = %d", entete->spin_packet);
	Affiche_trace (3, fonction, "Phase instr = %d", entete->phase_instr);
	Affiche_trace (3, fonction, "Op. mode    = %d", entete->op_mode);
	Affiche_trace (3, fonction, "Tlm rate    = %d", entete->tlm_rate);
	Affiche_trace (3, fonction, "Pspin       = %f", entete->pspin);

EXIT:	return code;
}


/***************************************************************************************************
 *
 *	Ecriture entete produit sur fichier
 *	-----------------------------------
 */
int	Ecriture_entete_produit (t_prod_header * entete, FILE * pf)
{
	char *		fonction = FNAME ("Ecriture_entete_produit");
	int		code = OK;
	int		stat = 0;

	stat +=	fwrite (& entete->indice,		sizeof (WORD), 	1, pf);
	stat +=	fwrite (& entete->time_in_ms,		sizeof (double),1, pf);
	stat +=	fwrite (& entete->cis_day,		sizeof (WORD), 	1, pf);
	stat +=	fwrite (& entete->cis_milli,		sizeof (DWORD),	1, pf);
	stat +=	fwrite (& entete->cis_micro,		sizeof (WORD), 	1, pf);
	stat +=	fwrite (& entete->scet_day,		sizeof (WORD), 	1, pf);
	stat +=	fwrite (& entete->scet_milli,		sizeof (DWORD),	1, pf);
	stat +=	fwrite (& entete->scet_micro,		sizeof (WORD), 	1, pf);
	stat +=	fwrite (& entete->spin_frame,		sizeof (WORD), 	1, pf);
	stat +=	fwrite (& entete->spin_packet,		sizeof (WORD), 	1, pf);
	stat +=	fwrite (& entete->pspin,		sizeof (float),	1, pf); 
	stat +=	fwrite (& entete->sp_phase_pulse,	sizeof (WORD), 	1, pf);
	stat +=	fwrite (& entete->sensitivity,		sizeof (WORD), 	1, pf);
	stat +=	fwrite (& entete->tlm_rate,		sizeof (WORD),  1, pf);
	stat +=	fwrite (& entete->op_mode,		sizeof (WORD),  1, pf);
	stat +=	fwrite (& entete->burst_mode,		sizeof (WORD), 	1, pf);
	stat +=	fwrite (& entete->produit,		sizeof (WORD), 	1, pf);

#ifdef	LOST_PACKET
	stat +=	fwrite (& entete->received,		sizeof (BYTE), 	1, pf);
	stat +=	fwrite (& entete->change_mode,		sizeof (BYTE), 	1, pf);
#else
	stat +=	fwrite (& entete->change_mode,		sizeof (WORD), 	1, pf);
#endif

	stat +=	fwrite (& entete->phase_instr,		sizeof (WORD), 	1, pf);
	stat +=	fwrite (& entete->instrument,		sizeof (WORD), 	1, pf);
	stat +=	fwrite (& entete->phase_codif,		sizeof (WORD), 	1, pf);
	stat +=	fwrite (& entete->taille_produit,	sizeof (WORD), 	1, pf);

	if (stat != NB_HEADER_FIELDS) {

		Affiche_erreur (fonction, "Ecriture de %d champs sur %d", stat, NB_HEADER_FIELDS);
		code = ERR_fwrite;
	}

	return code;
}
