/***************************************************************************************************
 *
 *	Fichier	: $RCSfile: DSP_EXTERNAL.c,v $
 *
 *	Version	: $Revision: 1.2 $
 *
 *	Auteur	: $Author: penou $
 *
 *	Date	: $Date: 2021/04/27 09:48:58 $
 *
 *	==========================================================================================
 *
 *	Interface IDL - C pour l'acces aux calibrations
 */

#define	MODULE_NAME	"EXTERNAL"

#include "DSPLIB.h"
#include "CALIB.h"

#ifdef GDL
#include "libgdl.h"
#else
#include "export.h"
#endif

static	IDL_MEMINT	dimension [IDL_MAX_ARRAY_DIM];



/***************************************************************************************************
 *
 *	Importation des calibrations HIA vers IDL
 *	-----------------------------------------
 */
static	t_err	Import_HIA (void)
{
	char *		fonction = FNAME ("Import_HIA");
	t_err		error = OK;

	dimension [0] = NB_DSP_MODE;
	dimension [1] = NB_TLM_PRODUCT;

	IDL_ImportNamedArray ("dsp_spin_accumulation", 
		2, dimension, IDL_TYP_LONG, (UCHAR *) dsp_spin_accumulation, NULL, NULL);

	dimension [0] = NB_SENSITIVITY;
	
	IDL_ImportNamedArray ("dsp_geom_factor", 
		1, dimension, IDL_TYP_FLOAT, (UCHAR *) dsp_geom_factor, NULL, NULL);

	dimension [0] = 3;

	IDL_ImportNamedArray ("dsp_anal_k_factor", 
		1, dimension, IDL_TYP_FLOAT, (UCHAR *) dsp_anal_k_factor, NULL, NULL);

	dimension [0] = NB_SENSITIVITY;

	IDL_ImportNamedArray ("dsp_anal_alpha_angle", 
		1, dimension, IDL_TYP_FLOAT, (UCHAR *) dsp_anal_alpha_angle, NULL, NULL);

	dimension [0] = 2;
	dimension [1] = NB_ANODE;
	dimension [2] = NB_SENSITIVITY;

	IDL_ImportNamedArray ("dsp_anode_eff", 
		3, dimension, IDL_TYP_FLOAT, (UCHAR *) dsp_anode_eff, NULL, NULL);

	dimension [0] = 2;

	IDL_ImportNamedArray ("dsp_dead_times", 
		1, dimension, IDL_TYP_FLOAT, (UCHAR *) dsp_dead_times, NULL, NULL);

	dimension [0] = NB_SENSITIVITY;

	IDL_ImportNamedArray ("dsp_a", 
		1, dimension, IDL_TYP_FLOAT, (UCHAR *) dsp_a, NULL, NULL);

	dimension [0] = NB_SENSITIVITY;

	IDL_ImportNamedArray ("dsp_b", 
		1, dimension, IDL_TYP_FLOAT, (UCHAR *) dsp_b, NULL, NULL);

	dimension [0] = NB_SENSITIVITY;

	IDL_ImportNamedArray ("dsp_norm_e", 
		1, dimension, IDL_TYP_FLOAT, (UCHAR *) dsp_norm_e, NULL, NULL);

	dimension [0] = NB_SENSITIVITY;

	IDL_ImportNamedArray ("dsp_norm_theta", 
		1, dimension, IDL_TYP_FLOAT, (UCHAR *) dsp_norm_theta, NULL, NULL);

	dimension [0] = 5;
	dimension [1] = 3;

	IDL_ImportNamedArray ("dsp_MCP_fitting_param", 
		2, dimension, IDL_TYP_FLOAT, (UCHAR *) dsp_MCP_fitting_param, NULL, NULL);

	dimension [0] = 3;
	dimension [1] = 62;
	dimension [2] = 11;

	IDL_ImportNamedArray ("dsp_energy_sweep_table_62", 
		3, dimension, IDL_TYP_FLOAT, (UCHAR *) dsp_energy_sweep_table_62, NULL, NULL);

	dimension [0] = 3;
	dimension [1] = 31;
	dimension [2] = 11;

	IDL_ImportNamedArray ("dsp_energy_sweep_table_31", 
		3, dimension, IDL_TYP_FLOAT, (UCHAR *) dsp_energy_sweep_table_31, NULL, NULL);

	dimension [0] = 3;
	dimension [1] = 16;
	dimension [2] = 11;

	IDL_ImportNamedArray ("dsp_energy_sweep_table_16", 
		3, dimension, IDL_TYP_FLOAT, (UCHAR *) dsp_energy_sweep_table_16, NULL, NULL);

	dimension [0] = 3;
	dimension [1] = 32;

	IDL_ImportNamedArray ("dsp_energy_sweep_table_prom",
		2, dimension, IDL_TYP_FLOAT, (UCHAR *) dsp_energy_sweep_table_prom, NULL, NULL);

EXIT:	return error;
}


/***************************************************************************************************
 *
 *	Initialisation des calibrations pour IDL
 *	----------------------------------------
 */
t_err	CALIB_Init (void)
{
	char *		fonction = FNAME ("CALIB_Init");
	t_err		error = OK;

	if (Erreur (error = Check_DSP_root ())) goto EXIT;

	Affiche_trace (1, fonction, "");

	error = Open_calib ();

EXIT:	return error;
}

int     CALIB_Init_AUTO_GLUE () {

	return CALIB_Init();

}


/***************************************************************************************************
 *
 *	Cloture de l'acces aux calibrations a partir d'IDL
 *	--------------------------------------------------
 */
t_err	CALIB_Close (void)
{
	char *		fonction = FNAME ("CALIB_Close");
	t_err		error = OK;

	Affiche_trace (1, fonction, "");

	error = Close_calib ();

EXIT:	return error;
}

int	CALIB_Close_AUTO_GLUE () {

	int	argc=0;
	void	*argv[1];

	return CALIB_Close ();

}


/***************************************************************************************************
 *
 *	Lecture d'un produit de calibration pour IDL
 *	--------------------------------------------
 */
t_err	CALIB_Lire (int argc, void ** argv)
{
	char *		fonction = FNAME ("CALIB_Lire");
	t_err		error = OK;
	double		date, end_validity;
	IDL_STRING *	produit;

	#ifdef GDL
	DSP_ENERGY_SWEEP_TABLE_62		= (char *) argv[3];
	DSP_ENERGY_SWEEP_TABLE_31		= (char *) argv[4];
	DSP_ENERGY_SWEEP_TABLE_16		= (char *) argv[5];
	DSP_ENERGY_SWEEP_TABLE_PROM		= (char *) argv[6];
	DSP_SPIN_ACCUMULATION			= (char *) argv[7];
	DSP_DEAD_TIMES				= (char *) argv[8];
	DSP_GEOM_FACTOR				= (char *) argv[9];
	DSP_A					= (char *) argv[10];
	DSP_B					= (char *) argv[11];
	DSP_NORM_E				= (char *) argv[12];
	DSP_NORM_THETA				= (char *) argv[13];
	DSP_ANODE_EFF				= (char *) argv[14];
	DSP_MCP_FITTING_PARAM			= (char *) argv[15];
	#else
	if (argc != 3) {

		Affiche_erreur (fonction, "Syntaxe : CALIB_LIRE <produit> <date> <fin_validite>");
		error = ERROR;
		goto EXIT;
	}
	#endif

	produit = (IDL_STRING *) argv [0];

	date = * (double *) argv [1];

	* (double *) argv [2] = 0.0;

	if (Erreur (error = Get_calib (produit->s, date, & end_validity))) goto EXIT;

	if (strcmp (produit->s, "HIA") == 0) error = Import_HIA ();

	* (double *) argv [2] = end_validity;

EXIT:	return error;
}

t_err	CALIB_Lire_AUTO_GLUE (
		void	*p_produit,
		void	*p02,
		void	*p03,
		void	*p04,
		void	*p05,
		void	*p06,
		void	*p07,
		void	*p08,
		void	*p09,
		void	*p10,
		void	*p11,
		void	*p12,
		void	*p13,
		void	*p14,
		void	*p15,
		void	*p16) {

		int		argc=16;
		void		*argv[16];
		int		code;
		IDL_STRING	*produit;

		// p_produit -> produit	
		produit = malloc (1 * sizeof(IDL_STRING));
		IDL_StrStore (produit, p_produit);

		argv[ 0] = produit;
		argv[ 1] = p02;
		argv[ 2] = p03;
		argv[ 3] = p04;
		argv[ 4] = p05;
		argv[ 5] = p06;
		argv[ 6] = p07;
		argv[ 7] = p08;
		argv[ 8] = p09;
		argv[ 9] = p10;
		argv[10] = p11;
		argv[11] = p12;
		argv[12] = p13;
		argv[13] = p14;
		argv[14] = p15;
		argv[15] = p16;
		code = CALIB_Lire (argc, argv);

		free (produit);

		return code;

}


