/***************************************************************************************************
 *
 *	Fichier	: $RCSfile: CONTEXTE.c,v $
 *
 *	Version	: $Revision: 1.7 $
 *
 *	Auteur	: $Author: penou $
 *
 *	Date	: $Date: 2007/07/19 10:35:56 $
 *
 *	==========================================================================================
 *
 *	Ce module permet la lecture des donnees du fichier CONTEXTE
 *
 *	Il cree une variable globale de type structure dont les valeurs influencent 
 *	le deroulement de certains traitement.
 *
 *	ATTENTION	Ce module est partage par les CLL1, CLL2 et CLL3
 */

#define	MODULE_NAME	"CONTEXTE"

#include <strings.h>

#include "CISLIB.h"
#include "INTERFACE.h"
#include "CONTEXTE.h"

t_contexte	contexte;		/* Variable globale contenant les donnees du contexte	*/

static	char *	libelle_site [NB_SITE] = { "CTM", "CSPI", "JSOC" };


/*	Definition des formats de lecture des variables du fichier contexte
 *	-------------------------------------------------------------------
 */
#define	FRM_TRACE	"NIVEAU TRACE%*[ \t]=%s"
#define	FRM_SITE	"SITE PRODUCTION%*[ \t]=%s"
#define	FRM_FGM		"OPTION FGM%*[ \t]=%s"
#define	FRM_SPD		"PRODUCTION SPD%*[ \t]=%s"
#define	FRM_CALIB	"V. CALIBRATION%*[ \t]=%s"
#define	FRM_SOFT	"V. SOFTWARE%*[ \t=]%[^\n]"
#define	FRM_UNIQ	"DATE UNIQUE%*[ \t]=%s"


/***************************************************************************************************
 *
 *	Retourne le code d'un site de production
 *	----------------------------------------
 */
int	Code_site (char * libelle)
{
	int		i;

	for (i=0; i < NB_SITE; i++) if (strcasecmp (libelle_site [i], libelle) == 0) return i;

	return -1;
}


/***************************************************************************************************
 *
 *	Retourne le libelle d'un site de production
 *	-------------------------------------------
 */
char *	Lib_site (t_site code)
{
	return (code >= 0 && code < NB_SITE) ? libelle_site [code] : "INCONNU";
}


/***************************************************************************************************
 *
 *	Affichage des donnees lues dans le fichier contexte
 *	---------------------------------------------------
 */
int	Affiche_contexte ()
{
	char *		fonction = FNAME ("Affiche_contexte");
	int		code = OK;

	Affiche_trace (1, fonction, "Niveau trace       = %d", contexte.niveau_trace);
	Affiche_trace (1, fonction, "Site production    = %s", Lib_site (contexte.site_production));
	Affiche_trace (1, fonction, "Option FGM         = %s", (contexte.option_fgm) ? "YES" : "NO");
	Affiche_trace (1, fonction, "Production SPD     = %d", contexte.production_spd);
	Affiche_trace (1, fonction, "Version calibarion = %d", contexte.version_calibration);
	Affiche_trace (1, fonction, "Version Software   = %s", contexte.software_version);
	Affiche_trace (1, fonction, "Date unique        = %s", (contexte.date_unique) ? "YES" : "NO");
	
	return code;
}


/***************************************************************************************************
 *
 *	Lecture des valeurs definies dans le fichier contexte
 *	-----------------------------------------------------
 */
int	Lecture_contexte (char * fichier)
{
	char *		fonction = FNAME ("Lecture_contexte");
	int		code = OK;
	char		buffer [200], texte [50];
	FILE *		pf = NULL;

	if (fichier == NULL || strlen (fichier) == 0) {

		Affiche_erreur (fonction, "Fichier CONTEXTE inexistant");
		code = ERROR;
		goto EXIT;
	}

	if ((pf = fopen (fichier, "rt")) == NULL) {

		Affiche_erreur (fonction, "Lecture fichier CONTEXTE : %s impossible", fichier);
		code = ERR_fopen;
		goto EXIT;
	}

	Affiche_trace (1, fonction, "%s", fichier);

	contexte.niveau_trace		= 0;	
	contexte.site_production	= -1;	
	contexte.option_fgm		= FALSE;
	contexte.production_spd		= 0;
	contexte.version_calibration	= 0;
	contexte.date_unique		= TRUE;

	strcpy (contexte.software_version, "");

	while (Read_line (buffer, pf) == OK) {

		Affiche_trace (9, fonction, ">>> %s",  buffer);

		if (sscanf (buffer, FRM_TRACE, texte) == 1) 	contexte.niveau_trace = atoi (texte);

		if (sscanf (buffer, FRM_SITE, texte) == 1) 	contexte.site_production = Code_site (texte);

		if (sscanf (buffer, FRM_FGM, texte) == 1) 	contexte.option_fgm = 
								(*texte == 'Y' || *texte == 'y') ? TRUE : FALSE;

		if (sscanf (buffer, FRM_SPD, texte) == 1) 	contexte.production_spd = atoi (texte);

		if (sscanf (buffer, FRM_CALIB, texte) == 1) 	contexte.version_calibration = atoi (texte);

		if (sscanf (buffer, FRM_SOFT, texte) == 1) 	strcpy (contexte.software_version, texte);

		if (sscanf (buffer, FRM_UNIQ, texte) == 1)	contexte.date_unique =
								(*texte == 'Y' || *texte == 'y') ? TRUE : FALSE;
	}

	code = Affiche_contexte ();

EXIT:	if (pf != NULL)	fclose (pf);

	return code;
}
