PRO trace, angles_full, angles

	nbaz = N_ELEMENTS(angles_full[*,0])
	nbel = N_ELEMENTS(angles_full[0,*])
	
	xmin = -30.
	xmax = 45.
	ymin = -30.
	ymax = 45.
	X = [ xmin, xmin, xmax,  xmax, xmin ]
	Y = [ ymin,  ymax, ymax, ymin, ymin ]
	PLOT, X, Y, xrange=[xmin, xmax], yrange=[ymin,ymax], xstyle=1, ystyle=1, xtitle='Az', ytitle='El'

	FOR iaz=0L,nbaz-1 DO BEGIN
		FOR iel=0L,nbel-1 DO BEGIN

			X = [ angles_full[iaz,iel].azmin, angles_full[iaz,iel].azmin, angles_full[iaz,iel].azmax, angles_full[iaz,iel].azmax, angles_full[iaz,iel].azmin ]
			Y = [ angles_full[iaz,iel].elmin, angles_full[iaz,iel].elmax, angles_full[iaz,iel].elmax, angles_full[iaz,iel].elmin, angles_full[iaz,iel].elmin ]

			OPLOT, X, Y, color=2

		END
	END

	FOR iaz=0L,nbaz-1 DO BEGIN
		FOR iel=0L,nbel-1 DO BEGIN

			X = [ angles[iaz,iel].azmin, angles[iaz,iel].azmin, angles[iaz,iel].azmax, angles[iaz,iel].azmax, angles[iaz,iel].azmin ]
			Y = [ angles[iaz,iel].elmin, angles[iaz,iel].elmax, angles[iaz,iel].elmax, angles[iaz,iel].elmin, angles[iaz,iel].elmin ]

			OPLOT, X, Y, color=3, linestyle=2

		END
	END

	tables = REPLICATE (0., nbaz, nbel, nbaz, nbel)

	FOR iaz=0L,nbaz-1 DO BEGIN
		FOR iel=0L,nbel-1 DO BEGIN

			azmin = angles[iaz,iel].azmin
			azmax = angles[iaz,iel].azmax
			elmin = angles[iaz,iel].elmin
			elmax = angles[iaz,iel].elmax

			; Recherche candidats
			ind = WHERE (angles_full.azmax GE azmin AND angles_full.azmin LE azmax AND angles_full.elmax GE elmin AND angles_full.elmin LE elmax)
			IF ind[0] NE -1 THEN BEGIN
				s = ''
				FOR i=0L,N_ELEMENTS(ind)-1 DO BEGIN
					; surface à utiliser ?
					xmin = angles_full[ind[i]].azmin LE azmin ? azmin : angles_full[ind[i]].azmin
					xmax = angles_full[ind[i]].azmax GE azmax ? azmax : angles_full[ind[i]].azmax
					ymin = angles_full[ind[i]].elmin LE elmin ? elmin : angles_full[ind[i]].elmin
					ymax = angles_full[ind[i]].elmax GE elmax ? elmax : angles_full[ind[i]].elmax

					surface_totale = (angles_full[ind[i]].azmax-angles_full[ind[i]].azmin)*(angles_full[ind[i]].elmax-angles_full[ind[i]].elmin)
					surface_utile  = (xmax-xmin) * (ymax-ymin)
					iy = ind[i] / nbaz
					ix = ind[i] - iy*nbaz
				
					IF i NE 0 THEN s += ' + '	
					s += val_to_str(surface_utile/surface_totale) + '*f('+val_to_str(ix)+','+val_to_str(iy)+')'
					tables[iaz,iel,ix,iy] = surface_utile/surface_totale
				END
				PRINT, "f'("+val_to_str(iaz)+','+val_to_str(iel)+'] = '+s
			END
		END
	END

END

PRO solar_pas_lire_angles_full

	; obtenir pour chaque bin (11x9):
	;	- azmin, azmoy, azmax
	;	- elmin, elmoy, elmax

	nbaz = 11
	nbel =  9
	angles_full = REPLICATE ( {azmin: 0., azmoy:0., azmax:0., elmin:0., elmoy:0., elmax:0.}, nbaz, nbel)
	angles      = REPLICATE ( {azmin: 0., azmoy:0., azmax:0., elmin:0., elmoy:0., elmax:0.}, nbaz, nbel)

	ligne = ''

	fichier = 'PAS_PFM_Az_full_array_14_Feb_2020.txt'
	OPENR, fd, fichier, /GET_LUN
	WHILE ~EOF(fd) DO BEGIN
		READF, fd, ligne
		IF STRMID(ligne,0,1) EQ '#' THEN CONTINUE
		tmp = STRSPLIT (ligne, /EXTRACT)
		IF tmp[0] EQ 'Elevation' THEN BEGIN
			el = tmp[2]
		END ELSE BEGIN
			az = tmp[0]
			angles_full[az,el].azmoy = tmp[1]
			angles_full[az,el].azmin = tmp[2]
			angles_full[az,el].azmax = tmp[3]
		END
	END
	FREE_LUN, fd

	fichier = 'PAS_PFM_El_full_array_14_Feb_2020.txt'
	OPENR, fd, fichier, /GET_LUN
	WHILE ~EOF(fd) DO BEGIN
		READF, fd, ligne
		IF STRMID(ligne,0,1) EQ '#' THEN CONTINUE
		tmp = STRSPLIT (ligne, /EXTRACT)
		IF tmp[0] EQ 'Azimuth' THEN BEGIN
			az = tmp[2]
		END ELSE BEGIN
			el = tmp[0]
			angles_full[az,el].elmoy = tmp[1]
			angles_full[az,el].elmin = tmp[2]
			angles_full[az,el].elmax = tmp[3]
		END
	END
	FREE_LUN, fd

	fichier = 'PAS_PFM_El_array_14_Feb_2020.txt'
	OPENR, fd, fichier, /GET_LUN
	WHILE ~EOF(fd) DO BEGIN
		READF, fd, ligne
		IF STRMID(ligne,0,1) EQ '#' THEN CONTINUE
		tmp = STRSPLIT (ligne, /EXTRACT)
		el = tmp[0]
		angles[*,el].elmoy = tmp[1]
		angles[*,el].elmin = tmp[2]
		angles[*,el].elmax = tmp[3]
	END
	FREE_LUN, fd

	fichier = 'PAS_PFM_Az_array_14_Feb_2020.txt'
	OPENR, fd, fichier, /GET_LUN
	WHILE ~EOF(fd) DO BEGIN
		READF, fd, ligne
		IF STRMID(ligne,0,1) EQ '#' THEN CONTINUE
		tmp = STRSPLIT (ligne, /EXTRACT)
		az = tmp[0]
		angles[az,*].azmoy = tmp[1]
		angles[az,*].azmin = tmp[2]
		angles[az,*].azmax = tmp[3]
	END
	FREE_LUN, fd

	WINDOW, XSIZE=1000, YSIZE=1000

	trace, angles_full, angles

	STOP

END
