;-------------------------------------------------------------------------------
FUNCTION taille2val,	$
;-------------------------------------------------------------------------------
	staille	; LINT_PROTOTYPE input
;-------------------------------------------------------------------------------
; Retoune un nombre  partir d'une chaine pouvant contenir les units K, M, G, T.
;-------------------------------------------------------------------------------

	; On peut avoir "48K&nbsp;"

	remplacer, staille, "&nbsp;",""

	len = STRLEN(staille)
	last = STRMID(staille,len-1,1)
	IF last GE '0' AND last LE '9' THEN BEGIN
		val = LONG64(staille)
	END ELSE IF last EQ 'K' THEN BEGIN
		val = LONG64(STRMID(staille,0,len-1)) * LONG64(1024)
	END ELSE IF last EQ 'M' THEN BEGIN
		val = LONG64(STRMID(staille,0,len-1)) * LONG64(1024) * LONG64(1024)
	END ELSE IF last EQ 'G' THEN BEGIN
		val = LONG64(STRMID(staille,0,len-1)) * LONG64(1024) * LONG64(1024) * LONG64(1024)
	END ELSE IF last EQ 'T' THEN BEGIN
		val = LONG64(STRMID(staille,0,len-1)) * LONG64(1024) * LONG64(1024) * LONG64(1024) * LONG64(1024)
	END ELSE IF last EQ '-' THEN BEGIN
		val = 0 ; arrive sur les rpertoires
	END ELSE BEGIN
		val = 'ERROR_'+staille
	END

	RETURN, val
END


;-------------------------------------------------------------------------------
PRO get_listing_distant_recursif,	$
;-------------------------------------------------------------------------------
	httpdir,		$	; LINT_PROTOTYPE input
	http,			$	; LINT_PROTOTYPE input
	local,			$	; LINT_PROTOTYPE input
	ndistant,		$	; LINT_PROTOTYPE input
	ndistant_new,		$	; LINT_PROTOTYPE input
	ndistant_modified,	$	; LINT_PROTOTYPE input
	ndistant_ok,		$	; LINT_PROTOTYPE input
	ndistant_total,		$	; LINT_PROTOTYPE input
	size_new,		$	; LINT_PROTOTYPE input
	size_modified,		$	; LINT_PROTOTYPE input
	size_ok,		$	; LINT_PROTOTYPE input
	size_total,		$	; LINT_PROTOTYPE input
	fd_listing,		$	; LINT_PROTOTYPE input
	fd_new,			$	; LINT_PROTOTYPE input
	fd_modified,		$	; LINT_PROTOTYPE input
	fd_useless,		$	; LINT_PROTOTYPE input
	readonly,		$	; LINT_PROTOTYPE input
	slow,			$	; LINT_PROTOTYPE input
	silence,		$	; LINT_PROTOTYPE input
	nodir,			$	; LINT_PROTOTYPE input
	accept=accept,		$	; LINT_PROTOTYPE input
	reject=reject			; LINT_PROTOTYPE input
;-------------------------------------------------------------------------------
; Traite rcursivement un rpertoire http.
;
;	Entres:
;			http:		rpertoire a lister
;			local:		rpertoire de travail en local
;
;	Sorties:
;			ndistant	nombre de fichiers trouvs
;-------------------------------------------------------------------------------

	COMMON COMMON_CL, general
	tmois = ['', 'JAN', 'FEB', 'MAR', 'APR', 'MAY', 'JUN', 'JUL', 'AUG', 'SEP', 'OCT', 'NOV', 'DEC']

	last = STRMID(http, STRLEN(http)-1, 1)
	IF last EQ '/' THEN BEGIN ; rpertoire

		http1 = STRMID(http, 0, STRLEN(http)-1) ; supprimer le '/'  la fin
		local1 = STRMID(local, 0, STRLEN(local)-1) ; supprimer le '/'  la fin

		; en local
		IF ~readonly THEN mkdir_p, local1 ; indispensable pour que get_http_dir puisse crer les fichiers .remote-index

		code = my_file_info(local1)
		IF ~code.exists THEN BEGIN
			linkslocal = ''
		END ELSE BEGIN
			PUSHD, local1
			linkslocal = FILE_SEARCH() ; liste des fichiers en local
			; rajouter '/' aux rpertoires si ncessaire
			FOR i=0L,N_ELEMENTS(linkslocal)-1 DO BEGIN
				IF linkslocal[i] EQ '' THEN CONTINUE
				IF STRMID(linkslocal[i],STRLEN(linkslocal[i])-1,1) EQ '/' THEN CONTINUE
				IF FILE_TEST (linkslocal[i], /DIRECTORY) THEN linkslocal[i] += '/'
			END
			POPD
		END

		IF ~readonly THEN PRINTF, fd_listing, SYSTIME(0)+ ' *** DIRECTORY *** ' + local
		IF ~readonly THEN FLUSH, fd_listing

		code = get_http_dir (general, http1, readonly ? '/tmp' : local1, links, datelinks=datelinks, taillelinks=taillelinks, /thunderbird, silence=silence)

		IF links[0] NE '' THEN BEGIN
			isdir = REPLICATE (0, N_ELEMENTS(links))
			FOR i=0L, N_ELEMENTS(links)-1 DO BEGIN
				last = STRMID(links[i], STRLEN(links[i])-1, 1)
				isdir[i] = last EQ '/'
			END

			; D'abord les fichiers
			FOR i=0L, N_ELEMENTS(links)-1 DO BEGIN
				IF isdir[i] THEN CONTINUE

				size_total += taille2val(taillelinks[i])
				ndistant_total++

				IF KEYWORD_SET(accept) && STRPOS(http+links[i],accept) EQ -1 THEN CONTINUE
				IF KEYWORD_SET(reject) && STRPOS(http+links[i],reject) NE -1 THEN CONTINUE

				IF slow THEN BEGIN

					code = get_http_file (general, http+links[i], local, /thunderbird, readonly=readonly, silence=silence)

				END ELSE BEGIN

					tmp = STRSPLIT(datelinks[i],' ',/extract)
					tmp1 = STRSPLIT(tmp[0],'-',/extract)

					; Format classque 29-Dec-2015
					jour = tmp1[0]
					mois = WHERE (tmois EQ STRUPCASE(tmp1[1]))
					annee = tmp1[2]

					IF mois EQ -1 THEN BEGIN
						; Format 2015-12-29 ex: sohoww.nascom.nasa.gov/solarsoft/stereo/gen/data/spice/ah/ahead
						annee = tmp1[0]
						mois = tmp1[1]
						jour = tmp1[2]
					END
					

					tmp2 = STRSPLIT(tmp[1],':',/extract)
					heure = tmp2[0]
					minute = tmp2[1]
					date = tu_to_date (annee,mois,jour,heure,minute,0)
					date += 12d*3600d*1000d ; rajout de 1/2 jour afin de regler les problmes de fuseaux horaires entre date et date_local
					ndistant++
					tmp = my_file_info (local+links[i])
					date_local = ~tmp.exists ? -1 : (tmp.mtime*1000d + tu_to_date(1970,1,1,0,0,0))
					IF ~tmp.exists THEN BEGIN
						size_new += taille2val(taillelinks[i])
						ndistant_new++
						PRINT, 'NEW_____ ' + ' REMOTE='+date_to_str(date)+'                               '+' '+modif_thunderbird(http+links[i])
						IF ~readonly THEN PRINTF, fd_new, local+links[i]
						IF ~readonly THEN FLUSH, fd_new
						IF ~readonly THEN PRINTF, fd_listing, SYSTIME(0)+ ' *** NEW       *** ' + local+links[i]
						IF ~readonly THEN FLUSH, fd_listing
						IF ~readonly THEN code = get_http_file (general, http+links[i], local, /thunderbird, silence=silence)
					END ELSE IF date GT date_local THEN BEGIN
						size_modified += taille2val(taillelinks[i])
						ndistant_modified++
						PRINT, 'MODIFIED ' + ' REMOTE='+date_to_str(date)+' LOCAL='+date_to_str(date_local)+' '+modif_thunderbird(http+links[i])
						IF ~readonly THEN PRINTF, fd_modified, local+links[i]
						IF ~readonly THEN FLUSH, fd_modified
						IF ~readonly THEN PRINTF, fd_listing, SYSTIME(0)+ ' *** MODIFIED  *** ' + local+links[i]
						IF ~readonly THEN FLUSH, fd_listing
						IF ~readonly THEN code = detruire(local+links[i])
						IF ~readonly THEN code = get_http_file (general, http+links[i], local, /thunderbird, silence=silence)
					END ELSE BEGIN
						size_ok += taille2val(taillelinks[i])
						ndistant_ok++
						IF readonly THEN PRINT, 'OK______ ' + ' SIZE='+val_to_str(taille2val(taillelinks[i]))+' REMOTE='+date_to_str(date)+' LOCAL='+date_to_str(date_local)+' '+modif_thunderbird(http+links[i])
						IF ~readonly THEN PRINTF, fd_listing, SYSTIME(0)+ ' *** OK        *** ' + local+links[i]
						IF ~readonly THEN FLUSH, fd_listing
					END

				END
			END

			; Puis les rpertoires
			FOR i=0L, N_ELEMENTS(links)-1 DO BEGIN
				IF ~isdir[i] THEN CONTINUE
				IF nodir THEN CONTINUE
				IF links[i] EQ '../' THEN CONTINUE ; trouv sur JUNO
				get_listing_distant_recursif, httpdir, http+links[i], local+links[i], ndistant, ndistant_new, ndistant_modified, ndistant_ok, ndistant_total, size_new, size_modified, size_ok, size_total, fd_listing, fd_new, fd_modified, fd_useless, readonly, slow, silence, nodir, accept=accept, reject=reject
			END

		END
		IF ~silence THEN PRINT, modif_thunderbird(http1)+' '+val_to_str(ndistant)+' files'

		; Recherche fichiers ou rpertoires en trop
		premier = 1
		FOR i=0L,N_ELEMENTS(linkslocal)-1 DO BEGIN

			IF linkslocal[i] EQ '' THEN CONTINUE

			ind = WHERE (links EQ linkslocal[i])
			IF ind[0] EQ -1 THEN BEGIN
				IF ~silence AND premier THEN PRINT
				IF ~silence THEN PRINT, '*** USELESS   *** ' + local + linkslocal[i]
				IF ~readonly THEN PRINTF, fd_useless, local+linkslocal[i]
				IF ~readonly THEN FLUSH, fd_useless
				premier = 0
			END
		END
		IF ~silence AND ~premier THEN PRINT

	END

END


;-------------------------------------------------------------------------------
FUNCTION afficher,	$
;-------------------------------------------------------------------------------
	tab,	$	; LINT_PROTOTYPE input
	i		; LINT_PROTOTYPE input
;-------------------------------------------------------------------------------
; Affiche tab[i] sur un nombre de caractres qui est la longueur de la chaine la plus longue de tab.
;-------------------------------------------------------------------------------

	s = tab[i]
	nblancs = MAX(STRLEN(tab))-STRLEN(s)
	FOR k=0L,nblancs-1 DO s = ' '+s

	RETURN, s

END


;-------------------------------------------------------------------------------
PRO get_listing_distant,	$
;-------------------------------------------------------------------------------
	httpdir,		$	; LINT_PROTOTYPE input
	localdir,		$	; LINT_PROTOTYPE input
	readonly,		$	; LINT_PROTOTYPE input
	slow,			$	; LINT_PROTOTYPE input
	silence,		$	; LINT_PROTOTYPE input
	nodir,			$	; LINT_PROTOTYPE input
	accept=accept,		$	; LINT_PROTOTYPE input
	reject=reject			; LINT_PROTOTYPE input
;-------------------------------------------------------------------------------
; Appelle get_listing_distant_recursif puis affiche des infos sur les fichiers rcuprs.
;
;	Entres:
;			httpdir:	rpertoire http  lister (ex: "http://fiji.sr.unh.edu/1dmax_ascii/")
;			localdir:	rpertoire local ou doit tre dupliqu httpdir
;
;	La procdure cre les sous-rpertoires dans localdir (cre puis dtruit .remote-index.html dans chaque rpertoire)
;-------------------------------------------------------------------------------

	ndistant = 0L
	ndistant_new = LONG64(0)
	ndistant_modified = LONG64(0)
	ndistant_ok = LONG64(0)
	ndistant_total = LONG64(0)
	size_new = LONG64(0)
	size_modified = LONG64(0)
	size_ok = LONG64(0)
	size_total = LONG64(0)
	IF ~readonly THEN OPENW, fd_listing, localdir+'/'+'wget_listing', /GET_LUN
	IF ~readonly THEN OPENW, fd_new, localdir+'/'+'wget_new', /GET_LUN
	IF ~readonly THEN OPENW, fd_modified, localdir+'/'+'wget_modified', /GET_LUN
	IF ~readonly THEN OPENW, fd_useless, localdir+'/'+'wget_useless', /GET_LUN

	IF silence THEN PRINT,' begin wget ' + httpdir
	get_listing_distant_recursif, httpdir, httpdir, localdir, ndistant, ndistant_new, ndistant_modified, ndistant_ok, ndistant_total, size_new, size_modified, size_ok, size_total, fd_listing, fd_new, fd_modified, fd_useless, readonly, slow, silence, nodir, accept=accept, reject=reject
	IF silence THEN PRINT,' end   wget ' + httpdir

	IF ~readonly THEN FREE_LUN, fd_listing
	IF ~readonly THEN FREE_LUN, fd_new
	IF ~readonly THEN FREE_LUN, fd_modified
	IF ~readonly THEN FREE_LUN, fd_useless

	na = ndistant_new
	nb = ndistant_modified
	nc = ndistant_ok
	nd = ndistant_total

	va = size_new
	vb = size_modified
	vc = size_ok
	vd = size_total

	c3 = 1024.0*1024.0
	c4 = c3*1024.0
	c5 = c4*1024.0

	t1 = [	val_to_str(na),			val_to_str(nb),			val_to_str(nc),				val_to_str(nd)			]
	t2 = [	val_to_str(va),			val_to_str(vb),			val_to_str(vc),				val_to_str(vd)			]
	t3 = [	val_to_str_2decimales(va/c3),	val_to_str_2decimales(vb/c3),	val_to_str_2decimales(vc/c3),		val_to_str_2decimales(vd/c3)	]
	t4 = [	val_to_str_2decimales(va/c4),	val_to_str_2decimales(vb/c4),	val_to_str_2decimales(vc/c4),		val_to_str_2decimales(vd/c4)	]
	t5 = [	val_to_str_2decimales(va/c5),	val_to_str_2decimales(vb/c5),	val_to_str_2decimales(vc/c5),		val_to_str_2decimales(vd/c5)	]
		
	IF ~silence THEN PRINT
	IF ~silence THEN PRINT, 'NEW       ' + afficher(t1,0) +' files  '+ afficher(t2,0) +' bytes  '+afficher(t3,0)+' Mbytes  '+afficher(t4,0)+' Gbytes  '+afficher(t5,0)+' Tbytes'
	IF ~silence THEN PRINT, 'MODIFIED  ' + afficher(t1,1) +' files  '+ afficher(t2,1) +' bytes  '+afficher(t3,1)+' Mbytes  '+afficher(t4,1)+' Gbytes  '+afficher(t5,1)+' Tbytes'
	IF ~silence THEN PRINT, 'OK        ' + afficher(t1,2) +' files  '+ afficher(t2,2) +' bytes  '+afficher(t3,2)+' Mbytes  '+afficher(t4,2)+' Gbytes  '+afficher(t5,2)+' Tbytes'
	IF ~silence THEN PRINT, 'TOTAL     ' + afficher(t1,3) +' files  '+ afficher(t2,3) +' bytes  '+afficher(t3,3)+' Mbytes  '+afficher(t4,3)+' Gbytes  '+afficher(t5,3)+' Tbytes'

END


;-------------------------------------------------------------------------------
PRO wget,	$
;-------------------------------------------------------------------------------
	http_dir,		$	; LINT_PROTOTYPE input
	local_dir,		$	; LINT_PROTOTYPE input
	login,			$	; LINT_PROTOTYPE input
	password,		$	; LINT_PROTOTYPE input
	readonly=readonly,	$	; LINT_PROTOTYPE input
	slow=slow,		$	; LINT_PROTOTYPE input
	nodir=nodir			; LINT_PROTOTYPE input
;-------------------------------------------------------------------------------
; Rcupre rcursivement le rpertoire http_dir dans local_dir
;
; login et password sont utiles si le rpertoire est protg par .htaccess
; /readonly:	pour ne pas physiquement recopier quoi que ce soit en local
; /slow:	pour ne pas utiliser les dates/tailles des fichiers retourns lors de l'interrogation du contenu d'un rpertoire
; /nodir:	pour ne pas traverser rcursivement les rpertoires
;-------------------------------------------------------------------------------
	COMMON COMMON_CL, general

	IF N_ELEMENTS(readonly) EQ 0 THEN readonly = 0
	IF N_ELEMENTS(slow)     EQ 0 THEN slow = 0
	IF N_ELEMENTS(nodir)    EQ 0 THEN nodir = 0 ; /nodir pour ne pas traverser les rpertoires recursivement

	silence = 1

	pos = STRPOS(http_dir,'accept=')
	IF pos NE -1 THEN BEGIN
		accept = STRMID (http_dir,pos+7)
		http_dir = STRMID (http_dir,0,pos)
	END ELSE BEGIN
		pos = STRPOS(http_dir,'reject=')
		IF pos NE -1 THEN BEGIN
			reject = STRMID (http_dir,pos+7)
			http_dir = STRMID (http_dir,0,pos)
		END
	END

	IF STRMID(http_dir,0,7) NE 'http://' OR STRMID(http_dir,STRLEN(http_dir)-1,1) NE '/' THEN BEGIN
		PRINT,"http_dir must be in the form http://.../"
		EXIT
	END

	IF STRMID(local_dir,STRLEN(local_dir)-1,1) NE '/' THEN BEGIN
		PRINT,"local_dir ("+local_dir+") must be ended by /"
		EXIT
	END

	IF login NE '' AND password NE '' THEN BEGIN
		http_authorization = ''
		login_password = login+':'+password
		tmp = REPLICATE (0b,1024)
		IF is_fdl() THEN BEGIN
			lint_unused = CALL_EXTERNAL (libname('util'), 'CODER_LOGIN_PASSWORD_AUTO_GLUE', login_password,tmp, /AUTO_GLUE)
		END ELSE BEGIN
			lint_unused = CALL_EXTERNAL (libname('util'), 'CODER_LOGIN_PASSWORD', login_password,tmp)
		END
		FOR i=0L,N_ELEMENTS(tmp)-1 DO BEGIN
			IF tmp[i] EQ 0 THEN BREAK
			http_authorization += STRING(tmp[i])
		END
		set, general, 'http_authorization', http_authorization
	END

	set, general, 'http_cancel', 0
	get_listing_distant, http_dir, local_dir, readonly, slow, silence, nodir, accept=accept, reject=reject

END
