;-------------------------------------------------------------------------------
;
;	Fichier	: $RCSfile: tree__define.pro,v $, v $Revision: 1.5 $
;
;	Date	: $Date: 2014/03/12 17:14:18 $
;
;	Auteur	: $Author: penou $
;
;	Version : %Z% version %I% de %M% du %G%
;
;-------------------------------------------------------------------------------


;-------------------------------------------------------------------------------
PRO tree::construire_nochamp,	$
;-------------------------------------------------------------------------------
	nom,	$	; LINT_PROTOTYPE input
	val		; LINT_PROTOTYPE input
;-------------------------------------------------------------------------------
; Remise en forme de la variable "nochamp" avec "Panel x: type x y z"
;-------------------------------------------------------------------------------


	old_val_nochamp     = nom EQ 'val_nochamp'         ? val : get (self, 'val_nochamp')
	data_size_nochamp   = nom EQ 'data_size_nochamp'   ? val : get (self, 'data_size_nochamp')
	x_size_nochamp      = nom EQ 'x_size_nochamp'      ? val : get (self, 'x_size_nochamp')
	x_charsize_nochamp  = nom EQ 'x_charsize_nochamp'  ? val : get (self, 'x_charsize_nochamp')

	IF N_ELEMENTS(data_size_nochamp) EQ N_ELEMENTS(x_size_nochamp) AND $
	   N_ELEMENTS(data_size_nochamp) EQ N_ELEMENTS(x_charsize_nochamp) AND old_val_nochamp[4] NE 'No Panel' THEN BEGIN

		no = (WHERE (old_val_nochamp[4:*] EQ get (self,'nochamp')))[0]
		IF no EQ -1 THEN no = 0

		nbfils = N_ELEMENTS(data_size_nochamp)
		val_nochamp = REPLICATE ('', nbfils)
		FOR i=0L,nbfils-1 DO BEGIN
			old = STRSPLIT (old_val_nochamp[4+i], /EXTRACT)
			val_nochamp[i] = 'Panel ' + 										$
						STRING (i+1,					FORMAT='(I3)')  + ': ' + 	$
						STRING (old[2], 				FORMAT='(A15)') + '  ' + 	$
						STRING (val_to_str(data_size_nochamp[i]), 	FORMAT='(A9)')  + '  ' + 	$
						STRING (val_to_str(x_size_nochamp[i]), 		FORMAT='(A9)')  + '  ' + 	$
						STRING (val_to_str(x_charsize_nochamp[i]), 	FORMAT='(A9)')
		END

		nochamp = val_nochamp[no]
		self -> obj::setproperty, 'nochamp', nochamp

		val_nochamp = ['L1','2','15','LABEL_LEFT',val_nochamp]
		set, self, 'val_nochamp', val_nochamp
		self -> obj::setproperty , 'nochamp', val_nochamp, /info
		
	END

END

;-------------------------------------------------------------------------------
PRO tree::setproperty,	$
;-------------------------------------------------------------------------------
	nom,			$	; LINT_PROTOTYPE input
	val,			$	; LINT_PROTOTYPE input
	passaveold=passaveold		; LINT_PROTOTYPE input
;-------------------------------------------------------------------------------
; Permet de modifier la valeur d'une variable.
;-------------------------------------------------------------------------------

	IF nom EQ 'data_size_nochamp' OR nom EQ 'x_size_nochamp' OR nom EQ 'x_charsize_nochamp' THEN BEGIN

		self -> construire_nochamp, nom, val

	END

	self -> obj::setproperty, nom, val, passaveold=passaveold

END


;-------------------------------------------------------------------------------
FUNCTION tree::init,	$
;-------------------------------------------------------------------------------
	general	; LINT_PROTOTYPE input
;-------------------------------------------------------------------------------
; Constructeur de la classe "tree".
;-------------------------------------------------------------------------------

	param = [ $
		{ var_obj, '',							'val_nochamp', 		0, PTR_NEW(), 			'check_always_ok', 	PTR_NEW(),	PTR_NEW('')	},	$
		{ var_obj, 'Add panel:Start (DD MM YYYY [HH [MM [SS[.MSC]]]])',	'time_t1', 		1, PTR_NEW(['TE','2','23']), 	'check_strdate', 	PTR_NEW(),	PTR_NEW('')	},	$
		{ var_obj, 'End   (DD MM YYYY [HH [MM [SS[.MSC]]]])',		'time_t2', 		1, PTR_NEW(['TE','2','23']), 	'check_strdate', 	PTR_NEW(),	PTR_NEW('')	},	$
		{ var_obj, '', 							'arbre', 		1, PTR_NEW(), 			'check_always_ok',	PTR_NEW(),	PTR_NEW('')	},	$
		{ var_obj, '', 							'ou', 			1, PTR_NEW(), 			'check_always_ok', 	PTR_NEW(),	PTR_NEW('')	},	$
		{ var_obj, 'Resize panel:Space between panel', 			'space_size', 		2, PTR_NEW(['FL','2','12']),	'check_always_ok', 	PTR_NEW([0]),	PTR_NEW('')	},	$
		{ var_obj, 'Property', 						'nochamp', 		2, PTR_NEW(), 			'check_always_ok', 	PTR_NEW(),	PTR_NEW('')	},	$
		{ var_obj, 'Data_size', 					'data_size_nochamp',	2, PTR_NEW(['FL','0','12']), 	'check_supegal', 	PTR_NEW([0]),	PTR_NEW('')	},	$
		{ var_obj, 'X_size', 						'x_size_nochamp', 	2, PTR_NEW(['FL','0','12']), 	'check_supegal', 	PTR_NEW(0),	PTR_NEW('')	},	$ 
		{ var_obj, 'X_charsize', 					'x_charsize_nochamp', 	2, PTR_NEW(['FL','2','12']), 	'check_supegal', 	PTR_NEW(0),	PTR_NEW('')	},	$
		{ var_obj, 'Move panel:Move', 					'ou1', 			3, PTR_NEW(), 			'check_always_ok', 	PTR_NEW(),	PTR_NEW('')	},	$
		{ var_obj, 'To', 						'ou2', 			3, PTR_NEW(), 			'check_always_ok', 	PTR_NEW(),	PTR_NEW('')	},	$
		{ var_obj, 'Remove panel:Remove', 				'remove', 		4, PTR_NEW(), 			'check_always_ok', 	PTR_NEW(),	PTR_NEW('')	}	$
	]

        code = self -> obj::init (1, -1, -1, param, general=general,/saisissable)
        RETURN, code

END


;-------------------------------------------------------------------------------
PRO tree__define
;-------------------------------------------------------------------------------
; La classe "tree" hrite de obj.
;-------------------------------------------------------------------------------

	lint_unused = { tree, 	$

		INHERITS obj 	$

	}

END
